---
title: Les ondes
published: true
routable: true
visible: false
lessons:
    -
      slug: energy-mix-hydroelectricity-2
      name: TD4-exo23 : Hydroélectricité
      order: 3
    -
      slug: TD4-hydroelectricity-energy-efficiency-values
      name: DÉFINITIONS-2 : TD4 et grandeurs d'efficacité énergétique
      order: 3
    -
      slug: TD4-hydroelectricity-fr_legislative-economic-aspects
      name: DÉFINITIONS-2 : TD4, aspects législatifs et économiques
      order: 2
---

<!--Commandes Latex spécifiques
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
-->

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-5_L1200.jpg)<details>
<summary>Etape 5 : Ecriture : 3/3</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Mix-énergétique : TD 4

---------------------------


# <p style="font-size:70%;text-align: center;">Les Centrales<br> au fil de l'eau</p>

_Exercice basé sur 5 écluses du canal du Rhône au Rhin déclassé équipées chacune 
depuis 2014 avec une micro-centrale hydroélectrique à vis d'Archimède, et dérivé 
d'un TD donné au Lycée Lavoisier de Mulhouse._

Un *exemple technique de micro-centrale* au fil de l'eau est la **turbine à vis d'archimède**.

![](energy-mix-TD4-hydroelectricity-micro-power-station-1_L1200.jpg)   
_turbine à vis d'archimède travaillant en générateur de courant électrique._


* La turbine à vis d'Archimède est un *type de turbine à action*, bien *adaptée aux basses chutes à débit variable*. 

* La turbine à vis d'Archimède **peut être conçue pour fonctionner en mode STEP**.  
  <br>
  La *turbine* est alors couplée à une installation électrique pouvant fonctionner 
   * soit en *mode alternateur*
   * soit en *mode moteur électrique*. 


![](energy-mix-TD4-hydroelectricity-micro-power-station-2_L1200.jpg)   
_turbine à vis d'archimède travaillant en mode stockage d'énergie potentielle gravitationnelle._

   * Lorsque l'**eau entraîne la rotation de la turbine** par sa chute, l'installation électrique 
   fonctionne en *mode générateur* délivrant ainsi de la puissance électrique.   
   
   * Lorsque la **rotation de la turbine est entraînée en sens inverse** par l'installation 
   électrique fonctionnant en *mode moteur*, l'eau piégée entre les pales est entraînée 
   depuis le bassin bas vers le bassin haut, et elle gagne ainsi en énergie potentielle.

##### Données de l'exercice :

* **Variation mensuelle** *du débit $`\mathbf{Q}`$* (exemple du )canal Rhône au Rhin déclassé) :

---

| &nbsp;&nbsp;&nbsp;&nbsp;**Mois**&nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;janvier&nbsp;&nbsp; | &nbsp;&nbsp;février &nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;&nbsp; mars&nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp;&nbsp;avril &nbsp;&nbsp;&nbsp;&nbsp;|
| :---: | :---: | :---: | :---: | :---: |
| *débit<br> ($`m^3\,s^{-1}`$)* | 6,1 | 5,8 | 4,8 | 3,2 |

   ---
   
 | &nbsp;&nbsp;&nbsp;&nbsp;**Mois**&nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp;&nbsp;mai&nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp;&nbsp;juin &nbsp;&nbsp;&nbsp;&nbsp;| &nbsp;&nbsp;&nbsp;&nbsp; juillet &nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp;&nbsp;août &nbsp;&nbsp;&nbsp;&nbsp;|
| :---: | :---: | :---: | :---: | :---: |
| *débit<br> ($`m^3\,s^{-1}`$)* | 2,1 | 1,3 | 0,9 | 0,7 |

   ---
   
| &nbsp;&nbsp;&nbsp;&nbsp;**Mois**&nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;septembre| &nbsp;octobre| &nbsp;novembre| &nbsp;décembre|
| :---: | :---: | :---: | :---: | :---: |
| *débit<br> ($`m^3\,s^{-1}`$)* | 0,8 | 1,3 | 1,9 | 4,7 |

---
<br>

* **Hauteur** de l'écluse : *$`\mathbf{H = 2,2\;m}`$*
* **Puissance crête** de l'installation électrique : *$`\mathbf{P_c = 90}`$ kW*.
* **Rendement total** de conversion d'énergie mécanique en énergie électrique : *$`\boldsymbol{\mathbf{\eta_{\,conv} = 0,67}}`$*
* **Accélération de la pesanteur** : *$`\mathbf{g \simeq 10\;ms^{-2}}`$*
* **Densité massique de l'eau** : *$`\boldsymbol{\mathbf{\varrho = 1000\;kg.m^{-3}}}`$* 
* Le **coût d'installation** de la micro-centrale est de *$`\mathbf{350\;k}`$€* (&ast;). 
* Le **coût moyen de maintenance annuel** est de *$`\mathbf{20\;k}`$€* (&ast;).
* Le **prix de vente du kWh** électrique est de *$`\mathbf{0,22}`$€*.
* La **maintenance** arrête de la centrale *vingt jours par an*.
* Ces **installations** sont souvent installées en *zone rurale*, donc *pavillonnaire*. 
* 
   _(* : donnée estimée pour l'exercice (sans référence réelle)_

En France, la **consommation électrique moyenne d'un foyer** composé de 4 personnes vivant 
dans une maison de 120 m² et utilisant uniquement de l’électricité est de *$`\mathbf{20 000}`$ kWh* d’électricité.
                                                               

## <p style="font-size:60%;text-align: center;">FONCTION dans le SYSTEME ENERGETIQUE</p>

##### 1. **Capacité de stockage / déstockage** ou *générateur continu* d'énergie<br><br>a)  A laquelle de ces deux classes appartiennent ces centrales de lac?

<details markdown=1><summary>Solution</summary>

* Une **petite centrale hydraulique au fil de l'eau** n'est en général pas précédée d'une retenue d'eau.
Installée dans un lieu de faible dénivelé, une telle retenue d'eau n'aurait pas vraiment de sens 
en terme de capacité de stockage d'énergie sous forme gravitationnelle ; sa présence résulterait 
plutôt d'une volonté de préserver des habitats en cas de crue, ou de faire des réserves d'eau pour 
l'irrigation en période de sécheresse. Ainsi une petite centrale n'a 
*pas de fonction de stockage /déstockage d'énergie*.

* Par contre, la turbine d'une petite centrale au fil de l'eau est **alimenté en continue par le débit d'un cours d'eau**,
subissant *certes des variations mensuelles*, mais relativement *stable sur la semaine*.

* Elle jour plus le **rôle d'un générateur continu** d'électricité dans la chaine industrielle énergétique.

</details>


##### b)  Calculer la puissance électrique produite moyennée sur une année de fonctionnement

<details markdown=1><summary>Solution</summary>

* Le *débit annuelle moyen annuelle* est, en négligeant la légère variation de durée des  
      différents mois :  
<br> 
*$`\boldsymbol{\mathbf{Q_{moy}(1\,an)}}`$* 

$`\hspace{1,4cm}=\dfrac{6,1+5,8+4,8+3,2+2,1+1,3}{12}`$
$`\hspace{1,4cm}\quad + \dfrac{0,9+0,7+0,8+1,3+1,9+4,7}{12}`$

*$`\hspace{1,4cm}=\dfrac{33,6}{12}\mathbf{=2,8\,m^3s^{-1}}`$*

<br>

* La **puissance électrique moyenne annuelle** est :   
<br>
**$`\boldsymbol{\mathbf{P_{moy}^{1\,an}=\eta_{tot}\times
\big(
\varrho_{eau}\times Q_{moy}^{1\,an}\times H\times g\big)}}`$**

$`\hspace{1,6cm} = 0,67 \times 10^3 \times 2,8 \times 2,2 \times 10`$

**$`\hspace{1,6cm}\mathbf{=41,3\times 10^3\;J\,s^{-1}}`$**

</details>

<br>

---

##### 2. **Production annuelle d'énergie** et *nombre de foyers alimentés* en électricité,<br><br>a)  Estimer l'énergie électrique produite annuellement par cette centrale

<details markdown=1><summary>Solution</summary>

* *Facteur de conversion* énergétique depuis le *Joule vers le kWh*   
<br>
*$`\boldsymbol{\mathbf{\mathcal{F}_{J\rightarrow kWh}=\dfrac{1\,kWh}{3,6\times 10^6\,J}}}`$*

*$`\hspace{1,6cm}=\dfrac{1}{3,6\times 10^6}\;kWh.J^{-1}`$

*$`\hspace{1,6cm}\mathbf{\simeq 2,8\times 10^{-7}\;kWh.J^{-1}}`$*

<br>

* Rappel : L'installation électrique a une puissance crête de *$`\mathbf{P_c = 90}`$ kW*.
 
<br>

* **Energie électrique produite annuellement**   
<br>
**$`\mathbf{E_{\,1\,an}^{\,elec}=
P_{moy}^{\,1\,an}\times
\underbrace{365,25\times 24\times 3600}_{nombre\;de \;sec.\;par\;an}}`$**


$`\hspace{1,6cm}=(4,1\times 10^4)\times (3,1 \times 10^7)\;J.an^{-1}`$

*$`\mathbf{\hspace{1,6cm}= 12,7\times 10^{11} \,J.an^{-1}}`$*

$`\hspace{1,6cm} = 12,7\times 10^{11}\,J.an^{-1}\times\mathcal{F}_{J\rightarrow kWh}`$

$`\hspace{1,6cm}\begin{align}= (12,7\times &10^{11}\;J.an^{-1})\\
&\;\times (2,8\times 10^{-7}\;kWh.J^{-1})\end{align}`$

**$`\mathbf{\hspace{1,6cm}\simeq 3,6\times 10^{5}\;kWh.an^{-1}}`$**

</details>

##### b)  Estimer le nombre de foyers alimentés par cette centrale

<details markdown=1><summary>Solution</summary>

* **Ce type de petite centrale** a une *origine* (décision, financement) et 
un *impact* (énergétique, écologique) *locaux*, desservant avec en général 
un **habitat pavillonnaire**, aussi est-il plus 
**judicieux d'estimer le nombre de foyers** qu'elle peut ainsi alimenter que le nombre d'habitants. 

<br>

* Rappel : La *consommation électrique moyenne d'un foyer* en maison individuelle (4 personnes, 120 m<sup>2</sup> 
de surface habitable) alimentée exclusivement en énergie électrique est de  :
*$`\mathbf{E_{\,1\,an\,1\,foyer}^{\,elec}\simeq 20\times 10^3\;kWh.foy^{-1}.an^{-1}}`$*.

<!---supression de -----------
* **En France**, la **consommation moyenne d’électricité par mois et par foyer** est 
de l’ordre de *$`\mathbf{390 kWh}`$*, soit *$`\mathbf{4 679}`$ kWh par an*   
_(source : particuliers.engie.fr)_.
<br>
**$`\mathbf{E_{\,1\,an\,1\,hab}^{\,elec}\simeq4,6\times 10^3\;kWh.foy^{-1}.an^{-1}}`$**   
----->

<br>
* **$`\mathbf{\text{nombre}_{\;foyers}\simeq\dfrac{36\times 10^4}{2,0\times 10^4}\simeq 18\;\text{foyers}}`$**

</details>

<br>

------

##### 3. **Facteur de charge** et *type d'utilisation*<br><br>a) Calculer le facteur de charge de cette centrale

<details markdown=1><summary>Solution</summary>

<br>

* **$`\mathbf{F_{charge}=\dfrac{P_{moy}(\Delta t)}{P_c}=\dfrac{1}{P_c}\cdot\dfrac{E_{\Delta t}}{\Delta t}}`$**

<br>
$`\hspace{1,6cm}=\dfrac{1}{P_c\;(W)}\cdot\dfrac{E_{\,1\,an}^{\,elec}\;(W.h)}{\underbrace{365,25\times 24\;(h)}_{\text{nombre d'heures par an}}}`$

$`\hspace{1,6cm}=\dfrac{1}{90\;(kW)}\cdot\dfrac{3,6\times 10^5\;(kW.h)}{8766\;(h)}`$

**$`\hspace{1,6cm}\mathbf{=0,45}`$**

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Le facteur de charge *exprimé en %* s'écrit :

*$`\hspace{1,1cm}\mathbf{F_{charge}=45\;\%}`$*

</details>

##### b) Quel sera son rôle dans le système d'approvisionnement en énergie ?

<details markdown=1><summary>Solution</summary>

* Ce **facteur de charge important** confirme que la fonction essentielle de cette petite centrale
  est celle d'un *générateur continu* d'électricité.

</details>

<br>

## <p style="font-size:60%;text-align: center;">EFFICACITÉ et ENJEUX ÉCOLOGIQUES</p>

Pas de question posée

<br>

## <p style="font-size:60%;text-align: center;">RÉSILIENCE CLIMATIQUE et GÉOPOLITIQUE</p>

Pas de question posée

<br>

## <p style="font-size:60%;text-align: center;">POTENTIEL de DÉVELOPPEMENT en FRANCE</p>

Pas de question posée

<br>

## <p style="font-size:60%;text-align: center;">EQUILIBRE ECONOMIQUE<br> et CADRE LEGISLATIF actuels</p>

* La **durée de vie** de l'installation est donnée pour *15 ans*, avec les *maintenances régulières*.

##### 4. **Equilibre économique**

<br>

--------

<details markdown=1>
<summary>Choix 1 : SOLUTION SIMPLISTE, pour SENSIBILISATION<br>&nbsp;</summary>

##### a)  Quel prix de vente du kWh électrique assure le point d'équilibre économique de cette micro-centrale ?

<details markdown=1><summary>Solution</summary>

* **Point d'équilibre** : *prix = coût de production*   
<br>
*$`\boldsymbol{\mathbf{\text{coût}_{\,elec}^{\,1\,an}}}`$*

$`\hspace{1,6cm}=\dfrac{35\times 10^4}{15}+2\times 10^4`$

*$`\hspace{1,6cm}\mathbf{\simeq 4,4\times 10^4}`$ €/an*

<br>

* **Coût par kWh produit**   
<br>
**$`\mathbf{\text{coût}_{\,kWh}}`$** $`=\dfrac{4,4\times 10^4}{35\times 10^4}`$

**$`\hspace{1,6cm}\mathbf{\simeq 0,13}`$ €/kWh**

</details>

<br>

##### b) Cette micro-centrale est-elle économiquement viable au prix de vente actuel ?<br><br> et si c'est le cas, en combien d'années l'investissement est-il remboursé?

<details markdown=1><summary>Solution</summary>

* Le prix de **22 centimes d'Euro pour $`\mathbf{1\;kW.h}`$** est une *estimation*.   
   * Ce n'est pas le prix de vente au particulier<br>
     _(qui diffère d'ailleurs selon la puissance installée et le fournisseur)_
   * Ce n'est pas le prix de revente à EDF. 

   C'est un prix auquel il faudrait rajouter le coût du raccordement au réseau. **Tout devrait s'étudier en détail**.

* La centrale est **économiquement viable**, 
  *sous l' hypothèse que le débit annuel moyen reste identique*
  à celui de l'année des relevés du tableau.

* Elle rapporte par année :   
  <br>
 **$`\mathbf{E_{\,1\,an}^{\,elec}}`$**$`\;\simeq (3,6\times 10^{5}\;kWh.an^{-1})\times(0,22 \;`$€$`.kWh^{-1})`$

**$`\hspace{2,1cm}\mathbf{\simeq 79\,000}\;`$€$`\mathbf{.an^{-1}}`$**

* Il faut tenir compte de la durée annuelle de maintenance où la centrale ne produit plus :   
  <br>
**$`\mathbf{E_{\,1\,an}^{\,elec}}`$**$`\;\simeq 79 000 \times \dfrac{365 - 20}{365}`$

$`\hspace{2,1cm}\simeq 79000\times 0,95`$

**$`\hspace{2,1cm}\mathbf{\simeq 75\,000}\;`$€$`\mathbf{.an^{-1}}`$**

* L'investissement sur 15 ans est de (à prix constant) :   
<br>
**$`\mathbf{Inv_{\;15\,ans}}`$**$`\; = (35\times 10^4)+(15 \times 2\times 10^4)`$

**$`\hspace{2,5cm}\mathbf{= 650\,000}\;`$€**

!!!! *ATTENTION :* On ne tient pas compte 
!!!! * d'une estimation de l'inflation à venir ... 
!!!! * des taux d'intérêts si l'investissement est financé.... 
!!!! * de l'évolution du prix de vente du kWh ...
!!!! * de l'évolution de la législation ...
!!!!
!!!! Cette *estimation* est *ultra simpliste*.

* Dans ce modèle ultra simpliste, l'investissement est remboursé en :   
<br>
**$`\mathbf{\dfrac{650\,000}{75000}\simeq 8,7\;}`$ans**

</details>
</details>

------------

<details markdown=1>
<summary>Choix 2 : SOLUTION PLUS RÉALISTE, pour ALLER PLUS LOIN<br>
Nécessite les informations de l'axe "TD4 : aspects législatifs et économiques</summary>


##### a)  Quel prix de vente du kWh électrique assure le point d'équilibre économique de cette micro-centrale ?

<details markdown=1><summary>Solution</summary>

* **Point d'équilibre** : *prix = coût de production*   
<br>
*$`\boldsymbol{\mathbf{\text{coût}_{\,elec}^{\,1\,an}}}`$*

$`\hspace{1,6cm}=\dfrac{35\times 10^4}{15}+2\times 10^4`$

*$`\hspace{1,6cm}\mathbf{\simeq 4,4\times 10^4}`$ €/an*

<br>

* **Coût par kWh produit**   
<br>
**$`\mathbf{\text{coût}_{\,kWh}}`$** $`=\dfrac{4,4\times 10^4}{35\times 10^4}`$

**$`\hspace{1,6cm}\mathbf{\simeq 0,13}`$ €/kWh**

</details>

<br>

##### b) Cette micro-centrale est-elle économiquement viable au prix de vente actuel ?<br><br> et si c'est le cas, en combien d'années l'investissement est-il remboursé?

<details markdown=1><summary>Solution</summary>

* **La *valeur de l'investissement initial* exprimée en euro est :     
<br>
**$`\mathbf{INP_0}\mathbf{=350\,k\text{€}}`$**


* Les recettes annuelles sont de :   
<br>
  **$`\mathbf{\texte{recettes}`$** $`/; = (3,4\times 10^5 \text{ kWh}) \times (0,22 \text{ €.kWh}^{-1})}`$  
 <br>
  **$`\mathbf{\hspace{1,7cm} = 75\,000\,}`$€**
 <br>
 Les dépenses annuelles sont de :   
<br>
**$`\mathbf{\texte{dépenses} = 20\,000\,}`$€**   
 <br>
Donc le flux net de trésorerie est de :   
 <br>
**$`\mathbf{FNT(0)}`$** = recettes - dépenses    
<br>
$`\hspace{1,7cm} = 75\,000 - 20\,000`$€**    
<br>
**$`\mathbf{\hspace{1,7cm}= 55\,000\,}`$€**

* Avec un taux d'actualisation estimé et choisi de :   
<br>
**$`\mathbf{act = 0,03}`$**   
<br>
Projetons cette valeur nette actualisée sur les 15 années de vie de la centrale.


|  n | FNT(n)} (k€) | FNTC(n)} (k€)| VAN(n) (k€)|
|:---:|:---:|:---:|:---:|
| 0 | 0  | 0 | -350 |
| 1 | 53,4  | 53,4 | -296,6 |
| 2 | 51,8  | 105,2 | -244,8 |
| 3 | 50,3  | 155,5 | -194,5 |
| 4 | 48,9  | 204,4 | - 145,6 |
| 5 | 47,4  | 251,8 | - 98,2 |
| 6 | 46,1  | 297,9 | - 52,1 |
| *7* | 44,7  | 342,6 | *- 7,4* |
| **8** | 43,4  | 386,0 | **+36** |
| 9 | 42,1  | 428,1 | +78,1 |
| 10 | 40,9  | 469,0 | +119,0 |
| 11 | 39,7  | 508,7 | +158,7 |
| 12 | 38,6  | 547,3 | +197,3 |
| 13 | 37,4  | 584,7 | + 234,7 |
| 14 | 36,3  | 621,0 | +271,0 |
| 15 | 35,3  | 656,3 | +306,3 |

</details>

----------







