---
title: Las ondas en física
published: true
routable: true
visible: false
lessons:
    - 
        slug: waves-conceptual-and-learning-patterns-es
        name: PANORAMA-234: Las ondas, una visión general
        order: 1
---

*Curso en construcción*, **no validado**.   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-ES_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-7_L1200.jpg)<details>
<summary>Etapa 7 : Probado con estudiantes</summary>  
1. Lluvia de ideas
2. Estructuración
3. Escribiendo : 1/3
4. Escribiendo : 2/3
5. Escribiendo : 3/3
6. Revisión 
7. Probado con estudiantes.
8. Validado, aún incompleto
9. Validado, con base suficiente
10. Validado, operativo, en constante mejora.
</details>


##### Caminata en colinas

---------------------------

### ONDAS

### **Las ondas** *en física*

<br>
[versión multilingüe : EN , FR , ES](https://m3p2.com/polyglot/temporary-m3p2/waves/n2/waves-introduction/waves-in-physics)
<br>

<!--
# <p style="font-size:70%;text-align: center;">Les ondes en physique</p>
<p style="font-size:75%;text-align: center;">Naissance du concept d'onde</p>
-->



#### Nacimiento de los conceptos de campo y onda

 * Cada uno de nosotros ha lanzado un balón o arrojado una piedra. En cada instante,
 estos objetos ocupan una posición bien definida en el espacio y siguen una trayectoria 
que nuestros ojos pueden seguir. Esta experiencia sensible es la base de nuestro 
concepto intuitivo de **cuerpos materiales**: objetos bien definidos, de extensión 
limitada en el espacio, que se desplazan según las leyes de la física.   
<br>
Pero nuestra experiencia sensible no se limita a estos objetos localizados.
Cada uno de nosotros ha **lanzado piedras al agua** o observado gotas de lluvia 
caer sobre la superficie tranquila de un estanque.   
<br>
Sus impactos perturban la superficie del agua, creando **pequeñas ondulaciones circulares** 
que *se propagan, se refuerzan o se debilitan* cuando se cruzan, y
*rodean los obstáculos* que encuentran en su camino.

* Estas ondulaciones se traducen, *en cada instante y en cada punto* de la superficie, en una
**variación de la altura del agua** bajo la superficie.   
<br>
El físico habla de **campo** para describir una
*magnitud física definida en cada punto del espacio y en cada instante*. Aquí la
magnitud física es la altura del agua, y el espacio es la superficie bidimensional
del estanque.

<br>

#### Propiedades y valores de un campo

* El físico asocia al concepto de **campo**:
  * una **magnitud física** que tiene *un valor definido en todo instante y en cada punto*
    del espacio donde está definido.
  * **propiedades** que *especifican cómo varía el campo* en el espacio y el tiempo,
    y *cómo se propagan las perturbaciones del campo*, se suman e interactúan con su entorno.

* Enumeremos las *principales propiedades* de un campo:

   * Un campo es **uniforme** si *su valor es el mismo en todo punto* del espacio en un instante
     dado o durante un período de tiempo especificado.   
     <br>
     _Por ejemplo, incluso en ausencia de pequeñas olas, la profundidad de un estanque varía de un punto a otro._
     _El campo de altura del agua bajo la superficie no es uniforme._
     _En cambio, en una piscina olímpica donde el agua tiene la misma profundidad en todas partes, el campo de_
     _altura del agua es uniforme en la superficie._

   * Un campo es **estacionario** si *sus valores*, que pueden variar en el espacio,
     *no varían con el tiempo*.   
     <br>
     _En un estanque tranquilo y sin viento, donde la superficie del agua está "en reposo", perfectamente inmóvil,_
     _el campo de altura del agua es estacionario._

   * Un campo es **homogéneo** si *sus propiedades de propagación* (la forma de la perturbación
     para un mismo impacto y su velocidad de propagación en una dirección dada)
     *son idénticas en todo punto* del espacio, incluso si los valores del campo varían espacialmente.   
     <br>
     _La velocidad de las pequeñas olas depende de la profundidad, ya que en aguas poco profundas, la fricción_
     _del agua con el fondo frena la propagación, mientras que en aguas profundas, las olas se_
     _desplazan más libremente y, por lo tanto, más rápidamente._   
     _Así, como la profundidad de un estanque es variable, el campo de altura del agua no es rigurosamente homogéneo._
     _En cambio, en una piscina olímpica de profundidad constante, sí es homogéneo._

   * Un campo es **isótropo** si, independientemente del punto de impacto, *la propagación de la perturbación* (su velocidad,
     su forma, su atenuación) *no depende de la dirección* considerada, incluso si, para un mismo impacto, la perturbación
     inducida varía de un punto a otro.   
     <br>
     _Si el impacto de las gotas de lluvia en un estanque forma siempre pequeñas olas que permanecen perfectamente circulares_
     _durante su propagación, es porque cada ola se propaga a la misma velocidad en todas las direcciones._
     _Si, además, a igual distancia del punto de impacto de la gota, la altura de una pequeña ola se mantiene constante, entonces_
     _el campo de altura del agua es isótropo._

   * Un campo es **lineal** si, para un impacto puntual e instantáneo,
     *la amplitud de la perturbación es proporcional a la energía del impacto*,
     y si *las amplitudes de las perturbaciones se suman simplemente*
     cuando las perturbaciones se superponen.   

<br>


#### Fenómenos propios de las ondas

* Las *ondulaciones* resultan del **desplazamiento** de moléculas de agua, es decir, 
 **de materia**.   
<br>
Cuando una onda caracteriza la *perturbación de un medio material*, el físico habla
de **onda mecánica**.   
<br>

* Las **propiedades de las ondas mecánicas**:
   *  *Propagación*
   *  *Interferencias*
   *  *Difracción* por un obstáculo.
   *  *Reflexión y transmisión* en la interfaz entre dos medios diferentes.
   *  *Transporte de energía*, pero *no de materia* a grandes distancias.

   **se encuentran también en fenómenos más sutiles** observados en la naturaleza 
   y luego descritos matemáticamente, o primero previstos por la teoría física antes 
   de ser confirmados por la experimentación.    
   <br>
   Así, se han podido identificar ondas no mecánicas.

<br>

![](waves-interferences-diffraction-2_L1200.jpg)
_Representación de los fenómenos de interferencia y difracción._

<br>

#### Ondas de diferentes tipos

* Hoy en día, **cuatro tipos de ondas** han sido observados, desde las *ondas mecánicas*
hasta las ondas *electromagnéticas*, luego las ondas *gravitacionales* y las ondas *cuánticas*.
En orden, estas ondas **corresponden a niveles de realidad cada vez más sutiles**,
relacionados con la velocidad de la luz c, y modelados por teorías físicas con
matemáticas cada vez más abstractas.

<br>

![](waves-introduction-n2-ES_L1200.jpg)
_Cuatro tipos de ondas en física, para describir niveles de realidad cada vez más sutiles y abstractos._

---------

##### **Las ondas mecánicas** *($`v \lt c`$)*

* Son las *más conocidas e intuitivas*, y a menudo son muy
*fáciles de observar* o sentir. Corresponden a una **perturbación de un campo material**:
   * *ondulaciones* en la superficie del agua (campo de altura).
   * *sonidos* que se propagan en el aire (campo de presión).
   * *ondas sísmicas* en el suelo (campo de desplazamiento en la tierra).
   * *ondulaciones* de un resorte o de una cuerda de un instrumento musical (campo de desplazamiento).

* Todas **estas ondas son materiales**, su velocidad de propagación $`\mathscr{v}`$ es inferior
a la velocidad de la luz $`c`$.

* Al requerir un medio material, *no pueden viajar en el vacío*.

![](https://m3p2.com/fr/temporary-m3p2/waves/images-sounds/wave-phenomena/Waves-reflexion-interferences-e_v2_L500.gif)
_Ondas generadas en la superficie del agua en un plato, durante un impacto en una pared._


<br>

--------

##### **Las ondas electromagnéticas** *($`v = c`$)*

* No resultan de la perturbación de un medio material, sino que *están formadas*
por un **campo eléctrico y** un **campo magnético perpendiculares que se auto-mantienen**.
<br>
Como no existe un medio de soporte para las ondas electromagnéticas, estas
**pueden viajar en el vacío**, entre otros, el vacío interestelar.

* Estas ondas incluyen:
   * las *ondas de radio*
   * las *microondas*
   * los *infrarrojos*
   * la *luz visible*
   * los *ultravioleta*
   * los *rayos X*
   * los *rayos gamma*

* **Nuestros ojos perciben solamente** una pequeña parte de este espectro, la *luz visible*.   
<br>
Como **estas ondas** son **energía pura** (no tienen masa en reposo), son
*mucho más abstractas*.   
<br>
En todo momento, **nuestro cuerpo es atravesado** por *ondas de radio*, *ondas de televisión*, *ondas WiFi* que
transportan música, imágenes, palabras de entrevistas, etc.
**Sin la tecnología**, no tendríamos *ningún conocimiento de la mayoría de estas ondas*.   
<br>

* La **velocidad de las ondas electromagnéticas** es
siempre *exactamente $`c = 299\,792\,458 m\,s^{-1}`$*, constante fundamental de la naturaleza llamada
*velocidad de la luz en el vacío*.   
<br>
Al no depender del estado de movimiento del observador que mide esta velocidad, estas ondas
**desafían nuestra intuición clásica** del mundo. Constituyen *una de las pruebas experimentales* del acoplamiento del espacio y del tiempo
dentro *del espacio-tiempo* descrito primero por la **relatividad especial, luego** por la relatividad **general**.   
<br>
![](https://m3p2.com/fr/temporary_ins/waves/n2/overview/linear-electromag-wave-n3_L1200.gif)
![](https://m3p2.com/fr/temporary_ins/waves/n2/overview/elliptic-wave-electromag-wave-n3_L1200.gif)
_Dos estados de polarización diferentes, lineal (arriba) y elíptica (abajo), de una onda electromagnética.
Sin necesidad de dominar el nivel Montaña, el conocimiento visual de estos estados de polarización te permitirá entender, entre otras cosas, cómo puedes ver en 3 dimensiones una película proyectada en las 2 dimensiones de una pantalla de cine._

! *Nota*:
!
! Las **ondas electromagnéticas**, hasta muy recientemente (2015), eran la *única fuente de todo nuestro conocimiento del Universo*:
!
! La astrofísica observa las ondas electromagnéticas provenientes del *Big Bang*, de las *galaxias*, de las *estrellas*, de los *planetas* y del *medio interestelar*.

---------------

##### **Las ondas gravitacionales** *($`v = c`$)*

* A diferencia de las ondas electromagnéticas, que viajan en el espacio y el tiempo, 
las **ondas gravitacionales** son *aún más abstractas*: son una **pertubación del campo del tejido 
del espacio-tiempo** mismo.   
<br>

* El **espacio-tiempo** se deforma por la presencia de materia (lo que causa la gravedad), pero además **puede vibrar** durante el *paso de ondas gravitacionales* producidas por eventos violentos en el universo.
<br>
Nuestros sentidos no pueden percibir estas ondas en absoluto.   
<br>

* Descritas por la relatividad general, **viajan** *a la velocidad de la luz $`c`$*.

! *Nota*:
!
! Predichas por la relatividad general, pero observadas solo desde 2015, las **ondas gravitacionales** son la **base de una nueva astrofísica**, la *astrofísica de ondas gravitacionales*.
! <br>
! Esta disciplina observa **fenómenos violentos y masivos** en el universo, como rotaciones rápidas antes de la *fusión de agujeros negros y estrellas de neutrones*.

---

##### **Las ondas cuánticas** *($`v \gt c`$ en ciertos casos)*

<br>

*A - Función de onda y medición*

* Las ondas cuánticas son **perturbaciones de un campo de probabilidad**,
descrito por la **función de onda $`\psi`$**. La evolución temporal de esta función está
gobernada por la *ecuación de Schrödinger*, o por ecuaciones más avanzadas en la *teoría cuántica de campos*
(que combina y supera la relatividad especial y la mecánica cuántica).

* **$`\boldsymbol{\psi}`$** no describe una onda clásica, sino una **amplitud de probabilidad**
de encontrar una partícula en un estado dado (posición, momento, espín, etc.).
La *probabilidad misma* es proporcional a *$`|\boldsymbol{\psi}|^2`$*.
En este sentido, la función cuántica **$`\boldsymbol{\psi}`$ describe la dualidad onda-partícula**.

* No es *material*, y una de sus particularidades es
*incluir una parte imaginaria* que desempeña un papel fundamental.

* Nadie comprende aún el significado real de esta onda.   
Está **limitada por la velocidad de la luz, excepto en el momento de una medición**
(colapso de la función de onda), que es un fenómeno no local, es decir, instantáneo (por lo tanto
con v > c).   
Este **comportamiento no local** es *fundamentalmente aleatorio* y, por lo tanto,
*no permite comunicarse* (de lo contrario, implicaría la existencia de paradojas temporales).

![](hydrogenoid-atom-quantum-mechanics-s-p-orbitales.gif)
_Representación de la probabilidad de presencia electrónica (azul) en los orbitales s (centro) y p (6 lóbulos)_
_de un átomo hidrogenoide, con el núcleo atómico en el centro y muy ampliado (rojo)._


*B - Función de onda y partículas entrelazadas*

* El **entrelazamiento cuántico** corresponde a un *nivel de realidad aún más abstracto*.   
<br>
El **vínculo cuántico entre dos partículas entrelazadas** (que interactuaron juntas en el pasado)
es una conexión absolutamente extraordinaria que *existe fuera del espacio y del tiempo*.   
<br>
Este vínculo:
   * es *indetectable* por cualquier tecnología conocida,
   * *no disminuye* con la distancia,
   * no es *detenido por obstáculos* de ningún tipo,
   * tiene un *comportamiento instantáneo*, por lo tanto, *no local*.

* **Fundamentalmente no local**, este vínculo es la *base de la teleportación cuántica*.   
<br>
Cuando el **estado de una partícula es teletransportado de un lugar A a un lugar B**, 
la *información se propaga instantáneamente* de A a B y no pasa por el espacio físico
entre A y B (por eso se dice que este vínculo existe fuera del espacio y del tiempo).   
<br>
La **comprensión conceptual de este fenómeno** es *una de las grandes preguntas abiertas* en la interpretación de la física cuántica y es objeto de grandes debates entre los físicos.

<br>

*C - Función de onda y predicciones*

* La **formulación matemática de la mecánica cuántica** está:
   * perfectamente *bien comprendida*,
   * perfectamente *bien verificada experimentalmente*.

   Es su interpretación conceptual la que es materia de controversia.

* La **acción instantánea del entrelazamiento cuántico** es *aleatoria* y *no permite comunicarse*.   
<br>
Sin embargo, la **teleportación cuántica permite comunicarse**, ya que incluye dos etapas:
   * una **primera etapa** *transportada por el entrelazamiento*,
   * una **segunda etapa** *limitada por la velocidad de la luz*.

   Por lo tanto, la **teleportación completa** está *limitada por la velocidad de la luz*.


!! *Para ir más allá*:
!!
!! El marco de la teoría cuántica de campos, que combina y supera la relatividad especial y la mecánica cuántica no relativista, ha tenido numerosos éxitos. Entre ellos, la predicción previa al descubrimiento de varias partículas, como el quark top (1995) y el bosón de Higgs (2011).
!!
!! Sin embargo, no explica los fenómenos previstos por la relatividad general (dilatación del tiempo en un campo gravitacional, agujeros negros y ondas gravitacionales, verificados experimentalmente u observados).
!!
!! Así, nuestra comprensión de todos los fenómenos observados en el Universo requiere dos teorías distintas: la relatividad general y la teoría cuántica de campos, que parecen inconciliables en sus fundamentos.
!!
!! Los físicos continúan buscando un principio único que dé lugar a una teoría física unificada, de la cual la relatividad general y la teoría cuántica de campos serían solo aproximaciones, y que describiría y predeciría estadísticamente todos los fenómenos en todas las escalas de la Naturaleza.