---
title: Collecte éléments de Logique
published: true
routable: true
visible: false
---

### Colecta de elementos / Collecte d'éléments / Collecting Elements

##### Nivel / niveau / level : 3 or 4

---------

### Lógica y teoría matemática / Logique et théorie mathématique / Logic and mathematical theory


!!!! *Recopilar elementos de cursos / Collecte d'éléments de cours / Collecting course items*
!!!! 
!!!! No publique, no haga visible.<br>
!!!! Ne pas publier, ne pas rendre visible.<br>
!!!! Do not publish, do not make visible.<br>


#### Informaciónes / Informations

------------------------------------------------------------------

 <details markdown=1>
 <summary>
 ¿Qué es un elemento del curso?<br>
 </summary>
* Este es un **componente básico** para crear un curso, que incluye :<br>
 * una o unas *frases estándar muy cortas*.
 * las *palabras clave* del vocabulario científico y técnico.
 * las *ecuaciones matemáticas*

* Se realiza **en los 3 idiomas [ES] [FR] [EN]** para:
 * Identificar el *vocabulario equivalente* en cada idioma.
 * Identificar *diferencias culturales*, especialmente en escritura matemática
 (ejemplo: $`\wedge`$ o $`\times`$)
 
* Su **rol** :
 * permitirá construir el *curso* eligiendo una *serie de elementos básicos*.
 * *redacción final libre* en cada idioma dentro de cada elemento central.
 * *se puede repetir en varios cursos*.

* **Ventajas** :
 * permite *cursos muy similares* en los 3 idiomas, que se pueden mostrar en paralelo.
 * *sin traducción palabra por palabra*.
 * permite mantener *ejemplos y expresiones lingüísticas específicas de cada cultura*.
</details>

 <details markdown=1>
 <summary>
 Qu'est-ce qu'un élement de cours? 
 </summary>
* C'est un **élément de base** pour construire un cours, comprenant :<br>
 * une ou quelques *phrases très courtes, standards*.
 * les *mots clés* du vocabulaire scientifique et technique.
 * les *équations mathématique*

* Il est **réalisé dans les 3 langues [ES] [FR] [EN]** pour :
 * Identifier le *vocabulaire équivalent* dans chaque langue.
 * Identifier les *différences culturelles*, notamment dans l'écriture mathématique<br>
 (exemple : $`\wedge`$ ou $`\times`$)
 
* Son **rôle** : 
 * permettra de construire le *cours* en choisissant une *suite d'éléments de base*.
 * *rédaction finale libre* dans chaque langue au sein de chaque élément de base.
 * *peut être repris dans plusieurs cours*.

* **Avantages** : 
 * permet des *cours très proches* dans les 3 langues, pouvant être affichés en parallèle.
 * *pas de traduction mot-à-mot*.
 * permet de garder *exemples et expressions linguistiques propres à chaque culture*.
</details>

 <details markdown=1>
 <summary>
 What is a course item?
 </summary>

 * This is a **basic block** to build a course, including: <br>
  * one or a few *very short, standard sentences*.
  * the *key words* of the scientific and technical vocabulary.
  * the *mathematical equations*

* It is **realized in the 3 languages [ES] [FR] [EN]** to:
  * Identify the *equivalent vocabulary* in each language.
  * Identify *cultural differences*, especially in mathematical writing <br>
  (example: $`\wedge`$ or $`\times`$)
 
* His **role** :
  * will allow the *course* to be built by choosing a *series of basic elements*.
  * *free final writing* in each language within each core element.
  * *can be repeated in several courses*.

* **Advantages** :
  * allows *very similar courses* in the 3 languages, which can be displayed in parallel.
  * *no word-for-word translation*.
  * allows to keep *examples and linguistic expressions specific to each culture*.
</details>

------------------

<details markdown=1>
<summary>
¿Cómo contribuir ?<br>
</summary>
* Directamente en el **GitLab M3P2 con su nombre de usuario / contraseña**, haciendo clic en Mejorar este curso
 al final de esta página.
* En el **documento de googledoc** : se especificará.<br>
</details>

<details markdown=1>
<summary>
Comment contribuer ?<br>
</summary>
* Directement sur le **GitLab M3P2 avec votre login / password**, en cliquant sur Améliorer ce cours
 à la fin de cette page.
* Sur le **document googledoc** : à préciser.<br>
</details>

<details markdown=1>
<summary>
How to contribute ? <br>
</summary>
* Directly on ** GitLab M3P2 with your login / password **, by clicking on "Improve this course"
  at the end of this page.
* On the **googledoc document**: to be specified. <br>
</details>

-----------------

<details markdown=1>
<summary>
Depositar un nuevo elemento de curso
</summary>

* **Estructura del elemento a reproducir :**<br>
<br>
Comience escribiendo el código numerado que especifica el tema, aquí :<br>
*Math-Logic-xxx* o *MATH-REAS-xxx*
 (dar un *número entero xxx no presente*, un número que sigue a los números presentes o un número intermedio según la lógica de la progresión educativa).<br>
 
 Por nivel n <br>
 (*indique el nivel n = 1, 2, 3 o 4* donde se encuentra su elemento del curso).<br>
 
 * (YYY): *3 iniciales* para identificarse.
 
 * *Comentario* (no obligatorio)
 
 *[ES] + el texto en su idioma*, o *su traducción automática si es posible* en las otras, especificando (auto-tra).
 
* *[LL] (YYY) + las ecuaciones* que usas.
</details>

<details markdown=1>
<summary>
Déposer un nouvel élément de cours
</summary>
* **Struture de l'élément** à reproduire :<br>
<br>
Commencer par écrire le code numéroté qui précise le thème, ici :<br>
*Math-Logic-xxx* o *MATH-REAS-xxx*   
 (donner un *nombre entier xxx non déjà présent*, un nombre à la suite des nombres présents ou un nombre intercalaire selon la logique de la progression pédagogique)<br>
 <br>
Pour le niveau n  <br>
 (*indiquer le niveau n=1, 2, 3 ou 4* ou se situe votre élément de cours)<br>
 <br>
 *(YYY) : 3 initiales* pour t'identifier. <br>
 <br>
*commentaire* (non obligatoire).<br>
 <br>
*[FR] + le texte dans votre langue* ; ou *sa traduction automatique si possible* dans les autres, en précisant (auto-tra). <br>
 <br>
* *[LL] (YYY) + les équations* que vous utilisez.<br>
</details>

<details markdown=1>
<summary>
Submit a new course item
</summary>
* **Structure of the item** to reproduce : <br>
<br>
Start by writing the numbered code that specifies the theme, here : <br>
*Math-Logic-xxx* o *MATH-REAS-xxx*   
  (give an *whole number xxx not already present*, a number following the numbers present or an intermediate number according to the logic of the educational progression) <br>
  <br>
  For level n  <br>
  (*indicate level n = 1, 2, 3 or 4* where your course item is located) <br>
  <br>
  *(YYY): 3 initials* to identify you. <br>
  <br>
*comment* (not required). <br>
  <br>
*[EN] + the text in your language*; or *its automatic translation if possible* in the others, specifying (auto-tra). <br>
  <br>
* *[LL] (YYY) + the equations* you use. <br>
</details>

----------------------

<details markdown=1>
  <summary>
 Mejorar, completar, corregir un elemento del curso existente
  </summary>
* Simplemente **dentro del elemento** del curso, escriba **su contribución comenzando con (YYY-LL)**, con: <br>
YYY sus 3 iniciales, y LL su idioma (ES, FR o EN).
<br>
Si solo corrige el texto de una traducción automática en su idioma nativo,
recuerde reemplazar (auto-tra) con sus iniciales (YYY).
</details>

<details markdown=1>
  <summary>
  Améliorer, compléter, corriger un élément de cours existant
  </summary>
 * Simplement **à l'intérieur de l'élément** de cours, écrire **votre contribution en commençant par (YYY-LL)**, avec :<br>
YYY vos 3 initiales, et LL votre langue (ES, FR ou EN).
<br>
Si vous corrigez simplement le texte d'une traduction automatique dans votre langue natale,
pensez à remplacer (auto-tra) par vos initiales (YYY).
</details>
  
<details markdown = 1>
   <summary>
   Improve, complete, correct an existing course item
   </summary>
  * Simply **inside the course item**, write **your contribution starting with (YYY-LL)**, with : <br>
YYY your 3 initials, and LL your language (ES, FR or EN).
<br>
If you just correct in your native language the text of an automatic translation, 
remember to replace (auto-tra) with your initials (YYY).
</details>

------------------------------------------------------------------

<!--
[ES] Esta es una oportunidad, si lo deseamos, para estandarizar nuestros notación y vocabulario,<br> 
http://www.electropedia.org/iev/iev.nsf/index?openform&part=102<br>
o para indicar en el texto la equivalencia con la norma internacional si
queremos mantener nuestras notaciones y vocabularios. Ejemplo :

[FR] C'est l'occasion, si nous le souhaitons, de normaliser notre notation et vocabulaire, <br>
http://www.electropedia.org/iev/iev.nsf/index?openform&part=102<br>
ou d'indiquer dans le texte l'équivalence avec la norme internationale si
on souhaite garder nos notations et vocabulaires. Exemple :

[EN] This is an opportunity, if we wish, to standardize our notation and vocabulary, <br>
http://www.electropedia.org/iev/iev.nsf/index?openform&part=102<br>
or to indicate in the text the equivalence with the international standard 
if we wish to keep our notations and terms. Example :

"élément scalaire de surface $`dA`$" au lieu de "surface élémentaire ou infinitésimale $`dS`$".

---

[ES] La oportunidad también de que un matemático verifique la conformidad de expresiones
matemáticas lógicas. Ejemplo :

[FR] L'occasion aussi de faire vérifier par un mathématicien la conformité des expressions
mathématiques logiques. Exemple :

[EN] The opportunity also to have a mathematician verify the conformity of logical
mathematical expressions. Example :

$`\Longrightarrow \quad\forall \overrightarrow{V}\in\mathcal{P}`$$`\quad\exists ! (\alpha,\beta)\in\mathbb{R}^2`$$`\quad
\overrightarrow{V}=\alpha\cdot\overrightarrow{a}+\beta\cdot\overrightarrow{b}`$

https://en.wikipedia.org/wiki/ISO_31-11

--------------------------------------------------------------------------------
-->


#### Inicio de colección / Début de la collecte / Start of collection 
------------------------------------------------------------------

*[Math-Logic-10]  Aserción / Assertion / ...*

[ES]    

[FR]     
La logique mathématique utilise des **assertions** qui peuvent être *vraies ou fausses*.    

[EN]  
_assertion is a genaral term, and statement = assertion that may be true or false ?_

[ES] (¡ auto-transl !)   
**aserción** = *afirmación, frase, oración, proposición*.      

[FR]    
**assertion** = *phrase, énoncé, proposition*.  

[EN] 
....

[ES] (¡ auto-transl !)   
La lógica matemática representa las **aserciones** mediante *letras mayúsculas*.    

[FR]   
En logique mathématiques, les **assertions** sont représentées par des *lettres majuscules*.   

[EN]   
...    

**valor de verdad** / **valeur de vérité** / ...

[ES]     
...

[FR]    
Une proposition $`P`$ peut prendre 2 valeurs de vérité possibles : vrai, ou faux.    

[EN] 
...

[ES]    
...

[FR]   
La valeur de vérité d'une proposition $`P`$ s'écrit $`v(P)`$.

[EN]   
...    

[ES]  (¡ auto-transl !)  
Notaciones :
* el valor **verdadero** está representado por la letra *V* o el número *1*.
* el valor **falso** está representado por la letra *F* o el número *0*.    

[FR]   
Notations :
* la valeur **vrai** se représente par la lettre *V* ou le nombre *1*.
* la valeur **faux** se représente par la lettre *F* ou le nombre *0*.

[EN]     
...    

-----------------------

*[Math-logic-15] Proposiciones indecidibles? Propositions indécidables?*

[ES] ¿Que decir?<br>
[FR] Que dire ?<br>
[EN] What to say?<br>

[ES] (¡ auto-transl !)  La paradoja del mentiroso que dice "En esta oración presente, estoy mintiendo.".<br>
[FR] Le paradoxe du menteur qui dit "Dans cette phrase présente, je mens.".<br>
[EN] 

------------------------

*[Math-Logic-20]  Lógica / logique / logic*

[ES] (¡ auto-transl !)   
Así como el álgebra estudia las propiedades de las operaciones y ecuaciones realizadas con sus combinaciones, sin preocuparse por los valores de los números involucrados, <br>
_ejemplo : el álgebra establece que $`a\times (b+c) = a\times b + a\times c`$_<br>
la **lógica** estudia las *propiedades de los operadores lógicos y equivalencias entre expresiones lógicas* realizadas con sus combinaciones, sin preocuparse por el significado de las aserciones involucradas.<br>
Los **operadores lógicos** son la *negación* ($`\neg`$), la *equivalencia* ($`\Longleftrightarrow`$), la *conjunción* ($`\land`$), la *disyunción* ($`\lor`$), la *implicación* ($`\Longrightarrow`$) y la *incompatibilidad* ($`|`$).<br>
_ejemplo : la lógica establece que  $`\neg(\,P \land Q\,)  \Longleftrightarrow  \neg P  \lor \neg Q`$._

[FR]   
De même que l'algèbre étudie les propriétés des opérations et des équations réalisées avec leurs combinaisons, sans se soucier des valeurs des nombres mis en jeu,<br>
_exemple : l'algèbre établit que $`a\times (b+c) = a\times b + a\times c`$_<br>
la **logique** étudie les *propriétés des opérateurs logiques et des équivalences entre expressions logiques* réalisées avec leurs combinaisons, sans se soucier du sens des assertions mises en jeu,<br>
Les **opérateurs logiques** sont la *négation* ($`\neg`$), l'*équivalence* ($`\Longleftrightarrow`$), la *conjonction* ($`\land`$),la *disjonction*($`\lor`$), l'*implication*  ($`\Longrightarrow`$) et l'*incompatibilité* ($`|`$).<br>
_ejemplo : la lógica establece que  $`\neg(\,P \land Q\,) \Longleftrightarrow \neg P  \lor \neg Q`$._

[EN] 
...    

-------------------------

*[Math-Logic-30]  axiomas y teoremas / axiomes et théorèmes / axioms and theorems*

[ES] (¡ auto-transl !)    
Un **axioma** es una *aserción* que se declara y se considera *verdadera, sin demonstración*. <br>
Un **teorema** es una *aserción* cuyo *valor verdadero se demuestra mediante un razonamiento lógico a partir de otras afirmaciones (axiomas o teoremas).

[FR]    
Un **axiome** est une *assertion* qui est posée et considérée comme *vraie, sans démonstration*.<br>
Un **théorème** est une *assertion* dont *la valeur vraie est démontrée* par un raisonnement logique à partir d'autres assertions (axiomes ou théorèmes).

[EN]  (auto-transl !) 
...

--------------------------

*[Math-Logic-40] théorie mathématique*

[ES] ? <br>
[FR] ? <br>
[EN] ?

--------------------------

*[Math_Logic-50]*    
[ES] (¡ auto-transl !)   <br>
[FR] *Théorie contradictoire ou cohérente* <br>
[EN] (¡ auto-transl !)

[ES] (¡ auto-transl !)  <br>
[FR] Une théorie est **contradictoire** si *une assertion est à la fois vraie et fausse* car dans ce cas *toutes les assertions sont à la fois vraies et fausses*.<br>
[EN] (auto-transl !)

[ES] (¡ auto-transl !)  <br>
[FR] Une théorie est **cohérente** si elle n'est *pas contradictoire*.<br>
[EN] (auto-transl !)

--------------------------------------

*[Math_Logic-60]*  Tabla de verdad / Table de vérité / Truth table

[ES] (¡ auto-transl !)
[FR] Donne la valeur de vérité d'une assertion composée<br>
[EN] (auto-transl !)

-------------------------------------------------------------------------------------------
#### Los operadores lógicos / Les opérateurs logiques / The logical operators 
-------------------------------------------------------------------------------------------

*[Math-Logic-70]  Négation*

[ES] (¡ auto-transl !)    

[FR] Soit $`P`$ une assertion.<br>
La **négation de $`P`$** est une nouvelle assertion qui s'écrit **$`\mathbf{\text{NON}(P)}`$** ou **$`\mathbf{\neg P}`$**, et dont la valeur est *définie par* :
* **$`\mathbf{\\neg P}`$ est vraie si $`\mathbf{P}`$ est fausse**.
* **$`\mathbf{\\neg P}`$ est fausse si $`\mathbf{P}`$ est vraie**.

[EN] (auto-transl !)

[ES][FR]

| $`\quad P\quad`$   |  $`\quad\neg P\quad`$ |
| :-------------------: | :-------------------: |
| V | F |
| F | V |

[EN] 

| $`\quad P\quad`$   |  $`\quad\neg P\quad`$ |
| :-------------------: | :-------------------: |
| T | F |
| F | T |

o / ou / or [ES][FR][EN]

| $`\quad P\quad`$   |  $`\quad\neg P\quad`$ |
| :-------------------: | :-------------------: |
| 1 | 0 |
| 0 | 1 |

!!! *Ejemplos / exemples / examples* :
!!!  * $`\neg (3\lt 5)`$ es una aserción falsa /est une assertion fausse / is a false statement
!!!  * $`\neg (3 = 5)`$ es una aserción verdarera / est une assertion vraie / is a true statement

-----------------------------------------

*[Math-Logic-80]  	Equivalencia / équivalence*

Símbolo / symbole / symbol : **$`\mathbf{\Longleftrightarrow}`$**

[ES] (¡ auto-transl !)

[FR] Soient $`P`$ et $`Q`$ deux assertions.

L'assertion **$`\mathbf{P \Longleftrightarrow Q}`$** :
  * se lit *$`P`$ est équivalent à $`Q`$*.
  * est **vraie si et seulement si** les valeurs de vérité de $`P`$ et $`Q`$ sont égales : **$`\mathbf{v(P)=v(Q)}`$**,<br>
donc si les assertions $`P`$ et $`Q`$ sont vraies ou fausses en même temps.

Les assertions **$`\mathbf{P \Longleftrightarrow Q}`$** et **$`\mathbf{Q \Longleftrightarrow P}`$** ont la *même définition*,<br>
sont *deux écritures différentes de la même* **équivalence de $`\mathbf{P}`$ et $`\mathbf{Q}`$**.

[EN] (auto-transl !)

[ES] (¡ auto-transl !) Tabla de verdad de equivalencia :<br>
[FR] Table de vérité de l'équivalence :<br>
[EN] (auto-transl !) Truth table of the equivalence :

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longleftrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| V | V | V |
| V | F | F |
| F | V | F |
| F | F | V |

([EN] same, excepted that V becomes T)

o / ou / or

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longleftrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| 1 | 1 | 1 |
| 1 | 0 | 0 |
| 0 | 1 | 0 |
| 0 | 0 | 1 |

!!! *Ejemplos / exemples / examples* :<br>
!!! [ES] (¡ auto-transl !) "Juan es el hijo de José" $`\quad \Longleftrightarrow \quad`$" José es el padre de Juan ".
!!! [FR] "Jean est le fils de Jacques" $`\quad \Longleftrightarrow \quad`$ "Jacques est le père de Jean".<br>
!!! [EN] (auto-transl !) "Oliver is Daniel's son" $`\quad \Longleftrightarrow \quad`$" Daniel is Oliver's father".

-----------------------

*[Math-Logic-90]  ... / conjonction / ..*

[ES] Símbolo : <br>
[FR] Symbole : **ET** ou **$`\mathbf{\land}`$** <br>
[EN] Symbol :

[ES]  <br>
[FR] Soient $`P`$ et $`Q`$ deux assertions.<br>
[EN]

L'assertion **$`\mathbf{P \land Q}`$** :
  * se lit *conjonction de $`P`$ et de $`Q`$*.
  * est **vraie si et seulement si** les assertions *$`\mathbf{P}`$ et $`\mathbf{Q}`$ sont vraies toutes les deux*,<br>
donc si et seulement si **$`\mathbf{v(P)=v(Q)=1}`$**.
  * donc est fausse dès que l'une au moins des deux assertions $`P`$ et $`Q`$ est fausse.

[ES] <br>
[FR] Table de vérité de la conjonction :<br>
[EN] 

 $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \land Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| V | V | V |
| V | F | F |
| F | V | F |
| F | F | F |

ou

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \land Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| 1 | 1 | 1 |
| 1 | 0 | 0 |
| 0 | 1 | 0 |
| 0 | 0 | 0 |

-----------------------

*[Math-Logic-100]  ... / disjonction / ..*

[ES] Símbolo : <br>
[FR] Symbole : **OU** ou **$`\mathbf{\lor}`$** <br>
[EN] Symbol :

[ES]  <br>
[FR] Soient $`P`$ et $`Q`$ deux assertions.<br>
[EN]

L'assertion **$`\mathbf{P \lor Q}`$** :
  * se lit *disjonction de $`P`$ et de $`Q`$*.
  * est **fausse si et seulement si** les assertions *$`P`$ et $`Q`$ sont fausses toutes les deux*,<br>
donc $`v(P \lor Q)=1`$ si et seulement si **$`\mathbf{v(P)=v(Q)=0}`$**.
  * donc $`P \lor Q)`$ est vraie dès que l'une au moins des deux assertions $`P`$ et $`Q`$ est vraie.

[ES] <br>
[FR] Table de vérité de la disjonction :<br>
[EN] 

 $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \lor Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| V | V | V |
| V | F | V |
| F | V | V |
| F | F | F |

ou

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \lor Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| 1 | 1 | 1 |
| 1 | 0 | 1 |
| 0 | 1 | 1 |
| 0 | 0 | 0 |

-----------------------

*[Math-Logic-101]  ... / disjonction / ..*

[ES] ?

!!!! [FR] *Attention :*
!!!!
!!!! *Dans la langue française*, le "ou" dans l'expression *P ou Q* est un *"ou" exclusif*. Cela signifie que si la proposition *(P ou Q)* est vraie*, alors soit *P est vraie à l'exclusion de Q*, soit *Q est vraie à l'exclusion de P,* mais donc P et Q ne peuvent être vraies ensemble.
!!!!
!!!! _Par exemple, si dans un restaurant un menu indique que vous avez droit au "fromage ou déssert", cela signifie que vous avez le droit de commander soit le fromage, soit le déssert, mais pas les deux en même temps._
!!!!
!!!! *En mathématique*, le *OU* est *inclusif*. Cela signifie que la proposition $`(P OU Q)`$ est vraie, si $`P`$ est vraie, si $`Q`$ est vraie, et si $`P`$ et $`Q`$ sont toutes les deux vraies.

[EN] ?

-----------------------

*[Math-Logic-110]  ... / implication / ..*

[ES] Símbolo : <br>
[FR] Symbole : **$`\mathbf{\Longrightarrow}`$** <br>
[EN] Symbol :


[ES]  <br>
[FR] Soient $`P`$ et $`Q`$ deux assertions.
[EN] 

L'assertion **$`\mathbf{P \Longrightarrow Q}`$** :
  * se lit *$`P`$ implique $`Q`$*.
  * est **fausse si et seulement si** la première assertion *$`\mathbf{P}`$ est vraie* et la suivante *$`\mathbf{Q}`$ est fausse*,<br>
donc si et seulement si **$`\mathbf{v(P)=1}`$ et $`\mathbf{v(Q)=0}`$**.

[ES] <br>
[FR] Table de vérité de l'implication :<br>
[EN] 

 $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| V | V | V |
| V | F | F |
| F | V | V |
| F | F | V |

ou

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| 1 | 1 | 1 |
| 1 | 0 | 0 |
| 0 | 1 | 1 |
| 0 | 0 | 1 |

-----------------------


*[Math-Logic-110.1]  ... / implication / ..*

[ES]

[FR]
! *Remarque :*
!
! L'implication *$`P \Longrightarrow Q`$* sera *seulement utilisée dans le cas où* :
! * les deux assertions *$`P`$ et $`Q`$ sont vraies*, ce qui conduit à *$`P \Longrightarrow Q`$ vraie*.
! * *$`P`$ est vraie et $`Q`$ est fausse*, ce qui conduit à *$`P \Longrightarrow Q`$ fausse*.
! 
! Ainsi nous évitons le paradoxe apparent que $`P \Longrightarrow Q`$ est toujours vrai dès que $`P`$ est fausse.

[EN]

-----------------------

*[Math-Logic-120]  ... / incompatibilité / ..*

[ES] Símbolo : <br>
[FR] Symbole : **$`|`$** <br>
[EN] Symbol :


[ES]  <br>
[FR] Soient $`P`$ et $`Q`$ deux assertions.
[EN] 

L'assertion **$`\mathbf{P\, | \, Q}`$** :
  * se lit *$`P`$ est incompatible avec $`Q`$*.
  * est **fausse si et seulement si** Les assertions *$`P`$ et $`Q`$ sont vraies ensemble*,<br>
donc $`v(P | Q)=0`$ si et seulement si **$`\mathbf{v(P)=1}`$ et $`\mathbf{v(Q)=1}`$**

Les assertions **$`\mathbf{P\, | \,Q}`$** et **$`\mathbf{Q\, | \, P}`$** ont la *même définition*,<br>
sont *deux écritures différentes de la même* **incompatibilité de $`\mathbf{P}`$ et $`\mathbf{Q}`$**.<br>

[ES] <br>
[FR] Table de vérité de l'implication :<br>
[EN] 

 $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| V | V | F |
| V | F | V |
| F | V | V |
| F | F | V |

ou

| $`\quad P\quad`$   |  $`\quad Q \quad`$ | $`\quad P \Longrightarrow Q \quad`$ |
| :--------------------: | :--------------------: | :---------------------------------------------: |
| 1 | 1 | 0 |
| 1 | 0 | 1 |
| 0 | 1 | 1 |
| 0 | 0 | 1 |

----------------------------------------------------------------------------------------------------
#### Las equivalencias simples / Les équivalences simples / The simple equivalences
----------------------------------------------------------------------------------------------------

*[Math-Logic-130.1]  ... / Lois de Morgan / ..*

[ES]  <br>
[FR] **Théorème (Lois de Morgan)** :<br>
Pour deux assertions $`P`$ et $`Q`$, les équivalences suivantes sont vraies :

**$`\mathbf{\text{NON}(P\;ET\;Q) \Longleftrightarrow \big{(}\text{NON}(\,P\,)\,OU\,\text{NON}(\,Q\,)\big{)}}`$**<br>
**$`\mathbf{\text{NON}(P\;OU\;Q) \Longleftrightarrow \big{(}\text{NON}(\,P\,)\,ET 
\,\text{NON}(\,Q\,)\big{)}}`$**

[EN]

[ES][FR][EN] :<br>
**$`\mathbf{\neg(\,P \land Q\,) \quad \Longleftrightarrow \quad \neg P  \lor \neg Q}`$**<br>
**$`\mathbf{\neg(\,P \lor Q\,) \quad \Longleftrightarrow \quad \neg P \land \neg Q}`$**

-----------------

*[Math-Logic-130.2]  ... / Démonstation : Morgan*

[ES]

[EN] 

[FR] Démontrer que $`\text{NON}(P\;ET\;Q) \Longleftrightarrow \big{(}\text{NON}(\,P\,)\;OU\;\text{NON}(\,Q\,)\big{)}`$, c'est montrer que $`\text{NON}(\,P\;ET\;Q\,)`$ et 
$`\big{(}\,\text{NON}(\,P\,)\;OU\;\text{NON}(\,Q\,)\big{)}`$ partagent la même table de vérité.

Avant d'écrire la table de vérité de ces propositions, allégeons le tableau en notant :<br>
$`A= \text{NON}(\,P\;\;ET\;\;Q\,) \quad`$  ,
$`\quad \text{C}=\big{(}\,\text{NON}(\,P\,)\;\;OU\;\;\text{NON}(\,Q\,)\,\big{)}`$<br>
$`B= \text{NON}(\,P\;\;OU\;\;Q\,) \quad`$ , 
$`\quad \text{D}=\big{(}\,\text{NON}(\,P\,)\;\;ET\;\;\text{NON}(\,Q\,)\,\big{)}`$<br>

Etablissons les tables de vérité des expressions $`A`$ et $`C`$ et vérifions leur identité :

| $`\;P\;`$ | $`\;Q\;`$ | $`\;A\;`$ || $`\text{NON}(\,A\,)`$ | $`\text{NON}(\,B\,)`$ | $`\;C\;`$ |  
| :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| V | V | F |  | F | F | F |
| V | F | V |  | F | V | V |
| F | V | V |  | V | F | V |
| F | F | V |  | V | V | V |

Ce qui prouve la première loi de Morgan.

De même :

| $`\;P\;`$ | $`\;Q\;`$ | $`\;B\;`$ || $`\text{NON}(\,A\,)`$ | $`\text{NON}(\,B\,)`$ | $`\;D\;`$ |  
| :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| V | V | F |  | F | F | F |
| V | F | F |  | F | V | F |
| F | V | F |  | V | F | F |
| F | F | V |  | V | V | V |

Ce qui prouve la deuxième loi de Morgan.

------------

*[Math-Logic-130.3]  ... / Démonstation : Morgan*

[ES] En notación matemática (internacionale) <br>
[FR] En notation mathématique (internationale) <br>
[EN] In mathematical notation (international) 

[ES] Las propiedades de una aserción $`F`$ vienen dadas por su tabla de verdad. <br>
Sean dos aserciones $`F_1`$ y $`F_2`$ compuestas de dos aserciones $`P`$ y $`Q`$ :<br>
$`F_1=F_1(P,Q)`$ y $`F_2=F_2(P,Q)`$ 
Demostrar que $`F_1(P,Q)`$ y $`F_2(P,Q)`$ son iguales ($`F_1(P,Q) = F_2(P,Q)`$), es mostrar que $`F_1`$ y $`F_2`$ comparten la misma tabla de verdad. 

[FR] Les propriétés d'une assertion $`F`$ sont données par sa table de vérité.<br>
Soient deux assertion $`F_1`$ et $`F_2`$ composée à partir de deux mêmes assertions $`P`$ et $`Q`$.
Démontrer que $`F_1`$ et $`F_2`$ sont égales ($`F_1=F_2`$), c'est montrer que $`F_1`$ et $`F_2`$ partagent une même table de vérité.

[EN] 

[ES] Demostración de : <br>
[FR] Démonstration de :<br>
[EN] Demonstration of : <br>
 $`\neg(\,P \land Q\,) \quad \Longleftrightarrow \quad \neg P  \lor \neg Q`$ :

| $`\;P\;`$ | $`\;Q\;`$ | $`\;\neg P \land \neg Q\;`$ || $`\;\neg P\;`$ | $`\;\neg Q\;`$ | $`\;\neg P \lor \neg Q\;`$ 
| :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| V | V | F |  | F | F | F |
| V | F | V |  | F | V | V |
| F | V | V |  | V | F | V |
| F | F | V |  | V | V | V |

([EN] same, excepted that V becomes T. 
([ES] Aún mejor, use 1 para V y 0 para F.
[FR] Encore mieux : utiliser 1 pour V et 0 pour F.
[EN] Even better, use 1 for V, and 0 for F.

<br>
[ES] Demostración de : <br>
[FR] Démonstration de :<br>
[EN] Demonstration of : <br>
$`\neg(\,P \lor Q\,) \quad \Longleftrightarrow \quad \neg P \land \neg Q`$ :

| $`\;P\;`$ | $`\;Q\;`$ | $`\neg(\,P \lor Q\,)`$ || $`\;\neg P\;`$ | $`\;\neg Q\;`$ | $`\;\neg P \land \neg Q\;`$  
| :---: | :---: | :---: | :---: | :---: | :---: | :---: |
| V | V | F |  | F | F | F |
| V | F | F |  | F | V | F |
| F | V | F |  | V | F | F |
| F | F | V |  | V | V | V |

-------------------------

*[Math-Logic-140]  La doble negación / La double négation / The double negation*

[ES] (¡ auto-transl !) Para cualquier aserción lógica $`P`$ :<br>
**$`\mathbf{\text{NO}\big{(}\text{NO}(\,P\,)\big{)} \Longleftrightarrow  P}`$** 

[FR] Pour toute assertion logique $`P`$ :<br>
**$`\mathbf{\text{NON}\big{(}\text{NON}(\,P\,)\big{)} \Longleftrightarrow  P}`$**

[EN] (auto-transl !) For any logical statement $`P`$ :<br>
**$`\mathbf{\text{NO}\big{(}\text{NO}(\,P\,)\big{)} \Longleftrightarrow  P}`$**

| $`\; P\;`$   |  $`\; \text{NO}(\,P\,) \;`$ | $`\; \text{NO}\big{(}\text{NO}(\,P\,)\big{)}  \;`$ |
| :---: | :---: | :---: | 
| V | F | V | 
| F | V | F | 

donc

| $`\; P\;`$   |  $`\; \text{NO}\big{(}\text{NO}(\,P\,)\big{)}  \;`$ | $`\text{NO}\big{(}\text{NO}(\,P\,)\big{)} \Longleftrightarrow  P`$ |
| :---: | :---: | :---: | 
| V |  V | V |
| F |  F | V |

<br>
[ES][FR][EN] **$`\mathbf{\neg \neg P \Longleftrightarrow  P}`$**

| $`\quad P\quad`$   |  $`\quad \neg P \quad`$ | $`\quad \neg\neg P \quad`$ | $`\neg \neg P \Longleftrightarrow  P`$ |
| :---: | :---: | :---: |  :---: |
| 1 | 0 | 1 | 1 |
| 0 | 1 | 0 | 1 |

-------------------------

*[Math-Logic-150]  Verdadero Y falso / vrai ET faux / True AND false*

[ES] (¡ auto-transl !) Para cualquier aserción lógica $`P`$ :<br>
**$`\mathbf{\big{(}\,P\;\;\text{Y}\;\;\text{NO}(\,P\,)\,\big{)}}`$ es falsa**.

[FR] Pour toute assertion logique $`P`$ :<br>
**$`\mathbf{\big{(}\,P\;\;\text{ET}\;\;\text{NO}(\,P\,)\,\big{)}}`$ est fausse**.

[EN] (auto-transl !) For any logical statement $`P`$ :<br>
**$`\mathbf{\big{(}\,P\;\;\text{AND}\;\;\text{NO}(\,P\,)\,\big{)}}`$ is false**.

| $`\quad P\quad`$   | $`\quad\text{NO}(\,P\,) \;\quad`$ | $`\quad P\;\;\text{Y}\;\;\text{NO}(\,P\,)\quad`$ | 
| :---: | :---: | :---: | 
| V | F | F | 
| F | V | F | 


<br>
[ES][FR][EN] **$`\mathbf{P \land \neg P} = 0`$**

| $`\quad P\quad`$   |  $`\quad \neg P \quad`$ | $`\quad P \land \neg P\quad`$ |
| :---: | :---: | :---: |
| 1 | 0 | 0 |
| 0 | 1 | 0 |

-------------------------

*[Math-Logic-160]  Verdadero O falso / vrai OU faux / True OR false*

[ES] (¡ auto-transl !) Para cualquier aserción lógica $`P`$ :<br>
**$`\mathbf{\big{(}\,P\;\;\text{O}\;\;\text{NO}(\,P\,)\,\big{)}}`$ es verdadera**.<br>

[FR] Pour toute assertion logique $`P`$ :<br>
**$`\mathbf{\big{(}\,P\;\;\text{OU}\;\;\text{NO}(\,P\,)\,\big{)}}`$ est vraie**.<br> 

[EN] (auto-transl !) For any logical statement $`P`$ :<br>
**$`\mathbf{\big{(}\,P\;\;\text{OR}\;\;\text{NO}(\,P\,)\,\big{)}}`$ is true**.

| $`\quad P\quad`$   |  $`\quad \text{NO}(\,P\,) \quad`$ | $`\quad P\;\;\text{O}\;\;\text{NO}(\,P\,) \quad`$ |
| :---: | :---: | :---: |
| V | F | V |
| F | V | V |

<br>
[ES][FR][EN] **$`\mathbf{P \lor \neg P} = 1`$**

| $`\quad P\quad`$   |  $`\quad \neg P \quad`$ | $`\quad P \lor \neg P\quad`$ |
| :---: | :---: | :---: |
| 1 | 0 | 1 |
| 0 | 1 | 1 |

-------------------------

*[Math-Logic-170]  Conmutatividad / commutativité / commutativity*

[ES] (¡ auto-transl !) Conmutatividad de conjunción y disyunción :
[FR] Commutativité de la conjonction et de la disjonction :
[EN] (auto-transl !) Commutativity of the conjunction and disjonction :

[ES] (¡ auto-transl !) Para cualquier aserciones lógicas $`P`$ y $`Q`$, las siguientes equivalencias son verdaderas :<br>
**$`\mathbf{(\,P\;\;Y\;\; Q\,)\; \Longleftrightarrow\; (\, Q \;\; Y \;\; P\,)}`$** <br>
**$`\mathbf{(\,P\;\;O\;\; Q\,)\; \Longleftrightarrow\; (\, Q \;\; O \;\; P\,)}`$** 

[FR] Pour toutes assertions logiques $`P`$ et $`Q`$, les équivalences suivantes sont vraies :<br>
**$`\mathbf{(\,P\;\;ET\;\; Q\,)\; \Longleftrightarrow\; (\, Q \;\; ET \;\; P\,)}`$** <br>
**$`\mathbf{(\,P\;\;OU\;\; Q\,)\; \Longleftrightarrow\; (\, Q \;\; OU \;\; P\,)}`$** 

[EN] (auto-transl !) For any logical statements $`P`$ and $`Q`$, the following equivalences are true :<br>
**$`\mathbf{(\,P\;\;AND\;\; Q\,)\; \Longleftrightarrow\; (\, Q \;\; AND \;\; P\,)}`$** <br>
**$`\mathbf{(\,P\;\;OR\;\; Q\,)\; \Longleftrightarrow\; (\, Q \;\; OR \;\; P\,)}`$** 

| $`\quad P\quad `$ | $`\quad Q\quad `$ | $`\quad P\;AND\;Q\quad `$ | $`\quad Q\;AND\;P\quad`$ | 
| :---: | :---: | :---: | :---: | 
| V | V | V | V | 
| V | F | F | F | 
| F | V | F | F | 
| F | F | F | F | 

<br>

| $`\quad Q\quad `$ | $`\quad P\quad `$ | $`\quad P\;OR\;Q\quad `$ | $`\quad Q\;OR\;P\quad`$ | 
| :---: | :---: | :---: | :---: | 
| V | V | V | V | 
| V | F | V | V | 
| F | V | V | V | 
| F | F | F | F | 

<br>
[ES] [FR] [EN] <br>
**$`\mathbf{P \lor Q \;\Longleftrightarrow\; Q \lor P}`$**<br>
**$`\mathbf{P \lor Q \;\Longleftrightarrow\; Q \lor P}`$**

| $`\; P\; `$ | $`\; Q\; `$ | $`\; P\land Q\; `$ | $`\; Q\land P\; `$ | $`\; P\lor Q\; `$ | $`\; Q\lor P\; `$ |
| :---: | :---: | :---: | :---: | :---: | :---: |
| 1 | 1 | 1 | 1 | 1 | 1 |
| 1 | 0 | 0 | 0 | 1 | 1 |
| 0 | 1 | 0 | 0 | 1 | 1 |
| 0 | 0 | 0 | 0 | 0 | 0 |

-------------------------

*[Math-Logic-180]  Asociatividad / associativité / associativity*

[ES] (¡ auto-transl !) Asociatividad de conjunción y disyunción :
[FR] Associativité de la conjonction et de la disjonction :
[EN] (auto-transl !) Associativity of the conjunction and disjonction :

[ES] (¡ auto-transl !) Para cualquier aserciones lógicas $`P`$ , $`Q`$ y $`R`$, las siguientes equivalencias son verdaderas :<br>
**$`\mathbf{P\;\;¿?\;(\,Q\;¿?\;R\,) \Longleftrightarrow  (\,P\;¿?\;Q\,)\;¿?\;R}`$** <br>
et on écrit ??????<br>
<br>
**$`\mathbf{P\;¿?\;(\,Q\;¿?\;R\,) \Longleftrightarrow  (\,P\;¿?\;Q\,)\;¿?\;R}`$** <br>
et on écrit ??????<br>

[FR] Pour toutes assertions logiques $`P`$ , $`Q`$ et $`R`$, les équivalences suivantes sont vraies :<br>
**$`\mathbf{P\;\;ET\,(\,Q\;\;ET\;\;R\,) \Longleftrightarrow  (\,P\;\;ET\;\;Q\,)\,ET\;\; R}`$** <br>
et on écrit :<br>
*$`\mathbf{P\;\;ET\;\;Q\;\;ET\;\;R}`$*<br>
<br>
**$`\mathbf{P\;\;OU\,(\,Q\;\;OU\;\;R\,) \Longleftrightarrow  (\,P\;\;OU\;\;Q\,)\,OU\;\; R}`$** <br>
et on écrit :<br>
*$`\mathbf{P\;\;OU\;\;Q\;\;OU\;\;R}`$*<br>

[EN] (auto-transl !) For any logical statements $`P`$ , $`Q`$ and $`R`$, the following equivalences are true :<br>
**$`\mathbf{P\;AND\,(\,Q\;AND\;R\,) \Longleftrightarrow  (\,P\;AND\;Q\,)\,AND\;R}`$** <br>
and we write :<br>
*$`\mathbf{P\;\;AND\;\;Q\;\;AND\;\;R}`$*<br>
<br>
**$`\mathbf{P\;OR\,(\,Q\;OR\;R\,) \Longleftrightarrow  (\,P\;OR\;Q\,)\,OR\; R}`$** <br>
an we write :<br>
*$`\mathbf{P\;\;OR\;\;Q\;\;OR\;\;R}`$*<br>


[ES] _¿Demostración de la primera equivalencia en forma de animación o un menú desplegable?_<br>
[FR] _Démonstration de la première équivalence sous forme d'animation, ou d'un menu déroulant?_<br>
[EN] _Demonstration of the first equivalence in the form of an animation, or a drop-down menu?_

| $`\;P\;`$ | $`\;Q\;`$ | $`\;R\;`$ | $`\quad P\;OR\;Q\quad `$ | $`\quad (P\;OR\;Q)\;OR\;R\quad `$ |
| :---: | :---: | :---: | :---: | :---: |
| V | V | V | V | V |
| V | V | F | V | V |
| V | F | V | V | V |
| V | F | F | V | V |
| F | V | V | V | V |
| F | V | F | V | V |
| F | F | V | F | V |
| F | F | F | F | F |

and

| $`\;P\;`$ | $`\;Q\;`$ | $`\;R\;`$ | $`\quad Q\;OR\;R\quad `$ | $`\quad P\;OR\;(Q\;OR\;R)\quad `$ |
| :---: | :---: | :---: | :---: | :---: |
| V | V | V | V | V |
| V | V | F | V | V |
| V | F | V | V | V |
| V | F | F | F | V |
| F | V | V | V | V |
| F | V | F | V | V |
| F | F | V | V | V |
| F | F | F | F | F |

<br>
[ES] _¿Demostración de la segunda equivalencia en forma de ejercicio de autoevaluación (menú de autodesplazamiento) en la parte "más allá"?_<br>
[FR] _Démonstration de la deuxième équivalence sous forme d'un exercice d'autoévaluation (menu autoréroulant) dans la partie au-delà?_<br>
[EN] _Demonstration of the second equivalence in the form of a self-assessment exercise (drop-down menu) in the beyond part?_

-------------------------

*[Math-Logic-190]  Distributividad / distributivité / distributivity*

[ES] (¡ auto-transl !) Para cualquier aserción lógica $`P`$ :<br>
[FR] Pour toute assertion logique $`P`$ :<br>
[EN] (auto-transl !) For any logical statement $`P`$ :<br>

à terminer


-----------------------------------------------------------------------------------------------------------------------
####  ... / Prédicat / ...
-----------------------------------------------------------------------------------------------------------------------

*[Math-Reason-10]  ... / Prédicat / ...*

De l'assertion au prédicat...

* exemples d'assertion :
    * $`3<5`$ est une assertion vraie.
    * $`3=5`$ est une assertion fausse.

* exemples de prédicat :
    * $`x=5`$ est un prédicat
    * $`x<y`$ est un prédicat

Un énoncé mathématique dont tous les éléments sont déterminés et qui est soit vrai soit faux est une assertion.
Et si c'est un énoncé dont tous les éléments sont précisés, mais qui est indécidable?
Un énoncé mathématique dont l'un au moins des éléments est indéterminé est un prédicat.
Un prédicat dont les éléments indéterminés sont précisés devient une assertion (sous l'hypothèse qu'il n'est pas indécidable...)

-----------------------------------------------------------------------------------------------------------------------
####  Cuantificadores lógicos / quantificateurs logiques / ...
-----------------------------------------------------------------------------------------------------------------------

<!------------------
[FR]  MATH-REAS_10
Un ensemble est une collection d'éléments.  
_Un ensemble se représente souvent par une lettre majuscule._
_Un éléments se représente souvent par une lettre minuscule indicée._
------------------>

*MATH-REAS_20* : $`\forall`$

[ES] *(auto-trad).  
**$`\mathbf{\forall}`$**$` \quad \equiv\quad`$ "*Para algún*" $`\quad \equiv\quad`$ "*para cualquier x*"$`\quad \equiv\quad`$ "*para todo*".  
...

[FR]   
**$`\mathbf{\forall}`$**$` \quad \equiv\quad`$ "*pour tout*" $`\quad \equiv\quad`$ "*quelque soit*".

Soit $`P(x)`$ un prédicat à une indéterminée $`x`$ sur un ensemble $`E`$.
L'expression mathématique  
**$`\mathbf{\forall x \in E\; , \;P(x)}`$**   
se lit  
"*Pour tout $`\mathbf{x}`$ appartenant à $`\mathbf{E}`$, l'assertion $`\mathbf{P(x)}`$ est vérifiée.*"

Autres écritures rencontrées :  
*$`\mathbf{\forall x \in E\; ,\; P(x)\quad \equiv\quad \big(\,\forall x \in E\,\big)\,\big(\,P(x)\,\big)}`$*   
(y a t-il une norme internationale prônée?)

[EN]

----------------------

*MATH-REAS_21*  : ejemplos / exemples / examples $`\forall`$

_____*MATH-REAS_21.1*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! ...    
!!!
!!! [EN]     
!!! ...    

_____*MATH-REAS_21.2*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]   
!!! $`\forall x\in\mathbb{R}\, , x^2\ge 0`$  
!!! L'assertion est $`P(x)=\;"x^2\ge 0"`$  
!!!   
!!! [EN]   
!!! ...   

----------------------------

*MATH-REAS_30* : $`\exists`$

[ES] *(auto-trad.)* cuantificador existencial

**$`\mathbf{\exists}`$**$` \quad \equiv\quad`$ "*existe un*".   
...


[FR]   
**$`\mathbf{\exists}`$**$` \quad \equiv\quad`$ "*il existe*".

Soit $`P(x)`$ un prédicat à une indéterminée $`x`$ sur un ensemble $`E`$.
L'expression mathématique  
**$`\mathbf{\exists x_0 \in E\;,\; P(x)}`$**   
se lit  
"*Il existe un $`x_0`$ appartenant à $`E`$, tel que l'assertion $`P(x_0)`$ est vérifiée.*"  
et se comprend comme  
"Il existe *au moins un* $`\mathbf{x_0}`$ appartenant à $`\mathbf{E}`$, tel que l'assertion $`\mathbf{P(x_0)}`$ est vérifiée."

Attention : Nous ne savons pas _a priori_ quel élément $`x_0`$ vérifie l'assertion $`P(x_0)`$. Nous savons simplement qu'il existe et nous pouvons travailler formallement avec.

Autres écritures rencontrées :  
 *$`\mathbf{\exists x_0 \in E\; ,\; P(x_0)\quad \equiv\quad \big(\,\exists x_0 \in E\,\big)\,\big(\,P(x_0)\,\big)}`$*   
 
Le "tel que" est exprimé par la virgule " , " ou un " | " :   
*$`\mathbf{\exists x_0 \in E\; ,\; P(x_0)\quad \equiv\quad \exists x_0 \in E\; | \; P(x_0)}`$*  
(y a t-il une norme internationale prônée?)

[EN]

----------------------

*MATH-REAS_31* : ejemplos / exemples / examples $`\exists`$

_____*MATH-REAS_31.1*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! ...    
!!!
!!! [EN]     
!!! ...    

_____*MATH-REAS_31.2*     
!!! [ES]     
!!! ...    
!!!   
!!! [FR] 
!!! L'assertion est $`P(x)=\,"x\gt 5"`$.   
!!! $`\exists x\in\mathbb{R}\; , \; x\gt 5`$   
!!! (par exemple $`7\; : 7\in\mathbb{R}`$ et $`7\gt 5`$,     
!!! ce qui s'écrit aussi
!!! $`(7\in\mathbb{R}) \land (7\gt 5)`$
!!!   
!!! L'assertion est $`P(x)=\,"x = 5"`$.   
!!! $`\exists x\in\mathbb{R}\; , \; x\gt 5`$   (il n'y en a qu'un seul : $`x=5`$).
!!! 
!!! [EN]   
!!! ...   

-------------------------


*MATH-REAS_40* : $`\exists !`$

[ES] *(auto-trad)* cuantificador existencial único  
**$`\mathbf{\exists !}`$**$` \quad \equiv\quad`$ "*existe un y solo uno*" $` \quad \equiv\quad`$ "*existe un único*".

[FR]   
**$`\mathbf{\exists !}`$**$` \quad \equiv\quad`$ "*il existe un et un seul*" $` \quad \equiv\quad`$ "*il existe un unique*".

Soit $`P(x)`$ un prédicat à une indéterminée $`x`$ sur un ensemble $`E`$.
L'expression mathématique  
**$`\mathbf{\exists ! \; x_0 \in E\;,\; P(x)}`$**   
se lit   
"*Il existe un et un seul $`\mathbf{x_0}`$ appartenant à $`\mathbf{E}`$, tel que l'assertion $`\mathbf{P(x_0)}`$ est vérifiée.*"

[EN]

----------------------

*MATH-REAS_41* : ejemplos / exemples / examples $`\exists`$

_____*MATH-REAS_41.1*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! ...    
!!!
!!! [EN]     
!!! ...    

_____*MATH-REAS_41.2*     
!!! [ES]     
!!! ...    
!!!   
!!! [FR]  
!!! L'assertion est $`P(x)=\,"x = 5"`$.   
!!! $`\exists !\; x\in\mathbb{R}\; , \; x = 5`$   
!!! (5 est le seul nombre réel qui est égal à lui-même).
!!! 
!!! [EN]   
!!! ...   

-----------------------------------------------------------------------------------------------------------------------
####  Reglas para usar cuantificadores  / règles d'utilisation des quantificateurs / ...
-----------------------------------------------------------------------------------------------------------------------

<!----- ¿Todos esos? / tout cela? all this?--------
Leyes de Identidad, de Complementación, de Idempotencia, Leyes Conmutativas, Asociativas, Distributivas, de Involución, de Absorción,  de Morgan, ...
------------------------------------------------------->


*MATH-REAS_100* : La negación de / la négation de / the negation of : $`\forall`$

[ES]. 
...   

[FR]    
La négation de l'expression  
"Pour tout $`x`$ appartenant à $`E`$, l'assertion $`P(x)`$ est vérifiée"  
se dit :  
"Il existe (au moins) un  $`x`$ appartenant à $`E`$, tel que l'assertion $`P(x)`$ n'est pas vérifiée",  
et cela s'écrit mathématiquement :  
$`NON\big(\;\forall x \in E\; , \;P(x)\;\big)`$ $`\Longleftrightarrow \exists x \in E\; , \; NON\big(\,P(x)\,\big)`$  
ou mieux encore :  
**$`\mathbf{\neg\big(\;\forall x \in E\; , \;P(x)\;\big)}`$ $`\mathbf{\Longleftrightarrow \exists x \in E\; , \; \neg\big (\,P(x)\,\big)}`$**

---------------

*MATH-REAS_101* : $`\neg`$ y $`\forall`$ : ejemplos / exemples / examples

_____*MATH-REAS_101.1*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! ...    
!!!
!!! [EN]     
!!! ...    

_____*MATH-REAS_101.2*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]   
!!! _(pour niveaux 1 à 4)_   
!!! La *négation* de l'expression logique
!!! "*Tous les chats sont gris*"  
!!! est   
!!! "*Il existe un moins un chat qui n'est pas gris*".   
!!!   
!!! [EN]    
!!! ...

---------------

*MATH-REAS_110* : La negación de / la négation de / the negation of : $`exists`$

[ES]. 
...   

[FR]      
La négation de l'expression  
"Il existe un $`x`$ appartenant à $`E`$ tel que l'assertion $`P(x)`$ est vérifiée"  
se dit :  
"Pour tout $`x`$ appartenant à $`E`$, l'assertion $`P(x)`$ n'est pas vérifiée",  
et cela s'écrit mathématiquement :  
$`NON\big(\;\exists x \in E\; , \;P(x)\;\big)`$ $`\Longleftrightarrow \forall x \in E\; , \; NON\big(\,P(x)\,\big)`$  
ou mieux encore :  
**$`\mathbf{\neg\big(\;\exists x \in E\; , \;P(x)\;\big)}`$ $`\mathbf{\Longleftrightarrow \forall x \in E\; , \; \neg\big (\,P(x)\,\big)}`$**

[EN].    
...     

----------------------

*MATH-REAS_111* : $`\neg`$ y $`\exists`$ : ejemplos / exemples / examples

_____*MATH-REAS_111.1*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! ...    
!!!
!!! [EN]     
!!! ...    

_____*MATH-REAS_111.2*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]   
!!! _(pour niveaux 1 à 4)_   
!!! La *négation* de l'expression logique
!!! "*Il existe un chat de couleur verte*"  
!!! est   
!!! "*Aucun chat n'est de couleur verte*"  
!!! qui est équivalent à    
!!! "Tous les chats ont une couleur qui n'est pas le vert."
!!!   
!!!   
!!! [EN]    
!!! ...

---------------

*MATH-REAS_112* : $`\neg`$ y $`\exists`$,  $`\forall`$ : autoevaluación simple / auto-test simple / ...

<!--para la parte "más allá"  / pour la partie "au-delà" / for the "beyond" part -->

[ES]   
...

[FR]   
_(pour niveau 3 ou 4)_   
Quelle est la négation des assertions suivantes :   
* $`\big(\,\forall z \in \mathbb{C}\,\big)\,\big(\,z^2+1 \ne 0\,\big)`$.  
* $`\big(\,\forall \epsilon \gt 0\,\big)`$.   

[EN]    
...

---------------

*MATH-REAS_120* : Distributividad / distributivité / distributivity : $`\exists\rightarrow\lor`$

[ES].   
...

[FR].    
Distributivité de $`\exists`$ avec $`OU`$ ($`\lor`$) :   
$`\exists x \in E\; , \; A(x)\;OU\;B(x)`$ 
$`\;\Longleftrightarrow\; \big(\,\exists x \in E\; , \; A(x)\,\big)\;OU\;\big(\,\exists x \in E\; , \; B(x)\,\big)`$   
ou encore   
**$`\mathbf{\exists x \in E\; , \; A(x)\;\lor\;B(x)}`$
$`\mathbf{\;\Longleftrightarrow\; \big(\,\exists x \in E\; , \; A(x)\,\big)\;\lor\;\big(\,\exists x \in E\; , \; B(x)\,\big)}`$**

-----------------------------

*MATH-REAS_121* : Distrib. $`\exists\rightarrow\lor`$, ejemplos / exemples / examples

_____*MATH-REAS_121.1*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! ...    
!!!
!!! [EN]     
!!! ...    

_____*MATH-REAS_121.2*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! *Exemple 1 :*   
!!!    
!!! *$`\mathbf{E}`$* est l'*ensemble des étudiants*.    
!!! Regardons les *prédicats* suivants :   
!!! *$`\mathbf{P(x)}\;=\;`$ "L'étudiant $`x`$ possède un smartphone."*   
!!! *$`\mathbf{P(x)}\;=\;`$ "L'étudiant $`x`$ possède un vélo."*   
!!!   
!!! La phrase mathématique   
!!! $`\exists x \in E\; , \; A(x)\;\lor\;B(x)`$
!!! $`\;\Longleftrightarrow`$ $`\; \big(\,\exists x \in E\; , \; A(x)\,\big)\;\lor\;\big(\,\exists x \in E\; , \; B(x)\,\big)`$     
!!! s'écrit en français   
!!! "Dire qu'il existe au moins un étudiant qui possède un smartphone ou un vélo ou les deux, équivaut à dire
!!! "qu'il existe au moins un étudiant qui possède un smartphone, ou qu'il existe au moins un étudiant qui possède un vélo, ou qu'il existe au moins un étudiant qui possède les deux."   
!!!
!!! [EN].   
!!! ...


[EN].   
...

--------------------

*MATH-REAS_125* : Distributividad / distributivité / distributivity : $`\forall\rightarrow\land`$

[ES].   
...

[FR].    
Distributivité de $`\forall`$ avec $`ET`$ ($`\land`$) :   
$`\forall x \in E\; , \; A(x)\;ET\;B(x)`$ 
$`\;\Longleftrightarrow\; \big(\,\forall x \in E\; , \; A(x)\,\big)\;ET\;\big(\,\forall x \in E\; , \; B(x)\,\big)`$   
ou encore   
**$`\mathbf{\forall x \in E\; , \; A(x)\;\land\;B(x)}`$
$`\mathbf{\;\Longleftrightarrow\; \big(\,\forall x \in E\; , \; A(x)\,\big)\;\land\;\big(\,\forall x \in E\; , \; B(x)\,\big)}`$**

---------------------

*MATH-REAS_126* : Distrib. $`\forall\rightarrow\land`$, ejemplos / exemples / examples

_____*MATH-REAS_126.1*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! ...    
!!!
!!! [EN]     
!!! ...    

_____*MATH-REAS_126.2*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! *Exemple 1 (suite) :*   
!!!     
!!! La phrase mathématique   
!!! $`\forall x \in E\; , \; A(x)\;\land\;B(x)`$
!!! $`\;\Longleftrightarrow`$ $`\; \big(\,\forall x \in E\; , \; A(x)\,\big)\;\land\;\big(\,\forall x \in E\; , \; B(x)\,\big)`$   
!!! s'écrit en français   
!!! Dire que tout étudiant possède un smartphone et un vélo équivaut à dire que tout étudiant possède un smartphone et que tout étudiant possède un vélo.   
!!!
!!! [EN].   
!!! ...

[EN].   
...

--------------------

*MATH-REAS_130* : No distributividad / non distributivité / no distributivity : $`\exists\rightarrow\land`$ 

[ES].   
...

[FR].    
!!!! *ATTENTION :*    
!!!!     
!!!! *Non distributivité de $`\exists`$ avec $`ET`$ ($`\land`$)* :   
!!!!    
!!!! $`\exists x \in E\; , \; A(x)\;ET\;B(x)`$ 
!!!! *$`\require{cancel}\;\xcancel{\iff}\;`$* $`\big(\,\exists x \in E\; , \; A(x)\,\big)\;ET\;\big(\,\exists x \in E\; , \; B(x)\,\big)`$   
!!!! ou encore   
!!!! $`\exists x \in E\; , \; A(x)\;\land\;B(x)`$
!!!! *$`\require{cancel}\;\xcancel{\iff}\;`$* $`\big(\,\exists x \in E\; , \; A(x)\,\big)\;\land\;\big(\,\exists x \in E\; , \; B(x)\,\big)`$      
!!!!    
!!!! *L'implication est vraie*,
!!!!     
!!!! $`\mathbf{\exists x \in E\; , \; A(x)\;ET\;B(x)}`$ 
!!!! *$`\mathbf{\Longrightarrow}`$* *$`\mathbf{\big(\,\exists x \in E\; , \; A(x)\,\big)\;ET\;\big(\,\exists x \in E\; , \; B(x)\,\big)}`$*   
!!!! ou encore   
!!!! *$`\mathbf{\exists x \in E\; , \; A(x)\;\land\;B(x)}`$*
!!!! *$`\mathbf{\Longrightarrow}`$* *$`\mathbf{\big(\,\exists x \in E\; , \; A(x)\,\big)\;\land\;\big(\,\exists x \in E\; , \; B(x)\,\big)}`$* 
!!!!    
!!!! mais *la réciproque est fausse*,
!!!!    
!!!! $`\big(\,\exists x \in E\; , \; A(x)\,\big)\;ET\;\big(\,\exists x \in E\; , \; B(x)\,\big)`$
!!!! *$`\require{cancel}\cancel{\Longrightarrow}\;`$* $`\exists x \in E\; , \; A(x)\;ET\;B(x)`$    
!!!! ou encore   
!!!! $`\big(\,\exists x \in E\; , \; A(x)\,\big)\;\land\;\big(\,\exists x \in E\; , \; B(x)\,\big)`$
!!!! *$`\require{cancel}\cancel{\Longrightarrow}\;`$* $`\exists x \in E\; , \; A(x)\;\land\;B(x)`$   

[EN]

----------------------------------

*MATH-REAS_131* : No distrib. $`\exists\rightarrow\land`$, ejemplos / exemples / examples

_____*MATH-REAS_131.1*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! ...    
!!!
!!! [EN]     
!!! ...    

_____*MATH-REAS_131.2*     
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! *Exemple 1 (suite) :*   
!!!     
!!! Les phrases mathématiques    
!!! $`\exists x \in E\; , \; A(x)\;ET\;B(x)`$ (phrase 1)   
!!! et    
!!!  $`\big(\,\exists x \in E\; , \; A(x)\,\big)\;\land\;\big(\,\exists x \in E\; , \; B(x)\,\big)`$  (phrase 2)    
!!! s'écrivent respectivement :    
!!! "Il existe au moins un étudiant qui possède un smartphone et un vélo." (phrase 1)  
!!! et    
!!! "Il existe au moins un étudiant qui possède un smartphone, et il existe au moins un étudiant qui possède un vélo."  (phrase 2)     
!!! ...
!!! Nous voyons bien que la prase (1) implique la phrase (2).   
!!! Par contre la réciproque n'est vraie. Il se peut très bien qu'aucun des étudiants qui possèdent un smartphone (et il y en a au moins un) ne possède de vélo, et vice versa : la phrase (2) n'implique pas la phrase (1).    
!!! Les phrases (1) et (2) ne sont pas équivalentes.   
!!!     
!!! [EN]    
!!! ...

--------------------

*MATH-REAS_135* : No distributividad / non distributivité / no distributivity : $`\forall\rightarrow\lor`$ 

[ES].   
...

[FR].    
!!!! *ATTENTION :*    
!!!!     
!!!! *Non distributivité de $`\forall`$ avec $`OU`$ ($`\lor`$)* :   
!!!!    
!!!! $`\big(\,\forall x \in E\; , \; A(x)\,\big)\;OU\;\big(\,\forall x \in E\; , \; B(x)\,\big)`$
!!!! *$`\require{cancel}\;\xcancel{\iff}\;`$* $`\forall x \in E\; , \; A(x)\;OU\;B(x)`$    
!!!! ou encore   
!!!! $`\big(\,\forall x \in E\; , \; A(x)\,\big)\;\lor\;\big(\,\forall x \in E\; , \; B(x)\,\big)`$
!!!! *$`\require{cancel}\;\xcancel{\iff}\;`$* $`\forall x \in E\; , \; A(x)\;\lor\;B(x)`$
!!!!    
!!!! *L'implication est vraie*,
!!!!     
!!!! *$`\mathbf{\big(\,\forall x \in E\; , \; A(x)\,\big)\;OU\;\big(\,\forall x \in E\; , \; B(x)\,\big)}`$*
!!!! *$`\mathbf{\Longrightarrow}`$* *$`\mathbf{\forall x \in E\; , \; A(x)\;OU\;B(x)}`$*    
!!!! ou encore   
!!!! *$`\mathbf{\big(\,\forall x \in E\; , \; A(x)\,\big)\;\lor\;\big(\,\forall x \in E\; , \; B(x)\,\big)}`$*
!!!! *$`\mathbf{\Longrightarrow}`$* *$`\mathbf{\forall x \in E\; , \; A(x)\;\lor\;B(x)}`$*
!!!!    
!!!! mais *la réciproque est fausse*,
!!!!    
!!!!   $`\forall x \in E\; , \; A(x)\;OU\;B(x)`$
!!!! *$`\require{cancel}\cancel{\Longrightarrow}\;`$*
!!!! $`\big(\,\forall x \in E\; , \; A(x)\,\big)\;OU\;\big(\,\forall x \in E\; , \; B(x)\,\big)`$    
!!!! ou encore   
!!!! $`\forall x \in E\; , \; A(x)\;\lor\;B(x)`$
!!!! *$`\require{cancel}\cancel{\Longrightarrow}\;`$* $`\big(\,\forall x \in E\; , \; A(x)\,\big)\;\lor\;\big(\,\forall x \in E\; , \; B(x)\,\big)`$  

[EN]

----------------------------------

*MATH-REAS_136* : No distrib. $`\forall\rightarrow\lor`$, ejemplos / exemples / examples

_____*MATH-REAS_136.1*
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! ...    
!!!
!!! [EN]     
!!! ...    


_____*MATH-REAS_136.2*

!!! [ES]      
!!! ...
!!! 
!!! [FR].    
!!! *Exemple 1 (suite) :*   
!!!     
!!! Les phrases mathématiques    
!!! $`\forall x \in E\; , \; A(x)\;OU\;B(x)`$ (phrase 1)   
!!! et    
!!!  $`\big(\,\forall x \in E\; , \; A(x)\,\big)\;\lor\;\big(\,\forall x \in E\; , \; B(x)\,\big)`$  (phrase 2)    
!!! s'écrivent respectivement :    
!!! "Tout étudiant possède un smartphone ou un vélo, ou les deux." (phrase 1)  
!!! et    
!!! "Tout étudiant possède un smartphone" ou "tout étudiant possède un vélo", ou "tout étudiant possède les deux."  (phrase 2)   
!!!     
!!! Nous voyons bien que la phrase (2) implique la phrase (1).   
!!! En effet 
!!! La réciproque n'est pas vraie, (1) n'implique pas (2).   
!!! Prenons un contre-exemple : une moitié des étudiants possèdent un smarphone et pas de vélo, et l'autre moitié un vélo mais pas de smartphone.  Quelque soit alors l'étudiant considéré, il possède un smartphone ou un vélo, ou les deux et la phrase (1) est vraie. Par contre nous ne sommes dans aucun de ces trois cas décrits par la phrase (2) :  
!!! \- "Tout étudiant possède un smartphone".   
!!! \- "Tout étudiant possède un vélo".   
!!! \- "Tout étudiant possède un smartphone et un vélo".   
!!! 
!!! [EN]

--------------------

*MATH-REAS_140* : Comutatividad / commutativité / commutativity : $`\exists`$, $`\forall`$

[ES].  
...

[FR]    
Soient $`E_1`$ et $`E_2`$ deux ensembles, et $`P(x,y)`$ un prédicat à deux indéterminées sur $`E_1`$ et $`E_2``$.   

Lorsque *les deux quantificateurs sont identiques*, les propositions suivantes **sont vraies :**

**$`\mathbf{\forall x \in E_1 \;,\, \forall y\, \in E_2 \;,\, P(x,y)}`$ $`\mathbf{\;\iff \forall y\in E_2 \;,\, \forall x\in E_1 \;,\, P(x,y)}`$**

**$`\mathbf{\exists x\in E_1 \;,\, \exists y\in E_2 \;,\, P(x,y)}`$ $`\mathbf{\;\iff \exists y\in E_2 \;,\, \exists x\in E_1\;,\, P(x,y)}`$**

[EN].   
...

-------------------

*MATH-REAS_141* : Com. $`\exists`$, $`\forall`$ (suite)

[ES].  
...

[FR]    
Soient $`E_1`$ et $`E_2`$ deux ensembles, et $`P(x,y)`$ un prédicat à deux indéterminées sur $`E_1`$ et $`E_2``$.   

Lorsque *les deux quantificateurs sont différents*, **seule l'implication suivante est vraie :**

**$`\mathbf{\exists x\in E_1\;,\; \forall y\in E_2 \;,\; P(x,y)}`$ $`\mathbf{\;\Longrightarrow \forall y\in E_2 \;,\;  \exists x\in E_1 \;,\; P(x,y)}`$**

La première partie de la phrase mathématique précédente,    
$`\exists x\in E_1\, , \forall y\in E_2\, , P(x,y)`$,       
se lit  
"Il existe un $`x`$ de $`E_1`$, tel que pour tout $`y`$ de $`E_2`$, le prédicat $`P(x,y)`$ s'applique".   
Ce $`x`$ est le même pour tous les $`y`$.

La seconde partie,    
$`\forall y\in E_2\, , \exists x\in E_1\, , P(x,y)`$,   
se lit   
"pour tout $`y`$ de $`E_2`$,  il existe un $`x`$ de $`E_1`$ tel que le prédicat $`P(x,y)`$ s'applique.   
Mais chaque $`y`$ peut avoir un $`x`$ différent.

La première partie implique la seconde. La seconde n'implique pas la première.

[EN].   
...

--------------------

*MATH-REAS_142* : Com. $`\exists`$, $`\forall`$, ejemplos, exemples, examples  

_____*MATH-REAS_142.1*
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! ...    
!!!
!!! [EN]     
!!! ...    


_____*MATH-REAS_142.2*
!!! [ES].     
!!! ...
!!! 
!!! [FR]. 
!!! $`J`$ est l'ensemble des jours de l'année, et $`H`$ l'ensemble des heures de la journée.
!!! Le prédicat $`P(j,h)`$ est "le soleil de lève le jour j à l'heure h".
!!! 
!!! * l'expression mathématique   
!!! $`\exists h \in H\; , \; \forall j \in J\; , \; P(j,h)`$   
!!! s'écrit en français   
!!! "Il existe une heure h telle que, quelque-soit le jour de l'année, le soleil se lève à l'heure h".   
!!! Ce prédicat n'est vraie que sur la ligne équatoriale, où la durée du jour et de la nuit sont égales toute l'année.
!!! 
!!! * l'expression mathématique   
!!! $`\forall j \in J\; , \; \exists h \in H\; , \; P(j,h)`$   
!!! s'écrit en français   
!!! "Quelque-soit le jour j de l'année, il existe une heure h à laquelle le soleil se lève".   
!!! Ce prédicat est vraie sur la plus grande partie de la Terre, sauf peut-être au voisinage des pôles géographiques terrestres où 6 !!! !!! mois de nuits succèdent à 6 mois de jours. Cela signifie simplement que le soleil se lève chaque jour.
!!! 
!!! <!--Cet exemple est excellent, c'est le cycle immuable du levé du soleil chaque jour observé et compris par tous. J'espère qu'on !!! !a le droit de l'utiliser dans le site-->
!!! 
!!! [EN].     
!!! ...

-------------------

*MATH-REAS_145* : 

[ES]    
...

[FR]    
...

[EN]   
...

-------------------

*MATH-REAS_150* : 

[ES]    
...

[FR]    
...

[EN]   
...


-----------------------------------------------------------------------------------------------------------------------
####  Métodos de razonamiento  / méthodes de raisonnement / reasoning methods 
-----------------------------------------------------------------------------------------------------------------------

*MATH-REAS_200* : El contraejemplo / le contre-exemple / the counterexample 

[ES].   
...        

[FR]       
Basé sur :     
$`NON\big(\,\forall x\; , \; P(x)\,\big) \iff \exists x\; , \; NON\big(\,P(x)\,\big)`$    
ou encore     
**$`\mathbf{\neg(\,\forall x\in E \; , \; P(x)\,\big) \iff \exists x\in E\; , \; \neg P(x)}`$**

[EN].      
.....

----------------------------

*MATH-REAS_210* : Reducción al absurdo / raisonnement par l'absurde / argumentum ad absurdum

[ES].    
....

[FR].     
Basé sur :   
$`\big(\,P \Longrightarrow Q\,\big) \iff \big(\,NON(Q) \Longrightarrow NON(P)\,\big)`$   
ou encore.   
**$`(\mathbf{\,P \Longrightarrow Q\,) \iff (\,\neg Q \Longrightarrow \neg P\,)}`$**



[EN].    
*argumentum ad absurdum* = *reductio ad absurdum*

---------------------

*MATH-REAS_220* : Razonamiento por recurrencia / raisonnement par récurrence / ???

[ES].    
Razonamiento por recurrencia  = Método de inducción completa

[FR].     

**Principe de récurrence**.  
Soit $`n_0 \in \mathbb{N}`$,    
et soit $`I_{n_0}`$ l'ensemble des entiers naturels supérieurs à $`n_0`$ :
$`I_{n_0} = \{n\in \mathbb{N}, n\ge n_0\}`$.

**$`\mathbf{\left.\begin{array}{l} 
\text{Initialisation :}\;\mathbf{P(n_0)\;\text{est vraie}}  \\ 
\text{Hérédité :}\;\mathbf{\forall n \in I_{n_0}\;,\; P(n)\Longrightarrow P(n+1)}
\end{array}\right\}}`$
$`\mathbf{\;\Longrightarrow\forall n \in I_{n_0}\;,\; P(n) \;\text{est vraie.}}`$**


[EN].    
Attention !!! ce sera a priori un faux-ami ici, le terme correspondant

---------------------

*MATH-REAS_221* : Ejemplos / exemples / examples

_____*MATH-REAS_221.1*
!!! [ES]     
!!! ...    
!!!
!!! [FR]     
!!! ...    
!!!
!!! [EN]     
!!! ...    


_____*MATH-REAS_221.2*
!!! [ES].   
!!! ...    
!!!
!!! [FR].   
!!! Montrons que      
!!! $`\forall n \in \mathbb{N}\;,\; \displaystyle\sum_{k=0}^n  k = \dfrac{n\,(n+1)}{2}`$   
!!! 
!!! Pour $`n \in \mathbb{N}`$ le prédicat *$`P(n)`$ est l' égalité $`\displaystyle\sum_{k=0}^n  k = \dfrac{n\,(n+1)}{2}`$*.
!!!
!!! *Etape d'initialisation* :  si nous voulons démontrer que ce prédicat est vrai pour tout entier naturel, testons le sur le plus petit d'entre eux : $`n=0`$.   
!!!  $`\displaystyle\sum_{k=0}^0  k = 0 = \dfrac{0\,(0+1)}{2}`$,  
!!! donc *$`\mathbf{P(0)}`$ est vraie*.   
!!! 
!!! *Etape d'hérédité* : soit $`n \in \mathbb{N}`$, supposons que $`P(n)`$ est vraie et montrons que $`P(n+1)`$
!!! est vraie.  
!!!  
!!! Si $`P(n)`$ est vraie donc :   
!!! $`\displaystyle\sum_{k=0}^n  k = \dfrac{n\,(n+1)}{2}`$   
!!!
!!! $`\displaystyle\sum_{k=0}^{n+1}  k = \sum_{k=0}^{n}  k + (n+1) `$ $`\;= \dfrac{n\,(n+1)}{2}+(n+1)`$   
!!!
!!! $`\displaystyle\sum_{k=0}^{n+1} = \dfrac{n\,(n+1)}{2}+ \dfrac{2\,(n+1)}{2}`$  $`\;= \dfrac{(n+2)\,(n+1)}{2}`$ 
!!!
!!! ce qui prouve que $`P(n+1)`$ est vraie aussi.
!!!
!!! Ainsi, puisque le $`n`$ fixé dans cette partie hérédité est quelconque, nous avons démontré que *le prédicat *
!!!
!!! *$`\mathbf{\forall n \in \mathbb{N}\;,\; P(n)\Longrightarrow P(n+1)}`$ est vrai*.
!!!
!!! *Etape de conclusion* : l'*application du principe de récurrence* nous permet de conclure que *le prédicat*   
!!! 
!!! *$`\mathbf{\forall n \in \mathbb{N}\;,\; \displaystyle\sum_{k=0}^n  k = \dfrac{n\,(n+1)}{2}}`$ est vrai*.
!!!     
!!! [EN].   
!!! ...    
!!!

---------------------

*MATH-REAS_222* : Para un parte más allá / au-delà / beyond

!! [ES].   
!! ...    
!!
!! [FR].   
!! Une *suite récurrente* est une suite dont *chaque terme se détermine à partir du ou des termes précédents*.
!!    
!! Certaines suites récurrentes très utiles en physique :
!! * Les *suites arithmétiques de raison $`\mathbf{a} \in \mathbb{R}`$* et de premier terme $`b \in \mathbb{R}`$. Chaque terme $`u_{n+1}`$ de la suite se définit à partir du précédent : *$`\mathbf{u_{n+1}=u_n + a}`$*.
!!
!! * Les *suites géométriques de raison $`\mathbf{a} \in \mathbb{R}`$* et de premier terme $`b \in \mathbb{R}`$. Chaque terme $`u_{n+1}`$ de la suite se définit à partir du précédent : *$`\mathbf{u_{n+1}=u_n \times a}`$*.
!!
!! Citons une suite récurrente très célèbre, la *suite de Fibonacci*. Ses deux premiers termes $`\mathbf{u_0 = u_1 = 1}`$ et tout terme suivant de rang $`n`$ se calcule à partir des 2 termes précédents selon la récurrence $`\mathbf{u_n=u_{n-1}+u_{n-2}}`$.
!!
!! [EN].   
!! ...    
!!

---------------------

*MATH-REAS_230* : Razonamiento por análisis y síntesis ?? / raisonnement par analyse-synthèse / ???

[ES].    


[FR].     
....


[EN].    


---------------------

