---
title: "Application du théorème d'Ampères : 1° étape, symétries et invariances"
published: true
routable: true
visible: false
lessons:
    -
       slug: magnetostatics-ampere-application-method-3
       name: LINÉAIRE-3 : Théorème d'Ampère : méthode générale
       order: 1
    -
        slug: ampere-integral-cylindrical-symmetry-wire-3-method
        name: LINÉAIRE-3 : Ampère intégral et câbles rectilignes coaxiaux
        order: 1
    -
        slug: ampere-local-cylindrical-symmetry-wire-3-method
        name: LINÉAIRE-3 : Ampère local et câbles rectilignes coaxiaux
        order: 1
    -
        slug: ampere-local-cylindrical-symmetry-solenoid-3-method
        name: LINÉAIRE-3 : Ampère local et solénoïdes
        order: 1
    -
        slug: ampere-integral-cylindrical-symmetry-solenoid-3-method
        name: LINÉAIRE-3 : Ampère intégral et solénoïdes
        order: 1
    -
        slug: ampere-integral-cylindrical-symmetry-toroidal-coil-3-method
        name: LINÉAIRE-3 : Ampère intégral et bobines toriques
        order: 1
    -  
        slug: ampere-integral-demonstration-towards-application
        name: PARALLÈLE-3 : Ampère intégral, démonstration vers application
        order: 2
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-7_L1200.jpg)<details>
<summary>Etape 7 : En test auprès d'étudiants</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------


### Application du théorème d'Ampère


<!-----depuis Gauss, à adapter pour Ampère-------------
    -
        slug: gauss-integral-cylindrical-symmetry-3-method
        name: LINÉAIRE-3 : De Gauss intégral aux charges à symétrie cylindrique
        order: 1
    -
        slug: gauss-local-cylindrical-symmetry-3-method
        name: LINÉAIRE-3 : De Gauss local aux charges à symétrie cylindrique
        order: 1      
    -  
        slug: gauss-integral-demonstration-towards-application
        name: PARALLÈLE-3 : Gauss intégral, démonstration vers application
        order: 2
    -  
        slug: gauss-local-demonstration-towards-application
        name: PARALLÈLE-3 : Gauss local, démonstration vers application
        order: 2
---------------------->

#### Introduction

Dans les cas où il s'applique facilement, le **théorème d'Ampère**, dans sa forme intégrale comme dans sa
forme locale, *remplace des calculs directs* qui seraient *très complexes* à mener.

Pour cela, la **condition** est de *disposer d'un minimum d'informations* préliminaires à l'application du théorème. Il faut connaître :
* la **direction du champ magnétique $`\overrightarrow{B}`$** en tout point $`M`$ de l'espace.
* un **nombre restreint de coordonnées** (une, parfois deux) dont dépend le champ magnétique $`\overrightarrow{B}`$, et **leur identification**.

Ces informations minimales sur le champ magnétique $`\overrightarrow{B}`$,sont 
*extraites de l'étude des invariances et des symétries* de ses causes, c'est à dire de la 
distribution de courants à l'origine de ce champ $`\overrightarrow{B}`$.

<br>
Ainsi, la **première étape**, commune à l'application du théorème d'*Ampère de forme intégrale comme de forme locale*,
est donc l'**étude des symétries et invariances** de la distribution de courants considérée.   

! *Note :*   
! La nécessité de connaître déjà la direction de $`\overrightarrow{B}`$ et d'avoir un champ magnétique qui ne dépend que d'une, voire deux 
! coordonnées, explique que le théorème d'Ampère n'est utilisable pour des distributions de courants présentant un haut degré de symatrie.
! 
! Ces distributions de courants sont essentiellement :
! * des cylindres infinis pleins ou creux, parcourus par des courants dirigés selon l'axe de révolution
!  du cylindre, ou qui s'enroulent circulairement dans les plans perpendiculaires à l'axe de révolution.
! * des plans infinis de toute épaisseur parcourus par des courants unidirectionnels.
! * des bobines toriques à sections quelconques.
! 
! Par contre, le théorème de superposition permet de déterminer le champ magnétique de toute combinaison de ces distributions de courants.

!! *Pour aller plus loin* : *Théorème de Maxwell-Ampère et Électromagnétisme*
!!
!! L'étude du théorème d'Ampère en magnétostatique, à cette étape contrefort, permet de se familiariser avec les concepts,
!! et de calculer le champ magnétique $`\overrightarrow{B}`$ créé par des distributions immobiles de courants stationnaires $`\overrightarrow{j}`$ 
!! hautement invariantes et symétriques.
!!
!! *L'électromagnétisme permettra de calculer le champ électromagnétique $`(\overrightarrow{E}, \overrightarrow{B})`$ 
!! créé par des distributions de charges et de courants $`(\dens, \overrightarrow{j})`$ variables dans le temps*,
!! avec pour apport fondamental un couplage entre les champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ 
!! lorsque ceux-ci varient dans le temps.
!!
!! L'ensemble de *l'électromagnétisme est contenu dans quatre équations* appelées équations *de Maxwell*. Ces quatre équations 
!! fondamentales exprimées sous forme locale, ont aussi une expression intégrale. 
!! 
!! Le théorème d'Ampère ici étudié en magnétostatique, 
!! dans sa forme locale comme dans sa forme intégrale,   
!!
!! $`\vec{rot}\,\vec{B}=\mu_0\,\vec{j}`$   
!!
!! $`\displaystyle\oint\limits_{\Gamma_{or.}}\vec{B}\cdot\vec{dl}
!! =\mu_0\,\iint\limits_{S_{or.}\leftrightarrow \Gamma_{or.}}\vec{j}\cdot\vec{dS}`$   
!!
!! sera en *modifié en électromagnétisme* par un *terme de couplage* entre  les champs
!! $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$, *proportionnel à la dérivée temporelle
!! de $`\overrightarrow{E}`$*.   
!!
!! $`\vec{rot}\,\vec{B}=\mu_0\,\vec{j}\,+\,\mu_0\,\epsilon_0\,\dfrac{\partial \vec{E}}{\partial t}`$   
!!
!! $`\displaystyle\oint\limits_{\Gamma_{or.}}\vec{B}\cdot\vec{dl}`$
!! $`\displaystyle\;=\mu_0\iint\limits_{S_{or.}\leftrightarrow \Gamma_{or.}}\vec{j}\cdot\vec{dS}\,+\,
!! \mu_0\,\epsilon_0\,\dfrac{d}{dt}\iint\limits_{S_{or.}\leftrightarrow \Gamma_{or.}}\vec{E}\cdot\vec{dS}`$   
!!
!! Ce théorème d'Ampère complété s'appellera *théorème de Maxwell-Ampère*.
!!
!! Ce théorème sera l'une des quatre équations de Maxwell, qui unifient en physique classique
!! l'électricité, le magnétisme et l'optique étendue à tout le spectre électromagnétique, révélant
!! de nouveaux aspects précédemment cachés, comme les états de polarisation de la lumière.


<br>

---------------------

#### 1° étape : étude des invariances et symétries

Au cours de cette étude, nous sommes amenés à :
* **choisir le système de coordonnées** le mieux adapté pour décrire la distribution de courants, sinon le nombre
de composantes non nulles du champ  $`\overrightarrow{B}`$ seront toujours au nombre de trois.
* **déterminer les invariances** de la distribution de courants, afin d'identifier le nombre minimum de coordonnées
avec lesquelles $`\overrightarrow{B}`$ varie. 
* **identifier les plans de symétries et/ou d'antisymétries** suffisants pour déterminer la direction de $`\overrightarrow{B}`$,
c'est à dire déterminer la seule composante non nulle de $`\overrightarrow{B}`$.

Reprenons ces 3 points.

##### Choix du repère de l'espace

Ce choix du repère de l'espace **résulte de l'observation** *des invariances et des symétries* de la distribution de courants. 

Mais celles-ci ne peuvent s'exprimer en terme de coordonnées et de vecteurs de base associés avant que ne soit explicitement précisé le repère.

!!!! *Attention* :   
!!!! Vous avez identifié un repère $`(O, \overrightarrow{e_{\alpha}},\overrightarrow{e_{\beta}},\overrightarrow{e_{\gamma}})`$ comme étant bien adapté pour décrire la distribution de courants observée.   
!!!!
!!!! Si vous communiquez votre étude à d'autres (publication, travail en équipe, copie d'examen) il ne suffit pas de nommer le repère choisi. 
!!!!
!!!! *Il faut préciser la position de l'origine $`O`$ du repère et l'orientation des axes* permettant de définir les coordonnées $`(\alpha, \beta, \gamma)`$ et les vecteurs de base associés *en fonction des éléments descriptifs de la distribution*.
!!!
!!!! Sinon vous ne faites aucun couplage entre la distribution de charge observée et le repère de l'espace choisi, et votre étude est alors vide de sens.

!!! *Exemple* : un fil conducteur cylindrique infini parcouru par un courant constant.
!!! 
!!! Le fil cylindrique possède une symétrie de révolution autour d'un axe $`\Delta`$. Si vous choisissez le repère cylindrique $`(O, \overrightarrow{e_{\rho}},\overrightarrow{e_{\varphi}},\overrightarrow{e_z})`$, précisez que l'axe $`Oz`$ est l'axe de révolution $`\Delta`$ du cylindre, l'origine $`O`$ pouvant être situé n'importe-où sur $`\Delta`$.
!!!
!!! Il est souvent plus simple et explicite de se référer à un schéma faisant apparaître la distribution des courants et le repère choisi.


##### Etude des invariances

L'étude des invariances :
   * **identifie les coordonnées dont ne dépend pas $`\overrightarrow{B}`$**.
   * ne donne *aucune information sur la direction de $`\overrightarrow{B}`$*.   
<br>

Soit un *système de coordonnées $`(\alpha, \beta, \gamma)`$*.   
**De façon générale** *et en tout point de l'espace*, l'écriture la plus développée du vecteur champ magnétique s'écrit :

**$`\mathbf{\overrightarrow{B}=B_{\alpha}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\alpha}}
+B_{\beta}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\beta}}}`$**
**$`\mathbf{+B_{\gamma}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\gamma}}}`$**

L'étude des invariances ne s'intéressant pas à la direction de $`\overrightarrow{B}`$, le champ peut s'écrire ici plus simplement :

**$`\mathbf{\overrightarrow{B}=\overrightarrow{B}(\alpha, \beta, \gamma)}`$**


!!!! *Attention* :    
!!!! Une *erreur* souvent observées et *ici barrée*, est d'écrire *pour cette écriture générale* :
!!!!
!!!! *$`\require{cancel}\mathbf{\overrightarrow{B}=\xcancel{B_{\alpha}(\alpha)}\overrightarrow{e_{\alpha}} + \xcancel{B_{\beta}(\beta)}\overrightarrow{e_{\beta}}+\xcancel{B_{\gamma(\gamma)}\overrightarrow{e_{\gamma}}}}`$*
!!!!
!!!! C'est bien sûr faux et la suite de l'étude le sera également.    
!!!! Une composante vectorielle $`B_{\alpha}\;\overrightarrow{e_{\alpha}}`$ peut varier en amplitude $`B_{\alpha}`$ en se déplaçant dans les 3 directions de l'espace. $`B_{\alpha}`$ doit dépendre de façon générale des trois coordonnées $`(\alpha, \beta, \gamma)`$ :
!!!!
!!!! $`\mathbf{B_{\alpha}=B_{\alpha}(\alpha, \beta, \gamma)}`$ est correct.

Une distribution de courants invariante $`\overrightarrow{j}`$ par toute variation d'une coordonnée, par exemple la coordonnée $`\alpha`$, créé un champ magnétique $`\overrightarrow{B}`$ qui ne dépend pas de cette coordonnée $`\alpha`$.

**$`\mathbf{\overrightarrow{j}\,(\xcancel{\alpha},\beta, \gamma) =\overrightarrow{j}\,(\beta,\gamma)}`$**
**$`\mathbf{\quad\Longrightarrow\quad\overrightarrow{B}\,(\xcancel{\alpha},\beta, \gamma)=\overrightarrow{B}\,(\beta, \gamma)}`$**

Si de plus la distribution de courants $`\overrightarrow{j}`$ est invariante par toute variation d'une autre coordonnée, par exemple la coordonnée $`\gamma`$, alors $`\overrightarrow{B}`$ ne dépend pas non plus  de $`\gamma`$.

**$`\require{cancel}\begin{align}\left.
\begin{array}{l}
\overrightarrow{j}\,(\xcancel{\alpha},\beta, \gamma) =\overrightarrow{j}\,(\beta,\gamma) \\
\overrightarrow{j}\,(\alpha,\beta, \xcancel{\gamma}) =\overrightarrow{j}\,(\alpha,\beta)
\end{array}\right\}&\Longrightarrow \boldsymbol{\mathbf{\overrightarrow{j} = \overrightarrow{j} (\beta)}}\\
&\Longrightarrow \boldsymbol{\mathbf{\overrightarrow{B}=\overrightarrow{B}\,(\beta)}}
\end{align}`$**


##### Etude des symétries

L'étude des symétries :
   * **identifie la direction de $`\overrightarrow{B}`$**.
   * ne donne *aucune information sur les composantes dont dépend $`\overrightarrow{B}`$*.

<br>

Le champ magnétique **$`\overrightarrow{B}`$** est un **vecteur axial** (ou pseudo-vecteur). 
Causé par une distribution de courants $`\overrightarrow{j}`$, il est donc :
* *perpendiculaire à tout plan de symétrie* de $`\overrightarrow{j}`$.
* *contenu dans tout plan d'antisymétrie* de  $`\overrightarrow{j}`$.

<br>

La **direction de $`\overrightarrow{B}`$** en un point $`M`$ est donc *déterminée dès la connaissance*
* d'un *plan unique de symétrie* contenant le point $`M`$.
* de *deux plans d'antisymétrie* qui s'interceptent au point $`M`$.

<br>

La méthode pour **déterminer la direction de $`\overrightarrow{B}`$ en tout point de l'espace** 
consiste donc à *considérer un point $`M`$ quelconque* de l'espace, et 
*rechercher les plans de symétrie ou d'antisymétrie qui passe par $`M`$* . 

Soit un *système de coordonnées $`(\alpha, \beta, \gamma)`$*.   
**De façon générale** *et en tout point de l'espace*, l'écriture la plus développée du vecteur champ magnétique s'écrit :

*$`\mathbf{\overrightarrow{B}=B_{\alpha}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\alpha}}
+B_{\beta}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\beta}}}`$*
*$`\mathbf{+B_{\gamma}(\alpha, \beta, \gamma)\;\overrightarrow{e_{\gamma}}}`$*

L'étude des symétries ne s'intéressant pas aux composantes de $`\overrightarrow{B}`$ 
mais seulement à sa direction, le champ peut s'écrire ici plus simplement :

**$`\mathbf{\overrightarrow{B}=B_{\alpha}\;\overrightarrow{e_{\alpha}}
+B_{\beta}\;\overrightarrow{e_{\beta}} +B_{\gamma}\;\overrightarrow{e_{\gamma}}}`$**

Soit un **point $`M`$ quelconque** *de coordonnées $`(\alpha, \beta, \gamma)`$*.

Le regard cherchera d'abord la présence d'un plan de symétrie pour $`\overrightarrow{j}`$ qui contient $`M`$ .
Si un tel plan existe, par exemple le plan $`\mathcal{P}_A`$ qui contient le point $`M`$ et défini par les vecteurs
$`\overrightarrow{e_{\alpha}}`$ et $`\overrightarrow{e_{\gamma}}`$, alors $`\overrightarrow{B}`$ 
est perpendiculaire à ce plan et s'écrit $`\overrightarrow{B}=B_{\beta}\;\overrightarrow{e_{\beta}}`$.

**$`\mathbf{\left.\begin{array}{c}
\overrightarrow{B} \text{ est un vecteur axial } \\
\mathcal{P}_A\,(M, \overrightarrow{e_{\alpha}}, \overrightarrow{e_{\gamma}}) \text{ est plan de symétrie }
\end{array}\right\}}`$
$`\mathbf{\Longrightarrow \overrightarrow{B}=B_{\beta}\overrightarrow{e_{\beta}}}`$**

<!--je ne sais pas si ce cas ci-dessous existe, à vérifier-->
Si n'existe pas de plan de symétrie passant par $`M`$, mais que tout point $`M`$ appartient à deux plans 
d'antisymétrie, par exemples les plans $`\mathcal{P}_{S1}\,(M, \overrightarrow{e_{\alpha}}, \overrightarrow{e_{\beta}})`$
et  $`\mathcal{P}_{S2}\,(M, \overrightarrow{e_{\beta}}, \overrightarrow{e_{\gamma}})`$, alors la direction 
de $`\overrightarrow{B}`$ au point $`M`$ est celle de la droite $`\Delta=(M,\overrightarrow{e_{\beta}})`$
intersection entre ces deux plans. $`\overrightarrow{B}`$ s'écrit alors $`\overrightarrow{B}=B_{\beta}\;\overrightarrow{e_{\beta}}`$.

**$`\mathbf{\left.\begin{array}{c}
\overrightarrow{B} \text{ est un vecteur axial } \\
\mathcal{P}_{S1}\,(M, \overrightarrow{e_{\alpha}}, \overrightarrow{e_{\beta}}) \text{ est plan d'antiymétrie} \\
\mathcal{P}_{S2}\,(M, \overrightarrow{e_{\beta}}, \overrightarrow{e_{\gamma}}) \text{ est plan d'antisymétrie} \\
\end{array}\;\right\}}`$
$`\mathbf{\Longrightarrow \overrightarrow{B}=B_{\beta}\,\overrightarrow{e_{\beta}}}`$**



##### Synthèse de l'étude des invariances et symétries.

Il s'agit de rassembler au sein d'une même écriture les informations obtenues sur l'expression 
du champ magnétique $`\overrightarrow{B}`$ en tout point de l'espace.

Soit un *système de coordonnées $`(\alpha, \beta, \gamma)`$*.   
Si l'étude des invariances de la distribution de courants conduit à $`\overrightarrow{B}=\overrightarrow{B}\,(\alpha)`$
et si l'étude des symétrie de la distribution de courants conduit à $`\overrightarrow{B}=B_{\beta}\,\overrightarrow{e_{\beta}}`$
alors en tout point de l'espace l'expression du champ magnétique se limite à 
$` \overrightarrow{B}=B_{\beta}\,(\alpha)\,\overrightarrow{e_{\beta}}`$.

**$`\mathbf{\left.\begin{array}{l}
\text{Invariances}\Longrightarrow \overrightarrow{B}=\overrightarrow{B}\,(\alpha) \\
\text{Symétries}\;\;\Longrightarrow \overrightarrow{B}=B_{\beta}\,\overrightarrow{e_{\beta}}
\end{array}\;\right\}}`$
$`\mathbf{\,\Longrightarrow\overrightarrow{B}=B_{\beta}\,(\alpha)\,\overrightarrow{e_{\beta}}}`$**








