---
title: Synthèse
routable: false
visible: false
lessons:
    -
        slug: cylindrical-charge-or-current-distributions-integral
        name: PARALLÈLE-3 : Distributions cylindriques de charges et de courants
        order: 2
    -
        slug: ampere-integral-cylindrical-symmetry-wire-3-method
        name: LINÉAIRE-3 : Ampère intégral et câbles rectilignes coaxiaux
        order: 2
    -
        slug: symmetry-axial-vectors-magnetic-field-wire-3
        name: CONCEPT-3 : Symétries, vecteurs axiaux et câbles rectilignes coaxiaux
        order: 2
    - 
        slug: ampere-integral-cylindrical-symmetry-wire-3-mathtool
        name: OUTIL-MATH : Calcul intégral, coordonnées cylindriques et courants rectilignes
        order: 2
     - 
       slug: magnetostatics-wire-direct-ampere-3
       name: PARALLÈLE-3 : Fil-conducteur, direct et Ampère
       order: 3
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oint{\displaystyle\mathop{{\int}\mkern-16mu \scriptsize \bigcirc}}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-7_L1200.jpg)<details>
<summary>Etape 7 : En test auprès d'étudiants</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>



##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------

##### Application du théorème d' **Ampère intégral** aux :


### **Distributions cylindriques de courant**

* Le terme **cylindrique** réfère à l'*aspect extérieur* de la distribution de courant.



#### Propriétés nécessaires au théorème d'Ampère

* Le théorème d'Ampère sera utilisable si une distribution cylindrique de charge possède les deux éléments de symétrie suivants :
   * une *symétrie de révolution*
   * une **symétrie de translation**   
  
  *autour* et **selon** un même axe, *l'axe de révolution*.

<!---------un peu inutile ici---------
! *rappel* : un axe de *révolution* est un axe de *rotation d'ordre infini*.

* La cause du champ $`\overrightarrow{E}`$ (la charge électrique) étant un scalaire, tout plan contenant l'axe de révolution est plan de symétrie pour la charge électrique.
------------------------------------->

<!--ATTENTION : ce qui est ici en commentaire est probablement faux----------
de courant possède les deux éléments de symétrie suivants :
   * une *symétrie de révolution*
   * une **symétrie de translation**   
  
  *autour* et **selon** un même axe, *l'axe de révolution*.

! *rappel* : un axe de *révolution* est un axe de *rotation d'ordre infini*.
--------------------------------------------------------------------------->

#### Y a t-il plusieurs configurations vérifiant ces propriétés ?

* La cause du champ $`\overrightarrow{B}`$ étant vectorielle, *deux configurations de* **courants** sont possibles. Le déplacement des charges peut s'effectuer :
   *  **en direction de l'axe de révolution** : c'est le cas d'un *fil électrique rectiligne* infini parcouru par un courant.   
      $`\Longrightarrow``$ tout plan contenant l'axe de révolution est plan de symétrie pour le courant.

   *  en **tournant circulairement autour de l'axe de révolution** : c'est le cas d'un *solénoïde* infini parcouru par un courant.   
      $`\Longrightarrow`$ tout plan contenant l'axe de révolution est plan d'anti-symétrie pour le courant.

----------------------

#### LES COURANTS SONT DIRIGÉS SELON L'AXE DE RÉVOLUTION <br><br> exemple : un fil conducteur rectiligne infini.

![](magnetostatics-rectiliear-wire-configuration_L1200.jpg)

---------------------

#### Quel système de coordonnées spatiales choisir ?

* Le système de coordonnées *le mieux adapté* est le système de **coordonnées cylindriques
   $`(O,\rho,\varphi,z)`$**, 
   avec **$`Oz =\;`$ axe de révolution**, et où :
   * $`O`$ est le point de l'espace pris comme origine des coordonnées.
   * $`(\rho,\varphi,z)`$ sont les coordonnées cylindriques.
   
  et de repère orthonormé associé le *repère cylindrique $`\mathbf{(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})}`$*.


#### Comment caractériser cette distribution de courant ?

* Dans le cas où la *section droite* du fil conducteur placé sur l'axe $`Oz`$ est *négligée*, le **sens du courant** 
  est simplement *indiqué par une flèche*.   
 _(en magnétostatique, le courant est constant, donc son sens ne varie pas au cours du temps)._

<!---- attention, ce qui est ici caché est faux--- refaire? avec sens choisi sur contour d'Ampère?---
  L'**intensité $`I`$** du courant sera notée *en notation algébrique*, c'est à dire que :
   * **$`I>0`$** si le courant parcourt le fil *vers les z croissants*.
   * **$`I<0`$** si le courant parcourt le fil *vers les z décroissants*.
---------------->


* Dans le cas contraire où la *section droite* est *non négligée*, le courant est décrit par un
 **vecteur densité de courant $`\overrightarrow{j}`$**.
<br>
   * Un *courant dirigé selon l'axe de révolution* implique **$`\overrightarrow{j}=j(\rho,\varphi,z)\,\overrightarrow{e_z}`$**
   * L'*invariance par rotation* d'angle $`\Delta\varphi`$ quelconque impose **$`\require{\cancel} \overrightarrow{j} = \overrightarrow{j}(\rho,\xcancel{\varphi}, z)`$**.   
   * L'*invariance par translation* de longueur $`\Delta z`$ quelconque impose  **$`\require{cancel}\overrightarrow{j}= \overrightarrow{j}(\rho,\varphi, \xcancel{z})`$**.   
<br>
* *Au final*, le vecteur densité volumique de courant **$`\overrightarrow{j}`$** est **dirigé selon $`Oz`$** et **ne dépend que de $`\rho`$** :   
*$`\mathbf{\left.\begin{array}{l}
\overrightarrow{j}=j_z\,\overrightarrow{e_z}\\
\overrightarrow{j}=\overrightarrow{j}\,(\rho, z) \\
\overrightarrow{j}=\overrightarrow{j}\,(\rho, \varphi)
\end{array}\quad\right\}
\,\Longrightarrow}`$* **$`\mathbf{\overrightarrow{j}=j_z(\rho)\,\overrightarrow{e_z}}`$**   

<!---- attention, ce qui est ici caché est faux--- refaire? avec sens choisi sur contour d'Ampère?---
<br>
* Le **signe de $`j_z(\rho)`$** indique le *sens de déplacement* du courant :
   * **$`j_z(\rho)>0`$** si le courant parcourt le fil *vers les z croissants*.
   * **$`j_z(\rho)<0`$** si le courant parcourt le fil *vers les z décroissants*.
--------------------------------------------------->

Image à faire   
_Un cylindre infini est, lorsqu'il est parcourue par un courant réparti uniformément dans son volume, est l'exemple le plus simple de distribution cylindrique de courant._



#### De quelles coordonnées dépend $`\overrightarrow{B}`$ ?

* **L'effet** possède les *invariances de sa cause* :
$`\Longrightarrow`$**$`\mathbf{\overrightarrow{B}}`$** possède les *invariances de $`\overrightarrow{j}`$*

* $`\mathbf{\overrightarrow{j}=\overrightarrow{j}(\rho)\Longrightarrow}`$ **$`\mathbf{\overrightarrow{B}=\overrightarrow{B}(\rho)}`$**


#### Comment déterminer la direction de $`\overrightarrow{B}`$ ?

* *Par l'* **étude des symétries** *de la distribution de courant $`\overrightarrow{j}`$*.   
<br>

![](magnetostat-fil-symetries-direction-B_v2_L1200.gif)   
_Attention, figure à corriger : dans l'expression_ $`\overrightarrow{j}=j_z(r)\,\overrightarrow{e_z}`$ _, remplacer_ $`r`$ _par_ $`\rho`$.

1. Soit un **point $`M(\rho_M\,\varphi_M,z_M)`$ quelconque** de l'espace.
2. Le **plan $`P_1`$** qui contient le point $`M`$ et l'axe $`Oz`$ est *plan de symétrie* pour la distribution de courant.
3. Le champ magnétique **$`\overrightarrow{B}`$ étant un vecteur axial**, en tout point d'un plan de symétrie 
   il est perpendiculaire à ce plan. Le plan de symétrie $`P_1`$ étant déterminé, la
   *direction de $`\overrightarrow{B}`$, selon $`\overrightarrow{e_{\varphi}}`$*, est 
   *totalement déterminée*.
4. _Étape non nécessaire :_    
_Le plan_ $`P_2`$ _qui contient le point $`M`$ et perpendiculaire à l'axe $`Oz`$ est_
 _plan de d'anti-symétrie pour la distribution de courant. En tout point d'un plan_
_d'anti-symétrie, $`\overrightarrow{B}`$ vecteur axial est contenu dans ce plan, ce qui est bien vérifié._   


* De façon plus concise :   
<br>
**En tout point $`M`$** l'espace,   
*$`\left.\begin{array}{l} \overrightarrow{B}\;\text{vecteur axial} \\
P_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_z})\; \text{plan de symétrie}\end{array}\right\}\,\Longrightarrow`$* 
**$`\mathbf{\overrightarrow{B}=B_{\varphi}\,\overrightarrow{e_{\varphi}}}`$**

![](magnetostat-symetries-wire_L1200.jpg)   
<br>

#### Comment s'exprime $`\overrightarrow{B}`$ en tout point de l'espace ?

* Synthèse de l'étude des invariances et symétries de $`\overrightarrow{j}`$ :   
<br>
**En tout point $`M`$** de l'espace,
*$`\left.\begin{array}{l}
\text{Invariances}\Longrightarrow\overrightarrow{B}=\overrightarrow{B}(\rho) \\
\text{Symétries}\Longrightarrow\overrightarrow{B}=B_{\varphi}\,\overrightarrow{e_{\varphi}}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{B}=B_{\varphi}(\rho)\,\overrightarrow{e_{\varphi}}}`$**


#### Y-a-t'il des lieux où $`\overrightarrow{B}`$ est déjà totalement déterminé par les symétries et invariances ?

à faire
cxvxv

#### Quel contour d'Ampère $`\Gamma_A`$ choisir ?

* Le **contour d'Ampère $`\mathbf{\Gamma_A}`$** doit :
   * être une *ligne fermée*.
   * *contenir le point $`M`$* quelconque.
   * permettre un *calcul simple de $`\displaystyle\oint_{\Gamma_A} \overrightarrow{B}\cdot \overrightarrow{dl}`$*.
   
* Que savons nous ? <br>
  Les invariances et symétries $`\Longrightarrow`$*$`\;\overrightarrow{B}=B_{\varphi}(\rho)\,\overrightarrow{e_{\varphi}}`$* 


<br>
![](magnetostatics-wire-ampere-contour_L1200.gif)  
_Attention, figure à corriger : dans l'expression_ $`\overrightarrow{j}=j_z(r)\,\overrightarrow{e_z}`$ _, remplacer_ $`r`$ _par_ $`\rho`$.
<br>

* *Choix de $`\mathbf{\Gamma_A}`$* : **cercle**,
   * inscrit dans le plan qui **contient de point $`M`$** et **perpendiculaire à l'axe $`Oz`$**.
   * de **rayon $`\rho_M`$**, coordonnées du point $`M`$ considéré.


#### Que signifie orienter le contour d'Ampère $`\Gamma_A`$ choisi ?

* orienter signifie **donner un sens "positif" de circulation**, *indiqué par une flèche* sur le contour.

* Ce sens positif **fixe le sens des vecteurs déplacement élémentaire $`\mathbf{\overrightarrow{dl}}`$ ** le long du contour : .   
  <br>
  figure explicative à faire.


#### Le choix de l'orientation est-il important ?

* Ne pas oublier d'**orienter le contour d'Ampère** est *important*.

* Choisir **un sens plutôt que l'autre** n'a *pas d'importance*.   
  <br>
  En effet :   
  * le théorème d'Ampère est une égalité entre 2 membres :   
  $`\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}=\mu_0\,\oiint_{\mathscr{S}_A}\overrightarrow{j}\cdot\overrightarrow{dS}`$
  * Les orientations de $`\overrightarrow{dl}`$ et $`\overrightarrow{dS}`$ sont liées.
  * Changer le sens de $`\overrightarrow{dl}`$ changera aussi le sens de $`\overrightarrow{dS}`$.   
    Cela revient à multiplier par $`-1`$ chaque membre de l'égalité,    
    ce qui ne modifie pas la solution de l'équation.


#### Que vaut la circulation de $`\overrightarrow{B}`$ le long de $`\Gamma_A`$ ?

* Le **signe** devant l'expression finale contenant $`B_{\varphi}(r)`$ *dépend de l'orientation choisie* sur $`\mathbf{\Gamma_A}`$.

* Le sens positif choisi est indiqué par une flèche sur le cercle $`\mathbf{\Gamma_A}`$.

<br>
![](magnetostatics-wire-ampere-sens-contour_L1200.gif)   
<br>

* Si **$`\mathbf{\overrightarrow{dl}=+\,\rho_M\,d\varphi\,\overrightarrow{e_{\varphi}}}`$** :  
 <br>
**$`\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}}`$**   
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{En se rappelant que :}}}`$
 $`\quad\quad\color{blue}{\scriptsize{\quad\text{invariances + symétries }\Longrightarrow \vec{B}=B_{\varphi}(\rho)\,\vec{e_{\varphi}}}}`$   
<br>
$`\quad\quad=\oint_{\varphi=0}^{\varphi=2\pi}\big(B_{\varphi}(\rho_M)\,\overrightarrow{e_{\varphi}}\big)\cdot \big(+\rho_M\,d\varphi\,\overrightarrow{e_{\varphi}}\big)`$    
<br>
$`\displaystyle\quad\quad=\oint_{\varphi=0}^{\varphi=2\pi}B_{\varphi}(\rho_M)\,\rho_M\,\big(\overrightarrow{e_{\varphi}}\cdot \overrightarrow{e_{\varphi}}\big) d\varphi`$      
<br>
$`\displaystyle\quad\quad=\rho_M\,B_{\varphi}(\rho_M)\,\oint_{\varphi=0}^{\varphi=2\pi}d\varphi`$    
<br>
**$`\mathbf{\displaystyle\quad\quad = 2\pi\,\rho_M\, B_{\varphi}(\rho_M)}`$**

<br>
* Si *$`\mathbf{\overrightarrow{dl}=-\,\rho_M\,d\varphi\,\overrightarrow{e_{\varphi}}}`$* :   
<br>
*$`\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}}`$*   
$`\displaystyle\quad\quad=\oint_{\varphi=0}^{\varphi=2\pi}\big(B_{\varphi}(\rho_M)\,\overrightarrow{e_{\varphi}}\big)\cdot \big(-\rho_M\,d\varphi\,\overrightarrow{e_{\varphi}}\big)`$      
<br>
$`\displaystyle\quad\quad=-\oint_{\varphi=0}^{\varphi=2\pi}B_{\varphi}(\rho_M)\,\rho_M\,\big(\overrightarrow{e_{\varphi}}\cdot \overrightarrow{e_{\varphi}}\big) d\varphi`$   
<br>
$`\displaystyle\quad\quad=-\rho_M\,B_{\varphi}(\rho_M)\,\oint_{\varphi=0}^{\varphi=2\pi}d\varphi`$   
<br>
*$`\mathbf{\displaystyle\quad\quad = -\,2\pi\,\rho_M\, B_{\varphi}(\rho_M)}`$*


#### Quelle surface ouverte $`\mathscr{S}_A`$ s'appuyant sur $`\Gamma_A`$ choisir ?

* La **surface d'Ampère $`\mathscr{S}_A`$** doit :
   * être une *surface ouverte s'appuyant sur le contour d'Ampère $`\Gamma_A`$*.
   * permettre un *calcul simple de $`\displaystyle\oiint_{\mathscr{S}_A} \;\overrightarrow{j^{3D}}\cdot \overrightarrow{dS}`$*.

* Que savons nous ? <br>
  La distribution de courant vérifie $`\Longrightarrow`$*$`\;\overrightarrow{j^{3D}}=j^{3D}(\rho)\,\overrightarrow{e_z}`$* 

<br>
![](magnetostatics-wire-ampere-surface_L1200.gif)
<br>
<br>

* *Choix de $`\mathbf{\Gamma_A}`$* : le **disque** *qui s'appuie sur le cercle $`\Gamma_A`$*, donc le disque :
   * contenu dans le plan qui **contient de point $`M`$** et **perpendiculaire à l'axe $`Oz`$**.
   * de **rayon $`\rho_M`$**, coordonnées du point $`M`$ considéré.   
   <br>
   *$`\displaystyle\Longrightarrow\;\forall M\in\mathscr{S}_A\,,\;\overrightarrow{j^{3D}}\cdot \overrightarrow{dS}=\pm\; j^{3D}\,dS`$*   
   ($`+`$ ou $`-`$ selon l'orientation du disque $`\mathscr{S}_A`$).

!!!! *Attention*   
!!!!
!!!! Dans cette distribution de courant,  $`\mathbf{\boldsymbol{\overrightarrow{j^{3D}}=j_z^{3D}(\rho)\,\overrightarrow{e_z}}}`$.   
!!!!
!!!! *Dans l'espression* $`\mathbf{\boldsymbol{\overrightarrow{j^{3D}}\cdot \overrightarrow{dS}=\pm\; j^{3D}\,dS}}`$, *ne pas confondre*
!!!! * $`\mathbf{j^{3D}}`$ : composante de $`\overrightarrow{j^{3D}}`$ selon $`\overrightarrow{e_z}`$ qui peut être positive ou négative selon le sens du courant.    
!!!! *avec*    
!!!! * $`\mathbf{\Vert \,\overrightarrow{j^{3D}} \,\Vert}`$ : norme du vecteur $`\overrightarrow{j^{3D}}`$ qui est toujours positive.


#### Comment orienter $`\mathscr{S}_A`$ ?

* Les **orientations du contour et de la surface** d'Ampère associée sont *couplées par la règle de la main droite*.

* Donc l'orientation du disque $`\mathscr{S}_A`$ dépend de l'orientation choisie sur le cercle $`\Gamma_A`$ ,   



* **$`\mathbf{\overrightarrow{dS}=\,+\,\rho\,d\rho\,d\varphi\,\overrightarrow{e_z}\Longleftrightarrow\overrightarrow{dl}=+\,\rho_M\,d\varphi\,\overrightarrow{e_{\varphi}}}`$**   
  $`d\rho`$ et $`d\varphi`$ représentant des accroissements élémentaires ($`d\rho > 0`$ et $`d\varphi > 0`$).

<br>
![](magnetostatics-wire-ampere-direct-sens-surface_v2_L1200.gif)   
<br>

* *$`\mathbf{\overrightarrow{dS}=\,-\,\rho\,d\rho\,d\varphi\,\overrightarrow{e_z}\Longleftrightarrow\overrightarrow{dl}=\,-\,\rho_M\,d\varphi\,\overrightarrow{e_{\varphi}}}`$*  
  $`d\rho`$ et $`d\varphi`$ représentant des accroissements élémentaires ($`d\rho > 0`$ et $`d\varphi > 0`$).

<br>
![](magnetostatics-wire-ampere-indirect-sens-surface_v2_L1200.jpg)   
<br>

<!-------------------
#### Quelle expression simple du théorème d'Ampère obtient-on alors ?

* En replaçant chacun des deux membres du *théorème d'Ampère*      
<br>
*$`\displaystyle\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}=\mu_0\,\oiint_{S_A}\overrightarrow{j}\cdot\overrightarrow{dS}}`$*   
<br>
par leur expression obtenue pour cette distribution particulière de courant, et quelques soient les orientations choisies pour $`\Gamma_A`$ et $`S_A`$ du moment qu'elles sont reliées par la règle d'orientation de la main droite, **nous obtenons**   
<br>
**$`\displaystyle\mathbf{\boldsymbol{2\pi\,\rho_M\;B_{\varphi}(\rho_M)}}`$** 
*$`\displaystyle\mathbf{\boldsymbol{\; = \mu_0\,\int_{\rho=0}^{\rho_M}\int_{\varphi=0}^{2\pi} j_z(\rho)\,d\varphi\,d\rho}}`$*   
<br>
**$`\quad\quad\quad\quad\quad\quad = \displaystyle\boldsymbol{\mathbf{2\pi\,\mu_0\,\int_{\rho=0}^{\rho_M} j_z(\rho)\,d\rho}}`$**  
<br>
ou si la section droite du fil conducteur rectiligne infini est négligée   
<br>
**$`\mathbf{2\pi\,\rho_M\;B_{\varphi}(\rho_M) = \mu_0\,\overline{I}}`$**   
<br>
avec $`\overline{I}`$ l'intensité du courant, en valeur algébrique, qui parcourt le fil,   
<br>
en sachant que *$`\overrightarrow{B}=B_{\varphi}(\rho_M)\,\overrightarrow{e_{\varphi}}`$* en tout point $`M`$ de l'espace.
--------------------->


#### Comment calculer l'intensité totale traversant $`\mathcal{S}_A`$, puis en déduire $`\overrightarrow{B}`$ ?


* **Les résultats précédents**
   * $`\overrightarrow{B}(\rho,\varphi,z) = B_{\varphi}(\rho)\,\overrightarrow{e_{\varphi}}`$
   * $`\oint_{\Gamma_A} \overrightarrow{B}\cdot\overrightarrow{dl} = \pm \;2\pi\;\rho_M\;B_{\varphi}(\rho_M)`$   
     _le signe_ _$`+\text{ ou }-`$_ _dépendant de l'orientation de_ $`\Gamma_A`$ _choisie_

  sont *communs à toutes les distributions de courants de type $`\overrightarrow{j} = j_z(\rho)\,\overrightarrow{e_z}`$*.

* La **calcul de l'intensité totale à travers $`\mathcal{S}_A`$**, puis **de $`\overrightarrow{B}`$**
  *nécessite de connaître*, selon la description du courant :   
  * la *géométrie de la distribution cylindrique* (cylindre plein, cylindre creux, cylindres coaxiaux comme dans
    un cable coaxial rectiligne, rayons, etc...), et
    le *sens du (des) courant(s)* le(s) traversant, sens donné(s) par une flèche sur un schéma descriptif.
  * l'*expression mathématique pour $`\overrightarrow{j}^{3D}`$* en chaque point de l'espace.
  $`\Longrightarrow`$ *différentes distributions de courants sont étudiées* dans la suite.


##### Calcul de l'intensité totale en valeur algébrique

##### *1* - Le courant est représenté par $`j^{3D}`$

* L'**intensité totale** traversant la surface d'Ampère $`\mathcal{S}_A`$ s'écrit :    
  <br>
  **$`\displaystyle\iint_{\mathcal{S}_A} = \overrightarrow{j}^{3D}\cdot\overrightarrow{dS}`$**

* Dans le cas étudié, $`\overrightarrow{j}=j_z(\rho)\,\overrightarrow{e_z}`$   
$`\Longrightarrow`$ le *sens du courant* dans le solénoïde est donc *donné par le signe de $`j_z(\rho)`$*.

* L'**intensité totale en valeur algébrique** résulte simplement du calcul de 
  $`\iint_{\mathcal{S}_A} \overrightarrow{j}^{3D}\cdot\overrightarrow{dS}`$, en prenant le
  **$`\overrightarrow{dS}`$ correspondant à l'orientation choisie** de $`\mathcal{S}_A`$ :   
  $`\overrightarrow{dS}= +\,\rho\,d\varphi\,d\rho\,\overrightarrow{e_z}`$ _ou_ $`\overrightarrow{dS}= -\,\rho\,d\varphi\,d\rho\,\overrightarrow{e_z}`$. 

##### *2* - Le courant est représenté par $`I`$

* Le *sens de chaque courant* $`I`$ traversant $`\mathcal{S}_A`$ est *indiqué par sa flèche*. 

* Pour un courant d'intensité $`I`$ en valeur absolue,    
  son **intensité en valeur algébrique** est :   
   * **positive $`\overline{I}>0`$** si le courant *I traverse $`\mathcal{S}_A`$ dans le sens de $`\overrightarrow{dS}`$*,
     élément vectoriel de surface au point de traversé.
   * **négative $`\overline{I}<0`$** si le courant *I traverse $`\mathcal{S}_A`$ dans le sens opposé à $`\overrightarrow{dS}`$*.

* L'**intensité totale en valeur algébrique** est la somme des intensités algébriques des courants traversant $`\mathcal{S}_A`$ :   
  **$`\displaystyle\sum_{\mathcal{S}_A}\overline{I}`$**


##### Calcul de $`\overrightarrow{B}`$

* Il *résulte de la synthèse des résultats* précédents.

* L'**égalité entre les deux termes** du théorème d'Ampère *donne la composante $`B`$*
  du champ $`\overrightarrow{B}=B\,\overrightarrow{e_{\varphi}}`$ en tout point de l'espace :
  <br>
  $`\left.\begin{align}
   &\oint_{\mathcal{S}_A}\overrightarrow{B}\cdot\overrightarrow{dl}\color{brown}{=\mu_0\sum\overline{I}}\\
   &\quad\quad\quad\quad OU \\
   &\oint_{\mathcal{S}_A}\overrightarrow{B}\cdot\overrightarrow{dl}\color{brown}{=\mu_0\iint \overrightarrow{j}\cdot\overrightarrow{dS}}\\
  \end{align}
  \right\}`$ **$`\Longrightarrow`$ expression de $`B`$**   
  <br>
  Ne pas oublier le terme $`\mu_0`$.

* L'écriture complète s'écrit **$`\overrightarrow{B}=B\,\overrightarrow{e_{\varphi}}`$** 
  *en remplaçant sa composante $`B`$ par son expression.*

<br>

---------------------------

#### **1 - ** Le fil conducteur rectiligne infini parcouru par un courant constant

* *Objectif d'apprentissage* : C'est le **cas le plus simple** (la section du fil est négligée).   
  La méthode de calcul de $`\overrightarrow{B}`$ utilisant le théorème d'Ampère 
  **peut être comparée avec le calcul direct** de $`\overrightarrow{B}`$ à partir de la loi de Biot et Savard.



##### Description puis modélisation du fil parcouru par un courant $`I`$

* Le **fil** est *rectiligne*, et de *section droite négligeable*.

* Il est traversé par un **courant constant d'intensité $`I`$** dont 
  le *sens* est *indiqué par une flèche* sur le schéma.

* la **longueur $`L`$** du fil est grande devant son rayon (négligé), 
  donc,
  pour le calcul de $`\overrightarrow{B}`$ à l'extérieur du fil, hors effets de bord, 
  le **modèle choisi** est celui d'un *fil de longueur infinie*.


##### Calcul de l'intensité totale traversant $`\mathcal{S}_A`$, puis de $`\overrightarrow{B}`$

* Choisissons l'*orientation* positive du contour d'Ampère $`\Gamma_A`$ comme *indiqué sur la figure*,   
  $`\Longrightarrow\quad\overrightarrow{dl}=+\,\rho\;d\varphi \;\overrightarrow{e_{\varphi}}\quad\text{et}\quad \overrightarrow{dS}=+\,dS\overrightarrow{e_z}`$      
  $`\hspace{2cm}\text{ avec } dz>0 et dS>0`$   
  <br>
  $`\Longrightarrow\quad\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}\,=\,`$ **$`\mathbf{2\pi\;\rho_M\,B_{\varphi}(\rho_M)}`$**
  
* La  surface d'Ampère **$`\mathcal{S}_A`$** est *traversée par fil*.

* *Pour le sens du courant indiqué* sur la figure, l'intensité algébrique du courant 
  dans le fil est   
   **$`\overline{I}=+\,I\quad`$**, avec $`I=|\overline{I}|`$.   
   <br>
   L'*intensité totale* traversant $`\mathcal{S}_A`$ est donc :   
  *$`\displaystyle\sum_{\mathcal{S}_A}\overline{I}= +\,I`$*

* Le *théorème d'Ampère*   
  *$`\displaystyle\mathbf{\oint_{\Gamma_A}\overrightarrow{B}\cdot\overrightarrow{dl}=\mu_O\sum_{\mathcal{S}_A}\overline{I}}`$*   
  <br>
  s'exprime en tout point $`M`$ **à l'extérieur** du fil par    
  **$`\displaystyle\mathbf{2\pi\,\rho_M\,B_{\varphi}(\rho_M) = +\,\mu_0\;I}`$**   
  <br>

* Au final, 
$`\left.\begin{array}{l}
\overrightarrow{B}=B_{\varphi}(\rho)\,\overrightarrow{e_{\varphi}}=B\,\overrightarrow{e_{\varphi}} \\
2\pi\,\rho\,B= \mu_0\,I
\end{array}\right\}
\Longrightarrow`$
**$`\mathbf{\overrightarrow{B}=+\,\dfrac{\mu_0\;I}{2\pi\,\rho}\,\overrightarrow{e_{\varphi}}}`$**   

<br>
  
![](magnetostat-ampere-application-wire-1_L1200.gif)  
  
<br>

 ##### Le choix de l'orientation n'influe pas

* Comme précisé précédemment, le **choix des orientations** de $`\Gamma_A`$ et $`\mathcal{S}_A`$
  (couplées par la règle de la main droite) *ne change pas le calcul* de $`\overrightarrow{B}`$.

* Le choix d'un sens d'**orientation, choix virtuel** dans la pensée de l'observateur pour décrire
  mathématiquement la situation, **ne peut pas modifier la réalité**, qui est le *champ magnétique* 
  *$`\overrightarrow{B}`$ créé par une distribution de courants*.

<br>

![](magnetostat-ampere-application-wire-2_L1200.gif)   

<br>

##### Champ magnétique créé par un fil rectiligne.

* Le *champ magnétique $`\overrightarrow{B}`$* créé par un **fil rectiligne infini** traversé par un **courant constant**
  d'intensité $`I`$ *tourne autour du fil* dans des plans perpendiculaires au fil, et *décroît en $`1/\rho`$* (distance au fil)

* Dans le cas d'un **fil réel de faible rayon de courbure traversé par un courant continu**, les *lignes de champ magnétique* créées par ce fil
  dans son voisinage *s'enroulent autour du fil* et *$`B`$ décroît en $`1/\rho`$*.

<br>

![](magnetostat-ampere-application-wire-3_L1200.gif)   

<br>


------------------------

#### **2 - ** Cylindre infini, parcouru par une densité volumique de courant uniforme $`j^{3D}=j_0\;\overrightarrow{e_z}`$.
à faire

<br>

------------------------

#### **3 - ** Cylindre infini, parcouru par une densité volumique de courant non uniforme.


<br>

------------------------

#### **4 - ** Cylindre creux infini, parcouru par une densité volumique de courant uniforme.

<br>

----------------------

#### **5 - ** Cylindre infini, parcouru par une densité surfacique de courant uniforme.






