---
title: Définir les outils mathématiques de niveau 3 : proposition 1
published: true
routable: true
visible: false
lessons:
    - slug: define-234-mathematical-tools-p1
      order: 2
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\oint{\displaystyle\mathop{{\int}\mkern-16mu \scriptsize \bigcirc}}`$

#### Proposition 1

--------------------------------------------------------

#### Définir les outils mathématiques requis au niveau 3

--------------------------------------------------------

avec une **première classification pour ordonner un peu** le brainstorming (numération, géométrie, etc).
Elle *ne présage pas des titres de chapitres*.

N'hésitez pas à créer une nouvelle classification si nécessaire.

-------------------------------------------------------------


Les *outils mathémétiques de niveaux 1 et 2* **$`+`$** :

<!------------------------------------------------------------------------------
  NUMERATION, OPERATIONS ET FONCTIONS USUELLES
------------------------------------------------------------------------------->
! *Numération, opérations et fonction usuelles*

* nombre imaginaire **$`i`$**   
  Ensemble des nombres imaginaires purs *$`\mathbb{I}`$* : **$`c=i\,b`$**
  Ensemble des nombres complexes $`\mathbb{C}`$ : 
  **$`c=a+i\,b= |c|\,e^{\,i\,\theta}`$**, avec $`|c|=\sqrt{a^2 + b^2}`$ et $`\theta\arctan{b/a}`$   
  **$`c=a+i\,b= \mathcal{Re}(c)+i\,\mathcal{Im}(c)`$**

* fonction puissance $`y^x`$ 
* fonction exponentielle **$`e^x`$**    
  Euler **$`e^{\,i\theta}=\cos\theta+ i\sin\theta`$**       
  **$`\cos\theta=\dfrac{e^{\,i\theta}+e^{\,-i\theta}}{2}`$**     
  ** $`\sin\theta=\dfrac{e^{\,i\theta}-e^{\,-i\theta}}{2i}`$**

* **$`e^0=1 \quad , \quad`$**
**$`e^{\,i\frac{\pi}{2}}=i\quad , \quad`$**
**$`e^{\,i\pi}=-1\quad , \quad`$**, ...

* fonction logatithme **$`log_p\,x`$**   
  propriétés fonction log, dont transformation produit en somme : **$`log_p\,xy`=log_p\,x+log_p\,y$** 
  fonction logatithme **$`log_{10}\,x`$** en relation à la fonction puissance $`10^x`$   
  fonction logatithme népérien **$`Log\,x=ln\,x`$** en relation à la fonction puissance $`exp(x)=e^x`$  

* notations réelle et notation complexe : 
**$`\overrightarrow{U}=U_0\,\cos(k\,x-\omega t+\varphi)\overrightarrow{e}`$**   
**$`\overrightarrow{\underline{U}}=U_0\,e^{\,i\,(k\,x-\omega t+\varphi)}\overrightarrow{e}`$**
**$`\;=\underline{U_0}\,e^{\,i\,(k\,x-\omega t)}\overrightarrow{e}`$**       
**$`\overrightarrow{U}=\mathcal{Re}(\overrightarrow{\underline{U}})`$**

<!------------------------------------------------------------------------------
  ENSEMBLES  ET  LOGIQUE
------------------------------------------------------------------------------->
! *Ensembles et logique*



<!------------------------------------------------------------------------------
  GÉOMÉTRIE  ET  COORDONNÉES
------------------------------------------------------------------------------->
! *Géométrie et coordonnées*

* Règle d'*orientation de l'espace*   
  Systèmes de coordonnées, bases et repères *directs ou indirect*

* *Coordonnées, bases vectorielles et repères* associées   
  bases et repères *orthogonaux, normés, orthonormés, directs et indirects*

* *Coordonnées cartésiennes, cylindriques et sphériques*   
  * avec *repères et bases associés*    
  * *éléments infinitésimaux* de longueur, de surface, de volume    
  * expressions des *opérateurs* **$`\overrightarrow{grad}`$**, **$`div`$** et **$`\overrightarrow{rot}`$**
  
* *matrice changement de base orthonormée directe* :   
  * $`\overrightarrow{e_i}\longrightarrow \overrightarrow{e_j}'`$ : $`(a)`$
  * $`\overrightarrow{e_j}'\longrightarrow \overrightarrow{e_i}'`$ : **$`(a')=(a)^t = (a)^{-1}`$**

<!------------------------------------------------------------------------------
  VECTEURS, OPERATEURS ET ANALYSE VECTORIELLE
------------------------------------------------------------------------------->
! *Vecteurs et opérateurs, analyse vectorielle*

* Produit vectoriel **$`\overrightarrow{a}\wedge\overrightarrow{b}`$** (notation $`\wedge`$ ou $`\times`$ )
* Produit mixte **$`(\overrightarrow{a},\overrightarrow{b},\overrightarrow{c})`$**

* Opérateurs **$`\overrightarrow{grad}`$**, **$`div`$** et **$`\overrightarrow{rot}`$** (notation $`\overrightarrow{rot}`$ ou $`\overrightarrow{curl}`$ )
  et notation avec nabla (coordonnées cartésiennes) :
  **$`\overrightarrow{\nabla}=\dfrac{\partial}{\partial x}\overrightarrow{e_x}+\dfrac{\partial}{\partial y}
  \overrightarrow{e_y}\dfrac{\partial}{\partial z}\overrightarrow{e_z}`$**

* Opérateurs Laplacien scalaire (coordonnées cartésiennes)
 **$`\Delta=\dfrac{\partial^2}{\partial x^2}+\dfrac{\partial^2}{\partial y^2}+\dfrac{\partial^2}{\partial z^2}`$** 
 **$`\;=\overrightarrow{\nabla}\cdot\overrightarrow{\nabla}`$**

* Opérateur d'Alembertien scalaire (coordonnées cartésiennes)
*  **$`\Box=\Delta-\dfrac{1}{c^2}\dfrac{\delta^2}{\delta t^2}`$** (pour les ondes)

* 

<!------------------------------------------------------------------------------
MATRICES
------------------------------------------------------------------------------->
! *Matrices*

* Matrices $`(n,m)`$ : **$`\begin{pmatrix} a_{11} & \ldots & a_{1m} \\ \vdots & \ddots & \vdots \\ a_{n1} & \ldots & a_{nm}\\ \end{pmatrix}`$**
* Matrice transposée d'une matrice carrée
* Calcul matriciel
* Déterminant d'une matrice carrée : 
  **$`\begin{vmatrix} a_{11} & \ldots & a_{1n} \\ \vdots & \ddots & \vdots \\ a_{n1} & \ldots & a_{nn}\\ \end{vmatrix}`$**  


<!------------------------------------------------------------------------------
  FONCTIONS - CALCUL DIFFERENTIEL ET INTEGRAL
------------------------------------------------------------------------------->
! *Étude de fonctions*

* Passage de la notation $`f'(x_0)`$ à $`\left.\dfrac{df}{dx}\right|_{x_0}`$
  Passage de la notation $`f'(x)`$ à $`\dfrac{df}{dx}`$
  ...
  de $`f^{n}(x_0)`$ à $`\left.\dfrac{d^{n}f}{dx^{n}}\right|_{x_0}`$ 
  de $`f^{n}(x)`$ à $`\dfrac{d^{n}f}{dx^{n}}`$ 

* fonction dérivée et fonction primitive.

* intégrale simple 
  * indéfinie $`\displaystyle\int f(x)\,dx`$
  * définie $`\displaystyle\int_{x_1}^{x_2} f(x)\,dx`$

* intégrale multiple (variables indépendantes)
  *  $`\displaystyle\iint f(x,y)\,dxdy)`$
  *  $`\displaystyle\iiint f(x,y,z)\,dxdydz)`$

* différence entre :
  *  $`\displaystyle\int f(x)\,dx)`$ et $`\oint f(x)\,dxd`$
  *  $`\displaystyle\iint f(x,y}\,dxdy)`$ et $`\oiint f(x,y}\,dxdy)`$

<!------------------------------------------------------------------------------
  ÉQUATIONS
------------------------------------------------------------------------------->
! *Équations*

* *Résolution de systèmes d'équations* par la *méthode du déterminant*.

