---
title: Collecte éléments de "Ensembles"
published: true
routable: true
visible: false
---

### Colecta de elementos de cursos / Collecte d'éléments de cours / Collecting course items

!!!! *Colecta de elementos de cursos / Collecte d'éléments de cours / Collecting course items*
!!!! 
!!!! No publique, no haga visible.    
!!!! Ne pas publier, ne pas rendre visible.   
!!!! Do not publish, do not make visible.   

---------

Les ensembles au niveau 3, main

--------------------------------------

### Les ensembles

-------------------------------------

### L'inclusion et l'égalité

##### Définition de l'inclusion

Soient **$`\mathbf{E}`$ et $`\mathbf{F}`$ deux ensembles**.

L'ensemble *$`\mathbf{E}`$* est une partie ou un *sous-ensemble de $`\mathbf{F}`$* si et seulement si *tous les éléments de  $`\mathbf{E}`$  sont élements de $`\mathbf{F}`$*, et je dis alors que **$`\mathbf{E}`$ est inclus dans $`\mathbf{F}`$** ou de façon équivalente que **$`\mathbf{F}`$ contient $`\mathbf{E}`$**   
ce que j'écris en écriture mathématique :
* avec le *symbole d'inclusion $`\subset`$*. 
     <br>**$`\mathbf{\big(\,E \subset F\,\big) \iff \big (\,\forall x \;,\; x\in E \Longrightarrow x\in F\,\big)}`$**
* avec le *symbole de contenance $`\supset`$*. 
     <br>**$`\mathbf{\big(\,F \supset E\,\big) \iff \big (\,\forall x \;,\; x\in E \Longrightarrow x\in F\,\big)}`$**

Si au moins *un élément de $`\mathbf{E}`$ n'est pas un élément de $`\mathbf{F}`$*, alors je dis que **$`\mathbf{E}`$ n'est inclus pas dans $`\mathbf{F}`$** ou de façon équivalente que **$`\mathbf{F}`$ ne contient pas $`\mathbf{E}`$**,    
ce que j'écris en écriture mathématique :
* avec le *symbole de non inclusion $`\not\subset`$*. 
     <br>**$`\mathbf{\big(\,E \not\subset F\,\big) \iff \big(\,\exists x \;,\; x\in E \land x\not\in F\,\big)}`$**
* avec le *symbole de contenance $`\not\supset`$*. 
     <br>**$`\mathbf{\big(\,F \not\supset E\,\big) \iff \big(\,\exists x \;,\; x\in E \land x\not\in F\,\big)}`$**

! *Remarque :*   
! Pour démontrer $`E \subset F`$, je dois démontrer l'implication $`\big(\,E \subset F\,\big) \iff \big (\,\forall x \;,\; x\in E \Longrightarrow  x\in F\,\big)`$.   
! Je dois donc écrire "Soit $`x\in E`$", puis démontrer que $`x\in F`$.   
!
! <details markdown=1>
! <summary>
!  Pour démontrer que E n'est pas inclus dans F,  je dois ...
!  </summary>
!  démontrer l'implication    $`\exists x \;,\; x\in E \land x\not\in F`$.    
! Je dois donc écrire "Il existe $`x\in E`$", puis démontrer qu'il existe au moins un élément de $`E`$ qui n'est pas élément de $`F`$.
! </details>

!!! *Exemples :*  
!!! * $`\mathbb{N} \subset \mathbb{Z}  \subset \mathbb{Q}  \subset \mathbb{R} `$
!!! * $`\{3\} \subset \mathbb{N}`$
!!! * $`\{-1\,,6\} \subset \mathbb{Z}`$
!!! * $`\{\sqrt{2}\,,0\} \not\subset \mathbb{Q}`$

##### Définition de l'égalité

Les deux ensembles **$`E`$ et $`F`$ sont égaux** si et seulement si :   
* *tout élément de $`E`$ est élément de $`F`$* et *tout élément de $`F`$ est élément de $`E`$*,    
ce qui s'écrit en écriture mathématique :   
**$`\mathbf{\big(\,E=F\,\big) \Longleftrightarrow\big(\,\forall x \;,\; x\in E \Longleftrightarrow  x\in F\,\big)}`$**   

ce qui est équivalent à dire

* *$`E`$ est inclus dans $`F`$* et *$`F`$ est inclus dans $`E`$*,    
ce qui s'écrit en écriture mathématique :   
**$`\mathbf{\big(\,E=F\,\big) \Longleftrightarrow\big(\,E \subset F \land F \subset E\,\big)}`$**   

! *Remarque :*    
! Pour montrrer que deux ensembles $`E`$ et $`F`$ sont égaux, je dois démontrer pour tout $`x`$ l'équivalence $`(x \in E \iff x \in F)`$.   
! Je pose donc un $`x`$ quelconque, puis    
! * *soit* je raisonne directement par équivalence et montre que *$`(x \in E \iff x \in F)`$*.
! * *soit* je démontre deux implications, c'est à dire une double inclusion :   
! \- *d'abord* je montre que $`(E \subset F)`$,    
! c'est à dire que *si $`x\in E`$ alors $`x\in F`$*    
! \- *puis* je montre que $`(F \subset E)`$,   
! c'est à dire que *si $`x\in F`$ alorsS $`x\in E`$*.

!!! *Exemple :*    
!!! _il faut développer complètement un exemple ici_.  
!!! _Les travaux personnels de l'apprenant seront mis dans la partie "au-delà" de ce cours, avec pour certains dans un menu déroulant, d'abord des indices, puis une solution._

!!!! *Attention :*.  
!!!! *Ne pas confondre $`\in`$ et $`\subset`$*.   
!!!! Si $`x`$ est un élément, et $`E\,,F\,,G`$ des ensembles, je peux avoir $`x\in E`$ et $`F\subset G`$.   
!!!!
!!!! *Un élément peut être considéré comme un ensemble*.   
!!!! Par exemple :   
!!!! * une droite est un ensemble de points.
!!!! * une droite est aussi un élément de l'ensemble des droites du plan qui le contient.

##### Transitivité de l'inclusion

Soit **$`\mathbf{E}`$ un ensemble**,   
et soient **$`\mathbf{A\,,B\,,C}`$ trois sous-ensembles** (ou parties) de $`\mathbf{E}`$.

La **transitivité de l'inclusion** exprime le fait que    
si *$`\mathbf{A}`$ est inclus dans $`\mathbf{B}`$*, et que ce même *$`\mathbf{B}`$ est inclus dans $`\mathbf{C}`$, alors* je peux dire avec certitude que *$`\mathbf{A}`$ est inclus dans $`\mathbf{C}`$*,    
ce qui s'écrit en écriture mathématique :    
**$`\mathbf{\big[\,\big(\,A \subset B\,\big) \land \big(\,B \subset C\,\big)\,\big] \iff \big(\,A \subset C\,\big)}`$**

*Démonstration*

Je pars de l'hypothèse que $`\,A \subset B`$ et que $`\,B \subset C`$, et je dois prouver que $`\,A \subset C`$.  

Comme $`A`$ est inclus dans $`B`$, alors tout élément de $`A`$ est élément de $`B`$ :    
$`\big(\,\,A \subset B\,\big) \Longrightarrow \big(\,\forall x\;,\; x\in A \Longrightarrow x\in B\,\big)`$.   
<br>
De même  l'inclusion de $`B`$ dans $`C`$ implique que tout élément de $`B`$ est élément de $`C`$ :  
$`\big(\,\,B \subset C\,\big) \Longrightarrow \big(\,\forall x\;,\; x\in B \Longrightarrow x\in C\,\big)`$.  
<br>
Ceci me permet de dire qu'alors tout élément de $`A`$ est élément de $`C`$,   
_Comment écrire cela correctement ?_       

$`\left.
\begin{array}{l}
\forall x\;,\; x\in A \Longrightarrow  x\in B \\
\quad\;\;\; x\in B \Longrightarrow  x\in C
\end{array}
\right\}\Longrightarrow x\in A \Longrightarrow  x\in C`$

$`\forall x\;,`$    
$`\left.
\begin{array}{l}
\big(\, x\in A \Longrightarrow  x\in B\,\big) \\
\big(\,x\in B \Longrightarrow  x\in C\,\big)
\end{array}\right\}\Longrightarrow \big(\, x\in A \Longrightarrow  x\in C\,\big)`$

$`\forall x\;,`$    
$`\left.
\begin{array}{c}
\big(\, x\in A \Longrightarrow  x\in B\,\big) \\
\land \\
\big(\,x\in B \Longrightarrow  x\in C\,\big)
\end{array}
\right\}\Longrightarrow \big(\, x\in A \Longrightarrow  x\in C\,\big)`$

$`\forall x\;,`$ $`\;\big[\big(\, x\in A \Longrightarrow  x\in B\,\big) \land \big(\,x\in B \Longrightarrow  x\in C\,\big)\big]`$ 
$`\Longrightarrow \big(\, x\in A \Longrightarrow  x\in C\,\big)`$   
<br>
Ce qui prouve la transitivité de l'inclusion :    
$`\big[\,\big(\,A \subset B\,\big) \land \big(\,B \subset C\,\big)\,\big] \iff \big(\,A \subset C\,\big)`$

##### Transitivité de l'égalité

Soit **$`\mathbf{E}`$ un ensemble**,   
et soient **$`\mathbf{A\,,B\,,C}`$ trois sous-ensembles** (ou parties) de $`\mathbf{E}`$.

La **transitivité de l'égalité** exprime le fait que    
si *$`\mathbf{A=B}`$ et si $`\mathbf{B=C}`$, alors *$`\mathbf{A=C}`$*,    
ce qui s'écrit en écriture mathématique :    
**$`\mathbf{\big[\,\big(\,A = B\,\big) \land \big(\,B = C\,\big)\,\big] \iff \big(\,A = C\,\big)}`$**

*Démonstration*

Je pars de l'hypothèse que $`A = B`$ et $`B = C`$.   
Par définition j'ai  $`A \subset B`$ et $`B \subset C`$, et la transitivité de l'inclusion implique $`A \subset C`$.   
De même, $`B \subset A`$ et $`C \subset A`$ impliquent $`C \subset A`$.
Il en résulte que $`A = C`$.

------------------------------------------------

### Opération sur les parties de $`E`$

#### Le complémentaire d'un ensemble $`E`$

##### Définition 

Soit $`E`$ un ensemble, et $`A`$ un sous-ensemble de $`E`$.   
Le **complémentaire de $`A`$ dans $`E`$**, noté **$`\mathbf{\complement_E A}`$**, est l'*ensemble des éléments de $`E`$ qui n'appartiennent pas à $`A`$* :   

**$`\mathbf{\complement_E A=\{x\in E\,,\, x \notin A\}}`$**

! *Remarques :* 
!
! * $`\complement_E A`$ est un sous-ensemble de $`E`$.   
!
! * *$`\mathbf{\complement_E A}`$* peut aussi se noter *$`\mathbf{\overline{A}}`$* ou *$`\mathbf{A^c}`$* lorsque l'ensemble $`E`$ sur lequel la complémentarité s'applique est bien spécifié avant, et qu'il n'y a pas d'autre risque de confusion.

!!! *Exemple :*     
!!! Soient $`E=\{1\,,2\,,3\,,4\,,5\} \;,\; A=\{1\,,3\}\subset E  \;,\; B=\{2\,,4\,,5\}\subset E`$.   
!!! Nous avons :    
!!! $`\complement_E A=\{2\,,4\,,5\}=B`$.  
!!! $`\complement_E A\,(\complement_E A) =\{1\,,3\}=A`$.  
!!! $`\complement_E B=\{1\,,3\}=A`$.  
!!! $`A+\complement_E A) =E`$    
!!! $`B+\complement_E B) =E`$

*Proposition*

Soient un ensemble $`E`$, et $`A`$ et $`B`$ deux sous-ensembles de $`E`$.
Les deux assertions suivantes sont vraies :


##### Le complémentaire du complémentaire 





#### L'ensemble vide

##### Existence de ensemble vide

*Théorème*


*Démonstration*

! *Remarques :*    
!     ....



### Intersection, Union


### Produit cartésien



### Famille d'éléments et partition d'un ensemble

