---
title: Les équations de Maxwell
published: false
routable: false
visible: false
lessons:
    - slug: maxwell-equations
      name: LINÉAIRE - Les équations de Maxwell
      order: 1
---

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

Attention !!! En période d'élaboration et de construction !

<!--MétaDonnée : ... -->

<!--caligraphie de l'intégrale double curviligne-->
$`\def\speed{\mathscr{v}}`$
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\soiint{\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

##### Randonnée montagne :&nbsp; _physique_

---------------------------

### Les équations de Maxwell

#### Génèse des équations de Maxwell.

À écrire.   
Dire : travail de synthèse des résultats expérimentaux...   
Au terme d'un long processus, 4 équations postulées et donc non démontrées.
Rendent compte de tous les phénomènes électriques et magnétiques observés,...
etc...

------------------------------------

#### Les 4 équations de Maxwell

<!----
$`\left \{
   \begin{array}{r c l}
      AB  & = & 192 \\
      C   & = & 5\,896 \\
      DEF & = & 0,5
   \end{array}
   \right.`$
   
   

$`\left \{
   \begin{array}{r c l}
      \text{ÉlectroStatique}  & \; & \text{Maxwell's equations} \\
      \text{cause :}\; \rho \longrightarrow \text{effet :}\overrightarrow{E} & \; & \\
      \text{cond. validité :}\; \rho=0& \; & \\
      div \overrightarrow{E} = \dfrac{\rho}{\epsilon_0}  & \; & div \overrightarrow{E} = \dfrac{\rho}{\epsilon_0} \\
      \overrightarrow{rot} \;\overrightarrow{E} =0 & \; & \overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}
   \end{array}
   \right.`$--->

##### Les équations locales 

<!----------
IL FAUDRAIT PRENDRE L4HABITUDE DE DIRE "LOI" ET NON "EQUATION", CAR   
UNE EQUATION EST UNE EGALITE ENTRE DEUX TERMES, QUI PEUT-ËTRE VRAIE OU FAUSSE.   
UNE LOI EST UNE EGALITE ENTRE ENTRE DEUX TERMES QUI EST CONSIDEREE COMME VRAIE.   
C'EST IMPORTANT !!!   
EN LOGIQUE, ON APPRENDRA ET METTRA EN EVIDENCE QU'UNE EQUATION PEUT ËTRE VRAIE OU FAUSSE,   
ET IL EST IMPORTANT QUE L'APPRENANT, LORSQU'IL VERRA UNE EQUATION, SE POSE TOUJOURS LA QUESTION
DE SA VERICITE.
A METTRE EN APPLICATION DANS TOUT M3P2 DES QUE POSSIBLE;
--------------->

Les équations locales de Maxwell sont les plus importantes. Elles relient les propriétés locales de divergence
et de rotationnel du champ électromagnétique $`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`$ à des causes purement locales, 
la densité volumique de charge $`\dens`$ et le vecteur densité volumique de courant $`\overrightarrow{j}`$ au point considéré.
Elles sont vraies en tout point de l'espace et à tout instant.

Les expressions de divergence des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ restent inchangées par rapport à leurs expressions en champs statiques.   
Ainsi :

* $`div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}\quad`$  (éq. Maxwell-Gauss)   
   Le théorème de Gauss établi en électrostatique reste vrai dans le cadre de l'électromagnétisme, et prend le nom de théorème de Maxwell-Gauss.

* $`div \overrightarrow{B} = 0\quad`$  (éq. Maxwell-flux)   
  ...    

Les expressions de rotationnel des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ sont modifiées 
par rapport aux cas statiques. Chacune d'elle couple les champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$.
Elles fondent les propriétés du champs électromagnétique $`(\overrightarrow{E}\,,\,\overrightarrow{B})`$.

* $`\overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}\quad`$  (éq. Maxwell Faraday),    
Équation de Maxwell-Faraday qui montre qu'un champ électrique résulte d'un champ magnétique variable dans le temps.

* $`\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} +
\mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\quad`$  (éq. Maxwell-Ampère),   
Équation de Maxwell-Ampère qui montre qu'un champ magnétique résulte d'un champ électrique variable dans le temps.

Dans ces équations,    
*   $`\dens`$ est la densité volumique de charge. 
*   $`\overrightarrow{j}`$ est le vecteur densité volumique de courant. 

! *Note :*   
! Dans l'équation de Maxwell-Ampère, $`\overrightarrow{j}`$ est le vecteur densité 
! volumique de courant, qui correspond à un courant élémentaire $`dI`$ réel à travers un vecteur
! surface élémentaire $`\overrightarrow{dS}`$ au point considéré : $`dI=\overrightarrow{j}\cdot\overrightarrow{dS}`$.   
! 
! Je remarque que le terme *$`\mathbf{\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$* 
! est *homogène à un vecteur densité volumique de courant.*   
!
! De ce fait il est ainsi souvent dénommé vecteur densité volumique de *courant de déplacement*
! de notation $`\mathbf{\overrightarrow{j}_{dépl}}`$*$`=\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$* .
! 
! Avec cette dénomination, l'équation de Maxwell-Ampère peut se réécrire :   
!
! $`\mathbf{\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\big(\overrightarrow{j} +\overrightarrow{j}_{dépl}\big)}`$
<!---------------
!! *Pour aller plus loin:*   
!! Cette remarque, que $`\rho=\rho_{totale}`$ et $`\overrightarrow{j}\overrightarrow{j}_{total}`$ prendra toute sont importance dans l'étude des équation de Maxwell dans les mieux matériels. En effet :   
!! À la densité volumique de charge libre...
------------------>

##### Les équations intégrales

à modifer, compléter et terminer.

<!--
#### Ecuaciones de Maxwell en forma integral / Equations de Maxwell intégrales / ...

$`\displaystyle\oiint_S\overrightarrow{E}\cdot\overrightarrow{dS}=\dfrac{Q_{int}}{\epsilon_0}`$
$`=\dfrac{1}{\epsilon_0} \cdot \displaystyle\iiint_{\tau\leftrightarrow S} \rho \cdot d\tau`$

$`\displaystyle\oiint_S\overrightarrow{B}\cdot\overrightarrow{dS}=0`$

*[ELECMAG4-20]*

[ES] (auto-trad) *Ley de Gauss = teorema de Gauss* <br>
[FR] (CME)  *Théorème de Gauss* <br>
[EN] (auto-trad) *Gauss' theorem* <br>
----------------->

__Équation de Maxwell-Gauss__

$`\displaystyle\iiint_{\tau} div\overrightarrow{E} \cdot d\tau= \displaystyle\iiint_{\tau}
\dfrac{\dens}{\epsilon_0} \cdot d\tau`$$`\; = \dfrac{1}{\epsilon_0} \cdot \iiint_{\tau} \dens 
\cdot d\tau`$$`\;  = \dfrac{Q_{int}}{\epsilon_0} `$

<!--------------------
[ES] <br>
[FR] (CME) Théorème d'Ostrogradsky = théorème de la divergence :<br>
[EN] Ostrogradsky’s theorem = divergence theorem : for all vectorial field :<br>
-------------------->


$`\vec{X}`$, $`\displaystyle\iiint_{\tau} div\;\overrightarrow{X} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\tau} \overrightarrow{X}\cdot\overrightarrow{dS}`$

$`\displaystyle\iiint_{\tau} div\;\overrightarrow{E} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS} = \Phi_E`$

<!-------------------------
[ES] (auto-trad) Flujo eléctrico : <br>
[FR] (CME) Flux du vecteur champ électrique : $`\Phi_E`$ <br>
[EN] (auto-trad) : <br>
----------------------------->

$`\Phi_E = \displaystyle \oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS}
= \dfrac{1}{\epsilon_0} \cdot \iiint_{\tau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0} `$


<!------------------------------
*[ELECMAG4-20]*

[ES] (auto-trad) *Ley de Faraday* <br>
[FR] (CME)  *Loi de Faraday* <br>
[EN] (auto-trad)  <br>
----------------------------->

<br><br>__Équation de Maxwell-Faraday__

$`\displaystyle\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot \overrightarrow{dS}
= -\displaystyle\iint_{S \leftrightarrow \tau} \dfrac{\partial \overrightarrow{B}}{\partial t}\cdot \overrightarrow{dS}`$

<!----------------------
[ES] (auto-trad) Mecánica newtoniana : espacio y el tiempo son desacoplados $`\Longrightarrow`$ orden de integración
/ derivación entre variables de espacio y tiempo no importa.<br>
[FR](CME) Mécanique newtonienne : espace et temps sont découplés $`\Longrightarrow`$ l'ordre d'intégration / différenciation entre 
variables d'espace et de temps n'importe pas.<br>
[EN](auto-trad)
---------------------->

En mécanique newtonnienne, l'espace et le temps sont découplés. Ainsi l'ordre d'intégration / différenciation entre 
variables d'espace et de temps n'importe pas, et je peux écire :

$`\displaystyle\iint_S \overrightarrow{rot}\,\overrightarrow{E}\cdot \overrightarrow{dS}`$ 
$`\;= - \dfrac{\partial}{\partial t} \left( \displaystyle\iint_S \overrightarrow{B}\cdot \overrightarrow{dS}\right)`$

<!-----------------------------------------
[ES] (auto-trad) :<br>
[FR] (CME) Théorème de Stokes = théorème du rotationnel : pour tout champ vectoriel $`\vec{X}`$ :<br>
[EN] (auto-trad) Stokes' theorem  : for all vectorial field $`\vec{X}`$ :<br>
------------------------------------------>

Pour faire apparaître directement le champ électrique $`\overrightarrow{E}`$ et non sa propriété locale 
$`\overrightarrow{rot}\,\overrightarrow{E}`$, je peux utiliser le théorème de Stoke

$`\displaystyle\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{X} \cdot dS 
= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$.

Appliqué au champ électrique, il donne :

$`\displaystyle\iint_{S} \overrightarrow{rot} \,\overrightarrow{E}\cdot \overrightarrow{dS}`$
$`\;= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}`$

J'y reconnais la circulation d'un champ électrique $`{C}_E`$, la grandeur physique associée est une tension.   
L'équation de Maxwell-Faraday s'exprime finalement :

$`\displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}`$
$`\;= - \dfrac{\partial}{\partial t} \left( \displaystyle\iint_S \overrightarrow{B}\cdot \overrightarrow{dS}\right)`$
$`\; = - \dfrac{\partial \Phi_B}{\partial t}=\mathcal{C}_E\quad\text(tension)`$ 

<!----------------------------
[ES] (auto-trad) :<br>
[FR] (CME) Théorème d'Ostrogradsky = théorème de la divergence : pour tout champ vectoriel $`\vec{X}`$ :<br>
[EN] (auto-trad) Ostrogradsky’s theorem = divergence theorem : for all vectorial field $`\vec{X}`$ :<br>
----------------------------->

<br><br>__Équation de Maxwell-flux__

...

<br><br>__Équation de Maxwell-Ampère__


--------------------------------

#### Équations de Maxwell et champ électromagnétique

à faire... sera court, ou alors à supprimer.
Juste faire remarquer que les équations de Maxwell-Farady et Maxwell-Ampère sont
des équations qui couplent E et B. Que B variable implique E variable et que E variable
implique B variable. Que la force percu par une particule chargée en mouvement est la
force de Lorentz qui implique à la fois E et B.

Il n'y a donc ni sens ni utilité à considérer un champ de façon individuelle, seul
le couple de champ (E,B) est signifiant, d'où le concept de champ électromagnétique.

Et pour aller plus loin dans un apparté vert, faire remarquer que :
les causes de B étant un élément de courant $`\overrightarrow{j}\,d\tau`$ et
comme $`\overrightarrow{j}=\dens_{libre}\,\overrightarrow{v}`$, B dépend de la vitesse
$`\overrightarrow{v}`$ à laquelle un observateur voit les charges libres se déplacer,
donc B dépend de l'observateur. Donc la force de Lorentz semble dépendre de l'observateur.
Or en mécanique newtonienne, la force ne dépend pas du référentiel...
D'où un paradoxe apparent...
E et B varient ensemble selon le référentiel, pour créer un effet que ne dépend 
pas du référentiel. Entriane encore plus que seul le couple (E,B) a un sens physique.
Vient du fait que les équations de Maxwell contiennent des germes de la relativité.

Dans cet aparté, dire quelques lignes dna scette partie principale si c'est possible.
En tout cas, c'est une question difficile que pourronts e poser des aprenants. Donc le
développer suffisamment bien dans un "point culturel", ou un "point difficile" de la partie
"Au-delà".

Y réflechir bien, pas simple à expliquer bien.



----------------------------------

#### Équations de Maxwell et conservation de la charge

Dans la matière, les charges électriques sont portées par les électrons et
les protons des noyaux atomiques. En physique classique, ces particules existent, 
et elles ne peuvent ni surgir du vide, ni disparaître.

Ainsi le principe de conservation de la charge électrique peut se résumer en une phrase :

"Dans tout volume de l'espace et pendant une durée donnée, la charge électrique qui entre dans ce volume moins la charge électrique
qui en sort est égale à la variation de la charge dans le volume."

Cela se traduit en écriture mathématique par la loi :

Pour toute surface fermée $`S`$ délimitant un volume macroscopique $`\Ltau`$, 

$`\oiint_{S\leftrightarrow\Ltau}\overrightarrow{j}\cdot\overrightarrow{dS}+\iiint_{\Ltau}\dfrac{\partial\dens}{\partial t}\cdot d\tau=0`$

Aucune limite de taille, supérieure ou inférieure, ne limitant ce raisonnement, il s'applique aussi
à une surface de taille mésoscopique ou microscopique. Ainsi la loi de conservation
a aussi une expression locale, valide en tout point de l'espace, qui s'écrit :

$`div\,\overrightarrow{j}+\dfrac{\partial\dens}{\partial t}=0`$

<!-----FINIR DE METTRE AU POINT--------------------
! *Rappel* : 
! La loi de conservation ainsi exprimée comporte bien un signe *+*. Il est souvent
! difficile à retrouver mentalement.
! La raion est la convention de signe du flux d'un champ vectoriel à travers une surface fermée $``$.
! Le flux est compté positivement lorsque ...
------------------------------------------------------>

!! *Pour aller plus loin* : 
!!
!! La *physique classique* ne prévoit *pas de création ou d'annihilation de corpuscules* de matière,
!! chargée ou non. Ainsi toute variation de charge dans un volume donné correspond obligatoirement
!! à une charge qui traverse la surface fermée délimitant le volume considéré.
!!
!! En conséquence, *la loi de conservation de la charge ne contient pas de terme*
!! *décrivant la création ou l'annihilation de charge*.   
!!
!! Cependant il est observé *expérimentalement* que de *la matière peut-être créé ou annihilée*.  
!!
!! Dans les accélérateurs de particules de grands laboratoires de physique, *des couples comprenant*
!! *une particule et son antiparticule sont créés* à partir de l'énergie dégagée lors de chocs
!! entre protons accélérés à des vitesse proches de celles de la lumière dans le vide.   
!! De même est observée l'*annihilation de tout couple constitué d'une particule et de son antiparticule*
!! *lorsqu'elles se rencontrent*.  
!! Ces faits observationnels sont compris dans le cadre de la relativité d'Einstein et de sa célèbre
!! équivalence $`E=m\,c^2`$. Déjà dans sa forme restreinte, la relativité unifie matière et énergie
!! au sein d'une matière-énergie. L'une peut être convertie dans l'autre tant que la loi de la conservation
!! de la matière-énergie reste satisfaite.
!!
!! Mais même dans les conditions extrêmes réalisées dans les accélérateurs de particules, les couples
!! créés ou annihilés sont toujours constitués d'une particule et de son antiparticule. Par définition, 
!! *l'antiparticule a une charge opposée à celle de sa particule*, et la variation de charge reste nulle 
!! au total. 
!! 
!! Dans le monde des particules réelles, *le principe de conservation de la charge reste vérifié*.

Les équations de Maxwell couplent les champs électrique $`\overrightarrow{E}`$ et magnétique $`\overrightarrow{B}`$.
Je peux aussi les voir comme des équations qui couplent la densité volumique de charge $`\dens`$ et
le vecteur densité volumique de courant $`\overrightarrow{j}`$.
Il est ainsi intéressant de déduire des équations de Maxwell une équation dans laquelle apparaîtrait
soit les champs , soient leurs propriétés en terme de divergence, de rotationnel, de dérivée temporelle,
et de voir ce que réserverait le second terme de l'équation obtenue.

Je dois partir d'une contrainte sur les combinaisons d'opérateurs. Je teste celle-ci,

"La divergence du rotationnel d'un champ vectoriel est toujours nulle",

d'expression mathématique

$`\forall \overrightarrow{X}\big(\overrightarrow{r},t\big)\;,\quad div\big(\overrightarrow{rot}\,\overrightarrow{X}\big)=0`$.

et je l'applique au champ magnétique. J'obtiens :

$`div\big(\overrightarrow{rot}\,\overrightarrow{B}\big)=0`$.

La loi de Maxwell-Ampère permet d'écrire :

$`div\Big(\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

En divisant les termes de droite et de gauche par $`\mu_0`$, l'équation se simplifie :

$`div\Big(\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

L'équation précédente contient $`\overrightarrow{j}`$, je cherche à faire apparaître
la loi de Maxwell-Gauss pour faire apparaître $`\dens`$ :

$`div\,\overrightarrow{j} + div\Big(\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

L'espace et le temps étant découplés en physique classique, l'ordre de différentiation
et intégration n'importe pas si elles s'appliquent l'une à des coordonnées spatiales
et l'autre au temps. Ainsi :

$`div\,\overrightarrow{j} +
\dfrac{\partial}{\partial t}\Big(\epsilon_0\, div\,\overrightarrow{E}\Big)=0`$

ce qui permet d'écrire,

$`div\,\overrightarrow{j} + \dfrac{\partial\dens}{\partial t}=0`$

Je reconnais là la loi de conservation de la charge.

! *Les équations de Maxwell contiennent et impliquent la conservation de la charge électrique.*



<!----------------------------
aurélie jean, biais cognitifs
----------------------------->



-----------------------------------

#### Équations de Maxwell et propagation du champ électromagnétique

##### Rappel sur le phénomène de propagation dans l'espace et le temps

Soit une grandeur physique (scalaire ou vectorielle) représentée par un fonction continue de l'espace et du temps (donc un champ scalaire ou un champ vectoriel dépendant du temps).

Un grandeur physique se propage librement dans l'espace et le temps si aucun phénomène physique localisé dans l'espace et le temps ne vient atténuer ou amplifier, dévier ou disperser sa propagation. 

Le phénomène de propagation d'une grandeur physique qui se déplace librement  à travers l'espace et le temps, est décrit mathématiquement par l'équation d'onde simple. 

L'équation d'onde simple permet de calculer la valeur de la grandeur physique en tout point M de l'espace et à tout instant t.

##### La plus simple des équations d'onde : l'équation de d'Alembert

Pour un champ scalaire $`f(\overrightarrow{r},t)`$, l'équation d'onde simple, 
connue sous le nom d'équation de d'Alembert, est :

$`\Delta f(\overrightarrow{r},t) - \dfrac{1}{\speed^2} \; \dfrac{\partial^2 \;f(\overrightarrow{r},t)}{\partial\; t^2}=0`$

<!--$`\Delta \overrightarrow{X} - \dfrac{1}{v_{\phi}^2} \; \dfrac{\partial^2 \;\overrightarrow{X}}{\partial\; t^2}=0`$-->

La solution générale s'écrit :

$`f(\overrightarrow{r},t)=\sum_i f_i(\overrightarrow{u_i}.\overrightarrow{r}-\speed.t)`$

Elle décrit une superposition d'ondes $`f_i`$ qui se déplacent dans les directions en sens représentées par 
les vecteurs unitaires $`\overrightarrow{u_i}`$ à la même célérité $`\speed`$ (l'espace vide étant un milieu non dispersif).

!!!!! *Terminologie : milieu dispersif*   
!!!!!
!!!!! Un milieu dispersif est un milieu dans lequel *la célérité d'une l'onde monofréquencielle varie avec sa fréquence*.
!!!!! <details markdown=1>
!!!!! <summary>Différence entre dispersion et diffraction</summary>
!!!!! L'onde monofréquentielle (on dit aussi monochromatique, harmonique, sinusoïdale) s'étendant à l'infini dans l'espace comme dans le temps 
!!!!! et donc transportant une énergie infinie, n'a pas d'existence réelle.   
!!!!! Son intérêt est mathématique et vient du *théorème de Fourier* qui stipule que *toute onde réelle peut se décomposer*
!!!!! *en une somme intégrale d'ondes monochromatiques* d'amplitudes différentes et déphasées entre-elles.   
!!!!! Une onde réelle est donc limitée dans le temps comme dans l'espace, et posséde un certains profil. 
!!!!! Le terme *paquet d'ondes* traduit ce fait que le profil de l'onde réelle se décrit comme 
!!!!! une somme d'ondes monofréquentielles.
!!!!! 
!!!!! Dans un milieu dispersif, chaque composante nomofréquentielle de l'onde réelle va se propager à sa vitesse propre, 
!!!!! qui peut être différente de celles des autres composantes monochromatiques. Ainsi le profil se déforme au cours de
!!!!! sa propagation dans un milieu dispersif.
!!!!!
!!!!! La *dispersion* d'une onde *traduit tout phénomène liés à la propagation de l'onde dans un milieu dispersif*,
!!!!! et qui se peut se traduire par :
!!!!! * un *étalement spatial* du profil de l'onde : dispersion de la lumière par un prisme.
!!!!! * un *étalement temporel* du profil de l'onde au cours de sa propagation dans le milieu dispersif.
!!!!!
!!!!! *Ne pas confondre avec* la *diffraction* d'une onde qui traduit la perturbation d'une onde lorsqu'elle
!!!!! rencontre une inhomogénéïté de son milieu de propagation de taille comparable à sa longueur d'onde 
!!!!! (obstacle, ou ouverture).
!!!!! </details>

Pour un champ vectoriel $`\overrightarrow{X}(\overrightarrow{r},t)`$, l'équation d'onde de d'Alembert s'écrit :

$`\Delta \overrightarrow{X} - \dfrac{1}{\speed^2} \; \dfrac{\partial^2 \;\overrightarrow{X}}{\partial\; t^2}=0`$

L'expression de l'opérateur Laplacien vectoriel $`\Delta`$ en fonction des opérateurs $`grad`$, $`div`$ et $`rot`$ est :

$`\Delta =\overrightarrow{grad} \left(div\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\right)`$

##### Equation d'onde pour le champ électromagnétique 

L'idée est de calculer pour chacun des champs $`\overrightarrow{E}`$ et $`\overrightarrow{E}`$ 
l'expression de son Laplacien, pour voir si une identification avec l'équation d'onde est
réalisée.

Pour établir l'expression $`\;\;\Delta \overrightarrow{E}\;\;`$, je calcule 
$`\;\;\overrightarrow{rot}\left(\overrightarrow{rot}\;\overrightarrow{E}\right)\;\;`$ puis 
$`\;\;\overrightarrow{grad} \left(div \overrightarrow{E}\right)\;\;`$ à partir des équations
de Maxwell :


*  $`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
\overrightarrow{rot} \,\left( -\dfrac{\partial \overrightarrow{B}}{\partial t}\right)`$
<br><br>
En physique classique non relativiste, espace et temps sont découplés. Les coordonnées spatiales
et la coordonnée temporelle sont indépendantes. L'ordre de dérivation ou intégration entre 
des coordonnées spatiales et la coordonnés temporelle ne change pas le résultat, donc
je peux écrire :
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\overrightarrow{rot}\overrightarrow{B}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\mu_0\;\overrightarrow{j} +
\mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)
=-\mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$
<br><br>

* $`\overrightarrow{grad} \left( div \; \overrightarrow{E} \right) = \overrightarrow{grad}\left( \dfrac{\dens}{\epsilon_O} \right)`$

La reconstruction de 
$`\Delta \;\overrightarrow{E} =\overrightarrow{grad} \left(div\;\overrightarrow{E}\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\;\overrightarrow{E}\right)`$
donne :

$`\Delta \;\overrightarrow{E} = \overrightarrow{grad}\left( \dfrac{\dens}{\epsilon_O} \right) + \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$

ce qui donne par identification au premier terme de l'équation d'onde :

$`\mathbf{\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_O} \;
\overrightarrow{grad}\left(\dens \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}}`$

_(équation de propagation du champ électrique)_

Une étude de forme identique (proposée en autotest dans la partie beyond) me conduirait 
pour le champ magnétique  $`\overrightarrow{B}`$ à l'équation de propagation :

$`\mathbf{\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}}`$

_(équation de propagation du champ magnétique)_

##### Équation de propagation dans la matière

...

##### Équation de propagation dans le vide

 
 L'espace vide est caractérisé par une absence de charges, fixes ou en mouvement. 
 La densité volumique de charge $`\dens_{vide}`$ de même que le vecteur densité volumique de courant
 $`\overrightarrow{j}_{vide}`$ ont une valeur nulle dans tout l'espace vide,
 
 $`\dens_{vide}=0\quad\text{et}\quad\overrightarrow{j}_{vide}=\overrightarrow{0}`$.
 
 Dès lors, l'équation de propagation de l'onde électromagnétique dans le vide prend la forme
 de l'équation de d'Alembert :
 
$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}`$

$`\Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}`$




 
 



---------------------------------------

#### Équations de Maxwell et puissance cédée par le champ électromagnétique à la matière

Le champ électromagnétique interagit mécaniquement avec les particules chargées (électrons, ions, …) de la
matière, le terme "mécaniquement" signifiant que la présence d'un champ magnétique modifie le
mouvement des particules chargées. En Physique classique, l'interaction mécanique se modélise par
le concept de force, et la modification de mouvement induite par une force appliquée est décrite
par les lois de Newton.

##### Puissance cédée à une charge ponctuelle

La sensibilité d'une particule à l'interaction avec un champ électromagnétique se quantifie
par le paramètre appelé charge électrique de la particule.

La force qui décrit l'action d'un champ électromagnétique $`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`$ 
sur une particule de charge $`q`$ est la force de Lorentz d'expression 

$`\overrightarrow{F}_{\,Lorentz}=q\Big(\overrightarrow{E}+\overrightarrow{v}\land\overrightarrow{B}\Big)`$

&nbsp;&nbsp;où $`\overrightarrow{v}`$ est le vecteur vitesse de la particule dans le référentiel d'inertie de l'observation.

!!!!! référentiel d'inertie = référentiel galiléen

Lors d'un déplacement élémentaire $`\overrightarrow{dl}`$ de la particule dans le champ électromagnétique
$`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`$, le travail de la force de Lorentz s'écrit :

$`d\mathcal{W}_{\,Lorentz}=\overrightarrow{F}_{Lorentz}\cdot\overrightarrow{dl}`$,

soit

$`\begin{align}
d\mathcal{W}_{\,Lorentz}&=q\Big(\overrightarrow{E}+\overrightarrow{v}\land\overrightarrow{B}\Big)\cdot\overrightarrow{dl}\\
&\\
&= q\Big(\overrightarrow{E}\cdot\overrightarrow{dl}\Big)+ q\Big(\overrightarrow{v}\land\overrightarrow{B}\cdot\overrightarrow{dl}\Big)\\
&\\
&= q\,\overrightarrow{E}\cdot\overrightarrow{dl} + q\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big) \\
\end{align}`$

où $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)`$ est le produit mixte de la séquence des trois vecteurs.

Comme les vecteurs $`\overrightarrow{v}`$ et $`\overrightarrow{dl}=\overrightarrow{v}\,dt`$ du produit mixte sont colinéaires, celui-ci
est donc nul, 

$`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$,

!!!! 
!!!! <details markdown=1>
!!!! <summary>Rappels sur le produit mixte</summary>
!!!! Le produit mixte de trois vecteurs $`\vec{a}\,,\vec{b}\,,\vec{c}`$, noté $`(\vec{a}\,,\vec{b}\,,\vec{c})`$
!!!! est défini par :    
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{a}\land\vec{b})\cdot\vec{c}`$.   
!!!! Il est alors facile de démontrer qu'il est invariant par permutation circulaire des 3 vecteurs :
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{b}\,,\vec{c}\,,\vec{a})=(\vec{c}\,,\vec{a}\,,\vec{b})`$.
!!!! C'est donc un nombre réel, dont la valeur absolue s'identifie au volume du parallélépipéde 
!!!! créé les trois vecteurs $`\vec{a}\,,\vec{b}\,,\vec{c}`$.
!!!!
!!!! Dans le cas étudié, deux vecteurs au moins du produit mixte $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)`$
!!!! sont colinéaires car $`\overrightarrow{dl}=\overrightarrow{v}\,dt`$.
!!!! Je peux dès lors m'assurer que ce produit mixte est nulle,    
!!!! * soit en remarquant que trois vecteurs dont deux sont colinéaires s'inscrivent dans un même plan (2D)   
!!!! et donc le volume (3D) construit par ces trois vecteurs est nul : 
!!!! $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$   
!!!! * soit en utilisant l'invariance du produit mixte par permutation circulaire,    
!!!! $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=\Big(\overrightarrow{dl},\overrightarrow{v},\overrightarrow{B}\Big)`$
!!!! $`=dt\times\Big(\overrightarrow{v},\overrightarrow{v},\overrightarrow{B}\Big)`$
!!!! et en remarquant que le produit vecoriel de deux vecteurs colinéaires est nul :
!!!! $`\big\Vert\overrightarrow{v}\land\overrightarrow{v}\big\Vert=\big\Vert\overrightarrow{v}\big\Vert\cdot\big\Vert\overrightarrow{v}\big\Vert\cdot \sin 0=0`$
!!!! $`\Longrightarrow \overrightarrow{v}\land\overrightarrow{v}=\overrightarrow{0}`$   
!!!! $`\Longrightarrow \Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$
!!!! </details>
!!!! 

et le travail de la force de Lorentz se simplifie :

$`\mathcal{W}_{\,Lorentz} = q\,\overrightarrow{E}\cdot\overrightarrow{dl}`$

! *Remarque :*
!
! La *force magnétique $`\overrightarrow{F}_{\,magn.}=q\,\overrightarrow{v}\land\overrightarrow{B}`$*, 
! par nature perpendiculaire au vecteur vitesse $`\overrightarrow{v}`$ et donc au vecteur déplacement 
! élémentaire $`\overrightarrow{dl}=\overrightarrow{v}\,dt`$ en tout point de la trajectoire de la particule
! de charge $`q`$, *ne travaille pas* :
!
! $`\mathbf{d\mathcal{W}_{\,magn} = \overrightarrow{F}_{magn}\cdot \overrightarrow{dl}=0}`$
!
! *Le travail de la force de Lorentz se limite au travail de la force électrique* :
!
! $`\mathbf{d\mathcal{W}_{\,Lorentz} = d\mathcal{W}_{\,élec} =q\,\overrightarrow{E}\cdot \overrightarrow{dl}}`$

La puissance cédée par le champ à cette particule s'écrit :

$`\mathbf{d\mathcal{P}_{cédée} = \dfrac{\mathcal{W}_{\,Lorentz}}{dt} = q\,\overrightarrow{E}\cdot\overrightarrow{v}}`$

<!---QUESTION- que peut se poser l'apprenant--------------
Pourquoi la dérivée par rapport au temps de l'énergie ne s'applique que sur dl et pas sur E?
---------------------------------------------------------->


##### Puissance cédée dans un matériau








---------------------------------------

#### Équations de Maxwell et énergie électromagnétique

à faire

<!------------------

##### équation d'onde simple

$`\Delta \overrightarrow{X} - \dfrac{1}{v_{\phi}} \; \dfrac{\partial^2 \;\overrightarrow{X}}{\partial\; t^2}=0`$

de solution

#### équation d'onde amortie

$`\Delta \overrightarrow{X} - \dfrac{1}{v_{\phi}} \; \dfrac{\partial^2 \;\overrightarrow{X}}{\partial\; t^2}=
\beta \; \dfrac{\partial \overrightarrow{X}}{\partial t}`$

où $`\beta`$ est le terme d'amortissement

de solution

L'expression de l'opérateur Laplacien vectoriel $`\Delta`$ en fonction des opérateurs $`grad`$, $`div`$ et $`rot`$ est :

$`\Delta =\overrightarrow{grad} \left(div\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\right)`$


### Equation d'onde pour le champ électromagnétique 
(Ou "Etude du Laplacien du champ électromagnétique")

Pour établir l'expression $`\;\;\Delta \overrightarrow{E}\;\;`$, je calcule 
$`\;\;\overrightarrow{rot}\left(\overrightarrow{rot}\;\overrightarrow{E}\right)\;\;`$ puis 
$`\;\;\overrightarrow{grad} \left(div \overrightarrow{E}\right)\;\;`$ à partir des équations
de Maxwell :


*  $`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
\overrightarrow{rot} \,\left( -\dfrac{\partial \overrightarrow{B}}{\partial t}\right)`$
<br><br>
En physique classique non relativiste, espace et temps sont découplés. Les coordonnées spatiales
et la coordonnée temporelle sont indépendantes. L'ordre de dérivation ou intégration entre 
des coordonnées spatiales et la coordonnés temporelle ne change pas le résultat, donc
je peux écrire :
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\overrightarrow{rot}\overrightarrow{B}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\mu_0\;\overrightarrow{j} +
\mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)
=-\mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$
<br><br>

* $`\overrightarrow{grad} \left( div \; \overrightarrow{E} \right) = \overrightarrow{grad}\left( \dfrac{\rho}{\epsilon_O} \right)`$

La reconstruction de 
$`\Delta \;\overrightarrow{E} =\overrightarrow{grad} \left(div\;\overrightarrow{E}\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\;\overrightarrow{E}\right)`$
donne :

$`\Delta \;\overrightarrow{E} = \overrightarrow{grad}\left( \dfrac{\rho}{\epsilon_O} \right) + \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$

ce qui donne par identification au premier terme de l'équation d'onde :

$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_O} \;
\overrightarrow{grad}\left(\rho \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t} `$

---------->
