---
title: 'Framework of a fictif euclidian space-time'
published: true
routable: true
visible: false
lessons:
    -
      slug: from-classical-to-relativistic-universe-through-euclidian-space-time
      name: CONCEPT : Espace-temps euclidien, étape conceptuel entre univers classique et relativiste.
      order: 2
---


<!---------------------------
lessons:
    - slug: stationary-electric-field
      order: 2
----------------------------->

<!--MétaDonnée : ... -->

$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Colline

---------------------------

*Cadre __fictif__ d'un espace-temps euclidien :*   

##### Un ESPACE-TEMPS euclidien : étape conceptuelle

<br>

RÉSUMÉ
:
*Corps* :   
\- tout être ou objet matériel localisé dans l'espace-temps.   
*Observateur* :   
\- Corps percevant l'espace et le temps, et d'autres corps dans l'espace et le temps.   
\- Il peut mesurer des durées $`\Delta t`$ et des longueurs $`\Delta l`$ à l'aide d'une 
horloge et d'une règle, immobiles par rapport à lui le temps de la mesure.    
\- Il repère la position de corps dans l'espace-temps en choisissant une origine 
de l'espace-temps et des coordonnées $`(x,y,z,t)`$.   
*Autres corps dans l'espace-temps* :   
\- immobiles ou en mouvements par rapport à un observateur.  
\- et repérés par leurs coordonnées spatio-temporelles $`(x,y,z,t)`$.   
*Évènement* :   
\- position dans l'espace-temps d'un corps, d'une interaction ou d'une
coïncidence entre deux ou plusieurs corps.   
*Ligne d'univers d'un corps* :   
\- ensemble des positions $`(x,y,z,t)`$ de l'espace-temps occupées par le corps.   
\- équation de la ligne d'univers : fonction $`f(x,y,z,t)`$ des coordonnées spatio-temporelles
d'une ligne d'univers telle que $`f(x,y,z,t)=0`$.   
*Observateur galiléen* :   
$`\Longleftrightarrow`$ un corps soumis à aucune interaction est observé immobile 
  ou se déplaçant selon une ligne d'univers rectiligne.   
*Espace-temps euclidien* :   
$`\Longleftrightarrow`$ il existe des systèmes de coordonnées rectilignes spatio-temporels 
$`(O,x,y,z,t)`$ appelées cartésiennes, tels que, pour tout couple d'évènements $`A`$ 
et $`B`$, le résultat de la mesure 
$`s_{AB}=\sqrt{c^2\Delta t_{AB}^2+\Delta x_{AB}^2+\Delta y_{AB}^2+\Delta z_{AB}^2}`$    
\- avec c une 
constante fondamentale de l'espace-temps ayant la dimension d'une vitesse, est le 
même pour tout observateur galiléen.   
\- écriture $`\Delta u_{AB}^{\;2}=(u_B-u_A)^2`$, avec $`u`$ une coordonnée.   
*Perception de l'espace et du temps par un observateur*.  
\- l'observateur vit l'instant présent d'un temps fléché du passé vers le futur.   
\-  à chaque instant $`t`$, l'observateur perçoit un espace euclidien :    
il existe des systèmes de coordonnées spatiales $`(O,x,y,z)`$ appelées cartésiennes
tels que, pour tout couple de points $`C`$ et $`D`$, le résultat de la mesure 
$`\Delta l_{CD}=\sqrt{\Delta x_{CD}^2+\Delta y_{CD}^2+\Delta z_{CD}^2}`$   
est le même pour tout autre 
observateur immobile par rapport au premier et au même instant.   
*D'observateur galiléen à observateur galiléen*,   
en translation rectiligne l'un par rapport à l'autre à la vitesse constante $`V`$ 
selon une direction $`\Delta`$ :   
chaque observateur observe pour les corps en mouvement une même :   
\- dilatation des longueurs dans la direction $`\Delta`$ 
d'un rapport $`\Gamma`$.   
\- conservation des longueurs dans la direction perpendiculaire à $`\Delta`$   
\- contraction des durées, d'un rapport $`\Gamma`$.   
$`\hspace{1 cm}\text{avec }\Gamma = \dfrac{1}{\sqrt{1+V^2/c^2}}`$.   
*Caractère absolu ou relatif d'une grandeur* :   
\- relatif : dont la valeur mesurée dépend de l'observateur.   
\- absolu : dont la valeur mesurée est la même pour tous les observateurs.   
*Caractère des grandeurs usuelles*.  
\- relativité des longueurs $`\Delta l`$    
\- relativité des durées $`\Delta t`$.  
$`\Longrightarrow`$ relativité des angles $`\varphi = \text{arctg}(\Delta l_{opposé} / \Delta l_{adjacent})`$.  
$`\Longrightarrow`$ relativité des vitesses linéaires $`\mathscr{v} = \Delta l / \Delta t`$.    
$`\Longrightarrow`$ relativité des accélérations linéaires $`a = \Delta\mathscr{v} / \Delta t`$.  
$`\Longrightarrow`$ relativité des vitesses angulaires $`\omega = \Delta \varphi / \Delta t'`$.  
$`\Longrightarrow`$ relativité des accélérations angulaires $`\dpt{\omega} = \Delta \omega / \Delta t'`$.  


# <p style="font-size:60%;text-align: center;">Un ESPACE-TEMPS EUCLIDIEN<br><br>base d'un monde fictif</p>

## <p style="font-size:70%;text-align: center;">Premiers pas vers<br>la révolution conceptuelle qui t'attend</p>

#### Une étape importante

* Un **espace-temps euclidien** est une *étape vers la relativité* restreinte, puis générale d'Einstein.
* Il permet de visualisaer et de **comprendre la nature géométrique** *des paradoxes apparents*
  (pour notre intuition) de la relativité restreinte.
* Les **effets relativistes** dans ce chapitre sont de même nature, mais
  *inversés par rapport à la relativité restreinte*.

#### Penser l'espace et le temps différemment

![](espace-temps-euclidien-1_v2_L1200.gif)   
_Représentation symbolique : des corps immobiles et en mouvements ont chacun leur propre perception de l'espace et du temps_
_ d'un espaxe-temps euclidien._
   
* Le **temps et** l'**espace** ne sont *ni universels, ni indépendants*.
* Des **corps** (êtres vivants observateurs, objets, tout corps matériel) sont **immobiles ou en mouvement** 
  les uns par rapport à d'autres *dans un espace-temps* ici *fictif et euclidien*.   

!! *Pour aller plus loin* :
!! * L'espace-temps minkovskien de la *relativité restreinte* est une modélisation plus étrange mais beaucoup 
!! *plus précise, explicative et prédictive de l'univers* 
!!  dans lequel nous sommes nés, que la mécanique classique.
!! * *En ce sens*, la relativité restreinte n'est pas une fiction, mais elle te donne une vision 
!! certes à première vue étrange mais *"plus réaliste"* que la très intuitive mécanique classique.
!!
!! <details markdown=1>
!! <summary>Des modèles encore plus réalistes</summary>
!! * L'espace-temps de type riemannien de la *relativité générale* donne une vision *encore plus réaliste*.
!! <br>
!! * Sur le chemin de la compréhension ultime de note Univers, Une *autre révolution conceptuelle très différente*
!! et tout aussi étrange sera pour toi la découverte de la *mécanique quantique*.   
!! * La mécanique quantique non relativiste de permettra de comprendre le comportement très étrange du monde des
!! particules élémentaires, mais avec des applications macroscopiques et technologiques majeures.
!! * La mécanique relativiste restreinte a permi de prédire l'existence de l'anti-matière avant sa découverte expérimentale.
!! * L'unification de la relativité générale et mécanique quantique, résistent à ce jour aux physiciens.
!! * De par leurs natures fondamentalement différentes, déterministe pour la relativité, et probabiliste pour la mécanique
!! quantique, ces deux théories exptrèmement prédictives dans leurs domaines respectifs, semblent irréconciliables.
!! * Dans leur recherche d'une théorie du Tout, nombres de physiciens pensent qu'une réponse éventuelle nécessitera
!! une nouvelle et totale révolution conceptuelle.
!! </details>
!! <br>
!!

* Chaque **corps** a *sa propre perception de l'espace et du temps*,   
  <br>
  et les **résultats de mesure** effectués sur un même évènements lui sont *propres*.

#### Une classe de corps partageant une même perception de l'espace temps.

![](espace-temps-euclidien-2_v2_L1200.gif)   
_Représentation symbolique : des corps galiléens immobiles les uns par rapport aux autres partagent leur propre perception de l'espace et du temps._


* Tous les **corps immobiles par rapport à un corps galiléen**
   * *percoivent un même espace-temps*,   
   * et donc *partagent les mêmes résultats de mesures* effectuées sur un même évènement.

!! *Pour aller plus loin* :
!! Ce point sera à la base de la *notion de référentiel* qui sera vue au niveau Contreforts :<br>
!! Un référentiel sera défini comme un observateur muni d'une règle et d'une horloge, et tout objet
!! de position fixe par rapport à cet observateur.

<br>



<!-----------

##### Un espace et un temps indépendants

* **Deux mots, "espace" et "temps"**, pour parler de notre perception de l'espace et du temps, montre
  bien qu'il s'agit de *deux réalités* vécues percues comme *distinctes et indépendantes*, de *natures différentes*.

* L'**espace a trois dimensions**, ce qui signifie qu'il faut et il suffit de *trois nombres réels* appelés
  "coordonnées spatiales" souvent notées $`(x_P,y_P,z_P)`$ *pour localiser de façon unique tout point* P dans l'espace.   
  <br>
  Connaissant les coordonnées spatiales de deux points dans l'espace, il est possible de quantifier un **intervalle d'espace**
  entre ces deux points, représenté par un nombre réel dont la valeur ne dépend pas des coordonnées choisies, 
  en définissant une *notion de distance* entre ces deux points.

* Le **temps a une seule dimension**, ce qui signifie qu'il faut et il suffit d'*un seul nombre réel* appelé
  "coordonnée temporelle" ou "date" souvent noté $`t`$ *pour localiser de façon unique un instant* dans le temps.   
  <br>
  Connaissant les dates de deux instants dans le temps, il est possible de quantifier l'**intervalle de temps**
  entre ces deux instants, en définissant une *notion de durée* entre ces deux instants.

* **Distance** et **durée** sont de natures différentes, comme l'espace et le temps, et *ne peuvent se comparer*. 

##### Un espace-temps

* **Un seul mot "espace-temps"** pour parler de l'espace et du temps, montre que sous ces deux réalités d'apparences différentes
  se cache *une seule réalité* dans laquelle *l'espace et le temps sont liés*, et donc non indépendants.

* L'espace-temps a trois plus une égale quatre dimensions, ce qui signifie qu'il faut et il suffit 
  de *quatre nombres réels* appelés "coordonnées spatio-temporelles" souvent notées $`(x_P,y_P,z_P, t_P)`$ 
  *pour localiser de façon unique tout évènements* P se produisant dans l'espace-temps.  

* Connaissant les coordonnées spatio-temporelles de deux évènements situés dans l'espace-temps, il doit être possible
  de quantifier l'**intervalle d'espace-temps**
  entre ces deux évènements, en définissant une *distance-spatio-temporelle* entre ces deux évènements.

* Cette distance spatio-temporelle combine à la fois la distance spatiale et la distance temporelle. 


#### Qu'est-ce qu'une distance dans un espace-temps?

* L'**espace et le temps** sont intuitivement *perçus de natures différentes*,
   * un **intervalle d'espace** ou **distance** $`\Delta l_A^B`$ entre deux points $`A`$ et $`B`$ à la *dimension d'une longueur* 
   notée [L],   
   _et dans le système international d'unités, se mesure en mètre (m)._
   * un **intervalle de temps** ou **durée** $`\Delta t_C^D`$ entre deux instants $`t_C`$ et $`t_D`$ à la *dimension d'un temps* 
   notée [T],   
   _et dans le système international d'unités, se mesure en seconde (s)._

* Pour **rendre comparable un longueur et une durée**, *multiplie toute durée $`\Delta t`$ par $`c`$*, 
  un nombre réel constant auquel tu associes la *dimension d'une vitesse, noté [V]*=[L]/[T].   
  _Dans le système international d'unités, $``c``$ se mesure en mètre par seconde (ms<sup>-1</sup>)._

  Ainsi la quantité **$`c\Delta t`$** sera de *même nature qu'une longueur $`\Delta l`$*.


_animation 1_
_1 - Tout observateur ou corps matériel ne perçoit que l'instant présent d'un temps fléché du passé vers le futur._
_2 - à chaque instant il perçoit un espace à 3 dimensions,_
_3 - et d'autres corps matériels immobiles (a) ou en mouvement (b) par rapport à lui._
L'espace se reproduit à chaque instant.

_animation 2_
_1 - L'observateur dispose mesure des durées avec une horloge immobile par rapport à lui.
_2 - dipose d'une règle mesure des longueurs avec une règle rigide immobile par rapport à lui.






## <p style="font-size:70%;text-align: center;">Perceptions propres d'un observateur galiléen<br>dans un espace-temps euclidien</p>



#### Qu'est-ce qu'un observateur ?


#### Qu'est-ce qu'un observateur galiléen ou d'inertie ?


#### Que perçoit un observateur galiléen dans un espace-temps euclidien?

<!-------------
>
* L'**observateur** vit dans l'*instant présent d'un temps fléché du passé vers le futur*.   
  <br>
  Il mesure le temps avec une **horloge immobile par rapport à lui-même**. 
  L'ensemble des *corps immobiles* par rapport à lui
   * l'observateur
   * 
  
  partagent *un même écoulement du temps*, que cela soit :
   * le mécanisme d'oscillation dans son horloge.
   * ses pensées
   * ses processus biologiques (vieillissement cellulaire ou division cellulaire) se produiront à la même vitesse.
   * sa durée de vie ne sera ni augmentée, ni diminuée.
   
   
  Sa perception du temps est identique à celle d'un observateur dans 
  l'espace et le temps universels et indépendants de la mécanique classique, sauf que le temps
  n'est pas universelle, l'observateur et tout corps immobile par rapport à lui vivent dans son temps propres,
  ou partagent le même temps propre.
  <br>

* L'observateur vit dans un *espace euclidien à trois dimensions*, c'est à dire
  il existe des systèmes de coordonnées de l'espace $`(O,x,y,z)`$ couvrant tout l(espace et appelées 
  cartésiens, tels que pour tout points $`A`$ et $`B`$ dans l'espace, à tout instant $`t`$ de son temps propre, le résultat de la mesure 
  $`\Delta l_{AB}(t)=\sqrt{\Delta x_{AB}^2(t)+\Delta y_{AB}^2(t)+\Delta z_{AB}^2(t)}`$    
  \- avec écriture $`\Delta u_{AB}(t)^{\;2}=(u_B(t)-u_A(t))^2`$, avec $`u`$ une coordonnée spatiale.  
  <br>
  Sa perception de l'espace est identique à celle d'un observateur dans l'espace euclidien de la mécanique classique.   

![observateur, sa grille spatiale et son temps]()

* En particulier, à tout instant :
   * L'**écart entre deux droites parallèles** reste *constant*.
   * Le **rapport entre la circonférence $`C`$ et le rayon $`R`$** de tout cercle égale
     *deux fois le nombre $`\pi=3,14159...`$* :   
     **$`C=2\,\pi\,R`$**
   * La **somme des angles aux sommets de tout triangle** égale le *nombre $`\pi=3,14159...`$*.

![la grille spatiale et droites parallèles, propriétés du cercle et triangle]()

------------->


## <p style="font-size:70%;text-align: center;">Un hyper-espace euclidien<br> à 4 dimensions</p>

à faire

![](4D-euclidian-space-time-1_L1200.gif)

(possibilité de quadriller tout l'espace temps avec un réseau de droites parallèles
unité de longueur, 

-------------

![](euclidian-4D-space-observator_L1200.gif)

* Soient **M et N deux points quelconques fixes** pour un observateur dans un hyper-espace à 4 dimensions.   
  <br>
  Ces deux points peuvent représenter :
   * Les *extrémité d'un segment rigide* de *longueur $`MN`$*
   * *deux corps isolés* de *distance $`MN`$* constante.

* Soit un point $`O`$ quelconque.
* Soit une droite $`\Delta`$ quelconque passant par $`O`$.   
  <br>
  *Dans un hyper-espace à 4 dimensions, normal à une droite* se trouve un **espace à 3 dimensions**.

!!!!! <details markdown=1><summary>Terminologie : sécante, perpendiculaire, orthogonale, normale</summary>
!!!!! * deux droites qui se coupent en un point sont dites sécantes.
!!!!! Dans un plan euclidien (2D),
!!!!! * deux droites non parallèles sont sécantes,
!!!!! * deux droites sécantes sont perpendiculaires si elles se coupent à angle droit.
!!!!! Dans l'espace euclidien tridimensionnel (3D),
!!!!! * deux droites sécantes dont les directions forment un angle droit sont dites perpendiculaires,
!!!!! * deux droites non sécantes mais dont les directions forment un angle droit sont dites orthogonales.<br>
!!!!! _C'est le cas de deux droites perpendiculaires à une troisième droites._
!!!!! * Une droite est dite normale ou orthogonale à un plan si elle est perpendiculaire à toute droite contenue dans le plan.
!!!!! Dans un hyper-espace euclidien à 4 dimensions
!!!!! * Une droite est dite normale ou orthogonale à un espace si elle est perpendiculaire à toute droite contenue dans l'espace.
!!!!! </details>

--------------

![](euclidian-4D-space-projection-on-direction-and-space_L1200.gif)

* De même que dans l'espace euclidien tridimensionnel, un point peut être projeté orthogonalement sur une droite
  et sur le plan orthogonal à la droite,   
  *dans un hyper-espace euclidien quadridimensionnel*, La **projection d'un point $`N`$** quelconque :   
   * **sur une droite $`\Delta`$** est un *point* ici noté *$`N_{\Delta}`$*,
   * **sur l'espace orthogonal $`\boldsymbol{\mathcal{E}}`$ à la droite $`\Delta`$** est un *point* ici noté *$`N_{E}`$*.

!!!!! *Terminologie :* distance, longueur
!!!!! * La *distance* entre deux points est la *longueur du plus court chemin* entre ces deux points.
!!!!! * Dans un *espace euclidien*, le plus court chemin entre deux point est unique, et est le 
!!!!! *segment de droite* joignant ces deux points.
   
* Soient :
   * *$`M_{\Delta}`$* et *$`N_{\Delta}`$*, les projections de $`M`$ et $`N`$ sur $`\Delta`$.
   * *$`M_{E}`$* et *$`N_{E}`$*, les projections de $`M`$ et $`N`$ sur $`\boldsymbol{\mathcal{E}}`$.

* Note :
   * **$`M_{\Delta}N_{\Delta}`$** la **distance** entre les points $`M_{\Delta}`$ et $`N_{\Delta}`$
   * **$`M_{E}N_{E}`$** la **distance** entre les points $`M_{E}`$ et $`N_{E}`$   
<br> 
   
---

![](euclidian-4D-space-projection-on-direction-and-space_pythagore-1_L1200.gif)

* Appelle **$`P`$** la **projection orthogonale** *de $`M`$ sur* la droite *$`(NN_{E})`$*.
* Le **triangle $`MNP`$** formé par les 3 points $`M\,,N\,\text{et}\,P`$ est *rectangle en P*.
* L'*hyper-espace* étant *euclidien*, le **théorème de Pythagore** s'applique à tout triangle rectangle, et tu as :   
<br>
**$`\boldsymbol{\Large{NM^{\,2} = MP^{\,2} + PN^{\,2}}}\quad`$**(eq.1)   
<br>

---

![](euclidian-4D-space-projection-on-direction-and-space_pythagore-2_L1200.gif)

* Les points $`N\,,P\,,M_{\Delta}\,,N_{\Delta}`$ forment un *rectangle*, donc les distances $`NP`$ 
  et $`M_{\Delta}\,,N_{\Delta}`$ sont égales :   *$`NP=M_{\Delta}N_{\Delta}\quad`$*(eq.2)

* Les points $`N\,,P\,,M_{E}\,,N_{E}`$ forment un *rectangle*, donc les distances $`NP`$ 
  et $`M_{E}N_{E}`$ sont égales :   *$`NP=M_{E}N_{E}\quad`$*(eq.3)

* *Ainsi*, des équations 1, 2 et 3 tu déduis :  
 <br>
  *$`\boldsymbol{\Large{NM^{\,2} = M_{\Delta}N_{\Delta}^{\;\;2} + M_{E}N_{E}^{\;\;2}}}\quad`$*   
 <br>
 Ce qui se réécrit, une distance étant positive :   
 <br>
 **$`/displaystyle\boldsymbol{\Large{NM = \sqrt{M_{\Delta}N_{\Delta}^{\;\;2} + M_{E}N_{E}^{\;\;2}}}}\quad`$**  (eq.4)   
 <br>
Dans un hyper-espace euclidien, la distance entre deux points est égale à la racine carré
de la somme des distances au carré des deux points projetés orthogonalement sur une 
droite quelconque, et sur l'espace orthogonal à cette droite.

<br>

## <p style="font-size:70%;text-align: center;">Un espace-temps euclidien<br> à 4 dimensions</p>


à faire,

(le rôle distinct pour un observateur de l'espace et du temps ;   
 un temps contraint unidimensionnel qui
s'écoule continument du passé ver le futur ;   
 un espace continue libre à 3 dimensions ;   
l'axe $`\Delta`$ est la direction temporelle pour l'observateur ;   
dans hyper-espace, l'invariant est une longueur, nécessité de convertir une durée en une longueur   
=> entraine une constante fondamentale ayant la dimension d'une vitesse ;
note : rien n'oblige cette constante fondamentale à être la vitesse de la lumière, dans analogie avec relativité restreinte.   
$`\Delta`$  devient axe ct et non t ;  
pour les calculs de l'invariant, l'unité de temps multipliée par c doit êêtre égale à l'unité de longueur choisie ;
pas simple à expliquer : un mètre-temps (ct) doit être égale à un mètre-espace l ??   
et l'unité de temps t doit vérifier le mètre-temps ct doit égaler le mètre-espace (m)...
rendre simple...   
unités de longueur temporelle : l'année lumière (les étudiants se trompent souvant), la seconde lumière
sont des unité de longueurs ;   
rendre simple ...    
expression de l'invariant dans cet espace-temps euclidien    

<br>

## <p style="font-size:70%;text-align: center;">Corps matériels et observateurs galiléens</p>


#### Corps matériels et observateurs

à faire, 




#### Observateur et corps matériel

* Appelle **observateur** un *être qui perçoit l'espace et le temps*,   
  et **muni** :
   * d'une **horloge** pour *dater* des évènements et pour *mesurer des durées* entre évènements
   * d'un dispositif expérimental équivalent d'une **règle rigide** lui permettant de façon instantanée de
     *mesurer des distances* entre deux points, ou *des longueurs* d'objets rigides.
   _Cette notion d'observateur te permet aussi de t'identifier à lui, pour mieux faire tiennes_
   _les résultats de cette étude._

! *Note :*   
! *L'aspect mesure* de l'espace et du temps *est important*, car au-delà de ses perceptions
! et intuitions premières, *l'observateur doit être capable d'interroger précisément la Nature* pour essayer de comprendre sa réalité.
! Or l'histoire des sciences nous apprend que la Nature apparait plus subtile qu'elle nous apparaissait au premier abord.
! Interroger la Nature, c'est d'abord savoir progressivement :
! * lui poser les bonnes questions à l'aide d'observations précises, de dispositifs expérimentaux, de procédures de mesure, 
! et de méthodes d'analyse respectant la méthode scientifique,
! * puis d'interpréter sa réponse en terme de modéles mathématiques prédictifs, qui seront invalidés ou validés dans
! un domaine de validité, par des nouvelles questions posées à la Nature.

* Cependant, l'observateur, ses instruments de mesure, sont matériels et soumis au lois naturelles connues ou à découvrir..
  Ainsi dans les démonstrations suivantes concernant un espace-temps euclidien, fictif   
   * **ce qui se vérifie pour un observateur** *se vérifie pour tout corps matériel*.
   * les propriétés de l'espace et du temps 
<br>


#### L'observateur galiléen et observateur non galiléen

A faire

Observateur (ou corps matériel) galiléen et non gliléen

<br>


#### Perception sensible du temps, de l'espâce, du mouvement par un observateur

A faire (Ici, on fait appel au lecteur, il regarde simplement, il n'interprête pas encore dans le cadre d'un modèle).

![](human-perception-of-space-and-time-0_L1200.gif)

<br>

## <p style="font-size:70%;text-align: center;">Ligne d'univers<br>et temps propre</p>

#### Element de ligne d'univers

à faire

![](infinitesimal-world-line-element_v2_L1200.jpg)

<br>

#### Lignes d'univers d'observateurs galiléens et non galiléens


![](world-line-galilean-non-galilean-0-fr_L1200.jpg)
![](world-line-galilean-non-galilean-1_L1200.jpg)

Différence entre trajectoire dans l'espace et ligne d'univers dans l'espace temps 
(parler aussi des équations horaires? ou laisser cela dans l'équivalent classique ?)

figure à faire


<br>

#### Ligne d'univers, invariant et temps propre

A faire

idée : lignes d'univers de 2 observateurs. 2 instants quelconques sur leurs lignes respectives
$`t^{A}_{1}`$ et $`t^{B}_{1}`$. $`t^{A}_{1}`$ et $`t^{B}_{1}`$ n'ont aucune raison d'avoir
la même valeur. Ils parcourent chacun une même "longueur" sur leur ligne d'univers (faut-il déjà
parler d'invariant? oui, à introduire avant). Alors même durée propre pour chacun d'eux. Aller à 
l'idée que le temps propre de chacun s'écoule de la même façon pour tous. Aucun mouvement ne permet
de vivre plus longtemps par exemple.

![](euclidian-space-time-worldline-proportional-proper-time_L1200.gif)

<br>

#### Différence entre ligne d'univers et trajectoire classique

A faire

idée : pour un observateur, trajectoire ensemble des positions spatiales parcourues 
pour un corps entre deux instants. Ne précise pas à quel instant une position de la trajectoire
est atteinte par le corps. Nécessité classique des équations horaires.
pour un observateur, ligne d'univers ensemble des positions spatio-temporelles parcourues par un
corps entre de l'espace-temps parcourues entre deux positions.

Figure à faire

observateur galiléen 2 cas, il voit corps ganiléen et corps non galiléen.

<br>

#### Distorsions temporelles lorsque deux lignes d'univers se croisent deux fois

A faire

![](euclidian-space-time-worldline-twin-paradox_L1200.gif)

idée : les lignes d'univers de deux observateurs A et B , l'un galiléen (A) et l'autre non (B), 
se croisent une première fois. Ils se retrouvent alors au même instant en une même position de
l'espace (ou deux position très proches). Horloges identiques, il est $`t^{A}_{1}`$ pour A 
et $`t^{B}_{1}`$ pour B. Ils en profitent pour synchroniser leurs horloges (on aura préciser l'horloge
d'un observateur est immobile par rapport à lui) : $`t^{A}_{1} = t^{B}_{1}`$.
Puis chaun pousuit sa ligne d'univers, A est galiléen (non éccéléré) et B non galiléen (accéléré).
Il se croisent à nouveau en une même position de l'espace, à un instant $`t^{A}_{2}`$ pour A 
et $`t^{B}_{2}`$ pour B. La ligne d'univers de B étant plus "longue" que celle de A, ils ne mesureront
pas la même durée entre leurs rencontrent, $`\Delta t^{\,A}_{1\,2}=`t^{A}_{2}-`t^{A}_{1}`$ pour A 
et $`\Delta t^{\,B}_{1\,2}=`t^{B}_{2}-`t^{B}_{1}`$ pour B. Leurs horloges synchronisées en
$`t^{A}_{1} = t^{B}_{1}`$ n'afficheront plus la même heure : $`t^{A}_{1} < t^{B}_{1}`$.
S'ils avaient le même âge en $`t^{A}_{1} = t^{B}_{1}`$, B accéléré à plus vieillit que A galiléen.

faire lien avec paradoxe des jumeaux

et à faire dans un points "pour aller plus loin" : l'effet est inversé en relativité restreinte, qui
décrit mieux la réalité que la mécanique classique. Une première explication de pourquoi.

<br>


#### Lignes d'univers de deux observateurs galiléens

Représentation de deux observateurs galiléens, en translation l'un par rapport à
l'autre à la vitesse V

figure à faire

la vitesse V équivaut à un angle $`\alpha`$ entre les lignes d'univers des deux observateurs,
tel que $`tan \alpha = \dfrac{V}{c}`$, à faire

<br>

## <p style="font-size:70%;text-align: center;">Dilatation des longueurs , contraction du temps , relativité de la simultanéïté</p>


#### Présentation de la scène d'étude :<br> un train, une gare et des observateurs

##### Les observateurs

* Pour accompagner les démonstrations, considère *quatre observateurs* auxquels
tu pourras t'identifier,   
**Alba, Benjamin, Cédric, Diana**   
qui seront *respectivement représentés* ou symbolisés sur les animations par les 
lettres **A, B, C, D**.

* *Chacun possède* 
   * **une horloge** identique à celles des autres.
     **Immobile** par rapport à l'observateur, elle lui indique son *temps propre* et lui
     permet de déterminer sa *durée propre* entre deux évènements.   
   <br>
   * Un dispositif expérimental **équivalent d'une règle rigide** pour la **mesure instantanée de longueurs**,
     identique à celui des autres.  
     **Immobile** par rapport à l'observateur lors des mesures de longueurs, il lui permet la mesure de la *distance propre* entre deux corps distincts ou 
     de la *longueur propre* d'un corps rigide, dans toutes les directions de l'espace.   
     _Ce dispositif est symbolisé par une règle sur les schémas._

! *Note :*   
! Tu vas mettre en évidence des différences de durées entre deux mêmes évènements
! et des différences de longueurs d'un même corps rigide, selon que les observateurs
! galiléens qui réalisent les mesures sont immobiles ou en mouvement relatif l'un
! par rapport à l'autre.
! Ces effets affectent aussi les instruments de mesure.
! Aussi, pour que chaque observateur mesure bien des durées dans son propre temps et des longueurs
! dans son propre espace, il est nécessaire que les instruments de mesure
! soient immobiles par rapport à lui.

  
A faire : figure des 4 personnages avec chacun sa montre et sa règle rigide.


##### La scène

![](train-positions-persons-ABCD_L1200.jpg)

* **A, B et C** (Benjamin, Cédric et Diana) sont *assis dans un train*,
   * **B et D** sur des places situées sur une *même rangée*.
   * **B et C** sur des places *coté fenêtre* d'un même côté du train.
* **A** (Alba) est debout, *immobile sur le quai* de la gare.
   
* Les *animations* sont faites à tout instant où **A, B et D** 
  *sont alignés*, donc perpendiculairement à la direction des rails.   

<!-----
*  *Deux cas* sont étudiés, lorsque   
   1. le **train** est *à l'arrêt* en gare.
   2. le **train** *passe en gare à vitesse constante*, donc sans s'arrêter, les rails étant rectilignes.

A faire : figure des deux cas.

----->

<br>

!! Pour aller plus loin : A faire
!! Le rôle de l'avènement des chemins de fer à la fin du 19<sup>ème</sup> siècle,
!! sur le chemin de la révolution relativiste des notions d'espace et de temps,
!! avant, clochers des villages sonnaent midi quand le soleil était au zénith, problème
!! chaque village avait sa propre heure, chemin de fer nécessite de définir un temps
!! (classique) uniforme à l'échelle d'un compagbie de chemin de fer, d'un pays...
!! D'où un départ de réflexions ... Einstein,
!! et ici le choix du train pour étudier les effets relativistes.

<br>

<!--
#### Voyageurs assis dans le train : un espace et un temps partagé

A faire

!! *Pour aller plus loin* , à faire   
!! Vers la notion de référentiel (niveau 3 et 4), et notamment discussion de
!! la définition d'un référentiel parfois rencontrée qui inclut tous les corps
!! immobiles entre eux. En retrouver.-->

<!---

#### Le train est stationné en gare

<br>

![](train-speed-0-persons-ABCD_L1200.jpg)

à faire, continuer, améliorer

* **B, C et D** (Benjamin, Cédric et Diana) sont *assis dans le train*. 
* **A** (Alba) est *sur le quai* de la gare, devant le *train à l'arrêt*.
* Tous, A, B, C et D sont *immobiles les uns par rapport aux autres*,   
  donc **leurs lignes d'univers sont parallèles** entre elles,     
  <br>
  toutes les **durées** qu'ils mesureront *entre deux mêmes évènements* donneront le
  *même résultat*.

* A chaque instant, ils partagent alors un même espace,    
  donc les **mesures de distance** qu'ils réaliseront entre eux-mêmes ou entre deux mêmes corps,
  les mesures **de longueur** d'un même objet rigide selon toutes les directions possibles
  donneront le *même résultat*.

* Ainsi **deux évènements sumiltanés pour l'un** d'entre eux seront *simultanés pour les autres*.

* Leurs montres indiquent respectivement les temps :   
**$`\mathbf{\hspace{1cm}t^A}\quad`$** pour *A (Alba)*,     
**$`\mathbf{\hspace{1cm}t^B}\quad`$** pour *B (Benjamin)*,         
**$`\mathbf{\hspace{1cm}t^C}\quad`$** pour *C (Cédric)*,      
**$`\mathbf{\hspace{1cm}t^D}\quad`$** pour *D (Diana)*.    
<br>
**S'ils synchronisent leurs montres**, alors à tout instant leurs montres indiquent
la *même heure* :   
**$`\mathbf{\hspace{1cm}t^A = t^B = t^C = t^D}`$**

<br>

figure à faire, partage d'un même espace instantané pour A, B, C et D

<br>

![](train-euclidian-space-time-3D-peopleABCD-v0_L1200.jpg)

<br>

![](train-euclidian-space-time-2D-peopleABCD-v0_L1200.gif)

<br--->

#### Le train ne s'arrête pas, il passe en gare à vitesse constante

<br>

à faire


![](train-speed-V-persons-ABCD_L1200.jpg)


<br>

 ![](train-euclidian-space-time-3D-peopleABCD-vV_L1200.jpg)

<br>

![](train-euclidian-space-time-2D-peopleABCD-vV_L1200.gif)

<br>

* La **perception par A** (Alba) du **mouvement de B** (Benjamin) est celle :

   * d'un *espace immobile* car vécu toujours au présent
   * du *temps qui passe*
   * de *Benjamin qui se déplace* avec le temps,   
     _et au-delà, de corps matériels immobiles ou en mouvement._
   * La partie grise n'existe pas pour A, seul existe au présent son espace tridimensionnel et les
     êtres ou corps qui s'y déplacent.

![](human-perception-of-space-and-time-0_L1200.gif)

* L'interprétation de cette perception dans le cadre d'un espace-temps euclidien (fictif) donne :   
  <br>
la **position de B dans l'espace de A** est celle où la *ligne d'univers de B croise l'espace de A*.  
<br>


![](euclidian-space-time-1-inertial-observators_L1200.gif)


* Adopte maintenant le **point de vue spatio-temporel quadridimensionnel**, comme un être qui verrait à la fois
  l'esoace et le temps du passé au futur.

 ![](euclidian-space-time-2-inertial-observators_L1200.gif)

* Les **lignes d'univers de A et de B** sont *visibles dans leur étendue*.
* Pour A comme pour B, **à chaque instant propre** sur sa ligne d'univers, et 
  *normal à la ligne d'univers* s'étend l'*espace propre* tridimensionnel.
* **Pour A**, dans l'espace propre, **B est localisé** au *point d'intersection* entre la *ligne d'univers de B* et l'*espace propre de A*.   
  de même   
  **Pour B**, dans l'espace propre, **A est localisée** au *point d'intersection* entre la *ligne d'univers de A* et l'*espace propre de B*.   
 

à terminer, remarquer simplement que les lignes d'univers d'Alba et Benjamin n'étant pas parallèles 
le temps s'écoule différemment pour eux, 
et que leurs espaces instantanés se croisant mais étant disjoints, les longueurs mesurées par eux
seont différentes. Question de projections d'un sègment de la ligne d'univers de Benjamin 
entre deux instants (invariant par nature dans l'espace-temps euclidien) sur les axes temporels (lignes d'univers) de A et B
et sur les espaces instantanés de A et B.

<br>

##### Un temps fictif relatif, <br>avec contraction du temps des corps en déplacement


3 figures à faire 

avec la calcul du facteur multiplicatif de contraction du temps

puis

![](euclidian-space-time-time-contraction-3_L1200.jpg)

<br>


#### Dilatation des longueurs des corps en déplacement

A faire :

idée , avec figure :
dans un espace 3D euclidien, l'intersection de deux plans (2D) est une droite (1D),
cette droite est commune aux deux plans.
de même dans un espace-temps euclidien (4D), l'intersection de deux espaces (3D) est
une surface (2D), cette surface est commune aux deux espaces.
Et dans chaque espace, la direction du mouvement observée est normale à cette surface commune.
Idée qui sera montrée :
les longueurs qui s'inscrivent dans la surface commune sont perçues et mesurées égales,
les longueurs qui s'inscrivent dans la direction du mouvement appartiennent à deux espaces différents,
et donc seront perçues et mesurées différentes.
Ce sont les deux cas étudiés ci-dessous :


##### Conservation des longueurs perpendiculaires au déplacement

A faire, figures et animations à faire

première figure ;

![](train-euclidian-spece-time-conservation-perpendicular-V-distances-1-v4.gif)

deuxième figure :

à faire

<br>

##### Dilatation des longueurs dans le sens du déplacement

A faire, figures et animations à faire

première figure : (longueurs différentes)

![](train-euclidian-spece-time-dilatation-parallel-V-distances-1_L1200.gif)

deuxième figure : (démonstration du rapport de dilataion)   

à faire

je commence à rentrer la démonstration, sera à compléter, améliorer, simplifier, corriger si-besoin.
Pour l'instant, c'est confus et pâteux d'un boit à l'autre ...

* Benjamin, Cédric et Diana sont assis dans le wagon. Ils sont donc immobiles l'un par rapport à l'autre.

* **Benjamin mesure $`\mathbf{\Delta l^B_{BC}}`$**, *distance entre* lui-même *Benjamin, et Cédric*.

* **Alba mesure**, à l'aide d'une règle identique à celle de Benjamin, une 
  *distance $`\mathbf{\Delta l^B_{BC}}`$ entre Benjamin et Cédric*.

* Le train, donc **Benjamin, et Cédric** se déplace à la *vitesse $`\mathbf{V}`$* par rapport au quai, 
  donc *par rapport à Alba*.

* **Benjamin perçoit Cédric** dans son espace propre *au point $`\mathbf{C^B}`$*, interection 
  entre son espace propre et de la ligne d'univers de Cédric.
  <br>
  **Alba perçoit Cédric** dans son espace propre *au point $`\mathbf{C^A}`$*, interection 
  entre son espace propre et de la ligne d'univers de Cédric.
  <br>
  **Alba et Benjamin mesurent** chacun dans son propre espace la *distance $`\mathbf{L_{BC}}`$* entre Benjamin et Cédric.    
  Les résultats de mesure sont différents et sont notés :
   * **$`\mathbf{\Delta l_{BC}^{\;A}}\quad`$** *pour Alba*
   * **$`\mathbf{\Delta l_{BC}^{\;A}}\quad`$** *pour Benjamin*   

<br>

* **Benjamin**, pour **quadriller son propre espace-temps**, choisit le système de 
  *coordonnées cartésiennes $`\mathbf{(B, ct^B, x^B, y^B, z^B)}`$* 
  tel que :
   * **$`\mathbf{Bct^B}`$**  soit son *axe temporel*,
   * **$`\mathbf{Bx^B}`$**  soit l'axe dirigé *en direction du mouvement du train* par rapport à la gare, 
   * **$`\mathbf{By^B}`$ et $`\mathbf{Bz^B}`$** sont des axes *perpendiculaires entre eux, 
   et* aux axes *$`\mathbf{Bx^B}`$ et  $`\mathbf{Bct^B}`$*.

<br>

* **Alba**, pour **quadriller son propre espace-temps**, choisit le système de 
  *coordonnées cartésiennes $`\mathbf{(ct^A, x^A, y^A, z^A)}`$* 
  tel que :
   * **$`\mathbf{Act^A}`$**  soit son *axe temporel*,
   * **$`\mathbf{Ax^A}`$**  soit l'axe dirigé *en direction du mouvement du train* par rapport à la gare, 
   * **$`\mathbf{Ay^A}`$ et $`\mathbf{Az^A}`$** sont des axes *perpendiculaires entre eux, et* 
     aux axes *$`\mathbf{Ax^A}`$ et $`\mathbf{Act^A}`$*.
 

##### *Étape 1*

figure à faire, b)

* *Cédric est immobile par rapport à Benjamin*, **sa ligne d'univers** est donc parallèle
  à celle de Benjamin, donc **parallèle à l'axe $`\mathbf{Bct^B}`$**.   
  <br>
  Elle **coupe les espaces propres** de Benjamin et d'Alba respectivement **en $`\mathbf{C^B}`$ et $`\mathbf{C^A}`$**.

* Le **triangle $`\mathbf{(B, C^B, C^A)}`$** est situé dans un *plan spatio-temporel*,   
  contenant les *axes $`\mathbf{Bct^B}`$, $`\mathbf{Bx^B}`$*.

* Les *coordonnées $`\mathbf{(ct^B, x^B, y^B, z^B)}`$* étant *cartésiennes*,    
  alors les axes $`Bct^B`$ et $`Bx^B`$ sont orthogonaux,   
  et donc le **triangle $`\mathbf{(B, C^B, C^A)}`$** est **rectangle en $`\mathbf{C^B}`$**.

* L'*espace-temps* est *euclidien*, donc le **théorème de Pythagore** est **vrai** 
  pour tout triangle rectangle de l'espace-temps.   
  <br>
  *Appliqué au triangle rectangle $`\mathbf{(B, C^B, C^A)}`$* il donne :   
  <br>
  **$`\Large{\boldsymbol{\mathbf{(\Delta l_{BC}^{\;A})^2 = (\Delta l_{BC}^{\;B})^2 + \Lambda^2}}}\quad`$** (éq.1)   
  <br>
  en posant *$`\boldsymbol{\mathbf{\Lambda = C^AC^B}}`$*.

  
##### *Étape 2*

figure à faire, c)

* *Benjamin*, immobile dans le train *se déplacant à la vitesse $`\mathbf{V}`$* vers la droite 
*par rapport à Alba* immobile sur le quai de la gare,   
l'**axe $`\mathbf{Bct^B}`$** est **tourné d'un angle $`\boldsymbol{\mathbf{\alpha = arctan(V/c)}}`$** 
dans le plan $`(B,C^B, C^A)`$ 
*par rapport à* la direction de l'*axe $`\mathbf{Act^A}`$* projeté dans ce plan.   
Le sens de la rotation est indiqué sur la figure.   
<br>
Donc *$`\boldsymbol{\mathbf{\tan\alpha = \dfrac{V}{c}}}`$*.

* La **tangente d'un angle $`\boldsymbol{\alpha}`$** au sommet $`B`$ d'un triangle $`(B, C^B, C^A)`$ 
 rectangle en $`C^B`$ étant égale en valeur à la *longueur du côté opposé $`\boldsymbol{\Lambda}`$
 divisé par la longueur du côté adjacent $`\mathbf{\Delta l_{BC}^{\;B}}`$*, soit :   
 <br>
 *$`\boldsymbol{\mathbf{\tan\alpha = \dfrac{V}{c}=\dfrac{\Lambda}{\Delta l_{BC}^{\;B}}}}`$*   
<br>
Tu en déduis alors :   
<br>
*$`\boldsymbol{\mathbf{\Lambda = \Delta l_{BC}^{\;B} \times \dfrac{V}{c}}}`$*   
<br>
et en particulier :   
<br>
**$`\Large{\mathbf{\boldsymbol{\Lambda^2 = (\Delta l_{BC}^{\;B})^2 \times \dfrac{V^2}{c^2}}}}\quad`$** (éq.2)

##### *Étape finale*

figure à faire, d)

* Les équations (éq.1) et (éq.2) te permettent alors de trouver, dans cet espace-temps euclidien fictif, 
le rapport de dilatation des longueurs $`\beta_{euclid.}^{esp-tps}`$ lorsque l'on passe d'une longueur
en direction du vecteur .... blabla bla...   
<br>
$`\boldsymbol{\mathbf{(\Delta l_{BC}^{\;A})^2 = (\Delta l_{BC}^{\;B})^2 + \Lambda^2}}\quad`$ (éq.1)   
<br>
$`\hspace{1,7 cm} \color{blue}{\scriptsize{\text{remplace  } \Lambda^2} \text{  par  } (\Delta l_{BC}^{\;B})^2 \times (V^2\,/\,c^2)\text{ ,  (éq.2)}}`$    
<br>
$`\mathbf{\hspace{1,7 cm} = (\Delta l_{BC}^{\;B})^2 + (\Delta l_{BC}^{\;B})^2 \times \dfrac{V^2}{c^2}}`$      
<br>
$`\mathbf{\hspace{1,7 cm} = (\Delta l_{BC}^{\;B})^2 \times \left( 1 + \dfrac{V^2}{c^2}\right)}`$   

* Tu en déduis alors      
<br>
*$`\Large{\mathbf{\Delta l_{BC}^{\;A} = \Delta l_{BC}^{\;B} \times \sqrt{1 + \dfrac{V^2}{c^2}}}}`$*

à terminer


##### Synthèse

à faire 

idée

Conservation des distances et longueurs dans le sens perpendiculaire au déplacement :

*$`\Large{\mathbf{L_{\perp} = L_0}}`$*

Dilatation des distances et longueurs dans le sens parallèle au déplacement :

**$`\Large{\mathbf{L_{\parallel} = L_0 \times \sqrt{1 + \dfrac{V^2}{c^2}}}}`$**


!! *Pour aller plus loin*
!! speech sur le signe plus qui devient moins en relativité restreinte.
!! On parle alors de contraction des longueurs
!! Facteur de Lorentz qui vient expérince de Mickelson-Morley
!! mettre cela au point


<br>


##### Relativité de la simultanéïté

A faire, figures et animations à faire

<br>

##### Contraction des durées

A faire, figures et animations à faire

<br>

##### Loi de composition des vitesses

A faire, figures et animations à faire

<br>

## <p style="font-size:70%;text-align: center;">Des paradoxes apparents qui n'en sont pas</p>

A faire

<br>


## <p style="font-size:70%;text-align: center;">Cônes de lumières</p>

A faire

![](euclidian-space-time-3D-A-1_L1200.gif)
_test de figure,<br>

<br>

Représentation de cônes de lumières le long des lignes d'univers

![](world-line-galilean-non-galilean-0-fr_L1200.jpg)
![](world-line-light-cone-galilean-non-galilean-1_L1200.jpg)
_test de figure,<br>

## <p style="font-size:70%;text-align: center;">figure en attente<br> de positionnement</p>


![](maxim-1-euclidian-space-time-fr_L1200.jpg)   

<!--

![](maxim-1-euclidian-space-time-es_L1200.jpg)   

![](maxim-1-euclidian-space-time-en_L1200.jpg)   

<br><br> -->

![](maxim-2-euclidian-space-time-fr_L1200.jpg)  

<!--

![](maxim-2-euclidian-space-time-es_L1200.jpg) 


![](maxim-2-euclidian-space-time-en_L1200.jpg)   


choix des coordonnées xyt pour la prochiane figure

<br>  -->

<p style="font-family:'Times New Roman';font-weight:bold;font-size:1.15rem;text-align:left;color:#009900">Tous les observateurs galiléens partagent</p>
<hr width=100% size=6px border-style="solid" color=#00bb33>
<p style="font-family:'Times New Roman';font-weight:bold;font-size:1.15rem;text-align:left;color:#bbbbbb">un <span style="color:#0066cc"> invariant spatio-temporel<br>
<span style="font-family:'Times New Roman';margin-left:30px;font-weight:bold;font-size:0.85rem;text-align:right;color:#6699cc">entre deux évènements A et B de l'espace-temps </span><br>
<span style="font-family:'Times New Roman';font-weight:bold;font-size:1.15rem;color:#bbbbbb">appelé 
</span><span style="font-family:'Times New Roman';font-weight:bold;font-size:1.15rem;left;color:#bb3300"> interval
<span style="font-family:'Times New Roman';font-weight:bold;font-size:1.15rem;text-align:left;color:#bbbbbb"> et noté</span>
<span style="font-family:'Times New Roman';font-weight:bold;font-size:1.15rem;text-align:left;color:#bb3300"> s<sub>AB</sub></span><br>
<span style="font-family:'Times New Roman';font-weight:bold;font-size:1.15rem;text-align:left;color:#bbbbbb">d'expression</span><br>
<span style="font-family:'Times New Roman';margin-left:30px;font-weight:bold;font-size:0.85rem;text-align:left;color:#009900"">en coordonnées spatio-temporelles cartésiennes</span></p>
$`\large{\mathbf{\color{#009900}{s_{AB}=\sqrt{(c\,\Delta t_{AB})^2+(\Delta l_{AB})^2}}}}`$
<p style="font-family:'Times New Roman';font-weight:bold;font-size:0.85rem;text-align:left;color:#bbbbbb">avec</p>
$`\color{#009900}{\Delta l_{AB}=\sqrt{(x_B-x_A)^2+(y_B-y_A)^2+(z_B-z_A)^2}}`$
$`\color{#009900}{\Delta t_{AB}=|t_B-t_A|=\sqrt{(t_B-t_A)^2}}`$
<hr width=100% size=6px border-style="solid" color=#00bb33>


et autres figures à venir

Chapitrage :

A

I - ... (système de coordonnées propores d'un observateur)

Système de coordonnées spatiotemporelles : (x,t) (x,y,t) (x,y,z,t)

Ligne d'univers

Perception spatiale instantanée


II - Observation de corps immobiles ou en mouvement

III Système de coordonnées propres d'un corps en mouvement

IV Transformation des durées et des longueurs

B

I relativité de l'espace temps

II principe de relativité d'Einstein

III Les transformations de Lorentz

C (Dynamique des corps en mouvement relatifs)

D (Ebergétique des xorps en mouvement relatifs)




<br>
