---
title: Maxwell's equations, foundation of electromagnetism
published: true
routable: true
visible: true
lessons:
    - slug: maxwell-equations-en
      name: LINEAR - Maxwell's equations
      order: 2
---

<!--MétaDonnée : ... -->

<!--caligraphie de l'intégrale double curviligne-->
$`\def\speed{\mathscr{v}}`$
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\soiint{\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

*Lecture under construction*, **not validated**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-EN_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-7_L1200.jpg)<details>
<summary>Stage 7 : Tested with students</summary>  
1. Brainstorming
2. In structuring
3. In writing : 1/3
4. In writing : 2/3
5. In writing : 3/3
6. Under review
7. Tested with students
8. Validated, still incomplete
9. Validated, sufficient basis
10. Validated, operational, in constant improvement
</details>

<!--MétaDonnée : ... -->

##### Mountain pathway :&nbsp; _Physics_
---------------------------

### ELECTROMAGNETISM

### **Maxwell’s Equations**<br>*and the electromagnetic field $`(\overrightarrow{E}, \overrightarrow{B})`$*

<br><br>
[multilingual version : EN , FR , ES](https://m3p2.com/polyglot/temporary_ins/electromagnetism-in-vacuum/maxwell-equations/overview)
<br>

SUMMARY
: ---

  *Domain of validity*:
  Very general. In vacuum, and even in matter if the observation scale is not mesoscopic,
  but atomic.
  However, a more accurate description of matter at the atomic scale
  requires the use of quantum physics.

  *Note: The expressions below are only valid in the International System of Units ($`SI`$), formerly $`MKS`$.*

  ---
  *Local form of Maxwell’s equations*

  * At every point in space and at every instant:
  <br>
  $`\left\{\begin{array}{l}
  \text{div } \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}\quad \small{(Maxwell-Gauss)}\\
  \text{div } \overrightarrow{B} = 0\quad \small{(Maxwell-Thomson)}\\
  \overrightarrow{\text{curl}} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}\quad\small{(Maxwell-Faraday)}\\
  \overrightarrow{\text{curl}} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\\
  \hspace{3.5cm}\small{(Maxwell-Ampère)}
  \end{array}\right.`$
  <br>
  with $`\dens`$ volume charge density
  &nbsp;&nbsp; and $`\overrightarrow{j}`$ volume current density vector.

  * $`\Longrightarrow`$ charge conservation:
    $`\text{div}\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0`$

  * $`\Longrightarrow`$ propagation in vacuum
    of the electromagnetic (EM) wave, the variable part of the electromagnetic field:
    <br>
    $`\left\{\begin{array}{l}
    \Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}\\
    \Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}
    \end{array}\right.`$
    <br>
    at the speed $`c=299,792,458 \, \text{m}\,\text{s}^{-1}\approx 3\times 10^8 \, \text{m}\,\text{s}^{-1}`$,
    a fundamental constant of nature.

  * $`\Longrightarrow`$ the EM field contains energy,
    in volume density:
    $`\small{\dens}_{\text{energ.EM}} = \dfrac{\epsilon_0\,\overrightarrow{E}\cdot\overrightarrow{E}}{2}+\dfrac{\overrightarrow{B}\cdot\overrightarrow{B}}{2\mu_0}`$

  * $`\Longrightarrow`$ every $`\overrightarrow{dS}`$ receives EM power:
    $`d\overrightarrow{\mathcal{P}}_{EM}=\overrightarrow{\Pi}\cdot\overrightarrow{dS}`$
    with $`\overrightarrow{\Pi}=\dfrac{\overrightarrow{E}\times\overrightarrow{B}}{\mu_0}`$ the Poynting vector.

  * $`\Longrightarrow`$ the EM field yields energy to matter via the Joule effect:
    $`\mathcal{P}_{\text{ceded}} = \overrightarrow{j}\cdot\overrightarrow{E}\,d\tau`$

  * $`\Longrightarrow`$ every accelerated charged particle generates an electromagnetic wave.

<br>

#### What was Maxwell’s work?

* *Until the mid-14th century*, **electricity, magnetism, and optics** were studied in *distinct scientific fields*.

* However, *observations of natural phenomena and laboratory experiments* revealed an
  **unexplained interaction between electricity, magnetism,** and even **optics**.
    * Natural: lightning can charge metallic objects, magnetize iron, and create a flash.
    * Experiments:
      \- A current deflects a compass needle.
      \- Moving a magnet creates a current.

* A skilled mathematician, **Maxwell** *synthesized the experimental results* of his time
  into 4 equations, the *Maxwell’s equations*.

* These 4 equations **unify electricity, magnetism, and optics** within electromagnetism,
  and expand optics to a *new world: electromagnetic waves*.

<br>

![Maxwell's Equations](Maxwell-equation-en.png)
_Maxwell modified two of the equations of electrostatics and magnetostatics by_
_introducing coupling terms between E and B,_
_thus revolutionizing physics._

#### Why do we say "equations" and not "theorems" of Maxwell?

* The **4 Maxwell’s equations** *are not proven*, so they do not constitute theorems.
* They are *stated and assumed true*, they **are postulates**.

<!-----------------
#### Why do these equations found electromagnetism?

#### What is the domain of validity of these equations?
------------------>

<br>

------------

<br>

#### What are these 4 Maxwell’s equations?

##### Local form

* Two **divergence expressions** of the fields $`\overrightarrow{E}`$ and $`\overrightarrow{B}`$ *unchanged from the stationary case* (electrostatics and magnetostatics):

   * **$`\large{\mathbf{\text{div } \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}}}`$** &nbsp;&nbsp;&nbsp;(eq. *Maxwell-Gauss*).

   * **$`\large{\mathbf{\text{div } \overrightarrow{B} = 0}}`$** &nbsp;&nbsp;&nbsp;(eq. *Maxwell-Thomson*).

* Two **curl expressions** of the fields $`\overrightarrow{E}`$ and $`\overrightarrow{B}`$ that *change and couple the fields $`\mathbf{\overrightarrow{E}}`$ and $`\mathbf{\overrightarrow{B}}`$*:

   * **$`\large{\mathbf{\overrightarrow{\text{curl}} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}}`$**
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(eq. *Maxwell-Faraday*).

   * **$`\large{\mathbf{\overrightarrow{\text{curl}} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}}`$**
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(eq. *Maxwell-Ampère*).

* where:
   * $`\dens=\dens^{3D}`$ is the volume charge density.
   * $`\overrightarrow{j}=\overrightarrow{j}^{3D}`$ is the volume current density vector.

------------------

* And these equations *rewritten with the nabla operator: $`\mathbf{\nabla}`$*:

   * **$`\mathbf{\nabla\cdot\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}}`$**

   * **$`\mathbf{\nabla\cdot\overrightarrow{B}=0}`$**

   * **$`\mathbf{\nabla\times\overrightarrow{E}= -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$**

   * **$`\mathbf{\nabla\times\overrightarrow{B}= \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$**

------------------

##### Integral form

* They **are deduced from the local equations**, with the help of:
   * the *Divergence Theorem*:
     $`\forall \overrightarrow{X}(\overrightarrow{r})`$:
     *$`\displaystyle\iiint_{\tau} \text{div}\,\overrightarrow{X} \cdot d\tau = \displaystyle
\oiint_{S\leftrightarrow\tau} \overrightarrow{X}\cdot\overrightarrow{dS}`$*
   * the *Stokes' Theorem*:
     $`\forall \overrightarrow{X}(\overrightarrow{r})`$:
     *$`\displaystyle\iint_{S} \;\overrightarrow{\text{curl}}\,\overrightarrow{X} \cdot dS
= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$*.

-----------

* **Maxwell-Gauss Equation**:
  At any instant t, and for any volume $`\tau`$:

   * $`\forall \overrightarrow{r},\;`$ *$`\mathbf{\text{div } \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}}`$*
   $`\Longrightarrow \iiint_{\tau} \text{div } \overrightarrow{E}\,d\tau = \iiint_{\tau}\dfrac{\dens}{\epsilon_0}\,d\tau`$

   * $`\left.\begin{array}{l}
   \iiint_{\tau} \text{div } \overrightarrow{E}\,d\tau = \iiint_{\tau}\dfrac{\dens}{\epsilon_0}\,d\tau \\
   \iiint_{\tau} \text{div}\,\overrightarrow{E} \cdot d\tau = \displaystyle
   \oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS}
   \end{array}\right\}`$
   $`\Longrightarrow`$
   **$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS}
   = \dfrac{1}{\epsilon_0} \cdot \iiint_{\tau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0}}`$**

------------

* **Maxwell-Thomson Equation**:   
  <br>
  At any instant t, and for any volume $`\tau`$:

   * $`\forall \overrightarrow{r},\;`$ *$`\mathbf{\text{div } \overrightarrow{B} = 0}`$*
   $`\Longrightarrow \iiint_{\tau} \text{div } \overrightarrow{B}\,d\tau = 0`$

   * $`\left.\begin{array}{l}
   \iiint_{\tau} \text{div } \overrightarrow{B}\,d\tau = 0 \\
   \iiint_{\tau} \text{div}\,\overrightarrow{B} \cdot d\tau = \displaystyle
   \oiint_{S\leftrightarrow\tau} \overrightarrow{B}\cdot\overrightarrow{dS}
   \end{array}\right\}`$
   $`\Longrightarrow`$
   **$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\tau} \overrightarrow{B}\cdot\overrightarrow{dS}= 0}`$**

------------

* **Maxwell-Faraday Equation**:

  At any instant t,
  and for any open and oriented surface $`S`$, immobile and undeformable, supported by a contour $`\Gamma`$ 
  (also immobile and undeformable), with orientation compatible with that of $`S`$ according to the right-hand rule:

   * $`\forall \overrightarrow{r},\;`$ *$`\mathbf{\overrightarrow{\text{curl}} \,\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$*
   $`\Longrightarrow \iint_S \overrightarrow{\text{curl}} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big)`$   
  <br>

   * $`\left.\begin{array}{l}
   \iint_S \overrightarrow{\text{curl}} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big) \\
   \text{Newton: space and time independent,} \\
   \text{order of derivation/integration} \\
   \text{does not matter}
   \end{array}\right\}`$
   $`\Longrightarrow`$
   $`\iint_S \overrightarrow{\text{curl}} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big)`$   
   <br>

   * $`\left.\begin{array}{l}
   \iint_S \overrightarrow{\text{curl}} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big) \\
   \iint_{S} \;\overrightarrow{\text{curl}}\;\overrightarrow{E} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}
   \end{array}\right\}`$
   $`\Longrightarrow`$
   **$`\begin{array}{l}
     &nbsp; \\
    \mathbf{\displaystyle\quad\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}= -\dfrac{d}{dt}\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}}
   \end{array}`$**   
   <br>
   * This equation plays an *important role in Neumann's induction phenomena*.   
   _The quantity_ $`\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}`$
   _with the historically imperfect name "electromotive force (emf)", homogeneous to a voltage, is the origin of an electric current_
   _flowing through the contour $`\Gamma`$ if it represents a conductive circuit._

---------------

* **Maxwell-Ampère Equation**:

  At any instant t,
  and for any open and oriented surface $`S`$, fixed and undeformable, supported by a contour $`\Gamma`$
  with orientation compatible with that of $`S`$ according to the right-hand rule :
  <br>

  $`\forall \overrightarrow{r},\;`$ *$`\mathbf{\overrightarrow{\text{curl}} \,\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$*
  $`\Longrightarrow`$ $` \iint_S \overrightarrow{\text{curl}} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS}`$
  <br>

  $`\left.\begin{array}{l}
  \iint_S \overrightarrow{\text{curl}} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS} \\
  \text{Newton: space and time independent},\\
  \text{order derivation/integration does not matter}
  \end{array}\right\}`$
  $`\Longrightarrow`$
  $`\iint_S \overrightarrow{\text{curl}} \,\overrightarrow{B}\cdot\overrightarrow{dS}`$ $`\; = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
  \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}`$
  <br>

  $`\left.\begin{array}{l}
  \iint_S \overrightarrow{\text{curl}} \,\overrightarrow{B}\cdot\overrightarrow{dS} \\
  \quad = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
  \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS} \\
  \iint_{S} \;\overrightarrow{\text{curl}}\;\overrightarrow{B} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}
  \end{array}\right\}`$
  $`\Longrightarrow`$

  **$`&nbsp;\mathbf{\displaystyle\;\,\oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}}`$
  $`\;\mathbf{\displaystyle= \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +\mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}}`$**

<br>

------------

<br>

#### Why do we speak of an electromagnetic field?

* The 2 coupling equations of $`\overrightarrow{E}`$ and $`\overrightarrow{B}`$ imply
  that **variables, $`\overrightarrow{E}`$ and $`\overrightarrow{B}`$ cannot exist without each other**.

* The term *$`\dfrac{\partial\overrightarrow{B}}{\partial t}\ne 0`$ implies $`\overrightarrow{E}\ne \overrightarrow{0}`$*
* The term *$`\dfrac{\partial\overrightarrow{E}}{\partial t}\ne 0`$ implies $`\overrightarrow{B}\ne \overrightarrow{0}`$*

<br>

-------------

<br>

#### What do Maxwell's equations say about charge conservation?

##### Law of conservation of electric charge

* In matter, **electric charges** are carried by *electrons* and
  *protons* in atomic nuclei. *In classical physics*, these particles exist,
  and they **can neither emerge from nothing nor disappear**.

* Thus, the **principle of conservation of electric charge** can be summarized in one sentence:
  <br>
  ! *In any volume of space and over a given duration, the electric charge*
  ! *entering this volume minus the electric charge*
  ! *leaving it is equal to the change in charge within the volume.*

  <br>
  This is expressed mathematically by the **integral expression** :   
  <br>
  For any closed surface $`S`$ bounding a macroscopic volume $`\tau`$,   
  <br>
  **$`\mathbf{\oiint_{S\leftrightarrow\tau}\overrightarrow{j}\cdot\overrightarrow{dS}+\iiint_{\tau}\dfrac{\partial\dens}{\partial t}\cdot d\tau=0}`$**
  <br>
  which states:
  <br>
  ! *The flux of the volume current density vector through a closed surface*
  ! *is equal to the time derivative of the total charge contained within this closed surface.*

  ![Charge conservation law](charge-conservation-law-L1200.jpg)

* Since this equality holds for any integration volume, it must apply to the integrands themselves.
  $`\Longrightarrow`$ The conservation law also has a **local expression**, valid at every point in space, which is written as :   
  <br>
  **$`\mathbf{\text{div}\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0}`$**   

<br><br>

![Charge conservation](charge-conservation-1-L1200.jpg)

<br>

##### Study of Maxwell's equations

* **Let's start** with the remarkable operator combination, valid for any vector field $`\overrightarrow{U}`$,
  which states :   
  *"The divergence of the curl of a vector field is always zero."*   
  <br>
  $`\forall \overrightarrow{X}\big(\overrightarrow{r},t\big)\;,`$*\$`\quad \mathbf{\text{div}\big(\overrightarrow{\text{curl}}\,\overrightarrow{X}\big)=0}`$*.
  <br>
  and apply it to the magnetic induction field $`\overrightarrow{B}`$ :   
  <br>
  **$`\mathbf{\text{div}\big(\overrightarrow{\text{curl}}\,\overrightarrow{B}\big)=0}`$**.

* The *Maxwell-Ampère law*   
  *$`\overrightarrow{\text{curl}}\,\overrightarrow{B}=\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$*   
  allows us to write :   
  <br>
  **$`\mathbf{\text{div}\Big(\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0}`$**   

* Dividing both sides by $`\mu_0`$, the equation simplifies to :   
  <br>
  $`\text{div}\Big(\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

* The equation already contains $`\overrightarrow{j}`$, I seek to make $`\dens`$ appear.
  To do this, I seek to make $`\text{div}\,\overrightarrow{j}`$ appear in order to then use the Maxwell-Gauss law.   
  <br>
  $`\text{div}\,\overrightarrow{j} + \text{div}\Big(\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

<!--------------------
Since space and time are decoupled in classical physics, the order of differentiation
and integration does not matter if one applies to spatial coordinates
and the other to time. Thus:

$`\text{div}\,\overrightarrow{j} +
\dfrac{\partial}{\partial t}\Big(\epsilon_0\, \text{div}\,\overrightarrow{E}\Big)=0`$

which allows us to write,

$`\text{div}\,\overrightarrow{j} + \dfrac{\partial\dens}{\partial t}=0`$

I recognize here the law of conservation of charge.
----------------------->

* In the context of *classical physics, space and time are independent*,
  the order of derivation with respect to a spatial variable and a time variable does not matter :   
  <br>
  *$`\dfrac{\partial}{\partial t}\left(\dfrac{\partial}{\partial x}\right) =\dfrac{\partial}{\partial x}\left(\dfrac{\partial}{\partial t}\right)`$*
      * The divergence operator consists only of partial derivatives with respect to spatial variables.
      * $`\dfrac{\partial}{\partial t}`$ is a partial derivative with respect to the time variable.

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*$`\Longrightarrow\quad \text{div}\left(\dfrac{\partial}{\partial t}\right)= \dfrac{\partial}{\partial t}\left(\text{div}\right)`$*.

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;We obtain :   

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**$`\mathbf{\text{div}\,\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial}{\partial t}\left(\text{div}\,\overrightarrow{E}\right)=0}`$**

* Using the *Maxwell-Gauss law $`\text{div}\,\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}`$*
  <br>
  we obtain the **local equation of conservation of electric charge** in a time-varying regime (thus always valid) :   
  <br>
  **$`\mathbf{\text{div}\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0}`$**

! *Maxwell's equations contain and imply the conservation of electric charge.*

<!--Rather for main part--------------------

* We need to express the charge distributions $`\dens^{3D}`$ and the volume current density vector $`\overrightarrow{j}^{3D}`$.
  For this, we use the Maxwell-Ampère law:
  * $`\overrightarrow{\text{curl}} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$
  <br>
  $`\text{div}\big(
  \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}
  \big)=0`$

* Simplify by dividing both sides by the magnetic constant $`\mu_0`$:
  <br>
  $`\text{div}\,\big(
  \;\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}
  \big)=0`$

* In the context of classical physics, space and time are independent, the order of derivation with respect to a spatial variable and a time variable does not matter:

  $`\dfrac{\partial}{\partial t}\left(\dfrac{\partial}{\partial x}\right) =\dfrac{\partial}{\partial x}\left(\dfrac{\partial}{\partial t}\right) `$
      * The divergence operator consists only of partial derivatives with respect to spatial variables.
      * $`\dfrac{\partial}{\partial t}`$ is a partial derivative with respect to the time variable.
  $`\Longrightarrow\quad \text{div}\left(\dfrac{\partial}{\partial t}\right)= \dfrac{\partial}{\partial t}
  \left(\text{div}\right)`$.
  We obtain:
  <br>
  $`\text{div}\,\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial}{\partial t}
  \left(\text{div}\,\overrightarrow{E}\right)=0`$

* Using the Maxwell-Gauss law $`\text{div}\,\overrightarrow{E}=\dfrac{\dens^{3D}}{\epsilon_0}`$, we obtain the local equation of conservation of electric charge in a time-varying regime (thus always valid):
  <br>
  $`\text{div}\,\overrightarrow{j} +\dfrac{\partial \dens^{3D}}{\partial t}=0`$
--------------------->

* We can *integrate this local equality* over any volume $`\tau`$ :   
  <br>
  $`\displaystyle\iiint_{\tau} \Big(\text{div}\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}\big)\,d\tau=0`$     
  <br>
  *$`\displaystyle\iiint_{\tau} \text{div}\,\overrightarrow{j}\,d\tau+\iiint_{\tau}\dfrac{\partial \dens}{\partial t}\,d\tau=0`$*   

* The *Divergence Theorem* (= *Gauss's Theorem*) states that for any vector field
  $`\overrightarrow{U}`$ and any volume $`\tau`$,   
  *$`\displaystyle\iiint_{\tau} \text{div}\,\overrightarrow{U}\,d\tau=\oiint_S \overrightarrow{U}\cdot dS`$*,   
  $`S`$ being the closed surface bounding the volume $`\tau`$.   
  <br>
  *Applied to the first term* of the equality, we obtain :   
  <br>
  **$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} + \iiint_{\tau}\dfrac{\partial \dens}{\partial t}\,d\tau=0`$**.   

* Noting again that *space and time are independent in classical physics*, the order of derivation or integration with respect to a spatial variable and a time variable does not matter :   
  <br>
  **$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{\partial}{\partial t} \left(\iiint_{\tau}\dens \,d\tau\right)=0`$**.   

* Noting that *$`\displaystyle\iiint_{\tau}\dens^{3D} \,d\tau`$ is the total charge $`Q_{int}`$*
  contained in the volume $`\tau`$, we obtain the **integral expression of the conservation law** of charge :   
  <br>
  **$`\mathbf{\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{dQ_{int}}{dt}=0}`$**.   

<br>

------------

<br>

#### Can the electromagnetic field yield energy to matter?

##### Power yielded to a charge carrier

* The **sensitivity** of a particle **to electromagnetic interaction** is quantified
  by the parameter called *electric charge* of the particle.

* The force that describes the *action of an electromagnetic field $`\big(\overrightarrow{E}, \overrightarrow{B}\big)`$*
  on a particle with charge $`q`$ is the **Lorentz force**, with the expression :   
  <br>
  **$`\overrightarrow{F}_{Lorentz}=q\Big(\overrightarrow{E}+\overrightarrow{v}\times\overrightarrow{B}\Big)`$**
  <br>
  &nbsp;&nbsp;where $`\overrightarrow{v}`$ is the velocity vector of the particle in the inertial frame of the observer.   

* *During an elementary displacement $`\overrightarrow{dl}`$* of the particle in the electromagnetic field
  $`\big(\overrightarrow{E}, \overrightarrow{B}\big)`$*, the **work of the Lorentz force** is written as :   
  <br>
  **$`d\mathcal{W}_{Lorentz}=\overrightarrow{F}_{Lorentz}\cdot\overrightarrow{dl}`$**,   
  <br>
  that is,   
  <br>
  $`\begin{align}
  d\mathcal{W}_{Lorentz}&=q\Big(\overrightarrow{E}+\overrightarrow{v}\times\overrightarrow{B}\Big)\cdot\overrightarrow{dl}\\
  &\\
  &= q\Big(\overrightarrow{E}\cdot\overrightarrow{dl}\Big)+ q\Big(\overrightarrow{v}\times\overrightarrow{B}\cdot\overrightarrow{dl}\Big)\\
  &\\
  &= q\,\overrightarrow{E}\cdot\overrightarrow{dl} + q\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big) \\
  \end{align}`$   
  <br>
  where $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)`$ is the scalar triple product of the sequence of the three vectors.   

* Since the *vectors $`\overrightarrow{v}`$ and $`\overrightarrow{dl}=\overrightarrow{v}\,dt`$* are *collinear*, the scalar triple product
  is zero :   
  <br>
  *$`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$*,   


!!!! <details markdown=1>
!!!! <summary>Reminders about the scalar triple product</summary>
!!!! The scalar triple product of three vectors $`\vec{a}, \vec{b}, \vec{c}`$, denoted $`(\vec{a}, \vec{b}, \vec{c})`$
!!!! is defined by:
!!!! $`(\vec{a}, \vec{b}, \vec{c})=(\vec{a}\times\vec{b})\cdot\vec{c}`$.
!!!! It is easy to demonstrate that it is invariant under circular permutation of the 3 vectors:
!!!! $`(\vec{a}, \vec{b}, \vec{c})=(\vec{b}, \vec{c}, \vec{a})=(\vec{c}, \vec{a}, \vec{b})`$.
!!!! It is therefore a real number, whose absolute value identifies with the volume of the parallelepiped
!!!! formed by the three vectors $`\vec{a}, \vec{b}, \vec{c}`$.
!!!!
!!!! In the case studied, at least two vectors of the scalar triple product $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)$
!!!! are collinear since $`\overrightarrow{dl}=\overrightarrow{v}\,dt`$.
!!!! I can therefore ensure that this scalar triple product is zero,
!!!! * either by noting that three vectors, two of which are collinear, lie in the same plane (2D)
!!!! and therefore the volume (3D) constructed by these three vectors is zero:
!!!! $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$
!!!! * or by using the invariance of the scalar triple product under circular permutation,
!!!! $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=\Big(\overrightarrow{dl},\overrightarrow{v},\overrightarrow{B}\Big)`$
!!!! $`=dt\times\Big(\overrightarrow{v},\overrightarrow{v},\overrightarrow{B}\Big)`$
!!!! and by noting that the cross product of two collinear vectors is zero:
!!!! $`\big\Vert\overrightarrow{v}\times\overrightarrow{v}\big\Vert=\big\Vert\overrightarrow{v}\big\Vert\cdot\big\Vert\overrightarrow{v}\big\Vert\cdot \sin 0=0`$
!!!! $`\Longrightarrow \overrightarrow{v}\times\overrightarrow{v}=\overrightarrow{0}`$
!!!! $`\Longrightarrow \Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$
!!!! </details>
!!!!

* $`\Longrightarrow`$ the **work of the Lorentz force** simplifies to :   
  <br>
  **$`d\mathcal{W}_{Lorentz} = q\,\overrightarrow{E}\cdot\overrightarrow{dl}`$**

! *Note:*
!
! The *magnetic force $`\overrightarrow{F}_{magn.}=q\,\overrightarrow{v}\times\overrightarrow{B}`$*,
! by nature perpendicular to the velocity vector $`\overrightarrow{v}`$ and thus to the elementary displacement
! vector $`\overrightarrow{dl}=\overrightarrow{v}\,dt`$ at every point on the particle's trajectory
! with charge $`q`$*, *does no work* :   
!
! $`\mathbf{d\mathcal{W}_{magn} = \overrightarrow{F}_{magn}\cdot \overrightarrow{dl}=0}`$
!
! *The work of the Lorentz force is limited to the work of the electric force*:
!
! $`\mathbf{d\mathcal{W}_{Lorentz} = d\mathcal{W}_{elec} =q\,\overrightarrow{E}\cdot \overrightarrow{dl}}`$

* The **elementary power yielded by the field** to this particle is written as:
  <br>
  **$`\mathbf{\mathcal{P}_{yielded} = \dfrac{d\mathcal{W}_{Lorentz}}{dt} = q\,\overrightarrow{E}\cdot\overrightarrow{v}}`$**

##### Power yielded in a material with a single type of charge carrier

* If the **material medium** contains *$`n`$ identical charge carriers of charge $`q`$ per unit volume*,
  then an elementary volume $`d\tau`$ contains $`n\,\tau`$ charge carriers
  and the **elementary power yielded** by the electromagnetic field is written as :   
  <br>
  **$`d\mathcal{P}_{yielded} = n\,\big( q\,\overrightarrow{E}\cdot\overrightarrow{v}\big)\,d\tau`$**   

* Expressed *with the volume charge density $`\rho=n\,q`$* :   
  <br>
  $`d\mathcal{P}_{yielded} = \big(n\, q\big)\,\overrightarrow{E}\cdot\overrightarrow{v}\,d\tau = \rho\,\overrightarrow{E}\cdot\overrightarrow{v}\,d\tau`$   

* Expressed *with the volume current density vector $`\overrightarrow{j}=\rho\,\overrightarrow{v}`$*, noting that
  $`\overrightarrow{E}\cdot\overrightarrow{v}=\overrightarrow{v}\cdot\overrightarrow{E}`$ :   
  <br>
  **$`d\mathcal{P}_{yielded} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau`$**   

##### Power yielded in a material with multiple types of charge carriers

* When a material contains **multiple types of charge carriers $`q_i`$**   
  in *concentrations $`n_i`* and with *drift velocities $`\overrightarrow{v_{d\,i}}`$* :   
  <br>
  $`\displaystyle d\mathcal{P}_{yielded} = \sum_{i=1}^p \big(n_i\,q_i\,\overrightarrow{E}\cdot\overrightarrow{v_i}\big)\,d\tau`$   
  <br>
  $`\displaystyle d\mathcal{P}_{yielded} = \sum_{i=1}^p \rho_i\,d\tau\,\overrightarrow{E}\cdot\overrightarrow{v_i}`$   
  <br>
  $`\displaystyle d\mathcal{P}_{yielded} = \sum_{i=1}^p\overrightarrow{j_i}\cdot\overrightarrow{E}\,d\tau`$   
  <br>
  *$`d\mathcal{P}_{yielded} = \overrightarrow{j}_{total}\cdot\overrightarrow{E}\,d\tau`$*   

* By simply setting *$`\overrightarrow{j}_{total}=\overrightarrow{j}`* :   
  <br>
  **$`\large{\mathbf{d\mathcal{P}_{yielded} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}}`$**   

* The *power yielded* by the electromagnetic field *in a volume $`\tau`* is called **$`\large{\text{Joule Effect}}`$**,   
  <br>
  **$`\large{\displaystyle\mathbf{\mathcal{P}_{yielded} = \iiint_{\tau}\big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}}`$**   

<br>

------------

<br>

#### Does the electromagnetic field contain energy?

* If the *electromagnetic field* can yield energy to matter, it is because it **contains energy**.

* An electromagnetic field $`\big(\overrightarrow{E},\,\overrightarrow{B}\big)`$ extending through space,
  the energy contained in the field is described by
  a **volumetric energy density of the electromagnetic field $`\rho_{energy-EM}^{3D}`$** defined at each point in space.

<!-------------------
@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@
##### Is the expression of the volumetric energy density of the electromagnetic field contained in Maxwell's equations?
--------------------->

* Start with the mathematical identity :   
  <br>
  $`\mathbf{\text{div}\,\big(\overrightarrow{U}\times\overrightarrow{V}\big)=
  \overrightarrow{V}\cdot\big(\overrightarrow{\text{curl}}\,\overrightarrow{U}\big)\,-\,\overrightarrow{U}\cdot\big(\overrightarrow{\text{curl}}\,\overrightarrow{V}\big)}`$   
  <br>
  and apply it to the electromagnetic field $`\big(\overrightarrow{E},\,\overrightarrow{B}\big)`$ by setting $`\overrightarrow{U}=\overrightarrow{E}`$
  and $`\overrightarrow{V}=\overrightarrow{B}`$   
  <br>
  **$`\mathbf{\text{div}\,\big(\overrightarrow{E}\times\overrightarrow{B}\big)=\overrightarrow{B}\cdot\big(\overrightarrow{\text{curl}}\,\overrightarrow{E}\big)\,-\,\overrightarrow{E}\cdot\big(\overrightarrow{\text{curl}}\,\overrightarrow{B}\big)}`$**   
  <br>
  $`\color{blue}{\scriptsize{
  \text{Identify the terms } \overrightarrow{\text{curl}}\,\overrightarrow{E} \text{ and } \overrightarrow{\text{curl}}\,\overrightarrow{B}}}`$
  $`\color{blue}{\scriptsize{\text{ with their causes, respectively}}}`$
  $`\color{blue}{\scriptsize{\text{the Maxwell-Faraday and Maxwell-Ampère equations}}}`$   
  <br>
  $`\begin{align}\text{div}\,\big(\overrightarrow{E}\times\overrightarrow{B}\big)
  =&\overrightarrow{B}\cdot
  \big(
  \underbrace{\overrightarrow{\text{curl}}\,\overrightarrow{E}}
  _{\color{blue}{=-\frac{\partial \vec{B}}{\partial t}}}\big)\,\\
  &\quad-\,\overrightarrow{E}\cdot\big(\underbrace{\overrightarrow{\text{curl}}\,\overrightarrow{B}}_{\color{blue}{=\mu_0\,\vec{j}+\mu_0\epsilon_0\frac{\partial \vec{E}}{\partial t}
  }}\big)\end{align}`$   
  <br>
  $`\text{div}\,\big(\overrightarrow{E}\times\overrightarrow{B}\big)`$   
  $`\quad=-\,\mu_0\,\vec{j}\cdot\overrightarrow{E}\,-\,\mu_0\,\epsilon_0\dfrac{\partial \vec{E}}{\partial t}\cdot\overrightarrow{E}
  \,
  -\,\overrightarrow{B}\cdot \dfrac{\partial \vec{B}}{\partial t}\big)`$   
  <br>
  $`\color{blue}{\scriptsize{
  \text{Recall that } \vec{u}\dfrac{\partial \vec{u}}{\partial t}=\dfrac{1}{2}\,\dfrac{\partial (\vec{u}\cdot\vec{u})}{\partial t}=\dfrac{1}{2}\,\dfrac{\partial u^2}{\partial t}}}`$   
  <br>
  $`\text{div}\,\big(\overrightarrow{E}\times\overrightarrow{B}\big)`$
  $`\quad =-\,\mu_0\,\vec{j}\cdot\overrightarrow{E}\,-\,\dfrac{\mu_0\,\epsilon_0}{2}\,\dfrac{\partial E^2}{\partial t}\,-\,\dfrac{1}{2}\,\dfrac{\partial B^2}{\partial t}`$   
  <br>
  $`\color{blue}{\scriptsize{\text{Recognizing the Joule effect term }\vec{j}\cdot\vec{E}=\dfrac{d\mathcal{P}_{yielded}}{d\tau}}}`$   
  $`\color{blue}{\scriptsize{\text{encourages dividing each term of the equation by }\mu_0 }}`$   
  <!-- $`\color{blue}{\scriptsize{\text{so that each term is homogeneous to a power per unit volume:}}}`$-->
  <br>
  $`\text{div}\,\left(\dfrac{\overrightarrow{E}\times\overrightarrow{B}}{\mu_0}\right)`$   
  $`\quad = -\,\underbrace{
  \vec{j}\cdot\overrightarrow{E}
  }_{
  \color{blue}{=\frac{d\mathcal{P}_{yielded}}{d\tau}}
  }
  \,-\,\dfrac{\epsilon_0}{2}\,\dfrac{\partial E^2}{\partial t}
  \,
  -\,\dfrac{1}{2\,\mu_0}\,\dfrac{\partial B^2}{\partial t}
  `$   
  <br>
  $`\color{blue}{\scriptsize{\text{which you can rewrite:}}}`$      
  <br>
  **$`\mathbf{
  \text{div}\,\left(\dfrac{\overrightarrow{E}\times\overrightarrow{B}}{\mu_0}\right)}`$
  $`\mathbf{\quad = -\,\vec{j}\cdot\overrightarrow{E}
  \,-\,\dfrac{\partial}{\partial t}\,\left(
  \dfrac{\epsilon_0\,E^2}{2}\,+\,\dfrac{B^2}{2\,\mu_0}
  \right)
  }`$**   

* Thus appears the **volumetric energy density of the electromagnetic field** with *SI unit: $`J\,m^{-3}`$* :   
  <br>
  **$`\large{\mathbf{\rho_{energy-EM}^{3D}=\dfrac{\epsilon_0\,E^2}{2}+\dfrac{B^2}{2 \mu_0}}}`$**   

* This volumetric density $`\rho_{energy-EM}^{3D}`$ *has two components*:
  * an *electric component* **$`\;\rho_{elec}^{3D}=\dfrac{\epsilon_0\,E^2}{2}`$**
  * a *magnetic component* **$`\;\rho_{mag}^{3D}=\dfrac{B^2}{2 \mu_0}`$**.

* The electromagnetic energy $`\mathcal{E}_{EM}`$ contained **in a volume $`\tau`$** is expressed as :   
  <br>
  **$`\displaystyle\large{\mathbf{\mathcal{E}_{EM}=\iiint_{\tau} \left(\dfrac{\epsilon_0\,E^2}{2}+\dfrac{B^2}{2 \mu_0}\right) d\tau}}`$**

<br>

------------

<br>

#### Why Do We Speak of Electromagnetic Waves?

##### Wave Equation

* For a *vector field $`\overrightarrow{U}(\overrightarrow{r},t)`*, the **d'Alembert wave equation** is written as :   
  <br>
  **$`\Delta \overrightarrow{U} - \dfrac{1}{v^2} \; \dfrac{\partial^2 \;\overrightarrow{U}}{\partial t^2}=0`$**   

* The expression of the *vector Laplacian operator $`\Delta`* in terms of the $`\text{grad}`$, $`\text{div}`$, and $`\text{curl}`$ operators is :   
  <br>
  *$`\Delta = \overrightarrow{\text{grad}} \left(\text{div}\right) - \overrightarrow{\text{curl}} \left(\overrightarrow{\text{curl}}\right)`$*   

* The **idea** is to *calculate for each of the fields $`\overrightarrow{E}`$ and $`\overrightarrow{B}`$*
  the expression of *its Laplacian*, to see if it can be identified with the wave equation.   

##### Study of the $`\overrightarrow{E}`$ Component of the Electromagnetic Field

* To **establish the expression $`\Delta \overrightarrow{E}`$**, I calculate
  $`\overrightarrow{\text{curl}}\left(\overrightarrow{\text{curl}} \overrightarrow{E}\right)`$ and then
  $`\overrightarrow{\text{grad}} \left(\text{div} \overrightarrow{E}\right)`$ *from Maxwell's equations*.

* $`\overrightarrow{\text{curl}} \left(\overrightarrow{\text{curl}} \overrightarrow{E}\right) =
  \overrightarrow{\text{curl}} \left(-\dfrac{\partial \overrightarrow{B}}{\partial t}\right)`$   
  <br>
  In classical physics, space and time are decoupled. The spatial coordinates
  and the time coordinate are independent. The order of differentiation or integration between
  spatial coordinates and the time coordinate does not matter, so :   
  <br>
  $`\overrightarrow{\text{curl}} \left(\overrightarrow{\text{curl}} \overrightarrow{E}\right) =
  -\dfrac{\partial}{\partial t} \left(\overrightarrow{\text{curl}} \overrightarrow{B}\right)`$   
  <br><br>
  $`\overrightarrow{\text{curl}} \left(\overrightarrow{\text{curl}} \overrightarrow{E}\right) =
  -\dfrac{\partial}{\partial t} \left(\mu_0 \overrightarrow{j} + \mu_0 \epsilon_0 \dfrac{\partial \overrightarrow{E}}{\partial t}\right)`$   
  <br><br>
  *$`\overrightarrow{\text{curl}} \left(\overrightarrow{\text{curl}} \overrightarrow{E}\right) =
  -\mu_0 \dfrac{\partial \overrightarrow{j}}{\partial t} - \mu_0 \epsilon_0 \dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$*   
  <br><br>

* *$`\overrightarrow{\text{grad}} \left(\text{div} \overrightarrow{E}\right) =
  \overrightarrow{\text{grad}} \left(\dfrac{\rho}{\epsilon_0}\right)`$*

* Reconstructing
  $`\Delta \overrightarrow{E} = \overrightarrow{\text{grad}} \left(\text{div} \overrightarrow{E}\right) -
  \overrightarrow{\text{curl}} \left(\overrightarrow{\text{curl}} \overrightarrow{E}\right)`$
  gives :   
  <br>
  $`\Delta \overrightarrow{E} = \overrightarrow{\text{grad}} \left(\dfrac{\rho}{\epsilon_0}\right) +
  \mu_0 \dfrac{\partial \overrightarrow{j}}{\partial t} + \mu_0 \epsilon_0 \dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$   
  <br>
  which, by identifying with the first term of the wave equation, gives :   

  **$`\mathbf{\Delta \overrightarrow{E} - \mu_0 \epsilon_0 \dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} =
  \dfrac{1}{\epsilon_0} \overrightarrow{\text{grad}} \left(\rho\right) + \mu_0 \dfrac{\partial \overrightarrow{j}}{\partial t}}`$**   
  <br>
  *(wave equation for the electric field)*

##### Study of the $`\overrightarrow{B}`$ Component of the Electromagnetic Field

* A *similar study* (proposed as a self-test in the advanced section) would lead me
  to the propagation equation for the magnetic field $`\overrightarrow{B}`$ :   
  <br>
  **$`\mathbf{\Delta \overrightarrow{B} - \epsilon_0 \mu_0 \dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} =
  -\mu_0 \overrightarrow{\text{curl}} \overrightarrow{j}}`$**   
  <br>
  *(wave equation for the magnetic field)*

##### Propagation of an Electromagnetic Wave in Matter

* The study starts from Maxwell's equations and the two equations :   
  <br>
  $`\Delta \overrightarrow{E} - \mu_0 \epsilon_0 \dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} =
  \dfrac{1}{\epsilon_0} \overrightarrow{\text{grad}} \left(\rho\right) + \mu_0 \dfrac{\partial \overrightarrow{j}}{\partial t}`$   
  <br>
  $`\Delta \overrightarrow{B} - \epsilon_0 \mu_0 \dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} =
  -\mu_0 \overrightarrow{\text{curl}} \overrightarrow{j}`$   
  <br>
  and is the subject of an entire **development in a later chapter**.

##### Propagation of an Electromagnetic Wave in Vacuum

* *Empty space* is characterized by an absence of charges, whether fixed or moving.
  The volume charge density $`\rho_{\text{vacuum}}`$ as well as the volume current density vector
  $`\overrightarrow{j}_{\text{vacuum}}`$ have a value of zero throughout empty space,   
  <br>
  *$`\rho_{\text{vacuum}}=0 \quad \text{and} \quad \overrightarrow{j}_{\text{vacuum}}=\overrightarrow{0}`$*.   

* Therefore, the propagation of the electromagnetic wave in vacuum is expressed in the form
  of a system of **two d'Alembert equations** :   
  <br>
  **$`\large{\boldsymbol{\mathbf{\Delta \overrightarrow{E} - \mu_0 \epsilon_0 \dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}}}}`$**
  <br>
  **$`\large{\boldsymbol{\mathbf{\Delta \overrightarrow{B} - \mu_0 \epsilon_0 \dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}}}}`$**

!!!! *Attention* :                   
!!!!
!!!! *Maxwell's equations imply the propagation of the electromagnetic field*.
!!!!
!!!! *But,*
!!!!
!!!! The *two wave equations for the fields $`\overrightarrow{E}`$ and $`\overrightarrow{B}`$
!!!! do not imply Maxwell's equations*.
!!!!
!!!! Any field $`\overrightarrow{E}`$ that satisfies
!!!! $`\Delta \overrightarrow{E} - \mu_0 \epsilon_0 \dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}`$
!!!!
!!!! and any field $`\overrightarrow{B}`$ that satisfies
!!!! $`\Delta \overrightarrow{B} - \mu_0 \epsilon_0 \dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}`$
!!!!
!!!! describe the propagation of an electromagnetic wave only if $`\overrightarrow{E}`$ and $`\overrightarrow{B}`$
!!!! satisfy Maxwell's equations.

##### Speed of Light in Vacuum

* Identifying the propagation equations of the fields $`\overrightarrow{E}`$ and $`\overrightarrow{B}`$
  with the d'Alembert wave equation shows that *the electromagnetic field propagates at the speed*   
  <br>
  *$`\large{\mathscr{v}=\dfrac{1}{\sqrt{\epsilon_0 \mu_0}}}`$*   

* The *speed of light in vacuum*, denoted *$`\mathbf{c}`$*, is a **fundamental constant** of the universe, and its exact value is :   
  <br>
  *$`\large{c=299,792,458 \, \text{m} \, \text{s}^{-1} \approx 3 \times 10^8 \, \text{m} \, \text{s}^{-1}}`$*   

!! *For further reading*:
!!
!! The propagation equations of electromagnetic waves, established here within the framework
!! of classical physics,
!! predict that electromagnetic waves propagate in vacuum at the speed
!! $`c=1/\sqrt{\epsilon_0 \mu_0}`$, a constant speed independent of the observer's motion.
!!
!! This is in contradiction with the law of velocity addition in classical mechanics, which
!! results from Galilean transformations.
!!
!! $`\Longrightarrow`$ During the second half of the 19th century, the work of physicists was
!! to try to modify Maxwell's equations to make them compatible with classical physics.
!!
!! But it was the opposite that needed to be done: modify Newtonian mechanics, the basis of classical physics,
!! to make it compatible with Maxwell's equations.
!!
!! This inverse work was done by Albert Einstein, who published in 1905 a paper titled
!! "On the Electrodynamics of Moving Bodies,"
!! which marked the birth of the theory of Special Relativity, revolutionizing our conception
!! of space and time.
!!
!! Later, in 1915, Einstein submitted a paper titled
!! "The Foundation of the General Theory of Relativity"
!! which revolutionized our conception of the relationship between spacetime and its content of matter and energy.
!!
!! *Newtonian physics*:
!! space + time + matter + energy.
!!
!! *Relativistic physics in the restricted sense*:
!! spacetime + matter-energy ($`E=mc^2`$).
!!
!! *Relativistic physics in the general sense*:
!! spacetime-matter-energy.

<br>

------------

<br>

#### What Is the Electromagnetic Spectrum?

* **Maxwell** hypothesized that *visible light*, whose speed had just been measured from
  astronomical observations of the motion of Jupiter's satellites, *is an electromagnetic wave*.   
  <br>
  $`\Longrightarrow`$ Light is only a tiny part of electromagnetic waves.   
  <br>
  $`\Longrightarrow`$ A *whole new world of "lights"* is revealed, called the **electromagnetic spectrum**.  

<br>

![Electromagnetic Spectrum](astro-electromagnetic-spectrum-N4_1_fr_L1200.jpg)

<br>

* In particular, **knowledge of the universe** resulted *before Maxwell* from the sole observation of the *visible domain*,   

![Visible Sky](ciel-visible-bsp_L1200.jpg)

* now extends to *the entire electromagnetic spectrum*.

![Sky in Various Wavelengths](ciel-images-bsp_L600_transparence.gif)

<br>

------

<br>


#### What Is the Poynting Vector?

* The **electromagnetic wave contains energy**
  * with *at each point in space* a **volumetric energy density $`\rho_{energy-EM}^{3D}`$**,
    - with an *electric component $`\rho_{energy-EM}^{3D}=\dfrac{\epsilon_0\,E^2}{2}`$*,
    - with a *magnetic component $`\rho_{energy-EM}^{3D}=\dfrac{B^2}{2 \mu_0}`$*.
  * which **moves in vacuum** *at speed $`c`$*.

* The **Poynting vector** translates this fact and allows the *calculation of the energy* of an electromagnetic wave
  incident *on any surface per second*.

* The **Poynting vector**, defined at each point in space, is *defined by* the relation :   
  <br>
  *$`\large{\mathbf{d\mathcal{P}=\overrightarrow{\Pi}\cdot\overrightarrow{dS}}}`$*   
  <br>
  where $`d\mathcal{P}`$ is the *elementary power* of the electromagnetic wave
  *radiated through the surface element* $`\overrightarrow{dS}`$.

![Poynting Vector](poynting-vector-1_L1200.jpg)

* Its **expression** in terms of the fields $`\overrightarrow{E}`$ and $`\overrightarrow{B}`$ is :   
  <br>
  **$`\large{\mathbf{\overrightarrow{\Pi}=\dfrac{\overrightarrow{E}\times\overrightarrow{B}}{\mu_0}}}`$**

* *SI Unit* : **$`\mathbf{W\,m^{-2}}`$**

! *Note 1*:
!
! The displacement of a charge (SI unit: $`C`$) contained in an elementary volume
! $`d\tau`$ (SI: $`m^3`$) with volume charge density
! $`\rho_{charge}^{3D}`$ (SI: $`C\,m^{-3}`$) at a velocity
! $`\overrightarrow{v_d}`$ (SI: $`m\,s^{-1}`$) :   
! * allows defining a volume electric current density vector
! $`\overrightarrow{j}_{current}^{3D}=\rho_{charge}^{3D}\,v_d`$
! (SI: $`A\,m^{-2}`$),
! * and thus allows calculating the elementary current intensity $`dI`$ (SI: $`A = C\,s^{-1}`$) flowing through
! any surface element
! $`\overrightarrow{dS}`$ (SI: $`m^2`$),
! $`dI= \overrightarrow{j}_{current}^{3D}\cdot\overrightarrow{dS}`$.
!
! Similarly,
!
! the displacement of the energy (SI unit: $`J`$) of the electromagnetic wave contained
! in an elementary volume $`d\tau`$ (SI: $`m^3`$) with volumetric energy density
! $`\rho_{energy-EM}^{3D}`$ (SI: $`J\,m^{-3}`$) at speed $`c`$ (SI: $`m\,s^{-1}`$):
! * allows defining the equivalent of a power density vector of the electromagnetic wave,
! called *Poynting vector* and denoted $`\overrightarrow{\Pi}`$ (SI: $`J\,s^{-1}\,m^{-2}=W\,m^{-2}`$),
! * which allows calculating the elementary power $`d\mathcal{P}`$ (SI: $`W`$) of the EM wave passing through any surface element
! $`\overrightarrow{dS}`$,
! $`d\mathcal{P}= \overrightarrow{\Pi}\cdot\overrightarrow{dS}`$.

! *Note 2*:
!
! *The expression of the Poynting vector* in terms of the electric and magnetic fields of the wave,
! as well as *its meaning*, are *easier to remember* if expressed
! *in terms of the magnetic excitation field $`\overrightarrow{H}`*.
!
! *__In vacuum__ (and only in vacuum)*:
! The magnetic field is equally well described by the induction field
! $`\overrightarrow{B}`$, which is involved in the Lorentz force that induces the effects,
! as by the magnetic excitation field $`\overrightarrow{H}`$.
! These two fields are proportional, with the proportionality ratio being the magnetic constant $`\mu_0`$:
! <br>
! $`\overrightarrow{B}=\mu_0\,\overrightarrow{H}\quad\text{(in vacuum)}`$
!
! The expression of the Poynting vector in vacuum is then:
! <br>
! $`\overrightarrow{\Pi}=\overrightarrow{E}\times\overrightarrow{H}`$
!
! Remembering
! * from electrostatics that the SI unit of $`\overrightarrow{E}`$ is $`V\,m^{-1}`$,
! * from magnetostatics that the SI unit of $`\overrightarrow{H}`$ is $`A\,m^{-1}`$,
! * from circuit studies that $`\mathcal{P}\,(W) = U\,(V)\times I\,(A)`$,
!
! then the *SI unit of the Poynting vector* easily appears as *$`V\,A\,m^{-2}= W\,m^{-2}`$*.
!
! In the International System of Units, the Poynting vector is expressed in *watts per square meter*.
!
! The *physical quantity of the Poynting vector* is a *power per unit area*.

<br>

------

<br>

#### How to Calculate the Power Crossing a Surface of Any Area and Orientation?

* The **power** is simply calculated by the expression :   
  <br>
  **$`\displaystyle\mathcal{P}=\iint_S \overrightarrow{\Pi}\cdot\overrightarrow{dS}`$**

* Consider a **monochromatic electromagnetic wave** with a *time period $`\mathbf{T_{wave}}`$*.
  * **$`\mathbf{T_{wave}}`$** is the *time period of $`\overrightarrow{E}`$*, the electric field of the wave.
  * Since electrical energy is proportional to $`E^2`$, <br>
    the *period of energy variations* of the wave is **$`\mathbf{T_{energy}}`$** *$`\mathbf{=\dfrac{T_{wave}}{2}}`$*.

* Every **sensor** is characterized by a **response time $`\mathbf{\Delta t_{response}}`$** that quantifies its *speed*.   
  <br>
  Consider a sensor sensitive to electromagnetic energy:
  * If *$`\mathbf{\Delta t_{response}\ll T_{energy}}`$*, then the sensor is sensitive to the *instantaneous power* :   
    <br>
    *$`\displaystyle\large{\mathbf{\mathcal{P}(t)=\iint_S \overrightarrow{\Pi}(t)\cdot\overrightarrow{dS}}}`$*   
    <br>
  * If **$`\mathbf{\Delta t_{response}\gg T_{energy}}`$**, then the sensor cannot follow the temporal variations of
    the instantaneous power and only measures the **average value of the power** estimated over $`\Delta t_{response}`$ :   
    <br>
    **$`\displaystyle\large{\mathbf{<\mathcal{P}(t)>\;=\iint_S <\overrightarrow{\Pi}(t)>\cdot\overrightarrow{dS}}}`$**   

!!! *Example*:
!!!
!!! The *visible domain* corresponds to:
!!! * a *wavelength* in vacuum on the order of 500 nanometers: *$`\mathbf{\lambda = 5\cdot 10^{-7}\,m}`$* <br>
!!!   <br>
!!!   This corresponds to a time period of the electric field $`T_{wave}`$ of : <br>
!!!   $`T_{wave}=\dfrac{\lambda}{c}=\dfrac{5\cdot 10^{-7}}{3\cdot 10^{8}} = 1.7\times 10^{-15}\,s`$, <br>
!!!   or <br>
!!!   $`T_{energy}=8.5\times 10^{-16}\,s`$ <br>
!!!   <br>
!!!   In both cases, the order of magnitude of the *period* is $`\mathbf{T\approx 10^{-15}\,s}`$.
!!!   <br>
!!!   No sensor can follow the instantaneous power variations of visible light.

#### How to Emit an Electromagnetic Wave?

* It is sufficient to **accelerate a charged particle**.

<!---------------------
#### How to Capture the Power of an Electromagnetic Wave?

Some very concise ideas.
For transverse and classical resources, parallel links
---------------------->






