---
title: Properties of the conservative vector fields
published: false
routable: false
visible: false
lessons:
    - slug: gauss-ampere-theorems-demonstration
      name: PARALLÈLE : Les bases pour physiciens au niveau contreforts
      order: 1
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

<!------Commentaire----------------------------
!  *Thème* :<br>
! *Electrostatique / Démonstration du théorème de Gauss, forme intégrale et forme locale*<br>
! Guide pour établir les 3 parties : main, overview, beyond<br>
!
!  (_précède le thème : Electrostatique : Application du théorème de Gauss, forme intégrale et forme locale._)
----------------------------------------------->

##### Randonnée Contreforts :&nbsp; _toute spécialité_

---------------------------

### PHYSIQUE GÉNÉRALE


### Définitions et propriétés<br>**Gradient**<br>**Champs vectoriels conservatifs**

<br>

GRADIENT  D'UN  CHAMP SCALAIRE<br>_" du champ scalaire au champ vectoriel "_
: ---

  *Définition du gradient* :
  
  Soit $`\phi`$ un champ scalaire.   
  En un point quelconque de l'espace, un déplacement élémentaire $`\overrightarrow{dl}`$ induit
  une variation élémentaire $`d\phi`$ de la valeur du champ.   
  
  Le vecteur $`\overrightarrow{grad}\,\phi`$ réalise ne lien entre $`d\phi`$ et $`\overrightarrow{dl}`$ au point considéré :
  
 $`\mathbf{d\phi=\overrightarrow{grad}\,\phi\cdot\overrightarrow{dl}}`$
 
 *Expressions du gradient*
 
   Coordonnées cartésiennes :   
   $`\begin{align}
   \overrightarrow{grad}\,\phi &=\dfrac{\partial \phi}{\partial x}\,\overrightarrow{e_x}+\dfrac{\partial \phi}{\partial y}\,\overrightarrow{e_y}+\dfrac{\partial \phi}{\partial z}\,\overrightarrow{e_z} \\
    &=\overrightarrow{\nabla}\,\phi
    \end{align}`$
    
   &nbsp;&nbsp;avec opérateur nabla :
   &nbsp;&nbsp;$`\overrightarrow{\nabla}=\dfrac{\partial}{\partial x}\,\overrightarrow{e_x}+\dfrac{\partial}{\partial y}\,\overrightarrow{e_y}+\dfrac{\partial}{\partial z}\,\overrightarrow{e_z}`$

   Coordonnées cylindriques :   
   $`\overrightarrow{grad}\,\phi=\dfrac{\partial \phi}{\partial \rho}\,\overrightarrow{e_{\rho}}+\dfrac{1}{\rho}\,\dfrac{\partial \phi}{\partial \varphi}\,\overrightarrow{e_{\varphi}}+\dfrac{\partial \phi}{\partial z}\,\overrightarrow{e_z}`$

   Coordonnées sphériques :   
   $`\overrightarrow{grad}\,V=\dfrac{\partial \phi}{\partial r}\,\overrightarrow{e_r}+\dfrac{1}{r}\,\dfrac{\partial \phi}{\partial \theta}\,\overrightarrow{e_{\theta}}+\dfrac{1}{r\,sin\,\theta}\,\dfrac{\partial \phi}{\partial \varphi}\,\overrightarrow{e_{\varphi}}`$
 
 
  
  *Champ de gradient d'un champ scalaire* :  
  
  L'ensemble des vecteurs gradients en tout point de l'espace est un champ vectoriel, appelé champ de gradient
  
  *Opérateur gradient*
  
  L'opérateur $`\overrightarrow{grad}`$, appliqué à un champ scalaire $`\phi`$ et en un point de l'espace, donne
  le vecteur $`\overrightarrow{grad}\,\phi`$
  
  ---
  
  *Propriétés du gradient*
  
  En tout point de l'espace :
  * $`\overrightarrow{grad}\,\phi`$ pointe en direction et sens où un
   vecteur déplacement  élémentaire $`\overrightarrow{dl}`$ de norme constante $`\Vert\overrightarrow{dl}\Vert`$ 
   induit la variation élémentaire maximale $`d\phi_{MAX}`$ (>0).
  * dans cette direction et sens de variation maximale :
    $`\dfrac{d\phi_{MAX}}{\Vert\overrightarrow{dl}\Vert}=\Vert\overrightarrow{grad}\,\phi\Vert`$
  
  ---

   *Théorème du gradient*
  
  à continuer... nécessaire ici?
    
    
    
CHAMP VECTORIEL CONSERVATIF<br>_" du champ vectoriel (conservatif) aux champs scalaires "_
: ---

  *Définition d'un champ vectoriel conservatif*

  Un champ vectoriel $`\overrightarrow{X}`$ est conservatif si et seulement si il s'identifie
  au champ de gradient d'un champ scalaire $`\phi`$ :

  $`\mathbf{\overrightarrow{X}(\vec{r})\text{ est conservatif }}`$
  $`\mathbf{\Longleftrightarrow\;\exists\,\phi(\vec{r}), \overrightarrow{X(\vec{r})}=\overrightarrow{grad}\,\big(\phi(\vec{r})\big)}`$
  
  *Propriété d'un champ vectoriel conservatif*
  
  La circulation d'un champ vectoriel conservatif $`\overrightarrow{X}=\overrightarrow{grad}(\phi)`$ entre deux points $`M_1`$ et $`M_2`$ ne dépend que
  égale à $`\phi(M_2)-\phi(M_1)`$, quelque-soit le chemin suivi entre ces deux points :
  
  $`\displaystyle\begin{align}\mathbf{\int_{M_1}^{M_2}\overrightarrow{X}\cdot\overrightarrow{dl}}&=\int_{M_1}^{M_2} \overrightarrow{grad}(\phi)\cdot\overrightarrow{dl}\\
    & = \displaystyle\int_{M_1}^{M_2} d\phi\mathbf{\;\;=\phi(M_2)-\phi(M_1)}
    \end{align}`$
    
  $`\Longrightarrow`$ La circulation d'un champ vectoriel conservatif le long d'un contour (chemin fermé) est nulle.
  
  ---
  
  *Intérêt en physique*
  
  à faire

  
   
   

En début de construction ! stade très très préliminaire.

déjà poser des qestions,    
mettre les équations qui seront utilisées.



#### Qu'est-ce qu'un champ scalaire ?

à faire, simple

![](scalar-field-example-temperatures_L800.gif)


#### Qu'est-ce qu'un champ vectoriel ?


#### Quel est le gradient d'un champ scalaire ?


##### Vecteur gradiant en tout point d'un champ scalaire

**$`\large{\mathbf{dV=\overrightarrow{grad}\,V\cdot\overrightarrow{dl}}}`$**
_Exemple "intuitif" d'un champ scalaire défini sur un espace 2D : une carte météorologique, qui donne_
_une représentation des températures constatées ou prévues au niveau du sol._

**1** Un **champ scalaire** est une *grandeur physique scalaire définie en tout point de l'espace*. 

**2** Ce champ est modélisé mathématiquement par une fonction scalaire $`\phi(\vec{r})`$ continue et dérivable.

**3** Les lignes de niveaux (2D) ou surfaces de niveaux (3D) sont des ensembles continus de points de l'espace caractérisés
par une même valeur de champ.



##### L'opérateur gradient


##### Le Champ gradient 





**$`\large{\mathbf{dV=\overrightarrow{grad}\,V\cdot\overrightarrow{dl}}}`$**




#### Que représente le gradient d'un champ scalaire ?

**$`\mathbf{dV}`$**$`\;=\overrightarrow{grad}\,V\cdot\overrightarrow{dl}`$
**$`\mathbf{\;=\big\Vert\overrightarrow{grad}\,V\big\Vert\cdot\big\Vert\overrightarrow{dl}\big\Vert\cdot cos\theta}`$**

avec *$`\mathbf{\theta=\big(\widehat{\overrightarrow{grad}\,V\,,\overrightarrow{dl}}\big)}`$*


#### Comment se détermine l'expression du gradient dans un système de coordonnées ?

Je munis l'espace d'un système de coordonnées orthogonales $`(\alpha\,,\beta\,,\gamma)`$

En tout point de l'espace, je peux associer à ces coordonnées une base de vecteurs $`(\alpha\,,\beta\,,\gamma)`$

Ainsi je peux repérer tout point $`M`$ de l'espace par ses coordonnées $`(\alpha_M\,,\beta_M\,,\gamma_M)`$.

Si partant d'un point $`M`$ quelconque je à un point $`M'`$ de coordonnées 
fais un déplacement élémentaire correspondants aux variations infinitésimales de 
coordonnées d\alpha, d\beta et d\gamma, la longueur $`dl`$ du déplacement s'exprime :



À ces coordonnées je peux associer les vecteurs géométriques unitaires

$`\overrightarrow{e_{\alpha}}\,,\overrightarrow{e_{\beta}}\text{ et }\overrightarrow{e_{\gamma}}`$

définie

si d'un point quelconque $`M`$ dans l'espace, de coordonnées $(\alpha_M\,,\beta_M\,,\gamma_M)`$
je fais un déplacement correspondants aux variations de coordonnées d\alpha, d\beta et d\gamma,


$`dV=\left.\dfrac{\partial V}{\partial \alpha}\right|_M\cdot dl_{\alpha} + \left.\dfrac{\partial V}{\partial \beta}\right|_M\cdot dl_{\beta} + \left.\dfrac{\partial V}{\partial \gamma}\right|_M\cdot dl_{\gamma}`$

$`dV=\left.\dfrac{\partial V}{\partial x}\right|_M\cdot dl_x + \left.\dfrac{\partial V}{\partial y}\right|_M\cdot dl_y + \left.\dfrac{\partial V}{\partial z}\right|_M\cdot dl_z`$




##### Expression du gradient en coordonnées cartésiennes

##### Expression du gradient en coordonnées cylindriques

##### Expression du gradient en coordonnées sphériques








#### 

##### Les champs de forces conservatives et leurs propriétés

à construire