---
title: Cours
slug: cours
---

<!--

Cours de test, pour réfléchir au nom du fichier, au contenu du frontmatter ci-dessus, et tester le rendu dans le WebIDE.

Notes:

- La syntaxe LateX est légèrement différente, puisqu'elle utilise le symbole backtick ` (ALTGR+7) en plus du $.
- chapter -> level ?

-->

# La nature de la lumière

## Nature ondulatoire de la lumière

! Partie en construction.  Contributions bienvenues !


## Nature corpusculaire de la lumière

! Partie en construction.  Contributions bienvenues !


## Une constante fondamentale de la nature : la vitesse de la lumière dans le vide

Dans le vide, l'énergie lumineuse se propage à la vitesse de la lumière.
Cette vitesse de la lumière dans le vide est notée universellement "$c$", et sa valeur exacte,
exacte car fixée par l'humain depuis 1975 (l'unité de longueur du système international, le mètre, est depuis cette date fixé à partir de cette valeur définie et exacte de la vitesse de la lumière) est :

```math
c = 299\,792\,458\;m.s^{-1}
```

- Cette vitesse de la lumière est constante pour tout observateur quelque soit son état de mouvement. ce fait expérimental contredit la loi d'addition galiléenne des vitesses de la mécanique newtonienne, et il ne se comprend de façon cohérente que dans le cadre de la relativité restreinte et de la relativité générale toutes deux introduites par Einstein respectivement en 1905 et 1915.

- La notion de vitesse est traditionnellement associée à la mesure de la variation de la position d'un corps localisé dans l'espace en fonction du temps. Un ballon de football peut ainsi communément atteindre une vitesse de $`30 m.s^{-1}`$ (environ $`100 km.h^{-1}`$), ce qui signifie que la matière qui constitue le ballon s'est effectivement déplacée de 30 m par rapport au sol sur une durée de 1 seconde (on néglige ici les effets de déformation, et de rotation du ballon sur lui-même).

  Concernant une onde, la notion de vitesse est plus subtile. En regardant l'océan, je perçois chaque vague comme une structure étendue mais localisée dans l'espace. Cette structure reste discernable sur une certaine durée avant de se fracasser contre un rocher ou se disperser sur le sable de la plage. Pendant cette durée je peux attribuer une vitesse à cette structure, et je choisis intuitivement de suivre le mouvement de la crête d'une vague pour définir cette vitesse. Ainsi définie, un surfeur pourra estimer la vitesse d'une vague de l'ordre de $`8 m.s^{-1}`$ (environ $`30 km.h^{-1}`$).

  Cependant, le mouvement réel d'un centimètre cube d'eau, ou le mouvement d'une bouée censée être entraînée par la vague, est essentiellement un mouvement d'oscillation de bas en haut, et sa vitesse dans le plan horizontal est quasiment nulle. Une onde est un transport d'énergie, pas de matière. Je peux penser les vagues comme une onde qui déforme la surface de l'océan, et transporte à une vitesse de l'ordre de $`8 m.s^{-1}`$ l'énergie nécessaire pour déplacer alternativement de bas en haut la bouée. Ainsi "mal" définie, la vitesse d'une onde apparait comme une notion bien différente de la vitesse d'un corps en mécanique. C'est pourquoi il existe un mot spécifique pour parler de la "vitesse apparente" de déplacement d'une onde, c'est le mot "célérité". La lumière se comporte par bien des aspects comme une onde, aussi le terme de célérité est souvent employé à la place du terme "vitesse" concernant la lumière. C'est là l'origine de la lettre "$`c`$" représentant par convention la vitesse de la lumière dans le vide.</li>

- Pour une onde, la notion de vitesse ou célérité est bien plus complexe que ne le laissent présager ces deux termes. Même idéalisée, le profil de la vague se déforme au cours de sa propagation. L'analyse de Fourier me montrera que la vague peut se décomposer comme une superposition d'ondes planes sinusoïdales progressives (on dit aussi d'ondes planes harmoniques ou monochromatiques progressives) de la surface de l'eau, dont l'enveloppe décrit la vague. Une onde sinusoïdale présente un profil périodique qui se reproduit infiniment sans se déformer. Il est ainsi possible d'attribuer une vitesse bien définie, par exemple la vitesse de propagation d'un maximum d'amplitude de l'onde sinusoïdale. Chaque composante sinusoïdale possède donc une vitesse de propagation propre et bien définie, appelée vitesse de phase. A la vitesse de l'enveloppe, résultante de la superposition de toutes ses composantes sinusoïdales, je pourrai associer une "vitesse de groupe" dont une définition physique rigoureuse sera présentée dans divers chapitres de niveaux 3 et 4 liées aux phénomènes ondulatoires.

## Le spectre électromagnétique

<!-- todo? -->

# Interaction entre la lumière et la matière

## Interaction lumière-matière

L'univers est composé de matière en mouvement et de lumière.

Dans cette phrase il faudrait restreindre le terme matière à la *matière baryonique*, c'est à dire de matière composée d'*électrons*, de *protons* et de *neutrons*, c'est à dire la matière que nous connaissons, et étendre le terme lumière à tout les spectre des ondes électromagnétiques depuis les rayons gamma de très hautes énergies jusqu'au domaine radio de  très grandes longueurs d'ondes.

Matière et lumière sont en interaction constante.
Du point de vue des grands domaines de la physique, il y a *trois façons pour la matière de créer ou d'absorber de la lumière* :
<u>l'interaction classique</u> (classique au sens non relativiste),
<u>l'interaction quantique</u> et
<u>l'interaction relativiste</u>.

<!-- Apparemment il n'y a pas (encore) moyen de souligner en markdown, on est contraints d'utiliser le tag ins -->

### L'interaction classique

La matière est composée de particules élémentaires dont certaines sont caractérisées par une charge électrique non nulle, ce qui signifie qu'elles sont sensibles à l'interaction électromagnétique. Or la lumière est la propagation d'un champ électromagnétique.

Un "champ" en physique décrit une grandeur physique définie en tout point de l'espace.
L'existence d'un champ électromagnétique signifie donc qu'en tout point de l'espace existent un vecteur champ électrique $`\overrightarrow{E}`$ et un vecteur champ magnétique $`\overrightarrow{B}`$ liés par les équations de Maxwell.
L'interaction électromagnétique précise qu'en présence d'un champ électrique $`\overrightarrow{E}`$ et d'un champ magnétique $`\overrightarrow{B}`$, une particule de charge électrique $`q`$, de masse $`m`$ et animée d'une vitesse $`\overrightarrow{v}`$ dans le référentiel où elle est observée, subit une force électromagnétique dite force de Lorentz $`\overrightarrow{F}_{L}`$ qui s'exprime comme suit :

```math
\overrightarrow{F}_{L}=q\cdot(\overrightarrow{E}+\overrightarrow{v}\wedge\overrightarrow{B})
```


**Un champ électromagnétique induit une accélération à toute particule chargée**, du fait de la *force de Lorentz*.
Le phénomène inverse est aussi vrai, les lois de l'électromagnétisme disent que **toute particule chargée accélérée est source d'une onde électromagnétique**.

- Ainsi, pour créer une onde électromagnétique de fréquence $`\nu`$, il suffit de communiquer à un électron un mouvement oscillatoire à cette même fréquence $`\nu`$. Inversement, pour détecter une onde électromagnétique de fréquence $`\nu`$, il suffit de placer un électron libre sur le trajet de l'onde, et de détecter son mouvement oscillatoire induit (donc le petit courant alternatif résultant de son mouvement induit).
- Le domaine de la lumière visible correspondant à des fréquences de l'ordre de $`5\cdot10^{14}Hz`$, ce qui représente $`5\cdot10^{14}`$ oscillations par seconde, il est impossible mécaniquement ou même électriquement d'inculquer un mouvement oscillatoire aussi rapide à des particules chargées pour créer de la lumière visible. Cette interaction "classique" concerne donc le domaine des ondes électromagnétiques de fréquences moindres, celui des ondes radioélectriques ($`\lambda\geq1m`$) ou du domaine des micro-ondes ($`1mm\geq\lambda\leq1m`$).



### L'interaction quantique

Un atome est composée d'un noyau, ensemble compact de protons et de neutrons en interaction forte, entouré d'un nombre d'électrons équivalent au nombre de proton du noyau qui se répartissent dans un certain nombre d'orbitales caractérisées par leurs énergies.

La mécanique quantique est probabiliste. L'électron entre deux mesures n'a pas de trajectoire définie. La notion même de trajectoire n'as pas de sens. Seule la probabilité de présence de l'électron dans un volume donné peut être calculée. Une orbitale est définie comme une région de l'espace où l'électron a une probabilité  de présence supérieure à 90%.

Dans son état fondamental, les électrons se répartissent dans les orbitales de plus basses énergies. Dans un état excité de l'atome, certains électrons ont sauté sur des orbitales plus énergétiques. La transition entre deux états (entre l'état fondamental et un état excité, ou entre deux états excités) peut-être radiative. Dans ce cas elle s'accompagne de l'émission ou l'absorption (selon les cas) d'un photon d'énergie égale à la différence d'énergie entre les deux états concernés.

### L'interaction relativiste

Je comprends facilement cette interaction à partir de la célèbre formule d'Einstein $`E=m \cdot c^2`$ qui dit qu'un corps immobile et de masse $m$ dans un référentiel donné contient une énergie $`E`$ égale à la masse au repos du corps multipliée par la vitesse de la lumière $`c`$ élevée au carré.

La théorie de la relativité prévoit, en parfait accord avec l'expérience, que la masse d'un corps croît avec la vitesse de celui-ci. La masse d'un corps varie donc selon le référentiel dans lequel ce corps est observé.  Dans la relation $`E=m\cdot c^2`$, $`m`$ est la masse du corps mesurée dans un référentiel où le corps est immobile, je l'appelle "masse au repos".

A chaque particule de matière de masse au repos $`m`$ correspond son anti-particule qui possède la même masse.
Lorsqu'une particule de matière rencontre son anti-particule, toutes deux sont annihilées, et la somme de leurs masses est entièrement convertie en énergie, sous la forme de photons.
Entre le proton, le neutron et l'électron, l'électron est la particule atomique de plus faible masse $`m_e`$ au repos : $`m_e=9.1\cdot10^{-31}kg`$.
L'annihilation entre un _électron_ et son antiparticule appelée _positron_ libère 2 fois l'énergie :

```math
m_e\cdot c^2=8.2\cdot10^{-14}J=511 000eV
```

Une énergie de $1 eV$ est l'énergie cinétique acquise par un électron de charge électrique
$q=-1.6\cdot10^{-19}C$ accéléré par une différence de potentiel de $1V$.
En Joule, cela représente une énergie de $1 eV = 1.6\cdot10^{-19}J$.

Cela se traduit par la création de deux photons d'énergie $511 keV$.
Chaque photon posède donc une énergie plus de $250 0000$ fois supérieure à un photon visible.
Cette interaction relativiste ne s'observe que dans le domaine des rayons gamma.


Une carte du ciel centrée sur une énergie photonique de $511 keV$
présente la distribution spatiale de l'annihilation électron-positron.
Ce sont des sources quasiment ponctuelles dans le plan Galactique.
Si l'origine de cette émission à $511 keV$ reste sujet à débat,
elle est liée à des évènements extrêmement énergétiques capables de générer des positrons.
Ces positrons peuvent être produits dans ou au voisinage d'objects stellaires compacts
(étoiles à neutrons, trous noirs), lors d'explosions d'étoiles (novae, supernovae).
Ils peuvent aussi être créés par désintégration d'éléments radioactifs
créés par l'interaction du rayonnement cosmique avec le gaz interstellaire,
ou encore avoir une origine exotique (évènement affectant de la matière noire).

<!-- Je m'arrête ici pour l'instant, n'hésite pas à continuer -->

---

<!--Spatial distribution of the 511 keV line emission from positron annihilation in the central region of the Galaxy     L'origine de ces positons est encore ignorée. De nombreuses sites peuvent produire ces particules d'antimatière parmi lesquelles les étoiles compactes (étoiles à neutrons, trous noirs),  les explosions d'étoiles (novae, supernovae), les sursauts gamma mais aussi l'interaction des particules du rayonnement cosmique avec le gaz de la galaxie ou les étoiles géantes lorsqu'elles fabriquent des éléments radioactifs qui se désintègrent. Parmi toutes les hypothèses actuellement discutées, deux sont particulièrement retenues: une origine radioactive (désintégration de noyaux avec émission de positons) ou une origine exotique (annihilation d'un certain type de matière noire). -->


<h3>Le rayonnement du corps noir</h3>

<h3>Le rayonnement thermique du corps réel</h3>



<h2>Domaine de validité de l'optique géométrique</h2>

<p>L’<strong>optique géométrique</strong><em> modélise le comportement de la lumière avec les concepts de rayon lumineux, d'indice de réfraction et un principe de base : le principe de Fermat appliqué à la trajectoire des rayons lumineux</em></p>
<p>Elle permet de <em>comprendre puis maîtriser la formation des images</em> par des <strong>systèmes optiques de dimensions caractéristiques a grandes devant la longueur d’onde &lambda; de la lumière (a &#8811  &lambda;). </strong> </p>
<ul class ="exemple">
<li>Même le diamètre de 2 millimètres de l'objectif d'un smartphone qui permet de prendre des photos est 2500 fois plus grand que la plus grande longueur d'onde du domaine visible (800nm)</li>
</ul>
<p>Elle permet de <em>comprendre <strong>comment l'oeil perçoit son environnement</strong>, comprendre et maîtriser le fonctionnement et les caractéristiques de tous les appareils d'optiques utilisés dans la vie de tous les jours : <strong>loupes, miroirs, appareils photos, téléobjectifs, microscopes, télescopes et lunettes astronomiques ou terrestres, ainsi que lunettes et lentilles de vue pour corriger un défaut de la vision.</strong> </em></p>
<p>L'optique géométrique  ne permet pas de comprendre les phénomènes lumineux induits par des systèmes optiques de taille caractéristique a de l'ordre de grandeur ou inférieure à la longueur d'onde &lambda; de la lumière (a  &#8776;  &lambda; ou a  &#8804;  &lambda;) : les phénomène de diffraction et d'interférences lumineuses. Je comprendrai et maîtriserai ces phénomènes dans le cadre de l'optique ondulatoire, puis de façon plus approfondie dans le cadre de la théorie électromagnétique de Maxwell (Electromagnétisme).</p>
<ul class = "list">
<li>Dans la vie de tous les jours, il est difficile de trouver un fait observable qui ne peut se comprendre que par un phénomène d'interférences lumineuses. Néanmoins l'un est spectaculaire et beau à observer, c'est la création des motifs colorés des couleurs de l'arc en ciel, observés à la surface d'une bulle de savon ou d'une fine couche d'huile recouvrant une flaque d'eau.</li><br>
<li>Par contre, trouver dans notre quotidien un fait observable qui ne peut s'expliquer que par un phénomène de diffraction et clairement attribuable à la diffraction  est quasiment impossible.</li>
</ul>

<p>Elle ne permet pas de comprendre comment la lumière est créée ou absorbée par la matière, ni les phénomènes liés à la polarisation et à la diffusion de la lumière. Je comprendrai et maîtriserai ces phénomènes dans le cadre beaucoup plus large de l'électromagnétisme.</p>
<ul class ="list">
<li>L'exemple le plus évident du phénomène de diffusion est celui de la diffusion de la lumière du soleil par l'atmosphère terrestre. Cette diffusion entraîne d'une part que le ciel de jour est lumineux dans toutes ces directions, et pas seulement dans la direction du soleil, d'autre part que la couleur du ciel est bleue alors que la couleur du soleil est jaune. En effet, dans l'espace interplanétaire, le soleil m'apparaîtrait comme un disque lumineux jaune très intense dans un ciel d'un noir total, hormis les sources de lumière ponctuelles des planètes et des étoiles lointaines.</li><br>
<li>L'oeil humain n'est pas sensible à la polarisation de la lumière, contrairement aux yeux ou photorécepteurs de certains animaux vertébrés ou invertébrés, comme l'abeille par exemple. Par contre, la technologie actuelle des films en 3D dans les salles de cinéma utilisent des lunettes grand public dont les verres sont polarisés. Différentes expériences mettant en évidence la polarisation de la lumière sont facilement réalisables chez soi en disposant de deux de ces paires de lunettes.</li>
<!-- à mettre quelque-part dans /M : Voir la polarisation de la lumière à l'œil nu (brosse de Haidinger), relativement facile à observer avec un écran d'ordinateur de technologie à cristaux liquides (LCD),
et avec les lunettes 3D de cinéma : http://blog.guillaume-loubet.fr/polarisation-circulaire-et-cinema-3d -->
</ul>


<!--p>Lorsque &lambda; n’est plus négligeable devant a, il faut tenir explicitement compte du caractère corpusculaire et ondulatoire de la lumière : c’est l’objet de l’optique physique. Ainsi l’optique géométrique ne permet pas de rendre compte des phénomènes d’interférences, de diffraction, elle ne permet pas d’expliquer le fonctionnement d’un Laser. Pour tout cela l’optique physique est nécessaire.</p-->
<br><br><br>




<h2>Fondement de l'optique géométrique</h2>

<h3>Concepts et principe de base</h3>

<h4>Le rayon de lumière</h4>

<h4>L'indice de réfraction</h4>

<p> la lumière se propage dans le vide à la vitesse de $c=300 000\;km.s^{-1}=3\cdot10^8\;m.s^{-1}$, et se propage en ligne droite dans tout milieu transparent homogène et isotrope. Cependant, <ins>en passant d'un milieu à un autre, je peux observer que la lumière change de direction à l'interface entre les deux milieux : c'est le phénomène de </ins><strong>réfraction de la lumière </strong> à l'interface entre les deux milieux.</p>
<ul class="list">
<li>Il me suffit de placer une petite cuillère dans un verre d'eau, pour constater que la cuillère semble au mieux tordue, au pire brisée, à l'interface eau/air. Du fait que cette impression ne soit qu'une illusion (l'eau n'agit pas sur la forme de la cuillère), je dois admettre que ce phénomène est incompatible avec une trajectoire de la lumière qui suivrait une même ligne droite à la traversée de l'interface. Dans le cas contraire, si l'interface eau/air situé entre la partie immergée de la cuillère et mon oeil ne modifiait pas la direction des rayons lumineux, je ne verrais aucune différence, que la cuillère soit totalement dans l'air ou partiellement immergée. Il doit y avoir, il y a un changement de direction de la lumière à la traversée de l'interface.</li>
<br>
<li>je peux dupliquer l'expérience, en prenant deux verres d'eau identiques, et en placant dans chacun d'eux un crayon identique dans la même position (l'effet est plus facilement mis en évidence avec la forme simple et parfaitement rectiligne d'un crayon, qu'avec la forme plus complexe d'une cuillère), j'observe la même brisure du crayon à l'interface dans les deux cas. Si maintenant je dissous une grande quantité de sucre (jusqu'à la limite de saturation) dans l'eau de l'un des verres, alors je remarque que la brisure devient plus prononcée. Ainsi l'effet dépend des milieux en présence de part et d'autre de l'interface, et non seulement de la présence d'une interface indépendamment des milieux qu'elle sépare. Ainsi différents milieux transparents interagissent différemment avec la lumière. De quelle façon des milieux transparents tels que l'eau pure ou l'eau fortement sucrée peuvent-ils interagir avec la lumière?</li>
</ul>

<p>Le phénomène de réfraction peut être expliquer quantitativement dans le cadre du principe de Fermat, si je considère que la vitesse de la lumière change selon le milieu de propagation.</p>

<ul class="exemple">
<li>Foucault en 1850 a déterminé expérimentalement la vitesse de la lumière dans l'eau et dans l'air, et a trouvé que la vitesse dans l'eau était inférieur à celle mesurée dans l'air. De plus, les valeurs permettent de calculer les corrects angles de réfraction en utilisant le principe de Fermat.</li>
</ul> 

<p>la vitesse de la lumière dans différents milieux apparait ainsi comme une quantité importante, qui est à l'origine de toutes les caractéristiques (grandissement, grossissement, aberrations, dispersion, ...) de tous les systèmes optiques utilisant des lentilles ou des primes. Parce que la vitesse de la lumière dans le vide est une constante fondamentale de la nature et qu'elle intervient dans un grand nombre de domaines de la physique, il est sensé de vouloir exprimer la vitesse de la lumière dans tout milieu relativement à sa valeur dans le vide : cela est réalisé avec l'indice de réfraction.</p>

<p>L'<strong>indice de réfraction </strong>, noté <strong>$n$</strong>, est défini comme le <ins> rapport entre la vitesse de la lumière dans le vide $c$ et celle dans le milieu considéré $v$</ins> :
<strong>$$n\;=\;\frac{c}{v}$$</strong>
<p>L'indice de réfraction étant le rapport de deux vitesse, c'est <strong>une grandeur physique sans dimension</strong>.</p>
<p>Comme la vitesse de la lumière dans tout milieux ne peut être qu'inférieure ou égale à sa valeur dans le vide, l'indice de réfraction est toujours <strong>une quantité supérieure ou égale à 1 :  ($n\ge1$)</strong></p>

<ul class="list">
<li>Bien sûr, à l'échelle atomique, un milieu matériel n'est ni homogène, ni isotrope. Par ailleurs un matériau est principalement constitué de vide, la taille des noyaux atomiques étant bien inférieure à la distance inter-atomique. Une lumière se propageant à vitesse réduite dans un matériaux transparent homogène est donc une image même si effectivement, quels que soient les mécanismes plus complexes et subtils d'interaction entre l'onde électromagnétique et les charges positives et négatives qui constituent la matière (noyaux positifs et électrons négatifs), le résultat finale est que la vitesse mesurée de la lumière lors de la traversée d'un matériau transparent est inférieure à sa vitesse dans le vide. As the electromagnetic wave possesses some characteristics to which the eye is not sensitive and which you still do not know well (like the polarization of the light), the possible phenomenons are many and the inferred technological possibilities numerous.</li><br>
<li>En modélisant ces mécanismes d'interaction (en utilisant la simple physique de Newton, ou la plus complexe physique quantique), il est possible d'obtenir une valeur complexe de l'indice de réfraction qui varie avec la fréquence de la lumière incidente et dépend des caractéristiques du matériau. Cette valeur complexe de l'indice de réfraction et sa dépendance en fréquence contient toute l'information nécessaire pour comprendre et simuler comme l'onde électromagnétique se comporte à l'interface avec un matériau (comment elle est réfléchie ou réfractée à l'interface) et dans le matériau (comment elle se propage à travers ou est absorbée dans le matériau, et comment le matériau réagit). </li></ul><!--Comme l'onde possède des caractéristiques auxquelles l'oeil n'est pas sensible et que je ne connais pas encore bien (comme la polarisation), les phénomènes possibles liés à la réfraction sont nombreux et les possibilités technologiques induites immenses.-->
<p>Je sais qu'un prisme disperse dans différentes directions toutes les composantes colorées d'un faisceau incident de lumière blanche. la fait que chaque rayon de lumière de ce faisceau subit simplement deux réfractions montre que  <strong>dans le domaine visible, l'indice de réfraction varie légèrement </strong><ins>avec la couleur</ins>, ou pour le dire plus précisément <ins>avec la fréquence (ou la longueur d'onde dans le vide) </ins>de la lumière</ins>.<p> 

<ul class="exemple">
<li>En géométrie, un prime est un solide limité par deux polygones, appelés les bases du prisme, obtenus l'uj de l'autre par une simple translation. Cela implique que c'est bases sont connectées l'une à l'autre par des parallélogrammes. Quand ces parallélogrammes sont rectangles, j'appelle ce prisme un prisme droit.<br>
En optique, un prisme est réalisé dans un matériau transparent et toutes ses surfaces sont polies. La forme usuel d'un prisme en optique, dont le but est de disperser un faisceau parallèle de lumière en toutes ses composantes colorées, possède une base triangulaire.
</li></ul>

<p>Ainsi pour réaliser une expérience précise de dispersion, je dois préciser la fréquance à laquelle est donné la valeur de l'indice de réfraction. Cependant, dans le visible, cette variation reste limitée (de l'ordre de quelques dixièmes de pourcent) and <ins>est donné seulement la </ins><strong>valeur moyenne de l'indice de réfraction</strong> (comme $n_{eau}=1.33$), ou la <strong>valeur de l'indice de réfraction à des longueurs d'onde (dans le vide) spécifiques</strong> à des raies spectrales ou des sources de lumières quasi-monochromatiques intenses qui ont permis de mesurer précisément la valeur de cette indice (par exemple $n\;_{546nm}$ pour un indice spectral déterminé à partir de la raie verte d'une lampe à vapeur de mercure, ou $n\;_{632nm}$ quand c'est un laser helium-néon qui a été utilisé).</p>


<h4>Le principe de Fermat</h4>

<p>Les deux lois importantes en optique géométrique (loi de la réflexion, et loi de la réfraction connue sous le nom de Snell-Descartes) dérivent directement du principe de Fermat.</p>

<h5>Temps de parcours</h5>
<p>Soit <strong>un chemin $S_{AB}$</strong> (donc une ligne continue) défini <ins>entre deux points donnés $A$ et $B$</ins> de l'espace. Ce chemin possède une <strong>longueur $s(S_{AB})$ </strong> telle que :
<strong>$$ s(S_{AB})\;=\;\int_{S_{AB}} ds$$</strong>
ou $ds$ est un élément de longueur infinitésimal pris le long du chemin  $S_{AB}$.</p>

<p>Ce chemin est parcouru à une vitesse variable au cours de son parcours. <strong>En chaque point $P$ de ce chemin </strong>, l'élément de <ins>longueur infinitésimal $ds_P$ </ins>est parcouru à la <ins>vitesse instantanée $v_P$</ins>, et le <strong>temps infinitésimal $dt_P$</strong> mis par la lumière pour parcourir cette distance $ds_P$ est, comme $ds_P\,=\,v_P\cdot dt_P$, alors :
<strong>$$dt_P\,=\,\frac{ds_P}{v_P}$$</strong></p>

<p>Si $t_A$ est l'instant de départ sur le chemin $S_{AB}$ et $t_B$ est l'instant d'arrivée, le <strong>temps de parcours $\tau=t_B-t_A$</strong> de ce chemin est la <ins>somme intégrale des temps infinitésimaux $dt_P$</ins> mis pour parcourir chacun des éléments de longueurs infinitésimaux $ds_P$ pris en tout point $P$ appartenant au chemin $S_{AB}$. Je peux écrire ce temps de parcours :<br>

<strong>$$\tau\;=\;\int_{P \in S_{AB}} dt_P\;=\;\int_{P \in S_{AB}}\frac{ds_P}{v_P}$$</strong>

 &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ou

 <strong>$$\tau\;=\;\;\int_{\tau} dt\;=\;\int_{S_{AB}}\frac{ds}{v}$$</strong>

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;ou encore

<strong>$$\tau\;=\;\int_{t_A}^{t_B} dt\;=\;\int_{A}^{B}\frac{ds}{v}$$</strong>

<ul class="exemple">
<li>Je peux l'écrire de plusieurs façons, mais l'essentiel est que je sois conscient de la grandeur physique que j'intègre, et du domaine d'intégration.</li></ul>

<p>Cette écriture intégrale me permet de calculer un temps de parcours dans les cas les plus complexe, si la vitesse est connue (ou estimée si je veux un temps de parcours estimé) en chaque point de la trajectoire considéré. <ins>Une trajectoire qui minimise le temps de parcours entre deux points de l'espace n'est pas toujours le segment de droite qui joint ces deux points.</ins>.</p>
<ul class="exemple">

<li> Je le conçois facilement à partir de la situation communément utilisée pour expliquer le théorème de Fermat et retrouver la loi de la réfraction : si je suis sur la rive d'un lac, à quelques mètres du bord de l'eau, et qu'un nageur est en difficulté dans le lac, à quelques mètres du bord lui aussi, le trajet en ligne droite de moi à lui n'est pas le trajet optimum pour le secourir. En effet je courre plus vite que je ne nage, aussi sera-t-il judicieux de parcourir une distance en ligne droite un peu plus grande sur la terre, et diminuer celle dans l'eau afin de le secourir au plus vite. Parmi tous les chemins possibles, il existe un chemin précis qui minimise le temps de parcours.</li></ul>

<p>Si j'applique ce calcul du temps de parcours à la lumière, en chaque point d'une trajectoire la vitesse de la lumière est déterminée par l'indice de réfraction du milieu en ce point et je peux écrire :

$$\tau\;=\;\int_{S_{AB}}\frac{ds}{v}\;=\;\frac{1}{c}\cdot\int_{S_{AB}}\frac{c}{v}\;\cdot ds$$
<strong>$$\tau\;=\;\frac{1}{c}\cdot\int_{S_{AB}}n\;ds$$</strong>

<h5>Chemin optique</h5>

<p>Lorsque la lumière se déplace sur des trajectoires traversant des milieux d'indices réfraction différents, les différents temps de parcours ne sont pas égaux aux longueurs correspondantes multipliées par un nombre réel unique, indépendant des trajectoires. Cela reste vrai sur la trajectoire unique d'un rayon de lumière traversant plusieurs milieux : pour une même longueur considérée le long de la trajectoire, le temps de parcours pourra être différent selon la portion de trajectoire sur laquelle la longueur est prise. Je peux résumer cela d'une phrase :</p>

<p><ins>Sur l'ensemble des cas,</ins><strong> le temps de parcours n'est pas proportionnel à la distance parcourue.</strong>

Or la grandeur physique importante associée à un parcours entre deux points de l'espace, pour savoir si la lumière choisira ce parcours plutôt q'un autre, sera le temps de parcours. Cependant lorsque je visualise mentalement une trajectoire, je vois une ligne à laquelle j'associe intuitivement une longueur. <ins>Comment travailler mathématiquement avec une grandeur physique homogène à une longueur, mais qui aurait les mêmes propriétés que le temps de parcours pour décrire la propagation de la lumière </ins>? Une telle grandeur a été définie en physique, et est grandement utilisée en optique géométrique, optique ondulatoire, électromagnétisme, et elle est nommée "<strong>chemin optique</strong> noté usuellement "<strong> $\delta_o$</strong>".</p>

<p>Le chemin optique $\delta_o$ d'un parcours donné $\Gamma_o$ entre deux points A et B de l'espace est <ins>homogène à une longueur</ins>. Son <strong>unité (S.I.)</strong> (son unité dans le Système International d'unités) est donc le "<ins>mètre</ins>".</p>

<p>Pour tout segment de droite pris entre deux points infiniment proche dans l'espace, son chemin optique infinitésimal (ou élémentaire) <strong>$\mathrm{d}\delta$</strong> est égal à sa <ins>longueur euclidienne $\mathrm{d}s$ multipliée par la valeur de l'indice de réfraction $n$</ins> moyennée sur le segment infinitésimal considéré :
<strong>$$\mathrm{d}\delta\;=\;n\times \mathrm{d}s$$</strong></p>

<p>Le chemin optique $\delta$ d'un parcours donné $\Gamma_o$ entre deux point de l'espace est simplement la somme des chemins optiques infinitésimaux intégrés sur ce parcours :
<strong>$$\delta = \int_{\Gamma_o}\mathrm{d}\delta= \int_{\Gamma_o}n\cdot \mathrm{d}s$$</strong></p>

<p>Quelques soient deux points donnés A et B de l'espace, et quelque soit le parcours considéré entre ces deux points, le <strong>chemin optique</strong> sera <ins>toujours égal au temps de parcours de la lumière sur ce parcours divisé par la vitesse de la lumière dans le vide $c$ </ins>qui est une constante universelle de la nature :
<strong>$$\mathrm{d}\delta\;=\;\frac{ds}{c}$$
$$\delta = \int_{S_{AB}}n\cdot\mathrm{d}s\;=\;\int_{S_{AB}}\frac{c}{v}\cdot\mathrm{d}s$$
$$\hspace{1cm}= c\;\int_{S_{AB}}\frac{\mathrm{d}s}{v} =\;c\;\tau$$</strong>
</p>

<br>
<ul class="exemple">Je peux maintenant considérer un rayon lumineux se propageant d'un point A à un point B, et lui imposer au cours de sa trajectoire entre A et B d'interagir avec un système optique. Je peux ensuite considérer l'ensemble des chemins possibles (ils sont en nombre infini en optique) entre A et B, et considérer une application $f$ qui à chaque chemin de cet ensemble associe une grandeur physique particulière. En optique géométrique, les deux grandeurs physiques intéressantes sont le temps de parcours et le chemin optique. La question est :<br>
Le trajet réellement suivi par la lumière dans chaque cas correspond-t-il à un chemin défini par un point particulier de la fonction $f$ ?. Les points particuliers qui vont m'intéresser en optique géométrique sont appelés en mathématiques les points stationnaires.</ul>

<h5>Grandeur physique stationnaire</h5>

<p>Soit <strong>$\Gamma_o$</strong> un <ins>chemin continue dans l'espace entre deux points A et B</ins>, chemin entièrement <ins>déterminé par son paramètre </ins><strong>$\lambda_o$</strong>, ou <ins>plusieurs paramètres indépendants </ins><strong>$\lambda_{io}$</strong>.</p>
<p> 
Soit <strong>$f$ </strong>une <ins>grandeur physique caractérisant  ce chemin</ins> $\Gamma$.</p>
<ul class="exemple">
<li>Pour l'application du principe de Fermat, je travaillerai avec le temps de parcours ou le chemin optique entre A et B.</li></ul>

<p>
Je considère maintenant $\Gamma$ tout chemin infiniment proche de $\Gamma_o$ et de mêmes extrémités A et B, et caractérisé par son paramètre $\lambda=\lambda_o+d\lambda$ ou ses paramètres $\lambda_i=\lambda_{io}+d\lambda_i$.</p>
<p> 
La grandeur physique <strong>$f$</strong> est <strong>stationnaire sur le chemin $\Gamma_o$</strong> si <ins>sa variation calculée au premier ordre est nulle sur tout chemin $\Gamma$ infiniment proche de $\Gamma_o$</ins> :


<strong>$$\mathrm{d}f(\Gamma_o)=\frac{\mathrm{d}f}{\mathrm{d}\lambda}(\Gamma_o)\cdot\mathrm{d}\lambda=0$$</strong>
&nbsp;&nbsp;&nbsp;&nbsp;ou
<strong>$$\mathrm{d}f(\Gamma_{o})=\sum_i\frac{\partial f}{\partial\lambda_i}(\Gamma_o)\cdot\mathrm{d}\lambda_i=0$$</strong>
</p>

<p>En mathématiques, pour une <strong>fonction $f:\mathbb{R}\rightarrow\mathbb{R}$</strong> (fonction réelle $f$ à variable réelle $x$), un <strong>point stationnaire</strong> ou <strong>point critique</strong> correspond à un <ins> maximum</ins> (au moins local), ou à un <ins> minimum</ins> (au moins local), ou encore à un <ins>point d'inflexion stationnaire</ins>. Pour une <strong>fonction $f :\mathbb{R}^2\rightarrow\mathbb{R}$</strong>, il faut rajouter le <ins>point col ou point selle </ins>(en un point selle la fonction présente un maximum local selon un axe et un minimum local selon un autre axe, ce qui lui donne localement la forme d'une selle de cheval). Il faut aussi noter que tout point d'une fonction constante (de $\mathbb{R}\rightarrow\mathbb{R}$ ou de $\mathbb{R}^2\rightarrow\mathbb{R}$) est un points stationnaire.</p>
<!--Un point stationnaire P s'identifie facilement parce que la <ins>dérivée première de la fonction s'annule en ce point  (fonction d'une seule variable)</ins> ou <ins>chacune des dérivées partielles s'annulent en ce point (fonction de deux variables)</ins> :

<strong>$$\frac{d\tau}{dx}(P)=0$$</strong>
&nbsp;&nbsp;&nbsp;ou
<strong>$$\frac{\partial\tau}{\partial x}(P)=0\:\:\:\:et\:\:\:\:\frac{\partial\tau}{\partial y}(P)=0$$</strong-->



<!--p>Le <strong>type d'un point stationnaire</strong> P s'identifie facilement par l'<ins>étude de la dérivée seconde ou des dérivées partielles secondes en ce point P</ins>.</p>
<p>Pour une <strong>fonction d'une variable</strong>, P est un :
<ul class="list">
<li><strong>maximum</strong> si et seulement si <ins>${\large\frac{d{\large\tau}}{dx}}(P)<0$</ins></li>
<li><strong>minimum</strong> si et seulement si <ins>${\large\frac{d{\large\tau}}{dx}}(P)>0$</ins></li>
</ul>
<p>Pour une <strong>fonction de deux variables</strong>, et en posant :

<ins>$$r=\frac{\partial^2{\large\tau}}{\partial x^2} , 
s=\frac{\partial^2{\large\tau}}{\partial x\,\partial y} , 
t=\frac{\partial^2{\large\tau}}{\partial y^2}$$</ins>
&nbsp;&nbsp;&nbsp;P est un :
<ul class="list">
<li><strong>maximum</strong> si et seulement si <ins>$rt-s^2>0$ et $r<0$</ins></li>
<li><strong>minimum</strong> si et seulement si <ins>$rt-s^2>0$ et $r>0$</ins></li>
<li><strong>point selle</strong> si et seulement si <ins>$rt-s^2<0$</ins></li>
</ul></p-->

<!--un couts trans1 sera l'étude des points critiques des fonctions à une ou deux variables -->


<h5>Enoncé du principe de Fermat</h5>

<p>Le <strong>principe de Fermat</strong> peut s'énoncer <ins>à partir du temps de parcours</ins> ou bien <ins>à partir du chemin optique</ins> de la lumière entre deux points de sa trajectoire. Ces deux grandeurs physiques associées sont en effet simplement proportionnelles entre elles, et elles auront donc la propriété de stationnarité sur les mêmes parcours. Les deux énoncés du principe de Fermat sont :</p>

<p><strong>"Entre deux points de sa trajectoire, la lumière suit tout parcours sur lequel son temps de propagation est stationnaire par rapport à tout autre parcours infiniment voisin."</strong></p>

<p><strong>"Entre deux points de sa trajectoire, la lumière suit tout parcours de chemin optique stationnaire par rapport à tout autre parcours infiniment voisin."</strong></p>


<h5>chemin stationnaire dans un milieu homogène</h5>

<p>Par définition, dans un <strong>milieu homogène</strong> l'<ins>indice de réfraction à la même valeur en tout point</ins>, donc je peux écrire :<br>
$$\tau\;=\;\frac{1}{c}\cdot\int_{S_{AB}}n\;ds\;=\;\frac{n}{c}\cdot\int_{S_{AB}}ds$$

Comme $n$ et $c$ sont des constantes, lors le <strong>temps de parcours $\tau$ </strong><ins>est proportionnel à la simple longueur euclidienne $s= \int_{S_{AB}}ds$ du chemin suivi </ins>entre A et B.</p>

<p>Il existe une infinité de chemins possibles entre A et B, dont les longueurs s'étendent depuis une longueur minimum jusqu'à l'infini. Le seul chemin sur lequel le temps de parcours de la lumière est stationnaire est ici le chemin de longueur minimum entre ces deux points, soit le segment de droite [AB]. Le principe de Fermat postule donc que la lumière suivra le segment de droite qui joint ces deux points A et B.</p>
<p> <strong>Dans un milieu homogène</strong>,<ins> les rayons lumineux sont des droites </ins></p>

<h5>chemin optique stationnaire lors d'une réflexion</h5>

<p>Soit un <strong>miroir plan</strong>.</p>

<!--A  REPRENDRE !!! >
Inutile et nuisble de préciser que c'est un miroir, ni que la surface sur laquelle s'éffectue la réflexion soit plane. On peut refaire toute la démonstration sans l'hypothèse que le dioptre est plan !, et il faut le faire. En effet, le principe de Fermat ne nécessite que de connaître trois points : un point A placé sur le trajet du rayon de lumière avant interaction avec la surface du dioptre, un point B placé sur le trajet de la lumière après interaction avec la surface du dioptre, et le point d'impact du rayon de lumière à la surface du dioptre. La loi de la réfraction se déduit seulement de ces 3 points et s'exprime par deux angles i1 et i2 dont la référence est la normale à la surface au point d'impact. Cette normale est définie mathématiquement par rapport au plan tangent à la surface au point I. Il suffit donc que la surface soit une surface continue (mathématiquement, c'est ca?). Elle peut être plane ou courbe, aussi compliquée soit la courbure. -->

<p>Pour simplifier les calculs, je choisi un système d'axes $(O,x, y, z)$ orthonormé direct tel que la surface du miroir soit dans le plan $(O,x,y)$.</p>
<p>Soit <strong>A et B </strong><ins>deux points situés d'un même côté du miroir</ins>, et <ins>par lesquels passe un même rayon lumineux</ins>. Le rayon lumineux passe d'abord par le point A, se réfléchit sur le miroir en un point I avant de passer par le point B.</p>
<p>Pour simplifier les calculs, je peux choisir les axes $Ox$ et $Oy$ tels que les points A et B soient situés dans le plan $(O,x,z)$.</p>
<p> Soient $(x_A,0,z_A)$, $(x_B,0,z_B)$ les cordonnées fixées des deux points A et B dans le système d'axe choisi, et  $(x_I,y_I,0)$ les cordonnées variables du point I dans le plan du miroir.</p>
<p>Le <strong>trajet du rayon lumineux</strong> se fait en <ins>deux parties</ins>, du point A au point I, puis après réflexion du point I au point B, toutes deux <ins>situées dans un même milieu homogène</ins> d'indice de réfraction $n$. Le chemin suivi par la lumière est donc constitué des deux segments de droite [AI] et [IB], de longueurs respectives notées d(A,I) et d(I,B). Le <strong>chemin optique</strong> s'écrit alors :

$$\delta=\int_{S_{AI}}n\;ds\;+\int_{S_{IB}}n\;ds$$
$$\hspace{0.2cm}=n\cdot \big( d(A,I)+d(I,B) \big)$$

<p> En fonction des coordonnées des points A et B et des variables coordonnées du point I, il se réécrit :
<ins>
$$\delta(x_I,y_I)=n\cdot\Big(\sqrt{(x_I-x_A)^2+y_i^2+z_A^2}$$
$$\hspace{0.8cm}+\sqrt{(x_I-x_B)^2+y_i^2+z_B^2}\;\Big)$$
</ins>

<p>Tout couple de coordonnées ($x_I,y_I) \in \mathbb{R}^2$ représente un parcours entre A et B susceptible d'être emprunté par la lumière. Par ailleurs tout parcours susceptible d'être emprunté par la lumière peut être identifié par un couple ($x_I,y_I) \in \mathbb{R}^2$ .

<ul class="exemple"><li>En terme mathématiques, je donnerai une description plus précise et plus complète en disant qu'il existe une bijection entre $\mathbb{R}^2$ et l'ensemble des parcours possibles entre les point A et B.</li></ul>

<p>Le <ins>parcours réellement suivi par la lumière</ins> selon le principe de Fermat doit être <strong>stationnaire</strong>. Donc <ins>tout couple de coordonnées ($x_I,y_I$)  qui vérifie</ins>  
<strong>
$$\delta(x_I,y_I)=\frac{\partial\delta}{\partial x_I}\cdot dx_I\;+\;\frac{\partial\delta}{\partial y_I}\cdot dx_I=0$$

pour toutes variations infinitésimales et indépendantes $dx_I$ et $dy_I$</strong>, est un <ins>parcours effectivement choisi par la lumière</ins>.</p>
<p>Cela n'est possible que si chacune des dérivées partiels est nulle, soit :

$$(1)\hspace{0.2cm}\frac{\partial\delta}{\partial x_I}=n\cdot\bigg({\small{\frac{x_I-x_A}{\sqrt{(x_I-x_A)^2+y_i^2+z_A^2}}}}$$
$$\hspace{0cm}+{\small{\frac{x_I-x_b}{\sqrt{(x_I-x_B)^2+y_i^2+z_B^2}}}}\;\bigg)=0$$
&nbsp;&nbsp;&nbsp;&nbsp;et 
$$(2)\hspace{0.2cm}\frac{\partial\delta}{\partial y_I}=n\cdot\bigg({\small{\frac{y_I}{\sqrt{(x_I-x_A)^2+y_i^2+z_A^2}}}}$$
$$\hspace{0cm}+{\small{\frac{y_I}{\sqrt{(x_I-x_B)^2+y_i^2+z_B^2}}}}\;\bigg)=0$$</p>

<p>Comme les points A et B sont ne sont pas dans le plan du miroir ($z_A > 0$ et $z_B > 0$) alors les deux termes en racine carré sont strictement positifs. L'équation $(2)$ n'est donc vérifiée que si implique $y_I=0$ : le principe de Fermat postule ici que les 3 points A, I et B sont dans le même plan $y=0$, appelé plan d'incidence. Ainsi le <strong>rayon réfléchi </strong>est <ins>dans plan d'incidence </ins>défini par le rayon incident et la normale à la surface du miroir. au point I.</P>

<p>Dans ce plan d'incidence $(O,x,z)$, l'équation $(1)$ implique que les coordonnées des points A=($x_A,z_A$) et B=($x_B,z_B$) vérifient :
$${\small{\frac{x_I-x_A}{\sqrt{(x_I-x_A)^2+z_A^2}}=\frac{x_I-x_B}{\sqrt{(x_I-x_B)^2+z_B^2}}}}$$
Cela implique premièrement, comme une racine carrée est toujours un nombre positif, que $x_I$ est un nombre compris entre $x_A$ et $x_B$. Dans le plan d'incidence, le <strong>rayon réfléchi</strong> est toujours <ins>de l'autre côté de la normale au plan du miroir au point d'impact</ins>, par rapport au rayon incident.<p>
<p>Deuxièmement, en remarquant dans cette même équation (1) que
<ins>$${\small{\frac{|\,x_I-x_A\,|}{\sqrt{(x_I-x_A)^2+z_A^2}}}}=\sin(i_i)$$
$${\small{\frac{|\,x_I-x_B\,|}{\sqrt{(x_I-x_B)^2+z_B^2}}}}=\sin(i_r)$$</ins>
<ul class="main">
<li>avec <strong>$i_i$ angle d'incidence</strong><ins> du rayon incident</ins> et <strong>$i_r$ angle de réflexion</strong><ins> du rayon réfléchi</ins> <strong>par rapport à la normale en I</strong><ins> au plan du miroir</ins>.</li></ul>

<p>on en déduit que l'<strong>angle de réflexion</strong> à la surface du miroir est <ins>égal à l'angle d'incidence</ins>.</p>


<h5>chemin optique stationnaire à la traversée d'un dioptre plan</h5>

<!--A  REPRENDRE !!! >
On peut refaire toute la démonstration sans l'hypothèse que le dioptre est plan !, et il faut le faire. En effet, le principe de Fermat ne nécessite que de connaître trois points : un point A placé sur le trajet du rayon de lumière avant interaction avec la surface du dioptre, un point B placé sur le trajet de la lumière après interaction avec la surface du dioptre, et le point d'impact du rayon de lumière à la surface du dioptre. La loi de la réfraction se déduit seulement de ces 3 points et s'exprime par deux angles i1 et i2 dont la référence est la normale à la surface au point d'impact. Cette normale est définie mathématiquement par rapport au plan tangent à la surface au point I. Il suffit donc que la surface soit une surface continue (mathématiquement, c'est ca?). Elle peut être plane ou courbe, aussi compliquée soit la courbure. -->

<p>J'appelle dioptre plan toute surface plane séparant deux milieux transparents homogènes d'indices de réfraction différents.<p>

<p>Pour simplifier les calculs, je choisi un système orthonormé direct d'axes $(O,x, y, z)$ tel que le dioptre soit le plan $(O,x,y)$. Le milieu situé côté positif de l'axe $Oz$ a pour indice de réfraction $n_1$ , et le milieu situé côté négatif a pour indice de réfraction $n_2$. </p>

<p>Soit <strong>A et B </strong><ins>deux points situés de part et d'autres du dioptre</ins>, et <ins>par lesquels passe un même rayon lumineux</ins>. Le rayon lumineux passe d'abord par le point A situé dans le milieu d'indice $n_1$, traverse le dioptre en un point I avant de passer par le point B situé dans le milieu d'indice $n_2$.</p>

<p>Pour simplifier les calculs, je peux choisir l'origine O et les axes $Ox$ et $Oy$ tels que les points A et B soient situés dans le plan $(O,x,z)$.</p>

<p> Soient $(x_A,0,z_A)$, $(x_B,0,z_B)$ les cordonnées fixées des deux points A et B dans le système d'axe choisi, et  $(x_I,y_I,0)$ les cordonnées variables du point I dans le plan du dioptre</p>

<p>Le <strong>trajet du rayon lumineux</strong> se fait en <ins>deux parties</ins>, du point A au point I dans le milieu d'indice $n_1$, puis après traversée du dioptre, du point I au point B dans le milieu d'indice $n_2$. Le chemin suivi par la lumière est donc constitué des <ins>deux segments de droite</ins> [AI] et [IB], de longueurs respectives notées d(A,I) et d(I,B). Le chemin optique s'écrit alors :

$$\delta=\int_{[AI]}n_1\;ds\;+\int_{[IB]}n_2\;ds$$

<p> En fonction des coordonnées des points A et B et des coordonnées variables du point I, le <strong>chemin optique</strong> se réécrit :
<ins>
$$\delta(x_I,y_I)=n_1\cdot\sqrt{(x_I-x_A)^2+y_I^2+z_A^2}$$
$$\hspace{0.8cm}+n_2\cdot\sqrt{(x_I-x_B)^2+y_I^2+z_B^2}$$
</ins></p>


<p>Le <ins>parcours réellement suivi par la lumière</ins> selon le principe de Fermat doit être <strong>stationnaire</strong>. Donc <ins>tout couple de coordonnées ($x_I,y_I$)  qui vérifie</ins>  
<strong>
$$\delta(x_I,y_I)=\frac{\partial\delta}{\partial x_I}\cdot dx_I\;+\;\frac{\partial\delta}{\partial y_I}\cdot dx_I=0$$

pour toutes variations infinitésimales et indépendantes $dx_I$ et $dy_I$</strong>, est un <ins>parcours effectivement choisi par la lumière</ins>.</p>
<p>Cela n'est possible que si chacune des dérivées partiels est nulle, soit :

$$(3)\hspace{0.2cm}\frac{\partial\delta}{\partial x_I}=n_1\cdot{\small{\frac{x_I-x_A}{\sqrt{(x_I-x_A)^2+y_i^2+z_A^2}}}}$$
$$\hspace{0cm}+n_2\cdot{\small{\frac{x_I-x_B}{\sqrt{(x_I-x_B)^2+y_i^2+z_B^2}}}}\;=0$$
&nbsp;&nbsp;&nbsp;&nbsp;et 
$$(4)\hspace{0.2cm}\frac{\partial\delta}{\partial y_I}=n_1\cdot{\small{\frac{y_I}{\sqrt{(x_I-x_A)^2+y_i^2+z_A^2}}}}$$
$$\hspace{0cm}+n_2\cdot{\small{\frac{y_I}{\sqrt{(x_I-x_B)^2+y_i^2+z_B^2}}}}\;=0$$</p>

<p>Dans l'équation (4), chaque terme en racine carrée est un nombre réel strictement positif dans les cas qui nous intéressent (A et B de part et d'autre du dioptre, donc $z_A>0$ et $z_B>0$). De plus  les indices $n_1$ et $n_2$ sont toujours supérieurs ou égaux à l'unité, donc l'équation ne peut être vérifiée que si 

$$y_I\;=\;0$$

Je retrouve bien le cas de la réflexion. Tout <strong>rayon réfracté</strong> est <ins>contenu dans le plan d'incidence</ins>.</p>

<p>De même, l'équation (3) n'est vérifiée que si :
$$n_1\cdot (x_I-x_A)\;=- \;n_2\cdot (x_I-x_B)$$
et là encore, comme $n_1$ et $n_2$ sont strictement positifs, cela implique que que $x_I$ est un nombre compris entre $x_A$ et $x_B$. Dans le plan d'incidence, le <strong>rayon réfracté</strong> est toujours <ins>de l'autre côté de la normale au plan du dioptre au point d'impact</ins>, par rapport au rayon incident.</p>

<p>Enfin si je remarque dans cette même équation (3) que
<ins>$${\small{\frac{|\,x_I-x_A\,|}{\sqrt{(x_I-x_A)^2+z_A^2}}}}=\sin(i_1)$$
$${\small{\frac{|\,x_I-x_B\,|}{\sqrt{(x_I-x_B)^2+z_B^2}}}}=\sin(i_2)$$</ins>
<ul class="main">
<li>avec <strong>$i_1$ angle d'incidence</strong><ins> du rayon incident</ins> et <strong>$i_2$ angle de réflexion</strong><ins>du rayon réfléchi</ins> <strong>par rapport à la normale en I</strong><ins> au plan du miroir</ins>.</li></ul>

<p>j'en déduis que la <strong>relation entre l'angle d'incidence $i_1$ et l'angle de réfraction $i_2$</strong> à la surface du miroir est <ins>$n_1\cdot \sin(i_1)=n_2\cdot\sin(i_2)$</ins>.</p>


<h5>Etude de cas :  réflexion sur un miroir elliptique</h5>

<h5>Etude de cas :  réflexion sur un miroir sphérique concave</h5>




<!--ul class="list">
<li>Ce dernier point est important. Si je me déplace en voiture sur un trajet entre deux villes, pour un même itinéraire, le temps de parcours dépendra de ma conduite. Je suis à chaque instant maître de la vitesse de ma voiture (dans ses limites, et dans les limites de sécurité), et donc le temps de parcours n'est pas une caractéristique du chemin lui-même.</li>
<li>Un temps de parcours qui ne dépendrait que du chemin lui même peut-être calculé en considérant que la voiture atteint, sur chaque portion de route caractérisée par une vitesse limite autorisée, une vitesse moyenne représentant 90% (par exemple de cette vitesse limite.</li></ul-->



<h5>Le principe dérivé du "retour inverse de la lumière"</h5>
<p>Je regarde la trajectoire d'un rayon lumineux dans l'espace. Sur cette trajectoire, je sélectionne deux points distincts quelconques sur cette trajectoire, mais tels que le sens de propagation de la lumière soit de A vers B. Quelques soient les systèmes optiques placés sur cette trajectoire entre ces deux points A et B, la trajectoire suivie par la lumière entre ces deux points suit le principe de Fermat : entre l'infinité de trajectoires possibles entre ces deux points, la lumière "choisit" celle qui minimise ou maximise le temps de parcours.</p>
<p>Si maintenant je considère une situation où la lumière doit se propager depuis le point B vers le point A, quelle serait la trajectoire de la lumière pour ce sens de parcours? Dans son énoncé, le principe de Fermat ne mentionne nullement un sens de propagation (de A vers B, ou de B vers A). Il est ainsi évident que la trajectoire déterminée par le principe de Fermat est identique, que la lumière se propage de A vers B ou de B vers A. Ce principe est connu sous le nom de "<strong>principe du retour inverse de la lumière</strong> et je peux l'énoncer de la façon suivante :</p>
<p><strong>Le trajet suivi par la lumière est indépendant du sens de propagation.</strong></p>
<p>Application : en optique géométrique, <ins>pour résoudre certains problèmes</ins>, il peut être <ins>parfois plus facile</ins> pour moi <ins>de considérer que la lumière se propage en sens inverse de son sens de propagation réel</ins>.</p>


<h3>Objets et images</h3>

<p class="exemple">L'optique géométrique est l'art de comprendre et maîtriser les images. Les images que je vois sont la perception indirecte d'objets. La perception est indirecte parce que les rayons lumineux issus de l'objet ne se propagent pas en ligne droite de l'objet jusqu'à l'oeil dans le milieu homogène que constitue l'air (ou l'eau, ou le vide, ou tout autre milieu homogène), mais qu'ils rencontrent sur leur trajectoire des objets surfaces réfléchissantes, des volumes transparents ou des modifications graduelles de l'indice de réfraction du milieu traversé qui modifient la direction des rayons lumineux. Ces surfaces et volumes seront appelés systèmes optiques. Entre l'objet physique initial qui émet sa propre lumière ou diffuse la lumière ambiante et l'oeil peuvent se trouver plusieurs systèmes optiques.</p>

<p class="exemple">Quand je dis "les images que je vois", cela signifie qu'il y a une image à voir. Mais est-ce toujours le cas? A travers une vitre translucide, je ne vois aucun des objets présents de l'autre côté de la vitre. Ou plus exactement ce que je vois semble très flou, ce qui ne m'empêche pas de distinguer des choses. Alors, ce que je vois peut-il être qualifié d'images d'objets vues à travers la vitre translucide?</p>

<p class="exemple">L'optique géométrique est l'art de comprendre et maîtriser les images. Mais avant de maîtriser le système optique qui me permettra de réaliser l'image que je souhaite, je dois définir la notion même d'image, je dois préciser la relation entre l'objet, l'image et le système optique qui la créé si elle existe. Avec une première question simple. Le vocabulaire est imprécis sur ce sujet : l'image est-elle seulement la perception mentale d'un objet vu à travers un système optique ? Ou bien a t'elle une existence physique propre indépendante du fait que je l'observe ou non ? Voici des questions que je dois préparer avec mon défi "objets et images".</p>
<p>L'<strong>objet physique initial</strong> occupe un <ins>volume dans l'espace, délimité par une surface</ins>. Cette surface peut se décomposer en une <ins>infinité de </ins><strong>surfaces physiques élémentaires</strong> (une surface élémentaire est une <ins>surface dont l'aire tend vers zéro</ins>), chacune <ins>ayant sa position propre dans l'espace, émettant sa propre lumière ou diffusant la lumière qu'elle reçoit dans un faisceau lumineux</ins></p>

<p>En optique géométrique, j'appelle <strong>faisceau lumineux</strong> un <ins>ensemble continu de rayons lumineux se propageant en lignes droites et convergents en un point, qui délimitent le volume de l'espace éclairé</ins>.</p>
<ul class="exemple">
Le faisceau lumineux étant un faisceau de droite, il est défini dans un milieu homogène, c'est à dire un milieu caractérisé par un indice de réfraction constant, afin que la lumière se propage effectivement en ligne droite.
</ul>


<p>Cette surface physique élémentaire peut :
<ul class="mainlist">
<li>appartenir à la surface d'un objet quelconque, dont l'état de surface présente des irrégularités de tailles de l'ordre ou supérieures à la longueur d'onde de la lumière qui l'éclaire. Cette surface physique élémentaire diffuse alors la lumière reçu dans tout le demi-espace situé devant elle/</li>
<li>appartenir à la minuscule surface émettrice d'une diode laser. Le faisceau de sortie, conique, est alors extrêmement étroit, très peu divergent et je parle alors de pinceau lumineux.</li>
<li>être assimilé au minuscule miroir de sortie d'un laser à gaz, auquel cas le pinceau lumineux émis est si peu divergent qu'il peut être représenté un rayon lumineux unique.</li>
</ul>
D'une façon générale, toute surface élémentaire physique émet ou diffuse de la lumière par un faisceau lumineux.</p>



<!-- c'est facile à comprendre, mais un peu faux : un élément de surface émet de la lumière dans un angle solide de 2pi stéradians devant lui. Mais cela sera faux quand on va généraliser à un point objet comme simple point de convergence d'un faisceau lumineux, sans que ce faisceau couvre un angle solide de 2pi stéradians. . je pense qu'il faut réécrire ce paragraphe en introduisant la notion de faisceau.-->


 . , qui émet sa propre lumière ou diffuse la lumière qu'il reçoit dans toutes les direction. Cet objet physique étant étendue, je considère chaque petite surface élémentaire de cet objet, chacune étant localisée à une position précise dans l'espace. Cette petite surface élémentaire physique émet ou diffuse de la lumière dans toutes les directions



<h3>Relation avec les phénomènes optiques</h3>

<p>Si je vois un objet, c'est que de la lumière parcourt une certaine trajectoire entre cet objet et mon oeil. La lumière porte de l'énergie. Cette énergie lumineuse est convertie en énergie chimique puis en énergie électriques dans les cellules de la rétine de mon oeil. Cette énergie électrique se propage dans le nerf optique puis les neurones de mon cortex cérébral dans lequel un processus cognitif me donne conscience de percevoir de la lumière.</p>


<p>J'appelle <strong> rayon lumineux</strong> une trajectoire orientée par une flèche parcourue par la lumière entre le point objet qui émet la lumière et</p>

<p> L'objet que je vois est en général étendu, et donc dans une direction particulière de l'espace, je vois une infime partie de l'objet. Je peux décomposer cet <strong>objet visible</strong> en un <em>ensemble continue de points émetteur</em>. Ainsi chaque <strong>point émetteur</strong> <em>émet donc de la lumière</em>, c'est à dire q'<em>un ensemble de rayons lumineux partent du point émetteur</em>.</p>
<ul class="exemple">
<li>J'appelle <strong>point objet émetteur</strong> ou <strong>source ponctuelle primaire de lumière</strong> , un <em>point émetteur qui créé sa propre lumière</em>. Même dans l'obscurité ambiante, un objet émetteur sera vu.</li>
<li>J'appelle <strong>point objet diffuseur</strong>, un <em>point objet qui diffuse dans toutes les directions de l'espace, la lumière qu'il reçoit d'une source éclairante </em>(soleil, lampe,...).</li>
<li>J'appelle <strong>point objet réflecteur</strong> un point objet qui, <em>pour chaque rayon lumineux incident qu'il reçoit, re-émet ce rayon lumineux dans une direction particulière suivant la loi de la réflection</em>.</li></ul>

<!-- Source étendue de surface S, élément de surface dS d'une source étendue, source ponctuelle
Source qui émet dans toutes les directions, source qui émet un faisceau parallèle ou faiblement divergent (lasers, diodes lasers). Source monochromatique, quasi-monochromatique, polychromatiques (avec raies d'émission discrètes et/ou émission large bande. /M intensité spectrale, les couleurs de l'univers--source ponctuelle toujours réelle-->

<!-- créer une image : faire en sorte que tout point source dans l'espace 3D se projette en une image ponctuelle dans un plan donné , plan de l'image : C'est le rôle d'un système optique réalisé dans un objectif d'imagerie. L'angle de vue définit la projection.. défauts : aplanétisme, stigmatisme, profondeur de champ, aberrations-->

<!--caractéristique d'une source diffusante : point de convergence initial des faisceaux issus de la source si pas de changement de milieu de propagation : ce sera la caractéristiques d'un point objet.
toute source ponctuelle est un point objet pour un système optique. Tout point objet n'est pas source ponctuelle.-->

<!-- instrument d'optique : former des images ponctuelles dans un plan donné de sources ponctuelles
système optique : former des images ponctuelles de points objets ponctuels
point objet et point image sont conjugués par le système optique.
Point objet réel ou virtuel / point image réel ou virtuel-->

<!-- vision à l'oeil nu , image à l'infini-->

<!--point source -- système optique -->image ponctuelle.-->

<!-- caractéristique d'une image :-->



<h3>La relation objet image</h3>


<h3>L'image 3D d'un objet 3D</h3>
<h4>Existence et définition d'une image</h4>
<h4>Le stigmatisme d'un système optique</h4>
<h4>Grandissement transversal et grandissement longitudinal</h4>
<h3>Projection d'une image dans un plan</h3>
<h4>Nécessité d'une image plane</h4>
<h4>Le stigmatisme dans le plan image</h4>
<h4>Les défauts d'une image plane</h4>
<h5>L'aberration sphérique</h5>
<h5>La coma</h5>
<h5>L'aberration chromatique</h5>
<h4>la profondeur de champ</h4>



<h2>Les éléments optiques simples</h2>

<p>J'appelle <strong>élément optique</strong> <ins>toute structure matérielle qui</ins>, exposée ou placée dans un faisceau de lumière, <ins>modifie la direction de propagation des rayons lumineux du faisceau ou le bloque</ins> ou modifie toute autre propriété de la lumière du faisceau.</p>
<ul class="exemple">
<li>En optique géométrique, l'élément optique modifie simplement la direction des rayons <ins>par réflexion ou réfraction</ins>, ou bien le bloque <ins>par absorption</ins>. Dans une description plus complète de la lumière (optique ondulatoire, électromagnétisme, optique quantique qui est une partie de l'électrodynamique quantique), l'élément optique modifie d'autres propriétés de la lumière qui ne sont pas décrites par l'optique géométrique. Il peut atténuer ou absorber la lumière, complètement ou sélectivement selon la longueur d'onde (ce qui revient à dire selon la fréquence de l'onde électromagnétique ou l'énergie des photons incidents), il peut diffracter la lumière ou changer son état de polarisation. Technologiquement, des systèmes optiques complexes peuvent aussi modifier la longueur d'onde, la durée du pulse d'un faisceau laser, ...</li></ul>

<p><strong>En optique géométrique</strong> qui décrit l'optique de la vie de tous les jours, les <strong>éléments optiques simples</strong> seront ceux qui sont utiliser pour construire les appareils optiques usuels : je les limite au <ins>miroirs</ins>, aux <ins>dioptres</ins>, et aux <ins>lentilles minces </ins>.</p>

<p>Un système matériel présente un <strong>symétrie de révolution autour d'un axe $Oz$</strong> si <ins>toutes les caractéristiques de cet élément dans un plan contenant l'axe $Oz$ restent identiques dans tout plan contenant le même axe $Oz$</ins>. Les caractéristiques du système matériel que va prendre en compte l'optique géométrique seront bien sur la <ins>forme</ins>, l'<ins>état de surface</ins> (qui permet ou non le phénomène de réflexion) et la <ins>matière</ins> (à travers l'indice de réfraction qui la caractérise).</p>

<ul class="exemple">Je nomme souvent $Oz$ l'axe d'une symétrie de révolution, par référence au système de coordonnées cylindriques qui décrit facilement ce type de symétrie.</ul>

<p>La plupart des appareil optiques usuels (télescopes, lunettes astronomiques ou terrestres, microscopes, optique d'un appareil photo, ...) présentent une symétrie de révolution autour d'un axe que je peux appeler $Oz$, par référence au système de coordonnées cylindriques qui décrit facilement ce type de symétrie. Il en est donc de même pour les miroirs, lentilles et dioptres qui les composent.</p>

<p>Les <strong> éléments optiques simples</strong> sur lesquels je vais travailler à ce niveau <ins>présentent une symétrie de révolution</ins>.</p>


<h3>Réflexion et réfraction d'un rayon incident sur une surface</h3>

<p>La surface que je considère ici est une <ins>surface réelle séparant deux milieux homogènes d'indices de réfraction différents</ins>. Si les deux milieux sont transparents, cette surface s'appelle un dioptre.</p> 

<ul class="list">
<!-- A mettre dans la partie /M en vidéo ou texte? -->
<li>Les propriétés optiques de tout milieu homogène sont traduites dans l'indice de réfraction complexe caractérisant le milieu. La partie réelle de l'indice de réfraction décrit comment la lumière (et plus généralement l'onde électromagnétique) se propage dans le milieu. La partie imaginaire de l'indice de réfraction décrit comment la lumière est absorbée dans le milieu. Dans le cas des milieux transparents, la valeur de l'indice de réfraction est donc un nombre réel.</li><br>
<li> Propagation et absorption dépendent de la fréquence $\nu;$ de l'onde électromagnétique incidente (donc de l'énergie  $E_{pho}$ des photons incidents selon la relation $E_{pho}=h\;\nu;$, avec $h$ la constante de Planck de valeur $h=6.62\cdot10^{-34}\,J\,s$ dans le système international d'unité). Ainsi l'ensemble des propriétés optiques se traduisent par l'indice de réfraction qui est une fonction réelle (elle dépend de la fréquence ou de la longueur d'onde dans le vide de l'onde qui se propage) à valeurs complexes (l'indice de réfraction complexe).</li><br>
<li>Le domaine de la lumière visible représente une infime partie du spectre électromagnétique. Dans ce domaine visible, la valeur de l'indice de réfraction varie avec la longueur d'onde, comme me le montre un prisme qui sépare spatialement les différentes composantes colorées d'une lumière blanche incidente. Mais cette variation de l'indice de réfraction dans le visible reste faible, et seule sa valeur moyenne, où ses valeurs à quelques longueurs d'onde précises, sont retenues.</li><br>
<li>Par contre, sur l'ensemble du spectre électromagnétique, l'indice de réfraction (partie réelle comme partie imaginaire qui sont liées) révèle un profil de variation complexe. Ce profil rend compte de l'ensemble des mécanismes physiques d'interaction entre l'onde électromagnétique et la matière, il est bien compris et peut être facilement modélisé.</li>
</ul>

<p>Le rayon lumineux étant une ligne de section nulle, <strong>le voisinage de la surface au point d'impact est toujours une portion de plan</strong> (au premier ordre).</p>

<p>Le <strong>plan d'incidence</strong> est le <ins>plan perpendiculaire à la surface, contenant le rayon incident, et la normale à la surface au point d'impact</ins>.</p> 

<p>Au point d'impact I, <ins>une partie de l'énergie du rayon incident est réfléchie et l'autre est transmise </ins>, conduisant à un rayon réfléchi et un rayon réfracté.</p>

<p><strong>L'énergie transmise</strong> dans le second milieu <ins>se propage sans perte dans un milieu transparent</ins>. Elle <ins>est absorbée dans un milieu opaque</ins><p>

<ul class="list">
<li>L'optique géométrique étudie la direction de propagation de l'énergie (donnée par les rayons lumineux) mais n'étudie pas la répartition de l'énergie entre rayon réfléchi et rayon transmis, ni l'absorption progressive de l'énergie lors de la propagation dans un milieu non totalement transparent ou opaque. Donc tous les éléments et milieux optiques étudiés en optique géométrique seront considérés comme idéalement transparents.</li><br>
<li>Je comprendrai, si je le souhaite, la répartition entre énergie réfléchie et énergie transmise, dans le cadre de l'électromagnétisme appliquée aux ondes électromagnétiques. En particulier, cela dépendra des indices de réfraction des deux milieux de part et d'autre de la surface, de l'angle d'incidence, de certaines caractéristiques de l'onde incidente par rapport au plan d'incidence (modes transverse électrique et transverse magnétique de l'onde incidente). Je comprendrai et maîtriserai tout cela en établissant les équations de Fresnel.</li></ul>

<h3>Le miroir</h3>
<h4>Le miroir plan</h4>
<h4>Le miroir sphérique</h4>

<p> Un <strong>miroir sphérique</strong> est un miroir dont la <ins>surface s'inscrit dans la surface d'une sphère</ins>. Il présente en général une <ins>symétrie de révolution autour de l'axe optique.</ins> Il est <ins>définit par deux points situés sur l'axe optique</ins> :</p>
<ul class="text"> 
<li>Son <strong>sommet S</strong>, <ins>intersection du miroir avec l'axe optique</ins>.</li>
<li>Son <strong>centre C</strong>, qui est le <ins>centre de la sphère</ins> dans laquelle s'inscrit la surface du miroir.</li>
</ul>
<p>Le <strong>rayon de courbure R</strong> est la longueur (non algébrique) du segment de droite.  [S;C].</p>
<p> Dans les calculs, les longueurs sont algébriques, donc j'ai : <strong>$R=|SC|=|CS|$</strong></p>
<h3>Le dioptre</h3>

<h4>Le dioptre sphérique</h4>
<p> Un dioptre sphérique est une surface qui s'inscrit localement sur la surface d'une sphère, et qui sépare deux milieux homogènes et isotropes d'indices de réfraction différents.</p>

<p> L'axe optique

<h4>Le dioptre plan</h4>
<p> Le dioptre plan étant un dioptre sphérique de rayon de courbure infini, les lentilles sphériques épaisses sont généralement classées en :</p-->

<h3>La lentille</h3>
<h4>La lentille épaisse</h4>
<p> Une lentille épaisse sphérique est un système optique composée de deux dioptres sphériques séparant le milieu constitutif de la lentille, centrés sur un même axe de révolution.</p>
<p> Il est défini par 4 points situés sur l'axe optique :
<ul><li> S1 et C1 :  sommet et centre de courbure du premier dioptre, celui que rencontre la lumière incidente</lI>
<li> S2 et C2 :  sommet et centre de courbure du deuxième dioptre, celui que quitte la lumière émergente. </lI></ul>
<p>Ces 4 points définissent 3 longueurs algébriques :</p>
<ul><li> S1C1 et S2C2 les rayons de courbures (algébriques) des deux dioptres.</li>
<li> S1S2 la distance (algébrique) entre les sommets des deux dioptres.</li></ul>
<p>Ces 2 dioptres séparent 3 milieux d'indices de réfraction différents :</p>
<li>n1 : indice de réfraction du milieu de propagation de la lumière incidente.</li>
<li>n2 : indice de réfraction du milieu constitutif de la lentille.</li>
<li>n3, indice de réfraction du milieu de propagation de la lumière émergente.</li></ul>

<h4>La lentille mince</h4>


<h2>L'oeil</h2>
<h3>Anatomie de l'oeil</h3>
<h3>Fonctionnement de l'oeil</h3>
<!-- vision de loin, vision proche : l'oeil au repos et l'oeil accommodant -->
<!-- quand on parle de l'iris et la pupille : dans la partie /M, parler de regarder un objet à travers un tout petit trou fait avec sa main : lien avec les conditions de Gauss-->
<h4>Le phénomène d'accommodation</h4>
<!-- distance maximale de vision distincte et punctum remotum-->
<!-- distance minimale de vision distincte et punctum proximum-->
<h4>L'oeil normal</h4>
<!-- en terme de plage de vision distincte-->
<!-- en terme de champ de vue--> 
<!-- en terme d'acuité visuel-->
<!-- en terme de vision des couleurs-->

<h3>Les défauts de la vision</h3>
<h4>L'oeil hypermétrope</h4>
<h4>L'oeil myope</h4>
<h4>L'oeil astigmate</h4>
<h4>L'oeil presbyte</h4>
<h4>L'oeil daltonien</h4>
<!--les dichromates, les trichromates anormaux-->

<h3>Modéliser simplement l'oeil et sa correction</h3>
<h4>Le cristallin modélisé par une lentille convergente</h4>
<h4>L'oeil modélisé par un dioptre</h4>
<h4>La lunette de vue</h4>
<h4>La lentille de contact</h4>


<h2>Les instruments optiques</h2>
<h3>Caractériser un système optique</h3>
<h4>Caractériser un système</h4>
<h4>Grandeurs d'entrée et de sortie caractérisant un système optique</h4>

<p>Tout système $Syst$ admet des grandeurs d'entrée $E_1, E_2,...E_n$  et fournit des grandeurs de sortie $S_1, S_2,...S_m$.</p>
$$Syst\: :\:E_1, E_2,...E_n\:  \mapsto\:  S_1, S_2,...S_m$$


<TABLE>
	<TR>	<TD><TH ROWSPAN=2></TH>
		<TH COLSPAN=2>Caractérisation OBJET</TH></TD>
	</TR>
	<TR>	<TD><TH>Taille $BC$</TH><TH>Diamètre apparent $\alpha$</TH></TD>
	</TR>
	<TR>	<TH ROWSPAN=2>Caractérisation IMAGE</TH>
	    	<TH>Taille $B'C'$</TH><TD>Grandissement $\gamma$</TD><TD>0.003</TD>
	</TR>
	<TR>	<TH>Diamètre apparent $\alpha'$</TH><TD>1.7</TD><TD>0.002</TD>
	</TR>
</TABLE>

<!-- taille ou diamètre apparent -->
<h3>Les composants standards : l'objectif et l'oculaire</h3>
<h3>L'appareil photo</h3>
<h4>Le capteur photosensible</h4>
<h4>L'objectif, le téléobjectif, le macro-objectif</h4>
<h4>La profondeur de champ</h4>
<h3>La loupe</h3>

<h3>Le microscope</h3>

<p>Le microscope permet de voir des détails invisibles à la simple vision directe, d'un objet de petite taille placé devant lui. 

est un système optique centré, qui donne d'un objet de petite taille placé devant lui






<h3>Les lunettes terrestres et astronomiques</h3>
<!-- parler du viseur -->
<h3>Le télescope</h3>
<h3>L'appareil photo</h3>
<h3>Le colimateur</h3>


<h1>Optique ondulatoire </h1>
