---
title: Les ondes en physique
published: true
routable: true
visible: false
lessons:
    - 
        slug: waves-conceptual-and-learning-patterns-fr
        name: PANORAMA-234 : Les ondes, une vision générale
        order: 1
    -
        slug: waves-2-fr
        name: SITUATION-2 : Les Ondes
        order: 1
    -
        slug: waves-1-situation-fr
        name: SITUATION-1 : les ondes
        order: 1
---

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Colline

---------------------------

### ONDES

### **Les ondes** *en physique*

<br>
[version multilingue : EN , FR , ES](https://m3p2.com/polyglot/temporary-m3p2/waves/n2/waves-introduction/waves-in-physics)
<br>

<!--
# <p style="font-size:70%;text-align: center;">Les ondes en physique</p>
<p style="font-size:75%;text-align: center;">Naissance du concept d'onde</p>
-->

#### Naissance des concepts de champ et d'onde

 * Chacun de nous a déjà lancé un ballon ou jeté un caillou. À chaque instant, ces objets occupent une position bien définie dans l’espace et suivent une trajectoire que nos yeux peuvent suivre. Cette expérience sensible est à la base de notre concept intuitif de **corps matériels** : des objets bien définis, d’extension limitée dans l’espace, qui se déplacent selon les lois de la physique.   
<br>
Mais notre expérience sensible ne se limite pas à ces objets localisés. Chacun de nous a déjà **lancé des cailloux dans l’eau** ou observé les gouttes de pluie tomber à la surface paisible d’un étang.    
<br>
Leurs impacts perturbent la surface de l'eau, créant de **petites vaguelettes circulaires** qui 
*se propagent, se renforcent ou s'amenuisent* lorsqu'elles se croisent, et 
*contournent les obstacles* rencontrés sur leur parcours.  

_image gif animée à faire ou achter : pluie sur l'étang, des goutelettes créent des vaguelettes_
 _qui se superposent et interfèrent._   

*  Ces vaguelettes se traduisent, *à chaque instant et en chaque point* de la surface, par une 
**variation de la hauteur de l'eau** sous la surface.    
<br>
Le physicien parle de **champ** pour décrire une 
*grandeur physique définie en chaque point de espace et à chaque instant.* Ici la 
grandeur physique est la hauteur de l'eau, et l'espace la surface bi-dimensionnelle 
de l'étang.   
<br>

* Lorsque l'*étang est calme*, que sa surface est à l'**équilibre et stable**, la *hauteur* de l'eau sous la surface **varie d'un point à un autre**, mais cette hauteur en chaque point 
**ne varie pas avec le temps**.    
<br>
Le physicien dit que le *champ* de la hauteur de l'eau est **stationnaire**.   
<br>

* Les vaguelettes se traduisent par une variation de la hauteur de l'eau par rapport
à la surface de l'étang au repos. Ces *vaguelettes* sont à la 
*base de notre concept intuitif d’ondes* : des **perturbations d’un champ** qui **se propagent**, 
interfèrent, et sont diffractées.   
<br>
Pour le physicien, l''**onde** apparaît ainsi comme la *partie non stationnaire d'un champ*,
donc l'écart temporaire à la valeur d'équilibre du champ au repos.   
<br>

* Les *vaguelettes* résultent du **déplacement** de molécule d'eau, donc **de matière**.   
<br> 
Lorsqu'une onde caractérise la *perturbation d'un milieu matériel*, le physicien parle 
d'**onde mécanique**.   
<br>

* Les **propriétés des ondes mécaniques**
   *  *Propagation*
   *  *Interférences*
   *  *Diffraction* par un obstacle.
   *  *Réflexion et transmission* à l'interface entre deux milieux différents.
   *  *Transport d’énergie*, mais *pas de matière* sur de grandes distances. 
   **sont retrouvées sur des phénomènes plus subtils** observés dans la nature puis décrits mathématiquement, ou bien d'abord prévus par la théorie physique avant d'être confirmés par l'expérimentation.

<br>

![](waves-interferences-diffraction-2_L1200.jpg)
_Représentation des phénomènes d'interférences et de diffraction._

<br>

#### Des ondes de différents types

* Aujourd’hui, **quatre types d’ondes** ont été observés, depuis les *ondes mécaniques* 
aux ondes *électromagnétiques*, puis des ondes *gravitationnelles* aux ondes *quantiques*. 
Dans l'ordre, ces ondes **correspondent à des niveaux de réalités de plus en plus subtils**, 
en lien avec la vitesse de la lumière c, et modélisés par des théories physiques aux 
mathématiques de plus en plus abstraites.

<br>

![](waves-introduction-n2_L1200.png)
_Quatre type d'ondes en physique, pour décrire des niveaux de réalité de plus en plus subtils et abstraits._

---------

##### **Les ondes mécaniques** *($`v \lt c`$)*

* Ce sont les *plus connues et intuitives*, et elles sont souvent très 
*facile à observer* ou ressentir. Elles correspondent à une **perturbation d’un champ matériel** :
   * *vaguelettes* à la surface de l’eau (champ de hauteur).
   * *sons* qui se propagent dans l’air (champ de pression).
   * *ondes sismiques* dans le sol (champ de déplacement dans la terre).
   * *ondulations* d’un ressort ou d’une corde d'un instrument de musique (champ de déplacement).

* Toutes **ces ondes sont matérielles**, leur vitesse de propagation $`\mathscr{v}`$ est inférieure 
à la vitesse de la lumière $`c`$.

* Nécessitant un milieu matériel, elles *ne peuvent pas voyager dans le vide*.

<br>

--------

##### **Les ondes électromagnétiques** *($`v = c`$)*

* Elles ne résulte pas de la perturbation d'un milieu matériel, mais *sont formées*
  d'un **champ électrique et** d'un **champ magnétique perpendiculaires qui s'auto-entretiennent**.   
  <br>
  Comme il n'existe pas de milieu support des ondes électromagnétiques, elles 
  **peuvent voyager dans le vide**, entre autre le vide interstellaire.

* Ces ondes incluent :
   * les *ondes-radio*
   * les *micro-ondes*
   * les *infra-rouges*
   * la *lumière visible*
   * les *ultra-violets*
   * les *rayons X*
   * les *rayons gamma*

* **Nos yeux perçoivent uniquement** une petite partie de ce spectre, la *lumière visible*.   
  <br>
  Comme **ces ondes** sont de l'**énergie pure** (elles n'ont pas de masse au repos), elles sont 
  *beaucoup plus abstraites*.      
  <br>
  À tout moment, **notre corps est traversé** par des *ondes-radio*, des *ondes-télé*, des *ondes Wifi* qui
transportent de la musique, des images, des paroles d'entrevues, etc. 
**Sans la technologie**, nous n'aurions *aucune connaissance de la plupart de ces ondes*.   
<br>

* La **vitesse des ondes électromagnétiques** est
  toujours *exactement $`c = 299\,792\,458 m\,s^{-1}`$*, constante fondamentale de la nature appelée
  *vitesse de la lumière dans le vide*.   
  <br>
  Ne dépendant donc pas de l'état de mouvement de l'observateur qui mesure cette vitesse, ces ondes
  **défient notre intuition classique** du monde. Elles constituent l'*une des preuves expérimentales* du couplage de l'espace et du temps
  au sein *de l'espace-temps* décrit d'abord par la **relativité restreinte, puis** par la relativité **générale*.   
<br>
![](https://m3p2.com/fr/temporary_ins/waves/n2/overview/linear-electromag-wave-n3_L1200.gif)
![](https://m3p2.com/fr/temporary_ins/waves/n2/overview/elliptic-wave-electromag-wave-n3_L1200.gif)
_Deux états de polarisation différents, rectiligne (haut) et elliptique (bas), d'une onde électromagnétique._   
_Sans attendre la maîtrise du niveau Montagne, la connaissance visuelle de ces états de polarisation
te permettra de comprendre entre autre comment tu peux voir en 3 dimensions un film pourtant projeté
sur les 2 dimensions d'un écran de cinéma._

! *Note* :   
!
! Les **ondes électromagnétiques**, jusqu'à très récemment (2015), étaient la *seule source de toute notre connaissance de l'Univers* :  
!
!  l'astrophysique observe les ondes électromagnétiques issues du *Big Bang*, des *galaxies*, des *étoiles*, 
!  des *planètes*, du *milieu interstellaire*.

---------------


##### **Les ondes gravitationnelles** *($`v = c`$)*

* Contrairement aux ondes électromagnétiques qui voyagent dans l'espace et le temps, les
**ondes gravitationnelles** sont *encore plus abstraites*, elles sont une
**perturbations du champ de courbure de l’espace-temps** lui-même.  
<br>

* L'**espace-temps** est déformé par la présence de matière (ce qui
cause la gravitation) mais, en plus, il **peut vibrer** lors du *passage d'ondes gravitationnelles*
produites lors d'évènements violents dans l'univers.    
Nos sens ne peuvent absolument pas percevoir ces ondes.  
<br>

* Décrites par la relativité générale, elles **voyagent** *à la vitesse de la lumière $`c`$*.

! *Note* :
!
! Prédites avec la relativité générale, mais observées seulement depuis 2015, les 
!  **ondes gravitationnelles** sont à la **base d'une nouvelle astrophysique**, 
!  l'*astrophysique des ondes gravitationnelles*.   
!  <br>
!  Elle observe les **phénomènes violents et massifs** dans l'univers : 
!  rotations rapides avant leur *fusion de trous noirs et étoiles à neutrons*.

------


##### **Les ondes quantiques** *($`v \gt c`$ dans certains cas)*

<br>

*A - Fonction d'onde et mesure*

* Les ondes quantiques sont des **perturbations d’un champ de probabilité**, 
décrit par la **fonction d’onde $`\psi`$**. L'évolution temporelle de ette fonction est
gouvernée par l’équation de Schrödinger, ou des équations plus avancées en théorie quantique des champs
(qui allie et dépasse la relativité restreinte et la mécanique quantique).

* **$`\boldsymbol{\psi}`$** ne décrit pas une onde classique, mais une **amplitude de probabilité** 
de trouver une particule dans un état donné (position, impulsion, spin, etc.). 
La *probabilité elle-même* est proportionnelle à *$`|\boldsymbol{\psi}|^2`$*.   
En ce sens, la fonction quantique **$`\boldsymbol{\psi}`$ décrit la dualité onde-corpuscule**.

* Elle n'est *pas matérielle*, et une de ses particularités est de 
  *comporter une partie imaginaire* qui joue un rôle fondamental.

* Personne ne comprend encore le sens réel de cette onde.   
  Elle est **limitée par la vitesse de la lumière, sauf au moment d'une mesure**
(effondrement de la fonction d'onde) qui est un phénomène non-local, i.e. instantané (donc
avec v > c).   
   Ce **comportement non-local** est *fondamentalement aléatoire* et donc
  *ne permet pas de communiquer* (sinon cela impliquerait l'existence de paradoxes temporels).

![](hydrogenoid-atom-quantum-mechanics-s-p-orbitales.gif)
_Représentation de la probabilité de présence électronique (bleu) dans les orbitales s (centre) et p (8 lobes)_
_d'un atome hydrogénoïde, avec au centre et très grossi (rouge) le noyau atomique._

*B - Fonction d'onde et particules intriquées*

* L'**intrication quantique** correspond à un *niveau de réalité encore plus abstrait*.    
  <br>
  Le **lien quantique entre deux particules intriquées** (qui ont interagi ensemble dans le passé) est
une connexion absolument extraordinaire qui *existe hors de l'espace et du temps*.   
<br>
Ce lien :
   * est *indétectable* par aucune technologie connue
   * *ne diminue pas* avec la distance
   * n'est *pas arrêté par les obstacles* quels qu'ils soient
   * a un *comportement instantané*, donc *non local*.
   
*  **Fondamentalement non-local**, ce lien est à la *base de la téléportation quantique*.   
   <br>
   Lorsque l'état d'une **particule est téléporté d'un endroit A à un endroit B**, 
   l'*information se propage instantanément* de A à B, et ne passe pas par l'espace physique
  entre A et B (c'est pourquoi on dit que ce lien existe hors de l'espace et du temps).   
  <br>
  La **compréhension conceptuelle de ce phénomène** est *une des grandes questions ouvertes*
  de l'interprétation de la physique quantique, elle est le siège de grands débats entre les physiciens.

<br>

*C - Fonction d'onde et prévisions*

* La **formulation mathématique de la mécanique quantique** est 
   * parfaitement *bien comprise*
   * parfaitement *bien vérifiée expérimentalement*   

   C'est son interprétation conceptuelle qui est matière à controverse.

* L'**action instantanée de l'intrication quantique** est *aléatoire*
  et *ne permet pas de communiquer*.   
  <br>
  Cependant, la **téléportation quantique permet de communiquer** car elle
comporte deux étapes :
   * une **première étape** *véhiculée par l'intrication*, 
   * une **deuxième étape** *limitée par la vitesse de la lumière*.   

   Par conséquent, la **téléportation complète** est *limitée par la vitesse de lumière*.


!! *Pour aller au-delà* :
!!
!! Le cadre de la théorie quantique des champs, qui allie et dépasse la relativité restreinte
!! et la mécanique quantique non relativiste, a connu de nombreux succès, citons entre autre
!! la prédiction précédant la découverte de plusieurs particules telles que le quark top (1995) et le boson de Higgs (2011).
!!
!! Il reste qu'elle n'explique pas les phénomènes prévues par la relativité générale (dilatation
!! des durées dans un champ de gravitation, trous noirs et ondes gravitationnelles, vérifiées 
!! expérimentalement ou observés).
!!
!! Ainsi notre compréhension de tous les phénomènes observés dans l'Univers nécessite deux théories
!! distinctes, relativité génerale et théorie quantique des champs, qui semblent
!! inconsiliables dans leurs fondements même.
!!
!! Les physiciens poursuivent la recherche d'un principe unique, qui donnerait une théorie physique
!! unique, dont la relativité générale et la théorie quantique des champs ne seraient que des approximations,
!! et qui décrirait et prédirait statistiquement l'ensemble des phénomènes à toutes les échelles de la Nature.




