---
title: Les ondes
published: true
routable: true
visible: false
lessons:
    -
      slug: waves-2
      name: LINÉAIRE-2 : Les Ondes
      order: 2
    -
      slug: panorama-waves-23
      name: PANORAMA-23 : Les ondes
      order: 1
    -
      slug: interdisciplinary-propagation-absorption-amplification-2
      name: CROSS-2 : Propagation, absorption, amplification
      order: 1
---

<!--Commandes Latex spécifiques
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
-->

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-1_L1200.jpg)<details>
<summary>Etape 1 : Appel à idées</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Randonnée Colline

---------------------------

### PHYSIQUE DES ONDES

### **Les ondes**<br>*et les phénomènes ondulatoires*   

<br><br>

RÉSUMÉ
: ---
 *Les différentes natures d'onde*    
  
  __Onde mécanique__ : perturbation d'un milieu matériel qui se propage de proche en proche à travers le milieu.   
    _exemples : le son qui se prppage dans l'eau, les vaguelettes suite au lancé d'un caillou dans l'eau._   
  __Onde électromagnétique__ : perturbation d'un champ électrique et d'un champ magnétique initialement statiques ou nuls, créant 
   une onde électromagnétique qui se propage dans le vide à la vitesse de la lumière.   
    _exemples : la lumière visible, l'infrarouge et l'ultraviolet, les ondes radios, les rayons X et gamma, sont des ondes électromagnétiques._   
  __Onde gravitationnelle__ : perturbation de la géométrie de l'espace-temps, qui se propage à la vitesse de la lumière à travers l'espace-temps.   
    _exemple : les ondes gravitationnelles créées par la rotation rapide autour de leur centre de gravité commun de deux trous noirs,_
    _juste avant leur collision._  

  -----------------------
  
    *Les ondes les plus simples*

  __L'onde périodique__ :   
  __L'onde harmonique__ :   
  __L'onde plane__ :  en tout point de l'espace, l'énergie de l'onde se propage dans une même direction.   
  __L'onde sphérique__ : en tout point de l'espace, l'énergie de l'onde se propage selon un rayon issu d'un unique point, source de l'onde.

  -------------------------
  
  __La puissance de l'onde à l'émission__ : énergie émise par seconde par la source de l'onde.   
  __L'intensité de l'onde incidente sur une surface__ : énergie de l'onde par unité de temps et par unité d'aire de la surface d'orientation précisée.
  
  -------------------------

  *Les phénomènes ondulatoires*   

  __Le propagation__ : transmission de l'onde à travers l'espace à une vitesse de propagation qui dépend du milieu (onde mécanique) ou
  à la vitesse constante de la lumière (onde électromagnétique et onde gravitationnelle).   
  __L'absorption__ : l'énergie propagée par l'onde est transférée au milieu de propagation.   
  __L'atténuation__ : L'intensité de l'onde diminue lors de sa propagation, soit par absorption, 
  soit par répartition de la puissance de l'onde sur des surfaces de plus en plus grandes (onde sphérique).   
  __La réflexion__ :  L'onde change de direction et de sens de propagation après interception par une surface réfléchissante.   
  __La réfraction__ : L'onde plane change de direction en traversant l'interface entre deux milieux différents.
  _(Les angles d'incidence et de réfraction suivent la loi de Snell-Descartes)_.   
  __milieu dispersif__ : milieu dans lequel la vitesse de propagation de l'onde sinusoîdale varie avec sa fréquence.   
  __La dispersion__ : phénomène par lequel les diverses composantes sinusoîdales d'une onde, initialement superposées au sein d'un faisceau unique,  
  se séparent spatialement pour se propager dans des directions différentes.   
  __Les interférences__ : lorsque deux ondes se superposent, l'amplitude de l'onde résultante n'est pas la somme
  des amplitudes des ondes individuelles.    
  __La diffraction__ : lorsque la libre propagation d'une onde plane est perturbée par un obstacle, 
  l'onde s'étale dans plusieurs directions.    
  __Le décalage Doppler__ : décalage observé entre la mesure de la durée de la pertubation
  ou de sa fréquence (onde sinusoîdale), effectuée au niveau de la source d'émission 
  et au niveau du capteur qui détecte l'onde.     
  __Les battements__ : la superposition de deux ondes sinusoîdales de fréquences proches $`\nu_1\approx\nu_2`$
  se traduit par une onde de basse fréquence $`|\,\nu_1 - \nu_2\,|`$ facilement détectable, modulée à 
  haute fréquence.
 
  -------------------------

  *Les phénomènes propres aux ondes, sans équivalents corpusculaires*

  Les interférences et la diffraction permettent d'identifier la nature ondulatoire de la cause de ces phénomènes.

  -------------------------



  *L'onde stationnaire*

  La perturbation varie selon la position dans l'espace, mais elle ne se propage pas. Elle résulte de la superposition de deux ondes progressives


<br><br>

![](titre-ondes_L1200.jpg)

![](sous-titre-ondes-mecaniques_L1200.jpg)

#### Qu'est-ce qu'une onde mécanique ?

* Dans l'expression **ondes mécaniques**, le terme mécanique fait référence à un *milieu matériel*.

* Un **milieu matériel** est composé de *particules matérielles* (atomes, molécules) qui interagissent entre elles. 
  Ce milieu peut être solide, liquide ou gazeux.

* Un **milieu à l'équilibre** signifie que chaque particule occupe une position d'*équilibre stable* 
  où les *forces* qui s'exercent sur elle *s'annulent*.

* Une **perturbation** se produit lorsqu'une *particule* est *temporairement déplacée* 
  de sa position d'équilibre.

   * **Après la perturbation**, la stabilité de l'équilibre signifie que les forces agissent pour 
     ramener la particule à sa position d'équilibre, créant une *force de rappel*.
   * À cause de son *inertie*, la particule dépasse souvent sa position d'équilibre 
     avant d'être ramenée. Cela crée un **mouvement d'oscillation** qui s'atténue progressivement.

* La **particule déplacée** perturbe l'équilibre des particules voisines, devenant 
  ainsi elle-même une **source de perturbation**. Son *mouvement d'oscillation se transmet* 
  aux particules voisines avec un *léger retard* dû à leur inertie et une *légère atténuation*.

* Ainsi, la **perturbation se propage** :
   * *dans l'espace*, d'une particule à l'autre.
   * *dans le temps*, en raison du retard de mouvement d'une particule à ses voisines.

* Une **onde mécanique** est l'expression qui décrit le phénomène de *propagation 
  d'une perturbation* dans un *milieu matériel*.


#### Pourquoi se limiter d'abord aux ondes mécaniques ?

* Des **phénomènes observés dans ondes mécaniques**, comme la diffraction et les interférences,
 sont **communs à tout type d'ondes** et **propres aux ondes**, y compris celles 
  qui sont moins intuitives comme les ondes électromagnétiques, gravitationnelles, ou de probabilité.

   * Les *ondes électromagnétiques* se propagent dans le vide, sans milieu matériel.
   * Les *ondes gravitationnelles* sont des perturbations de l'espace-temps lui-même.
   * Les *ondes de probabilité* décrivent la propagation de la probabilité de présence 
     d'une particule, matériel comme l'électron ou non matériel comme le photon, dans un état donné.

* Dans un premier temps,   
les **ondes mécanique, plus intuitives**, permettent de *mieux s'approprier les phénomènes ondulatoires* 
(diffraction, interférences).    
Puis,    
**L'observation de ces phénomènes** permet d'*identifier la nature ondulatoire* de l'origine de ces phénomènes.


#### Que transporte une onde mécanique ?

* Une *onde transporte* de l'**énergie** et de la **quantité de mouvement** sur 
  de longues distances, car elle met en mouvement de la matière dans le milieu perturbé.   
_Par exemple, un bouchon flottant sur l'eau se met à osciller verticalement lorsqu'il_
_est atteint par des vaguelettes, même s'il est loin du point d'impact._

* Cependant l'*onde ne transporte* **pas de matière**, car les particules oscillent 
  simplement autour de leur position d'équilibre.   
 _Le bouchon n'est pas transporté par la vague sur de longues distances, il oscille sur place._


#### Quels sont les acteurs d'une onde mécanique ?

* Une onde mécanique implique généralement **trois acteurs** avec des *rôles distincts* : la source, le milieu et le capteur.
   * La **source S** impose la *perturbation* au milieu matériel.
   * Le **milieu matériel** *propage* cette perturbation à une *vitesse dépendant du milieu*, vitesse mesurée par un observateur M immobile dans ce milieu.
   * Le **capteur C** détecte la perturbation.


#### Qu'est-ce qui détermine la vitesse de propagation ?

à faire, dépend du milieu.

Jusqu'à quel niveau de détail aller à ce niveau 2? 



#### Qu'est-ce qu'un milieu homogène et isotrope ?

à faire


<br><br>

![](sous-titre-ondes-electromagnetiques_L1200.jpg)

à faire


<br><br>

![](titres_ondes-ecrire-caracteriser_L1200.jpg)

![](sous-titre-ondes-ecriture-mathematique_L1200.jpg)


#### Comment décrire mathématiquement une perturbation ?

* A l'**échelle atomique**, les particules du milieu matériel sont les atomes. 
  La *taille caractéristique* de cette échelle est l'*angström*, le dixième de nanomètre.  
  Les **atomes sont disjoints**, même s'ils sont liés dans les solides et liquides.   
<br>
La *plupart des observations* se font à une **échelle bien plus grande**.   
_Par exemple, la plus petite taille visible à l'œil nu est d'environ un dixième_
_de millimètre, soit un million de fois plus grande qu'un angström._    
<br>
Ainsi dans la description physique d'une onde, on appelle **"particule de matière"** 
le *plus petit volume observable* à l'échelle considérée. À moins de travailler 
à l'échelle atomique, ces volumes qualifiés d'élémentaires se touchent, et donc
les "particules" sont **jointives**.    
<br>
La *perturbation* est alors décrite par une **fonction mathématique $`U`$ continue** 
dans l'espace et le temps :   
<br>
$`\large U = \;`$**$`\large\boldsymbol{\mathbf{U\,(\,x,\,y,\,z,\,t\,)}}`$**   
<br>
&nbsp;&nbsp;&nbsp;&nbsp;où $`(x,y,z)`$ sont des coordonnées spatiales.

!!!! *Attention :* Les *coordonnées spatiales* indiquent la *position d'équilibre* de la particule,    
!!!! et non sa position perturbée par l'onde au cours du temps.


#### Peut-on simplifier cette description mathématique?

* L'**univers** présente **trois dimensions spatiales**. Dans un système de coordonnées spatiales,
  tout point peut être précisé par la donnée de trois nombres réels $`(x,y,z)`$.

* Une **onde matérielle** se propage nécessairement dans un *volume limité*, et présente une certaine *forme*.


##### Onde unidimensionnelle

* L'**onde unidimensionnelle** est une *idéalisation*.

<br>
![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/wave-square_L1000.gif)   
![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/wavepacket_non-dispersive-v2_L1000.gif)   
![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/1D-corde-vibrante-f1-harm24_v2_L1000.gif)   
_figures a, b, c : Exemples d'onde unidimensionnelle._


* Parfois **à l'échelle d'observation**, une *forme* apparaît comme une **ligne** dont la section droite est invisible.   
  <br>
  Dans ce cas, les deux dimensions spatiale de la section peuvent être négligées. 
  <br>
  Un *système adapté de coordonnées* spatiales permet alors de repérer tout
  point sur la ligne avec **seulement une coordonnée**. La fonction prend alors la forme :   
  <br>
  $`\large U = \;`$**$`\large\boldsymbol{\mathbf{U\,(\,x,\,t\,)}}`$**

<br>
##### Onde bidimensionnelle

* L'**onde bidimensionnelle** est une *idéalisation*.

<br>
![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/different-waves-2.gif)   
_figures d, e, f, g : exemples d'onde bidimensionnelle._


* Parfois **à l'échelle d'observation**, une *forme* apparaît comme une **surface** dont l'épaisseur est invisible.   
  <br>
  Dans ce cas, la dimension spatiale de l'épaisseur peut être négligée. 
  <br>
  Un *système adapté de coordonnées* spatiales permet alors de repérer tout
  point de la surface avec **seulement deux coordonnées**. La fonction prend alors la forme :   
  <br>
  $`\large U = \;`$**$`\large\boldsymbol{\mathbf{U\,(\,x,\,y,\,t\,)}}`$**

<br>

#### Comment décrire physiquement une perturbation ?

##### Perturbation mécanique

* La *perturbation* d'une onde mécanique correspond, en chaque point de l'espace, 
  à un **déplacement de matière** *par rapport à sa position d'équilibre*. Ce déplacement 
  peut être décrit par :
   * une *fonction scalaire $`U`$* qui donne une distance ou **longueur**.
   * une *fonction vectorielle $`\vec{U}`$* qui donne un vecteur avec une **norme** 
     représentant la **longueur** et une **direction** indiquant le sens du déplacement.

* L'aspect oscillatoire du déplacement par rapport à l'équilibre peut entraîner des 
  variations de **densité volumique** dans le milieu de propagation _(comme pour le son dans l'air)_.
  Dans ce cas :
    *la fonction $`U`$* est scalaire et représente une **densité volumique**.

* D'*autres grandeurs physiques* peuvent être utilisées si elles permettent la *mesure de l'onde*.


##### Perturbation électromagnétique

à faire

décrire,  
montrer les deux figures classiques d'une onde électromag   
une moparisation recatiligne, l'autre élliptique.
oeil non sensible à polarisation
technique ou i,tervient polarisation (ciné 3D)

figures en attente

![](linear-electromag-wave-n3_L1200.gif)   

![](elliptic-wave-electromag-wave-n3_L1200.gif)  



#### Comment décrire mathématiquement la propagation ?


##### Pour une analogie : déplacement d'un corpuscule sur sa trajectoire

* Un **corpuscule** associé à un **point $`P`$** de l'espace _(le guidon dun vélo sur la figure)_ 
  se déplace à *vitesse constante* sur une *trajectoire rectiligne*.  
  _Par exemple, sur la fugure $`P`$ représente la position du guidon du vélo._   
  <br>
  ! *Rappel :*
  ! Un mouvement rectiligne à vitesse constante est un *mouvement rectiligne uniforme*.

  *A chaque instant $`t`$*, la **position** du corpuscule est repéré par sa 
  **coordonnée $`x_P(t)`$** sur l'axe x parallèle à la trajectoire.    
  _Sur les deux figures suivantes, l'axe x représente la route, orientée positivement de la gauche vers la droite._   
  
* Le corpuscule étant **localisé** en un point de l'espace, l'**intérêt pour l'étude du mouvement** 
  est de connaître *variation de la coordonnée $`x_P`$  en fonction du temps*.


   ##### *1 - Le corpuscule se déplace dans le sens positif*

 ![](meca-wave-point-propagation-vitesse-1_L1200.gif)   

* Si le *déplacement du corpuscule* va **dans le sens positif** de l'axe $`x`$, alors :     
  <br>
  **$`\Large{\mathbf{x_P(t) = x_{P,\,0} + v_P\,t}}`$**   
  <br>
  &nbsp;&nbsp;&nbsp;&nbsp;où $`x_{P,\,0}`$ est $`x_P`$ à  $`t=0`$.

* Entre deux instants $`t_1\text{ et }t_2`$ quelconques, la relation précédente permet d'écrire   
  <br>
  $`x_P(t_2)-v_P\,t_2 = x_P(t_1)-v_P\,t_1`$.   
  <br>
  Ces instants étant quelconques, cette relation $`x_P- v_P\,t`$ garde une valeur constante 
  *sur toute la trajectoire du corpuscule* :   
  <br>
  *$`\large{\mathbf{x_P(t)-v_P\,t = \text{constante}}}`$*   
  <br>
  Cette relation n'est pas utilisée car elle est *non pertinente pour* décrire le mouvement d'*un corpuscule*.
  En effet, celui-ci étant localisé, seule importe la position $`x_P`$ à tout instant $`t`$.

   ##### *2 - Le corpuscule se déplace dans le sens négatif*

 ![](meca-wave-point-propagation-vitesse-2_L1200.gif)
 
* Si le *déplacement du corpuscule* va **dans le sens négatif** de l'axe $`x`$, alors :   
  <br>
  **$`\Large{\mathbf{x_P(t) = x_{P,\,0} - v_P\,t}}`$**   
  <br>
  &nbsp;&nbsp;&nbsp;&nbsp;où $`x_{P,\,0}`$ est $`x_P`$ à $`t=0`$.

* Comme pour le cas précédent, tu pourrais en déduire    
  <br>
  *$`\large{\mathbf{x_P(t)+v_P\,t = \text{constante}}}`$*   
  <br>
  bien que cela une *expression peu utile* dans le cas d'un corpuscule.

<br>

##### Propagation d'une onde non périodique selon un rayon

* Dans un milieu homogène et isotrope, une **onde non périodique** d se propage à *vitesse constante $`v`$* selon 
  des *rayons rectilignes*.   
  <br>
  Selon un rayon, *à chaque instant $`t`$* la perturbation est définie par son **profil $`U(x,t)`$** considéré stable.

* Observe un **trait caractéristique** facilement repérable du profil, par exemple sa *valeur maximale $`U_{max}(t)`$*.   
  <br>
  *A chaque instant $`t`$*, la position de ce **trait** du profil est repéré par sa 
  **coordonnée $`x_{U_{max}}(t)`$** sur l'axe x, représentant le rayon orienté par le choix d'un sens positif.  
  _Sur les deux figures suivantes, l'axe x représente un rayon, orienté positivement de la gauche vers la droite._   
  <br>
  Tu peux alors exprimer la *variation de la coordonnée $`x_{U_{max}}`$ en fonction du temps*.

! *Note importante* :
! * Si une seule onde est considérée, le sens positif choisi sur le rayon est en général le sens de propagation de l'énergie.
! 
! * Etudie maintenant la *superposition de deux ondes* dont la *propagation de l'énergie* suit un *même rayon* (une même droite) mais
! en *sens inverses*. Pour les calculs tu es amené à prendre une *même orientation pour les deux ondes* pour définir
! l'*axe de propagation commun*.<br>
!  <br>
!  Dans ce cas l'*une des ondes* se propagera dans le *sens positif*, et *l'autre* dans le *sens négatif*.

   ##### *1 - L'onde se propage dans le sens positif*
 
 ![](meca-wave-point-propagation-vitesse-3_L1200.gif)
 
* A terminer
 
   ##### *2 - L'onde se propage dans le sens négatif*
 
 ![](meca-wave-point-propagation-vitesse-4_L1200.gif)
 
* A terminer
 
 

##### Propagation d'une onde périodique selon un rayon

* A décrire
 
   ##### *1 - L'onde se propage dans le sens positif*
 
  ![](meca-wave-point-propagation-vitesse-5_L1200.gif)

* A terminer
 
   ##### *2 - L'onde se propage dans le sens négatif*
 
  ![](meca-wave-point-propagation-vitesse-6_L1200.gif)

* A terminer

##### Synthèse

* A faire
 
 <br><br>
 
![](sous-titre-ondes-caracterisation_L1200.jpg)
 
 
#### Quelle différence entre onde et signal ?

* une **onde** est un *phénomène naturel* de *propagation dans l'espace et le temps*.

* un **signal** est une *codage temporel intentionnelle d'information*, qui *utilise une onde pour se transmettre* d'un point à un autre de l'espace.

!! <details markdown=1>
!! <summary>Pour aller plus loin : signal analogique ou numérique</summary>
!!
!! * Un *signal* est *analogique* si il est *mesurable à tout instant* et peut prendre 
!! comme *valeur tout nombre réel*.<br>
!!
!! * Un *signal* est *numérique* est un signal *discontinu* (discret) qui ne peut prendre 
!! qu'un *nombre fini de valeurs*, par exemple soit 0 soit 1 pour un signal binaire.
!! </details markdown=1>

<!--Texte ci-dessus pas convainquant. A retravailler...
!! Cette définition intuitive est toutefois incomplète. <br>
!! Mathématiquement, la fonction représentative est une *fonction dérivable* (et donc continue) 
!! définie de $`mathbb{R}`$ (représentant le temps) dans $`mathbb{R}`$ (représentant la 
!! grandeur physique codant l'information).

!! Cette définition intuitive est toutefois incomplète. <br>
!! Mathématiquement, la fonction représentative est une *fonction non dérivable* à valeurs 
!! discontinues (discrètes).
-------------->

------------

<br>


#### Qu'est-ce qu'une Onde Sinusoïdale ?

!!!!! *Terminologie :*
!!!!!
!!!!! sont *équivalentes* les expressions suivantes :   
!!!!! * *onde sinusoïdale*   
!!!!! * *onde harmonique*
!!!!!
!!!!! et dans un milieu homogène et isotrope, plutôt réservé aux ondes électromagnétiques (et donc lumineuses) : 
!!!!!
!!!!! * *onde monochromatique*

##### Point de vue de la source ou d'un capteur.

Figure à faire (fonction de t)

* La *source* ou le *capteur* d'une onde est *localisé en un point*
donné de l'espace, l'**onde** est alors représentée alors par une simple **fonction dépendant du temps : $`\mathbf{U(t)}`$**.

* L'**onde sinusoîdale** est une onde dont la *dépendance temporelle* est une *fonction sinusoïdale*.

* Mathématiquement les fonctions **sinus et cosinus** possèdent le *même profil* sinusoïdale, mais *décalé d'un quart de période*.
  En effet $`\forall \theta \in \mathbb{R}`$ :   
  <br>
  **$`\boldsymbol{\mathbf{sin\left(\theta + \dfrac{\pi}{2}\right)}}`$** 
   $`\,= sin \,\theta\;cos\dfrac{\pi}{2} + sin\dfrac{\pi}{2} \; cos \,\theta
   =  sin \theta \times 0 \,+\, 1\times cos \theta`$
   **$`\boldsymbol{\mathbf{\,= cos \,\theta}}`$**   
   <br>
   Ainsi la représentation d'une **onde sinusoïdale** est *soit une fonction sinus, soit par une fonction cosinus*.   
  <br>
  figure à faire   
   <br>
   Choisis par exemple la fonction cosinus.    
   L'**écriture générale** d'une onde sinusoïdale est :   
   <br>
   **$`\boldsymbol{\mathbf{\large{ U(t) = A\cdot cos\,(\,\omega t + \varphi_0)}}}\quad`$**   
   <br>
   avec,   
   * *$`\mathbf{U(t)}`$* : **élongation** à l'instant $`t`$
   * *$`\mathbf{A}`$* avec **$`\mathbf{A>0}`$** : **amplitude**, valeur maximale de la grandeur physique décrivant l'onde sinusïdale.
   * *$`\boldsymbol{\mathbf{\omega t - \varphi_0}}`$* : **phase** de l'onde à l'instant $`t`$, en radian *$`\mathbf{(rad)}`$*      
   * *$`\boldsymbol{\omega}`$* : **pulsation** de l'onde, en radian par seconde *$`\mathbf{(rad.s^{-1})}`$*
   * *$`\boldsymbol{\varphi_0}`$* : **phase à l'origine** de l'axe du temp, donc à **$`\mathbf{t=0}`$**, en radian *$`\mathbf{(rad)}`$*    
   
!!!! *Attention : radian* versus *degré*
!!!!
!!!! Au niveau Plaine :
!!!! * les angles étaient exprimées en degré.   
!!!! _Parcourir un cercle complet représente un angle de $`360°`$._
!!!! * le nombre $`\pi`$ est défini comme le rapport de la circonférence $`C`$ d'un cercle par son diamètre $`D`$,
!!!!   et son encadrement calculé donne la valeur approchée $`\pi\approx 3,14`$.
!!!!
!!!! À ce niveaux Colline :
!!!! * la *définition mathématique d'un angle* est introduite (voir le rappel).
!!!!   Un angle s'exprime comme le *rapport de la longueur d'un arc de cercle par le rayon* du cercle.
!!!! *  Dans cette définition, l'unité de mesure d'un angle est le *radian*.
!!!! *  Le radian est l'*unité angulaire du système internationale de mesure* (SI).
!!!!
!!!! Aux niveaux Colline et supérieur :
!!!! * Dans des présentations grand public, la mesure des angles sera toujours donnée en degré.   
!!!! Mais :   
!!!! * Dans les *expressions mathématiques* faisant apparaître des *angles>*, ceux-ci sont *toujours exprimés en radian*.
!!!! _sinon doit intervenir la constante de conversion des radians vers les degrés : $`180\,/\,\pi`$_
!!!!
!!!! *Attention* à une *grande cause d'erreur* lors d'applications numériques.   
!!!! *Toujours configurer* la calculatrice ou le logiciel pour qu'il exprime *les angles dans l'unité souhaitée* (radian ou degré).
!!!!
!!!! _L'erreur fréquente est d'utiliser les fonctions trigonométriques d'une calculatrice qui prend (fonctions sin, cos, tg)_ 
!!!! _ou donne (fonctions arcsin, arccos, arctg)_
!!!! _la valeur de l'angle en degré, alors que nous pensons les angles en radian._
   
! <details markdown=1>
! <summary>
! Rappel : définition d'un angle et d'un angle solide
! </summary>
! A faire;
! </details>

##### Point de vue du milieu de propagation

* *A tout instant $`t`$*, la perturbation du milieu prend des valeurs différentes en différents points de l'espace.
  L'onde est représentée par
  **fonction dépendant de coordonnées spatiales et du temps :  $`\mathbf{U\,(x,y,z,t)}`$**.

* L'espace ayant trois dimensions, définir l'onde sinusoïdale nécessite de *préciser 
 la forme spatiale* de l'onde.
 <br>
Dans un **milieu homogène et isotrope, trois formes simples d'onde** se propageant librement se distinguent, l'*onde unidimensionnelle*,
 l'*onde plane* (2D et 3D) et l'*onde sphérique* (3D) ou circulaire (2D).

   ##### *L'onde unidimensionnelle (1D)*
   
  Figure à faire (, pour tout t, fonction de x)
   
* L'espace ayant trois dimensions, l'**onde unidimensionnelle** est une idéalisation qui décrit une
  perturbation se propageant librement sur une *ligne* infinie ou fermée dont la *section droite est négligée*.   
  !!! *Exemple d'une unidimensionnelle :*   
  !!! Une perturbation qui se propage le long d'une corde tendue très longue de façon
  !!! que les ondes réflechies sur les extrémités de la corde ne parviennent pas dans le champ observé
  !!! durant la durée de l'observation.  
  !!! cette perturbation peut être :
  !!! * une vibration le long d'une corde.
  !!! * une différence de potentielle le long d'une lignbe électrique.

* En tout point de coordonnée spatiale $`x`$ et à tout instant $`t`$, l'onde sinusoïdale s'écrit alors :   
  <br>
  **$`\boldsymbol{\mathbf{\large{ U(t) = A\cdot cos\,(\,\omega t \pm k\,x + \varphi_0)}}}\quad`$**,   
  <br<
  avec :
   * *$`\mathbf{U(t)}`$* : **élongation** à l'instant $`t`$
   * *$`\mathbf{A}`$* avec **$`\mathbf{A>0}`$** : **amplitude**, valeur maximale de la grandeur physique décrivant l'onde sinusïdale.
   * *$`\boldsymbol{\mathbf{k\,x \pm \omega t + \varphi_0}}`$* : **phase** de l'onde en $`x`$ et à l'instant $`t`$, en radian *$`\mathbf{(rad)}`$*      
   * *$`\boldsymbol{\omega}`$* : **pulsation** de l'onde, en radian par seconde *$`\mathbf{(rad.s^{-1})}`$*
   * *$`\mathbf{k}`$* : **nombre d'onde**, en radian par mètre *$`\mathbf{(rad.m^{-1})}`$*
   * *$`\boldsymbol{\varphi_0}`$* : **phase à la double origine** de l'axe du temp et de l'axe spatiale, donc à **$`\mathbf{t = 0\text{ et }x = 0}`$**, en radian *$`\mathbf{(rad)}`$*    
   et *$`\pm`$* prend le signe :   
   * **$`\quad -`$** si l'onde se propage *vers les $`x`$ croissants*,   
   * **$`\quad +`$** si l'onde se propage *vers les $`x`$ décroissants* 






   ##### *L'onde plane (2D ou 3D)*
   
![](plane-waves-2_L1200.gif)
  



   <br>
   

<!--

  $`\large{U(t) = A

* Une **onde harmonique** est la décomposition de l'onde en un *plus petit motif qui se répète* de façon jointive.   
 
$`
     
  *  Une **OPPH** se propageant *en direction et sens* d'un *vecteur unitaire $`\vec{n}`$* 
     s'écrit :  
     <br>
     **$`\large{\boldsymbol{\mathbf{U(\vec{r},t) = A \cdot \cos(\, \omega t\;\mathbf{-}\;\vec{k}\cdot\vec{r}  + \varphi)}}}`$**,   
     <br>
     avec *$`\mathbf{\vec{k} = k\,\vec{n}}`$* et :   
     * *$`\mathbf{U(\vec{r}, t)}`$* : **élongation** en $`\vec{r}`$ et $`t`$
     * *$`\mathbf{A}`$* : **amplitude** = élongation maximum
     * *$`\boldsymbol{\mathbf{\omega t - \vec{k}\cdot\vec{r} + \varphi}}`$* : **phase** en $`\vec{r}`$ et $`t`$
     * *$`\boldsymbol{\mathbf{\varphi}}`$* : **phase à l'origine**,   
       à l'origine du système de coordonnées, $`\vec{r}=\vec{0}`$, et à l'instant $`t=0`$ origine de l'axe des temps.   
     <br>
  * **Propriété fondamentale** de l'onde : propriété *temporelle*, décrite par différentes *grandeurs physiques équivalentes* qui sont :   
     * **$`\mathbf{T}`$** la *période* temporelle, d'unité S.I. **$`(s)`$**.
     * **$`\boldsymbol{\mathbf{\nu}}`$** la *fréquence* temporelle, d'unité S.I. **$`(Hz = s^{-1})`$**
     * **$`\boldsymbol{\mathbf{\omega}}`$** la *pulsation* temporelle, d'unité S.I. **$`(rad\,s^{-1})`$**
     <br>
     telles que :   
     <br>
     **$`\large{\boldsymbol{\mathbf{\omega = 2\pi\,\nu = \dfrac{2\pi}{T}}}}`$**   
     <br>
  * **propriété du milieu** vis à vis de l'onde :   
     * **$`\boldsymbol{\mathscr{v}}`$** la **célérité** ou *vitesse de propagation* de 
       l'onde dans le milieu, d'unité S.I. **$`(m\,s^{-1})`$**

     * Souvent, la *célérité* **$`\boldsymbol{\mathbf{\mathscr{v}(\nu)}}`$** *dépend de la fréquence* 
       temporelle $`\mathscr{\nu}`$ de l'onde. Le **milieu** est alors dit **dispersif**.    
       <br>
       Le milieu est dit non dispersif dans le cas contraire.   
       <br>
       En général, un milieu est dispersif, mais il peut être non dispersif dans un
       domaine de fréquence d'intérêt.   
       <br>
       
      
  * **Propriété de l'onde dépendante du milieu** de propagation, propriété *spatiale*, décrite 
   par différentes *grandeurs physiques équivalentes* qui sont :   
   * **$`\boldsymbol{\mathbf{\lambda}}`$** la *longueur d'onde*   
     ou périodicité spatiale dans la direction de la propagation, d'unité S.I. **$`(m)`$**
   * **$`\mathbf{\overrightarrow{k}}`$** le *vecteur d'onde* qui s'étend en direction et sens de la propagation.   
   * **k** le *nombre d'onde* ou norme du vecteur d'onde, d'unité S.I. **$`(rad\,m^{-1})`$**   
   <br>
   telles que :   
   **$`\mathbf{\vec{k}=k \,\vec{n}}`$** où *$`\mathbf{\vec{n}}`$* 
   est le *vecteur unitaire* pointant en *direction et sens de propagation* de l'onde.   
   <br>
   **$`\large{\boldsymbol{\mathbf{k = \dfrac{2\pi}{\lambda}}}}`$**
     

  * *Relations entre les propriétés* temporelles, spatiales et du milieu :   
    <br>
    **$`\large{\boldsymbol{\mathbf{k = \dfrac{2\pi}{\lambda} = \dfrac{2\pi}{\mathscr{v} T} = \dfrac{2\pi\,\nu}{T} = \dfrac{\omega}{\mathscr{v}}}}}`$**   
    <br>
    !!!! *Attention* 
    !!!!
    !!!! Parfois dans la littérature, le terme *nombre d'onde* est défini par $`k = 1\,/\,\lambda`$.    
    !!!! Il diffère d'un facteur $`2\pi`$ de la définition ici donnée.   
  <br>
  * Cas d'une *onde unidimensionnelle* :    
    <br>
    **$`\boldsymbol{\mathbf{U(\vec{r}, t) = A \cdot cos(\omega t - kx  + \varphi)}}`$**

  * Une OPPH peut aussi s'écrire en utilisant la fonction sinus. Nous avons alors, pour une :   
    OPPH 1D :   
    $`U(\vec{r}, t) = A\cdot \sin(\omega t  - kx  + \varphi)`$   
    OPPH 2D ou 3D :   
    $`U(\vec{r}, t) = A \cdot \sin(\omega t - \vec{k}\cdot\vec{r}  + \varphi)`$   

<br>

##### Les notations utilisant la fonction sinus ou la fonction cosinus sont-elles équivalentes?

* Fonctions **sinus et cosinus** représentent *une même fonction, déphasée de $`\pi/2`$*:   
  <br>
  *$`\boldsymbol{\mathbf{sin (\varphi) = cos  (\varphi - \pi/2)}}`$*.


*  $`\Longrightarrow`$ Les écritures d'une OPPH avec une fonction sinus ou une fonction cosinus sont équivalentes.   
   <br>
**$`\mathbf{U(x,t)=A\cdot cos\,(\omega t - \vec{k}\cdot\vec{r} + \varphi)}`$**
$`\quad = A\cdot cos \Big(\omega t - \vec{k}\cdot\vec{r}  + \underbrace{ \varphi + \dfrac{\pi}{2}}_{\color{blue}{=\;\varphi'}} - \dfrac{\pi}{2}\Big)`$
$`\quad = A\cdot 
\;\underbrace{cos \Big[\,\Big(\omega t - \vec{k}\cdot\vec{r}  + \varphi'\Big) - \dfrac{\pi}{2}}_{\color{blue}{cos(a-\pi/2)\\\;=cos(a)\,cos(\pi/2)+sin(a)\,sin(\pi/2)\\=\;sin(a)}}\Big]`$
**$`\boldsymbol{\mathbf{\quad=A\cdot sin\,(\omega t - \vec{k}\cdot\vec{r} + \varphi')}}`$**   
  $`\quad\quad\quad \text{avec } \varphi'=\varphi + \dfrac{\pi}{2})`$   
  
  ---->

---------------

<br>

#### Qu'est-ce qu'une onde périodique?

* Le **milieu** considéré est en général *homogène et isotrope*.

* Une **onde périodique** est la décomposition de l'onde en un *plus petit motif qui se répète* de façon jointive.


##### Point de vue de la source ou d'un capteur.

* La *source* ou le *capteur* d'une onde est *localisé en un point*
donné de l'espace, l'**onde** est représentée alors par une simple **fonction dépendant du temps : $`\Phi(t)`$**.

* On parle alors de la *périodicité temporelle*.

* Le plus petit **motif** est une perturbation temporelle de forme donnée définie sur une durée limitée.
   * La **période temporelle** de l'onde détectée, en général notée **$`T`$**, est la *durée du motif*.
   * La **forme temporelle du motif** est représentée par une *fonction $`f_0(t)`$*.

* L'onde détectée périodique est reconstruite en reproduisant le motif $`g_0(t)`$ à intervalles de temps réguliers $`\Delta t`$ égaux à la période temporelle : $`\Delta t = T`$.

    figure ou animation à faire


##### Point de vue du milieu de propagation

* *A tout instant $`t`$*, la perturbation du milieu est représentée uniquement par
  **fonction dépendant de coordonnées spatiales : $`\Phi(x,y,z)`$**.

* On parle alors de la *périodicité spatiale*.

* Le plus petit **motif** est une *perturbation spatiale de forme donnée* définie sur dans un *espace limité*.

* L'espace ayant trois dimensions, définir une périodicité spatiale nécessite de préciser 
 un peu la forme spatiale de l'onde. *Trois formes simples d'onde* se distinguent, l'*onde unidimensionnelle*,
 l'*onde plane* (2D et 3D) et l'*onde sphérique* (3D) ou circulaire (2D).

   ##### *L'onde unidimensionnelle (1D)*
   
    figure à faire
   
* Le **motif** est la *forme de la perturbation* le long d'une *ligne droite* indiquant la 
  *direction de propagation de l'énergie* de l'onde.
* La **périodicité spatiale ou longueur d'onde** en général notée **$`\lambda`$** est la *longueur du motif*.
* La **forme du motif** est représentée par une *fonction $`g_0(x)`$*.

   ##### *L'onde plane (2D ou 3D)*
   
![](plane-waves-2_L1200.gif)
  
* Le **motif** est la *forme de la perturbation* le long *d'une ligne droite*  indiquant la 
  *direction de propagation de l'énergie* de l'onde.
* Dans une onde plane, le motif est reproduit à l'identique le long d'une
  infinité de lignes droites parallèles formant un plan (onde 2D) ou l'espace (onde 3D),   
  de telle façon qu'à chaque instant l'amplitude du motif soit uniforme dans toute droite (2D)
  ou tout plan (3D) perpendiculaire à ces droites.
   * La **périodicité spatiale ou longueur d'onde** en général notée **$`\lambda`$** est la *longueur du motif*.
   * La **forme du motif** est représentée par une *fonction $`g_0(x)`$*.   
   
   !!!!! *Terminologie : uniforme et stationnaire*
   !!!!! * Le terme *uniforme* donne une *information spatiale*.<br>
   !!!!! <br>
   !!!!! Une *onde* scalaire est *uniforme* dans l'espace ou sur une surface (plane, sphérique) si
   !!!!! à tout instant la grandeur scalaire décrivant l'onde a *même valeur en tout point* du plan ou de la surface.<br>
   !!!!! <br>
   !!!!! * Le terme *stationnaire* donne une *information temporelle*.<br>
   !!!!! Une *onde* scalaire est *stationnaire* si en n'importe-quel point de l'espace, la grandeur scalaire décrivant l'onde
   !!!!! a *même valeur à tout instant*.
   !!!!! <br>

   ##### *L'onde sphérique (3D) ou circulaire (2D)*
   
![onde sphérique](spherical-waves-2_L1200.gif)
   
* Le **motif** est la *forme de la perturbation le long d'un rayon d'une sphère (3D) ou d'un cercle (2D)*, indiquant la 
  *direction de propagation de l'énergie* de l'onde depuis le centre de la sphère ou du cercle, source de l'onde.
* Ce motif est reproduit à l'identique le long de tous les rayons d'une sphère (3D) ou d'un cercle (2D) centré sur la source de l'onde,
  de telle façon qu'à chaque instant l'amplitude du motif soit uniforme à la surface de la sphère (3D) ou du cercle (2D).
   * La **périodicité spatiale ou longueur d'onde** en général notée **$`\lambda`$** est la *longueur du motif*.
   * La **forme du motif** est représentée par une *fonction $`g_0(r)`$*,   
     où $`r`$ est la distance au centre sur un rayon de la sphère ou du cercle.

   ! *Note :*   
   ! Pour des question de conservation de l'énergie de l'onde au cours de sa propagation,
   ! l'onde sphérique est au moins atténuée d'un facteur purement géométrique dépendant de la distance
   ! à son point-source. 


   ##### *Relation entre onde sphérique et onde plane*

![](wave-spherical-towards-plane_v3_L1200.gif)

* *Pour un capteur* dont le volume de détection _(rectangle blanc sur la figure)_ est nécessairement fini, l'**onde perçue** est :
   * *a* : **sphérique** lorsqu'il est *proche de la source* de l'onde.
   * *b* : **quasi-plane** lorsqu'il se situe *à grande distance* de la source de l'onde.

<br>

------------

<br>

#### Qu'est-ce que le principe de superposition des ondes ?


 A faire 
 
 <br><br>
 
 
![](sous-titre-ondes-stationnaires_L1200.jpg)

------------

<br>

#### Qu'est-ce qu'une onde stationnaire ?

<!-------
!!!! *Point difficile :* Le concept d'*onde stationnaire*
!!!! 
!!!! Onde : perturbation qui se propage
!!!! Stationnaire : qui en tout point de l'espace ne varie pas dans le temps
--------->
à faire

<!----------
* Les **deux OPPH** sont :
   * *synchrones ou cohérentes* (en optique)
   * d'*amplitudes égales*
   * et se propagent, l'une *vers les $`x`$ croissants* **et** l'autre *vers les $`x`$ décroissants*
------------>

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/waves_interferences_ventres_noeuds_niv_3a_L1200.gif)

calcul à faire

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/stationary-wave-1D-ventre_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/waves-interferences-ventres-noeuds-niv_3a-2_L1200.gif)   
![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/stationary-wave-1D-noeud_L1200.jpg)   

interpréter de l'écriture mathématique du résultat,
lien avec l'interprétation des caractéristiques de l'onde :ventres et noeuds

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/2D-stationary-wave_L1200.gif)

Un exemple d'onde stationnaire en deux dimensions ou trois dimansions.

<br>


##### Quelle différence entre onde progressive et onde stationnaire ?


 A faire
 
 
##### Où trouve-t-on des ondes stionnaires ?

A faire. Idées : instruments de musique. Cordes, et analogie avec tuyaux
 
 <br><br>
 
![](titre-ondes-copuscules-phenomenes-analogues_L1200.jpg)


#### Quelles sont les phénomènes analogues aux ondes et aux corpuscules ?

* Il existe des **analogies** entre certains *phénomènes ondulatoires* et certains *faits corpusculaires*.

* Lorsque *une onde* rencontre une *interface* (surface de séparation entre deux milieux différents)
  *"suffisamment grande et lisse"* :

   * Le phénomène de **réflexion** de l'onde **à l'interface** évoque le *rebond* d'une *balle sur un mur*.
     
   * De façon plus abstraite, le phénomène de **réfraction** de l'onde **à travers l'interface**,
     peut être comparé à la *trajectoire toujours réalisée par un corpuscule*, trajectoire qui optimise une
     grandeur physique appelée action.   
     !! <details markdown=1><summary>Pour aller plus loin : vers Fermat et Lagrange</summary>
     !! 
     !! Cette analogie est directement utilisée pour expliquer le phénomène de réfraction en
     !! optique géométrique. L'optique géométrique utilise la notion de rayon lumineux et fait
     !! totalement abstraction de la notion d'ondes lumineuses.   
     !! La démonstration de la 
     !! *loi de la réfraction* sera expliqué en terme de *principe de Fermat*, appliqué à calculer
     !! la *trajectoire optimum de deux corpsucules* dans l'exercice de Maria et Simon. 
     !! Le terme optimum sera précisé.
     !! 
     !! Au-delà, au niveau montagne, ce lien sera précisé avec la vision de Lagrange sur la mécanique
     !! classique.
     !!
     !! La vision de Hamilton de la mécanique classique donnera un lien direct vers
     !! la mécanique quantique.
     !! </details>

* L'**effet Doppler** classique exprime aussi bien le *décalage entre fréquence* d'une onde périodique
mesurée au niveau de sa source et d'un capteur, et la *différence de durée* perçue par un observateur 
entre deux événements éloignés dans l'espace et le temps.

!!!!! <details markdown=1><summary>Terminologie : Interface versus surface</summary>
!!!!!
!!!!! * Pour un humain, le terme *surface* désigne la *partie visible et accessible* d'un objet.<br>
!!!!! _C'est par exemple la partie de la table qui est_
!!!!! _au contact direct de l'air et que l'on peut toucher ou observer._
!!!!! <br>
!!!!! Si le terme "sous-face" était employé, il désignerait la partie cachée ou située de l'autre côté de
!!!!! cette surface, que l'humain ne peut ni voir ni toucher.   
!!!!! <br>
!!!!! L'emploi du terme "surface" implique le choix d'un côté d'observation.
!!!!!
!!!!! * Le terme *interface* définit la *frontière entre deux milieux différents*,<br>
!!!!! _par exemple le bois de la table et l'air_,<br>
!!!!! *sans faire référence à un côté où se situerait un observateur. 
!!!!! <br>
!!!!! Le terme interface est à privilégier lorsqu'un phénomène est décrit de façon indépendante
!!!!! d'un humain qui serait observateur.<br>
!!!!! _Par exemple la lumière peut passer indifféremment de l'air à l'eau,_
!!!!! _comme de l'eau à l'air._
!!!!! </details>

! *Note* <br>
!
! La *source de ces analogies* est la *dualité onde-corpuscule*, réalité ultime
! et cachée à nos yeux.   
! Cette réalité cachée est révélée par quelques expériences simples et accessibles
! comme l'expérience des fentes d'Young. Elle est totalement observée dans nos
! laboratoires, et intervient fondamentalement dans beaucoup de nos technologies.
!
! La *dualité onde-corpuscule* est maîtrisée dans le cadre de la *mécanique quantique*.

<br>

![](sous-titre-effet-doppler_L1200.jpg)

#### Qu'est-ce que l'éffet Doppler ?

* L'*effet Doppler* décrit exprime le **décalage du durée** entre deux impulsions,
  mesuré **au niveau de la source et du capteur**.

* L'étude se limite au cas où *source et capteur* se déplacent sur une **même droite**,
  chacun à **vitesse constante**.

<!--
* Sur cette droite, le **détecteur** reste *toujours du même côté* de la source.
-->


#### L'effet Doppler classique, pour les ondes mécaniques


* La vitesse de *propagation des ondes mécaniques* est toujouts *très inférieure à $`c`$* la
  vitesse de la lumière dans le vide :   
  <br>
  **$`\large\mathbf{\boldsymbol{\mathscr{v}_{propag}\ll c}}`$**   
  <br>
  L'effet peut donc s'étudier dans le cadre de la physique classique, où *temps et espace*
  sont indépendants et **universels**.   
  <br>
  Ainsi l'effet Doppler peut s'étudier à l'aide d'un graphique 2D classique, où :
  * l'**axe vertical** représente le **temps**
  * l'**axe horizontal**représente l'**espace**, soit la droite dans laquelle s'inscrivent
  les déplacements de la source comme du capteur.

* Il faut tenir compte de quatre instants :
    * **$`\mathbf{t_1}`$** l'instant où une *source émet* une *première impulsion*.
    * **$`\mathbf{t_1}'`$** l'instant où un *capteur détecte* cette *première impulsion*.
    * **$`\mathbf{t_2}`$**  l'instant où la *source émet* une *deuxième impulsion*.
    * **$`\mathbf{t_2}'`$** l'instant où le *capteur détecte* cette *deuxième impulsion*.   
   
   de trois vitesses, exprimées *par rapport au milieu matériel* :
    * **$`\mathbf{\mathscr{v}_{propag}}`$** la *vitesse de propagation des impulsions*.
    * **$`\mathbf{\mathscr{v}_{source}}`$** la *vitesse de la source*.
    * **$`\mathbf{\mathscr{v}_{capteur}}`$** la *vitesse du capteur*.
    
*  **Trois cas** se distinguent :
   * *$`\mathbf{\mathscr{v}_{source}\lt\mathscr{v}_{propag}}`$*
   * *$`\mathbf{\mathscr{v}_{source}=\mathscr{v}_{propag}}`$*
   * *$`\mathbf{\mathscr{v}_{source} > \mathscr{v}_{propag}}`$*
   
   !! <details markdown=1><summary>Pour aller plus loin : les différents régimes de vitesse en aéronautique.
   !! </summary>
   !!
   !! L'aéronautique est un domaine où l'avion peut se déplacer dans l'air à une vitesse $`\mathscr{v}`$ inférieure, 
   !! égale ou supérieure à la vitesse de propagation $`\mathscr{v}_{son}`$ de l'onde sonore qu'il génère.   
   !!
   !! Cette *vitesse du son* dépend de la *température* et de la *densité de l'air*.
   !! Donnons par exemple :   
   !! * $`\mathscr{v}_{son}\approx 340\,m\,s^{-1}\approx 1224\,km/h`$ au niveau de la mer et pour une température de $`20°C`$.
   !! * $`\mathscr{v}_{son}\approx 295\,m\,s^{-1}\approx 1062\,km/h`$ à $`10000\,m`$ d'altitude et pour une température de $`-60°C`$.
   !!
   !! Le *Mach*, de symbole $`\mathbf{M}`$ est défini comme la vitesse relative de l'avion
   !! par rapport à la vitesse du son à une altitude et une température données :   
   !! $`\mathbf{M=\dfrac{\mathscr{v}}{\mathscr{v}_{son}}}`$   
   !!
   !! *Quatre régimes de vitesse* sont distingués :   
   !! * Pour $`\mathbf{M \le 0.8}`$ la vitesse est dite *subsonique* ou *infrasonique*.   
   !! * Pour $`\mathbf{0.8 \lt M \lt 1,2}`$ la vitesse est dite *transsonique*.   
   !! * Pour $`\mathbf{1,2 \le M \le 5}`$ la vitesse est dite *supersonique*.   
   !! * Pour $`\mathbf{ M \gt 5}`$ la vitesse est dite *hypersonique*.   
   !! 
   !! Le *mur du son* correpond à $`\mathbf{M = 1}`$
   !! </details>


##### 1 - Cas où $`\mathbf{\mathscr{v}_{source} \lt \mathscr{v}_{propag}}`$

* C'est le cas où pour tout capteur, la **source** sera *toujours précédée par l'onde* qu'elle émet.
<br>
* Etudions le cas où le mouvement du capteur lui permet de recevoir toujours l'onde émise par la source.

   * La *source émet* la **première impulsion à l'instant $`\mathbf{t_1}`$**.   

   * Le *capteur détecte* cette **première impulsion à l'instant $`\mathbf{t_1}'`$**, alors qu'il 
  est situé à la *distance $`\mathbf{d_{impuls.1}}`$  de la source* au moment de l'émission 
  la première impulsion.  
<br>
$`\mathbf{d_{impuls.1}}`$ est donc la distance parcourue par l'impulsion entre son instant 
$`\mathbf{t_1}`$ d'émission et l'instant $`\mathbf{t_1}'`$ où elle est détectée.    
<br>
Se propageant entre ces deux instants dans le milieu matériel à la vitesse $`\mathscr{v}_{prop}`$,
tu as la première relation :   
<br>
*$`\mathbf{d_{impuls.1} = \mathscr{v}_{propag}\times (t_1' - t_1)}`$*   

   * La *source émet* une **seconde impulsion à l'instant $`\mathbf{t_2}`$**.   
<br>
Figure ou animation à faire.  
<br>

   * Le *capteur détecte* cette **seconde impulsion à l'instant $`\mathbf{t_2}'`$**, alors qu'il
est situé à la *distance $`d_{impuls.2}`$ de la source* au moment où elle émet la seconde impulsion.   
<br>
$`\mathbf{d_{impuls.2}}`$ est donc la distance parcourue par la deuxième impulsion entre son instant $`\mathbf{t_2}`$
d'émission et l'instant $`\mathbf{t_2'}`$ où elle est détectée. L'impulsion se propageant dans le milieu
matériel à la vitesse $`\mathscr{v}_{propag}`$, tu as une deuxième relation :   
<br>
*$`\mathbf{d_{impuls.2} = \mathscr{v}_{propag}\times (t_2' - t_2)}`$*.   

* Avant une synthèse finale, **plusieurs cas** sont à étudier selon les mouvements de la source et du capteur, 
  donnant des *expressions différentes de l'effet Doppler* :

<br>

----------------

   * **Source et capteurs s'éloignent**, et se dirigent en *sens inverse*

![](doppler-1-n2_L1200.png)
<br>

* **$`\mathbf{d_{impuls.2}}`$** est donc la distance **$`\mathbf{d_{impuls.1}}`$** à laquelle *il faut* : 
  * *ajouter la distance $`\mathbf{d_{source}}`$* parcourue par la source pendant 
  la durée séparant l'émission des deux impulsions :   
 *$`\mathbf{d_{source}=\mathscr{v}_{source}\times (t_2 - t_1)}`$*.   
 <br>
   * *ajouter la distance $`\mathbf{d_{capteur}}`$*  parcourue par le capteur 
   pendant la durée séparant la réception deux impulsions :   
 *$`\mathbf{d_{capteur} = \mathscr{v}_{capteur}\times (t_2' - t_1')}`$*.
<br>

* Tu obtiens ainsi :   
<br>
**$`\mathbf{d_{impuls.2} = d_{impuls.1}}`$** *$`\mathbf{\, + d_{source} + d_{capteur}}`$*   
<br>
$`\color{blue}{\scriptsize{soit}}`$   
<br>
$`\begin{align}
\underbrace{\mathscr{v}_{propag.}\cdot (t_2' - t_2)}_{\color{blue}{d_{impuls.2}}}&=
\underbrace{\mathscr{v}_{propag.}\cdot (t_1' - t_1)}_{\color{blue}{d_{impuls.1}}}\\
& \hspace{1cm} + \underbrace{\mathscr{v}_{source}\cdot (t_2 - t_1)}_{\color{blue}{d_{source}}}\\
& \hspace{2cm} +\underbrace{\mathscr{v}_{capteur}\cdot (t_2' - t_1')}_{\color{blue}{d_{capteur}}}
\end{align}`$   
<br>
$`\color{blue}{\scriptsize{\text{si cette étape t'est nécessaire, simplifie la manipulation
à venir }}}`$   
$`\color{blue}{\scriptsize{\text{en évitant les produits de somme :}}}`$  
<br>
$`\begin{align}
\mathscr{v}_{propag.}\,t_2' - \mathscr{v}_{propag.}\,t_2 &= \mathscr{v}_{propag.}\,t_1' -  \mathscr{v}_{propag.}\,t_1\\
& \hspace{0.6cm} + \mathscr{v}_{source}\,t_2 - \mathscr{v}_{source}\,t_1\\
& \hspace{0.6cm} +\mathscr{v}_{capteur}\,t_2' - \mathscr{v}_{capteur}\,t_1'
\end{align}`$   
<br>
$`\color{blue}{\scriptsize{\text{Sépare d'un côté de l'équation les instants en ' propres
}}}`$  
$`\color{blue}{\scriptsize{\text{  à la réception,et de l'autre les instants propres à l'émission :
}}}`$  
<br>
$`\begin{align}
&\mathscr{v}_{propag.}\,t_2' - \mathscr{v}_{propag.}\,t_1' - \mathscr{v}_{capteur}\,t_2'+ \mathscr{v}_{capteur}\,t_1'\\
& \hspace{0.2cm} =  \mathscr{v}_{propag.}\,t_2 -  \mathscr{v}_{propag.}\,t_1 + \mathscr{v}_{source}\,t_2 - \mathscr{v}_{source}\,t_1 
\end{align}`$   
<br>
$`\color{blue}{\scriptsize{\text{et simplifie l'expression en factorisant :}}}`$   
<br>
$`\begin{align}
&\mathscr{v}_{propag.}\,(t_2' - t_1') - \mathscr{v}_{capteur}\,(t_2' - t_1') \\
&\hspace{1cm} = \mathscr{v}_{propag.}\,(t_2 - t_1) + \mathscr{v}_{source}\,(t_2 - t_1)
\end{align}`$   
<br><br>
$`\begin{align}
& (t_2' - t_1')\; (\mathscr{v}_{propag.} - \mathscr{v}_{capteur})\\
&\hspace{1cm} = (t_2 - t_1)\;(\mathscr{v}_{propag.}+ \mathscr{v}_{source})
\end{align}`$   
<br>
$`\color{blue}{\scriptsize{\text{Au final, tu obtiens :}}}`$   
<br>
$`\boldsymbol{\mathbf{(t_2' - t_1')= (t_2 - t_1)\cdot \dfrac{\mathscr{v}_{propag.}+ \mathscr{v}_{source}}
{\mathscr{v}_{propag.} - \mathscr{v}_{capteur}}}}`$

<br>

-----------------

   * **Source et capteurs se rapprochent**, se dirigeant en *sens inverse*

![](doppler-2-n2_L1200.png)

<br>
* **$`\mathbf{d_{impuls.2}}`$** est donc la distance **$`\mathbf{d_{impuls.1}}`$** à laquelle *il faut* : 
  * *soustraire la distance $`\mathbf{d_{source}}`$* parcourue par la source pendant 
  la durée séparant l'émission des deux impulsions :   
 *$`\mathbf{d_{source}=\mathscr{v}_{source}\times (t_2 - t_1)}`$*.   
 <br>
   * *soustraire la distance $`\mathbf{d_{capteur}}`$*  parcourue par le capteur 
   pendant la durée séparant la réception deux impulsions :   
 *$`\mathbf{d_{capteur} = \mathscr{v}_{capteur}\times (t_2' - t_1')}`$*.
<br>

* Tu obtiens ainsi :   
<br>
**$`\mathbf{d_{impuls.2} = d_{impuls.1}}`$** *$`\mathbf{\, - d_{source} - d_{capteur}}`$*  
<br>

* Un **calcul** *analogue au précédent* te conduit à :   
<br>
$`\boldsymbol{\mathbf{(t_2' - t_1')= (t_2 - t_1)\cdot \dfrac{\mathscr{v}_{propag.}- \mathscr{v}_{source}}
{\mathscr{v}_{propag.} + \mathscr{v}_{capteur}}}}`$


<br>

-----------------

   * **Source et capteurs se rapprochent**, se dirigeant tous deux dans le *sens 
     de propagation* de l'onde qui les relie

![](doppler-3-n2_L1200.png)   
<br>
* **$`\mathbf{d_{impuls.2}}`$** est donc la distance **$`\mathbf{d_{impuls.1}}`$** à laquelle *il faut* : 
  * *soustraire la distance $`\mathbf{d_{source}}`$* parcourue par la source pendant 
  la durée séparant l'émission des deux impulsions :   
 *$`\mathbf{d_{source}=\mathscr{v}_{source}\times (t_2 - t_1)}`$*.   
 <br>
   * *ajouter la distance $`\mathbf{d_{capteur}}`$*  parcourue par le capteur 
   pendant la durée séparant la réception deux impulsions :   
 *$`\mathbf{d_{capteur} = \mathscr{v}_{capteur}\times (t_2' - t_1')}`$*.
<br>

* Tu obtiens ainsi :   
<br>
**$`\mathbf{d_{impuls.2} = d_{impuls.1}}`$** *$`\mathbf{\, - d_{source} + d_{capteur}}`$*  
<br>

* Un **calcul** *analogue au précédent* te conduit à :   
<br>
$`\boldsymbol{\mathbf{(t_2' - t_1')= (t_2 - t_1)\cdot \dfrac{\mathscr{v}_{propag.}- \mathscr{v}_{source}}
{\mathscr{v}_{propag.} - \mathscr{v}_{capteur}}}}`$

<br>

-----------------

   * **Source et capteurs se rapprochent**, se dirigeant tous deux dans le *sens 
     contraire à la propagation* de l'onde qui les relie

![](doppler-4-n2_L1200.png)   
<br>
* **$`\mathbf{d_{impuls.2}}`$** est donc la distance **$`\mathbf{d_{impuls.1}}`$** à laquelle *il faut* : 
  * *ajouter la distance $`\mathbf{d_{source}}`$* parcourue par la source pendant 
  la durée séparant l'émission des deux impulsions :   
 *$`\mathbf{d_{source}=\mathscr{v}_{source}\times (t_2 - t_1)}`$*.   
 <br>
   * *soustraire la distance $`\mathbf{d_{capteur}}`$*  parcourue par le capteur 
   pendant la durée séparant la réception deux impulsions :   
 *$`\mathbf{d_{capteur} = \mathscr{v}_{capteur}\times (t_2' - t_1')}`$*.
<br>

* Tu obtiens ainsi :   
<br>
**$`\mathbf{d_{impuls.2} = d_{impuls.1}}`$** *$`\mathbf{\, + d_{source} - d_{capteur}}`$*  
<br>

* Un **calcul** *analogue au précédent* te conduit à :   
<br>
$`\boldsymbol{\mathbf{(t_2' - t_1')= (t_2 - t_1)\cdot \dfrac{\mathscr{v}_{propag.} + \mathscr{v}_{source}}
{\mathscr{v}_{propag.} + \mathscr{v}_{capteur}}}}`$

<br>

-----------------

* **Synthèse des différents cas**

<br>
**$`\large\boldsymbol{\mathbf{(t_2' - t_1')= (t_2 - t_1)\cdot \dfrac{\mathscr{v}_{propag.} \pm \mathscr{v}_{source}}
{\mathscr{v}_{propag.} \pm \mathscr{v}_{capteur}}}}`$**   
<br>
avec :

   * **$`\large{+}\,\mathscr{v}_{source}`$** si la *source* va dans le *sens inverse de propagation*.
   * **$`\large{-}\,\mathscr{v}_{source}`$** si la *source* va dans le *sens de la propagation*.
   * **$`\large{+}\,\mathscr{v}_{capteur}`$** si le *capteur* va dans le *sens inverse de propagation*.
   * **$`\large{-}\,\mathscr{v}_{capteur}`$** si le *capteur* va dans le *sens de la propagation*.
<br><br>

!! *Pour aller plus loin : La notation algébrique*
!!
!! à faire


*Effet Doppler classique et ondes périodiques*

* Ces **deux impulsions** représentent un même *trait caractéristique du motif 
temporel* d'une onde périodique, considérées *sur deux motifs consécutifs*.   
La durée entre ces deux impulsions représente alors la **période temporelle $`T`$ ** de l'onde :   
<br><br>
$`\boldsymbol{\mathbf{(T_{capteur})= (T_{source})\cdot \dfrac{\mathscr{v}_{propag.} \pm \mathscr{v}_{source}}
{\mathscr{v}_{propag.} \pm \mathscr{v}_{capteur}}}}`$ 
<br><br>


* S'adressant à des ondes périodiques, l'**effet Doppler** s'exprime le plus souvent
en *fonction de la fréquence $`\nu`$* de l'onde :   
<br>
$`\big(T_{capteur}\big)^{-1}= 
\underbrace{
\Big(T_{source}\cdot\dfrac{\mathscr{v}_{propag.}\pm \mathscr{v}_{source}}{v_{propag.} 
\pm \mathscr{v}_{capteur}}\Big)^{-1}
}_{
\color{blue}{(xy)^m = x^m\,y^m}
}`$   
<br><br>
$`\underbrace{\big(T_{capteur}\big)^{-1}}_{
\color{blue}{\nu = 1\,/\,T}}
= \underbrace{\big(T_{source}\big)^{-1}}_{
\color{blue}{\nu = 1\,/\,T}}
\cdot \left(\dfrac{\mathscr{v}_{propag.}
\pm \mathscr{v}_{source}}{\mathscr{v}_{propag.} \pm \mathscr{v}_{capteur}}\right)^{-1}`$   
<br>
<br>
**$`\large\boldsymbol{\mathbf{\boldsymbol{\nu_{capteur}= \nu_{source}\cdot \dfrac{\mathscr{v}_{propag.}
\pm \mathscr{v}_{capteur}}{\mathscr{v}_{propag.} \pm \mathscr{v}_{source}}}}}`$**

<br>
*Effet Doppler classique et ondes non-périodiques*

à faire.

<br>
*Effet Doppler classique et évènements indépendants*

à faire

! *Note :*
! 
! Cet effet Doppler entre deux évènements distincts perçus par un
! observateur grâce à une onde matérielle qu'ils émettent, est un
! phénomène classique tout à fait intuitif et compréhensible.
!
! Il ne doit pas être confondu avec le phénomène de contraction des durées,
! plus subtile et d'ampleur moindre dans le monde de tous les jours, décrit
! par la théorie de la relativité restreinte, puis générale.

<br><br>

##### 2 - Cas où $`\mathbf{\mathscr{v}_{source} = \mathscr{v}_{propag}}`$

à faire.

<br><br>

##### 3 - Cas où $`\mathbf{\mathscr{v}_{source}\gt \mathscr{v}_{propag}}`$

à faire.

<br><br>

##### Quand observe-t-on cet effet Doppler classique ?

à faire

<br>

<br><br>

--------------------

<br>

#### L'effet Doppler relativiste des ondes électromagnétiques

à faire.

<br><br>


##### Quand utilise-t-on cet effet Doppler relativiste ?

à faire

<br>

<br><br>

<br>

![](title-diffusion-absorption-attenuation.jpg)

A faire

<br><br>

<br>

![](titres_bleus-reflexion-refraction.jpg)

* Le phénomène de **réflexion** décrit le *rebond* d'une onde, avec changement de direction, 
  *sur une interface*
  entre deux milieux différents.

* **Selon l'état de la surface**, tu peux voir *deux types différents* de réflexion :
   * La **réflexion diffuse** se produit lorsqu'une onde frappe une *surface suffisamment rugueuse ou irrégulière*.
   * La **réflexion spéculaire** se produit lorsqu'une onde frappe une *surface suffisamment lisse et polie*.

* Le phénomène de **réfraction** complète parfois la réflexion spéculaire en décrivant la 
  *propagation de l'onde* incidente, avec changement de direction, *après traversée de l'interface*. 

<br>

![](sous-titre-reflexion-diffuse.jpg)

A faire

<br>

![](sous-titre-reflexion-speculaire-refraction.jpg)

![](waves-incid-reflec-refrac-1_L1200.gif)


![](waves-incid-reflec-refrac-2_L1200.jpg)

![](waves-incid-reflec-refrac-3_L1200.jpg)

![](waves-incid-reflec-refrac-4_L1200.jpg)


<br>

![](sous-titre-reflexion-spéculaire.jpg)

#### Réflexion spéculaire à une interface

À faire. Idées :  En terme d'onde, en terme de rebond, vers un lien dualité onde-corpuscule possible?
Lien avec l'optique géométrique et la loi de la réflexion.

Commencer par réflexion d'une onde non périodique unidimensionnelle (une impulsion).   
Exemple une corde tendue accrochée en un point fixe d'un poteau.  

Je fixe juste ci-dessous les idées pour ne pas oublier.

![](wave-reflexion-fixe-total-1d_1200.gif) 

_Pour un point "Mon petit laboratoire" : expérience réalisée avec une corde tendue dont l'une_ 
_des extrémités est arrimée à un crochet fixé ur une planche horizontale._

Question : Pourquoi le profil de l'onde se déforme-t-il en arrivant voisinage du poteau ?
Elle ne devrait pas, car la pertirbation se propage de proche en proche. Pourquoi se déforme t-elle
alors qu'elle se déplace librement, n'ayant pas encore atteint le poteau ?

Réponse : En fait l'onde incidente ne ce déforme pas jusqu'au poteau ou elle est réfléchie.   
Sur le poteau, l'onde incidente se superpose à l'onde réfléchie.   
La corde étant accrochée à un point fixe, la perurbation de la corde doit nulle à tout instant.
Cela signifie que sur le poteau, l'onde incidente et l'onde réfléchie doivent s'annuler à chaque instant, 
donc que leurs élongations sont à chaque instant opposées.

![](wave-reflexion-fixe-incident-reflected-1d_1200.gif)   

Exemple une corde tendue accrochée sur un anneau libre de se mouvoir sans frottement sur le poteau.

![](wave-total-reflexion-impulsion-libre-1D-L1200.gif)   

_Pour un point "Mon petit laboratoire" : peut être observée à la piscine, lors du rebond de petites vagielettes_
_sur la paroir de la piscine. Au nouveau de la paroi, l'amplitude de l'onde résultante de la superposition de l'onde incidente et de l'onde réfléchie_
_est plus importante que l'amplitude de la seule onde incidente, et l'énergie est telle que de petits éclaboussements_
_peuvent se réaliser._

Même question : Pourquoi le profil de l'onde se déforme-t-il en arrivant voisinage du poteau ?
Elle ne devrait pas, car la pertirbation se propage de proche en proche. Pourquoi se déforme t-elle
alors qu'elle se déplace librement, n'ayant pas encore atteint le poteau ?

Même réponse : l'onde incidente ne ce déforme pas jusqu'au poteau ou elle est réfléchie.   
Sur le poteau, l'onde incidente se superpose à l'onde réfléchie.  

La différence est la suivante :   
La corde étant accrochée à un anneau mobile pouvant gliser sans frottement le long du poteau, 
seule la composante de vitesse longitudinale de l'onde s'inverse lors de la réflexion.
Mais à chaque instant l'onde incidente et l'onde réfléchie ont même élongation sur le poteau.

![](wave-reflexion-impulsion-libre-incident-reflected-1D-L1200.gif)   

le phénomène de réflexion d'une onde résulte d'une interaction entre l'onde et le milieu où elle
se réfléchie.    
Les deux cas visualisés (point d'ancrâge de la corde fixe, ou glissant librement sans frottement) sont deux
cas limites.
a développer...

figure à faire ou les deux ondes, incidente et réfléchie, sont visualisées individuellement, leur superposition
qui donne la figure précédente n'apparaissant qu'en pointillé.

lien avec rebond d'une balle sur un mur ?

deux figures, cette fois-ci avec une onde sinusoîdale 1D, sinusoïdale? où les deux cas précédents sont
traduits en terme de déphasage (0 et pi), puis là encore parler du cas réelle.

ensuite passer à la réflexion d'une onde 2D sur une paroi plane, pour mettre en évidence la loi de la réflexion.

lien vers l'optique géométrique, science la plus ancienne de l'optique, ou l'information sur la phase (et la polarisation)
n'est pas décrite;

 

<br><br>

![](sous-titre-ondes-refraction_L1200.jpg)


#### Qu'est-ce que le phénomène de réfraction ?

<br>

* Le **phénomène de réfraction** correspond à une *modification de la direction* de propagation
d'une onde *à la traversée d'une interface* entre deux milieux différents.   

* Ce phénomène de réfraction est **propre à toute onde**. Il s'observe en *optique, acoustique, sismologie, ...*

![refraction d'une onde plane sur un dioptre plan](
https://m3p2.com/fr/temporary_ins/waves/n3/overview/wave-optics-n3-refraction-1_v2_L1000.gif)
_Modélisation du phénomène de réfraction d'une onde plane._

* La **période temporelle $`T`$** de l'onde, **grandeur fondamentale** propre à l'onde et donc 
  *ne dépend pas du milieu* de propagation.

* **Chacun des milieux**, de part et d'autre de l'interface, est caractérisé par 
   *sa propre vitesse de propagation* de l'onde.

* La **longueur d'onde $`\lambda`$**, distance parcourue par l'onde 
  au cours d'une période temporelle $`T`$, *dépend de la célérité* $`\mathscr{v}`$ et donc *du milieu*.

<br>

##### Quel rôle joue l'interface entre les deux milieux ?
<br>

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-intro-1_L1200.gif)

**a** - L'onde plane incidente change de direction à la traversée de l'interface entre les deux milieux.

**b** - Le **principe de Huygens-Fresnel** postule une *continuité de phase* de la fonction 
d'onde *à la traversée de l'interface* entre les deux milieux.

**c** - *Dans le plan de l'interface*, la fonction d'onde a une **périodicité $`\Lambda`$** 
qui dépend de l'angle d'incidence.


<br>

##### Quelle propriété de l'onde varie à la traversée de l'interface ?   
<br>

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-intro-2_L1200.gif)

* La **grandeur physique fondamentale** caractérisant une onde progressive *est temporelle*, soit :
   * sa période temporelle *$`T`$ ou* sa fréquence temporelle *$`\nu=1\,/\,T`$*.
   * sa pulsation *$`\omega = 2\pi\,\nu = 2\pi\,/\,T`$* pour une *onde harmonique*.
   

* L'**onde** progressive plane harmonique de *période temporelle $`T`$* présente :

   * une **longueur d'onde $`\lambda_1`$** *$`\; = \mathscr{v}_1\;T`$* dans le milieu 1 ou sa célérité est $`\mathscr{v}_1`$.
   * une **longueur d'onde $`\lambda_2`$** *$`\; = \mathscr{v}_2\;T`$* dans le milieu 1 ou sa célérité est $`\mathscr{v}_2`$.

<br>

##### Que représente un rayon ?<br> Et comment caractériser sa trajectoire ?   
<br>

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-intro-3_L1200.gif)

* L'**onde** plane progressive harmonique **propage de l'énergie** 
   * dans sa *direction de propagation*.
   * *perpendiculaire au fronts d'onde*.

* La *direction de propagation* de l'énergie peut être représentée par un **rayon**.   
  _trajectoire fléchée de couleur jaune sur la figure._

* La **trajectoire du rayon** est *déviée à l'interface*.

* Les **angles d'incidence et de réfraction** du rayon sont repérés *par rapport à la normale* à l'interface
  au point où le rayon traverse l'interface.
   * **$`\theta_1`$** est l'*angle d'incidence*.
   * **$`\theta_2`$** est l'*angle de réfraction*.

<br>
   
##### Quelle est la loi de la réfraction ?   
<br>

* Les deux angles **$`\theta_1`$ et $`\theta_2`$** peuvent s'exprimer en *fonction* des longueurs d'ondes
*$`\lambda_1`$ et $`\lambda_2`$*, et d'une **longueur de référence commune**, la longueur d'onde **$`\Lambda`$**
dans le plan de l'interface.

* Les relations utilisent le *théorème de Pythagore* dans un triangle rectangle.

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-relation-1_L1200.jpg)

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-relation-2_L1200.jpg)


* Exprimons cette longueur de référence commune dans chaque milieu :   
  <br>
  **$`\large{\boldsymbol{\mathbf{\Lambda = \dfrac{\lambda_1}{sin\,\theta_1}}}}\quad`$** 
  et *$`\quad\large{\boldsymbol{\mathbf{\Lambda = \dfrac{\lambda_2}{sin\,\theta_2}}}}`$*.   

* Nous en déduisons la **loi de la réfraction** :   
  <br>
  $`\left.\begin{align}
   &\Lambda = \dfrac{\lambda_1}{sin\,\theta_1}\\
   &\Lambda = \dfrac{\lambda_2}{sin\,\theta_2}
   \end{align}\right\}\Longrightarrow\;\dfrac{sin\,\theta_1}{\lambda_1}=\dfrac{sin\,\theta_2}{\lambda_2}`$   
   <br>
   $`\hspace{2.5cm}\Longrightarrow\;\dfrac{sin\,\theta_1}{\mathscr{v}_1\,T}=\dfrac{sin\,\theta_2}{\mathscr{v}_2\,T}`$   
   <br>
   $`\hspace{2.5cm}\Longrightarrow\;\color{brown}{\large{\boldsymbol{\mathbf{\dfrac{sin\,\theta_1}{\mathscr{v}_1}=\dfrac{sin\,\theta_2}{\mathscr{v}_2}}}}}`$
   

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/refraction-relation-3_L1200.jpg)


C'est incomplet. Traiter à la suite le phénomène de réflexion totale..

<br>

##### Quel est le lien avec l'Optique géométrique ?

<br>

* La célérité **$`c=3\times 10^8\;m\,s^{-1}`$** de la lumière dans le vide est une **constante fondamentale de la nature**.   
  L'expérience, comprises dans le cadre de la relativité d'Einstein, montre que $`c`$ est une *vitesse limite infranchissable*.

* Dans un **matériau transparent**, isotrope et homogène, tout se passe comme si la lumière se propage en ligne droite
  à une *célérité $`\mathscr{v}`$* qui dépend du matériau.

* Caractéristique du matériau, la célérité $`\mathscr{v}`$ s'exprime à travers la 
  notion d'*indice de réfraction* $`n`$ défini par :   
  <br>
  *$`\large{\mathbf{n=\dfrac{c}{\mathscr{v}}}}`$*.

* La *loi de la réfraction en optique géométrique* s'exprime en utilisant la notion d'indice de réfraction
  pour caractériser les milieux de part et d'autre de leur interface.   
  <br>
  Connue sous le nom de **Loi de Snell-Descartes**, elle s'écrit :   
  <br>
  **$`\large{\mathbf{n_1\cdot sin\,\theta_1 = n_2\cdot sin\,\theta_2}}`$**


<br><br>

![](titre-ondes-phenomenes_L1200.jpg)


#### Quelles sont les phénomènes propres aux ondes ?

* Ces phénomènes ne sont pas décrits par la physique classique appliquée aux corps et corpuscules.

* Lorsque *une ou plusieurs ondes* se propagent dans *un même milieu* :

   * Le phénomène d'**interférence** peut être observé en présence de plusieurs ondes.
     
   * Le phénomène de **diffraction** peut être observé lorsqu'un obstacle pertube la propagation d'une onde.

<br><br>

![](sous-titre-ondes-interference_L1200.jpg)

#### Qu'est-ce que le phénomène d'interférence ?

<br>

* Le **phénomène d'interférence** est le fait que lorsque *des ondes se superposent* dans l'espace et le temps,
l'*amplitude de l'onde resultante* n'est *pas la somme des amplitudes* des ondes en présence.

![interférences entre deux ondes sphériques d'égale amplitiudes et déphasées de pi,
et propagation des zéros](https://m3p2.com/fr/temporary_ins/waves/n3/overview/2_sources_circulaires_dephasees_pi_v2_L1000.gif)

@@@@@@@ EN  CONSTRUCTION @@@@@@@@@@@

* Pour une compréhension simple du phénomène d'interférence, considère la 
  **superposition des deux ondes harmoniques** de *même amplitude $`A`$*, de *même pulsation $`\omega`$*, 
  se propageant le long d'un même milieu unidimensionnel mais en *sens opposés*, et l'une par rapport à l'autre 
  *déphasées de $`\Delta\varphi`$*.   
  <br>
  **$`\boldsymbol{\mathbf{U_1(x,t) = A\cdot cos(kx - \omega t)}}`$**   
  **$`\boldsymbol{\mathbf{U_2(x,t) = A\cdot cos(kx - \omega t + \Delta\varphi)}}`$**   
  <br>
  Par définition, l'*onde résultante* est en chaque point $`x`$ et à chaque instant $`t`$
  la sommme des ondes en présence :   
  <br>
  *$`\mathbf{U(x,t) = U_1(x,t) + U_2(x,t)}`$*  
  <br>
  Le calcul à réaliser est :   
   <br>
   **$`\boldsymbol{\mathbf{U(x,t) = A\cdot cos(kx - \omega t)}}`$**
   **$`\boldsymbol{\mathbf{\hspace{3cm} + A\cdot cos(kx - \omega t + \Delta\varphi)}}`$** 

* En physique comme dans la vie, le **principe de convergence** est *souvent utile* à chaque étape d'un calcul :   
  <br>
![](https://m3p2.com/fr/temporary_ins/images/principe-de-convergence-fr-bleu_L1200.jpg)   

* Commence par **simplifier** l'écriture mathématique en donnant un *nom simple à ce qui est commun* mais complexe à écrire.<br>
  Ici ce qui est commun est le terme $`kx - \omega t`$.  
  Appelle-le $`\alpha`$, en gardant en mémoire que <br>
  *$`\alpha = kx - \omega t`$*
  <br>
  L'onde résultante recherchée s'écrit alors plus simplement :   
  <br>
  **$`\boldsymbol{\mathbf{U(x,t)\; = A\cdot cos(\alpha) +  A\cdot cos(\alpha + \Delta\varphi)}}`$**   

* Les *phases des deux ondes*, $`\alpha`$ et $`\alpha + \Delta\varphi`$, sont *différentes*.   
  Là encore, exprime ces deux phases en fonction de ce qu'elles partagent en commun, 
  et de leur différences par rapport à ce commun.   
  <br>
  * Le **commun** est la **valeur moyenne** de leur phases, soit   
  **$`\boldsymbol{\alpha_{moyen}}`$** $`\, = \dfrac{(\alpha)+(\alpha + \Delta\varphi)}{2} = \dfrac{2\,\alpha + \Delta\varphi}{2}`$ **$`\,\boldsymbol{\mathbf{= \alpha + \dfrac{\Delta\varphi}{2}}}`$**   
  <br>
  * Ce qui les différencie est leur *différence par rapport au commun*, soit *$`\boldsymbol{\mathbf{\Delta\varphi\,/\,2}}`$* en plus et en moins.   

  <br>
  Les *phases des deux ondes* s'écrivent alors sous la forme
  *$`\boldsymbol{\mathbf{\alpha_{moyen} - \dfrac{\Delta\varphi}{2}}}\;`$* et *$`\;\boldsymbol{\mathbf{\alpha_{moyen} + \dfrac{\Delta\varphi}{2}}}`$*   
  <br>
  et l'**onde résultante** se réécrit :     
  <br>
  **$`\boldsymbol{\mathbf{ U(x,t) = A\cdot cos\left(\alpha_{moyen} - \dfrac{\Delta\varphi}{2}\right)}}`$**
  **$`\boldsymbol{\mathbf{\hspace{3cm}+ A\cdot cos\left(\alpha_{moyen} + \dfrac{\Delta\varphi}{2}\right)}}`$**

      
      à continuer
  
==================

$`\begin{align} \quad &=A\;\big[\,cos(\underbrace{kx - \omega t}_{\color{blue}{\text{  posons }\\ kx - \omega t\,=\, \alpha}}) + cos(\underbrace{kx - \omega t}_{\color{blue}{=\; \alpha}} + \Delta\varphi)\,\big]
&\\
&=A\;\big[\,cos\Big(\alpha + \underbrace{\dfrac{\varphi_1+\varphi_2}{2} + \dfrac{\varphi_1-\varphi_2}{2}}_{\color{blue}{=\;\varphi_1}}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\alpha + \underbrace{\dfrac{\varphi_1+\varphi_2}{2} - \dfrac{\varphi_1-\varphi_2}{2}}_{\color{blue}{=\;\varphi_2}}\Big)\,\Big]\\
&\\
&=A\;\big[\,cos\Big(\underbrace{\alpha + \dfrac{\varphi_1+\varphi_2}{2}}_{\color{blue}{=\;\alpha '}} + \dfrac{\varphi_1-\varphi_2}{2}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\underbrace{\alpha + \dfrac{\varphi_1+\varphi_2}{2}}_{\color{blue}{\text{nous avons posé }\\ \alpha + (\varphi_1+\varphi_2)/2\; = \;\alpha '}} - \dfrac{\varphi_1-\varphi_2}{2}\Big)\,\Big]\\
&\\
&=A\;\big[\,cos\Big(\alpha ' + \dfrac{\varphi_1-\varphi_2}{2}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\alpha ' - \dfrac{\varphi_1-\varphi_2}{2}\Big)\,\Big]\\
&\\
&=A\;\big[\,\underbrace{cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\,-\,sin(\alpha ')\,sin\Big(\dfrac{\varphi_1-\varphi_2}{2}}_{\color{blue}{\text{car   }cos(a+b)\;=\;cos\,a\,cos\,b\;-\;sin\,a\,sin\,b}}\big)\\
&\quad + \underbrace{cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\,+\,sin(\alpha ')\,sin\Big(\dfrac{\varphi_1-\varphi_2}{2}}_{\color{blue}{\text{car   }cos(a-b)\;=\;cos\,a\,cos\,b\;+\;sin\,a\,sin\,b}}\big)\,\Big]\\
&\\
&=2\,A\cdot cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)
\end{align}`$   
<br>
$`\quad\boldsymbol{\mathbf{=\color{brown}{2\,A\cdot cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big) \cdot cos\Big(}\color{blue}{\underbrace{\color{brown}{\omega t - kx + \dfrac{\varphi_1+\varphi_2}{2}}}_{\text{pulsation }\omega\text{ inchangée}}}\color{brown}{\Big)}}}`$

-----------------------------------------

* L'*onde résultante*
   * est **harmonique**.
   * a la **même fréquence** $`\nu\,=\,\dfrac{\omega}{2\pi}`$ que les deux ondes initiales.
   
* L'**amplitude** de l'onde résultante est :   
  <br>
  **$`\boldsymbol{\mathbf{A_{résult.} = \left| \,2\,A\cdot cos\Big(\dfrac{\varphi_1 - \varphi_2}{2} \Big) \,\right|}}`$**   
  <br>
  $`\quad\quad\quad=\sqrt{4\,A^2 \cdot cos^2\Big(\dfrac{\varphi_1 - \varphi_2}{2}\Big)}`$   
  <br>
  $`\color{blue}{\scriptsize{\left.\begin{align} \quad\quad &cos(a+b)=cos(a)cos(b)-sin(a)sin(b)\\
                     &cos(a-b)=cos(a)cos(b)+sin(a)sin(b)\end{align}
               \right\}\Longrightarrow\\
        \quad\quad cos^2(a)=cos(a)cos(a)=\dfrac{1}{2}[cos(a+a)+cos(a-a)]\\
        \quad\quad\quad\quad=\dfrac{1}{2}[1 + cos(2a)]}}`$   
   <br>
   $`\boldsymbol{\mathbf{\quad\quad \color{brown}{=\sqrt{2\,A^2 \cdot \big(1 + cos\,(\varphi_1 - \varphi_2)\big)}}}}`$

<br>


@@@@@@@@@@@@@@@@@@

* La figure ci-dessus est la **représentation symbolique des interférences** créées par la 
  *superposition de deux ondes circulaires synchrones*, de même amplitude mais en opposition de phases à leurs sources.

* L'*interprétation des couleurs* se rapproche de l'expérience de la cuve à onde.
    * zone du **bleu le plus foncé** : *valeur maximale* pour l'élongation de l'onde résultante.   
      _(crêtes des vaguelettes observées)._
    * zone du **bleu le plus clair** : *valeur minimale*.
      _(creux des vaguelettes observées)._
    * zone de **bleu moyen** : *élongation nulle*.

  * On discerne des **lignes stationnaires** sur lesquelles l'*élongation EST nulle*.    
    Elles correspondent à des zones qui restent non perturbées.
    

<!----------------
!!! déphasées de $`/pi`$ à leurs sources
!!! <details markdown=1>
!!! <summary>Représentation symbolique des interférences créées par deux ondes sphériques.<br>
!!! </summary>
!!! La figure représente les interférences de deux ondes progressives sphériques $`U_1(\vec{r},t)`$ et $`U_1(\vec{r},t)`$, synchrones mais 
!!! déphasées de $`/pi`$ à leurs sources en $`S_1`$ et $`S_2`$.
!!! Afin de mieux visualiser le phénomène, la modélisation des sources sphériques n'est pas physique. 
$`U(\vec{r},t)=U_0\cdot\cos(k r-\omega t)`$ au lieu de $`U(\vec{r},t)=\dfrac{U_0}(r}\cdot\cos(kr-\omega t)`$ 
pour une onde progressive sphérique se propageant dans l'espace. Pour une onde sphérique réelle non amortie, 
la décroissance en $`1/r`$ de l'amplitude de l'onde à partir de sa source en $`r=0`$ permet la conservation de
l'énergie. 
Considérons une onde dont la puissance transportée 
En effet, au cours de sa progression, l'intensité $`I_O`$ proportionnelle en tout point à $`U_O^2`$ ontenue sur un front d'onde se répartie 
sur la surface $`4\pi r^2`$ sur une sphère de rayon croissant r au fur et à mesure de la progression.
de ra
Le modèle mathémait
!!! Même en absence de phénomène
!!! l'équation de propagation
!!! </details>


* Une onde projette de l'énergie.

* Le **phénomène d'interférence** apparaît lors de la *superposition de plusieurs ondes* dans l'espace.

* Il y a interference lorsque la *distribution spatiale d'énergie résultante* d'une superposition d'ondes
  n'est **pas égale à** la *somme des distributions d'énergie propres à chaque onde* prise isolément.


---------------->



##### Que signifient "interférences constructives" et "interférence destructives" ?


##### Que représentent les noeuds et les ventres ?


##### Quelle lien entre interférences et ondes stationnaires ?

<br>

 
 <br><br>
 
![](sous-titre-ondes-diffraction_L1200.jpg)


#### Qu'est-ce que le phénomène de diffraction ?

Le phénomène de **diffraction** est *étalement des directions de propagation* dans l'espace de l'onde
lors de sa propagation *au-delà d'un obstacle ou à travers une ouverture* dans une paroi.   

Le phénomène de diffraction **dépend** à la fois de la *longueur d'onde $`\lambda`$* et de la
*taille  $`L`$ de l'obstacle* ou de l'ouverture rencontrée, et **s'accentue** lorsque le rapport 
*$`\dfrac{\lambda}{L}`$ croît*.

Il est particulièrement **observable** lorsque les valeurs de *$`\lambda`$ et $`L`$ sont voisines*.

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/diffraction-lambda-wave_L1000.gif)
_La diffraction d'une onde plane à travers une ouverture est négligeable lorsque_
_la longeur d'onde $`\lambda`$ est très inférieure à la taille de l'ouverture $`L`$,_
_et croît fortement lorsque $`\lambda`$ devient du même ordre de grandeur que $`L`$._

![](https://m3p2.com/fr/temporary_ins/waves/n3/overview/diffraction-width-split_v2_L1000.gif)
_La diffraction d'une onde plane à travers une ouverture est négligeable lorsque_
_la taille $`L`$ de l'ouverture est très supérieure à la longueur d'onde $`\lambda`$,_
_et croît fortement lorsque $`L`$ devient du même ordre de grandeur que $`\lambda`$._
 
 <br>
 
 
#### Qu'est-ce que le principe d'Huygens-Fresnel ?

A faire
 
 <br>



---

En attente pour effet doppler

![](wave-doppler-forward-1_L900.gif)

serait mieux si c'était la source qui se déplace..

Source et détecteur immobiles dans le milieu

![](waves-doppler-immob_1ok_L900.gif)

![](waves-doppler-immob_2ok_L900.gif)


<!--Grand chapitre ## : Les ondes en général<br> des propriétés observées au phénomène ondulatoire--->




