---
title: Les Ondes
published: true
routable: true
visible: false
lessons:
    -   
      slug: classical-corpuscules-and-waves
      name: PARALLELE : Mécanique de Newton, corpuscules et ondes
      order: 3
    -   
      slug: from-classical-world-to-wave-corpuscular-duality
      name: PARALLELE : des ondes et corpuscules à la dualité onde-corpuscule
      order: 2
    - 
      slug: from-corpuscule-to-mechanical-wave-3
      name: PARALLÈLE particule et onde.
      order: 3
    -   
      slug: waves-3
      name: LINÉAIRE : Ondes
      order: 2
---
$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Contreforts :&nbsp; _physiciens_

---------------------------

*Physique classique :*

#### L'onde et la description de sa propagation

<br>


RÉSUMÉ
: ---   

  *Le concept d'onde, et ses propriétés*    
  
  __Onde mécanique__ : perturbation d'un milieu matériel, caractérisé par une grandeur <!--ou une propriété--> physique scalaire $`\eta`$ ou vectorielle
  $`\vec{\eta}`$, qui s'étend de proche en proche sur des distances souvent bien plus grandes
  que l'amplitude de déplacement $`\delta`$ de chaque particule du milieu autour de sa position d'équilibre.
  * Onde __transversale__ : déplacement local du milieu perturbé perpendiculaire à la direction de propagation.
  * Onde __longitudinale__ : déplacement local du milieu perturbé parallèle à la direction de propagation.
  * Onde __progressive__ : la perturbation se propage sur de grandes distances.
  * Onde __stationnaire__ : la perturbation ne se propage pas, résulte de la superposition d'ondes progressives.

  __Représentation mathématique__ un champ $`U`$ obligatoirement dépendant du temps,
  scalaire $`U(\vec{r},t)`$ ou vectoriel $`\overrightarrow{U}(\vec{r},t)`$

  __Propriétés des ondes mécaniques__
  * __Non localisée__ : fonction spatialement étendue.
  * __Transport d'énergie__. 
  * __Pas de transport de matière__ au delà de $`\delta`$.
  * Dans un milieu matériel,
     * le __phénomène de diffraction__ observé lorsqu'une onde mécanique rencontre un obstacle.
     * le __phénomène d'interférence__ peut être observé en présence de deux ondes.
  * À l'interface entre deux milieux de caractéristiques différentes,
     * le __phénomène de réflexion__, totale ou partielle, observé lorsque l'onde atteint l'interface.
     * le __phénomène de réfraction__ observé lorsque l'onde traverse l'interface.

  Le concept d'__onde__ s'élargit à tout phénomène conduisant aux propriétés des ondes mécaniques.
  * __Onde électromagnétique__ : Propagation du champ électromagnétique dans le vide ou dans la matière.
  * __Onde gravitationnelle__ : Propagation d'une perturbation dans la géométrie de l'espace-temps 
                de la relativité générale d'Einstein. Ne se traite pas dans le cadre de la physique classique.

  __Célérité__ $`v`$ : vitesse de propagation de l'onde progressive.<br>
  $`\mathscr{v} = \dfrac{\Delta \mathscr{l}}{\Delta t}`$, avec $`\Delta \mathscr{l}`$ distance parcourue par l'onde pendant la durée  $`\Delta t`$.

  -----------------------

  *L'onde périodique*   
  __Onde périodique__ : en tout point de l'espace de vecteur position $`\vec{r}`$ et à tout instant $`t`$, la perturbation $`U(\vec{r},t)`$ du milieu se répète à intervalles de temps réguliers :   
  $`U(\vec{r},t) = U(\vec{r}\,,\; t+n\times T)`$, avec $`n\in\mathbb{Z}`$ et $`T`$ une durée.    

  * __Propriété fondamentale__ de l'onde périodique : sa propriété temporelle décrite par les grandeurs physiques équivalentes :
      * La __période temporelle__ $`T`$ de l'onde (d'appellation commune : "période"), <br>
                   homogène à un temps : unité S.I., la "seconde" (notation $`s`$)..
      * La __fréquence temporelle__ $`\nu`$ $`\; = 1\,/\,T`$ : inverse de la période temporelle, <br> 
                   homogène à l'inverse d'un temps : unité S.I., le "hertz" (notation $`s^{-1}\equiv Hz`$) 

  * __Propriétés du milieu__ : On se limitera à la célérité $`\mathscr{v}`$
     * milieu __linéaire__ (noté L) : en présence de plusieurs ondes, la perturbation de milieu est égale à
                           la somme des perturbations induites par chaque onde en absence des autres
                           (principe de superposition).
     * milieu __homogène__ (noté H) : $`\mathscr{v}`$  ne dépend pas de la position dans le milieu.
     * milieu __isotrope__ (noté I) : $`\mathscr{v}`$  ne dépend pas de la direction de propagation de l'onde.  
     * milieu __dispersif__ : la célérité dépend de la fréquence temporelle de l'onde :
     $`\mathscr{v} = \mathscr{v}(\nu) = \mathscr{v}(T)`$
     * milieu __non dispersif__ : la célérité de dépend pas de la fréquence temporelle de l'onde.
     
  * __Propriété de l'onde dans un milieu LHI__  : sa propriété spatiale décrite par les grandeurs physiques équivalentes :
      * La période spatiale appelée __longueur d'onde__ $`\lambda`$, <br>
                   homogène à une longueur : unité S.I., le "mètre" (notation $`m`$), ou ses unités multiples
                   (kilomètre "$`km`$", ...) ou sous-multiples (millimètre "$`mm`$", micromètre "$`\mu m`$", 
                    nanomètre "$`nm`$",... )
      * La __fréquence spatiale__ $`1/\lambda`$ : inverse de la longueur d'onde, <br> 
                   d'unité S.I., le $`m^{-1}`$ et ses miultiples et sous-multiples.

    -----------------------
    
    *L'onde sinusoïdale*   
     Noms communs d'usage :   
     __onde sinusoïdale__ &equiv; __onde harmonique__ (&equiv; __onde monochromatique__ en optique).  
     
  *  Une onde se propageant en direction et sens d'un vecteur unitaire $`\vec{n}`$ :
     s'écrit $`U(\vec{r},t) = U_0 \cdot \cos(\,\vec{k}\cdot\vec{r} \;\mathbf{-}\; \omega t + \varphi)`$, avec
     * $`U(\vec{r}, t)`$ : __élongation__ en $`\vec{r}`$ et $`t`$
     * $`U_0`$ : __amplitude__ = élongation maximum
     * $`\vec{k}\cdot\vec{r}-\omega t + \varphi`$ : __phase__ en $`\vec{r}`$ et $`t`$
     * $`\vec{k} = k\,\vec{n}`$ : __vecteur d'onde__, avec :<br>
       &nbsp;&nbsp; k : __nombre d'onde__, d'unité S.I. $`rad\,m^{-1}`$, <br>

  * __Propriété fondamentale__ : aux propriétés temporelles $`T`$ et $`\nu`$ s'ajoute la pulsation $`\omega`$
       d'unité S.I. le radian par seconde ($`rad\,s^{-1}`$) et telle que :   
       $`\omega = 2\pi\,\nu = \dfrac{2\pi}{T}`$

  * __Propriété dépendante du milieu__ la propriété spatiale "vecteur d'onde" $`\vec{k}`$,
     s'ajoute à $`\lambda`$ en précisant la direction et le sens de propagation.

  * Relations entre propriétés :   
    $`k = \dfrac{2\pi}{\lambda} = \dfrac{2\pi}{\mathscr{v} T} = \dfrac{2\pi\,\nu}{T} = \dfrac{\omega}{\mathscr{v}}`$

  * Cas d'une onde unidimensionnelle : $`U(\vec{r}, t) = U_0\cdot \sin(kx \;\mathbf{-}\; \omega t + \varphi)`$
  
  * Onde sinusoïdale se propageant en sens inverse de $`\vec{n}`$ :   
       $`U(\vec{r}, t) = U_0\cdot \sin(\,\vec{k}\cdot\vec{r} \;\mathbf{+}\; \omega t + \varphi)`$

  * Intérêt : vient du __théorème de Fourier__ :
     * Toute onde périodique se décompose en une somme discrète d'onde sinusoïdales.
     * Toute onde (quelconque) se décompose en une somme intégrale d'onde sinusoïdales
  
 

<br>

-----------------

Liste des questions et figures à faire... dans le désordre ...


#### Qu'est-ce qu'une onde ?

* Notre représentation intuitive du phénomène ondulatoire vient des ondes matérielles.

* Une **onde mécanique** est la *perturbation d'un milieu matériel* caractérisé par une 
  grandeur physique qui *s'étend de proche en proche* sur des distances souvent bien plus 
  grandes que l'amplitude de déplacement δ de chaque particule du milieu autour
  de sa position d'équilibre.   
  Cette perturbation, qui implique de l'énergie, est *générée par un phénomène physique localisé*
  dans l'espace, appelé **source** de l'onde.

* Ce qui caractérise une onde mécanique :
   * décrite par un champ dépendant du temps,    
      $`\Longrightarrow`$ elle n'est *pas localisée*.
   * L'onde *transporte de l'énergie*. 
   * L'onde *ne transporte pas de matière*. 

* Suivant la nature de la grandeur physique décrivant l'onde, on qualifie :
   * **onde scalaire** : la grandeur physique est scalaire.   
     _&ndash;&nbsp; hauteur d'une vaguelette à la surface de l'eau, la source étant le point d'impact du cailloux jeté._   
     _&ndash;&nbsp; densité volumique de l'air, la source sonore étant la membrane de l'enceinte qui comprime_   
     _puis détend alternativement l'air en son voisinage._
     _&ndash;&nbsp; ..._
   * **onde vectorielle** : la grandeur physique est vectorielle.
     _vecteur déplacement des atomes constituant la matière, ..._
   * **onde tensorielle** : la grandeur physique est tensorielle.   
     _contrainte, déformation, ..._
    
* Le *concept d'onde s'étend* à des grandeurs physiques sans lien avec la matière.
   * **Ondes électromagnétiques** : propagation du champ électromagnétique $`\big(\vec{E},\vec(B)\big)`$ 
     dans le vide.
   * **Ondes gravitationnelles** : propagation d'une déformation de l'espace-temps représentée
     par sa grandeur physique "métrique" qui décrit localement les propriétés géométriques de l'espace et du temps.


##### Onde unidimensionnelle : sur une ligne.

* Exemple : La perturbation de la corde tendue d'une guitare.


##### Onde bidimensionnelle (2D) : sur une surface, <br> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; tridimensionnelle (3D) : dans l'espace.

* Exemple d'onde bidimensionnelle : vaguelettes à la surface de l'eau.
* Exemple d'onde tridimensionnelle : une onde sonore.

![représentation 2D d'ondes diverses 2D et 3D](different-waves-2.gif)

* La figure représente différents types d'ondes (2D ou 3D) :   
   d) onde quelconque
   e) onde plane progressive.
   f) onde sphérique progressive.
   g) onde stationnaire.


##### Quelle différence entre une onde longitudinale et une onde transverse ?




##### Quelle différence entre une onde progressive et une onde stationnaire ?

<br>
* **Onde progressive**   
  <br>
  **Couplage** entre les *coordonnées d'espace et de temps* de la forme :   
  * Pour une onde scalaire unidimensionnelle :  
    <br>
    **$`\mathbf{\large{U(x,t) = f(\,\pm\, x \pm \mathbf{\mathscr{v}} t)}}`$**

<br>
* *Onde stationnaire*   
  <br>
  **Séparation** des *coordonnées d'espace et de temps* dans deux fonctions différentes.   
  Résulte d'une superposition d'ondes progressives.
  * Pour une onde scalaire unidimensionnelle :  
    <br>
    *$`\mathbf{\large{U(x,t) = f(x)\times g(t)}}`$*
    <br>

  
#### Qu'est-ce que la célérité d'une onde ?




----------------------------------

#### Qu'est-ce que l'équation de d'Alembert ?

* Écriture d'une onde scalaire unidimensionnelle dans un système de coordonnées spatiale et temporelle $`(x,t)`$ :   
  <br>
  **$`\mathbf{\large{\dfrac{\partial^2 U\normalsize{(x,t)}}{\partial x^2}\,-\,\dfrac{1}{\mathscr{v}}\cdot\dfrac{\partial^2 U\normalsize{(x,t)}}{\partial t^2}= 0}}`$**

* Pour une onde scalaire tridimensionnelle dans un système de coordonnées cartésiennes et temporelle $`(x,y,z,t)`$ :   
  <br>
  $`\left(\dfrac{\partial^2 U(x,t)}{\partial x^2}\,+\dfrac{\partial^2 U(x,t)}{\partial y^2}
  \,+\dfrac{\partial^2 U(z,t)}{\partial x^2}\right)`$
  $`\,-\,\dfrac{1}{\mathscr{v}}\cdot\dfrac{\partial^2 U(x,t)}{\partial t^2}= 0`$   
  <br>
  ou en écriture vectorielle (indépendante du système de coordonnées choisi) :   
  <br>
  **$`\mathbf{\large{\Delta U}\normalsize{(x,t)}\large{\,-\,\dfrac{1}{\mathscr{v}}\cdot\dfrac{\partial^2 U\normalsize{(x,t)}}{\partial t^2}= 0}}`$** 
  


-------------------------------


#### Qu'est-ce qu'une onde périodique ?



#### Quelles sont les grandeurs fondamentales décrivant une onde périodique ?



#### Quelles sont les grandeurs décrivant une onde périodique qui dépendent du milieu de propagation ?


---------------------------


#### Quelle différence entre un milieu dispersif et un milieu non dispersif ?



#### Qu'est-ce que la relation de dispersion d'un milieu ?

------------------------------------------

#### Qu'est-ce qu'une onde progressive sinusoïdale ?



#### Comment décrire mathématiquement une onde progressive sinusoïdale ?


##### L'équivalence des fonctions sinus et cosinus.


##### L'écriture en notation complexe.



#### L'onde progresive sinusoïdale est-elle physiquement réaliste ?



#### Quel est l'intérêt de l'onde sinusoïdale ?

* L'onde sinusoïdale peut être vue comme une **brique** qui, en tout point $`\vec{r}`$ de l'espace et par superposition, 
  *permet de reconstruire toute onde* $`U(\vec{r},t)`$ grâce au **théorème de Fourier**.

#### Qu'est-ce que le théorème de Fourier ?

* **Théorème fondamental** qui intervient dans *tous les domaines de la physique*.

* Il précise que **toute fonction périodique** $`f(t)`$ peut s'exprimer comme une *somme discrète*
  *d'ondes sinusoïdales* de différentes fréquences et phases à l'origine.    
  <br>
  Expression pour une onde périodique unidimensionnelle de variable d'espace $`x`$ :   
  <br>
   * en notation réelle :   
     $`\displaystyle f(t) = f_0(t) + \sum_{n=1}^{\infty} F_n\,\cos(2\pi\,\nu\,t\,+\,\phi_n)`$  

   * en notation complexe :   
     $`\displaystyle f(t) = \sum_{n=1}^{\infty} F_n\,\exp(i\,2\pi\,\nu\,t\,+\,\phi_n)`$ 

* Il précise que **toute onde* $`f(t)`$ peut s'exprimer comme une *somme intégrale*
  *d'ondes sinusoïdales* de différentes fréquences et phases à l'origine.    
  <br>
  Expression pour une onde périodique unidimensionnelle de variable d'espace $`x`$ :   
  <br>
   * en notation complexe :   
     $`\displaystyle f(t) = \int_{-\infty}^{+\infty} F(\nu)\,\exp(i\,2\pi\,nu\,t\,+\,\phi_n) d\nu`$ 
  






<br>
* Il précise que **toute onde non périodique** peut s'exprimer comme une 
  *somme intégrale d'ondes sinusoïdales* de différentes fréquences et phases à l'origine.


<br>
* Ce théorème a aussi des expressions semblables pour les ondes bi et tridimensionelles.


#### Qu'est-ce que le spectre d'une onde ?


------------------------------------------------

#### Quelles sont les phénomènes propres aux ondes ?

* C'est phénomène ne sont pas décrit par la physique classique appliquée aux corps et corpuscules.

* Lorsque *une ou plusieurs ondes* se propagent dans *un même milieu* :

   * Le phénomène d'**interférence** peut être observé en présence de plusieurs ondes.
     
   * Le phénomène de **diffraction** peut être observé lorsqu'un obstacle pertube la propagation d'une onde.

* Lorsque *une onde* rencontre une *interface entre deux milieux différents*

   * Le phénomène de **réflexion**  peut être observé.
   * Le phénomène de **réfraction** peut être observé lorsque l'onde traverse l'interface.
   * 
   
--------------------------------------------

##### Qu'est-ce que deux ondes synchrones ?



#### Qu'est-ce que le phénomène d'interférence ?

![interférences entre deux ondes sphériques d'égale amplitiudes et déphasées de pi,
et propagation des zéros](2_sources_circulaires_dephasees_pi_v2_L1000.gif)






#### Qu'est-ce que le principe de superposition ?

* Il s'applique si dans un milieu toute onde créée par une source n'est pas modifiée par la présence 
  ou non d'autres ondes créées par d'autres sources.

* Dans ce cas, en présence de nombreuses onde, l' **élongation résultante** en tout point de l'espace et à tout instant s'exprime
  comme la *somme des élongations* induites par chacune *des ondes individuelles* (comme si elles
  étaient seules) en présence.   
  
* Expression mathématique du **principe de superposition** :      
  Soient $`n`$ ondes notées $`U_i(\overrightarrow{r},t)\;(avec i\in\{1,\dots,n\})`$, 
  l'onde totale résultante $`U_{tot}(\overrightarrow{r},t)`$ s'écrit :   
  <br>
  **$`\mathbf{\displaystyle\large{U_{tot}(\overrightarrow{r},t) = \sum_{i=1}^{n} U_i(\overrightarrow{r},t)}}`$**



##### Comment reconnaître le phénomène d'interférence ?


##### Que signifient "interférences constructives" et "interférence destructives" ?


##### Que représentent les noeuds et les ventres ?


##### Quelle lien entre interférences et ondes stationnaires ?



![waves_interferences_ventres_noeuds](waves_interferences_ventres_noeuds_niv_3a_L1200.gif)

niveau 2


--------------------------------------------

#### Qu'est-ce que le phénomène de diffraction ?

à faire

![](diffraction-lambda-wave_L1000.gif)

![](diffraction-width-split_v2_L1000.gif)

--------------------------------------------

#### Quelle différence entre interférence et diffraction ?

* Il n'y a pas de différence.

* Les deux phénomènes sont liés à la distribution spatiale d'amplitude ou d'intensité d'une onde
  résultante créée par un ensemble fini de sources synchrones, ou cohérentes (ondes lumineuses).
   * le terme **interférence** est utilisé quand les sources qui interfèrent sont des **sources discrètes**.   
     _exemple : figure d'interférence de deux fentes très fines._
   * le terme **diffraction** est utilisé quand les *sources forment un continuum*.   
     _exemple : figure de diffraction d'une fente large._

* Interférence et diffraction agissent toujours ensemble.   
     _exemple : figure d'interférence et de diffraction de deux fentes larges._
  


#### Qu'est-ce que le principe de Fresnel-Huygens ?

 * Enoncé : 
   
 * Domaine de validité :
    * donne une distribution d'intensité très proche de celle observée en réalité,
      lorsque celle-ci est calculée suffisamment loin des fentes
 * permet de calculer la figure de diffraction-interférence observée derrière un écran opaque
   percé de fentes et éclairé par une source cohérentes.
 * Lien avec la physique :


--------------------------------------------

#### Qu'est-ce que le phénomène de réflexion ?

à faire



--------------------------------------------

#### Qu'est-ce que le phénomène de réfraction ?


![refraction d'une onde plane sur un dioptre plan](wave-optics-n3-refraction-1_v2_L1000.gif)











<!-------------



#### Quels phénomènes sont caractéristiques d'une onde ?

![waves-sinusoide-lambda-n3_L1200](waves-sinusoide-lambda-n3_L1200.gif)

figure à transférer en niveau 2

...



#### Qu'est-ce que le phénomène de réfraction ?


#### Qu'est-ce qu'une onde périodique ?


#### Qu'est-ce que le phénomène d'interférence ?



#### Qu'est-ce qu'une onde stationnaire ?




![waves_interferences_ventres_noeuds](waves_interferences_ventres_noeuds_niv_3a_L1200.gif)

niveau 2


#### Quelles sont les différentes grandeurs physique caractérisant une onde périodique ?

![refraction d'une onde plane sur un dioptre plan](wave-optics-n3-refraction-1_L1000.gif)

niveau 2 reprise au 3?


------------>


