---
title: Les ondes
published: false
routable: false
visible: false
lessons:
    -
      slug: waves-2
      name: LINÉAIRE-2 : Les Ondes
      order: 2
    -
      slug: panorama-waves-23
      name: PANORAMA-23 : Les ondes
      order: 1
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$


*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-1_L1200.jpg)<details>
<summary>Etape 1 : Appel à idées</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Randonnée Colline

---------------------------

<details markdown=1>
<summary>Consignes de conception et de rédaction</summary>
Réfléchir à un ordre logique de questions, et leur réponse, de niveau lycée.   
Cet ordre sera repris dans la partie main pour un déveoppement plus traditionnel et chapitres et sous-chapitres.   
Doit-être abordés tous les points concernant les ondes, lever toutes les ambiguïtés et fixer 
le vocabulaire.   
L'outil mathématique se limitera aux fonction trigonométriques. L'apport de la notation complexe pour la maîtrise sera la valeur ajoutée du niveau 3.
</details>   
<br>
<!--Grand chapitre ## : Les ondes mécaniques<br> du phénomène ondulatoire aux propriétés de l'onde--->


<!--! sous chapitre # : LES  ONDES  MÉCANIQUES-->
<!--! sous chapitre ## : La nature des ondes mécaniques-->

![](titre-ondes_L1200.jpg)

![](sous-titre-ondes-mecaniques_L1200.jpg)

#### Qu'est-ce qu'une onde mécanique ?

* Dans l'expression **ondes mécaniques**, le terme mécanique fait référence à un *milieu matériel*.

* Un **milieu matériel** est composé de *particules matérielles* (atomes, molécules) qui interagissent entre elles. 
  Ce milieu peut être solide, liquide ou gazeux.

* Un **milieu à l'équilibre** signifie que chaque particule occupe une position d'*équilibre stable* 
  où les *forces* qui s'exercent sur elle *s'annulent*.

* Une **perturbation** se produit lorsqu'une *particule* est *temporairement déplacée* 
  de sa position d'équilibre.

   * **Après la perturbation**, la stabilité de l'équilibre signifie que les forces agissent pour 
     ramener la particule à sa position d'équilibre, créant une *force de rappel*.
   * À cause de son *inertie*, la particule dépasse souvent sa position d'équilibre 
     avant d'être ramenée. Cela crée un **mouvement d'oscillation** qui s'atténue progressivement.

* La **particule déplacée** perturbe l'équilibre des particules voisines, devenant 
  ainsi elle-même une **source de perturbation**. Son *mouvement d'oscillation se transmet* 
  aux particules voisines avec un *léger retard* dû à leur inertie et une *légère atténuation*.

* Ainsi, la **perturbation se propage** :
   * *dans l'espace*, d'une particule à l'autre.
   * *dans le temps*, en raison du retard de mouvement d'une particule à ses voisines.

* Une **onde mécanique** est l'expression qui décrit le phénomène de *propagation 
  d'une perturbation* dans un *milieu matériel*.


#### Pourquoi se limiter d'abord aux ondes mécaniques ?

* Des **phénomènes observés dans ondes mécaniques**, comme la diffraction et les interférences,
 sont **communs à tout type d'ondes** et **propres aux ondes**, y compris celles 
  qui sont moins intuitives comme les ondes électromagnétiques, gravitationnelles, ou de probabilité.

   * Les *ondes électromagnétiques* se propagent dans le vide, sans milieu matériel.
   * Les *ondes gravitationnelles* sont des perturbations de l'espace-temps lui-même.
   * Les *ondes de probabilité* décrivent la propagation de la probabilité de présence 
     d'une particule, matériel comme l'électron ou non matériel comme le photon, dans un état donné.

* Dans un premier temps,   
les **ondes mécanique, plus intuitives**, permettent de *mieux s'approprier les phénomènes ondulatoires* 
(diffraction, interférences).    
Puis,    
**L'observation de ces phénomènes** permet d'*identifier la nature ondulatoire* de l'origine de ces phénomènes.


#### Que transporte une onde mécanique ?

* Une *onde transporte* de l'**énergie** et de la **quantité de mouvement** sur 
  de longues distances, car elle met en mouvement de la matière dans le milieu perturbé.   
_Par exemple, un bouchon flottant sur l'eau se met à osciller verticalement lorsqu'il_
_est atteint par des vaguelettes, même s'il est loin du point d'impact._

* Cependant l'*onde ne transporte* **pas de matière**, car les particules oscillent 
  simplement autour de leur position d'équilibre.   
 _Le bouchon n'est pas transporté par la vague sur de longues distances, il oscille sur place._


#### Quels sont les acteurs d'une onde mécanique ?

* Une onde mécanique implique généralement **trois acteurs** avec des *rôles distincts* : la source, le milieu et le capteur.
   * La **source S** impose la *perturbation* au milieu matériel.
   * Le **milieu matériel** *propage* cette perturbation à une *vitesse dépendant du milieu*, vitesse mesurée par un observateur M immobile dans ce milieu.
   * Le **capteur C** détecte la perturbation.


#### Qu'est-ce qui détermine la vitesse de propagation ?

à faire, dépend du milieu.

Jusqu'à quel niveau de détail aller à ce niveau 2? 


<br><br>

![](sous-titre-ondes-electromagnetiques_L1200.jpg)

à faire


<br><br>

![](titres_ondes-ecrire-caracteriser_L1200.jpg)

![](sous-titre-ondes-ecriture-mathematique_L1200.jpg)


#### Comment décrire mathématiquement une perturbation ?

* A l'**échelle atomique**, les particules du milieu matériel sont les atomes. 
  La *taille caractéristique* de cette échelle est l'*angström*, le dixième de nanomètre.  
  Les **atomes sont disjoints**, même s'ils sont liés dans les solides et liquides.   
<br>
La *plupart des observations* se font à une **échelle bien plus grande**.   
_Par exemple, la plus petite taille visible à l'œil nu est d'environ un dixième_
_de millimètre, soit un million de fois plus grande qu'un angström._    
<br>
Ainsi dans la description physique d'une onde, on appelle **"particule de matière"** 
le *plus petit volume observable* à l'échelle considérée. À moins de travailler 
à l'échelle atomique, ces volumes qualifiés d'élémentaires se touchent, et donc
les "particules" sont **jointives**.    
<br>
La *perturbation* est alors décrite par une **fonction mathématique $`\phi`$ continue** 
dans l'espace et le temps :   
<br>
$`\phi = \;`$**$`\boldsymbol{\mathbf{\phi(\alpha,\beta,\gamma,t)}}`$**   
&nbsp;&nbsp;&nbsp;&nbsp;où les coordonnées spatiales $`(\alpha,\beta,\gamma)`$ sont des nombres réels.

!!!! *Attention :* Les *coordonnées spatiales* indiquent la *position d'équilibre* de la particule,    
!!!! et non sa position perturbée par l'onde au cours du temps.


#### Peut-on simplifier cette description mathématique?

* L'**univers** présente **trois dimensions spatiales**. Dans un système de coordonnées spatiales,
  tout point peut être précisé par la donnée de trois nombres réels $`(\alpha,\beta,\gamma)`$.

* Une **onde matérielle** se propage nécessairement dans un *volume limité*, et présente une certaine *forme*.

* Parfois **à l'échelle d'observation**, une *forme* apparaît comme une **surface**dont l'épaisseur est invisible.   
  <br>
  Dans ce cas, la dimension spatiale de l'épaisseur peut être négligée. 
  <br>
  Un *système adapté de coordonnées* spatiales permet alors de repérer tout
  point de la surface avec **seulement deux coordonnées**. La fonction prend alors la forme :   
  <br>
  $`\phi = \;`$**$`\boldsymbol{\mathbf{\phi(\alpha,\beta,t)}}`$**

* Parfois **à l'échelle d'observation**, une *forme* apparaît comme une **ligne**dont la section droite est invisible.   
  <br>
  Dans ce cas, les deux dimensions spatiale de la section peuvent être négligées. 
  <br>
  Un *système adapté de coordonnées* spatiales permet alors de repérer tout
  point sur la ligne avec **seulement une coordonnée**. La fonction prend alors la forme :   
  <br>
  $`\phi = \;`$**$`\boldsymbol{\mathbf{\phi(\alpha,t)}}`$**


#### Comment décrire physiquement une perturbation ?

##### Onde mécanique

* La *perturbation* d'une onde mécanique correspond, en chaque point de l'espace, 
  à un **déplacement** de matière par rapport à sa position d'équilibre. Ce déplacement 
  peut être décrit par :
   * une *fonction scalaire $`\phi`$* qui donne une distance ou **longueur**.
   * une *fonction vectorielle $`\vec{\phi}`$* qui donne un vecteur avec une **norme** 
     représentant la **longueur** et une **direction** indiquant le sens du déplacement.

* L'aspect oscillatoire du déplacement par rapport à l'équilibre peut entraîner des 
  variations de **densité volumique** dans le milieu de propagation _(comme pour le son dans l'air)_.
  Dans ce cas :
    *la fonction $`\phi`$ est scalaire et représente une **densité volumique**.

* D'*autres grandeurs physiques* peuvent être utilisées si elles permettent la *mesure de l'onde*.


##### Onde électromagnétique

à faire


#### Comment décrire mathématiquement la propagation ?

 A faire
 
 <br><br>
 
 ![](sous-titre-ondes-caracterisation_L1200.jpg)
 
 
#### Quelle différence entre onde et signal ?

* une **onde** est un *phénomène naturel* de *propagation dans l'espace et le temps*.

* un **signal** est une *codage temporel intentionnelle d'information*, qui *utilise une onde pour se transmettre* d'un point à un autre de l'espace.

<!--Texte ci-dessous pas convainquant. A retravailler..._
!! <details markdown=1>
!! <summary>*Pour aller plus loin :* signal analogique ou numérique</summary>
!!
!! * Un *signal* est *analogique* si il est *mesurable à tout instant* et peut prendre 
!! comme *valeur tout nombre réel*.<br>
!! Cette définition intuitive est toutefois incomplète. <br>
!! Mathématiquement, la fonction représentative est une *fonction dérivable* (et donc continue) 
!! définie de $`mathbb{R}`$ (représentant le temps) dans $`mathbb{R}`$ (représentant la 
!! grandeur physique codant l'information).
!!
!! * Un *signal* est *numérique* est un signal discontinu (discret) qui ne peut prendre 
!! qu'un nombre fini de valeur, par exemple soit 0 soit 1 pour un signal binaire.
!! Cette définition intuitive est toutefois incomplète. <br>
!! Mathématiquement, la fonction représentative est une *fonction non dérivable* à valeurs 
!! discontinues (discrètes).
!! </details markdown=1>
-------------->


#### Qu'est-ce qu'un milieu homogène et isotrope ?

à faire


![](sous-titre-ondes-periodiques_L1200.jpg)


* Le **milieu** considéré est en général *homogène et isotrope*.

#### Qu'est-ce qu'une onde périodique?

* Une **onde périodique** est la décomposition de l'onde en un *plus petit motif qui se répète* de façon jointive.


##### Point de vue de la source ou d'un capteur.

* La *source* ou le *capteur* d'une onde est *localisé* en un point donné de l'espace, l'**onde** est représentée alors par une simple **fonction dépendant du temps : $`\Phi(t)`$*.

* On parle alors de la *périodicité temporelle*.

* Le plus petit **motif** est une *perturbation temporelle de forme donnée* définie sur un *intervalle de temps limité*.
   * L'intervalle de temps est appelée **période temporelle** de l'onde détectée, et se note en générale **$`T`$**.
   * La forme du motif est représentée par une fonction $`g_0(t)`$ définie sur $`T`$.

* L'onde détectée périodique est reconstruite en reproduisant le motif $`g_0(t)`$ à intervalles de temps réguliers $`\Delta t`$ égaux à la période temporelle : $`\Delta t = T`$.

_figure ou animation à faire_


##### Point de vue du milieu matériel

* A tout instant $`t`$, la perturbation du milieu est représentée uniquement par **fonction dépendant de coordonnées spatiales : $`\Phi(\alpha,\beta,\gamma)`$**.

* On parle alors de la **périodicité spatiale**.

* Le plus petit **motif** est une *perturbation spatiale de forme donnée* définie sur dans un *espace limité*.

* L'espace ayant trois dimensions, définir une périodicité spatiale nécessite de préciser un peu la forme spatiale de l'onde. *Deux formes simples d'onde* se distinguent, l'*onde plane* et l'*onde
sphérique* (3D) ou circulaire (2D).

##### *L'onde plane*

à faire

##### *L'onde sphérique (3D) ou circulaire (2D)*

à faire


#### Relation entre les deux points de vue.

à faire

Idée : de l'onde sphérique d'une source ponctuelle à l'onde plane observée à grande distance.


<br><br>

![](sous-titre-ondes-harmoniques_L1200.jpg)


#### Qu'est-ce qu'une onde harmonique ?

 A faire
 
 <br>

#### Quel est l'intérêt des ondes harmoniques ?

 A faire
 
 <br>

#### Comment caractériser une onde harmonique ?

 A faire
 
 <br>

#### Qu'est-ce que le principe de superposition des ondes ?


 A faire
 
 <br><br>
 
 
![](sous-titre-ondes-stationnaires_L1200.jpg)


#### Qu'est-ce qu'une onde stationnaire ?

 A faire
 
 <br>


#### Quelle différence entre onde progressive et onde satationnaire ?


 A faire
 
 
#### Où trouve-t-on des ondes stionnaires ?

A faire. Idées : instruments de musique. Cordes, et analogie avec tuyaux
 
 <br><br>
 
![](titre-ondes-copuscules-phenomenes-analogues_L1200.jpg)


À faire. Expliquer l'utilisation du terme "semblables", et pas du terme "communes".

![](sous-titre-effet-doppler_L1200.jpg)

#### Qu'est-ce que l'éffet Doppler ?

* L'*effet Doppler* décrit exprime le **décalage du durée** entre deux impulsions,
  mesuré **au niveau de la source et du capteur**.

* L'étude se limite au cas où *source et capteur* se déplacent sur une **même droite**,
  chacun à **vitesse constante**.

<!--
* Sur cette droite, le **détecteur** reste *toujours du même côté* de la source.
-->


#### L'effet Doppler pour les ondes mécaniques

ATTENTION !! PAS ENCORE PRÊT DU TOUT

* Il faut tenir compte de quatre instants :
    * **$`\mathbf{t_1}`$** l'instant où une *source émet* une *première impulsion*.
    * **$`\mathbf{t_1}'`$** l'instant où un *capteur détecte* cette *première impulsion*.
    * **$`\mathbf{t_2}`$**  l'instant où la *source émet* une *deuxième impulsion*.
    * **$`\mathbf{t_2}'`$** l'instant où le *capteur détecte* cette *deuxième impulsion*.   
   
   de trois vitesses, exprimées *par rapport au milieu matériel* :
    * **$`\mathbf{\mathscr{v}_{prop}}`$** la *vitesse de propagation des impulsions*.
    * **$`\mathbf{\mathscr{v}_{source}}`$** la *vitesse de la source*.
    * **$`\mathbf{\mathscr{v}_{capteur}}`$** la *vitesse du capteur*.

<!---
* L'effet ne sera pas le même selon que la source se rapproche du capteur ou s'en éloigne.    
  <br>
  Pour que l'*équation du décalage Doppler* soit *valable dans tous les cas*, les
  **vitesses** seront exprimées en **valeurs algébriques**, avec la convention suivante :   
  <br>
  Toute vitesse a une valeur :
   * **valeur positive** si la déplacement se fait dans le *sens* de la *source vers le capteur*.
   * **valeur négative** si la déplacement se fait dans le *sens* du *capteur vers la source*.
  Ainsi la vitesse de propagation sera toujours positives.
  ---->

figure à faire.

<!------
!!!!! *Terminologie : valeur algébrique et valeur absolue*
!!!!!
!!!!! à faire.
------>

##### Cas où $`\mathbf{\mathscr{v}_{capteur} \lt \mathscr{v}_{propag}}`$

* C'est le cas où l'**onde émise** par la source *atteint toujours le capteur*.   
<br>
Ceci implique donc que la **vitesse du capteur** est *inférieure 
à la vitesse de propagation* de l'onde.

* La *source émet* la **première impulsion à l'instant $`t_1`$**.   

figure à faire.

* Le *capteur détecte* cette **première impulsion à l'instant $`t_1'`$**, alors qu'il 
  est situé à la *distance $`d_{impuls.1}`$ de la source* au moment de l'émission 
  la première impulsion.  
<br>
$`d_{impuls.1}`$ est donc la distance parcourue par l'impulsion entre son instant 
$`t_1`$ d'émission et l'instant $`t_1'`$ où elle est détectée.    
<br>
Se propageant entre ces deux instants dans le milieu matériel à la vitesse $`\mathscr{v}_{prop}`$,
tu as la première relation :   
<br>
*$`d_{impuls.1} = \mathscr{v}_{prop}\times (t_1' - t_1)`$*   

Figure ou animation à faire

* La *source émet* une **seconde impulsion à l'instant $`t_2`$**.   
<br>
Figure ou animation à faire.  
<br>

* Le *capteur détecte* cette **seconde impulsion à l'instant $`t_2'`$**, alors qu'il
est situé à la *distance $`d_{impuls.2}`$ de la source* au moment où elle émet la seconde impulsion.   
<br>
$`d_{impuls.2}`$ est donc la distance parcourue par la deuxième impulsion entre son instant $`t_2`$
d'émission et l'instant $`t_2'`$ où elle est détectée. L'impulsion se propageant dans le milieu
matériel à la vitesse $`\mathscr{v}_{prop}`$, tu as une deuxième relation :   
<br>
*$`d_{impuls.2} = \mathscr{v}_{prop}\times (t_2' - t_2)`$*.   

<!----
   * Si les *directions* de la *source* et du *capteur* sont font en **sens opposées** :    
     la distance supplémentaire parcourue par la perturbation est $`d_{impuls.1}+d_{impuls.2}`$
* 
* **$`d_{impuls.2}`$** est donc la distance **$`d_{impuls.1}`$** à laquelle *il faut* : 
  * *soustraire la distance algébrique $`d_{source}`$* parcourue par la source pendant 
  la durée séparant l'émission des deux impulsions :   
<br>
 *$`d_{source}=\mathscr{v}_{source}\times (t_2 - t_1)`$*.
   * *ajouter la distance algébrique $`d_{capteur}`$*  parcourue par le capteur 
   pendant la durée séparant la réception deux impulsions :   
<br>
 *$`d_{capteur} = \mathscr{v}_{capteur}\times (t_2' - t_1')`$*.
<br>
<br>
Tu obtiens ainsi :   
<br>
**$`\mathbf{d_{impuls.2} = d_{impuls.1}`$***$`\, - d_{source} + d_{capteur}}`$*


$`\begin{align}
\underbrace{\mathscr{v}_{propag.}\cdot (t_2' - t_2)}_{\color{blue}{d_{impuls.2}}}&=
\underbrace{\mathscr{v}_{propag.}\cdot (t_1' - t_1)}_{\color{blue}{d_{impuls.1}}}\\
& \hspace{1cm} + \underbrace{\mathscr{v}_{source}\cdot (t_2 - t_1)}_{\color{blue}{d_{source}}}\\
& \hspace{2cm} +\underbrace{\mathscr{v}_{capteur}\cdot (t_2' - t_1')}_{\color{blue}{d_{capteur}}}
\end{align}`$

<br>
$`\begin{align}
\mathscr{v}_{propag.}\,t_2' - \mathscr{v}_{propag.}\,t_2 &= \mathscr{v}_{propag.}\,t_1' -  \mathscr{v}_{propag.}\,t_1\\
& \hspace{0.6cm} + \mathscr{v}_{source}\,t_2 - \mathscr{v}_{source}\,t_1\\
& \hspace{1.2cm} +\mathscr{v}_{capteur}\,t_2' - \mathscr{v}_{capteur}\,t_1'
\end{align}`$

<br>
$`\begin{align}
&\mathscr{v}_{propag.}\,t_2' - \mathscr{v}_{propag.}\,t_1' - \mathscr{v}_{capteur}\,t_2'+ \mathscr{v}_{capteur}\,t_1'\\
& \hspace{1cm} =  \mathscr{v}_{propag.}\,t_2 -  \mathscr{v}_{propag.}\,t_1 + \mathscr{v}_{source}\,t_2 - \mathscr{v}_{source}\,t_1 
\end{align}`$

<br>
$`\begin{align}
&\mathscr{v}_{propag.}\,(t_2' - t_1') - \mathscr{v}_{capteur}\,(t_2' - t_1') \\
&\hspace{1cm} = \mathscr{v}_{propag.}\,(t_2 - t_1) - \mathscr{v}_{source}\,(t_2 - t_1)
\end{align}`$

<br>
$`\begin{align}
& (t_2' - t_1')\; (\mathscr{v}_{propag.} - \mathscr{v}_{capteur})\\
&\hspace{1cm} = (t_2 - t_1)\;(\mathscr{v}_{propag.}- \mathscr{v}_{source})
\end{align}`$


<br>
$`\boldsymbol{\mathbf{(t_2' - t_1')= (t_2 - t_1)\cdot \dfrac{\mathscr{v}_{propag.}- \mathscr{v}_{source}}
{\mathscr{v}_{propag.} - \mathscr{v}_{capteur}}}}`$


<br>
##### Effet Doppler et ondes matérielles non-périodiques

à terminer : idée. onde matériel composée de deux impulsions émises aux instants $`t_1`$ et $`t_2`$,
onde de profil quelconque s'étendant à l'emission entre les deux  instants $`t_1`$ et $`t_2`$,
compression ou dilatation du profil de l'onde...


<br>
*$`\boldsymbol{\mathbf{\Delta t_{capteur}= \Delta t_{source}\cdot \dfrac{v_{propag.}
 -v_{source}}{v_{propag.} - v_{capteur}}}}`$*
 
 
 
!! *Pour aller plus loin : Effet Doppler et corpuscules*

à faire


<br>
##### Effet Doppler et ondes matérielles périodiques

à terminer 


* Ces **deux impulsions** représentent un même *trait caractéristique du motif 
temporel* d'une onde périodique, considérées *sur deux motifs consécutifs*.   
La durée entre ces deux impulsions représente alors la **période temporelle $`T`$ ** de l'onde :   
<br><br>
*$`\large\boldsymbol{\mathbf{T_{capteur}= T_{source}\cdot \dfrac{v_{propag.}
-v_{source}}{v_{propag.} - v_{capteur}}}}`$*   
<br><br>


* S'adressant à des ondes périodiques, l'**effet Doppler** s'exprime le plus souvent
en *fonction de la fréquence $`\nu`$* de l'onde :   
<br>
$`\big(T_{capteur}\big)^{-1}= 
\underbrace{
\Big(T_{source}\cdot\dfrac{v_{propag.}-v_{source}}{v_{propag.}-v_{capteur}}\Big)^{-1}
}_{
\color{blue}{(xy)^m = x^m\,y^m}
}`$   
<br><br>
$`\underbrace{\big(T_{capteur}\big)^{-1}}_{
\color{blue}{\nu = 1\,/\,T}}
= \underbrace{\big(T_{source}\big)^{-1}}_{
\color{blue}{\nu = 1\,/\,T}}
\cdot \left(\dfrac{v_{propag.}
-v_{source}}{v_{propag.} - v_{capteur}}\right)^{-1}`$   
<br>
<br>
**$`\large\boldsymbol{\mathbf{\boldsymbol{\nu_{capteur}= \nu_{source}\cdot \dfrac{v_{propag.}
-v_{capteur}}{v_{propag.} - v_{source}}}}}`$**
------------>

##### Quand observe-t-on cet effet Doppler ?

à faire

<br>

#### L'effet Doppler des ondes électromagnétiques

à faire.

<br><br>


![](sous-titre-ondes-reflexion_L1200.jpg)

#### Réflexion à une interface

À faire. Idées :  En terme d'onde, en terme de rebond, vers un lien dualité onde-corpuscule possible?
Lien avec l'optique géométrique et la loi de la réflexion.


<br><br>

![](sous-titre-ondes-refraction_L1200.jpg)

à concevoir

#### Réfraction à une interface

À faire. Idées :  Plus discutable, mais réel : trajectoire du photon, ou Pierre et Paul, à travers le Principe de Fermat  et vers la mécanique analytique lagrangienne. 
Lien avec l'optique géométrique et la loi de Snell-Descartes.


<br><br>

![](titre-ondes-phenomenes_L1200.jpg)

![](sous-titre-ondes-interference_L1200.jpg)

#### Qu'est-ce que le phénomène d'interférence ?

 A faire
 
 <br><br>
 
![](sous-titre-ondes-diffraction_L1200.jpg)


#### Qu'est-ce que le phénomène de diffraction ?

 A faire
 
 <br>
 
 
#### Qu'est-ce que le principe d'Huygens-Fresnel ?

A faire
 
 <br>



---

En attente pour effet doppler

![](wave-doppler-forward-1_L900.gif)

serait mieux si c'était la source qui se déplace..

Source et détecteur immobiles dans le milieu

![](waves-doppler-immob_1ok_L900.gif)

![](waves-doppler-immob_2ok_L900.gif)


<!--Grand chapitre ## : Les ondes en général<br> des propriétés observées au phénomène ondulatoire--->




