---
title: "Combinaisons d'opérateurs"
published: true
routable: true
visible: false
---

### Combinaisons d'opérateurs

Le Laplacien vectoriel s'écrit, en fonction des opérateurs $`\overrightarrow{grad}`$, $`div`$ et opérateurs $`\overrightarrow{rot}`$ :

$`\mathbf{\Delta\;\overrightarrow{E}=\;\overrightarrow{grad}\big(div\;\overrightarrow{E}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)}`$

---ok

Vérifions sont expression en coordonnées cartésiennes :

#### L'opérateur Laplacien scalaire, et la propagation d'un champ scalaire

##### Propagation d'une onde réelle unidimensionnelle.

* Ici, la scalaire (qui peut être un nombre réel ou complexe) est réel.

$`\dfrac{\partial^2 f}{\partial x}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0`$


##### Propagation d'une onde scalaire bidimensionnelle.

En coordonnées cartésiennes, l'équation de propagation d'une onde scalaire bidimensionnelle s'écrit :

$`\left(\dfrac{\partial^2 f}{\partial x^2}+\dfrac{\partial^2 f}{\partial y^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0`$

!!! *Exemple :*   
!!! L'onde décrit la variation d'altitude de la surface de l'eau, par rapport à la surface de l'eau non perturbée au repos.
!!! La surface de l'eau au repos est une surface (2D) et définit un champ scalaire bidimentionnel.

Mais

##### Propagation d'une onde scalaire tridimensionnelle.

$`\left(\dfrac{\partial^2 f}{\partial x^2}+\dfrac{\partial^2 f}{\partial y^2}+\dfrac{\partial^2 f}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0`$





#### L'opérateur Laplacien vectoriel, et la propagation d'un champ vectoriel



* Un champ vectoriel $`\overrightarrow{U}`$ se propage s'il vérifie l'équation d'onde vectorielle.
  <br>
  L'écriture générale de cette équation utilise l'opérateur lagrangien vecoriel et s'écrit :   
  <br>
  $`\Delta\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=0`$

* Cherchons les coordonnées cartésiennes du premier terme, $`\overrightarrow{grad}\big(div\;\overrightarrow{E}\big)`$

$`\color{blue}{div\,\overrightarrow{U}=\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}}`$

* La divergence d'un champ vectoriel est un champ scalaire.   
      Le gradient d'un champ scalaire $`f`$ est le champ vectoriel, qui s'exprime en coordonnées cartésiennes :

$`\overrightarrow{grad}\,f=\left(
\begin{array}{l}
\dfrac{\partial f}{\partial x}\\
\dfrac{\partial f}{\partial y}\\
\dfrac{\partial f}{\partial z}
\end{array}\right)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; donc :

$`\overrightarrow{grad}\big(\color{blue}{div\,\overrightarrow{U}}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial}{\partial x}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)\\
\dfrac{\partial}{\partial y}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)\\
\dfrac{\partial}{\partial z}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)
\end{array}\right)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; et nous obtenons :

$`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$


* Cherchons les coordonnées cartésiennes du deuxième terme, * $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)`$

$`\color{blue}{\overrightarrow{rot}\,\overrightarrow{E}=
\left(\begin{array}{l}
\dfrac{\partial E_z}{\partial y}-\dfrac{\partial E_y}{\partial z}\\
\dfrac{\partial E_x}{\partial z}-\dfrac{\partial E_z}{\partial x}\\
\dfrac{\partial E_y}{\partial x}-\dfrac{\partial E_x}{\partial y}
\end{array}\right)}`$


$`\overrightarrow{rot}\big(\color{blue}{\overrightarrow{rot}\,\overrightarrow{E}\big)}`$
$`\quad =
\left[\begin{array}{l}
\dfrac{\partial}{\partial y}\left(
\color{blue}{\dfrac{\partial E_y}{\partial x}-\dfrac{\partial E_x}{\partial y}}
\right)
-\dfrac{\partial}{\partial z}\left(
\color{blue}{\dfrac{\partial E_x}{\partial z}-\dfrac{\partial E_z}{\partial x}}
\right)\\
\dfrac{\partial}{\partial z}\left(
\color{blue}{\dfrac{\partial E_z}{\partial y}-\dfrac{\partial E_y}{\partial z}}
\right)
-\dfrac{\partial}{\partial x}\left(
\color{blue}{\dfrac{\partial E_y}{\partial x}-\dfrac{\partial E_x}{\partial y}}
\right)\\
\dfrac{\partial}{\partial x}\left(
\color{blue}{\dfrac{\partial E_x}{\partial z}-\dfrac{\partial E_z}{\partial x}}
\right)
-\dfrac{\partial}{\partial y}\left(
\color{blue}{\dfrac{\partial E_z}{\partial y}-\dfrac{\partial E_y}{\partial z}}
\right)\end{array}\right]`$

 &nbsp;&nbsp;&nbsp;&nbsp; Nous obtenons alors :

$`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)`$
$`\quad =
\left(\begin{array}{l}
\dfrac{\partial^2 E_y}{\partial y\,\partial x}
-\dfrac{\partial^2 E_x}{\partial y^2}
-\dfrac{\partial^2 E_x}{\partial z^2}
+\dfrac{\partial^2 E_z}{\partial z\,\partial x} \\
\dfrac{\partial^2 E_z}{\partial z\,\partial y}
-\dfrac{\partial^2 E_y}{\partial z^2}
-\dfrac{\partial^2 E_y}{\partial x^2}
+\dfrac{\partial^2 E_x}{\partial x\,\partial y} \\
\dfrac{\partial^2 E_y}{\partial x\,\partial z}
-\dfrac{\partial^2 E_x}{\partial x^2}
-\dfrac{\partial^2 E_z}{\partial y^2}
+\dfrac{\partial^2 E_z}{\partial y\,\partial z} \\
\end{array}\right)`$


&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; il reste simplement à combiner les résultats :

$`\overrightarrow{grad}\big(div\;\overrightarrow{E}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$
$`\quad - \quad
\left(\begin{array}{l}
\dfrac{\partial^2 E_y}{\partial y\,\partial x}
-\dfrac{\partial^2 E_x}{\partial y^2}
-\dfrac{\partial^2 E_x}{\partial z^2}
+\dfrac{\partial^2 E_z}{\partial z\,\partial x} \\
\dfrac{\partial^2 E_z}{\partial z\,\partial y}
-\dfrac{\partial^2 E_y}{\partial z^2}
-\dfrac{\partial^2 E_y}{\partial x^2}
+\dfrac{\partial^2 E_x}{\partial x\,\partial y} \\
\dfrac{\partial^2 E_y}{\partial x\,\partial z}
-\dfrac{\partial^2 E_x}{\partial x^2}
-\dfrac{\partial^2 E_z}{\partial y^2}
+\dfrac{\partial^2 E_z}{\partial y\,\partial z} \\
\end{array}\right)`$

$`\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\quad\quad - \dfrac{\partial^2 E_y}{\partial y\,\partial x}
+\dfrac{\partial^2 E_x}{\partial y^2}
+\dfrac{\partial^2 E_x}{\partial z^2}
-\dfrac{\partial^2 E_z}{\partial z\,\partial x} \\
\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\quad\quad - \dfrac{\partial^2 E_z}{\partial z\,\partial y}
+\dfrac{\partial^2 E_y}{\partial z^2}
+\dfrac{\partial^2 E_y}{\partial x^2}
-\dfrac{\partial^2 E_x}{\partial x\,\partial y} \\
\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}\\
\quad\quad - \dfrac{\partial^2 E_y}{\partial x\,\partial z}
+\dfrac{\partial^2 E_x}{\partial x^2}
+\dfrac{\partial^2 E_z}{\partial y^2}
-\dfrac{\partial^2 E_z}{\partial y\,\partial z} \\
\end{array}\right)`$

* L'ordre de dérivation n'important pas,    
  (exemple : $`\dfrac{\partial^2}{\partial x\,\partial y}=\dfrac{\partial^2}{\partial y\,\partial x})`$,   
  nous remarquons alors que toutes les dérivées partielles du second ordre correspondant à
  des termes croisés de coordonnées s'annulent :

$`\overrightarrow{grad}\big(div\;\overrightarrow{E}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)`$
$`\require{cancel}\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial x\, \partial y}}}+\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial x \,\partial z}}}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 E_y}{\partial y\,\partial x}}}
+\dfrac{\partial^2 E_x}{\partial y^2}
+\dfrac{\partial^2 E_x}{\partial z^2}
-\color{blue}{\cancel{\dfrac{\partial^2 E_z}{\partial z\,\partial x}}} \\
\\
\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial y \,\partial x}}}+\dfrac{\partial^2 U_y}{\partial y^2}+\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial y \,\partial z}}}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 E_z}{\partial z\,\partial y}}}
+\dfrac{\partial^2 E_y}{\partial z^2}
+\dfrac{\partial^2 E_y}{\partial x^2}
-\color{blue}{\cancel{\dfrac{\partial^2 E_x}{\partial x\,\partial y}}} \\
\\
\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial z \,\partial x}}}+\color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial z \,\partial y}}}+\dfrac{\partial^2 U_z}{\partial z^2}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 E_y}{\partial x\,\partial z}}}
+\dfrac{\partial^2 E_x}{\partial x^2}
+\dfrac{\partial^2 E_z}{\partial y^2}
-\color{blue}{\cancel{\dfrac{\partial^2 E_z}{\partial y\,\partial z}}} \\
\end{array}\right)`$

* Au total nous obtenons l'expression simple :

**$`\overrightarrow{grad}\big(div\;\overrightarrow{E}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)`$**
**$`\quad =
\left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}\\
\dfrac{\partial^2 U_y}{\partial y^2}\\
\dfrac{\partial^2 U_z}{\partial z^2}\\
\end{array}\right)`$**

Cette combinaison particulière d'opérateurs $`\overrightarrow{grad}`$, $`\overrightarrow{rot}`$ et $`div`$
constitue la **définition de l'opérateur Laplacien vectoriel** :

**$`\large{\overrightarrow{\Delta}=\overrightarrow{grad}\big(div\;\overrightarrow{E}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{E}\big)}`$**



