---
title: 'Chirality-4'
published: true
routable: true
visible: false
lessons:
    -
      slug: chirality-4
      name: LINÉAIRE 4 : La chiralité
      order: 1
---

<!--MétaDonnée : ... -->

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-1_L1200.jpg)<details>
<summary>Etape 1 : Appel à idées</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Montagne :&nbsp; _physique fondamentale_

---------------------------

*Relativité restreinte :*




### **Définition technique de la chiralité avec attributs locaux (niveau Bac+3)**

#### **1. Définition d’un objet avec attributs**
Un objet $`\( \mathcal{O} \)`$ dans un espace euclidien $`\( \mathbb{R}^n \)`$ est défini par :
- Un ensemble de points $`\( \{P_1, P_2, ..., P_k\} \subset \mathbb{R}^n \)`$.
- Une **fonction d’attributs** $`\( f: \{P_1, ..., P_k\} \to \mathcal{A} \)`$ , où $`\( \mathcal{A} \)`$ est un ensemble d’attributs (ex. : types d’atomes, valeurs de champ, couleurs).
  *Exemple* :
  - En chimie : $`\( f(P_i) = \)`$ "atome de carbone", "atome d’oxygène", etc.
  - En physique : $`\( f(P_i) = \)`$ valeur d’un champ scalaire ou vectoriel en $`\( P_i \)`$.

**Isométrie généralisée** :
Une transformation $`\( T: \mathbb{R}^n \to \mathbb{R}^n \)`$ est une **isométrie pour $`\( \mathcal{O} \)`$** si :
1. $`\( T \)`$ préserve les distances : $`\( d(T(P_i), T(P_j)) = d(P_i, P_j) \)`$.
2. $`\( T \)`$ préserve les attributs : $`\( f(T(P_i)) = f(P_i) \)`$.
   *Remarque* : Cela interdit les transformations qui changeraient la nature des points 
   (ex. : transformer un atome de carbone en oxygène).

---

#### **2. Groupe de symétrie avec attributs**
Le **groupe de symétrie** $`\( G \)`$ de $`\( \mathcal{O} \)`$ est l’ensemble des isométries $`\( T \)`$ (rotations, translations, reflets) qui :
- Laissent $`\( \mathcal{O} \)`$ globalement invariant : $`\( T(\{P_i\}) = \{P_i\} \)`$.
- Préservent les attributs : $`\( f \circ T = f \)`$.

*Exemple* :
- Pour une molécule comme le **bromochlorofluorométhane** (CHBrClF), les attributs 
sont les atomes (H, Br, Cl, F). Aucune réflexion ne préserve ces attributs : la molécule est chirale.

---

#### **3. Définition formelle de la chiralité avec attributs**
Un objet $`\( \mathcal{O} \)`$ est **chiral** dans $`\( \mathbb{R}^n \)`$ si :
1. Il existe une isométrie anti-conforme $`\( T \)`$ (typiquement une réflexion) telle que :
   - $`\( T(\{P_i\}) = \{P_i\} \)`$  (même géométrie).
   - $`\( f \circ T \neq f \)`$  (les attributs ne sont **pas** préservés globalement).
     *Interprétation* : $`\( T(\mathcal{O}) \)`$ est l’image miroir de $`\( \mathcal{O} \)`$, mais 
     les attributs sont "inversés" (ex. : Br et Cl échangés).
2. Il n’existe **aucune isométrie conforme** $`\( R \)`$ (rotation + translation) telle que $`\( R(\mathcal{O}) = T(\mathcal{O}) \)`$.
   *Conséquence* : $`\( \mathcal{O} \)`$ et son image miroir ne sont pas superposables **sans modifier les attributs**.

---

#### **4. Matrices et représentations**
En dimension $`\( n = 3 \)`$, les isométries sont représentées par des matrices $`\( M \in O(3) \)`$ :
- **Rotations** : $`\( \det(M) = +1 \)`$.
- **Reflets** : $`\( \det(M) = -1 \)`$.

**Condition de chiralité** :
Le groupe de symétrie $`\( G \)`$ de $`\( \mathcal{O} \)`$ ne contient **aucune matrice de déterminant -1** qui préserve les attributs.
*Exemple* :
- Pour une molécule comme l’**alanine**, les reflets échangent les groupes $`\( \text{NH}_2 \)`$ et $`\( \text{CO}_2\text{H} \)`$
, ce qui n’est pas une symétrie de la molécule.

---

#### **5. Généralisation aux dimensions supérieures**
Un objet chiral en $`\( \mathbb{R}^n \)`$ peut devenir achiral en $`\( \mathbb{R}^{n+1} \)`$, 
car une rotation dans la dimension supplémentaire permet de superposer l’objet à son image miroir
**sans modifier les attributs**.
*Exemple* :
- Un "L" coloré (avec des attributs "rouge" et "bleu") est chiral en 2D, mais peut être retourné en 3D pour superposer les couleurs.

---

#### **6. Applications en physique et chimie**
- **Chimie** :
  Deux énantiomères (ex. : limonène) ont la même géométrie mais des **attributs chimiques** 
  (groupes fonctionnels) disposés différemment. Leurs interactions avec d’autres molécules 
  chiraux (ex. : récepteurs biologiques) diffèrent.
- **Physique des champs** :
  Un champ vectoriel chiral (ex. : skyrmion magnétique) ne peut pas être superposé à son
  image miroir par une rotation, car le champ $`\( \vec{B}(P_i) \)`$ change de direction.

---

#### **7. Exemple détaillé : Une molécule chirale**
Prenons le **bromochlorofluorométhane** (CHBrClF) :
- **Points** : $`\( \{P_1, P_2, P_3, P_4, P_5\} \)`$ (atomes C, H, Br, Cl, F).
- **Attributs** : $`\( f(P_1) = \text{C} \)`$, $`\( f(P_2) = \text{H} \)`$, \$`( f(P_3) = \text{Br} \)`$, etc.
- **Groupe de symétrie** : $`\( G = \{I\} \)`$ (seule l’identité préserve les attributs).
- **Reflet** : Échange Br et Cl, donc $`\( f \circ T \neq f \)`$. La molécule est chirale.
