---
title: Les Systèmes
published: true
routable: true
visible: false
lessons:
    - slug: from-sets-to-systems-3
      name: PARALLÈLE : Des ensembles aux systèmes
      order: 3
    -
      slug: sets-to-SYSTEMS-linear-3
      name: LINÉAIRE : Systèmes
      order: 2
---

<!---------
!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>
!!!!  <details>
------------->

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-1_L1200.jpg)<details>
<summary>Etape 1 : Appel à idées</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

<!--caligraphie de l'intégrale double curviligne-->

$`\def\bigt{\large{t}\normalsize}`$
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

---


##### Randonnée Contreforts :&nbsp; _thème transverse, pour tous_

---------------------------

### SYSTÈMES

<br>


RÉSUMÉ<br> 
: --- à faire.

<br>

-----------------

### Décrire l'évolution temporelle d'une grandeur physique   
#####

----------------

##### Est-ce modéliser un système ?

* La seule **évolution temporelle d'une population** ne décrit *pas un système*.
  <br>    
  Un **système** nécessite *au moins une interaction*, et donc *au minimum deux populations qui interagissent*.
  
* Cependant, l'**évolution temporelle d'une population** *dépend d'interactions* avec un environnement non pris en compte.
  Son profil *donne des indices* sur ces interactions,    
  et *aide à modéliser un système* auquel appartient la population.

<br>

##### Puis-je utiliser le calcul différentiel pour décrire la dynamique de variables discrètes ?

à faire.

<br>


! *LE  MODÈLE  EXPONENTIEL*


##### Qu'est-ce que modèle à taux de variation constant, ou modèle exponentiel ?





##### De combien de variables décrit-il l'évolution?

* le modèle exponentiel concerne une **variable unique $`\mathbf{X(t)}`$**.   
  Cette variable est un nombre réel : $`X(t)`$**$`\,\mathbf{\in\mathbb{R}}`$**.   
  <br>
  Dans l'interprétation du modèle, elle **peut représenter** :
   * la *valeur réelle d'une grandeur physique* continue à l'instant $`t`$.
   * un *nombre entier d'entités* au sein d'une population à l'instant $`t`$,   
     seules les valeurs entières de $`X(t)`$ prendront alors un sens.

##### Quelles sont les hypothèses fondatrices ?

* La **variation infinitésimale $`\mathbf{dX}`$** (positive ou négative) de la variable$`X`$ à l'instant $`t`$ et sur une 
  durée infinitésimale $`dt`$ est *proportionnel à $`\mathbf{X(t)}`$*, valeur de la variable
  à l'instant $`t`$ :   
  <br>
  $`\left.\dfrac{dX}{dt}\right\lvert_{\,\bigt} \,=\,\underbrace{\propto X(t)}_{\text{proportionnel à X(t)}}`$   
  <br>
  **$`\left.\dfrac{dX}{dt}\right\lvert_{\,\bigt}`$** est appelé le **taux de variation de $`X`$** à l'instant $`t`$.

* Notons **$`\mathbf{r(t)}`$** le *coefficient de proportionnalité*, et nommons le **taux de variation unitaire de $`X`$**   
  <br>
  $`\left.\dfrac{dX}{dt}\right\lvert_{\,\bigt} \,=\,r(t)\, X(t)`$  
  
* Le modèle exponentiel postule que **$`\mathbf{r}`$ ne dépend pas du temps**.   
  <br>
  $`r(t)=r=const\;\Longrightarrow\;\left.\dfrac{dX}{dt}\right\lvert_{\,\bigt} \,=\,r\, X(t)`$  

* Lorsque **$`\mathbf{r\gt 0}`$**, le taux de variation $`\dfrac{dX}{dt}`$ est positif. Cela implique un
  *accroissement de $`X`$* au cours du temps et nous parlons de **croissance exponentielle**.   
  <br>
  Lorsque **$`\mathbf{r\lt 0}`$**, le taux de variation $'\dfrac{dX}{dt}`$ est négatif. Cela implique une
  *décroissance de $`X`$* au cours du temps. On parle alors de **décroissance exponentielle**.  


##### Quelles sont les limites de ce modèle ?

* En dynamique d'une population, la **croissance** exige des *ressources*.   
  Ces ressources ne sont pas prises en compte dans ce modèle unidimentionnel.
  <br>
  Le modèle d'une **croissance exponentielle sur un temps infini** exigerait des *ressources infinies*,
  ce qui est *non réaliste*.    
  <br>
  La *réalité observable* ne peut correspondre qu'à une **croissance exponentielle sur une durée limitée**.   

* Ainsi, même en absence de prédateurs, une *population* ne peut soutenir longtemps un rythme
  de croissance exponentielle, et **tend vers une limite** associée à un *épuissement des ressources*.   
  Au mieux, la population se stabilise à cette valeur limite, sinon elle commence à décroître.
 

##### Quelle évolution de $`X(t)`$ prévoit le modèle ?

* Déterminons l'expresssion de $`X(t_2)`$, valeur de la variable $`X`$ à une date $`t_2`$, connaissant la valeur $`X(t_1)`$.
  <br>


   $`\color{brown}{\Large{\left.\dfrac{dX}{dt}\right\lvert_{\,\bigt} = r\,X(t)}}`$

  $`\displaystyle\begin{align}
   \;\;&\Longrightarrow\quad\left.\dfrac{dX}{X}\right\lvert_{\,\bigt}=r\,dt\\
   \\
   &\Longrightarrow\;\underbrace{\int_{X(t_1)}^{X(t_2)}\dfrac{dX}{X}}_{\color{blue}{\begin{array}{c}
   \text{Primitive }\left(\large{\frac{dx}{x}} \right)\\ =\;ln\,|\,x\,|\end{array}}}=\int_{t_1}^{t_2} r\,dt\\
   \\
   &\Longrightarrow\;\big[\,ln\,|X|\,\big]_{X(t_1)}^{X(t_2)}= r \,\big[\,t\,\big]_{t_1}^{t_2}\\
   \\
   &\Longrightarrow\;\underbrace{ln\,|X(t_2)|-\,ln\,|X(t_1)|}_{\color{blue}{
   \text{hypothèse : } X\,>\,0 \;\Longrightarrow\;|X|\,=\,X}} = r\,(t_2 - t_1)\\
   \\
   &\Longrightarrow\; ln\,X(t_2) = ln\,X(t_1) + r\,(t_2 - t_1)\\
   \\
   &\Longrightarrow\; \underbrace{exp\big[ln\,X(t_2)\big]}_{\color{blue}{exp\,(ln\,x)\;=\;x}}
   =\underbrace{exp\big[ln\,X(t_1) + r\,(t_2 - t_1)\big]}_{\color{blue}{exp\,(a+b)\;=\;exp\,a\;\times\; exp\,b}}\\
   \\
   &\Longrightarrow\; X(t_2)=X(t_1)\,exp\,\big[r\,(t_2 - t_1)\big]\\
   \\
   &\color{brown}{\Longrightarrow\; \Large{X(t_2)=X(t_1)\;e^{\,r\,(t_2-t_1)}}}
   \end{align}`$
   
   
##### Que signifie l'observation d'un taux de croissance exponentiel ?

* à faire...   
idées : taux de croissance stationnaire, rien  ne s'oppose, sur la durée de l'observation, à la croissance exponentielle.   
croissance très rapide (math : la fonction $`e^x`$ croît plus rapidement que toute fonction puissance $`x^n`$).   
warning, ... , états stationnaires résultats d'équilibres en danger, ... épuisement de ressources, extinction d'espèces locales, etc ...

<br>
  
-------------

! *CROISSANCE LOGISTIQUE*

à faire.

<br>

-----------------

### Modéliser un système  
#####

----------------


! *Le MODELE "PROIE-PRÉDATEUR" de Lotka-Volterra*


<!---#### Le modèle poie-prédateur de Lokta Volterra--->


##### Qu'est-ce que modèle "proie-prédateur" de Lotka-Volterra ?

* Le modèle de **Lotka-Volterra** est le *premier modèle proie-prédateur, le plus simple*, proposé
  dès 1925 (Alfred J. Lotka <sub>[1]</sub>) et 1926 (Vito Volterra <sub>[2]</sub>).   
  <br>
  [1] _Lotka, A.J. Elements of physical biology. Elem. Phys. Biol. 1926, 82, 341–343._   
  [2] _Volterra, V. Variazioni e fluttuazioni del numero d’individui in specie animali conviventi._
      _In Memoire della Real Accademia Nazionale._
dei Lincei II; Rome, Italy, 1926; pp. 31–113

<br>

##### De combien de variables décrit-il l'évolution?

* Le modèle "proie-prédateur" concerne un couple de variables réelles liées 
  **$`\mathbf{\big(\,(X_1(t)\,,X_2(t)\,\big)\,\in\,\mathbb{R}_+^2}`$**   
  <br>
  Dans l'interprétation du modèle, elles **peuvent représenter** :
   * la *valeur réelle d'une grandeur physique* continue à l'instant $`t`$.
   * un *nombre entier d'entités* au sein d'un système à l'instant $`t`$,   
     seules les valeurs entières prenant alors un sens.

<br>

##### Quels sont ses domaines d'application ?

Les modèles proie-prédateur, du plus simple à ses développements ultérieurs, peuvent servir
à comprendre et modéliser de nombreux phénomènes couvrant des **disciplines très diverses**.

* *Ecologie* : dynamique d'espèces en compétition.
* *Chimie* : phénomènes oscillatoire dans certaines réactions chimiques.
* *Psychologie* : dynamique des relations intersonnelles.
* *Sociologie* : ...
* *Economie* : ...
* ... (liste non limitative)

Il suffit de reconnaître dans les **équations et paramètres** des modèles une *description possible*
*d'un phénomène* observé, qu'il soit naturel ou culturel.

<br>

##### Quelles sont les hypothèses fondatrices ?

<br>
Les variables **$`X_1(t)`$ et $`X_2(t)`$** ne jouent *pas des rôles symétriques*.   
L'une représente des proies et l'autre des prédateurs.

<br>
**Variable proie $`X_1(t)`$**

* Elle représente le *nombre de proies*.
* **hypothèse** : Les proies disposent de *nourriture en quantité illimitée*.   
   * $`\Longrightarrow`$ **en absence de prédateur** rien ne s'oppose à un taux de croissance 
      *$`\left.\dfrac{dX_1}{dt}\right\lvert_{\,\bigt}^+`$ proportionnel à $`X_1`$*, le nombre de proies,   
     conduisant à une croissance exponentielle.   
     <br>
     **$`\large{\left.\dfrac{dX_1}{dt}\right\lvert_{\,\bigt}^+ \,=\,+\, C_1\, X_1(t)}\quad`$**, avec *$`C_1 \gt 0`$*.

<br>

**Variable prédateur $`X_2(t)`$**

* Elle représente le *nombre de prédateurs*.
* **hypothèse** : Les prédateurs *se nourrissent uniquement de proies*.  
   * $`\Longrightarrow`$ **en absence de proie** les prédateurs meurent selon un taux de décroissance 
      *$`\left.\dfrac{dX_2}{dt}\right\lvert_{\,\bigt}^-`$ proportionnel au nombre $`Y`$* de prédateurs,   
     conduisant à une décroissance exponentielle.   
     <br>
     **$`\large{\left.\dfrac{dX_2}{dt}\right\lvert_{\,\bigt}^- \,=\,-\, D_2\, X_2(t)}\quad`$**, avec *$`D_2 \gt 0`$*.

<br>

**Interaction entre $`X_1(t)`$ et $`X_2(t)`$**

* **hypothèses** : 
   * Pour **une proie**, la *probabilité d'être tuée* par un prédateur et par unité de temps 
     est *proportionnelle à $`X_2`$*,  nombre de prédateurs.
    <br>
   * Pour **un prédateur** La *probabilité de manger* une proie par unité de temps, lui permettant de survivre et de se repoduire, 
     est *proportionnelle à $`X_1`$*, nombre de proies.   
  <br>
  Cela entraîne :   

   * Pour la **population $`X_1`$ des proies**, le *taux de décroissance $`\left.\dfrac{dX_1}{dt}\right\lvert_{\,\bigt}^-`$* dû 
     à la prédation est *proportionnel à $`X_1(t)X_2(t)`$*, produit des nombres de proies et prédateurs :
     <br>
     **$`\large{\left.\dfrac{dX_1}{dt}\right\lvert_{\,\bigt}^- \,=\,-\, D_1\;X_1(t)\,X_2(t)}\quad`$**, avec *$`D_1 \gt 0`$*.   
     <br>
   * Pour la **population $`X_2`$ des prédateurs**, le *taux de croissance $`\left.\dfrac{dX_2}{dt}\right\lvert_{\,\bigt}^+`$* dû
     à l'abondance de proies est *proportionnel à $`X_1(t)\,X_2(t)`$* :   
     <br>
     **$`\large{\left.\dfrac{dX_2}{dt}\right\lvert_{\,\bigt}^+ \,=\,+\, C_2\;X_1(t)\,X_2(t)}\quad`$**, avec *$`C_2 \gt 0`$*. 

<br>

##### Quelle est l'expression mathématique de ce modèle ?

* Le taux de variation temporelle de chacune des variables est la somme de sa composante
      croissante et sa composante décroissante.   
  <br>
      $`\left\{\begin{array}{l}
      \left.\dfrac{dX_1}{dt}\right\lvert_{\,\bigt}=\;\left.\dfrac{dX_1}{dt}\right\lvert_{\,\bigt}^+\;+\;\left.\dfrac{dX_1}{dt}\right\lvert_{\,\bigt}^-\\
      \\
      \left.\dfrac{dX_2}{dt}\right\lvert_{\,\bigt}=\;\left.\dfrac{dX_2}{dt}\right\lvert_{\,\bigt}^+\;+\;\left.\dfrac{dX_2}{dt}\right\lvert_{\,\bigt}^-
      \end{array}\right.`$

* Les *hypothèses du modèle se traduisent par* le système d'équations différentielles :   
  <br>
      **$`\large{\left\{\;\begin{array}{l}
      \left.\dfrac{dX_1}{dt}\right\lvert_{\,\bigt}=\;\;C_1\;X_1(t)\;-\;D_1\;X_1(t)\,X_2(t)\\
      \\
      \left.\dfrac{dX_2}{dt}\right\lvert_{\,\bigt}=\,-\;D_2\;X_2(t)\;+\;C_2\;X_1(t)\,X_2(t)
      \end{array}\right.}`$**    
  <br>
      avec *$`(C_1\,,C_2\,,D_1\,,D_2)\in\mathbb{R}_+^4`$*.

<br>

##### Quelles sont les limites de ce modèle original ?

* Les proies disposent de **ressources infinies pour croître**.
* Le modèle décrit seulement l'évolution temporelle des populations :
   * Avec ses degrés de liberté, la **dimension spatiale** est **négligée**,   
     $`\Longrightarrow`$ les populations sont supposées réparties uniformément dans un espace
        homogène en terme de ressources. Les paramètres $`C_1,\,C_2,\,D_1,\,D_2`$ sont des
        moyennes sur l'espace considéré.
   * $`\Longrightarrow`$ ne sont *pas décrits* les phénomènes de *gradients* et de *migrations* des populations, des proies vers des zones
     plus nourriciaires ou moins peuplées en prédateurs, des prédateurs vers les proies.
* Les systèmes à **trois populations et plus en interaction** ne sont *pas décrits*.

<br>

##### Quel est un "état type" de ce modèle ?

<!--ancien titre : Quelle est l'évolution type des populations ?-->

1. Populations de *proies et prédateurs* évoluent en **cycles synchrones**.

   * Par *évolution temporelle <sup>a</sup> d'une population*, il faut entendre ici **évolution de son effectif**. 
   * <details><summary>Interprétation du phénomène.</summary>
     La population de prédateur croît lorsqu'elle trouve proies en abondance.   
     Lorsque le prélèvement sur la population de proies dépasse ses possibilités
     de renouvellement, alors la population de proies décroît.
     Lorsque la population de proies est insuffisante pour subvenir aux besoins vitaux des prédateurs,
     la population de prédateurs décroît, jusqu'à ce que la population de proies subvienne à ses nouveaux besoins.
     </details>
   * Le **cycle complet** caractérise *un état du système* proie-prédateur.
    
   * Dans l'*espace des configuration <sup>b</sup>* du système proie-prédeteur, le *cycle* est représenté
     par une **trajectoire fermée** parcourue dans un sens donné.

2. Un **état du système** peut être défini par *$`(X_{1\,ini},X_{2\,ini})`$ à un instant $`t_{ini}`$*.
   
   * Les valeurs des paramètres $`C_1,\,C_2,\,D_1,\,D_2`$ et la donnée des effectifs des proies et des prédateurs
     $`(X_{1\,ini},X_{2\,ini})`$ à un instant quelconque appelé instant initial $`t_{ini}`$ est **suffisant pour déterminer les populations** 
     de proies et de prédateurs *à tout instant passé ou futur*.
   * Inconvenient : il existe une infinité d'instants $`t_{ini}`$ et de couples associés
     *$`(X_{1\,ini},X_{2\,ini})`$ représentants un état du système.
   * Justification : La prévision avec le modèle commence souvent "sur le terrain" à recenser
     les populations $`(X_{1\,ini},X_{2\,ini})`$ à une date $`t_{ini}`$ donnée.


![](lokta-volverra-def-cycle_L1200.gif)
!!! <details markdown=1>
!!! <summary>Légende de la figure</summary>
!!! * *a : représentation temporelle* d'un état particulier $`(X_1(t),X_2(t)`$ du système proie-prédateur.
!!! * *b :* représentation du même état particuler $`(X_1,X_2)`$ dans l'*espace des configurations* du système
!!! proie-prédateur.
!!! * *Le système* est défini par les valeurs de paramètre : C<sub>1</sub>=2 u<sub>t</sub><sup>-1</sup>,
!!! D<sub>1</sub>=0,000666666 (P.u<sub>t</sub>)<sup>-1</sup>, C<sub>2</sub>=0,0001 (p.u<sub>t</sub>)<sup>-1</sup>,
!!! D<sub>2</sub>=0,5 u<sub>t</sub><sup>-1</sup><br>
!!! avec p : unité "proie", P : unité "prédateur" ; u<sub>t</sub> : unité arbitraire de temps.
!!! * *L'état particulier* représenté par la trajectoire fermée dans l'espace des configurations est défini
!!! par l'un des points de la trajectoire atteint à l'instant initial t<sub>ini</sub>=0, le point :<br>
!!! (X<sub>1 ini</sub>=3000 , X<sub>2 ini</sub>=1791).
!!! </details>


3. La **périodicité $`T`$** est une *caractérique d'un état* du système.

   * Dans l'*espace des configurations*, chaque *trajectoire* fermé représentant un état du système
     est **parcourue** dans un sens donné **à vitesse non constante**. 
   * Chaque point de cette trajectoire, couple de valeurs $`(X_1, X_2)`$ prises en un même instant,
     est traversé **avec la périodicité $`T`$**.

4. La **population des proies** évolue entre *deux valeurs limites* $`X_{1\,min}`$ et $`X_{1\,max}`$

   * Lorsque la variable **$`X_1`$** représente une **population d'entités discrètes**,   
     et que la *partie entière* de sa valeur absolue égale le *nombre d'entités* au sein de la population,    
     alors une valeur minimum inférieure à l'unité signifie l'extinction
     des proies, et en conséquence à terme celle des prédateurs :   
     <br>
     *$`\mathbf{X_{1\,min}\,\lt\,1\quad\Longrightarrow}\quad`$* **extinction des proies**.   
     <br>
     Le *cycle* qui mathématiquement continue *doit être arrêté*.
     
5. La **population des prédateurs** évolue entre *deux valeurs limites* $`X_{2\,min}`$ et $`X_{2\,max}`$
 
   * De même manière qu'au point précédent, si **$`X_2`$** représente une **population d'entités discrètes** alors :   
     <br>
     *$`\mathbf{X_{2\,min}\,\lt\,1\quad\Longrightarrow}\quad`$* **extinction des prédateurs**.   
     <br>
     Le *cycle* qui mathématiquement continue *doit être arrêté*.   
     Soit la population de proie est ou s'éteint, soit elle repart avec une croissance exponentielle.

<br>

##### Existe-t-il un "état stationnaire" dans ce modèle ?

* Un **état stationnaire** noté $`(X_1^*,X_2^*)`$** est caréctérisé par des effectifs de *populations stationnaires $`X_1`$ et $`X_2`$*.

* Des populations stationnaires $`X_1^*`$ et $`X_2^*`$ sont des populations dont *les effectifs*
  *ne varient pas dans le temps*, donc telles que leurs
  **dérivées premières $`dX_1^*/dt\text{  et  }dX_2^*/dt`$** sont **nulles à tout instant**.   
  <br>
  **$`\left.\begin{array}{l}
    \forall t \in \mathbb{R}, \\
    \left.\dfrac{dX_1^*}{dt}\right\vert_{\,\bigt}=0 \\
    \left.\dfrac{dX_2^*}{dt}\right\vert_{\,\bigt}=0
    \end{array}\right\}
    \Longrightarrow\;(X_1^*,X_2^*)`$** est **stationnaire**.

<br>

![](lokta-volverra-balance-populations-1a_L1200.jpg)

* Mathématiquement, il existe deux états stationnaires.
   * L'état $`(X_1^*=0\,,\,X_2^*=0)`$ vérifie les conditions de stationnarité.    
     Mais cet état n'est pas intéressant, car il correspond à l'absence de proies et de prédateurs.   
     Le modèle décrit alors l'évolution de populations qui n'existent pas.   
    <br>
   * L'état **$`(X_1^*=D_2/C_2\,,\,X_2^*=C_1/D_1)`$** est l'*unique cas stationnaire* intéressant.   
     <br>
     **$`\mathbf{\left.\begin{array}{l}
      \forall t \in \mathbb{R},\\
      X_1^*(t) = \dfrac{D_2}{C_2} =X_1^*\\
      X_2^*(t) = \dfrac{C_1}{D_1} = X_2^*
      \end{array}\right\}}`$**

      $`\Longrightarrow\left\{\begin{array}{l}
      \forall t \in \mathbb{R}, \\
      \left.\dfrac{dX_1^*}{dt}\right\vert_{\,\bigt}=+C_1\,\dfrac{D_2}{C_2}-D_1\,\dfrac{D_2}{C_2}\dfrac{C_1}{D_1}\\
      \left.\dfrac{dX_2^*}{dt}\right\vert_{\,\bigt}=-D_2\,\dfrac{C_1}{D_1}+C_2\,\dfrac{D_2}{C_2}\dfrac{C_1}{D_1}
      \end{array}\right.`$
      
      **$`\mathbf{\Longrightarrow\left\{\begin{array}{l}
      \forall t \in \mathbb{R}, \\
      \left.\dfrac{dX_1^*}{dt}\right\vert_{\,\bigt}=0\\
      \left.\dfrac{dX_2^*}{dt}\right\vert_{\,\bigt}=0
      \end{array}\right.}`$**
      
* L'*état stationnaire* est **un point dans l'espace des configuration**.  

![](lokta-volverra-balance-populations-1b_L1200.gif)

<!--pas très important, supprimé--------------------------------------
* Lorsque le modèle est fixé par les valeurs des paramètres $`C_1, C_2, D_1, D_2`$, il peut
  être caractérisé par son état stationnaire $`(X_1^*=D_2/C_2\,,\,X_2^*=C_1/D_1)`$.   
  Mais un état stationnaire ne caractérise pas un modèle. Il existe une infinité de quadruplets
  $`(C_1, C_2, D_1, D_2)`$ qui conduisent à un même état stationnaire.
--------------------------------------------------------------------->

! *Remarque :*
! * Les *valeurs stationnaires* $`X_1^*`$ et $`X_2^*`$ représente un *nombre d'entités* dans
! chaque population.
! * Cela ne signifie pas que les individus composants ces populations sont éternels.   
! En général *la population évolue dans ses entités* individuelles. Une naissance et un décès simultanés
! laissent l'effectif de la population inchangé.

!!!! *Attention :*
!!!! * L'*état stationnaire* d'un modèle proie-prédateur de Lokta Volterra n'est *pas un état limite* 
!!!!   vers lequel tendrait, avec le temps, tout état quelconque.  
!!!! * *Chaque état est indépendant*, et correspond à des *fluctuations périodiques perpétuelles*.
!!!! * Ce modèle ne prévoit *pas de transitions entre états* : les trajectoires fermées de l'espace des configurations
!!!! ne se coupent pas, chaque point appartient à un seul état.

!! *Pour aller plus loin :*
!! * Ce modèle historique proie-prédateur de Lokta Volterra, modèle historique, a donné naissance à toute une
!! *série de modèles proie-prédateur plus sophistiqués*.   
!! * Une *première évolution* serait de considérer que les proies ne disposent *pas de ressources infinies*, et donc
!! que même en absence de prédateur, leur population serait limitée.
!! * La *possibilité la plus simple* pour rendre compte de ce fait est de serait de considérer pour les proie 
!! un *taux de croissance logistique*, et non plus exponentiel.   
!! Les oscillations des populations $`X_2`$ et $`X_2`$ diminueraient alors avec le temps, et 
!! *mèneraient vers des populations stationnaires* qui sont précisément celles données par l'état stationnaire
!! $`(X_1^*=D_2/C_2\,,\,X_2^*=C_1/D_1)`$.    
!! *Dans l'espace des phases*, un état ne serait plus représenté par une trajectoire fermée, mais
!! par une *trajectoire ouverte en spirale* qui se terminerait au point représentant l'état stationnaire.

     
<br>

##### Comment représenter l'ensemble des états possibles ?

à faire

![](lokta-volverra-cyclic-populations_L1200.gif)

![](lokta-volverra-vector-field_L1200.jpg)
!!! <details markdown=1>
!!! <summary>Légende de la figure</summary>
!!! à faire.
!!! </details>

<br>


##### Quelle est la sensibilité aux paramètres d'interaction ?

à faire

![](lokta-volverra-variation-C2_L1200.gif)

![](lokta-volverra-variation-D1_L1200.gif)
!!! <details markdown=1>
!!! <summary>Légende de la figure</summary>
!!! à faire.
!!! </details>

<br>

##### Pourquoi la modélisation est-elle indispensable ?

à faire

<br>

##### Quels pièges éviter pour une modélisation satisfaisante ?

à faire... discrétisation, analyse numérique..

<br>
##### Quelles sont les pistes d'amélioration du modèle ?

à faire.

(limitation des ressources à travers modélisée par une croissance)

<!----------------

<br>


 modèle "proie-prédateur" de Lotka-Volterra* 

* Système d'ordre 1 et de dimension 2 (une première approche dynamique des populations ou un cours transverse sur les systèmes)
   * **$`\left\{\begin{array}{l} \dfrac{dx}{dt} = f(x,y)\\ \dfrac{dy}{dt}=g(x,y) \end{array}\right.`$** 
       avec par exemple le modèle proies prédateurs de Lotka-Volterra : $`f(x,y)= a\cdot x -b\cdot xy`$ et $`f(x,y)= - c\cdot x +d\cdot xy`$ (à ce niveau 3?) 


----------

##### Croissance par division

* Effectif population initiale : $`N_0`$

* En absence de mortalité, effectif de chaque génération :   
   * $`N_1=2\times N_0=2\,N_0`$
   * $`N_2=2\times N_1=2^2\,N_0`$
   * $`N_3=2\times N_2=2^3\,N_0`$
   * \dots
   * $`N_i=2\times N_{i-1}=2^i\,N_0`$

* Temps de génération $`G`$

$`\quad G=\dfrac{\text{intervalle de temps}}{\underbrace{\text{nombre de division}}_{\ge\;1} \text{ d'une cellule initiale}}`$

--->




  
  
