---
title: Waves in Physics
published: true
routable: true
visible: false
lessons:
    - 
        slug: waves-conceptual-and-learning-patterns-en
        name: PANORAMA-234 : Waves, an overview
        order: 1
---

*Course under construction*, **not validated**. 
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-EN_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-7_L1200.jpg)<details>
<summary>Stage 7 : Tested with students</summary>  
1. Brainstorming
2. In structuring
3. In writing : 1/3
4. In writing : 2/3
5. In writing : 3/3
6. Under review
7. Tested with students
8. Validated, still incomplete
9. Validated, sufficient basis
10. Validated, operational, in constant improvement
</details>


##### Hill Hiking

---------------------------

### WAVES

### **Waves** *in Physics*

<br>
[multilingual version : EN , FR , ES](https://m3p2.com/polyglot/temporary-m3p2/waves/n2/waves-introduction/waves-in-physics)
<br>

<!--
# <p style="font-size:70%;text-align: center;">Waves in Physics</p>
<p style="font-size:75%;text-align: center;">Birth of the Wave Concept</p>
-->

#### Birth of Field and Wave Concepts

 * Each of us has thrown a ball or tossed a pebble. At every moment, these objects occupy 
 a well-defined position in space and follow a trajectory that our eyes can track. 
This sensory experience forms the basis of our intuitive concept of **material bodies**:
well-defined objects with limited spatial extent that move according to the laws of physics.   
<br>
But our sensory experience is not limited to these localized objects. Each of us has 
**thrown pebbles into water** or watched raindrops fall onto the calm surface of a pond.   
<br>
Their impacts disturb the water’s surface, creating **small circular ripples** that
*propagate, reinforce, or diminish* when they cross each other, and
*bend around obstacles* encountered along their path.

* These ripples manifest, *at every moment and at every point* on the surface, as a
**variation in water height** beneath the surface.   
<br>
Physicists use the term **field** to describe a
*physical quantity defined at every point in space and at every moment*. Here, the
physical quantity is the water height, and the space is the two-dimensional surface
of the pond.   

<br>

#### Main Properties of a Field

* The physicist associates the concept of a **field** with:
   * a **physical quantity** that has *a defined value at every instant and at every point*
     in the space where it is defined.
   * **properties** that *specify how the field varies* in space and time,
     and *how perturbations of the field propagate*, add together, and interact with their environment.

* Let us enumerate the *main properties* of a field:
   * A field is **uniform** if *its value is the same at every point* in space at a given
   instant or over a specified time period.   
   <br>
   _For example, even without ripples, the depth of a pond varies from one point to another._
   _The water height field beneath the surface is not uniform._   
   _However, in an Olympic swimming pool where the water depth is the same everywhere,_
   _the water height field is uniform at the surface._

   * A field is **stationary** if *its values*—which may vary in space—*do not change over time*.   
   <br>
   _In a calm, windless pond where the water surface is "at rest," perfectly still,_
   _the water height field is stationary._


   * A field is **homogeneous** if *its propagation properties* (the shape of the perturbation 
   for a given impact and its propagation speed in a given direction) *are identical at every point* 
   in space, even if the field’s values vary spatially.   
   <br>
   _The speed of ripples depends on depth—shallow water slows propagation due to friction_
   _with the bottom, while deep water allows faster wave movement._   
   _Thus, since a pond’s depth varies, its water height field is not strictly homogeneous._
   _However, in an Olympic pool with constant depth, the field is homogeneous._

   * A field is **isotropic** if, regardless of the impact point, *the propagation of the perturbation*
   (its speed, shape, and attenuation) *does not depend on direction*, even if the 
   induced perturbation varies from one point to another for the same impact.   
   <br>
   _If raindrops in a pond always create perfectly circular ripples that propagate_
   _outward, it means each ripple spreads at the same speed in all directions._
   _Furthermore, if the height of a ripple remains constant at equal distances from_
   _the impact point, then the water height field is isotropic._

   * A field is **linear** if, for a point-like and instantaneous impact,
   *the amplitude of the perturbation is proportional to the energy of the impact*,
   and if *the amplitudes of the perturbations add together simply*
   when perturbations overlap.
 
<br>

#### Wave-Specific Phenomena


* The *ripples* result from the **displacement** of water molecules—i.e., **of matter**.    
  <br>
  When a wave characterizes the *disturbance of a material medium*, the physicist refers to it
  as a **mechanical wave**.   
  <br>

* The **properties of mechanical waves**:
   *  *Propagation*
   *  *Interference*
   *  *Diffraction* around an obstacle.
   *  *Reflection and transmission* at the interface between two different media.
   *  *Energy transport*, but *no matter transport* over long distances.
   
   **are also found in more subtle phenomena** observed in nature and later 
   described mathematically, or first predicted by physical theory before experimental
   confirmation.   
   <br>
   Thus, non-mechanical waves could be identified.

<br><br>

![Waves Interference Diffraction](waves-interferences-diffraction-2_L1200.jpg)
_Representation of interference and diffraction phenomena._

<br><br>

#### Different Types of Waves

* Today, **four types of waves** have been observed, from *mechanical waves*
to *electromagnetic waves*, then *gravitational waves* and *quantum waves*.
In order, these waves **correspond to increasingly subtle levels of reality**,
linked to the speed of light *c*, and modeled by physical theories with
increasingly abstract mathematics.

<br>

![Four Types of Waves](waves-introduction-n2-EN_L1200.jpg)
_Four types of waves in physics, to describe increasingly subtle and abstract levels of reality._

---------

##### **Mechanical Waves** *($`v \lt c`$)*

* These are the *most familiar and intuitive* and are often very
*easy to observe* or feel. They correspond to a **disturbance in a material field**:
   * *ripples* on the water’s surface (height field).
   * *sounds* propagating through air (pressure field).
   * *seismic waves* in the ground (displacement field in Earth).
   * *vibrations* in a spring or a musical instrument string (displacement field).

* All **these waves are material**; their propagation speed $`\mathscr{v}`$ is lower
than the speed of light $`c`$.

* Requiring a material medium, they *cannot travel through a vacuum*.

![](https://m3p2.com/fr/temporary-m3p2/waves/images-sounds/wave-phenomena/Waves-reflexion-interferences-e_v2_L500.gif)
_Waves generated on the water’s surface in a dish during an impact on a wall._

<br>

--------

##### **Electromagnetic Waves** *($`v = c`$)*

* They do not result from the disturbance of a material medium but *are formed*
by a **perpendicular electric field and magnetic field that self-sustain**.   
<br>
Since no supporting medium exists for electromagnetic waves, they
**can travel through a vacuum**, including interstellar space.

* These waves include:
   * *radio waves*
   * *microwaves*
   * *infrared*
   * *visible light*
   * *ultraviolet*
   * *X-rays*
   * *gamma rays*

* **Our eyes perceive only** a small part of this spectrum: *visible light*.   
<br>
Because **these waves** are **pure energy** (they have no rest mass), they are
*far more abstract*.   
<br>
At all times, **our bodies are traversed** by *radio waves*, *TV signals*, *WiFi waves* carrying
music, images, interview speech, etc.
**Without technology**, we would have *no awareness of most of these waves*.   
<br>

* The **speed of electromagnetic waves** is
always *exactly $`c = 299\,792\,458 \, \text{m/s}`$*, a fundamental constant of nature called
*the speed of light in a vacuum*.   
<br>
Since this speed does not depend on the observer’s state of motion, these waves
**defy our classical intuition** of the world. They constitute *one of the experimental proofs* of the coupling of space and time
within *spacetime*, first described by **special relativity** and later by **general relativity**.

![Linear Electromagnetic Wave](https://m3p2.com/fr/temporary_ins/waves/n2/overview/linear-electromag-wave-n3_L1200.gif)
![Elliptical Electromagnetic Wave](https://m3p2.com/fr/temporary_ins/waves/n2/overview/elliptic-wave-electromag-wave-n3_L1200.gif)
_Two different polarization states, linear (top) and elliptical (bottom), of an electromagnetic wave.
Without mastering the Mountain level, visual knowledge of these polarization states will allow you to understand, among other things, how you can see a movie in 3D even though it is projected on the 2D surface of a cinema screen._

! *Note* :
!
! **Electromagnetic waves**, until very recently (2015), were the *only source of all our knowledge of the Universe*:
!
! Astrophysics observes electromagnetic waves from the *Big Bang*, *galaxies*, *stars*,
! *planets*, and the *interstellar medium*.

---------------

##### **Gravitational Waves** *($`v = c`$)*

* Unlike electromagnetic waves, which travel through space and time, **gravitational waves**
are *even more abstract*—they are **disturbances in the curvature field of spacetime itself**.   
<br>

* **Spacetime** is warped by the presence of matter (which causes gravity), but it can also **vibrate**
during the *passage of gravitational waves* produced by violent events in the universe.   
Our senses cannot perceive these waves at all.


* Described by general relativity, they **travel** *at the speed of light $`c`$*.

! *Note* :
!
! Predicted by general relativity but observed only since 2015, the
! **gravitational waves** are at the **basis of a new astrophysics**,
! *gravitational wave astrophysics*.<br>
! <br>
! It observes **violent and massive phenomena** in the universe:
! rapid rotations before their *merger of black holes and neutron stars*.

------

##### **Quantum Waves** *($`v \gt c`$ in some cases)*

<br>

*A - Wave Function and Measurement*

* Quantum waves are **disturbances in a probability field**,
described by the **wave function $`\psi`$**. The temporal evolution of this function is
governed by *Schrödinger's equation*, or by more advanced equations in *quantum field theory*
(which combines and extends special relativity and quantum mechanics).

* **$`\boldsymbol{\psi}`$** does not describe a classical wave, but rather a **probability amplitude**
of finding a particle in a given state (position, momentum, spin, etc.).
The *probability itself* is proportional to *$`|\boldsymbol{\psi}|^2`$*.   
In this sense, the quantum function **$`\boldsymbol{\psi}`$ describes wave-particle duality**.

* It is *not material*, and one of its particularities is
*having an imaginary component* that plays a fundamental role.

* No one yet fully understands the true meaning of this wave.
It is **limited by the speed of light, except during measurement**
(collapse of the wave function), which is a non-local phenomenon, i.e., instantaneous (therefore
with v > c).
This **non-local behavior** is *fundamentally random* and thus
*does not allow communication* (otherwise it would imply the existence of temporal paradoxes).

![](hydrogenoid-atom-quantum-mechanics-s-p-orbitales.gif)
_Representation of electron presence probability (blue) in s orbitals (center) and p orbitals (6 lobes)_
_of a hydrogen-like atom, with the atomic nucleus at the center and highly magnified (red)._

<br>

*B - Wave Function and Entangled Particles*

* **Quantum entanglement** corresponds to an *even more abstract level of reality*.   
  <br>
  The **quantum link between two entangled particles** (which have interacted together in the past) is
  an absolutely extraordinary connection that *exists outside of space and time*.   
  <br>
  This link:
   * is *undetectable* by any known technology
   * *does not diminish* with distance
   * is *not stopped by obstacles* of any kind
   * has an *instantaneous behavior*, therefore *non-local*.

* **Fundamentally non-local**, this link is at the *basis of quantum teleportation*.   
  <br>
  When the **state of a particle is teleported from place A to place B**,
  the *information propagates instantaneously* from A to B, and does not pass through the physical
  space between A and B (which is why it is said that this link exists outside of space and time).   
  <br>
  The **conceptual understanding of this phenomenon** is *one of the great open questions*
  in the interpretation of quantum physics; it is the subject of major debates among physicists.

<br>

*C - Wave Function and Predictions*

* The **mathematical formulation of quantum mechanics** is
   * perfectly *well understood*
   * perfectly *experimentally verified*

  It is its conceptual interpretation that is a matter of controversy.

* The **instantaneous action of quantum entanglement** is *random*
  and *does not allow communication*.   
  <br>
  However, **quantum teleportation allows communication** because it
  involves two steps:
   * a **first step** *carried by entanglement*,
   * a **second step** *limited by the speed of light*.

  Therefore, **complete teleportation** is *limited by the speed of light*.

!! *Going Further* :
!!
!! The framework of quantum field theory, which combines and extends special relativity
!! and non-relativistic quantum mechanics, has seen many successes, including the prediction preceding the discovery of several particles such as the top quark (1995) and the Higgs boson (2011).
!!
!! However, it does not explain the phenomena predicted by general relativity (time dilation in a gravitational field, black holes, and gravitational waves, experimentally verified or observed).
!!
!! Thus, our understanding of all observed phenomena in the Universe requires two distinct theories: general relativity and quantum field theory, which seem
!! irreconcilable in their very foundations.
!!
!! Physicists continue the search for a unique principle that would give a single physical theory, of which general relativity and quantum field theory would be mere approximations,
!! and which would describe and statistically predict all phenomena at all scales of Nature.
