---
title: Les Ondes
published: true
routable: true
visible: false
lessons:
    -   
      slug: classical-corpuscules-and-waves
      name: PARALLELE : Mécanique de Newton, corpuscules et ondes
      order: 3
    -   
      slug: from-classical-world-to-wave-corpuscular-duality
      name: PARALLELE : des ondes et corpuscules à la dualité onde-corpuscule
      order: 2
    - 
      slug: from-corpuscule-to-mechanical-wave-3
      name: PARALLÈLE particule et onde.
      order: 3
    -   
      slug: waves-3
      name: LINÉAIRE : Ondes
      order: 2
---
$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Contreforts :&nbsp; _physiciens_

---------------------------

*Physique classique :*

#### L'onde et la description de sa propagation

<br>

RÉSUMÉ
: ---   

  *Le concept d'onde, et ses propriétés*    
  
  __Onde mécanique__ : perturbation d'un milieu matériel, caractérisé par une grandeur <!--ou une propriété--> physique scalaire $`\eta`$ ou vectorielle
  $`\vec{\eta}`$, qui s'étend de proche en proche sur des distances souvent bien plus grandes
  que l'amplitude de déplacement $`\delta`$ de chaque particule du milieu autour de sa position d'équilibre.
  * Onde __transversale__ : déplacement local du milieu perturbé perpendiculaire à la direction de propagation.
  * Onde __longitudinale__ : déplacement local du milieu perturbé parallèle à la direction de propagation.
  * Onde __progressive__ : la perturbation se propage sur de grandes distances.
  * Onde __stationnaire__ : la perturbation ne se propage pas, résulte de la superposition d'ondes progressives.

  __Représentation mathématique__ un champ $`U`$ obligatoirement dépendant du temps,
  scalaire $`U(\vec{r},t)`$ ou vectoriel $`\overrightarrow{U}(\vec{r},t)`$

  __Propriétés des ondes mécaniques__
  * __Non localisée__ : fonction spatialement étendue.
  * __Transport d'énergie__. 
  * __Pas de transport de matière__ au delà de $`\delta`$.
  * Dans un milieu matériel,
     * le __phénomène de diffraction__ observé lorsqu'une onde mécanique rencontre un obstacle.
     * le __phénomène d'interférence__ peut être observé en présence de deux ondes.
  * À l'interface entre deux milieux de caractéristiques différentes,
     * le __phénomène de réflexion__, totale ou partielle, observé lorsque l'onde atteint l'interface.
     * le __phénomène de réfraction__ observé lorsque l'onde traverse l'interface.

  Le concept d'__onde__ s'élargit à tout phénomène conduisant aux propriétés des ondes mécaniques.
  * __Onde électromagnétique__ : Propagation du champ électromagnétique dans le vide ou dans la matière.
  * __Onde gravitationnelle__ : Propagation d'une perturbation dans la géométrie de l'espace-temps 
                de la relativité générale d'Einstein. Ne se traite pas dans le cadre de la physique classique.

  __Célérité__ $`v`$ : vitesse de propagation de l'onde progressive.<br>
  $`\mathscr{v} = \dfrac{\Delta \mathscr{l}}{\Delta t}`$, avec $`\Delta \mathscr{l}`$ distance parcourue par l'onde pendant la durée  $`\Delta t`$.

  -----------------------

  *L'onde périodique*   
  __Onde périodique__ : en tout point de l'espace de vecteur position $`\vec{r}`$ et à tout instant $`t`$, la perturbation $`U(\vec{r},t)`$ du milieu se répète à intervalles de temps réguliers :   
  $`U(\vec{r},t) = U(\vec{r}\,,\; t+n\times T)`$, avec $`n\in\mathbb{Z}`$ et $`T`$ une durée.    

  * __Propriété fondamentale__ de l'onde périodique : sa propriété temporelle décrite par les grandeurs physiques équivalentes :
      * La __période temporelle__ $`T`$ de l'onde (d'appellation commune : "période"), <br>
                   homogène à un temps : unité S.I., la "seconde" (notation $`s`$)..
      * La __fréquence temporelle__ $`\nu`$ $`\; = 1\,/\,T`$ : inverse de la période temporelle, <br> 
                   homogène à l'inverse d'un temps : unité S.I., le "hertz" (notation $`s^{-1}\equiv Hz`$) 

  * __Propriétés du milieu__ : On se limitera à la célérité $`\mathscr{v}`$
     * milieu __linéaire__ (noté L) : en présence de plusieurs ondes, la perturbation de milieu est égale à
                           la somme des perturbations induites par chaque onde en absence des autres
                           (principe de superposition).
     * milieu __homogène__ (noté H) : $`\mathscr{v}`$  ne dépend pas de la position dans le milieu.
     * milieu __isotrope__ (noté I) : $`\mathscr{v}`$  ne dépend pas de la direction de propagation de l'onde.  
     * milieu __dispersif__ : la célérité dépend de la fréquence temporelle de l'onde :
     $`\mathscr{v} = \mathscr{v}(\nu) = \mathscr{v}(T)`$
     * milieu __non dispersif__ : la célérité de dépend pas de la fréquence temporelle de l'onde.
     
  * __Propriété de l'onde dans un milieu LHI__  : sa propriété spatiale décrite par les grandeurs physiques équivalentes :
      * La période spatiale appelée __longueur d'onde__ $`\lambda`$, <br>
                   homogène à une longueur : unité S.I., le "mètre" (notation $`m`$), ou ses unités multiples
                   (kilomètre "$`km`$", ...) ou sous-multiples (millimètre "$`mm`$", micromètre "$`\mu m`$", 
                    nanomètre "$`nm`$",... )
      * La __fréquence spatiale__ $`1/\lambda`$ : inverse de la longueur d'onde, <br> 
                   d'unité S.I., le $`m^{-1}`$ et ses miultiples et sous-multiples.

    -----------------------
    
    *L'onde progressive sinusoïdale*   
     Noms communs d'usage :   
     __onde sinusoïdale__ &equiv; __onde harmonique__ (&equiv; __onde monochromatique__ en optique).  
     
  *  Une onde progressive sinusoïïdale se propageant en direction et sens d'un vecteur unitaire $`\vec{n}`$ :
     s'écrit $`U(\vec{r},t) = U_0 \cdot \cos(\,\vec{k}\cdot\vec{r} \;\mathbf{-}\; \omega t + \varphi)`$, avec
     * $`U(\vec{r}, t)`$ : __élongation__ en $`\vec{r}`$ et $`t`$
     * $`U_0`$ : __amplitude__ = élongation maximum
     * $`\vec{k}\cdot\vec{r}-\omega t + \varphi`$ : __phase__ en $`\vec{r}`$ et $`t`$
     * $`\vec{k} = k\,\vec{n}`$ : __vecteur d'onde__, avec :<br>
       &nbsp;&nbsp; k : __nombre d'onde__, d'unité S.I. $`rad\,m^{-1}`$, <br>

  * __Propriété fondamentale__ : aux propriétés temporelles $`T`$ et $`\nu`$ s'ajoute la pulsation $`\omega`$
       d'unité S.I. le radian par seconde ($`rad\,s^{-1}`$) et telle que :   
       $`\omega = 2\pi\,\nu = \dfrac{2\pi}{T}`$

  * __Propriété dépendante du milieu__ la propriété spatiale "vecteur d'onde" $`\vec{k}`$,
     s'ajoute à $`\lambda`$ en précisant la direction et le sens de propagation.

  * Relations entre propriétés :   
    $`k = \dfrac{2\pi}{\lambda} = \dfrac{2\pi}{\mathscr{v} T} = \dfrac{2\pi\,\nu}{T} = \dfrac{\omega}{\mathscr{v}}`$

  * Cas d'une onde unidimensionnelle : $`U(\vec{r}, t) = U_0\cdot \cos(kx \;\mathbf{-}\; \omega t + \varphi)`$
  
  * Onde sinusoïdale se propageant en sens inverse de $`\vec{n}`$ :   
       $`U(\vec{r}, t) = U_0\cdot \cos(\,\vec{k}\cdot\vec{r} \;\mathbf{+}\; \omega t + \varphi)`$

  * Intérêt : vient du __théorème de Fourier__ :
     * Toute onde périodique se décompose en une somme discrète d'onde sinusoïdales.
     * Toute onde (quelconque) se décompose en une somme intégrale d'onde sinusoïdales
  
 

<br>

-----------------

<br>

#### Qu'est-ce qu'une onde ?

* Notre représentation intuitive du phénomène ondulatoire vient des ondes matérielles.

* Une **onde mécanique** est la *perturbation d'un milieu matériel* caractérisé par une 
  grandeur physique qui *s'étend de proche en proche* sur des distances souvent bien plus 
  grandes que l'amplitude de déplacement δ de chaque particule du milieu autour
  de sa position d'équilibre.   
  Cette perturbation, qui implique de l'énergie, est *générée par un phénomène physique localisé*
  dans l'espace, appelé **source** de l'onde.

* Ce qui caractérise une onde mécanique :
   * décrite par un champ dépendant du temps,    
      $`\Longrightarrow`$ elle n'est *pas localisée*.
   * L'onde *transporte de l'énergie*. 
   * L'onde *ne transporte pas de matière*. 

* Suivant la nature de la grandeur physique décrivant l'onde, on qualifie :
   * **onde scalaire** : la grandeur physique est scalaire.   
     _&ndash;&nbsp; hauteur d'une vaguelette à la surface de l'eau, la source étant le point d'impact du cailloux jeté._   
     _&ndash;&nbsp; densité volumique de l'air, la source sonore étant la membrane de l'enceinte qui comprime_   
     _puis détend alternativement l'air en son voisinage._
     _&ndash;&nbsp; ..._
   * **onde vectorielle** : la grandeur physique est vectorielle.
     _vecteur déplacement des atomes constituant la matière, ..._
   * **onde tensorielle** : la grandeur physique est tensorielle.   
     _contrainte, déformation, ..._
    
* Le *concept d'onde s'étend* à des grandeurs physiques sans lien avec la matière.
   * **Ondes électromagnétiques** : propagation du champ électromagnétique $`\big(\vec{E},\vec(B)\big)`$ 
     dans le vide.
   * **Ondes gravitationnelles** : propagation d'une déformation de l'espace-temps représentée
     par sa grandeur physique "métrique" qui décrit localement les propriétés géométriques de l'espace et du temps.


##### Onde unidimensionnelle

* Exemple : La perturbation de la corde tendue d'une guitare.

![](wave-square_L1000.gif)

![](wavepacket_non-dispersive-v2_L1000.gif)

![](1D-corde-vibrante-f1-harm24_v2_L1000.gif)


##### Onde bidimensionnelle (2D) ou tridimensionnelle (3D)

* Exemple d'onde bidimensionnelle : vaguelettes à la surface de l'eau.
* Exemple d'onde tridimensionnelle : une onde sonore.

![représentation 2D d'ondes diverses 2D et 3D](different-waves-2.gif)

* La figure représente différents types d'ondes (2D ou 3D) :   
   d) onde quelconque
   e) onde plane progressive.
   f) onde stationnaire.
   g) onde sphérique progressive.


##### Quelle différence entre une onde longitudinale et une onde transverse ?




##### Quelle différence entre une onde progressive et une onde stationnaire ?

<br>
* **Onde progressive**   
  <br>
  **Couplage** entre les *coordonnées d'espace et de temps* de la forme :   
  * Pour une onde scalaire unidimensionnelle :  
    <br>
    **$`\mathbf{\large{U(x,t) = f(\,\pm\, x \pm \mathbf{\mathscr{v}} t)}}`$**

<br>
* *Onde stationnaire*   
  <br>
  **Séparation** des *coordonnées d'espace et de temps* dans deux fonctions différentes.   
  Résulte d'une superposition d'ondes progressives.
  * Pour une onde scalaire unidimensionnelle :  
    <br>
    *$`\mathbf{\large{U(x,t) = f(x)\times g(t)}}`$*
    <br>


----------------------------------

#### Qu'est-ce que l'équation de d'Alembert ?

* Écriture d'une onde scalaire unidimensionnelle dans un système de coordonnées spatiale et temporelle $`(x,t)`$ :   
  <br>
  **$`\mathbf{\large{\dfrac{\partial^2 U\normalsize{(x,t)}}{\partial x^2}\,-\,\dfrac{1}{\mathscr{v}}\cdot\dfrac{\partial^2 U\normalsize{(x,t)}}{\partial t^2}= 0}}`$**

* Pour une onde scalaire tridimensionnelle dans un système de coordonnées cartésiennes et temporelle $`(x,y,z,t)`$ :   
  <br>
  $`\left(\dfrac{\partial^2 U(x,t)}{\partial x^2}\,+\dfrac{\partial^2 U(x,t)}{\partial y^2}
  \,+\dfrac{\partial^2 U(z,t)}{\partial x^2}\right)`$
  $`\,-\,\dfrac{1}{\mathscr{v}}\cdot\dfrac{\partial^2 U(x,t)}{\partial t^2}= 0`$   
  <br>
  ou en écriture vectorielle (indépendante du système de coordonnées choisi) :   
  <br>
  **$`\mathbf{\large{\Delta U}\normalsize{(\vec{r},t)}\large{\,-\,\dfrac{1}{\mathscr{v}}\cdot\dfrac{\partial^2 U\normalsize{(\vec{r},t)}}{\partial t^2}= 0}}`$** 
  


-------------------------------


#### Qu'est-ce qu'une onde périodique ?





#### Quelles sont les grandeurs fondamentales décrivant une onde périodique ?



#### Quelles sont les grandeurs décrivant une onde périodique qui dépendent du milieu de propagation ?


---------------------------


#### Quelle différence entre un milieu dispersif et un milieu non dispersif ?



#### Qu'est-ce que la relation de dispersion d'un milieu ?


------------------------------------------


#### Qu'est-ce qu'une onde progressive sinusoïdale ?



#### Comment décrire mathématiquement une onde progressive sinusoïdale ?


##### L'équivalence des fonctions sinus et cosinus.

$`U(x,t)=A\cdot cos (\omega t - kx)`$$`\; A\cdot cos (\omega t - kx + \dfrac{\pi}{2}  - \dfrac{\pi}{2})


##### L'écriture en notation complexe.



#### L'onde progressive sinusoïdale est-elle physiquement réaliste ?

* Une onde progressive sinusoïdale $`U(\vec{r},t) = U_0\cdot \cos(\vec{k}\cdot\vec{r}-\omega t)`$ :
  * existe de tout temps : $`t\in ]-\infty ; +\infty[`$
  * est définie en tout point de l'espace, de vecteur position $`\vec{r}`$   
  
*  Elle transporterait donc une *énergie infinie*.

*  $`\Longrightarrow`$ une onde sinusoïdale progressive est **physiquement irréaliste**.


##### Quel est alors son l'intérêt ?

* L'onde sinusoïdale peut être vue comme une **brique** qui, en tout point $`\vec{r}`$ de l'espace et par superposition, 
  *permet de reconstruire toute onde* $`U(\vec{r},t)`$ grâce au **théorème de Fourier** qui suppose que l'onde
  vérifie le **principe de superposition linéaire**.



##### Qu'est-ce que le principe de superposition linéaire ?

* 

* Il s'applique si dans un milieu toute onde créée par une source n'est pas modifiée par la présence 
  ou non d'autres ondes créées par d'autres sources.

* Dans ce cas, en présence de nombreuses onde, l' **élongation résultante** en tout point de l'espace et à tout instant s'exprime
  comme la *somme des élongations* qui seraient induites par chacune *des ondes individuelles* (comme si elles
  étaient seules) en présence.   
  
* Expression mathématique du **principe de superposition** :      
  Soient $`n`$ ondes notées $`U_i(\overrightarrow{r},t)\;(avec i\in\{1,\dots,n\})`$, 
  l'onde totale résultante $`U_{tot}(\overrightarrow{r},t)`$ s'écrit :   
  <br>
  **$`\mathbf{\displaystyle\large{U_{tot}(\overrightarrow{r},t) = \sum_{i=1}^{n} U_i(\overrightarrow{r},t)}}`$**



##### Qu'est-ce que le théorème de Fourier ?

* **Théorème fondamental** qui intervient dans *tous les domaines de la physique*.   
  Il précise que :   

* **toute fonction périodique $`^{\;(1)}`$** $`f(t)`$ de fréquence $`\nu`$ peut s'exprimer comme une *somme discrète*
  *de fonctions sinusoïdales* de fréquences $`n\nu`$ multiples de $`\nu`$, et de différentes phases à l'origine.    
   * en notation réelle :   
     $`\displaystyle f(t) = f_0 + \sum_{n=1}^{\infty} F_n\,\cos\,(2\pi\,n\nu\,t\,+\,\phi_n)`$  
     <br>
     avec $`F(\nu)`$ l'amplitude de la composante de fréquence $`n\nu`$.


   * en notation complexe :   
     $`\displaystyle f(t) = f_0 + \sum_{n=1}^{\infty} F_n\,\exp\,(i\,2\pi n\nu t+\phi_n)`$ 


   * **$`f_0`$ est la composante continue.
   * la fonction périodique de *plus basse fréquence*, $`\nu`$, est appelée **composante fondamentale**
   * les fonctions de *fréquences $`n\nu`$ avec $`n >1`$* sont appelées **composantes harmoniques**.
   * **$`F_n`$** est l'*amplitude de la composante de fréquence $`n\nu`$*.

<br>
* **toute fonction non périodique$`^{\;(1)}`$** $`f(t)`$ de fréquence $`\nu`$ peut s'exprimer comme une
  *somme intégrale d'ondes sinusoïdales* de différentes fréquences et phases à l'origine.   
   * en notation complexe :   
     $`\begin{align}\displaystyle f(t) &= f_0 + \int_{-\infty}^{+\infty} F(\nu)\,\exp\big(i\,2\pi\nu\,t\,+\,\phi(\nu)\big) \,d\nu \\
       \\
       &= f_0 + \int_{-\infty}^{+\infty} \underline{F(\nu)}\,\exp\big(i\,2\pi\nu\,t)\,d\nu \\
        &\quad\quad\quad\quad\quad\text{ avec }\underline{F(\nu)} = F(\nu)\,e^{\,i\,2\pi\nu t}
       \end{align}`$ 

*   * **$`\underline{F(\nu)}`$** est l'*amplitude complexe* de la composante de fréquence $`\nu`$.

* **$`\mathbf{(1)}`$** : sous réserve de quelques restrictions peu contraignantes en physique.
  

##### Qu'est-ce que le spectre d'une fonction $`f(t)`$ ?

* Le **spectre** d'une fonction $`f(t)`$ est l'*information sur toute les composantes* qui composent $`f(t)`$ :    
  * *fréquences* des composantes d'amplitude non nulle.
  * *amplitudes* de ces composantes.

* La **représentation** d'un spectre est données dans un *graphe $`F(\nu)`$*.   
  <br>
  _(figure à faire, un exemple de $`f(t)`$ et sa décomposition spectrale $`F(\nu)`$)_


------------------------------------------------

#### Quelles sont les phénomènes propres aux ondes ?

* C'est phénomène ne sont pas décrit par la physique classique appliquée aux corps et corpuscules.

* Lorsque *une ou plusieurs ondes* se propagent dans *un même milieu* :

   * Le phénomène d'**interférence** peut être observé en présence de plusieurs ondes.
     
   * Le phénomène de **diffraction** peut être observé lorsqu'un obstacle pertube la propagation d'une onde.

* Lorsque *une onde* rencontre une *interface entre deux milieux différents*

   * Le phénomène de **réflexion**  peut être observé.
   * Le phénomène de **réfraction** peut être observé lorsque l'onde traverse l'interface.
   * 
   
--------------------------------------------

##### Qu'est-ce que deux ondes synchrones ?



#### Qu'est-ce que le phénomène d'interférence ?

![interférences entre deux ondes sphériques d'égale amplitiudes et déphasées de pi,
et propagation des zéros](2_sources_circulaires_dephasees_pi_v2_L1000.gif)

* La figure ci-dessus est la **représentation symbolique des interférences** créées par la 
  *superposition de deux ondes circulaires synchrones*, de même amplitude mais en opposition de phases à leurs sources.

* L'*interprétation des couleurs* se rapproche de l'expérience de la cuve à onde.
    * zone du **bleu le plus foncé** : *valeur maximale* pour l'élongation de l'onde résultante.   
      _(crêtes des vaguelettes observées)._
    * zone du **bleu le plus clair** : *valeur minimale*.
      _(creux des vaguelettes observées)._
    * zone de **bleu moyen** : *élongation nulle*.

  * On discerne des **lignes stationnaires** sur lesquelles l'*élongation nulle*.    
    Elles correspondent à des zones qui restent non perturbées.
    

<!----------------
!!! déphasées de $`/pi`$ à leurs sources
!!! <details markdown=1>
!!! <summary>Représentation symbolique des interférences créées par deux ondes sphériques.<br>
!!! </summary>
!!! La figure représente les interférences de deux ondes progressives sphériques $`U_1(\vec{r},t)`$ et $`U_1(\vec{r},t)`$, synchrones mais 
!!! déphasées de $`/pi`$ à leurs sources en $`S_1`$ et $`S_2`$.
!!! Afin de mieux visualiser le phénomène, la modélisation des sources sphériques n'est pas physique. 
$`U(\vec{r},t)=U_0\cdot\cos(k r-\omega t)`$ au lieu de $`U(\vec{r},t)=\dfrac{U_0}(r}\cdot\cos(kr-\omega t)`$ 
pour une onde progressive sphérique se propageant dans l'espace. Pour une onde sphérique réelle non amortie, 
la décroissance en $`1/r`$ de l'amplitude de l'onde à partir de sa source en $`r=0`$ permet la conservation de
l'énergie. 
Considérons une onde dont la puissance transportée 
En effet, au cours de sa progression, l'intensité $`I_O`$ proportionnelle en tout point à $`U_O^2`$ ontenue sur un front d'onde se répartie 
sur la surface $`4\pi r^2`$ sur une sphère de rayon croissant r au fur et à mesure de la progression.
de ra
Le modèle mathémait
!!! Même en absence de phénomène
!!! l'équation de propagation
!!! </details>




* Une onde projette de l'énergie.

* Le **phénomène d'interférence** apparaît lors de la *superposition de plusieurs ondes* dans l'espace.

* Il y a interference lorsque la *distribution spatiale d'énergie résultante* d'une superposition d'ondes
  n'est **pas égale à** la *somme des distributions d'énergie propres à chaque onde* prise isolément.


---------------->



##### Que signifient "interférences constructives" et "interférence destructives" ?


##### Que représentent les noeuds et les ventres ?


##### Quelle lien entre interférences et ondes stationnaires ?



#### Interférences produites par la superposition de deux ondes harmoniques synchrones


##### 1 - Les ondes sont unidimensionnelles, de même amplitude, se propagent dans la même direction


<br>

* Les deux ondes harmoniques sont :
   * synchrones
   * d'amplitudes égales
   * et se propagent vers les $`x`$ croissants.
   <br>


-------------------

**Calcul de l'onde résultante** *en notation réelle*

* En notation réelle, les deux ondes harmoniques s'écrivent :   
  <br>
  **$`\boldsymbol{\mathbf{U_1(x,t) = A\cdot cos(kx - \omega t + \varphi_1)}}`$**
  **$`\boldsymbol{\mathbf{U_2(x,t) = A\cdot cos(kx - \omega t + \varphi_2)}}`$**

* Calcul de l'onde résultante :  
  <br>
  $`\color{brown}{\mathbf{U(x,t)}}\; = U_1(x,t) + U_2(x,t)`$   

$`\begin{align} \quad &=A\;\big[\,cos(\underbrace{kx - \omega t}_{\color{blue}{\text{  posons }\\ kx - \omega t \,=\, \alpha}} + \varphi_1) + cos(\underbrace{kx - \omega t}_{\color{blue}{=\; \alpha}} + \varphi_1)\,\big]
&\\
&=A\;\big[\,cos\Big(\alpha + \dfrac{\varphi_1+\varphi_1}{2} + \dfrac{\varphi_2-\varphi_2}{2}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\alpha + \dfrac{\varphi_2+\varphi_2}{2} + \dfrac{\varphi_1-\varphi_1}{2}\Big)\,\Big]\\
&\\
&=A\;\big[\,cos\Big(\underbrace{\alpha + \dfrac{\varphi_1+\varphi_2}{2}}_{\color{blue}{=\;\alpha '}} + \dfrac{\varphi_1-\varphi_2}{2}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\underbrace{\alpha + \dfrac{\varphi_1+\varphi_2}{2}}_{\color{blue}{\text{nous avons posé }\\ \alpha + (\varphi_1+\varphi_2)/2\; = \;\alpha '}} - \dfrac{\varphi_1-\varphi_2}{2}\Big)\,\Big]\\
&\\
&=A\;\big[\,cos\Big(\alpha ' + \dfrac{\varphi_1-\varphi_2}{2}\Big) \\
&\quad\quad\quad\quad + \,cos\Big(\alpha ' - \dfrac{\varphi_1-\varphi_2}{2}\Big)\,\Big]\\
&\\
&=A\;\big[\,\underbrace{cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\,-\,sin(\alpha ')\,sin\Big(\dfrac{\varphi_1-\varphi_2}{2}}_{\color{blue}{\text{car   }cos(a+b)\;=\;cos\,a\,cos\,b\;-\;sin\,a\,sin\,b}}\big)\\
&\quad + \underbrace{cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\,+\,sin(\alpha ')\,sin\Big(\dfrac{\varphi_1-\varphi_2}{2}}_{\color{blue}{\text{car   }cos(a-b)\;=\;cos\,a\,cos\,b\;+\;sin\,a\,sin\,b}}\big)\,\Big]\\
&\\
&=2\,A\cdot cos(\alpha ')\,cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)
\end{align}`$   
<br>
$`\quad\boldsymbol{\mathbf{=\color{brown}{2\,A\cdot cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big) \cdot cos\Big(}\color{blue}{\underbrace{\color{brown}{kx - \omega t + \dfrac{\varphi_1+\varphi_2}{2}}}_{\text{pulsation }\omega\text{ inchangée}}}\color{brown}{\Big)}}}`$

-----------------------------------------

* Je remarque que l'*onde résultante*
   * est **harmonique**.
   * a la **même fréquence** $`\nu\,=\,\dfrac{\omega}{2\pi}`$ que les deux ondes initiales.
   
* L'**amplitude** de l'onde résultante est :   
  <br>
  **$`\boldsymbol{\mathbf{A_{résult.} = \left| \,2\,A\cdot cos\Big(\dfrac{\varphi_1 - \varphi_2}{2} \Big) \,\right|}}`$**   
  <br>
  $`\quad\quad\quad=\sqrt{4\,A^2 \cdot cos^2\Big(\dfrac{\varphi_1 - \varphi_2}{2}\Big)}`$   
  <br>
  $`\color{blue}{\scriptsize{\left.\begin{align} \quad\quad &cos(a+b)=cos(a)cos(b)-sin(a)sin(b)\\
                     &cos(a-b)=cos(a)cos(b)+-sin(a)sin(b)\end{align}
               \right\}\Longrightarrow\\
        \quad\quad cos^2(a)=cos(a)cos(a)=\dfrac{1}{2}[cos(a+a)+cos(a-a)]\\
        \quad\quad\quad\quad=\dfrac{1}{2}[1 + cos(2a)]}}`$   
   <br>
   $`\boldsymbol{\mathbf{\quad\quad \color{brown}{=\sqrt{2\,A^2 \cdot \big(1 + cos\,(\varphi_1 - \varphi_2)\big)}}}}`$

----------------------------

<br>

**Calcul de l'onde résultante** *en notation complexe*

* Une **onde harmonique réelle $`U_1`$** s'écrit comme la *partie réelle de l'onde harmonique complexe $`\underline{U_1}`$*.
  <br>
  $`\begin{align} U_1&(x,t) = A\cdot cos(kx - \omega t + \varphi_1)\\
     &\\
     &= \mathscr{Re}\big[A\cdot \big(cos(kx - \omega t + \varphi_1)\\
     &\quad\quad\quad\quad + i\;sin(kx - \omega t + \varphi_1)\big)\big]\\
     &\\
     &= \mathscr{Re}\big[A\cdot e^{\,i\;(kx - \omega t + \varphi_1)} \big]\\
     &\\
     &= \mathscr{Re}\big[\underline{U_1}(x,t)\big] \end{align}`$

* Le deux ondes harmoniques qui interfèrent, d'écriture réelle :   
   <br>
     $`U_1(x,t) = A_1\cdot cos(kx - \omega t + \varphi_1)`$.  
     $`U_2(x,t) = A_2\cdot cos(kx - \omega t + \varphi_2)`$   
   <br>
   s'écrivent en notation complexe :   
   <br>
     **$`\boldsymbol{\mathbf{\underline{U_1}(x,t) = A_1\cdot e^{\,i\;(kx - \omega t + \varphi_1)}}}`$**    
     **$`\boldsymbol{\mathbf{\underline{U_2}(x,t) = A_2\cdot e^{\,i\;(kx - \omega t + \varphi_2)}}}`$**   
   <br>
   soit encore :   
   <br>
     $`\begin{align}\underline{U_1}(x,t) &= \underline{A_1}\cdot e^{\,i\;(kx - \omega t)}\\
       &\quad\quad\text{avec }\underline{A_1} = A_1\,e^{\,i\;\varphi_1}\end{align}`$.  
     <br>
     $`\begin{align}\underline{U_2}(x,t) &= \underline{A_2}\cdot e^{\,i\;(kx - \omega t)}\\
       &\quad\quad\text{avec }\underline{A_2} = A_2\,e^{\,i\;\varphi_2}\end{align}`$.  
     <br>
    ou $`\underline{A_2}`$ et $`\underline{A_2}`$ sont les amplitudes complexes des deux ondes.
  
* Calcul de l'onde complexe résultante :  
  <br>
  **$`\mathbf{\underline{U}(x,t)}`$**$`\; = \underline{U_1}(x,t) + \underline{U_2}(x,t)`$    
  <br>
  $`\quad =A\;\big[ \,e^{\,i\;(kx - \omega t+ \varphi_1)} + e^{\,i\;(kx - \omega t+ \varphi_2)}\,\big]`$     
  <br>
  $`\color{blue}{\scriptsize{\quad\text{Posons }kx - \omega t \,=\, \alpha}}`$   
  <br>
  $`\quad =A\;\big[\,e^{\,i\;(\alpha + \varphi_1)} + e^{\,i\;(\alpha + \varphi_2)} \,\big]`$
  <br>
  $`\color{blue}{\scriptsize{\quad\text{Rappel : } e^{\,i\;(a+b)}\;=\;e^{\,i\,a}\times e^{\,i\,b}}}`$   
  <br>
  $`\quad =A\;\big[ \,e^{\,i\,\alpha}\;e^{\,i\,\varphi_1}\; + \; e^{\,i\,\alpha}\;e^{\,i\,\varphi_2}\,\big]`$   
  $`\quad =A\;e^{\,i\,\alpha}\;\big[\,e^{\,i\,\varphi_1}\; + \; e^{\,i\,\varphi_2}\,\big]`$    

* Pour exprimer l'onde en notation réelle, il faut **décomposer l'onde complexe** en ses *parties réelle et imaginaire* :   
  <br>
  $`\color{blue}{\scriptsize{\quad\text{Rappel : }e^{\,i\,a} = cos (a) + i\,sin (a)}}`$   
  $`\color{blue}{\scriptsize{\quad\text{et pour simplifier l'écriture, posons la notation :}}}`$   
  $`\color{blue}{\scriptsize{\quad\ cos\,(a) = "ca" \text{ , et  } sin\,(a) = "sa"}}`$   
  <br>
  $`\quad =A\cdot(c\alpha\,+\,i\,s\alpha) \cdot (c\varphi_1\,+\,i\,s\varphi_1\,+\,c\varphi_2\,+\,i\,s\varphi_2)`$  
  <br>
  $`\quad =A\cdot(c\,\alpha\;+\;i\,s\,\alpha) \cdot \big[\,(c\varphi_1+c\varphi_2)`$$`\,+\, i\,(s\varphi_1+s\varphi_2)\,\big]`$   

* L'onde réelle est la partie réelle de $`\underline{U}(x,t)`$ :   
  <br>
  $`\mathbf{U(x,t)} = \mathscr{Re}[\,\underline{U}(x,t)\,]`$  
  <br>
  $`\quad =A\cdot\big[\,c\alpha\,(c\varphi_1+ c\varphi_2) - s\alpha\,(s\varphi_1+ s\varphi_2)\,\big]`$   
  <br>
  $`\color{blue}{\scriptsize{\quad\left| \begin{align}  &cos(a+b)=cos(a)\,cos(b)-sin(a)\,sin(b)\\
                                  &cos(a-b)=cos(a)\,cos(b)+-sin(a)\,sin(b)\end{align}\right.}}`$   
  $`\color{blue}{\scriptsize{ \quad\Longrightarrow  cos(a+b)+cos(a-b)=2\,cos(a)\,cos(b)}}`$   
  $`\color{blue}{\scriptsize{ \quad\text{En posant  } p=a+b \text{ et  } q=a-b\;,}}`$   
  $`\color{blue}{\scriptsize{\quad \text{nous obtenons  } a = (p+q)\,/\,2 \text{ et  }  b = (p-q)\,/\,2.}}`$   
  $`\color{blue}{\scriptsize{ \quad\text{Nous retrouvons ainsi  }}}`$
  $`\color{blue}{\scriptsize{ \quad\quad cos(p) + cos(q) = 2\,cos\Big(\dfrac{p+q}{2}\Big)\,cos\Big(\dfrac{p-q}{2}\Big)}}`$ 
  <br>
  $`\color{blue}{\scriptsize{ \quad\text{De même nous retrouverions }}}`$   
  $`\color{blue}{\scriptsize{ \quad\quad sin(p) + sin(q) = 2\,sin\Big(\dfrac{p+q}{2}\Big)\,cos\Big(\dfrac{p-q}{2}\Big)}}`$    
  <br>
  $`\quad \begin{align}=A\;\Big[\,&c\alpha\cdot 2\,c\Big(\dfrac{\varphi_1+\varphi_2}{2}\Big)\,c\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\\
     &- s\alpha\cdot 2\,s\Big(\dfrac{\varphi_1+\varphi_2}{2}\Big)\,c\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\end{align}`$   
  <br>
  $`\quad \begin{align}=2\,A\;&c\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\\
     &\times \Big[ \,c\alpha\,c\Big(\dfrac{\varphi_1+\varphi_2}{2}\Big)-s\alpha\,s\Big(\dfrac{\varphi_1+\varphi_2}{2}\Big)\,\Big]
     \end{align}`$   
  <br>
  $`\quad =2\,A\;c\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\,c\Big(\alpha + \dfrac{\varphi_1+\varphi_2}{2}\Big)`$   
  <br>
  **$`\boldsymbol{\mathbf{\quad =2\,A\;cos\Big(\dfrac{\varphi_1-\varphi_2}{2}\Big)\,cos\Big(kx - \omega t + \dfrac{\varphi_1+\varphi_2}{2}\Big)}}`$**
  <br>
  Bien sûr nous obtrenons le même résultat qu'avec le calcul en notation réelle.

<br>


#### Quel lien entre l'énergie et l'amplitude de l'onde ?

* Une onde projette de l'énergie à travers l'espace.

* *Selon la grandeur physique* que décrit l'onde, l'**énergie** $`\mathscr{E}`$ de l'onde contenue
  en tout élément de volume $`d\tau_P`$ de l'espace.
  (apparaissant comme ponctuel à l'échelle d'observation, et donc représenté par un point $`P`$)
  est **proportionnelle** :
   * au **carré de l'amplitude** de l'onde en ce point.
   * (moins souvent) **à l'amplitude** de l'onde en ce point.

<br>

#### Quels liens entre l'énergie, la puissance, l'intensité d'une onde ?

* L'**intensité** de l'onde est l'*énergie* traversée *par surface élémentaire $`dS`$ en un temps infinitésimal $`dt`$*.   
  $`\Longrightarrow`$ unité S.I. : *$'J\,s^{-1}\,m^{-2}\;=\; W\,m^{-2}`$*.   


* Si un **capteur** *prélève une partie $`\mathscr{W}`$ de l'énergie* de l'onde, la **puissance reçue $`\mathscr{P}`$**
  par le capteur est :  
  <br>
  **$`\mathbf{\mathscr{P} = \dfrac{d\mathscr{W}}{dt}}\quad,`$** unité S.I. : *$`J\,s^{-1}`$*.
   * Un **capteur "rapide"** qui *suit la variation d'intensité au cours d'une période*
     temporelle de l'onde (onde périodique) **mesure la puissance instantanée $`\mathscr{P}(t)`$** :   
     <br>
     $`\mathscr{P}(t) = \dfrac{d\mathscr{W}}{dt}(t)`$
   <br>
   * Un **capteur "lent"** sensible uniquement à la puissance moyenne reçue sur une période temporelle $`\Delta t`$ très grande
     devant la période $`T`$ de l'onde (onde périodique) **mesure la puissance moyenne $`<\mathscr{P}(t)>`$** :  
     <br>
     $`\displaystyle <\mathscr{P}(t)> = \dfrac{1}{\Delta t} \int_{t=0}^{\Delta t} \mathscr{P}(t)`$,  
     <br>
     $`\quad\quad\text{lorsque } \Delta t >> T,\quad T\text{ période de l'onde}`$

<br>


#### Pourquoi parfois seule l'amplitude de l'onde résultante est nécessaire ?

* Lorsque le **capteur** a un **temps de réponse $`\delta t`$ grand devant la périodocité $`T`$** de l'onde, 
il n'arrive pas à suivre la variation de l'élongation au sein d'une période temporelle.

* $`\Longrightarrow`$ Il n'est ainsi pas sensible à la puissance instantanée,    
  il n'est sensible et *ne mesure que la puissance $`<\mathscr{P}(t)>`$* moyennée sur la durée $`\delta t`$,

*  $`<\mathscr{P}(t)>`$ est *proportionnelle* à l'énergie contenue dans l'onde, soit suivant le type d'onde : 
   * **au carré de l'amplitude**.
   * (moins souvent) **à l'amplitude**.

!!! <details markdown=1>
!!! <summary>
!!! *Exemple 1*
!!! </summary>
!!! <br>
!!! *Un photodétecteur de lumière (UV, visible, infrarouge) ou un oeil humain (visible)* <br>
!!!
!!! Le *spectre visible* est un petit domaine de longueurs d'onde dans le vide s'étendant *de 380 à 780*
!!! *nanomètres*. 
!!!
!!! Prenons par exemple la longueur d'onde *$`\lambda = 500\,nm`$*, qui est perçue
!!! comme formant une *couleur verte*. Quelle est la fréquence temporelle $`\nu`$ correspondante ?   
!!! <br>
!!! $`\lambda = c\,T = \dfrac{c}{\nu}\Longrightarrow \nu=\dfrac{\lambda}{c}`$   
!!! <br>
!!! *$`\nu_{\lambda=500nm} = \dfrac{3\times 10^8 \; m\,s^{-1}}{500\times 10^{-9}\,m} = 6\times 10^{14}\,Hz`$*   
!!! <br>
!!! Aucune chaine de mesure n'est capable de suivre la variation de la puissance instantanée au sein d'une 
!!! *période temporelle de l'onde $`T=1\,/\,\nu = 1,6\times 10^{-15\,s}`$*.
!!!
!!! *Photodétecteurs comme oeil* ne sont *seulement sensibles à la puissance moyennée*.
!!!
!!! Pour le calcul d'une figure d'interférence ou de diffraction dans le dommaine visible, vue par l'oeil
!!! ou mesurée par un photodétecteur ou une matrice de détecteur, la grandeur physique à prendre en compte est
!!! le *carré de l'amplitude* de l'onde.
!!! </details>

!!! <details markdown=1>
!!! <summary>
!!! *Exemple 2*
!!! </summary>
!!! <br>
!!! *notre perception des sons.* <br>
!!!
!!! Le *spectre sonore audible* par l'ouïe humain s'étend de *20 à 20000 Hz*
!!!
!!! La chaine de mesure des sons de l'ouïe humain traduit, au stade final de la conscience, fréquence et intensité
!!! de l'onde sonore en terme de hauteur, de timbre et niveau d'intensité d'un son.
!!!
!!! Nous ne discernons pas la variation d'intensité sonore au sein d'une période temporelle d'un son
!!! pur (ou sinusoïdal). Nous ne sommes sensibles qu'à la puissance moyenne de l'onde sonore.
!!! </details>


#### Comment calculer l'amplitude seule de l'onde résultante ?

##### 1 - Superposition de deux ondes synchrones (cohérentes en optique) d'égales amplitudes.

* En **notation réelle ou en notation complexe**, les calculs sont de *difficultés équivalentes*. 

##### 2 - Superposition de deux ondes d'amplitude différentes,<br>ou d'un grand nombre d'ondes synchrones (cohérentes en optique) d'amplitudes égales :

Dans le cas d'un nombre supérieur à deux d'ondes synchrones (ou cohérente en optique) et 
lorsque le pas de déphasage entre deux ondes consécutives est constant, 
le calcul en notation complexe montre toute sa puissance,
là où le calcul en notation réelle se révèle rapidement complexe ou impossible.

Ainsi, la **notation complexe permet** le calcul de :

* la **figure d'interférences** créée par le grand nombre de fentes 
  d'un *réseau de diffraction*,  de comprendre ses propriétés et son fonctionnement.

- la **figure de diffraction** créée par une *fente suffisamment large*, 
 ce qui est équivalent à une infinité de sources secondaires ponctuelles distribuées sur toute la largeur de la fente.


<br>

##### 2 - Les ondes sont unidimensionnelles, d'amplitudes différentes, et se propagent dans la même direction

<br>
![](waves_sum_2_progressives_meme_sens_v2.gif)   
_La superposition de deux ondes harmoniques est une onde harmonique._
_Il reste à calculer son amplitude $`A`$ et sa phase à l'origine $`\theta`$_

* Le *calcul en notation réelle* est *très compliqué*  
  $`\Longrightarrow`$ **notation complexe**.



![waves_interferences_ventres_noeuds](waves_interferences_ventres_noeuds_niv_3a_L1200.gif)

niveau 2


--------------------------------------------

#### Qu'est-ce que le phénomène de diffraction ?

à faire

![](diffraction-lambda-wave_L1000.gif)

![](diffraction-width-split_v2_L1000.gif)

--------------------------------------------

#### Quelle différence entre interférence et diffraction ?

* Il n'y a pas de différence.

* Les deux phénomènes sont liés à la distribution spatiale d'amplitude ou d'intensité d'une onde
  résultante créée par un ensemble fini de sources synchrones, ou cohérentes (ondes lumineuses).
   * le terme **interférence** est utilisé quand les sources qui interfèrent sont des **sources discrètes**.   
     _exemple : figure d'interférence de deux fentes très fines._
   * le terme **diffraction** est utilisé quand les *sources forment un continuum*.   
     _exemple : figure de diffraction d'une fente large._

* Interférence et diffraction agissent toujours ensemble.   
     _exemple : figure d'interférence et de diffraction de deux fentes larges._
  


#### Qu'est-ce que le principe de Fresnel-Huygens ?

 * Enoncé : 
   
 * Domaine de validité :
    * donne une distribution d'intensité très proche de celle observée en réalité,
      lorsque celle-ci est calculée suffisamment loin des fentes
 * permet de calculer la figure de diffraction-interférence observée derrière un écran opaque
   percé de fentes et éclairé par une source cohérentes.
 * Lien avec la physique :


--------------------------------------------

#### Qu'est-ce que le phénomène de réflexion ?

à faire



--------------------------------------------

#### Qu'est-ce que le phénomène de réfraction ?


![refraction d'une onde plane sur un dioptre plan](wave-optics-n3-refraction-1_v2_L1000.gif)











<!-------------



#### Quels phénomènes sont caractéristiques d'une onde ?

![waves-sinusoide-lambda-n3_L1200](waves-sinusoide-lambda-n3_L1200.gif)

figure à transférer en niveau 2

...



#### Qu'est-ce que le phénomène de réfraction ?


#### Qu'est-ce qu'une onde périodique ?


#### Qu'est-ce que le phénomène d'interférence ?



#### Qu'est-ce qu'une onde stationnaire ?




![waves_interferences_ventres_noeuds](waves_interferences_ventres_noeuds_niv_3a_L1200.gif)

niveau 2


#### Quelles sont les différentes grandeurs physique caractérisant une onde périodique ?

![refraction d'une onde plane sur un dioptre plan](wave-optics-n3-refraction-1_L1000.gif)

niveau 2 reprise au 3?


------------>


