---
title: Les ondes en physique
published: true
routable: true
visible: false
lessons:
    - 
        slug: waves-conceptual-and-learning-patterns
        name: PANORAMA-234 : Les ondes, une vision générale
        order: 1
---

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Colline

---------------------------


### **Les ondes** *en physique*

<!--
# <p style="font-size:70%;text-align: center;">Les ondes en physique</p>
<p style="font-size:75%;text-align: center;">Naissance du concept d'onde</p>
-->

#### Naissance du concept d'onde

* Chacun de nous a déjà lancé un ballon, ou jeté un cailloux. À chaque instant ces 
  objets occupent une position bien définie dans l'espace et suivent une trajectoire 
  que nos yeux peuvent suivre. Cette expérience sensible est à la base de notre concept
  intuitif de corps matériels, objets bien définis,  d'extension limité dans l'espace, 
  et qui se déplacent selon les lois de la physique.   
<br>
  Mais notre expérience sensible ne se limite pas à ces objets localisés. Chacun de 
  nous a déjà **lancé des cailloux dans l'eau** ou observé les gouttes de pluie tomber 
  à la surface paisible d'un étang ou d'une flaque d'eau. Leurs impacts perturbent 
  la surface de l'eau, créant de **petites vaguelettes circulaires** qui *se propagent*,
  *se renforcent ou s'amenuisent* lorsqu'elles se croisent, et *contournent les obstacles*
  rencontrés sur leur parcours.   
  <br>
_image gif animée à faire ou achter : pluie sur l'étang, goutelettes crééent vaguelettes
 qui se superposent et interfèrent._
  <br>
  Ces vaguelettes sont à la **base de notre concept intuitif d'ondes mécaniques**, 
  perturbations d'un milieu matériel continu et étendu, qui se propagent,
  peuvent interférer et être diffractées. 

* Les **propriétés des ondes mécaniques**, 
   * *propagation*
   * *interférences*
   * *diffraction* par un obstacle
   * *réflexion et transmission* à l'interface entre deux milieux matériels différents,
   * *transport d'énergie* et de quantité de mouvement, *mais pas de matière* sur de longues
   distances, 

   **sont retrouvées sur des phénomènes plus subtils** observés dans la nature
   puis décrits mathématiquement, ou bien d'abord prévus par la théorie physique
   avant d'être confirmés par l'expérimentation.

<br>

![](waves-interferences-diffraction-2_L1200.jpg)
_Représentation des phénomènes d'interférences et de diffraction._

<br>

#### Des ondes de différents types

* Aujourd'hui, ce sont **quatre types d'ondes** qui ont été observées, depuis les *ondes mécaniques* 
  intuitives, jusqu'aux ondes *gravitationnelles* et les ondes *quantiques* en passant par 
  les ondes *électromagnétiques*. Dans l'ordre, ces ondes **correspondent à des niveaux
  de réalités de plus en plus subtils**, en lien avec la vitesse de la lumière $`c`$, 
  et modélisés par des théories physiques aux mathématiques de plus en plus abstraites. 

<br>

![](waves-introduction-n2_L1200.png)
_Quatre type d'ondes en physique, pour décrire des niveaux de réalité de plus en plus subtils et abstraits._

<br>

##### **Ondes mécaniques** *$`(\mathscr{v} < c)`$*

* Ce sont donc **les plus connues, intuitives**, et elles sont très **faciles à observer**. Elles correspondent à une perturbation qui se propage dans un milieu matériel :
   * *vaguelettes* et ondulations à la surface de l'eau,
   * *sons* qui se propagent dans l'air,
   * *ondes sismiques* qui se propagent dans le sol,
   * *ondulations* d'un ressort ou d'une corde d'un instrument de musique.

* Toutes **ces ondes sont matérielles**, leur vitesse de propagation $`\mathscr{v}`$ est inférieure à la vitesse de la lumière $`c`$.

* Nécessitant un milieu matériel, elles *ne peuvent pas voyager dans le vide*.

--------

<br>

##### **Ondes électromagnétiques** *$`(\mathscr{v} = c)`$*

* Elles ne résulte pas de la perturbation d'un milieu matériel, mais *sont formées*
  d'un **champ électrique et** d'un **champ magnétique perpendiculaires qui s'auto-entretiennent**.   
  <br>
  Comme il n'existe pas de milieu support des ondes électromagnétiques, elles **peuvent
  voyager dans le vide**, entre autre le vide interstellaire.

* Ces ondes incluent :
   * les *ondes-radio*
   * les *micro-ondes*
   * les *infra-rouges*
   * la *lumière visible*
   * les *ultra-violets*
   * les *rayons X*
   * les *rayons gamma*

* **Nos yeux perçoivent uniquement** une petite partie de ce spectre, la *lumière visible*.   
  <br>
  Comme **ces ondes** sont de l'**énergie pure** (elles n'ont pas de masse au repos), elles sont 
  *beaucoup plus abstraites*.      
  <br>
  À tout moment, **notre corps est traversé** par des *ondes-radio*, des *ondes-télé*, des *ondes Wifi* qui
transportent de la musique, des images, des paroles d'entrevues, etc. 
**Sans la technologie**, nous n'aurions *aucune connaissance de la plupart de ces ondes*.

* La **vitesse des ondes électromagnétiques** est
  toujours *exactement $`c = 299\,792\,458 m\,s^{-1}`$*, constante fondamentale de la nature appelée
  *vitesse de la lumière dans le vide*.   
  <br>
  Ne dépendant donc pas de l'état de mouvement de l'observateur qui mesure cette vitesse, ces ondes
  **défient notre intuition classique** du monde. Elles constituent l'*une des preuves expérimentales* du couplage de l'espace et du temps
  au sein *de l'espace-temps* décrit d'abord par la **relativité restreinte, puis** par la relativité **générale*.

<br>
![](https://m3p2.com/fr/temporary_ins/waves/n2/overview/linear-electromag-wave-n3_L1200.gif)
![](https://m3p2.com/fr/temporary_ins/waves/n2/overview/elliptic-wave-electromag-wave-n3_L1200.gif)
_Deux états de polarisation différents, rectiligne (haut) et elliptique (bas), d'une onde électromagnétique._

--------

<br>

##### **Ondes gravitationnelles** *$`(\mathscr{v} = c)`$*

* Contrairement aux ondes électromagnétiques qui voyagent dans l'espace et le temps, les
**ondes gravitationnelles** sont *encore plus abstraites**, elles sont une
*vibration du tissu de l'espace-temps lui-même*. 

* L'**espace-temps** est déformé par la présence de matière (ce qui
cause la gravitation) mais, en plus, il **peut vibrer** lors du *passage d'ondes gravitationnelles*
produites lors d'évènements violents dans l'univers.   
<br>
Nos sens ne peuvent absolument pas percevoir ces ondes. 

* Décrites par la relativité générale, elles **voyagent** *à la vitesse de la lumière $`c`$*.

--------

<br>

##### **Ondes quantiques** *($`\mathscr{v} > c`$ dans certains cas)*

idées à compléter et mettre en forme :

A. La fonction d'onde d'une particule (appelée Psi) est gouvernée par l'équation de
Schordinger. Elle n'est pas matérielle. Une de ses particularités est de comporter une partie
imaginaire qui joue un rôle fondamental. Personne ne comprend encore le sens réel de cette
onde. Elle est limitée par la vitesse de la lumière, sauf au moment d'une mesure
(effondrement de la fonction d'onde) qui est un phénomène non-local, i.e. instantané (donc
avec v > c). Ce comportement non-local est fondamentalement aléatoire et ne permet donc
pas de communiquer (sinon cela impliquerait l'existence de paradoxes temporels).
B. L'intrication quantique correspond à un niveau de réalité encore plus abstrait. Le lien
quantique qui unit deux particules intriquées (qui ont interagi ensemble dans le passé) est
une connexion absolument extraordinaire qui existe hors de l'espace et du temps :
Ce lien :
- est indétectable par aucune technologie connue
- ne diminue pas avec la distance
- n'est pas arrêté par les obstacles quels qu'ils soient
- a un comportement instantané
- existe hors de l'espace et du temps (voir ci-dessous)
Ce lien, fondamentalement non-local, est à la base de la téléportation quantique. Lorsque
l'état d'une particule est téléporté d'un endroit A à un endroit B, l'information se propage
instantanément de A à B, et ne passe pas par l'espace physique entre A et B (c'est pourquoi
on dit que ce lien existe hors de l'espace et du temps). La compréhension conceptuelle de ce
phénomène est une des grandes questions ouvertes de l'interprétation de la physique
quantique, elle est le siège de grands débats entre les physiciens.
Notes :
1. La formulation mathématique de la mécanique quantique est parfaitement bien comprise
et parfaitement bien vérifiée expérimentalement ; c'est son interprétation conceptuelle qui
est matière à controverse.
2. L'action instantanée de l'intrication quantique est aléatoire et ne permet pas de
communiquer. Cependant, la téléportation quantique permet de communiquer car elle
comporte deux étapes : une première étape véhiculée par l'intrication, et une deuxième
limitée par la vitesse de la lumière. Par conséquent, la téléportation complète est limitée par
la vitesse de lumière.






