---
title: 'Spherical refracting surface  : overview'
media_order: dioptre-1.gif
---

### What is a refracting surface ? 

#### Spherical refracting surface : physical description

* Local **spherical interface separating two transparent media of different refractive indices**.

* can be **foud in nature** : examples : when we look through the flat and quiet surface of a lake*, or when we look at something inside a fish ball aquarium.

<!-- fig 1 to add-→
<br>
Fig. 1. The spherical refracting interface of a fish ball aquarium.

* **appears in the design and modeling of other optical elements** : examples:<br>
\- a glass window pane is the combinaison of two parallel plane refracting interfaces (air/glass, then glass/air) that are rotationaly symmetrical around a same axis.

#### Spherical refracting interface versus 
spherical refracting surface

!!!! DIFFICULT  POINT:<br>
!!!! A same plane or spherical plane refracting interface will have two different optical behaviors, will be modeled by two different sets of parameters, depending on the direction of the light propagation.
!!!!
!!!! Consider a plane interface (a thick window whose thickness and effect can be neglected) that separates air and water, and two twins (Thompson and Thomson) at equal distances on both sides of the interface.
!!!!
!!!! <!-- fig 2a to add --><br>
!!!! Fig. 2a. The situation is not symmetrical :
!!!!
!!!! * When  Thompson (in air) looks at Thomson (in water) the light propagets from Thomson to Thompson's eyes. The fact is that Thompson sees the image of his brother closer than the real position of his brother.
!!!!
!!!! <!-- fig 2b to add--><br>
!!!! Fig. 2b.
!!!
!!!! * In the opposite situation, when Thomson (in water) looks at his brother (in air), the light propagates from Thompson to Thomson's eyes. And the fact is that Thomson sees the image of his brother farther away from his real position.<br>
!!!! (Strictly speaking, the eye of a fish should be considered in this situation, eyes well adapted to vision in water and in direct contact with water. If not, we should consider that the Thomson's dive mask is filled with water, to have Thomson's eyes in contact with water and not to add another water/air refracting surface (that of the dive mask) on the path of the light rays :
!!!!
!!!! <!-- fig 2c to add-→<br>
!!!! Fig. 2c.
!!!!
!!!! All this can be predicted and calculated, but this example shows that this air/water plane refracting interface corresponds to two different plane refracting surfaces :
!!!!
!!!! * First case : refracting surface such as :<br>
!!!! \- refractive index of the medium of incident light : $n_{inc}=n_{water}=1.33$<br>
!!!! \- refractive index of the medium of emerging light : $n_{eme}=n_{air}=1$
!!!!
!!!! * Second case : for this refracting surface :<br>
!!!! \- refractive index of the medium of incident light : $n_{inc}=n_{air}=1$<br>
!!!! \- refractive index of the medium of emerging light : $n_{eme}=n_{water}=1.33$
!!!!











### Spherical refracting surface modeling.

#### Description 

![](dioptre-1.gif)

with :
* arrow : indicates direction of light propagation.
* $`n_{ini}`$ : refractive index of the initial medium.
* $`n_{fin}`$ : refractive index of the final medium.
* $`\overline{SC}`$ : algebraic distance between vertex S and center C of curvature on optical axis.



!!!! *BE CAREFUL* :<br>
!!!! In the same way as we use in English the single word "mirror" to qualify a "reflecting surface", in French is use the single word "dioptre" to qualify a "refracting surface".
!!!! The term "dioptre" in English is a unit of mesure of the vergence of an optical system. In French, the same unit of measure is named "dioptrie".
!!!! So keep in mind the following scheme :
!!!!
!!!! refracting surface : *EN : refracting surface* , *ES : superficie refractiva* , *FR : dioptre*.<br>
!!!! _A crystal ball forms a spherical refracting surface : un "dioptre sphérique" in French._
!!!!
!!!! unit of measure : *EN : dioptre* , *ES : dioptría* , *FR : dioptrie*.<br>
!!!! _My corrective lens for both eyes are 4 dioptres : "4 dioptries" in French._


#### Spherical refracting surface.

#### Analytical study

A **spherical refracting surface** in analytical paraxial optics is defined by *three quantities* :
* **$`n_{ini}`$** : *refractive index of the initial medium* (the medium on the side on the incident light).
* **$`n_{fin}`$** : *refractive index of the final medium* (the medium on the side on the emerging light, after crossing the refracting surface).
* **$`\overline{SC}`$** : the *algebraic distance between the __vertex S__* (sometimes called "pole", is the centre of the aperture) *and the __center of curvature C__* of the refracting surface.

! *USEFUL* : The whole analytic study below also applies to a plane refracting surface. We just need to remark that a plane surface is a spherical surface whose radius of curvature tends towards infinity.

##### Spherical refracting surface equation

**spherical refracting surface equation** = **"conjuction equation" for a spherical refracting surface**

**$`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=\dfrac{n_{fin}-n_{ini}}{\overline{SC}}`$**

##### Transverse magnification expression

2. I use the **"transverse magnification equation" for a spherical refracting surface**, to calculate the *__algebraic value__ of the transverse magnification* **$`\overline{M_T}`$**, then to derive the *__algebraic length__* **$`\overline{A_{ima}B_{ima}}`$** of the segment $`[A_{ima}B_{ima}]`$, that is the algebraic distance of the point image $`B_{ima}`$ from its orthogonal projection $`A_{ima}`$ on the optical axis.

By *definition :* **$`\overline{M_T}=\dfrac{\overline{A_{ima}B_{ima}}}{\overline{A_{obj}B_{obj}}}`$**.
Its *expression for spherical refracting surface :* **$`\overline{M_T}=\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$**.

I know $`\overline{SA_{obj}}$, $n_{ini}$ and $n_{fin}$, I have previously calculated $`\overline{SA_{ima}}$, so I can calculate $`\overline{M_T}`$ and deduced $`\overline{A_{ima}B_{ima}}`$


! *USEFUL* : The conjuction equation and the transverse magnification equation for a plane refracting surface are obtained by rewriting these equations for a spherical refracting surface in the limit when $`|\overline{SC}|\longrightarrow\infty`$.<br> Then we get *for a plane refracting surface :*
!
! * *conjuction equation :*&nbsp;&nbsp; $`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=0`$.
!
! * *transverse magnification equation :*&nbsp;&nbsp; $`\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$ &nbsp;&nbsp; (unchanged).
!
! This generalizes and completes the knowledge you get about plane refracting surfaces seen in your pedagogical paths in plain and hills.


#### Graphical study