---
title: Les ondes
published: false
routable: false
visible: false
lessons:
    -
      slug: waves-2
      name: LINÉAIRE-2 : Les Ondes
      order: 2
    -
      slug: panorama-waves-23
      name: PANORAMA-23 : Les ondes
      order: 1
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$


*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-1_L1200.jpg)<details>
<summary>Etape 1 : Appel à idées</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Randonnée Plaine

---------------------------


Réfléchir à un ordre logique de questions, et leur réponse, de niveau lycée.

Cet ordre sera repris dans la partie main pour un déveoppement plus traditionnel et chapitres et sous-chapitres.

Doit-être abordés tous les points concernant les ondes, lever toutes les ambiguïtés et fixer 
le vocabulaire. 

L'outil mathématique se limitera aux fonction trigonométriques. L'apport de la notation complexe pour la maîtrise sera la valeur ajoutée


<!--Grand chapitre ## : Les ondes mécaniques<br> du phénomène ondulatoire aux propriétés de l'onde--->


! LES  ONDES  MÉCANIQUES


#### Qu'est-ce qu'une onde mécanique ?

* Dans l'expression **ondes mécaniques**, le terme mécanique fait référence à un *milieu matériel*.

* Un **milieu matériel** est composé de *particules matérielles* (atomes, molécules) qui interagissent entre elles. 
  Ce milieu peut être solide, liquide ou gazeux.

* Un **milieu à l'équilibre** signifie que chaque particule occupe une position d'*équilibre stable* 
  où les *forces* qui s'exercent sur elle *s'annulent*.

* Une **perturbation** se produit lorsqu'une *particule* est *temporairement déplacée* 
  de sa position d'équilibre.

   * **Après la perturbation**, la stabilité de l'équilibre signifie que les forces agissent pour 
     ramener la particule à sa position d'équilibre, créant une *force de rappel*.
   * À cause de son *inertie*, la particule dépasse souvent sa position d'équilibre 
     avant d'être ramenée. Cela crée un **mouvement d'oscillation** qui s'atténue progressivement.

* La **particule déplacée** perturbe l'équilibre des particules voisines, devenant 
  ainsi elle-même une **source de perturbation**. Son *mouvement d'oscillation se transmet* 
  aux particules voisines avec un *léger retard* dû à leur inertie et une *légère atténuation*.

* Ainsi, la **perturbation se propage** :
   * *dans l'espace*, d'une particule à l'autre.
   * *dans le temps*, en raison du retard de mouvement d'une particule à ses voisines.

* Une **onde mécanique** est l'expression qui décrit le phénomène de *propagation 
  d'une perturbation* dans un *milieu matériel*.


#### Pourquoi se limiter d'abord aux ondes mécaniques ?

* Les **phénomènes typiques des ondes mécaniques**, comme la diffraction, les interférences
  et le décalage Doppler, sont **communs à tout type d'ondes**, y compris celles 
  qui sont moins intuitives comme les ondes électromagnétiques, gravitationnelles, ou de probabilité.

   * Les *ondes électromagnétiques* se propagent dans le vide, sans milieu matériel.
   * Les *ondes gravitationnelles* sont des perturbations de l'espace-temps lui-même.
   * Les *ondes de probabilité* décrivent la propagation de la probabilité de présence 
     d'une particule, matériel comme l'électron ou non matériel comme le photon, dans un état donné.

* Dans un premier temps,   
les **ondes mécanique, plus intuitives**, permettent de *mieux s'approprier les phénomènes ondulatoires* 
(diffraction, interférences, décalage Doppler).    
Puis,    
**L'observation de ces phénomènes** permet d'*identifier la nature ondulatoire* de l'origine de ces phénomènes.


#### Que transporte une onde mécanique ?

* Une *onde transporte* de l'**énergie** et de la **quantité de mouvement** sur 
  de longues distances, car elle met en mouvement de la matière dans le milieu perturbé.   
_Par exemple, un bouchon flottant sur l'eau se met à osciller verticalement lorsqu'il_
_est atteint par des vaguelettes, même s'il est loin du point d'impact._

* Cependant l'*onde ne transporte* **pas de matière**, car les particules oscillent 
  simplement autour de leur position d'équilibre.   
 _Le bouchon n'est pas transporté par la vague sur de longues distances, il oscille sur place._


#### Quels sont les acteurs d'une onde mécanique ?

* Une onde mécanique implique généralement **trois acteurs** avec des *rôles distincts* : la source, le milieu et le capteur.
   * La **source S** impose la *perturbation* au milieu matériel.
   * Le **milieu matériel** *propage* cette perturbation à une *vitesse dépendant du milieu*, vitesse mesurée par un observateur M immobile dans ce milieu.
   * Le **capteur C** détecte la perturbation.


#### Qu'est-ce qui détermine la vitesse de propagation ?

à faire, dépend du milieu.

Jusqu'à quel niveau de détail aller à ce niveau 2? 


#### Comment décrire mathématiquement une perturbation ?

* A l'**échelle atomique**, les particules du milieu matériel sont les atomes. 
  La *taille caractéristique* de cette échelle est l'*angström*, le dixième de nanomètre.  
  Les **atomes sont disjoints**, même s'ils sont liés dans les solides et liquides.   
<br>
La *plupart des observations* se font à une **échelle bien plus grande**.   
_Par exemple, la plus petite taille visible à l'œil nu est d'environ un dixième_
_de millimètre, soit un million de fois plus grande qu'un angström._    
<br>
Ainsi dans la description physique d'une onde, on appelle **"particule de matière"** 
le *plus petit volume observable* à l'échelle considérée. À moins de travailler 
à l'échelle atomique, ces volumes qualifiés d'élémentaires se touchent, et donc
les "particules" sont **jointives**.    
<br>
La *perturbation* est alors décrite par une **fonction mathématique $`\phi`$ continue** 
dans l'espace et le temps :   
<br>
$`\phi = \;`$**$`\boldsymbol{\mathbf{\phi(\alpha,\beta,\gamma,t)}}`$**   
&nbsp;&nbsp;&nbsp;&nbsp;où les coordonnées spatiales $`(\alpha,\beta,\gamma)`$ sont des nombres réels.

!!!! *Attention :* Les *coordonnées spatiales* indiquent la *position d'équilibre* du point matériel, 
!!!! non sa position perturbée par l'onde au cours du temps.


#### Peut-on simplifier cette description mathématique?

* L'**univers** présente **trois dimensions spatiales**. Dans un système de coordonnées spatiales,
  tout point peut être précisé par la donnée de trois nombres réels $`(\alpha,\beta,\gamma)`$.

* Une **onde matérielle** se propage nécessairement dans un *volume limité*, et présente une certaine *forme*.

* Parfois **à l'échelle d'observation**, une *forme* apparaît comme une **surface**dont l'épaisseur est invisible.   
  <br>
  Dans ce cas, la dimension spatiale de l'épaisseur peut être négligée. 
  <br>
  Un *système adapté de coordonnées* spatiales permet alors de repérer tout
  point de la surface avec **seulement deux coordonnées**. La fonction prend alors la forme :   
  <br>
  $`\phi = \;`$**$`\boldsymbol{\mathbf{\phi(\alpha,\beta,t)}}`$**

* Parfois **à l'échelle d'observation**, une *forme* apparaît comme une **ligne**dont la section droite est invisible.   
  <br>
  Dans ce cas, les deux dimensions spatiale de la section peuvent être négligées. 
  <br>
  Un *système adapté de coordonnées* spatiales permet alors de repérer tout
  point sur la ligne avec **seulement une coordonnée**. La fonction prend alors la forme :   
  <br>
  $`\phi = \;`$**$`\boldsymbol{\mathbf{\phi(\alpha,t)}}`$**


#### Comment décrire physiquement une perturbation ?

* La *perturbation* d'une onde mécanique correspond, en chaque point de l'espace, 
  à un **déplacement** de matière par rapport à sa position d'équilibre. Ce déplacement 
  peut être décrit par :
   * une *fonction scalaire $`\phi`$* qui donne une distance ou **longueur**.
   * une *fonction vectorielle $`\vec{\phi}`$* qui donne un vecteur avec une **norme** 
     représentant la **longueur** et une **direction** indiquant le sens du déplacement.

* L'aspect oscillatoire du déplacement par rapport à l'équilibre peut entraîner des 
  variations de **densité volumique** dans le milieu de propagation _(comme pour le son dans l'air)_.
  Dans ce cas :
    *la fonction $`\phi`$ est scalaire et représente une **densité volumique**.

* D'*autres grandeurs physiques* peuvent être utilisées si elles permettent la *mesure de l'onde*.



#### Quels sont les propriétés temporelles d'une onde mécanique périodique ?

à faire...  périodicité temporelle $`T`$, fréquence temporelle $`\nu`$ (pulsation $`\omega`$ au niveau 3?)






Les ondes mécaniques.

Pour effet doppler

![](wave-doppler-forward-1_L900.gif)

serait mieux si c'était la source qui se déplace..

Source et détecteur immobiles dans le milieu

![](waves-doppler-immob_1ok_L900.gif)

![](waves-doppler-immob_2ok_L900.gif)


<!--Grand chapitre ## : Les ondes en général<br> des propriétés observées au phénomène ondulatoire--->

#### Quelles sont les 


