---
title: Waves in Physics
published: true
routable: true
visible: false
lessons:
    - 
        slug: waves-conceptual-and-learning-patterns-en
        name: PANORAMA-234 : Waves, an overview
        order: 1
---

*Course under construction*, **not validated**. 
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-EN_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Stage 2 : In structuring</summary>  
1. Brainstorming
2. In structuring
3. In writing : 1/3
4. In writing : 2/3
5. In writing : 3/3
6. Under review
7. Tested with students
8. Validated, still incomplete
9. Validated, sufficient basis
10. Validated, operational, in constant improvement
</details>


##### Hill Hiking

---------------------------

### **Waves** *in Physics*

<br><br>
[multilingual version : EN , FR , ES](https://m3p2.com/polyglot/temporary-m3p2/waves/n2/waves-introduction/waves-in-physics)
<br>

<!--
# <p style="font-size:70%;text-align: center;">Waves in Physics</p>
<p style="font-size:75%;text-align: center;">Birth of the Wave Concept</p>
-->

#### Birth of the Wave Concept

* Each of us has already thrown a ball, or tossed a pebble. At every moment, these
  objects occupy a well-defined position in space and follow a trajectory
  that our eyes can track. This sensory experience is the basis of our intuitive concept
  of material bodies, well-defined objects, with limited extension in space,
  and which move according to the laws of physics.
<br>
  But our sensory experience is not limited to these localized objects. Each of us has already **thrown pebbles into water** or observed raindrops falling
  onto the calm surface of a pond or puddle. Their impacts disturb
  the surface of the water, creating **small circular ripples** that *propagate*,
  *strengthen or weaken* when they cross, and *bypass obstacles*
  encountered along their path.
  <br>
_Animated GIF to create or purchase: rain on the pond, droplets creating ripples
that overlap and interfere._
  <br>
  These ripples are at the **basis of our intuitive concept of mechanical waves**,
  disturbances of a continuous and extended material medium, which propagate,
  can interfere, and be diffracted.

* The **properties of mechanical waves**,
   * *propagation*
   * *interference*
   * *diffraction* by an obstacle
   * *reflection and transmission* at the interface between two different material media,
   * *transport of energy* and momentum, *but not matter* over long
   distances,

   **are found in more subtle phenomena** observed in nature
   and then described mathematically, or first predicted by physical theory
   before being confirmed by experimentation.

<br>

![Waves Interference Diffraction](waves-interferences-diffraction-2_L1200.jpg)
_Representation of interference and diffraction phenomena._

<br>

#### Waves of Different Types

* Today, there are **four types of waves** that have been observed, from intuitive *mechanical
  waves* to *gravitational waves* and *quantum waves*, including
  *electromagnetic waves*. In order, these waves **correspond to increasingly subtle
  levels of reality**, related to the speed of light $`c`$,
  and modeled by physical theories with increasingly abstract mathematics.

<br>

![Four Types of Waves](waves-introduction-n2-EN_L1200.jpg)
_Four types of waves in physics, to describe increasingly subtle and abstract levels of reality._

---------

##### **Mechanical Waves** *($`v \lt c`$)*

* These are therefore **the best known, most intuitive**, and they are very **easy to observe**. They correspond to a disturbance that propagates in a material medium:
   * *ripples* and undulations on the surface of water,
   * *sounds* that propagate through air,
   * *seismic waves* that propagate through the ground,
   * *oscillations* of a spring or a string of a musical instrument.

* All **these waves are material**, their propagation speed $`\mathscr{v}`$ is less than the speed of light $`c`$.

* Requiring a material medium, they *cannot travel through a vacuum*.

<br>

--------

##### **Electromagnetic Waves** *($`v = c`$)*

* They do not result from the disturbance of a material medium, but *are formed*
  by a **perpendicular electric field** and **magnetic field that self-sustain**.
  <br>
  Since there is no medium supporting electromagnetic waves, they **can
  travel through a vacuum**, including interstellar space.

* These waves include:
   * *radio waves*
   * *microwaves*
   * *infrared*
   * *visible light*
   * *ultraviolet*
   * *X-rays*
   * *gamma rays*

* **Our eyes perceive only** a small part of this spectrum, *visible light*.
  <br>
  Since **these waves** are **pure energy** (they have no rest mass), they are
  *much more abstract*.
  <br>
  At any moment, **our bodies are traversed** by *radio waves*, *TV waves*, *Wi-Fi waves* that
  carry music, images, interview speeches, etc.
  **Without technology**, we would have *no knowledge of most of these waves*.

* The **speed of electromagnetic waves** is
  always *exactly $`c = 299\,792\,458 m\,s^{-1}`*, a fundamental constant of nature called
  *speed of light in a vacuum*.
  <br>
  Not depending on the state of motion of the observer measuring this speed, these waves
  **defy our classical intuition** of the world. They constitute *one of the experimental proofs* of the coupling of space and time
  within *spacetime* first described by **special relativity**, then by **general relativity**.

<br>
![Linear Electromagnetic Wave](https://m3p2.com/fr/temporary_ins/waves/n2/overview/linear-electromag-wave-n3_L1200.gif)
![Elliptical Electromagnetic Wave](https://m3p2.com/fr/temporary_ins/waves/n2/overview/elliptic-wave-electromag-wave-n3_L1200.gif)
_Two different polarization states, linear (top) and elliptical (bottom), of an electromagnetic wave.
Without mastering the Mountain level, visual knowledge of these polarization states will allow you to understand, among other things, how you can see a movie in 3D even though it is projected on the 2D surface of a cinema screen._

! *Note* :
!
! **Electromagnetic waves**, until very recently (2015), were the *only source of all our knowledge of the Universe*:
!
! Astrophysics observes electromagnetic waves from the *Big Bang*, *galaxies*, *stars*,
! *planets*, and the *interstellar medium*.

---------------

##### **Gravitational Waves** *($`v = c`$)*

* Unlike electromagnetic waves that travel through space and time, **gravitational waves**
  are *even more abstract*; they are a *vibration of the fabric of spacetime itself*.

* **Spacetime** is deformed by the presence of matter (which
  causes gravity), but in addition, it **can vibrate** during the *passage of gravitational waves*
  produced during violent events in the universe.
  <br>
  Our senses cannot perceive these waves at all.

* Described by general relativity, they **travel** *at the speed of light $`c`$*.

! *Note* :
!
! Predicted by general relativity but observed only since 2015, the
! **gravitational waves** are at the **basis of a new astrophysics**,
! *gravitational wave astrophysics*.
! <br>
! It observes **violent and massive phenomena** in the universe:
! rapid rotations before their *merger of black holes and neutron stars*.

------

##### **Quantum Waves** *($`v \gt c`$ in some cases)*

<br>

*A - Wave Function and Measurement*

* The **wave function of a particle** (denoted by the Greek letter Psi $`\Psi`$) is governed by the
  Schrödinger equation in non-relativistic quantum mechanics, or by the Klein-Gordon,
  Dirac, Proca, Rarita-Schwinger equations (depending on the particle's spin) in quantum
  field theory (which combines and extends special relativity and quantum mechanics).

* It is *not material*, and one of its particularities is to
  *include an imaginary part* that plays a fundamental role.

* No one yet understands the real meaning of this wave.
  It is **limited by the speed of light, except at the moment of a measurement**
  (collapse of the wave function), which is a non-local, i.e., instantaneous phenomenon (therefore
  with $v > c$).
  This **non-local behavior** is *fundamentally random* and therefore
  *does not allow communication* (otherwise, it would imply the existence of temporal paradoxes).

<br>

*B - Wave Function and Entangled Particles*

* **Quantum entanglement** corresponds to an *even more abstract level of reality*.
  <br>
  The **quantum link between two entangled particles** (which have interacted together in the past) is
  an absolutely extraordinary connection that *exists outside of space and time*.
  <br>
  This link:
   * is *undetectable* by any known technology
   * *does not diminish* with distance
   * is *not stopped by obstacles* of any kind
   * has an *instantaneous behavior*, therefore *non-local*.

* **Fundamentally non-local**, this link is at the *basis of quantum teleportation*.
  <br>
  When the **state of a particle is teleported from place A to place B**,
  the *information propagates instantaneously* from A to B, and does not pass through the physical
  space between A and B (which is why it is said that this link exists outside of space and time).
  <br>
  The **conceptual understanding of this phenomenon** is *one of the great open questions*
  in the interpretation of quantum physics; it is the subject of major debates among physicists.

<br>

*C - Wave Function and Predictions*

* The **mathematical formulation of quantum mechanics** is
   * perfectly *well understood*
   * perfectly *experimentally verified*

  It is its conceptual interpretation that is a matter of controversy.

* The **instantaneous action of quantum entanglement** is *random*
  and *does not allow communication*.
  <br>
  However, **quantum teleportation allows communication** because it
  involves two steps:
   * a **first step** *carried by entanglement*,
   * a **second step** *limited by the speed of light*.

  Therefore, **complete teleportation** is *limited by the speed of light*.

! *Note* :
!
! In quantum mechanics and quantum field theory, the *wave function $`\Psi`$*
! is actually *linked to the probability of a particle's presence* in a given quantum state superposition. The probability itself is proportional to $` \Psi|^2`$.
! In this sense, it *describes the wave-particle duality*.

!! *Going Further* :
!!
!! The framework of quantum field theory, which combines and extends special relativity
!! and non-relativistic quantum mechanics, has seen many successes, including the prediction preceding the discovery of several particles such as the top quark (1995) and the Higgs boson (2011).
!!
!! However, it does not explain the phenomena predicted by general relativity (time dilation in a gravitational field, black holes, and gravitational waves, experimentally verified or observed).
!!
!! Thus, our understanding of all observed phenomena in the Universe requires two distinct theories: general relativity and quantum field theory, which seem
!! irreconcilable in their very foundations.
!!
!! Physicists continue the search for a unique principle that would give a single physical theory, of which general relativity and quantum field theory would be mere approximations,
!! and which would describe and statistically predict all phenomena at all scales of Nature.
