---
title: 'Symétries, Vecteurs polaires et axiaux'
published: true
routable: true
visible: false
lessons:
    -
        slug: symmetries-polar-and-axial-vectors
        name: PARALLÈLE : Symétries, Vecteurs polaires et axiaux
        order: 1
    -
        slug: symmetry-axial-vectors-magnetic-field-toroidal-coil-3
        name: OUTIL-MATH-3 : Symétries, vecteurs axiaux et bobines toriques
        order: 1
    -
        slug: symmetry-axial-vectors-magnetic-field-toroidal-coil-3
        name: OUTIL-MATH-3 : Symétries, vecteurs axiaux et solénoïdes
        order: 1
    -
        slug: symmetry-axial-vectors-magnetic-field-toroidal-coil-3
        name: OUTIL-MATH-3 : Symétries, vecteurs axiaux et courants rectilignes
        order: 1
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------

Stade très très préliminaire. En phase de réflexion.

### Symétrie ou antisymétrie d'un système physique par rapport à un plan

<br>

#### Comment caractériser un système physique ?

* Un observateur peut caractériser un objet par :
   * une **qualité** : propriété *non mesurable* qu'un observateur peut attribuer.   
     _Exemple : la couleur d'un objet._
   * une **grandeur physique** : propriété *mesurable*, qui peut donc être *quantifiée par un ou plusieurs nombres*
     exprimés dans une *unité de mesure*.
     _Exemple : la longueur d'une règle, exprimée en mètre_

<br>

#### Qu'est-ce qu'une grandeur physique scalaire ? vectorielle ?

* grandeur physique **scalaire** : sa *mesure* est un *nombre unique*, réel ou complexe.
* grandeur physique **vectorielle** : sa *mesure* est représentée par un *vecteur*,   
  donc dans l'espace euclidien tridimensionnel de la physique classique par *3 nombres réels ou complexes*
  qui sont les composantes du vecteurs exprimées dans une base vectorielle.

<br>

#### Quelle nécessité d'une convention d'orientation de l'espace ?

A faire


<br>


#### Qu'est-ce que la règle de la main droite ?

A faire

![](physics-mechanics-space-orientation-right-hand-rule-direction_L1200_horiz_vert.jpg)

Autre dénomination : règle du tir-bouchon

A expliquer

![](physics-mechanics-space-orientation-right-hand-rule-direction_L1200_axis.jpg)



<br>


#### Quelle différence entre une grandeur physique polaire et axiale ?

##### Grandeur physique polaire, ou vraie

* Une **grandeur physique polaire** ou **vraie** dans sa définition et donc sa mesure *ne nécessite pas de convention d'orientation* de l'espace.  

* Si une **grandeur physique polaire** qui caractérise une propriété d'une entité réelle est
  de type *scalaire*, et que sa *valeur réelle* peut prendre des valeurs positives ou négatives,
  alors le **signe** est une *propriété intrinsèque* de l'entité.

!!!!! *Terminologie* : adjectif *intrinsèque*
!!!!!
!!!!! - qui appartient en propre,<br>
!!!!! - qui est indépendant de facteurs extérieurs
!!!!!
!!!!! _(définition du dictionnaire de "linternaute.fr")_
!!!!!
!!!!! adjectif très utilisé en physique, ainsi que son *opposé : extrinsèque*.

!!! *Un exemple : La charge électrique*.
!!!
!!! * Les *particules élémentaires* (électrons, neutrons, protons, les différents types de quarks) possèdent
!!! *plusieurs propriétés physiques*, comme la *masse*, la *charge électrique*, ...
!!! * La *mesure de la charge* électrique est un *nombre réel* qui peut être *potitif, négatif ou nul*.
!!! * Le *signe* de la charge électrique est une *propriété intrinsèque* du corps portant la charge électrique.   
!!! exemples : 
!!! &nbsp;&nbsp; la charge électrique d'un électron est toujours négative.
!!! &nbsp;&nbsp; la charge électrique d'un proton est toujours positive.
!!!
!!! L'attribution d'une charge négative à l'électron et d'une charge positive au proton résulte
!!! d'un choix historique, une convention initiale historique qui entre dans la définition de l'électron
!!! et du proton.
!!!
!!! Mais le signe ne résulte pas d'une règle d'orientation de l'espace.


* Si la **grandeur physique polaire** est de type *vectorielle*, alors dans un système donné de coordonnées, 
  les *composantes individuelles* du vecteur peuvent être *positives, négatives ou nulles*.   
  <br>
  Mais là encore,
  le **signe** de chaque composante exprime une *propriété intrinsèque* du corps, exprimée dans le système de coordonnées
  choisi.

!!! *Exemples de grandeurs physiques polaires ou vraies*
!!!
!!! * La *température* d'un corps.
!!! * la *longueur* d'une règle.
!!! * le *volume* d'un corps.
!!! * la *charge électrique* d'une particule.
!!! * le *vecteur position* $`\vec{r}=\overrightarrow{OM}`$ _d'un point $`M`$ par rapport
!!!   au point origine $`O`$ d'un repère de l'espace.
!!! * le *vecteur vitesse* $`\vec{v}=\dfrac{d\vec{r}}{dt}`$ d'un point $`M`$.
!!! * le *vecteur accélération* $`\vec{a}=\dfrac{d\vec{v}}{dt}=\dfrac{d^2\vec{r}}{dt^2}`$
!!!  d'un point $`M`$.
!!! * le *vecteur quantité de mouvement* $`\vec{p}=m\,\vec{v}`$ d'un corpuscule au point $`M`$ de masse $`m`$. 
!!! * le *vecteur force* totale $`\vec{F}`$ appliquée à un corpuscule de masse $`m`$ au point $`M`$,
!!!   relié en physique classique
!!!   au vecteur accélération par la seconde loi de Newton $`\vec{F}=\dfrac{d\vec{p}}{dt}`$.
!!! * le *vecteur champ électrique* $`\vec{E}`$ qui exerce une force $`\vec{F}=q\,\vec{E}`$
!!!   sur un corpuscule de charge électrique $`q`$.
!!! * un *vecteur élément de courant* $`I\,\overrightarrow{dl}=\dens_{charge}^{3D}\overrightarrow{v}=\overrightarrow{j}d\tau`$.

  <!--------------------------------------------
  _Exemples de grandeurs physiques polaires ou vraies :_   
  * _La __température__ d'un corps._
  * _la __longueur__ d'une règle._
  * _le __volume__ d'un corps._
  * _la __charge__ électrique d'une particule._
  * _le __vecteur position__ $`\vec{r}=\overrightarrow{OM}`$ _d'un point $`M`$ par rapport_
    _au point origine $`O`$ d'un repère de l'espace._
  * _le __vecteur vitesse__ $`\vec{v}=\dfrac{d\vec{r}}{dt}`$ d'un point $`M`$_.
  * _le __vecteur accélération__ $`\vec{a}=\dfrac{d\vec{v}}{dt}=\dfrac{d^2\vec{r}}{dt^2}`$_
    _d'un point $`M`$._ 
  * _le __vecteur quantité de mouvement__ $`\vec{p}=m\,\vec{v}`$ d'un corpuscule au point $`M`$ de masse $`m`$._ 
  * _le __vecteur force__ totale $`\vec{F}`$ appliquée à un corpuscule de masse $`m`$ au point $`M`$,_
    _relié en physique classique_
    _au vecteur accélération par la seconde loi de Newton $`\vec{F}=\dfrac{d\vec{p}}{dt}`$._
  * _le __vecteur champ électrique__ $`\vec{E}`$ qui exerce une force $`\vec{F}=q\,\vec{E}`$_
    _sur un corpuscule de charge électrique $`q`$._
  * _un_ __vecteur élément de courant__ $`I\,\overrightarrow{dl}=\dens_{charge}^{3D}\overrightarrow{v}=\overrightarrow{j}d\tau`$.
-------------------------------->

##### Grandeur physique axiale, ou pseudo grandeur physique.

* Par opposition au cas précédent, une **grandeur physique axiale** ou **peudo-grandeur physique** 
  dans sa mesure *nécessite une* **convention d'orientation de l'espace**.  

* Si une **grandeur physique axiale** qui caractérise une propriété d'une entité réelle est
  de type *scalaire*, et que sa *valeur réelle* peut prendre des valeurs positives ou négatives,
  alors le **signe** dépend d'une *convention d'orientation de l'espace*.

!!! *Exemples de grandeurs physiques axiales*
!!! 
!!! * le **vecteur champ magnétique** $`\vec{B}`$ qui exerce une force $`\vec{F}=q\,\vec{v}\wedge\vec{B}`$
!!!   sur un corpuscule de charge électrique $`q`$ et de vitesse $`\vec{v}`$.
!!! * le **moment $`\overrightarrow{\mathcal{M}^t}\big(\vec{F}\big)`$ d'une force** $`\vec{F}`$ appliquée en un point $`P`$
!!!   par rapport à un point $`O`$ : $`\overrightarrow{\mathcal{M}^t}\big(\vec{F}\big)=\overrightarrow{OP}\wedge\overrightarrow{F}`$.

!! *Pour aller plus loin* :
!! <details markdown=1><summary>Tenseurs polaires et axiaux.</summary>
!!
!! _niveau supérieur, "montagne"_
!!
!! Les *tenseurs* sont une *généralisation des scalaires et des vecteurs*.
!! Leur étude est nécessaire, car certaines grandeurs et propriétés physiques ont besoin,
!! pour être décrites quantitativement, de plus de composantes que les 3 composantes d'un
!! vecteur exprimé dans une base donnée.</details><br>
!! <br>

  <!--------------------------
  _Exemples :_   
  * _le __vecteur champ d'induction magnétique__ $`\vec{B}`$ qui exerce une force $`\vec{F}=q\,\vec{v}\wedge\vec{B}`$_
    _sur un corpuscule de charge électrique $`q`$ et de vitesse $`\vec{v}`$._
  * _le __moment $`\overrightarrow{\mathcal{M}^t}\big(\vec{F}\big)`$ d'une force__ $`\vec{F}`$ appliquée en un point $`P`$_
    _par rapport à un point $`O`$ : $`\overrightarrow{\mathcal{M}^t}\big(\vec{F}\big)=\overrightarrow{OP}\wedge\overrightarrow{F}`$._
 ------------------------------->


<br>


#### Pourquoi distinguer les grandeurs polaires des grandeurs axiales ?

<br>
*De part et d'autre*, ou *sur un plan de symétrie ou d'antisymétrie pour sa cause*, un **effet** a
un *comportement différent* selon sa **nature polaire ou axiale**.

!! *Pour aller plus loin* :  
!! <details markdown=1><summary>Propriétés physiques polaires et axiales, et symétries cristallines.</summary>
!!
!! _niveau supérieur, "montagne"_
!!
!! Une *propriété physique* est ce qui *relie deux grandeurs physiques* caractérisant
!! un corps donné. Pour une grandeur physique *"excitation"* appliquée à un corps, 
!! la propriété physique *"réponse"* du corps à l'excitation dépend de la propriété
!! physique du corps qui relie excitation et réponse.
!!
!! _Par exemple, en tout point $`P`$ d'un corps matériel, un champ électrique_ $`\vec{E}_P`$ _donné appliqué de l'extérieur_ 
!! _en ce point (excitation) induit en ce point un vecteur densité volumique de courant_ $`\vec{j}_P`$ _(réponse)_
!! _naissance en tout point du corps à un vecteur densité volumique de courant, dont l'amplitude dépend du matériau_
!! _à travers sa propriété physique conductivité électrique_ $`\sigma_p`$ _au point_ $`P`$ :<br>
!! $`\vec{j}_P = \sigma_P\;\vec{E}_P`$<br>
!!
!! * Une *propriété physique isotrope* est quantifiée par un *simple nombre réel (tenseur de rang 0)*<br>
!! * Une *propriété physique anisotrope* est quantifiée par un *vecteur (tenseur de rang 1)* ou un
!! *tenseur de rang supérieur à 2*.
!!
!! Dans un cristal, la *nature polaire ou axiale d'une propriété physique* sera *importante*, 
!! pour *déterminer la forme générale du tenseur représentatif* selon les diverses symétries
!! cristallines.
!!
!! La maîtrise des propriétés anisotropes ouvre la porte à des effets physiques insoupçonnés
!! qui sont à la base de nombreux dispotitifs  optiques, optoélectroniques, électromécaniques, etc.</details><br>
!! <br>

<br>


#### Qu'est-ce que le symétrique d'un point par rapport à un plan ?

A faire

![](Point-mirror-symmetry_L1200.gif)

<br>

#### Qu'est ce qu'un système physique qui admet un plan de symétrie ?

A faire

<br>


#### Qu'est ce qu'un système physique qui admet un plan d'antisymétrie ?

A faire


