---
title: 'N3-electromagnetism-learning-pattern'
published: true
routable: true
visible: false
lessons:
    - 
        slug: electromagnetism-conceptual-and-learning-patterns
        name: PANORAMA : Électromagnétisme, une vision générale
        order: 2
    -  
        slug: Gauss-theorem-in-EM-learning-pattern
        name: PANORAMA : Le théorème de Gauss dans l'électromagnétisme
        order: 3
    -  
        slug: Ampere-theorem-in-EM-learning-pattern
        name: PANORAMA : Le théorème d'Ampère dans l'électromagnétisme
        order: 3
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

### Guide d'apprentissage aux niveaux contreforts et montagne

<br>

_" &nbsp;Progresser sur les chemins de la connaissance te demandera entraînement et persévérance, mais n'oublie pas qu'avec le temps tu verras plus loin, la perspective sera plus belle, et ton pas plus assuré et endurant.&nbsp;"_

#### Randonnée Contreforts

![une randonneur sur un chemin de contreforts, pour symboliser le niveau d'effort, mais la beauté du paysage.](randonnee_contreforts_L1200.jpg)

##### Apprenant de toute spécialité

_(à retravailler...)

La maîtrise nouvelle de l'électromagnétisme au niveau contrefort 
te nécessite de connaître et maîtriser les concepts de la physique général à ce niveau : 

* circulation $`\mathscr{C}`$ d'un champ vectoriel $`\overrightarrow{X}`$ le long d'un parcourt $`\Gamma`$, que le parcourt soit :
   * ouvert : $`\displaystyle\mathscr{C}=\int_{\Gamma}\overrightarrow{X}\cdot\overrightarrow{dl}`$
   * fermé : $`\displaystyle\mathscr{C}=\oint_{\Gamma}\overrightarrow{X}\cdot\overrightarrow{dl}`$

* flux $`\phi(\overrightarrow{X})`$ d'un champ vectoriel  $`\overrightarrow{X}`$ à travers une surface macroscopique ouverte $`S`$ :   
   $`\displaystyle\Phi_S ({\overrightarrow{X}})=\iint_S \overrightarrow{X}\cdot\overrightarrow{dS}`$

* opérateur gradient $`\overrightarrow{grad}V`$ d'un champ scalaire $`V`$, 
   * son lien local avec élément différentiel $`dV=\overrightarrow{grad}V\cdot\overrightarrow{dl}`$
   * son lien macroscopique avec la variation de $`V`$ le long d'un parcourt $`\Gamma`$, que le parcourt soit :   
   - ouvert : $`\displaystyle V_A-V_B=\int_{\Gamma}\overrightarrow{grad}V\cdot\overrightarrow{dl}`$, et ne dépendant alors pas du chemin entre $`A`$ et $`B`$.   
   - fermé : $`\displaystyle V_A-V_B=\oint_{\Gamma}\overrightarrow{grad}V\cdot\overrightarrow{dl}=0`$.


Ces concepts sont introduits dans les chapitres suivants étudiants les causes et les effets des champs électriques et magnétiques stationnaires :
   
* *Electrostatique de Coulomb*
* *Electrocinétique*   
  <!--porteurs de charge, courant, vecteurs densité volumique et densité superficielle de courant, résistance, 
    conductivité et résistivité électrique, mobilité-->
* *Magnétostatique de Biot et Savart*

<br>
Une **Introduction à l'electromagnétisme** t'est proposée si tu souhaite quitter l'électromagnétisme à cette étape contreforts.   
Elle te donnera une vision des causes et des effets des champs électromagnétiques variable, et comprend les chapitres :
   * *Les phénomènes d'induction électromagnétique*
   * *Les ondes électromagnétiques*



##### Apprenant de spécialités Physique et Mathématique appliquée

La compréhension et la maîtrise des équations de Maxwell au niveau supérieur nécessite 
de commencer à te familiariser avec les concepts microscopiques nouveaux de :

* opérateur divergence $`div\,\overrightarrow{X}`$ d'un champ vectoriel $`\overrightarrow{X}`$,      
    s'appuyant sur le concept de flux $`\phi(\overrightarrow{X})`$ d'un champ vectoriel $`\overrightarrow{X}`$ à travers une surface macroscopique fermée S : $`\displaystyle\Phi_S ({\overrightarrow{X}})=\oiint_S \overrightarrow{X}\cdot\overrightarrow{dS}`$  
    
* opérateur rotationnel $`\overrightarrow{rot}\,\overrightarrow{X}`$ d'un champ vectoriel $`\overrightarrow{X}`$,   
    s'appuyant sur le concept de circulation $`\mathscr{C}`$ d'un champ vectoriel $`\overrightarrow{X}`$ le long d'un parcourt fermé $`\Gamma`$ : $`\displaystyle\mathscr{C}=\oint_{\Gamma}\overrightarrow{X}\cdot\overrightarrow{dl}`$


Ces concepts sont nécessaires pour établir le théorème de Gauss en électrostatique (qui sera la première équation de Maxwell en électromagnétisme) et le théorème d'Ampère en magnétostatique dans les chapitres spécifiques :

* *Électrostatique de Gauss* 
* *Magnétostatique d'Ampère*

<!-- Suite à mettre au point --------

* *Milieux conducteurs dans des champs électriques et magnétiques stationnaires*
  <!--porteurs de charges libres, équilibre statique, charges en surface, dans le conducteur :
   $`E=0, V=cste, \rho^{3D}=0`$ , Effet Hall
* *Milieux diélectriques dans un champ électrique stationnaire*
  <!--...
* Les condensateurs
  <!--...
* *Milieux magnétiques dans un champ magnétique stationnaire*
  <!--...
* Les selfs
  <!--...-->



#### Randonnée Montagne

![une randonneur sur un chemin de montagne, pour symboliser le niveau d'effort, mais la beauté du paysage.](randonnee-montagne_L1200.jpg)

**Électromagnétisme dans le vide**

* *Les équations de Maxwell*
* *Électromagnétisme en régime variable*
* *Électromagnétisme dans l'approximation des régimes quasi-stationnaires*
* *Propagation des ondes électromagnétiques dans le vide*

**Électromagnétisme dans la matière**

* *Propagation des ondes électromagnétiques dans la matière*
* *Réflexion et transmission des ondes électromagnétiques aux interfaces*







