---
title: Ecuaciones de Maxwell, fundamento del electromagnetismo.
published: true
routable: true
visible: false
lessons:
    - slug: maxwell-equations-es
      name: LINEAL - Ecuaciones de Maxwell
      order: 2
---

<!--MétaDonnée : ... -->

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

*Curso en construcción*, **no validado**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-ES_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-3_L1200.jpg)<details>
<summary>Etapa 3 : escribiendo : 1/3</summary>  
1. Lluvia de ideas
2. Estructuración
3. Escribiendo : 1/3
4. Escribiendo : 2/3
5. Escribiendo : 3/3
6. Revisión 
7. Probado con estudiantes.
8. Validado, aún incompleto
9. Validado, con base suficiente
10. Validado, operativo, en constante mejora.
</details>

<!--MétaDonnée : ... -->

##### Caminata Montaña :&nbsp;física, matemáticas aplicadas


---------------------------

### Las ecuaciones de Maxwell

<!--
    - 
       slug: electromagnetic-waves-propagation-from-vacuum-to-isotropic-media-es
       name: PARALELO: Propagación de ondas EM, del vacío hasta medios materiales isotrópicos
       order: 1
    -
        slug: maxwell-equations-in-EM-learning-pattern
        name: SITUACIÓN: Las ecuaciones de Maxwell en el electromagnetismo
        order: 2
    -   
        slug: combinaison-operators-for-electromagnetism
        name: TOOL-MAT: Combinación de operadores para electromagnetismo
        order: 2
@@@@@@@@@@@@@@

---
title: Équations de Maxwell , fondement de l'électromagnétisme
published: true
routable: true
visible: false
lessons:
    - slug: maxwell-equations-fr
      name: LINÉAIRE-4 - les équations de Maxwell
      order: 2
    - 
       slug: electromagnetic-waves-propagation-from-vacuum-to-isotropic-media-fr
       name: PARALLÈLE-4 : Propagation des ondes EM, du vide aux milieux matériels isotropes
       order: 1
    -
        slug: maxwell-equations-in-EM-learning-pattern-fr
        name: SITUATION-34 : Les équations de Maxwell dans l'électromagnétisme
        order: 2
    -   
        slug: combinaison-operators-for-electromagnetism-fr
        name: OUTIL-MATH-4 : Combinaison d'opérateurs pour l'électromagnétisme
        order: 2
    -  
        slug: from-gauss-ampere-to-maxwell-fr
        name: PANORAMA-34 : de Gauss et Ampère à Maxwell
        order: 3
    - slug: maxwell-electromagnetism-from-field-to-potential
      name: PARALLÈLE-4 : du champ (E,B) au potentiel (V,A)
      order: 1
    - slug: from-maxwell-to-quasi-stationary-fields-approximation-fr
      name: PARALLÈLE-4 : de Maxwell à l'ARQS
      order: 1

---

<!--MétaDonnée : ... -->


*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-7_L1200.jpg)
<details>
<summary>Paso 7: En prueba con estudiantes</summary>
1. Lluvia de ideas
2. Estructuración
3. Redacción: 1/3
4. Redacción: 2/3
5. Redacción: 3/3
6. Revisión
7. En prueba con estudiantes
8. Validado, pero incompleto
9. Validado, base suficiente
10. Validado y funcional
</details>

##### Randonnée Montagne :&nbsp; _physique_

---------------------------

### ÉLECTROMAGNÉTISME

### **Las ecuaciones de Maxwell**
*y el campo electromagnético $`(\overrightarrow{E}\,,\overrightarrow{B})`$*

---

**RESUMEN**
: ---
  *Dominio de validez*:
  Muy general. En el vacío, e incluso en la materia si la escala de observación no es mesoscópica,
  sino atómica.
  Sin embargo, una descripción más exacta de la materia a escala atómica
  requiere el uso de la física cuántica.

  *Atención: Las expresiones a continuación solo son válidas en el Sistema Internacional de Unidades $`SI`$, antes $`MKS`$.*

---

*Forma local de las ecuaciones de Maxwell*

* En todo punto del espacio y en todo instante:
  <br>
  $`\left\{\begin{array}{l}
  \text{div } \overrightarrow{E} = \dfrac{\rho}{\epsilon_0}\quad \small{(Maxwell-Gauss)}\\
  \text{div } \overrightarrow{B} = 0\quad \small{(Maxwell-Thomson)}\\
  \overrightarrow{\text{rot}} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}\quad\small{(Maxwell-Faraday)}\\
  \overrightarrow{\text{rot}} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\\
  \hspace{3,5cm}\small{(Maxwell-Ampère)}
  \end{array}\right.`$
  <br>
  con $`\rho`$ densidad volumétrica de carga
  &nbsp;&nbsp; y $`\overrightarrow{j}`$ vector densidad volumétrica de corriente.

  * $`\Longrightarrow`$ la conservación de la carga:
    $`\text{div}\,\overrightarrow{j} +\dfrac{\partial \rho}{\partial t}=0`$

  * $`\Longrightarrow`$ la propagación en el vacío
    de la onda electromagnética (EM), parte variable del campo electromagnético:
    <br>
    $`\left\{\begin{array}{l}
    \Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}\\
    \Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}
    \end{array}\right.`$
    <br>
    a la celeridad $`c=299\,792\,458\, \text{m}\,\text{s}^{-1}\approx 3\times 10^8\, \text{m}\,\text{s}^{-1}`$,
    constante fundamental de la naturaleza.

  * $`\Longrightarrow`$ el campo EM contiene energía,
    en densidad volumétrica:
    $`\small{\dens}_{energ.EM}`$$`\; = \dfrac{\epsilon_0\,\overrightarrow{E}\cdot\overrightarrow{E}}{2}+\dfrac{\overrightarrow{B}\cdot\overrightarrow{B}}{2\mu_0}`$

  * $`\Longrightarrow`$ todo $`\overrightarrow{dS}`$ recibe la potencia EM:
    $`d\overrightarrow{\mathcal{P}}_{EM}=\overrightarrow{\Pi}\cdot\overrightarrow{dS}`$
    con $`\overrightarrow{\Pi}=\dfrac{\overrightarrow{E}\land\overrightarrow{B}}{\mu_0}`$ vector de Poynting.

  * $`\Longrightarrow`$ el campo EM cede energía a la materia por efecto Joule:
    $`\mathcal{P}_{cedida} = \overrightarrow{j}\cdot\overrightarrow{E}\,d\tau`$

  * $`\Longrightarrow`$ toda partícula cargada acelerada genera una onda electromagnética.  

<br>

#### ¿Cuál fue el trabajo de Maxwell?

* *Hasta mediados del siglo XIV*, **electricidad, magnetismo y óptica** se estudiaban en *áreas científicas distintas*.

* Sin embargo, la *observación de fenómenos naturales y experimentos de laboratorio* mostró una
**interacción incomprendida entre electricidad, magnetismo** e incluso **óptica**.
  * Natural: el rayo puede cargar objetos metálicos, imantar el hierro y crear un relámpago.
  * Experimentos:
    - Una corriente desvía la aguja de una brújula.
    - El movimiento de un imán genera una corriente.

* Buen matemático, **Maxwell** *sintetizó los resultados experimentales* de su época,
que se resumen en 4 ecuaciones, las *ecuaciones de Maxwell*.

* Estas 4 ecuaciones **unifican electricidad, magnetismo y óptica** dentro del electromagnetismo,
y amplían la óptica a un *nuevo mundo: las ondas electromagnéticas*.

![Imagen de las ecuaciones de Maxwell](Maxwell-equation-fr.png)
*Maxwell modificó dos de las ecuaciones de la electrostática y la magnetostática,
introduciendo términos de acoplamiento entre E y B,
y revolucionó así la física.*

#### ¿Por qué decimos "ecuaciones" y no "teoremas" de Maxwell?

* Las **4 ecuaciones de Maxwell** *no están demostradas*, por lo que no constituyen teoremas.
* Son *planteadas y supuestas verdaderas*, **son postulados**.

---

#### ¿Qué son estas 4 ecuaciones de Maxwell?

##### En forma local
*(fundamental, conocer)*

* Dos **expresiones de la divergencia** de los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$ *inalteradas con respecto al caso estacionario* (electrostática y magnetostática):

  * **$`\large{\mathbf{div \overrightarrow{E} = \dfrac{\rho}{\epsilon_0}}}`$** &nbsp;&nbsp;&nbsp;(ec. *Maxwell-Gauss*).

  * **$`\large{\mathbf{div \overrightarrow{B} = 0}}`$** &nbsp;&nbsp;&nbsp;(ec. *Maxwell-Thomson*).

* Dos **expresiones del rotacional** de los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$ que *cambian y acoplan los campos $`\mathbf{\overrightarrow{E}}`$ y $`\mathbf{\overrightarrow{B}}`$*:

  * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}}`$**
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(ec. *Maxwell-Faraday*).

  * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}}`$**
  &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(ec. *Maxwell-Ampère*).

* Donde:
  * $`\rho=\rho^{3D}`$ es la densidad volumétrica de carga.
  * $`\overrightarrow{j}=\overrightarrow{j}^{3D}`$ es el vector densidad volumétrica de corriente.

------------------

* Y estas ecuaciones *reescritas con el operador nabla: $`\mathbf{\nabla}`$*:

  * **$`\mathbf{\nabla\cdot\overrightarrow{E}=\dfrac{\rho}{\epsilon_0}}`$**

  * **$`\mathbf{\nabla\cdot\overrightarrow{B}=0}`$**

  * **$`\mathbf{\nabla\land\overrightarrow{E}= -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$**

  * **$`\mathbf{\nabla\land\overrightarrow{B}= \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$**

------------------


##### Sous forme intégrale
_(savoir redémontrer)_


* Elles **se déduisent des équations locales**, avec l'aide :
   * du *théorème d'Ostrograsky* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iiint_{\Ltau} div\;\overrightarrow{X} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\Ltau} \overrightarrow{X}\cdot\overrightarrow{dS}`$*
   * du *théorème de Stokes* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{X} \cdot dS 
= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$*.

-----------

* **Ecuación de Maxwell-Gauss**:

  En todo instante $`t`$, y para todo volumen $`\tau`$:

  * $`\forall \overrightarrow{r},\;`$ *$`\mathbf{div \overrightarrow{E} = \dfrac{\rho}{\epsilon_0}}`$*
  $`\Longrightarrow \iiint_{\tau} \text{div } \overrightarrow{E}\,d\tau = \iiint_{\tau}\dfrac{\rho}{\epsilon_0}\,d\tau`$

  * $`\left.\begin{array}{l}
  \iiint_{\tau} \text{div } \overrightarrow{E}\,d\tau = \iiint_{\tau}\dfrac{\rho}{\epsilon_0}\,d\tau \\
  \iiint_{\tau} \text{div}\,\overrightarrow{E} \cdot d\tau = \displaystyle
  \oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS}
  \end{array}\right\}`$
  $`\Longrightarrow`$
  **$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\tau} \overrightarrow{E}\cdot\overrightarrow{dS}
  = \dfrac{1}{\epsilon_0} \cdot \iiint_{\tau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0}}`$**

------------

* **Ecuación de Maxwell-Thomson**:

  En todo instante $`t`$, y para todo volumen $`\tau`$:

  * $`\forall \overrightarrow{r},\;`$ *$`\mathbf{div \overrightarrow{B} = 0}`$*
  $`\Longrightarrow \iiint_{\tau} \text{div } \overrightarrow{B}\,d\tau = 0`$

  * $`\left.\begin{array}{l}
  \iiint_{\tau} \text{div } \overrightarrow{B}\,d\tau = 0 \\
  \iiint_{\tau} \text{div}\,\overrightarrow{B} \cdot d\tau = \displaystyle
  \oiint_{S\leftrightarrow\tau} \overrightarrow{B}\cdot\overrightarrow{dS}
  \end{array}\right\}`$
  $`\Longrightarrow`$
  **$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\tau} \overrightarrow{B}\cdot\overrightarrow{dS}= 0}`$**

-----------------

* **Ecuación de Maxwell-Faraday**:

  En todo instante $`t`$,
  y para toda superficie $`S`$ abierta y orientada, inmóvil y indeformable, que se apoya en un contorno $`\Gamma`$
  (por lo tanto también inmóvil e indeformable),
  con orientación compatible con la de $`S`$ según la regla de la mano derecha:

  * $`\forall \overrightarrow{r},\;`$ *$`\mathbf{\overrightarrow{rot} \,\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$*
  $`\Longrightarrow \iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big)`$
  <br>

  * $`\left.\begin{array}{l}
  \iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big) \\
  \text{Newton: espacio y tiempo independientes}, \\
  \text{el orden derivación/integración no importa}
  \end{array}\right\}`$
  $`\Longrightarrow`$
  $`\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big)`$
  <br>

  * $`\left.\begin{array}{l}
  \iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big) \\
  \iint_{S} \;\overrightarrow{rot}\;\overrightarrow{E} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}
  \end{array}\right\}`$
  $`\Longrightarrow`$
  **$`\begin{array}{l}
  &nbsp; \\
  \mathbf{\displaystyle\quad\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}= -\dfrac{d}{dt}\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}}
  \end{array}`$**
  <br>
  * Esta ecuación juega un *papel importante en los fenómenos de inducción de Neumann*.
  *La cantidad* $`\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}$,
  *de denominación histórica imperfecta "fuerza electromotriz (fem)", homogénea a una tensión, es el origen de una corriente*
  *eléctrica que atraviesa el contorno $`\Gamma`$ si este representa un circuito conductor.*

---------------

* **Ecuación de Maxwell-Ampère**:

  En todo instante $`t`$,
  y para toda superficie $`S`$ abierta y orientada, fija e indeformable, que se apoya en un contorno $`\Gamma`$
  con orientación compatible con la de $`S`$ según la regla de la mano derecha:
  <br>

  $`\forall \overrightarrow{r},\;`$ *$`\mathbf{\overrightarrow{rot} \,\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$*
  $`\Longrightarrow`$ $` \iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS}`$
  <br>

  $`\left.\begin{array}{l}
  \iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS} \\
  \text{Newton: espacio y tiempo independientes},\\
  \text{el orden derivación/integración no importa}
  \end{array}\right\}`$
  $`\Longrightarrow`$
  $`\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS}`$ $`\; = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
  \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}`$
  <br>

  $`\left.\begin{array}{l}
  \iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} \\
  \quad = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
  \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS} \\
  \iint_{S} \;\overrightarrow{rot}\;\overrightarrow{B} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}
  \end{array}\right\}`$
  $`\Longrightarrow`$

  **$`&nbsp;\mathbf{\displaystyle\;\,\oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}}`$
  $`\;\mathbf{\displaystyle= \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +\mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}}`$**
<br> 

------------

<br>

#### ¿Por qué hablamos de campo electromagnético?

* Las 2 ecuaciones de acoplamiento de $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$ implican
que **variables, $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$ no pueden existir el uno sin el otro**.

* El término *$`\dfrac{\partial\overrightarrow{B}}{\partial t}\ne 0`$ implica $`\overrightarrow{E}\ne \overrightarrow{0}`$*
* El término *$`\dfrac{\partial\overrightarrow{E}}{\partial t}\ne 0`$ implica $`\overrightarrow{B}\ne \overrightarrow{0}`$*

---

#### ¿Qué dicen las ecuaciones de Maxwell sobre la conservación de la carga?

##### Ley de conservación de la carga eléctrica

* En la materia, las **cargas eléctricas** son transportadas por los *electrones* y
los *protones* de los núcleos atómicos. *En física clásica*, estas partículas existen,
y **no pueden ni surgir de la nada, ni desaparecer**.

* Así, el **principio de conservación de la carga** eléctrica puede resumirse en una frase:
<br>
! *En todo volumen del espacio y durante un intervalo de tiempo dado, la carga eléctrica*
! *que entra en este volumen menos la carga eléctrica*
! *que sale del mismo es igual a la variación de la carga dentro del volumen.*

<br>
Esto se traduce en *escritura matemática* por la **expresión integral**:
<br>
Para toda superficie cerrada $`S`$ que delimita un volumen macroscópico $`\tau`$,
<br>
**$`\mathbf{\oiint_{S\leftrightarrow\tau}\overrightarrow{j}\cdot\overrightarrow{dS}+\iiint_{\tau}\dfrac{\partial\rho}{\partial t}\cdot d\tau=0}`$**
<br>
que se enuncia:
<br>
! *El flujo del vector densidad de corriente volumétrica a través de una superficie cerrada,*
! *es igual a la derivada temporal de la carga total contenida en el interior de esta superficie cerrada.*

![Ley de conservación de la carga](charge-conservation-law-L1200.jpg)

* Esta igualdad, al ser válida para cualquier volumen de integración, implica que
la igualdad se aplica a los integrandos mismos.
$`\Longrightarrow`$ La ley de conservación también tiene una **expresión local**, válida en todo punto del espacio, que se escribe:
<br>
**$`\mathbf{div\,\overrightarrow{j} +\dfrac{\partial \rho}{\partial t}=0}`$**

---

![Conservación de la carga](charge-conservation-1-L1200.jpg)

##### Estudio de las ecuaciones de Maxwell

* **Partamos** de la combinación de operadores notable, válida para todo campo vectorial $`\overrightarrow{U}`$,
que se enuncia:
*"La divergencia del rotacional de un campo vectorial siempre es nula."*
<br>
$`\forall \overrightarrow{X}\big(\overrightarrow{r},t\big)\;,`$*$`\quad \mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{X}\big)=0}`$*.
<br>
Apliquémosla al campo de inducción magnética $`\overrightarrow{B}`$:
<br>
**$`\mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{B}\big)=0}`$**.

* La *ley de Maxwell-Ampère*
$`\overrightarrow{rot}\,\overrightarrow{B}=\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$
permite escribir:
<br>
**$`\mathbf{div\Big(\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0}`$**

* Al dividir los términos de la derecha y la izquierda por $`\mu_0`$, la ecuación se simplifica:
<br>
$`div\Big(\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

* La ecuación ya contiene $`\overrightarrow{j}`$, busco hacer aparecer $`\rho`$.
Para ello, busco hacer aparecer $`div\,\overrightarrow{j}`$ para luego utilizar la ley de Maxwell-Gauss.
<br>
$`div\,\overrightarrow{j} + div\Big(\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

* En el marco de la *física clásica, espacio y tiempo son independientes*,
el orden de derivación por una variable espacial y una variable temporal no importa:
<br>
*$`\dfrac{\partial}{\partial t}\left(\dfrac{\partial}{\partial x}\right) =\dfrac{\partial}{\partial x}\left(\dfrac{\partial}{\partial t}\right)`$*
- El operador divergencia solo está constituido por derivadas parciales de variables espaciales.
- $`\dfrac{\partial}{\partial t}`$ es una derivada parcial de la variable tiempo.

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*$`\Longrightarrow\quad div\left(\dfrac{\partial}{\partial t}\right)= \dfrac{\partial}{\partial t}\left(div\right)`$*.
<br>
Obtenemos:
<br>
**$`\mathbf{div\,\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial}{\partial t}\left(div\,\overrightarrow{E}\right)=0}`$**

* Usando la *ley de Maxwell-Gauss $`div\,\overrightarrow{E}=\dfrac{\rho}{\epsilon_0}`$*
obtenemos la **ecuación de conservación local de la carga** eléctrica en régimen variable (por lo tanto siempre verificada):
<br>
**$`\mathbf{div\,\overrightarrow{j} +\dfrac{\partial \rho}{\partial t}=0}`$**

! *Las ecuaciones de Maxwell contienen e implican la conservación de la carga eléctrica.*

---

* Podemos *integrar esta igualdad local* sobre un volumen $`\tau`$ cualquiera:
<br>
$`\displaystyle\iiint_{\tau} \Big(div\,\overrightarrow{j} +\dfrac{\partial \rho}{\partial t}\Big)\,d\tau=0`$
<br>
*$`\displaystyle\iiint_{\tau} div\,\overrightarrow{j}\,d\tau+\iiint_{\tau}\dfrac{\partial \rho}{\partial t}\,d\tau=0`$*

* El *teorema de Ostrogradski* (= teorema *de la divergencia*) precisa que para todo campo
vectorial $`\overrightarrow{U}`$ y para todo volumen $`\tau`$,
*$`\displaystyle\iiint_{\tau} div\,\overrightarrow{U}\,d\tau=\oiint_S \overrightarrow{U}\cdot dS`$*,
$`S`$ siendo la superficie cerrada que delimita el volumen $`\tau`$.
<br>
*Aplicado al primer término* de la igualdad, obtenemos:
<br>
**$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} + \iiint_{\tau}\dfrac{\partial \rho}{\partial t}\,d\tau=0`$**.

* Al observar de nuevo que *espacio y tiempo son independientes en física clásica*, el orden de derivación o integración por una variable espacial y una variable temporal no importa:
<br>
**$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{\partial}{\partial t} \left(\iiint_{\tau}\rho \,d\tau\right)=0`$**.

* Al constatar que *$`\displaystyle\iiint_{\tau}\rho \,d\tau`$ es la carga total $`Q_{int}`$*
contenida en el volumen $`\tau`$, obtenemos la **expresión integral de la ley de conservación** de la carga:
<br>
**$`\mathbf{\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{dQ_{int}}{dt}=0}`$**.

<br> 

------------

<br>

Voici la traduction en espagnol latino-américain de la suite de ton texte, en respectant la mise en forme Markdown, les équations LaTeX et les détails techniques :

```markdown
#### ¿Puede el campo electromagnético ceder energía a la materia?

##### Potencia cedida a un portador de carga

* La **sensibilidad** de una partícula a la **interacción electromagnética** se cuantifica
por el parámetro llamado *carga* eléctrica de la partícula.

* La fuerza que describe la *acción de un campo electromagnético $`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`*
sobre una partícula de carga $`q`$ es la **fuerza de Lorentz**, cuya expresión es:
<br>
**$`\overrightarrow{F}_{\,Lorentz}=q\Big(\overrightarrow{E}+\overrightarrow{v}\land\overrightarrow{B}\Big)`$**
<br>
donde $`\overrightarrow{v}`$ es el vector velocidad de la partícula en el referencial de inercia de la observación.

* *Durante un desplazamiento elemental $`\overrightarrow{dl}`* de la partícula en el campo electromagnético
$`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`*, el **trabajo de la fuerza de Lorentz** se escribe:
<br>
**$`d\mathcal{W}_{\,Lorentz}=\overrightarrow{F}_{Lorentz}\cdot\overrightarrow{dl}`$**,
<br>
es decir,
<br>
$`\begin{align}
d\mathcal{W}_{\,Lorentz}&=q\Big(\overrightarrow{E}+\overrightarrow{v}\land\overrightarrow{B}\Big)\cdot\overrightarrow{dl}\\
&\\
&= q\Big(\overrightarrow{E}\cdot\overrightarrow{dl}\Big)+ q\Big(\overrightarrow{v}\land\overrightarrow{B}\cdot\overrightarrow{dl}\Big)\\
&\\
&= q\,\overrightarrow{E}\cdot\overrightarrow{dl} + q\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big) \\
\end{align}`$
<br>
donde $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)`$ es el producto mixto de la secuencia de los tres vectores.

* Los *vectores $`\overrightarrow{v}`$ y $`\overrightarrow{dl}=\overrightarrow{v}\,dt`* son *colineales*, el producto mixto
es nulo:
<br>
*$`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$*,

!!!!
!!!! <details markdown=1>
!!!! <summary>Recordatorios sobre el producto mixto</summary>
!!!! El producto mixto de tres vectores $`\vec{a}\,,\vec{b}\,,\vec{c}`$, denotado $`(\vec{a}\,,\vec{b}\,,\vec{c})`$
!!!! está definido por:
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{a}\land\vec{b})\cdot\vec{c}`$.
!!!! Es fácil demostrar que es invariante por permutación circular de los 3 vectores:
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{b}\,,\vec{c}\,,\vec{a})=(\vec{c}\,,\vec{a}\,,\vec{b})`$.
!!!! Es, por lo tanto, un número real, cuyo valor absoluto se identifica con el volumen del paralelepípedo
!!!! formado por los tres vectores $`\vec{a}\,,\vec{b}\,,\vec{c}`$.
!!!!
!!!! En el caso estudiado, al menos dos vectores del producto mixto $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)$
!!!! son colineales, ya que $`\overrightarrow{dl}=\overrightarrow{v}\,dt`$.
!!!! Por lo tanto, puedo asegurar que este producto mixto es nulo,
!!!! * ya sea observando que tres vectores, de los cuales dos son colineales, se inscriben en un mismo plano (2D)
!!!! y, por lo tanto, el volumen (3D) construido por estos tres vectores es nulo:
!!!! $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$
!!!! * ya sea utilizando la invariancia del producto mixto por permutación circular,
!!!! $`\Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=\Big(\overrightarrow{dl},\overrightarrow{v},\overrightarrow{B}\Big)`$
!!!! $`=dt\times\Big(\overrightarrow{v},\overrightarrow{v},\overrightarrow{B}\Big)`$
!!!! y observando que el producto vectorial de dos vectores colineales es nulo:
!!!! $`\big\Vert\overrightarrow{v}\land\overrightarrow{v}\big\Vert=\big\Vert\overrightarrow{v}\big\Vert\cdot\big\Vert\overrightarrow{v}\big\Vert\cdot \sin 0=0`$
!!!! $`\Longrightarrow \overrightarrow{v}\land\overrightarrow{v}=\overrightarrow{0}`$
!!!! $`\Longrightarrow \Big(\overrightarrow{v},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$
!!!! </details>

* $`\Longrightarrow`$ el **trabajo de la fuerza de Lorentz** se simplifica:
<br>
**$`d\mathcal{W}_{\,Lorentz} = q\,\overrightarrow{E}\cdot\overrightarrow{dl}`$**

! *Nota:*
!
! La *fuerza magnética $`\overrightarrow{F}_{\,magn.}=q\,\overrightarrow{v}\land\overrightarrow{B}`*,
! por naturaleza perpendicular al vector velocidad $`\overrightarrow{v}`$ y, por lo tanto, al vector desplazamiento
! elemental $`\overrightarrow{dl}=\overrightarrow{v}\,dt`$ en todo punto de la trayectoria de la partícula
! de carga $`q`$, *no realiza trabajo*:
!
! $`\mathbf{d\mathcal{W}_{\,magn} = \overrightarrow{F}_{magn}\cdot \overrightarrow{dl}=0}`$
!
! *El trabajo de la fuerza de Lorentz se limita al trabajo de la fuerza eléctrica*:
!
! $`\mathbf{d\mathcal{W}_{\,Lorentz} = d\mathcal{W}_{\,eléc} =q\,\overrightarrow{E}\cdot \overrightarrow{dl}}`$

* La **potencia elemental cedida por el campo** a esta partícula se escribe:
<br>
**$`\mathbf{\mathcal{P}_{cedida} = \dfrac{d\mathcal{W}_{\,Lorentz}}{dt} = q\,\overrightarrow{E}\cdot\overrightarrow{v}}`$**

##### Potencia cedida en un material con un solo tipo de portador de carga

* Si el **medio material** contiene *$`n`$ portadores idénticos de carga $`q`$ por unidad de volumen*,
entonces un volumen elemental $`d\tau`$ contiene $`n\,\tau`$ portadores de carga
y la **potencia elemental cedida** por el campo electromagnético se escribe:
<br>
**$`d\mathcal{P}_{cedida} = n\,\big( q\,\overrightarrow{E}\cdot\overrightarrow{v}\big)\,d\tau`$**

* Expresada *con la densidad volumétrica de carga $`\rho=n\,q`$*:
<br>
$`d\mathcal{P}_{cedida} = \big(n\, q\big)\,\overrightarrow{E}\cdot\overrightarrow{v}\,d\tau = \rho\,\overrightarrow{E}\cdot\overrightarrow{v}\,d\tau`$

* Expresada *con el vector densidad volumétrica de corriente $`\overrightarrow{j}=\rho\,\overrightarrow{v}`$*, observando que
$`\overrightarrow{E}\cdot\overrightarrow{v}=\overrightarrow{v}\cdot\overrightarrow{E}`$:
<br>
**$`d\mathcal{P}_{cedida} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau`$**

##### Potencia cedida en un material con varios tipos de portadores de carga

* Cuando un material contiene **varios tipos de portadores de carga $`q_i`**
en *concentraciones $`n_i`* y animados de *velocidades de deriva $`\overrightarrow{v_d\,i}`*:
<br>
$`\displaystyle d\mathcal{P}_{cedida} = \sum_{i=1}^p \big(n_i\,q_i\,\overrightarrow{E}\cdot\overrightarrow{v_i}\big)\,d\tau`$
<br>
$`\displaystyle d\mathcal{P}_{cedida} = \sum_{i=1}^p \rho_i\,d\tau\,\overrightarrow{E}\cdot\overrightarrow{v_i}`$
<br>
$`\displaystyle d\mathcal{P}_{cedida} = \sum_{i=1}^p\overrightarrow{j_i}\cdot\overrightarrow{E}\,d\tau`$
<br>
*$`d\mathcal{P}_{cedida} = \overrightarrow{j}_{total}\cdot\overrightarrow{E}\,d\tau`$*

* Al establecer simplemente *$`\overrightarrow{j}_{total}=\overrightarrow{j}`*:
<br>
**$`\large{\mathbf{d\mathcal{P}_{cedida} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}}`$**

* La *potencia cedida* por el campo electromagnético *en un volumen $`\tau`* se llama **$`\large{\text{Efecto Joule}}`**,
<br>
**$`\large{\displaystyle\mathbf{\mathcal{P}_{cedida} = \iiint_{\tau}\big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}}`$**

---

#### ¿Contiene el campo electromagnético energía?

* Si el *campo electromagnético* puede ceder energía a la materia, es porque él mismo **contiene energía**.

* Un campo electromagnético $`\big(\overrightarrow{E}\,,\,\overrightarrow{B}\big)`$ que se extiende en el espacio,
la energía contenida en el campo está descrita por
una **densidad volumétrica de energía electromagnética $`\dens_{energía-EM}^{3D}`** definida en cada punto del espacio.

* Parte de la identidad matemática
<br>
$`\mathbf{div\,\big(\overrightarrow{U}\land\overrightarrow{V}\big)=
\overrightarrow{V}\cdot\big(\overrightarrow{rot}\,\overrightarrow{U}\big)\,-\,\overrightarrow{U}\cdot\big(\overrightarrow{rot}\,\overrightarrow{V}\big)}`$
<br>
y aplícala al campo electromagnético $`\big(\overrightarrow{E}\,,\overrightarrow{B})`$ estableciendo $`\overrightarrow{U}=\overrightarrow{E}`$
y $`\overrightarrow{V}=\overrightarrow{B}`$
<br>
**$`\mathbf{div\,\big(\overrightarrow{E}\land\overrightarrow{B}\big)=\overrightarrow{B}\cdot\big(\overrightarrow{rot}\,\overrightarrow{E}\big)\,-\,\overrightarrow{E}\cdot\big(\overrightarrow{rot}\,\overrightarrow{B}\big)}`**,
<br>
$`\color{blue}{\scriptsize{
\text{Identifica los términos } \overrightarrow{rot}\,\overrightarrow{E} \text{ y } \overrightarrow{rot}\,\overrightarrow{B}}}`$
$`\color{blue}{\scriptsize{\text{ con sus causas respectivamente}}}`$
$`\color{blue}{\scriptsize{\text{con las ecuaciones de Maxwell-Faraday y Maxwell-Ampère}}}`$
<br>
$`\begin{align}div\,\big(\overrightarrow{E}\land\overrightarrow{B}\big)
=&\,\overrightarrow{B}\cdot
\big(
\underbrace{\overrightarrow{rot}\,\overrightarrow{E}}
_{\color{blue}{=-\frac{\partial \vec{B}}{\partial t}}}\big)\,\\
&\quad-\,\overrightarrow{E}\cdot\big(\underbrace{\overrightarrow{rot}\,\overrightarrow{B}}_{\color{blue}{=\mu_0\,\vec{j}+\mu_0\epsilon_0\frac{\partial \vec{E}}{\partial t}
}}\big)\end{align}`$
<br>
$`div\,\big(\overrightarrow{E}\land\overrightarrow{B}\big)`$
$`\quad=-\,\mu_0\,\vec{j}\cdot\overrightarrow{E}\,-\,\mu_0\,\epsilon_0\dfrac{\partial \vec{E}}{\partial t}\cdot\overrightarrow{E}
\,-\,\overrightarrow{B}\cdot \dfrac{\partial \vec{B}}{\partial t}\big)$
<br>
$`\color{blue}{\scriptsize{
\text{Recuerda que } \vec{u}\dfrac{\partial \vec{u}}{\partial t}=\dfrac{1}{2}\,\dfrac{\partial (\vec{u}\cdot\vec{u})}{\partial t}=\dfrac{1}{2}\,\dfrac{\partial u^2}{\partial t}}}`$
<br>
$`div\,\big(\overrightarrow{E}\land\overrightarrow{B}\big)`$
$`\quad =-\,\mu_0\,\vec{j}\cdot\overrightarrow{E}\,-\,\dfrac{\mu_0\,\epsilon_0}{2}\,\dfrac{\partial E^2}{\partial t}
\,-\,\dfrac{1}{2}\,\dfrac{\partial B^2}{\partial t}
$`
<br>
$`\color{blue}{\scriptsize{\text{El reconocimiento del término de efecto Joule }\vec{j}\cdot\vec{E}=\dfrac{d\mathcal{P}_{cedida}}{d\tau}}}`$
$`\color{blue}{\scriptsize{\text{incita a dividir cada miembro de la ecuación por }\mu_0 }}`$
<br>
$`
div\,\left(\dfrac{\overrightarrow{E}\land\overrightarrow{B}}{\mu_0}\right)`$
$`\quad = -\,\underbrace{
\vec{j}\cdot\overrightarrow{E}
}_{
\color{blue}{=\frac{d\mathcal{P}_{cedida}}{d\tau}}
}
\,-\,\dfrac{\epsilon_0}{2}\,\dfrac{\partial E^2}{\partial t}
\,-\,\dfrac{1}{2\,\mu_0}\,\dfrac{\partial B^2}{\partial t}
$`
<br>
$`\color{blue}{\scriptsize{\text{que puedes reescribir:}}}`$
<br>
**$`\mathbf{
div\,\left(\dfrac{\overrightarrow{E}\land\overrightarrow{B}}{\mu_0}\right)}`$
$`\mathbf{\quad = -\,\vec{j}\cdot\overrightarrow{E}
\,-\,\dfrac{\partial}{\partial t}\,\left(
\dfrac{\epsilon_0\,E^2}{2}\,+\,\dfrac{B^2}{2\,\mu_0}
\right)
}`$**

* Así aparece la **densidad volumétrica de energía electromagnética** de *unidad SI: $`J\,m^{-3}`*:
<br>
**$`\large{\mathbf{\dens_{energía-EM}^{3D}=\dfrac{\epsilon_0\,E^2}{2}+\dfrac{B^2}{2 \mu_0}}}`$**

* Esta densidad volumétrica $`\dens_{energía-EM}^{3D}`$ *posee dos componentes*:
* una *componente eléctrica* **$`\;\dens_{eléc}^{3D}=\dfrac{\epsilon_0\,E^2}{2}`$**
* una *componente magnética* **$`\;\dens_{magn}^{3D}=\dfrac{B^2}{2 \mu_0}`$**.

* La energía electromagnética $`\mathcal{E}_{EM}`$ contenida **en un volumen $`\tau`** se expresa:
<br>
**$`\displaystyle\large{\mathbf{\mathcal{E}_{EM}=\iiint_{\tau} \left(\dfrac{\epsilon_0\,E^2}{2}+\dfrac{B^2}{2 \mu_0}\right) d\tau}}`$**


<br>

------------

<br>

#### ¿Por qué hablamos de ondas electromagnéticas?

##### Ecuación de onda

* Para un *campo vectorial $`\overrightarrow{U}(\overrightarrow{r},t)`$*, la **ecuación de onda de d'Alembert** se escribe:
<br>
**$`\Delta \overrightarrow{U} - \dfrac{1}{v^2} \; \dfrac{\partial^2 \;\overrightarrow{U}}{\partial\; t^2}=0`$**

* La expresión del *operador Laplaciano vectorial $`\Delta`$* en función de los operadores $`grad`$, $`div`$ y $`rot`$ es:
<br>
*$`\Delta =\overrightarrow{grad} \left(div\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\right)`$*

* La **idea** es *calcular para cada uno de los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$*
la expresión de *su Laplaciano*, para ver si se identifica con la ecuación de onda.

---

##### Estudio de la componente $`\overrightarrow{E}`$ del campo electromagnético

* Para **establecer la expresión $`\;\;\Delta \overrightarrow{E}`$**, calculo
$`\;\;\overrightarrow{rot}\left(\overrightarrow{rot}\;\overrightarrow{E}\right)\;\;$$, luego
$`\;\;\overrightarrow{grad} \left(div \overrightarrow{E}\right)\;\;$* a partir de las ecuaciones de Maxwell.

* $`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
\overrightarrow{rot} \,\left( -\dfrac{\partial \overrightarrow{B}}{\partial t}\right)`$
<br>
En física clásica, el espacio y el tiempo están desacoplados. Las coordenadas espaciales
y la coordenada temporal son independientes. El orden de derivación o integración entre
coordenadas espaciales y la coordenada temporal no importa, por lo tanto:
<br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\overrightarrow{rot}\overrightarrow{B}\right)`$
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\mu_0\;\overrightarrow{j} +
\mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\right)`$
<br><br>
*$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=-\mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  - \mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$*
<br><br>

* $`\overrightarrow{grad} \left( div \; \overrightarrow{E} \right) = \overrightarrow{grad}\left( \dfrac{\rho}{\epsilon_0} \right)`$

* La reconstrucción de
$`\Delta \;\overrightarrow{E} =\overrightarrow{grad} \left(div\;\overrightarrow{E}\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\;\overrightarrow{E}\right)`$
da:
<br>
$`\Delta \;\overrightarrow{E} = \overrightarrow{grad}\left( \dfrac{\rho}{\epsilon_0} \right) + \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$
<br>
lo que da, por identificación con el primer término de la ecuación de onda:

**$`\mathbf{\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_0} \;
\overrightarrow{grad}\left(\rho \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}}`$**
<br>
*(ecuación de propagación del campo eléctrico)*

---

##### Estudio de la componente $`\overrightarrow{B}`$ del campo electromagnético

* Un *estudio de forma idéntica* (propuesto en autoevaluación en la parte avanzada) me llevaría
para el campo magnético $`\overrightarrow{B}`$ a la ecuación de propagación:
<br>
**$`\mathbf{\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}}`$**
<br>
*(ecuación de propagación del campo magnético)*

---

##### Propagación de una onda electromagnética en la materia

* El estudio parte de las ecuaciones de Maxwell y de las dos ecuaciones:
<br>
$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_0} \;
\overrightarrow{grad}\left(\rho \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}`$
<br>
$`\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}`$
<br>
y es objeto de todo un **desarrollo en un capítulo posterior**.

---

##### Propagación de una onda electromagnética en el vacío

* El *espacio vacío* se caracteriza por una ausencia de cargas, fijas o en movimiento.
La densidad volumétrica de carga $`\rho_{vacío}`$ así como el vector densidad volumétrica de corriente
$`\overrightarrow{j}_{vacío}`$ tienen un valor nulo en todo el espacio vacío,
<br>
*$`\rho_{vacío}=0\quad\text{y}\quad\overrightarrow{j}_{vacío}=\overrightarrow{0}`$*.

* Por lo tanto, la propagación de la onda electromagnética en el vacío se expresa en forma
del sistema de **dos ecuaciones de d'Alembert**:
<br>
**$`\large{\boldsymbol{\mathbf{\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}}}}`$**
<br>
**$`\large{\boldsymbol{\mathbf{\Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}}}}`$**

!!!! *¡Atención!*:
!!!!
!!!! Las *ecuaciones de Maxwell implican la propagación del campo electromagnético*.
!!!!
!!!! *Pero,*
!!!!
!!!! Las *dos ecuaciones de onda para los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`*
!!!! no implican las ecuaciones de Maxwell*.
!!!!
!!!! Todo campo $`\overrightarrow{E}`$ que verifique
!!!! $`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}`$
!!!!
!!!! y todo campo $`\overrightarrow{B}`$ que verifique
!!!! $`\Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}`$
!!!!
!!!! no describen la propagación de una onda electromagnética a menos que $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$
!!!! verifiquen las ecuaciones de Maxwell.

---

##### Rapidez de la velocidad de la luz en el vacío

* La identificación de las ecuaciones de propagación de los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$
con la ecuación de onda de d'Alembert muestra que *el campo electromagnético se propaga a la rapidez*
<br>
*$`\large{\mathscr{v}=\dfrac{1}{\sqrt{\epsilon_0\,\mu_0}}}`$*

* La *rapidez de la luz en el vacío*, denotada *$`\mathbf{c}`$* es una **constante fundamental** del universo, y su valor exacto es:
<br>
*$`\large{c=299\,792\,458\, m\,s^{-1}\approx 3\times 10^8\, m\,s^{-1}}`$*

!! *Para ir más allá*:
!!
!! Las ecuaciones de propagación de las ondas electromagnéticas, establecidas aquí en el marco
!! de la física clásica,
!! prevén que las ondas electromagnéticas se propagan en el vacío a la rapidez
!! $`c=1/\sqrt{\epsilon_0\,\mu_0}`$, rapidez constante independiente del movimiento del observador.
!!
!! Esto está en contradicción con la ley de adición de velocidades en mecánica clásica, que
!! resulta de las transformaciones de Galileo.
!!
!! $`\Longrightarrow`$ durante la segunda mitad del $`19^{ème}`$ siglo, el trabajo de los físicos fue
!! intentar modificar las ecuaciones de Maxwell para hacerlas compatibles con la física clásica.
!!
!! Pero fue lo contrario lo que había que hacer: modificar la mecánica de Newton, base de la física clásica,
!! para hacerla compatible con las ecuaciones de Maxwell.
!!
!! Este trabajo inverso fue el de Albert Einstein, quien publicó en 1905 un artículo titulado
!! "Sobre la electrodinámica de los cuerpos en movimiento",
!! que fue el nacimiento de la teoría de la Relatividad especial, que revolucionó nuestra concepción
!! del espacio y del tiempo.
!!
!! Más tarde, en 1915, Einstein presentó un artículo titulado
!! "Los fundamentos de la teoría de la Relatividad General"
!! que revolucionó nuestra concepción de la relación entre el espacio-tiempo y su contenido en materia y energía.
!!
!! *Física newtoniana*:
!! espacio + tiempo + materia + energía.
!!
!! *Física relativista en el sentido restringido*:
!! espacio-tiempo + materia-energía ($`E=m\,c^2`$).
!!
!! *Física relativista en el sentido general*:
!! espacio-tiempo-materia-energía.

---

#### ¿Qué es el espectro electromagnético?

* **Maxwell** plantea la hipótesis de que *la luz* visible, cuya velocidad se había medido a partir
de la observación astronómica del movimiento de los satélites de Júpiter, *es una onda electromagnética*.
<br>
$`\Longrightarrow`$ la luz es solo una pequeña parte de las ondas electromagnéticas.
<br>
$`\Longrightarrow`$ todo un *nuevo mundo de "luces"* se revela, llamado **espectro electromagnético**.

![Espectro electromagnético](astro-electromagnetic-spectrum-N4_1_fr_L1200.jpg)

* En particular, **el conocimiento del universo** resultaba *antes de Maxwell* de la sola observación del *dominio visible*,

![Cielo visible](ciel-visible-bsp_L1200.jpg)

* se extiende *ahora* a *todo el espectro electromagnético*.

![Cielo en varias longitudes de onda](ciel-images-bsp_L600_transparence.gif)

---

#### ¿Qué es el vector de Poynting?

* La **onda electromagnética contiene energía**:
  * con *en cada punto del espacio* una **densidad volumétrica de energía $`\dens_{energía-EM}^{3D}`$*,
  - con una *componente eléctrica* **$`\;\dens_{eléc}^{3D}=\dfrac{\epsilon_0\,E^2}{2}`$*,
  - con una *componente magnética* **$`\;\dens_{magn}^{3D}=\dfrac{B^2}{2 \mu_0}`$*.
  * que **se desplaza en el vacío** *a la velocidad $`c`$*.

* El **vector de Poynting** traduce este hecho, y permite el *cálculo de la energía* de una onda electromagnética
incidente *sobre una superficie cualquiera por segundo*.

* El **vector de Poynting**, definido en cada punto del espacio, está *definido por* la relación:
<br>
*$`\large{\mathbf{d\mathcal{P}=\overrightarrow{\Pi}\cdot\overrightarrow{dS}}}`$*
<br>
donde $`d\mathcal{P}`$ es la *potencia elemental* de la onda electromagnética
*radiada a través del elemento de superficie* $`\overrightarrow{dS}`$.

![Vector de Poynting](poynting-vector-1_L1200.jpg)

* Su **expresión** en función de los campos $`\overrightarrow{E}`$ y $`\overrightarrow{B}`$ es:
<br>
**$`\large{\mathbf{\overrightarrow{\Pi}=\dfrac{\overrightarrow{E}\land\overrightarrow{B}}{\mu_0}}}`$**

* *Unidad SI*: **$`\mathbf{W\,m^{-2}}`$**

! *Nota 1*:
!
! El desplazamiento de una carga (de unidad $`SI: C)`$ contenida en un volumen elemental
! $`d\tau\quad (SI: m^3)`$ de densidad volumétrica de
! carga $`\rho_{carga}^{3D}\quad (SI: C\,m^{-3})`$ a una velocidad
! $`\overrightarrow{v_d}\quad (SI: m\,s^{-1})`$:
! * permite definir un vector densidad de corriente (eléctrica) volumétrica
! $`\overrightarrow{j}_{corriente}^{3D}=\rho_{carga}^{3D}\,v_d\,`$
! $`\quad (SI: A\,m^{-2})`$,
! * y así permite calcular la intensidad elemental $`dI\quad (SI: A = C\,s^{-1})`$ de la corriente que atraviesa
! todo elemento de superficie
! $`\overrightarrow{dS}\quad (SI: m^2)`$,
! $`dI= \overrightarrow{j}_{corriente}^{3D}\cdot\overrightarrow{dS}`$!
!
! De la misma manera,
!
! el desplazamiento de la energía (de unidad $`SI: J)`$ de la onda electromagnética contenida
! en un volumen elemental $`d\tau\quad (SI: m^3)`$ de densidad volumétrica de energía
! $`\dens_{energía_EM}^{3D}\quad (SI: J\,m^{-3})`$ a la rapidez $`c\quad (SI: m\,s^{-1})`$:
! * permite definir el equivalente de un vector densidad de potencia de la onda electromagnética,
! llamado *vector de Poynting* y denotado $`\overrightarrow{\Pi}\quad (SI: J\,s^{-1}\, m^{-2}=W\, m^{-2})`$,
! * lo que permite calcular la potencia elemental $`d\mathcal{P}\quad (SI: W)`$ de la onda EM que atraviesa todo elemento de superficie
! $`\overrightarrow{dS}`$,
! $`d\mathcal{P}= \overrightarrow{\Pi}\cdot\overrightarrow{dS}`$.

! *Nota 2*:
!
! *La expresión del vector de Poynting* en función del campo eléctrico y del campo magnético de la onda,
! así como *su significado*, son *más fáciles de recordar* si se elige expresarlo
! *en función del campo de excitación magnética $`\overrightarrow{H}`$*.
!
! *__En el vacío__ (y únicamente en el vacío)*:
! El campo magnético está tan bien descrito por el campo de inducción
! $`\overrightarrow{B}`$ que interviene en la fuerza de Lorentz que induce los efectos,
! como por el campo de excitación magnética $`\overrightarrow{H}`$.
! Estos dos campos son proporcionales, siendo la constante de proporcionalidad $`\mu_0`$:
! <br>
! $`\overrightarrow{B}=\mu_0\,\overrightarrow{H}\quad\text{(en el vacío)}`$
!
! La expresión en el vacío del vector de Poynting es entonces:
! <br>
! $`\overrightarrow{\Pi}=\overrightarrow{E}\land\overrightarrow{H}`$
!
! Recordando
! * de la electrostática que la unidad SI de $`\overrightarrow{E}`$ es el $`V\,m^{-1}$,
! * de la magnetostática que la unidad SI de $`\overrightarrow{H}`$ es el $`A\,m^{-1}$,
! * del estudio de los circuitos que $`\mathcal{P}\,(W) = U\,(V)\times I\,(A)`$,
!
! entonces la *unidad SI del vector de Poynting* aparece fácilmente como *$`V\,A\,m^{-2}= W\,m^{-2}`$*
!
! En el sistema internacional de medidas, el vector de Poynting se expresa en *vatios por metro cuadrado*.
!
! La *magnitud física del vector de Poynting* es una *potencia por unidad de superficie*.

<br> 

------

<br>

#### Comment calculer le puissance traversée par une surface d'aire et d'orientation quelconque ?

* La **puissance**  se calcule simplement par l'expression :   
<br>
**$`\displaystyle\mathcal{P}=\iint_S \overrightarrow{\Pi}\cdot\overrightarrow{dS}`$**

* Soit une **onde électromagnétique monochromatique** de période temporelle $`\mathbf{T_{onde}}`$.
   * **$`\mathbf{T_{onde}}`$** est la *période temporelle de $`\overrightarrow{E}`$*, champ électrique de l'onde.
   * L'énergie électrique étant proportionnelle à $`E^2`$, <br>
     la *période des variations énergétiques* de l'onde est **$`\mathbf{T_{énergie}}`$** *$`\mathbf{\,=\dfrac{T_{onde}}{2}}`$*

* Tout **capteur** est caractérisé par un **temps de réponse $`\mathbf{\Delta t_{réponse}}`$** qui quantifie sa *rapidité*.  
  <br>
  Soit un capteur sensible à l'énergie électromégnétique :
   * Si *$`\mathbf{\Delta t_{réponse}\ll T_{énerg.}}`$* alors le capteur est sensible à la *puissance instantanée* :   
     <br>
    *$`\displaystyle\large{\mathbf{\mathcal{P}(t)=\iint_S \overrightarrow{\Pi}(t)\cdot\overrightarrow{dS}}}`$*  
   <br>
   * Si **$`\mathbf{\Delta t_{réponse}\gg T_{énerg.}}`$** alors le capteur ne peut suivre les variations temporelles de
     la puissance instantanée, et ne mesure que la **valeur moyenne de la puissance** estimée sur $`\Delta t_{réponse}`$ :   
     <br>
    **$`\displaystyle\large{\mathbf{<\mathcal{P}(t)>\;=\iint_S <\overrightarrow{\Pi}(t)>\cdot\overrightarrow{dS}}}`$**  

!!! *Exemple :*  
!!!
!!! Le *domaine visible* correspond à :
!!! * une *longueur d'onde* dans le vide de l'ordre de 500 nanomètres : *$`\mathbf{\lambda = 5\cdot 10^{-7}\,m}`$* <br>
!!!   <br>
!!!   Cela correspond à une période temporelle du champ électrique $`T_{onde}`$ de :<br>
!!!   $`T_{onde}=\dfrac{\lambda}{c}=\dfrac{5\cdot 10^{-7}}{3\cdot 10^{8}} = 1.7\times 10^{-15}\,s`$,<br>
!!!   soit<br>    
!!!   $`T_{énerg.}=8.5\times 10^{-16}\,s`$<br>
!!!   <br>
!!!   Dans les deux cas, l'ordre de grandeur de la *période* est de $`\mathbf{T\approx 10^{-15}\,s}`$*.
!!! 
!!! Aucun capteur n'arrive à suivre les variations instantanées de puissance de la lumière visible.


#### Comment émettre une onde électromagnétique ?

* Il suffit d'**accélérer une particule chargée**.

<!---------------------
#### Comment capter la puissance d'une onde électromagnétique ?

Quelques idées très synthétiques.   
Pour des ressources transverses et classiques, liens en parallèles
---------------------->

@@@@@@@@@@@@@@

<br>

RÉSUMÉ
: ---

  *Domaine de validité* :
  
  Très général. Dans le vide, et même dans la matière si l'échelle d'observation n'est pas mésoscopique,
  mais atomique.   
  Attention toutefois, une description plus exacte de la matière à l'échelle atomique 
  requiert l'utilisation de la physique quantique.
   
   _Attention : Les expressions ci-dessous ne sont valables que dans le système international d'unité $`SI`$, anciennement $`MKS`$._
   
   ---
   
  *Forme locale des équations de Maxwell*
  
  * En tout point de l'espace et à tout instant :   
  <br>
  $`\left\{\begin{array}{l}
  div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}\quad \small{(Maxwell-Gauss)}\\
  div \overrightarrow{B} = 0\quad \small{(Maxwell-flux)}\\
  \overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}\quad\small{(Maxwell-Faraday)}\\
  \overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\quad\small{(Maxwell-Ampère)}
  \end{array}\right.`$  
    <br>
   avec $`\dens`$ densité volumique de charge   
   &nbsp;&nbsp; et $`\overrightarrow{j}`$ vecteur densité volumique de courant.
   
   * $`\Longrightarrow`$ la conservation de la charge :   
     $`div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0`$

   * $`\Longrightarrow`$ la propagation dans le vide   
     de l'onde électromagnétique (EM), partie variable du champ électromagnétique :     
     <br>
     $`\left\{\begin{array}{l}
     \Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}\\  
     \Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}
     \end{array}\right.`$    
     <br>
     à la célérité $`c=299 792 458 m\,s^{-1}\approx 3\times 10^8 m\,s^{-1}`$,   
     constante fundamentale de la nature.   
 
   * $`\Longrightarrow`$ le champ EM contient de l'énergie,   
     en densité volumique :   
     $`\small{\dens}`$$`\; = \dfrac{\epsilon_0\,\overrightarrow{E}\cdot\overrightarrow{E}}{2}+\dfrac{\overrightarrow{B}\cdot\overrightarrow{B}}{2\mu_0}`$

   * $`\Longrightarrow`$ tout $`\overrightarrow{dS}`$ reçoit la puissance EM :
     $`d\mathcal{\overrightarrow{\Pi}}_{EM}=\overrightarrow{\Pi}\cdot\overrightarrow{dS}`$   
     avec $`\overrightarrow{\Pi}=\dfrac{\overrightarrow{E}\land\overrightarrow{B}}{\mu_0}`$ vecteur de Poynting.

   * $`\Longrightarrow`$ le champ EM cède de l'énergie à la matière par effet Joule :  
     $`\mathcal{P}_{cédée} = \overrightarrow{j}\cdot\overrightarrow{E}\,d\tau`$   
     
   * $`\Longrightarrow`$ toute particule chargée accélérée génère une onde électromagnétique.   

<br>

#### Quel fut le travail de Maxwell ?

* *Jusqu'au milieu du XIVème siècle*, **électricité, magnétisme et optique** étaient étudiés dans des *domaines scientifiques distincts*. 

* Cependant l'*observation de phénomènes naturels et d'expériences de laboratoire* montrèrent une
**interaction incomprise entre électricité, magnétisme,** voire **optique**.
    * naturel : la foudre peu charger des objets métalliques, aimante le fer, créé un éclair.
    * expériences :   
      \- un courant dévie l'aiguille d'une boussole.   
      \- le déplacement d'un aimant créé un courant.

* Bon mathématicien, **Maxwell** fait *synthèse des résultats expérimentaux* de son époque
qui se résume en 4 équations, les *équations de Maxwell*.

* Ces 4 équations **unifient électricité, magnétisme et optique** au sein de l'électromagnétisme,   
  et élargissent l'optique à un *monde nouveau : les ondes électromagnétiques*.

![](Maxwell-equation-es.png)
_Maxwell modifie deux des équations de l'électrostatique et de la magnétostatique en
introduisant des termes de couplage entre E et B,
et révolutionne ainsi la physique._

#### Pourquoi disons-nous "équations" et pas "théorèmes" de Maxwell ?

* Les **4 équations de Maxwell** *ne sont pas démontrées*, donc elles ne constituent pas des théorèmes.
* Elles sont *posées et supposées vraies*, ce **sont des postulats**.


<!-----------------
#### Pourquoi ces équations fondent l'électromagnétisme ?

#### Quel est le domaine de validité de ces équations ?
------------------>

<br> 

------------

<br>

#### Que sont ces 4 équations de Maxwell ?

##### Sous forme locale 
_(fondamental, connaître)_

* Deux **expressions de la divergence** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ *inchangées par rapport au cas stationnaire* (électrostatique et magnétostatique) :

   * **$`\large{\mathbf{div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}}}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-Gauss*).

   * ** $`\large{\mathbf{div \overrightarrow{B} = 0}}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-flux*).


* Deux **expressions du rotationnel** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ qui *changent et couplent les champs $`\mathbf{\overrightarrow{E}}`$ et $`\mathbf{\overrightarrow{B}}`$* :

   * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}}`$**   
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(éq. *Maxwell-Faraday*).

   * **$`\large{\mathbf{\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}}`$**   
   &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;(éq. *Maxwell-Ampère*).

* où :
   * $`\dens=\dens^{3D}`$ est la densité volumique de charge. 
   * $`\overrightarrow{j}=\overrightarrow{j}^{3D}`$ est le vecteur densité volumique de courant. 

------------------

* Et ces équations *réécrites avec l'opérateur nabla : $`\mathbf{\nabla}`$ *

   * **$`\mathbf{\nabla\cdot\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}}`$**

   * **$`\mathbf{\nabla\cdot\overrightarrow{B}=0}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{E}= -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{B}= \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$**


------------------


##### Sous forme intégrale
_(savoir redémontrer)_


* Elles **se déduisent des équations locales**, avec l'aide :
   * du *théorème d'Ostrograsky* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iiint_{\Ltau} div\;\overrightarrow{X} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\Ltau} \overrightarrow{X}\cdot\overrightarrow{dS}`$*
   * du *théorème de Stokes* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{X} \cdot dS 
= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$*.

* **Maxwell-Gauss** :   
     
  À tout instant t, et pour tout volume $`\tau`$ :

   * $`\forall \overrightarrow{r}, div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau \\
\iiint_{\Ltau} div\;\overrightarrow{E} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
= \dfrac{1}{\epsilon_0} \cdot \iiint_{\Ltau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0}}`$**

------------

* **Maxwell-flux** :

     
  À tout instant t, et pour tout volume $`\tau`$ :
  
     * $`\forall \overrightarrow{r}, div \overrightarrow{B} = 0`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0 \\
\iiint_{\Ltau} div\;\overrightarrow{B} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}= 0}`$**

-----------------

* **Maxwell-Faraday** :

     
  À tout instant t,   
  et pour toute surface $`S`$ ouverte et orientée, fixe et indéformable, qui s'appuie sur un contour $`\Gamma`$ 
  d'orientation compatible avec celle de $`S`$ selon la règle de la main droite :

   * $`\forall \overrightarrow{r}, \overrightarrow{rot} \,\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}`$
  $`\Longrightarrow \iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big)`$  
<br>   

   * $`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big) \\
\text{Newton : espace et temps indépendants,} \\
\text{ordre dérivation/intégration n'importe pas}
\end{array}\right\}`$
$`\Longrightarrow`$
$`\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big)`$   
<br>   

   * $`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big) \\
\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{E} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\begin{array}{l}
  &nbsp; \\
 \mathbf{\displaystyle\quad\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}= -\dfrac{d}{dt}\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}}
\end{array}`$**   
<br>   
   *  Cette équation joue un *rôle important pour les phénomènes d'induction*.    
      _La quantité_ $`\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}`$ 
      _d'appelation historique imparfaite "force électromotrice (fem)", homogène à une tension, est à l'origine d'un courant_
      _électrique traversant le contour $`\Gamma`$ si celui-ci représente un circuit conducteur._
     

---------------

* **Maxwell-Ampère** :

  À tout instant t,   
  et pour toute surface $`S`$ ouverte et orientée, fixe et indéformable, qui s'appuie sur un contour $`\Gamma`$ 
  d'orientation compatible avec celle de $`S`$ selon la règle de la main droite :
<br>

$`\forall \overrightarrow{r}, \overrightarrow{rot} \,\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$
  $`\Longrightarrow`$$` \iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS}`$  
<br>
   
$`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS} \\
\text{Newton : espace et temps indépendants},\\
\text{ordre dérivation/intégration n'importe pas}
\end{array}\right\}`$
$`\Longrightarrow`$
$`\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS}`$$`\; = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
 \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}`$   
<br>
   
$`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
 \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS} \\
\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{B} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}
\end{array}\right\}`$
$`\Longrightarrow`$

**$`&nbsp;\mathbf{\displaystyle\;\,\oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}}`$
$`\;\mathbf{\displaystyle= \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +\mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}}`$**

<br> 

------------

<br>

#### Pourquoi parlons-nous de champ électromagnétique ?

* Les 2 équations de couplage de $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ impliquent 
que **variables, $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ ne peuvent exister l'un sans l'autre**.

* Le terme *$`\dfrac{\partial\overrightarrow{B}}{\partial t}\ne 0`$ implique $`\overrightarrow{E}\ne \overrightarrow{0}`$*
* Le terme *$`\dfrac{\partial\overrightarrow{E}}{\partial t}\ne 0`$ implique $`\overrightarrow{B}\ne \overrightarrow{0}`$*
 
<br> 

------------

<br>

#### Que disent les équations de Maxwell sur la conservation de la charge ?

##### Loi de conservation de la charge électrique

* Dans la matière, les **charges électriques** sont portées par les *électrons* et
les *protons* des noyaux atomiques. *En physique classique*, ces particules existent, 
et elles **ne peuvent ni surgir du vide, ni disparaître**.

* Ainsi le **principe de conservation de la charge** électrique peut se résumer en une phrase :   
<br>
! *Dans tout volume de l'espace et pendant une durée donnée, la charge électrique*
! *qui entre dans ce volume moins la charge électrique*
! *qui en sort est égale à la variation de la charge dans le volume.* 
<br>
Cela se traduit en *écriture mathématique* par l'**expression intégrale**:   
<br>
Pour toute surface fermée $`S`$ délimitant un volume macroscopique $`\Ltau`$,   
<br>
**$`\mathbf{\oiint_{S\leftrightarrow\Ltau}\overrightarrow{j}\cdot\overrightarrow{dS}+\iiint_{\Ltau}\dfrac{\partial\dens}{\partial t}\cdot d\tau=0}`$**   
<br>
qui s"énonce :   
<br>
! *Le flux du vecteur densité de courant volumique à travers une surface fermée,*
! *est égal à la dérivée temporelle de la charge totale contenue à l'intérieur de cette surface fermée.*

![](charge-conservation-law-L1200.jpg)

* Cette égalité étant vérifiée quelque-soit le volume d'intégration, c'est que 
  l'égalité porte sur les intégrandes eux-mêmes.   
  $`\Longrightarrow`$ la loi de conservation a aussi une **expression locale**, valide en tout point de l'espace, qui s'écrit :   
<br>
**$`\mathbf{div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0}`$**   

<br><br>

![](charge-conservation-1-L1200.jpg)

<br>

##### Etude des équation de Maxwell

* **Partons de** la combinaison d'opérateurs remarquable, valable pour tout champ vectoriel $`\overrightarrow{U}`$,
   qui s'énonce     
  *" La divergence du rotationnel d'un champ vectoriel est toujours nulle. "* :    
  <br>
  $`\forall \overrightarrow{X}\big(\overrightarrow{r},t\big)\;,`$*$`\quad \mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{X}\big)=0}`$*.   
  <br>
  et appliquons là au champ d'induction magnétique  $`\overrightarrow{B}`$ :    
  <br>
  **$`\mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{B}\big)=0}`$**.

* La *loi de Maxwell-Ampère*   
  *$`\overrightarrow{rot}\,\overrightarrow{B}=\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$*   
  permet d'écrire :     
  <br>
  **$`\mathbf{div\Big(\mu_0\,\overrightarrow{j} + \mu_0\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0}`$**

* En divisant les termes de droite et de gauche par $`\mu_0`$, l'équation se simplifie :   
  <br>
  $`div\Big(\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

* L'équation contient déjà $`\overrightarrow{j}`$, je cherche à faire apparaître $`\dens`$.   
  Pour cela, je cherche à faire apparaître $`div\,\overrightarrow{j}`$ pour ensuite utiliser la loi de maxwell-Gauss.   
  <br>
  $`div\,\overrightarrow{j} + div\Big(\epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)=0`$

<!--------------------
L'espace et le temps étant découplés en physique classique, l'ordre de différentiation
et intégration n'importe pas si elles s'appliquent l'une à des coordonnées spatiales
et l'autre au temps. Ainsi :

$`div\,\overrightarrow{j} +
\dfrac{\partial}{\partial t}\Big(\epsilon_0\, div\,\overrightarrow{E}\Big)=0`$

ce qui permet d'écrire,

$`div\,\overrightarrow{j} + \dfrac{\partial\dens}{\partial t}=0`$

Je reconnais là la loi de conservation de la charge.
----------------------->

* Dans le cadre de la *physique classique, espace et temps sont indépendants*, 
l'ordre de dérivation par une variable spatiale et une variable temporelle n'importe pas :   
<br>
*$`\dfrac{\partial}{\partial t}\left(\dfrac{\partial}{\partial x}\right) =\dfrac{\partial}{\partial x}\left(\dfrac{\partial}{\partial t}\right)`$*    
    * L'opérateur divergence n'est constitué que de dérivées partielles de variables d'espace.
    * $`\dfrac{\partial}{\partial t}`$ est une dérivée partielle de la variable temps.

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;*$`\Longrightarrow\quad div\left(\dfrac{\partial}{\partial t}\right)= \dfrac{\partial}{\partial t}\left(div\right)`$*.   

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Nous obtenons :   

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;**$`\mathbf{div\,\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial}{\partial t}\left(div\,\overrightarrow{E}\right)=0}`$**


* En utilisant la *loi de Maxwell-Gauss $`div\,\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}`$*   
  <br>
nous obtenons l'**équation de conservation locale de la charge** électrique en régime variable (donc toujours vérifiée) :   
<br>
**$`\mathbf{div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}=0}`$**


! *Les équations de Maxwell contiennent et impliquent la conservation de la charge électrique.*



<!--Plutôt pour partie principale--------------------

* Il faut faire apparaître les distributions de charge $`\dens^{3D}`$ et de vecteur  densité de courant volumique $`\overrightarrow{j}^{3D}`$.    
Pour cela nous utilisons la loi de Maxwell-Ampère    
* $`\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$   
<br>
$`div\big(
\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}
\big)=0`$

* Simplifions en divisant de chaque côté par la constante magnétique $`\mu_0`$ :   
<br>
$`div\,\big(
\;\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}
\big)=0`$

* Dans le cadre de la physique classique, espace et temps sont indépendants, l'ordre de dérivation par une variable spatiale et une variable temporelle n'importe pas :   

$`\dfrac{\partial}{\partial t}\left(\dfrac{\partial}{\partial x}\right) =\dfrac{\partial}{\partial x}\left(\dfrac{\partial}{\partial t}\right) `$    
    * L'opérateur divergence n'est constitué que de dérivées partielles de variables d'espace.
    * $`\dfrac{\partial}{\partial t}`$ est une dérivée partielle de la variable temps.
$`\Longrightarrow\quad div\left(\dfrac{\partial}{\partial t}\right)= \dfrac{\partial}{\partial t}
\left(div\right)`$.   
Nous obtenons :   
<br>
$`div\,\overrightarrow{j} + \epsilon_0 \;\dfrac{\partial}{\partial t}
\left(div\,\overrightarrow{E}\right)=0`$

* En utilisant la loi de Maxwell-Gauss $`div\,\overrightarrow{E}=\dfrac{\dens^{3D}}{\epsilon_0}`$ nous obtenons l'équation de conservation locale de la charge électrique en régime variable (donc toujours vérifiée) :   
<br>
$`div\,\overrightarrow{j} +\dfrac{\partial \dens^{3D}}{\partial t}=0`$
--------------------->

* Nous pouvons *intégrer cette égalité locale* sur un volume $`\tau`$ quelconque :   
<br>
$`\displaystyle\iiint_{\Ltau} \Big(div\,\overrightarrow{j} +\dfrac{\partial \dens}{\partial t}\big)\,d\tau=0`$   
<br>
*$`\displaystyle\iiint_{\Ltau} div\,\overrightarrow{j}\,d\tau+\iiint_{\Ltau}\dfrac{\partial \dens}{\partial t}\,d\tau=0`$*

* Le *théorème d'Ostrogradski* (= théorème *de la divergence*) précise que pour tout champ 
$`\overrightarrow{U}`$ vectoriel et pour tout volume $`\tau`$,    
*$`\displaystyle\iiint_{\Ltau} div\,\overrightarrow{U}\,d\Ltau=\oiint_S \overrightarrow{U}\cdot dS`$*,   
$`S`$ étant la surface fermée que délimite le volume $`\tau`$.   
<br>
*Appliqué au premier terme* de l'égalité, nous obtenons :   
<br>
**$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} + \iiint_{\Ltau}\dfrac{\partial \dens}{\partial t}\,d\tau=0`$**.  

* En remarquant de nouveau qu'*espace et temps sont indépendants en physique classique*, l'ordre de dérivation ou intégration par une variable spatiale et une variable temporelle n'importe pas :    
<br>
**$`\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{\partial}{\partial t} \left(\iiint_{\Ltau}\dens \,d\tau\right)=0`$**.    

* En constatant que *$`\displaystyle\iiint_{\Ltau}\dens^{3D} \,d\tau`$ est la charge totale $`Q_{int}`$* 
contenue dans le volume $`\tau`$, nous obtenons l'**expression intégrale de la loi de conservation** de la. charge :   
<br>
**$`\mathbf{\displaystyle\oiint_S \overrightarrow{j}\cdot \overrightarrow{dS} +\dfrac{dQ_{int}}{dt}=0}`$**.    

<br> 

------------

<br>

#### Le champ électromagnétique peut-il céder de l'énergie à la matière ?

##### Puissance cédée à un porteur de charge

* La **sensibilité** d'une particule **à l'interaction électromagnétique** se quantifie
par le paramètre appelé *charge* électrique de la particule.   

* La force qui décrit l'*action d'un champ électromagnétique $`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`$* 
sur une particule de charge $`q`$ est la **force de Lorentz** d'expression :   
<br>
**$`\overrightarrow{F}_{\,Lorentz}=q\Big(\overrightarrow{E}+\overrightarrow{\speed}\land\overrightarrow{B}\Big)`$**<br>
<br>
&nbsp;&nbsp;où $`\overrightarrow{\speed}`$ est le vecteur vitesse de la particule dans le référentiel d'inertie de l'observation.

* *Lors d'un déplacement élémentaire $`\overrightarrow{dl}`$* de la particule dans le champ électromagnétique
$`\big(\overrightarrow{E}\,,\overrightarrow{B}\big)`$, le **travail de la force de Lorentz** s'écrit :   
<br>
**$`d\mathcal{W}_{\,Lorentz}=\overrightarrow{F}_{Lorentz}\cdot\overrightarrow{dl}`$**,   
<br>
soit   
<br>
$`\begin{align}
d\mathcal{W}_{\,Lorentz}&=q\Big(\overrightarrow{E}+\overrightarrow{\speed}\land\overrightarrow{B}\Big)\cdot\overrightarrow{dl}\\
&\\
&= q\Big(\overrightarrow{E}\cdot\overrightarrow{dl}\Big)+ q\Big(\overrightarrow{\speed}\land\overrightarrow{B}\cdot\overrightarrow{dl}\Big)\\
&\\
&= q\,\overrightarrow{E}\cdot\overrightarrow{dl} + q\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big) \\
\end{align}`$   
<br>
où $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)`$ est le produit mixte de la séquence des trois vecteurs.

* Les *vecteurs $`\overrightarrow{\speed}`$ et $`\overrightarrow{dl}=\overrightarrow{\speed}\,dt`$* étant *colinéaires*, le produit mixte 
est nul :   
<br>
*$`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$*,

!!!! 
!!!! <details markdown=1>
!!!! <summary>Rappels sur le produit mixte</summary>
!!!! Le produit mixte de trois vecteurs $`\vec{a}\,,\vec{b}\,,\vec{c}`$, noté $`(\vec{a}\,,\vec{b}\,,\vec{c})`$
!!!! est défini par :    
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{a}\land\vec{b})\cdot\vec{c}`$.   
!!!! Il est alors facile de démontrer qu'il est invariant par permutation circulaire des 3 vecteurs :
!!!! $`(\vec{a}\,,\vec{b}\,,\vec{c})=(\vec{b}\,,\vec{c}\,,\vec{a})=(\vec{c}\,,\vec{a}\,,\vec{b})`$.
!!!! C'est donc un nombre réel, dont la valeur absolue s'identifie au volume du parallélépipéde 
!!!! créé les trois vecteurs $`\vec{a}\,,\vec{b}\,,\vec{c}`$.
!!!!
!!!! Dans le cas étudié, deux vecteurs au moins du produit mixte $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)`$
!!!! sont colinéaires car $`\overrightarrow{dl}=\overrightarrow{\speed}\,dt`$.
!!!! Je peux dès lors m'assurer que ce produit mixte est nulle,    
!!!! * soit en remarquant que trois vecteurs dont deux sont colinéaires s'inscrivent dans un même plan (2D)   
!!!! et donc le volume (3D) construit par ces trois vecteurs est nul : 
!!!! $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$   
!!!! * soit en utilisant l'invariance du produit mixte par permutation circulaire,    
!!!! $`\Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=\Big(\overrightarrow{dl},\overrightarrow{\speed},\overrightarrow{B}\Big)`$
!!!! $`=dt\times\Big(\overrightarrow{\speed},\overrightarrow{\speed},\overrightarrow{B}\Big)`$
!!!! et en remarquant que le produit vecoriel de deux vecteurs colinéaires est nul :
!!!! $`\big\Vert\overrightarrow{\speed}\land\overrightarrow{\speed}\big\Vert=\big\Vert\overrightarrow{\speed}\big\Vert\cdot\big\Vert\overrightarrow{\speed}\big\Vert\cdot \sin 0=0`$
!!!! $`\Longrightarrow \overrightarrow{\speed}\land\overrightarrow{\speed}=\overrightarrow{0}`$   
!!!! $`\Longrightarrow \Big(\overrightarrow{\speed},\overrightarrow{B},\overrightarrow{dl}\Big)=0`$
!!!! </details>
!!!! 

* $`\Longrightarrow`$ le **travail de la force de Lorentz** se simplifie :   
<br>
**$`d\mathcal{W}_{\,Lorentz} = q\,\overrightarrow{E}\cdot\overrightarrow{dl}`$**

! *Remarque :*
!
! La *force magnétique $`\overrightarrow{F}_{\,magn.}=q\,\overrightarrow{\speed}\land\overrightarrow{B}`$*, 
! par nature perpendiculaire au vecteur vitesse $`\overrightarrow{\speed}`$ et donc au vecteur déplacement 
! élémentaire $`\overrightarrow{dl}=\overrightarrow{\speed}\,dt`$ en tout point de la trajectoire de la particule
! de charge $`q`$, *ne travaille pas* :
!
! $`\mathbf{d\mathcal{W}_{\,magn} = \overrightarrow{F}_{magn}\cdot \overrightarrow{dl}=0}`$
!
! *Le travail de la force de Lorentz se limite au travail de la force électrique* :
!
! $`\mathbf{d\mathcal{W}_{\,Lorentz} = d\mathcal{W}_{\,élec} =q\,\overrightarrow{E}\cdot \overrightarrow{dl}}`$

* La **puissance élémentaire cédée par le champ** à cette particule s'écrit :   
<br>
**$`\mathbf{\mathcal{P}_{cédée} = \dfrac{d\mathcal{W}_{\,Lorentz}}{dt} = q\,\overrightarrow{E}\cdot\overrightarrow{\speed}}`$**

##### Puissance cédée dans un matériau avec un seul type porteur de charge

* Si le **milieu matériel** contient *$`n`$ porteurs identiques de charge $`q`$ par unité de volume*,
alors un volume élémentaire $`d\tau`$ contient $`n\,\tau`$ porteurs de charge 
et la **puissance élémentaire cédée** par le champ électromagnétique s'écrit :   
<br>
**$`d\mathcal{P}_{cédée} = \mathcal{n}\,\big( q\,\overrightarrow{E}\cdot\overrightarrow{\speed}\big)\,d\tau`$**

* Exprimée *avec la densité volumique de charge $`\dens=\mathcal{n}\,q`$* :   
<br>
$`d\mathcal{P}_{cédée} = \big(\mathcal{n}\, q\big)\,\overrightarrow{E}\cdot\overrightarrow{\speed}\,d\tau = = \dens\,\overrightarrow{E}\cdot\overrightarrow{\speed}\,d\tau`$

* Exprimée *avec le vecteur densité volumique de courant $`\overrightarrow{j}=\dens\,\overrightarrow{\speed}`$*, en remarquant que 
$`\overrightarrow{E}\cdot\overrightarrow{\speed}=\overrightarrow{\speed}\cdot\overrightarrow{E}`$ :   
<br>
**$`d\mathcal{P}_{cédée} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau`$**

##### Puissance cédée dans un matériau avec un seul type porteur de charge

* Lorsqu'un matériau contient **plusieurs types de porteurs de charges $`q_i`$** 
en *concentrations $`n_i* et animées de *vitesses de dérives $`\overrightarrow{v_d\,i}`$* :   
<br>
$`\displaystyle d\mathcal{P}_{cédée} = \sum_{i=1}^p \big(\mathcal{n}_i\,q_i\,\overrightarrow{E}\cdot\overrightarrow{\speed_i}\big)\,d\tau`$   
<br>
$`\displaystyle d\mathcal{P}_{cédée} = \sum_{i=1}^p \dens_i\,d\tau\,\overrightarrow{E}\cdot\overrightarrow{\speed_i}`$   
<br>
$`\displaystyle d\mathcal{P}_{cédée} =  \sum_{i=1}^p\overrightarrow{j_i}\cdot\overrightarrow{E}\,d\tau`$   
<br>
*$`d\mathcal{P}_{cédée} = \overrightarrow{j}_{total}\cdot\overrightarrow{E}\,d\tau`$*

* En posant plus simplement *$`\overrightarrow{j}_{total}=\overrightarrow{j}`$* :     
<br>
**$`\large{\mathbf{d\mathcal{P}_{cédée} = \big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}}`$**

* La *puissance cédée* par le champ électromagnétique *dans un volume $`\tau`$* s'appelle **$`\large{\text{Effet Joule}}`$**   
<br>
**$`\large{\displaystyle\mathbf{\mathcal{P}_{cédée} = \iiint_{\Ltau}\big(\overrightarrow{j}\cdot\overrightarrow{E}\big)\,d\tau}}`$**

<br> 

------------

<br>

#### Le champ électromagnétique contient-t-il de l'énergie ?

* Si le *champ électromagnétique* peut céder de l'énergie à la matière, c'est que lui-même il **contient de l'énergie**.

* Un champ électromagnétique $`\big(\overrightarrow{E}\,,\,\overrightarrow{B}\big)`$ s'étendant dans l'espace, 
  l'énergie contenue dans le champ est décrite par 
  une **densité volumique d'énergie électromagnétique $`\dens_{énergie-EM}^{3D}`$** définie en chaque point de l'espace.

* A partir des équations de Maxwell, on montre avec une combinaison d'opérateur adéquate (à faire) que cette
  densité volumique $`\dens_{énergie-EM}^{3D}`$ *possède deux composantes* :   
   * une *composante électrique $`\;\dens_{énergie-EM}^{3D}=\dfrac{\epsilon_0\,E^2}{2}`$*
   * une *composante magnétique $`\;\dens_{énergie-EM}^{3D}=\dfrac{B^2}{2 \mu_0}`$*.
   
* Ainsi, en tout point de l'espace :   
  <br>
  **$`\large{\mathbf{\dens_{énergie-EM}^{3D}=\dfrac{\epsilon_0\,E^2}{2}+\dfrac{B^2}{2 \mu_0}}}`$**


* L'énergie électromagnétique $`\mathcal{E}_{EM}`$ contenue **dans un volume $`\tau`$** s'exprime :   
  <br>
  **$`\displaystyle\large{\mathbf{\mathcal{E}_{EM}=\iiint_{\Ltau} \left(\dfrac{\epsilon_0\,E^2}{2}+\dfrac{B^2}{2 \mu_0}\right) d\tau}}`$**

<br>

------------

<br>

#### Pourquoi parlons-nous d'ondes électromagnétiques ?

##### Equation d'onde

* Pour un *champ vectoriel $`\overrightarrow{U}(\overrightarrow{r},t)`$*, l'**équation d'onde de d'Alembert** s'écrit :   
<br>
**$`\Delta \overrightarrow{U} - \dfrac{1}{\speed^2} \; \dfrac{\partial^2 \;\overrightarrow{U}}{\partial\; t^2}=0`$**   

* L'expression de l'*opérateur Laplacien vectoriel $`\Delta`$* en fonction des opérateurs $`grad`$, $`div`$ et $`rot`$ est :   
<br>
*$`\Delta =\overrightarrow{grad} \left(div\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\right)`$*

* L'**idée** est de *calculer pour chacun des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$* 
l'expression de *son Laplacien*, pour voir si une identification avec l'équation d'onde est
réalisée.


##### Etude de la composante $`\overrightarrow{E}`$ du champ électromagnétique.


* Pour **établir l'expression $`\;\;\Delta \overrightarrow{E}`$**, je calcule 
$`\;\;\overrightarrow{rot}\left(\overrightarrow{rot}\;\overrightarrow{E}\right)\;\;`$ puis 
$`\;\;\overrightarrow{grad} \left(div \overrightarrow{E}\right)\;\;`$ *à partir des équations
de Maxwell*.


*  $`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
\overrightarrow{rot} \,\left( -\dfrac{\partial \overrightarrow{B}}{\partial t}\right)`$   
<br>
En physique classique, espace et temps sont découplés. Les coordonnées spatiales
et la coordonnée temporelle sont indépendantes. L'ordre de dérivation ou intégration entre 
des coordonnées spatiales et la coordonnés temporelle n'importe pas, donc :   
<br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\overrightarrow{rot}\overrightarrow{B}\right)`$   
<br><br>
$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=
-\dfrac{\partial}{\partial t} \,\left(\mu_0\;\overrightarrow{j} +
\mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\right)`$
<br><br>
*$`\overrightarrow{rot} \, \left( \overrightarrow{rot}\,\overrightarrow{E} \right)=-\mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$*
<br><br>

* *$`\overrightarrow{grad} \left( div \; \overrightarrow{E} \right) = \overrightarrow{grad}\left( \dfrac{\dens}{\epsilon_O} \right)`$*

<br>


* La reconstruction de 
$`\Delta \;\overrightarrow{E} =\overrightarrow{grad} \left(div\;\overrightarrow{E}\right) - \overrightarrow{rot}\, \left(\overrightarrow{rot}\;\overrightarrow{E}\right)`$
donne :   
<br>
$`\Delta \;\overrightarrow{E} = \overrightarrow{grad}\left( \dfrac{\dens}{\epsilon_O} \right) + \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}  +
\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2}`$   
<br>
ce qui donne par identification au premier terme de l'équation d'onde :   
<br>
**$`\mathbf{\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_O} \;
\overrightarrow{grad}\left(\dens \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}}`$**   
<br>
_(équation de propagation du champ électrique)_

##### Etude de la composante $`\overrightarrow{B}`$ du champ électromagnétique.

* Une *étude de forme identique* (proposée en autotest dans la partie beyond) me conduirait 
pour le champ magnétique  $`\overrightarrow{B}`$ à l'équation de propagation :   
<br>
**$`\mathbf{\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}}`$**   
<br>
_(équation de propagation du champ magnétique)_

##### Propagation d'une onde électromagnétique dans la matière

* L'étude part des équations de Maxwelle et des deux équations   
<br>
$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \dfrac{1}{\epsilon_O} \;
\overrightarrow{grad}\left(\dens \right)+ \mu_0\;\dfrac{\partial \overrightarrow{j}}{\partial t}`$   
<br>
$`\Delta \overrightarrow{B}-\epsilon_0\mu_0\;\dfrac{\partial^2 \overrightarrow{B}}
{\partial t^2}=-\mu_0\;\overrightarrow{rot}\;\overrightarrow{j}`$   
<br>
et fait l'objet de tout un **développement dans un chapitre ultérieur**.


##### Propagation d'une onde électromagnétique dans le vide

 * L'*espace vide* est caractérisé par une absence de charges, fixes ou en mouvement. 
 La densité volumique de charge $`\dens_{vide}`$ de même que le vecteur densité volumique de courant
 $`\overrightarrow{j}_{vide}`$ ont une valeur nulle dans tout l'espace vide,   
 <br>
 *$`\dens_{vide}=0\quad\text{et}\quad\overrightarrow{j}_{vide}=\overrightarrow{0}`$*.
 
 * Dès lors, la propagation de l'onde électromagnétique dans le vide s'exprime sous la forme
 du système de **deux équations de d'Alembert** :   
 <br>
**$`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}`$**   
<br>
**$`\Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}`$**

!!!! *Attention* :   
!!!!
!!!! Les *équations de Maxwell impliquent la propagation du champ électromagnétique*.
!!!!
!!!! *Mais,*
!!!!
!!!! Les *deux équations d'onde pour les champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$
!!!! n'impliquent pas les équations de Maxwell*.
!!!!
!!!! Tout champ $`\overrightarrow{E}`$ qui vérifie 
!!!! $`\Delta \;\overrightarrow{E}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{E}}{\partial t^2} = \overrightarrow{0}`$
!!!!
!!!! et tout champ $`\overrightarrow{B}`$ qui vérifie
!!!! $`\Delta \;\overrightarrow{B}-\mu_0 \epsilon_0 \;\dfrac{\partial^2 \overrightarrow{B}}{\partial t^2} = \overrightarrow{0}`$
!!!!
!!!! ne décrivent la propagation d'une onde électromégnétique que si  $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$
!!!! vérifient les équations de Maxwell.


##### Célérité de la vitesse de la lumière dans le vide

* L'identification des équations de propagation des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$
avec l'équation d'onde de d'Alembert montre que *le champ électroimagnétique se propage à la célérité*   
<br>
*$`\large{\mathscr{v}=\dfrac{1}{\sqrt{\epsilon_0\,\mu_0}}}`$*

* La *célérité de la lumière dans le vide*, notée *$`\mathbf{c}`$* est une **constante fondamentale** de l'univers, et sa valeur exacte est :  
<br>
*$`\large{c=299 792 458 m\,s^{-1}\approx 3\times 10^8 m\,s^{-1}}`$*

!! *Pour aller plus loin* :   
!!
!! Les équations de propagation des ondes électromagnétiques, établies ici dans le cadre
!! de la physique classique,   
!! prévoient que les ondes électromagnétiques se propagent dans le vide à la célérité
!! $`c=1/\sqrt{\epsilon_0\,\mu_0}`$, célérité constante indépendante du mouvement de l'observateur.   
!!
!! ceci est en contradiction avec la loi d'addition des vitesses en mécanique classique, qui
!! résulte des transformations de Galilée.
!!
!! $`\Longrightarrow`$ pendant la seconde moitié du $`19^{ème}`$ siècle, le travail de physiciens fut
!! d'essayer de modifier les équations de Maxwell pour les rendre compatibles avec la physique classique.   
!!
!! Mais ce fut l'inverse qu'il fallait faire : modifier la mécanique de Newton, base de la physique classique,
!! pour la rendre compatible avec les équations de Maxwell.
!!
!! Ce travail inverse fut celui d'Albert Einstein, qui publia en 1905 un article intitulé   
!! "Sur l'électrodynamique des corps en mouvement",   
!! qui fut la naissance de la théorie de la Relativité restreinte, qui bouleverse notre conception
!! de l'espace et du temps.
!!
!! Plus tard, en 1915, Einstein soumet un article intitulé   
!! "Les fondements de la théorie de la Relativité Générale"   
!! qui bouleverse notre conception du rapport entre l'espace-temps et son contenue en matière et énergie.
!!
!! *Physique Newtonienne* :   
!! espace + temps + matière + énergie.   
!!
!! *Physique relativiste au sens restreint* :   
!! espace-temps + matière-énergie ($`E=m\,c^2`$).   
!!
!! *Physique relativiste au sens général* :   
!! espace-temps-matière-énergie.   

<br>

-------

<br>

#### Qu'est-ce que le spectre électromagnétique ?


* **Maxwell** émet l'hypothèse que *la lumière* visible, dont on venait de mesurer la vitesse à partir
 de l'observation astronomique du mouvement des satellites de Jupiter, *est une onde électromagnétique*.   
<br>
$`\Longrightarrow`$ la lumière n'est qu'une toute petite partie des ondes électromagnétiques.   
<br>
$`\Longrightarrow`$ tout un *monde nouveau de "lumières"* se révèle, appelé **spectre électromagnétique**.   

![](astro-electromagnetic-spectrum-N4_1_fr_L1200.jpg)

* En particulier, **la connaissance de l'univers** résultait *avant Maxwell* de la seule observation du *domaine visible*,

![](ciel-visible-bsp_L1200.jpg)

* s'étend *maintenant* à *l'ensemble du spectre électromagnétique*.

![](ciel-images-bsp_L600_transparence.gif)

<br>

------

<br>

#### Qu'est-ce que le vecteur de Poynting ?


* L'**onde électromagnétique contient de l'énergie**
   * avec *en chaque point de l'espace* une **densité volumique d'énergie $`\dens_{énergie-EM}^{3D}`$**,   
    \- avec une *composante électrique $`\dens_{énergie-EM}^{3D}=\dfrac{\epsilon_0\,E^2}{2}`$*,   
    \- avec une *composante magnétique $`\dens_{énergie-EM}^{3D}=\dfrac{B^2}{2 \mu_0}`$*.
   * qui **se déplace dans le vide** *à la vitesse $`c`$*. 

   
   
* Le **vecteur de Poynting** traduit ce fait, et permet le *calcul de l'énergie* d'une onde électromagnétique
  incidente *sur une surface quelconque par seconde*.
 
* Le **vecteur de Poynting**, définit en chaque point de l'espace, est *défini par* la relation :   
<br>
   *$`\large{\mathbf{d\mathcal{P}=\overrightarrow{\Pi}\cdot\overrightarrow{dS}}}`$*   
<br>
où $`d\mathcal{P}`$ est la *puissance élémentaire* de l'onde électromagnétique
*rayonnée à travers l'élément de surface* $`\overrightarrow{dS}`$.

![](poynting-vector-1_L1200.jpg)

* Son **expression** en fonction des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ est :   
  <br>
  **$`\large{\mathbf{\overrightarrow{\Pi}=\dfrac{\overrightarrow{E}\land\overrightarrow{B}}{\mu_0}}}`$**

* *Unité SI* : **$`\mathbf{W\,m^{-2}}`$**

! *Remarque 1* :   
!
! Le déplacement d'une charge $`(unité SI : C)`$ contenue dans un volume élémentaire
! $`d\tau\quad (SI : ! m^3)`$ de densité volumique de 
! charge $`\dens_{charge}^{3D}\quad (SI : C\,m^{-3})`$ à une vitesse 
! $`\overrightarrow{\mathscr{v}_d}\quad (SI : m\,s^1)`$ :   
! * permet de définir un vecteur densité de courant (électrique) volumique 
! $`\overrightarrow{j}_{courant}^{3D}=\dens_{charge}^{3D}\,\mathscr{v}_d\,,\quad (SI : A\,m^{-2})`$,
!  * et ainsi permet de calculer l'intensité élémentaire $`dI\quad (SI : A = C\,s-{-1})`$ du courant qui traverse
! tout élément de surface 
! $`\overrightarrow{dS}\quad (SI : m^2)`$,   
! $`dI= \overrightarrow{j}_{courant}^{3D}\cdot\overrightarrow{dS}`$,   
!
! de même,  
! 
! le déplacement de l'énergie $`(unité SI : J)`$ de l'onde électromagnétique contenue 
! dans un volume élémentaire $`d\tau\quad (SI : ! m^3)`$ de densité volumique d'énergie
! $`\dens_{énergie_EM}^{3D}`$ à la célérité $`c`$ :   
! * permet de définir l'équivalent d'un vecteur densité de puissance de l'onde électromagnétique 
! , appelé *vecteur de Poynting* et noté *$`\overrightarrow{\Pi}\quad (SI : J\,s^{-1}\, m^{-2}=W\, m^{-2}=`$,
! * ce qui permet de calculer la puissance élémentaire $`d\mathcal{P}\quad (SI : W)`$ de l'onde EM qui traverse tout élément de surface 
! $`\overrightarrow{dS}`$,   
! $`d\mathcal{P}= \overrightarrow{\Pi}\cdot\overrightarrow{dS}`$.   

! *Remarque 2* :   
!
! *L'expression du vecteur de Poynting* en fonction du champ électrique et du champ magnétique de l'onde,
! ainsi que *sa signification*, sont *plus faciles à retenir* si l'on choisit de l'exprimer 
! *en fonction du champ d'excitation magnétique $`\overrightarrow{H}`$*.  
!
! *__Dans le vide__ (et uniquement dans le vide)* :   
!  Le champ magnétique est aussi bien décrit par le champ d'induction 
! $`\overrightarrow{B}`$ qui intervient dans la force de Lorentz qui induit les effets, 
! que par le champ d'excitation magnétique $`\overrightarrow{H}`$.  
! Ces deux champs sont proportionnels, le rapport de proportionnalité étant la constante magnétique $`\mu_0`$ :   
! <br>
! $`\overrightarrow{B}=\mu_0\,\overrightarrow{B}\quad\text{(dans le vide)}`$
!
! L'expression dans le vide du vecteur de Poynting est alors :   
! <br>
! $`\overrightarrow{\Pi}=\overrightarrow{E}\land\overrightarrow{H}`$
!
! En se souvenant 
! * de l'électrostatique que l'unité SI de $`\overrightarrow{E}`$ est le $`V\,m^{-1}`$,   
! * de la magnétostatique que l'unité SI de $`\overrightarrow{H}`$ est le $`A\,m^{-1}`$,   
! * de l'étude des circuits que $`\mathcal{P}\,(W) = U\,(V)\times I\,(A)`$,   
!
! alors l'*unité SI du vecteur de Poynting* apparaît facilement comme le *$`V\,A\,m^{-2}= W\,m^{-2}`$*
! 
! Dans le système international de mesure, le Vecteur de Poynting s'exprime en *Watt par mètre carré*.
!
! La *grandeur physique du vecteur de Poynting* est une *puissance par unité de surface*.


<br>

------

<br>

#### Comment calculer le puissance traversée par une surface d'aire et d'orientation quelconque ?

* Elle se calcule simplement par l'expression :   
<br>
**$`\displaystyle\large{\mathbf{\mathcal{P}=\iint_S \overrightarrow{\Pi}\cdot\overrightarrow{dS}}}`$**  


#### Comment émettre une onde électromagnétique ?

* Il suffit d'**accélérer une particule chargée**.

<!---------------------
#### Comment capter la puissance d'une onde électromagnétique ?

Quelques idées très synthétiques.   
Pour des ressources transverses et classiques, liens en parallèles
---------------------->








