---
title: 'Point dynamics'
published: true
routable: true
visible: false
lessons:
    -
      slug: point-dynamics
      name: LINÉAIRE : Dynamique du point matériel
      order: 2
    -   
      slug: all-newton-classical-mechanics
      name: PARALLELE : Mécanique de Newton
      order: 3
    -   
      slug: all-newton-classical-point-mechanics
      name: PARALLELE : Mécanique de Newton
      order: 2
    -   
      slug: classical-mechanics-newton-lagrange
      name: PANORAMA : de Newton à Lagrange
      order: 1
---


*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

<!------------
!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>
------------->

<!--MétaDonnée : ... -->

##### Randonnée Contreforts :&nbsp; _toute spécialité_

---------------------------

*Mécanique classique :*

#### Les causes du mouvements

<br>

RÉSUMÉ
: ---
  à faire


<br>
![](title-point-dynamics-in-galilean-reference-frame_v2_L1200.jpg)   
<br>

<!------------
Brainstorming "programme et plan d'exposition" :   
(fortement susceptible d'évoluer)
------------->
<br>
#### Qu'est-ce qu'une interaction mécanique entre deux corpuscules ?

à faire

<br>
#### Quelles sont les interactions fondamentales ?

à faire

<br>
#### Quel est le lien entre interaction, notion de force, et masse d'inertie ?

à faire

<br>
#### Que signifie réellement l'égalité entre la masse d'inertie et la masse grave ?

* La signification de l'égalité entre masse grave et masse d'inertie 
(_qui justifie le terme de masse employé dans les deux cas_)
se conçoit mieux avec un contre-exemple.   
<br>
##### Non égalité de la charge électrique et de la masse d'inertie

* L'*expérience* montre qu'il n'y a **pas de proportionnalité** entre la
 *charge électrique* et la *masse d'inertie*.

* Exemple : l'ion $`Cu^{2+}`$ possède une charge électrique $`q`$ double de celle de l'ion $`Cu^{+}`$
pour une masse d'inertie quasi-identique.  

* $`\Longrightarrow`$ **Charge électrique** et **masse d'inertie** sont des grandeurs 
physiques de *natures différentes*.   
<br>
##### Égalité entre masse grave et masse d'inertie, question de l'identité

* *Pour la totalité des corps* observés, les expériences réalisées montrent que
la **masse grave** et la **masse d'inertie** sont toujours **proportionnelles**. 

* *Dans un système d'unité* donnée, le *choix des valeurs numériques* de certaines *constantes fondamentales*
 (valeur de la constante gravitationnelle $ G`$) a permi
de réaliser l'**égalité numérique** entre les valeurs de la masse grave et de la masse d'inertie.   
<br>
**$`\Large\mathbf{m_{grave}=m_{inertie}}`$**   
<br>
Dès lors nous ne les distinguerons plus et les nommerons *indistinctement* la **masse** :
<br><br>
$`\Large m_{grave}=m_{inertie}`$ **$`\Large\mathbf{\,= m}`$**

!! *Pour aller plus loin* : vers la relativité générale d'Einstein.
!!
!! à faire, de cette égalité en valeur jamais prise en défaut à l'identité.
!! identité = une entité unique qui a un aspect quantité de matière (masse grave = degré de sensibilité
!! à l'interaction gravitationnelle) est un aspect spatio-temporelle (résistance à la variation de l'état de mouvement
!! lors d'une interaction mécanique).
!! 
!! à faire : remarque qui induit l'identité entre matière énergie et la géométrie de l'espace-temps à travers le principe d'équivalence...
!! à terminer.

!!!!! *Terminologie* : Égalité versus identité
!!!!! A faire
!!!!! L'identité définit une chose ou un être unique.<br>
!!!!! 
!!!!! L'égalité définit les similitudes entre deux une choses ou un êtres.
!!!!! 
!!!!! faire la synthèse des définitions de différents dictionnaires.


<br>
#### Qu'est-ce que la quantité de mouvement ?

* La **quantité de mouvement $`\overrightarrow{p}`$** d'un corpuscule de *masse $`m`$* animé dans un référentiel $`\mathscr{R}`$ 
d'une *vitesse $`\overrightarrow{\mathscr{v}}`$* s'exprime :   
<br>
**$`\Large\boldsymbol{\mathbf{\overrightarrow{p}=m\,\overrightarrow{\mathscr{v}}}}`$**


<br>
#### Quelle est la deuxième loi de Newton ?<br>**(Relation fondamentale de la dynamique)**

* Elle exprime que la force appliquée est égale à la dérivée par rapport au temps de sa quantité de mouvement :   
<br>
**$`\Large\mathbf{\displaystyle\overrightarrow{F}=\dfrac{d\overrightarrow{p}}{dt}}`$**   
<br>
En décomposant la quantité de mouvement comme le produit de la masse par la vitesse, tu obtiens :   
<br>
*$`\Large\mathbf{\overrightarrow{F}}`$* $`\,=\dfrac{d\overrightarrow{p}}{dt}`$   
   
$`\hspace{1.5cm} = \dfrac{d (m \overrightarrow{v})}{dt}`$   
   
*$`\hspace{1.5cm} = \Large\boldsymbol{\mathbf{\dfrac{dm}{dt}\cdot\overrightarrow{v} + m\cdot \dfrac{d\overrightarrow{v}}{dt}}}\quad`$* (éq.1)   
<br> 
!!! *Exemple :* La fusée.<br>
!!! * Le corpuscule peut modéliser de façon simplifiée une fusée.<br>
!!! * Une fusée ne s'appuie pas sur les gaz qu'elle éjecte.<br>
!!! * Une fusée se propulse grâce à la force de réaction qu'exercent les gaz éjectés
!!! sur elle-même.<br>   
!!! * *Une fusée perd de la masse* de  comburant et de carburant au fur et à mesure qu'elle accélère.
!!! C'est donc l'équation 1 qui donne l'expression de la force qui la propulse.


* Pour un **corpuscule de masse constante** :   
<br>
$`(m = cste)\;\Longrightarrow\;`$ *$`\mathbf{\dfrac{dm}{dt} = 0}`$*, donc :   
<br>
**$`\Large\mathbf{\overrightarrow{F}=m\dfrac{d\overrightarrow{v}}{dt}=m\overrightarrow{a}}`$**

<br>
#### Quelle est la troisième loi de Newton ?<br>**(Principe d'action et de réaction)**

* Soient *deux corpuscules* 1 et 2 *en interaction*.       
Les forces d’interaction $`\overrightarrow{F}_{1\rightarrow 2}`$ et $`\overrightarrow{F}_{2\rightarrow 1}`$ 
qu'exercent un corpuscule sur l'autre sont opposées :   
<br>
**$`\Large\mathbf{\overrightarrow{F}_{1\rightarrow 2}=-\overrightarrow{F}_{2\rightarrow 1}}`$**

<br>
#### Quels sont les différents types de forces ?

* Les **Forces fondamentales** représentant l'action d'une *interaction fondamentale*.
   * elles *s'exercent à distance*

* Les **Forces de contact** :
   * forces de *réaction d'un support*
   * forces de *frottement* (solide, visqueux).

* Les **forces d'inertie** (*d'accélération et de Coriolis*),    
lorsque le mouvement est observé **dans référentiel non galiléen**.


<br>
#### Qu'est-ce que le principe de superposition ?

* Soient un **corpuscule i** de *sensibilité $`\alpha_i`$* et    
  un **corpuscule j** de *sensibilité $`\alpha_j`$* à une interaction I.    

* Soit $`\overrightarrow{F}_{i\rightarrow j}(\alpha_i,\alpha_j)`$ la force qu'exerce 
le corpuscule i sur le corpuscule j.

* Le principe de superposition postule que l'expression de la 
**force $`\overrightarrow{F}_{i\rightarrow j}(\alpha_i,\alpha_j)`$**
d'interaction du corpuscule i sur le corpuscule j reste **inchangée** qu'il y ait 
*présence ou non d'autres corpuscules* sensibles à la même interaction dans le voisinage de i et j.

* La **force totale** d'interaction qu'exercent N corpuscules sur un corpuscule j peut ainsi
s'exprimer et se calculer simplement comme la *somme des forces d'interaction "deux à deux"*
qu'exercent chacun des N corpuscules sur j :   
<br>
**$`\Large\mathbf{\overrightarrow{F}_{tot\rightarrow j}}`$** *$`\mathbf{\,=\displaystyle\large\sum_{i=1}^N \Large\overrightarrow{F}_{i\rightarrow j}}`$*

<br>
#### Synthèse

* La force totale $`\overrightarrow{F}_{totale}`$ exercée sur un corpscule de masse $`m`$ et 
de quantité de mouvement $`\overrightarrow{p}=m\overrightarrow{v}`$ conduit 
la variation de quantité de mouvement $`\dfrac{d\overrightarrow{p}}{dt}`$ suivant l'expression :   

**$`\Large\mathbf{\overrightarrow{F}_{totale}}`$**   
<br>
$`\hspace{0.5cm}=\sum\overrightarrow{F}_{qui\ s'appliquent}`$   
<br>
$`\hspace{0.5cm}=\underbrace{\sum\overrightarrow{F}_{à\ distance}}_{inter.\ fondamentales}
+\underbrace{\sum\overrightarrow{F}_{de\ contact}}_{frottements,\ réactions}
+\underbrace{\sum\overrightarrow{F}_{d'inertie}}_{si\ réf.\ non\,galiléens}`$   
<br>
$`\hspace{0.5cm}=\dfrac{d\overrightarrow{p}}{dt}`$   
<br>
$`\hspace{0.5cm}=\dfrac{d\big(m\overrightarrow{v}\big)}{dt}`$   
<br>
**$`\Large\mathbf{\hspace{0.5cm}=m\,\overrightarrow{a}\;+\underbrace{\dfrac{dm}{dt}\cdot\overrightarrow{v}}_{\color{blue}{si\ m\ \\non\ constante}}}`$**


<!----------------------
De par la règle mathématique de sommation des vecteurs, ce postulat justifie de modéliser les interactions
entre corpuscules par les grandeurs vectorielles que sont les forces.
------------------------>

!! *Pour aller plus loin* :<br>
!! * Ce postulat ne reflète pas une réalité physique évidente.<br>
!! * De fait dans certains cas extrêmes observés dans
!! l'univers, l'interaction gravitationnelle d'un corps i sur un corps j est perturbée 
!! par la présence d'un troisième corps au voisinage des deux premiers. 
!! * Le modèle physique de la relativité générale tient compte de ce fait, ce qui explique
!! la complexité de la mathématique qu'elle utilise.<br>
!! * Chaque corps massique déforme l'espace-temps autour de lui.
!! Les mouvements liés des deux corps i et j sont des géodésiques dans l'espace-temps déformé par les deux corps eux-mêmes.
!! * La présence d'un troisième corps ajoute sa contribution à la déformation de l'espace-temps. Il ne serait pas possible
!! de modéliser les mouvements des trois corps prédits par la relativité générale à l'aide d'un modèle vectoriel.


<br>
##### Qu'est-ce que la loi de conservation de la quantité de mouvement ?

* Elle est **valide** au sein d'un *système isolé de particules*.

<br>
* Soit un **système isolé** de *N corpuscules*.   

* La *force* qu'exerce un *corpscule j sur lui-même* est *nulle* :   
<br>
*$`\Large\mathbf{\overrightarrow{F}_{j\rightarrow j}=\overrightarrow{0}}`$*

* La **force totale** $`\overrightarrow{F}_{tot\rightarrow j}`$ *exercée par les N-1 autres corpscules* 
sur un corpuscule j du système s'écrit :   
<br>
**$`\Large\mathbf{\overrightarrow{F}_{tot\rightarrow j}}`$** *$`\Large\mathbf{=\displaystyle\sum_{i=1}^N \overrightarrow{F}_{i\rightarrow j}}`$*   
<br>
$`\hspace{0.5cm}\;=\displaystyle\sum_{i=1}^N \dfrac{d \overrightarrow{p}_{i\rightarrow j}}{dt}`$   
<br>
$`\hspace{0.5cm}\displaystyle\;=\dfrac{\sum_{i=1}^N d \overrightarrow{p}_{i\rightarrow j}}{dt}`$   
<br>
**$`\hspace{0.5cm}\Large\mathbf{\;=\dfrac{d \overrightarrow{p}_{tot\rightarrow j}}{dt}}`$**

* La **quantité de mouvement totale** du système isolé des N corpuscules est la somme
des quantités de mouvement de ses N corpuscules, soit :   
<br>
**$`\displaystyle\Large\mathbƒ{\overrightarrow{p}_{sys.iso}}`$**
*$`\displaystyle\mathbƒ{\;=\sum_{i=1}^N \overrightarrow{p}_{tot\rightarrow j}}`$*
**$`\displaystyle\Large\mathbƒ{\;=\sum_{i=1}^N \sum_{j=1}^N \overrightarrow{p}_{i\rightarrow j}}`$**

* La **dérivée temporelle de la quantité de mouvement totale** du système isolé s'exprime alors :   
<br>
**$`\Large\mathbf{\dfrac{d\overrightarrow{p}_{sys.iso}}{dt}}`$**
*$`\displaystyle\Large\mathbf{\;=\dfrac{d\big(\sum_{i=1}^N \sum_{j=1}^N \overrightarrow{p}_{i\rightarrow j}\big)}{dt}}`$*   
<br>
$`\displaystyle\hspace{0.5cm}=\sum_{i=1}^N \sum_{j=1}^N \dfrac{d\overrightarrow{p}_{i\rightarrow j}}{dt}`$   
<br>
$`\displaystyle\hspace{0.5cm}=\sum_{i=1}^N \sum_{j=1}^N \overrightarrow{F}_{i\rightarrow j}`$   
<br>
$`\displaystyle\hspace{0.5cm}=\sum_{i=1}^N \overrightarrow{F}_{i\rightarrow i}
+\sum_{i=2}^N \sum_{j=1}^{(i-1)} \overrightarrow{F}_{i\rightarrow j}
+\sum_{j=2}^N \sum_{i=1}^{(j-1)} \overrightarrow{F}_{i\rightarrow j}`$   
<br>
$`\displaystyle\hspace{0.5cm}=\sum_{i=1}^N \underbrace{\overrightarrow{F}_{i\rightarrow i}}_{=\,0}
+\sum_{i=2}^N \sum_{j=1}^{(i-1)} \underbrace{\big(\overrightarrow{F}_{i\rightarrow j}
+\overrightarrow{F}_{j\rightarrow i}\big)}_{=\,0\,(action-réaction)}`$   
<br>
**$`\Large\mathbf{\hspace{0.5cm}=0}`$**



$`\displaystyle\begin{align}
\dfrac{d\overrightarrow{p}_{sys.iso}}{dt}&=\dfrac{d\big(\sum_{i=1}^N \sum_{j=1}^N \overrightarrow{p}_{i\rightarrow j}\big)}{dt}\\
\\
&=\sum_{i=1}^N \sum_{j=1}^N \dfrac{d\overrightarrow{p}_{i\rightarrow j}}{dt}\\
\\
&=\sum_{i=1}^N \sum_{j=1}^N \overrightarrow{F}_{i\rightarrow j}\\
\\
&=\sum_{i=1}^N \overrightarrow{F}_{i\rightarrow i}
+\sum_{i=2}^N \sum_{j=1}^{(i-1)} \overrightarrow{F}_{i\rightarrow j}
+\sum_{j=2}^N \sum_{i=1}^{(j-1)} \overrightarrow{F}_{i\rightarrow j}\\
\\
&=\sum_{i=1}^N \underbrace{\overrightarrow{F}_{i\rightarrow i}}_{=\,0}
+\sum_{i=2}^N \sum_{j=1}^{(i-1)} \underbrace{\big(\overrightarrow{F}_{i\rightarrow j}
+\overrightarrow{F}_{j\rightarrow i}\big)}_{=\,0\,(action-réaction)}\\
\\
&=0
\end{align}`$   
<br>
Tu peux alors énoncer la loi de conservation :   
<br>
La **quantité de mouvement d’un système de N particules isolées**
est *stationnaire* (ne varie pas dans le temps).



<!------------
9 - Retour sur la première loi de Newton
-------------->

<br>
![](title-point-dynamics-between-2-reference-frames_v2_L1200.jpg)   
<br>

