---
title: Waves in Physics
published: true
routable: true
visible: false
lessons:
    - 
        slug: waves-conceptual-and-learning-patterns-en
        name: PANORAMA-234 : Waves, an overview
        order: 1
---

*Course under construction*, **not validated**. 
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-EN_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Stage 2 : In structuring</summary>  
1. Brainstorming
2. In structuring
3. In writing : 1/3
4. In writing : 2/3
5. In writing : 3/3
6. Under review
7. Tested with students
8. Validated, still incomplete
9. Validated, sufficient basis
10. Validated, operational, in constant improvement
</details>


##### Hill Hiking

---------------------------

### WAVES

### **Waves** *in Physics*

<br>
[multilingual version : EN , FR , ES](https://m3p2.com/polyglot/temporary-m3p2/waves/n2/waves-introduction/waves-in-physics)
<br>

<!--
# <p style="font-size:70%;text-align: center;">Waves in Physics</p>
<p style="font-size:75%;text-align: center;">Birth of the Wave Concept</p>
-->

#### Birth of Field and Wave Concepts

 * Each of us has thrown a ball or tossed a pebble. At every moment, these objects occupy 
 a well-defined position in space and follow a trajectory that our eyes can track. 
This sensory experience forms the basis of our intuitive concept of **material bodies**:
well-defined objects with limited spatial extent that move according to the laws of physics.   
<br>
But our sensory experience is not limited to these localized objects. Each of us has 
**thrown pebbles into water** or watched raindrops fall onto the calm surface of a pond.   
<br>
Their impacts disturb the water’s surface, creating **small circular ripples** that
*propagate, reinforce, or diminish* when they cross each other, and
*bend around obstacles* encountered along their path.

* These ripples manifest, *at every moment and at every point* on the surface, as a
**variation in water height** beneath the surface.   
<br>
Physicists use the term **field** to describe a
*physical quantity defined at every point in space and at every moment*. Here, the
physical quantity is the water height, and the space is the two-dimensional surface
of the pond.   
<br>

* When the *pond is calm*, its surface in **equilibrium and stable**, the *height*
of the water beneath the surface **varies from point to point**, but this height at each point
**does not change over time**.   
<br>
The physicist says the *field* of water height is **stationary**.   
<br>

* The ripples represent a variation in water height relative to
the pond’s surface at rest. These *ripples* form the
*basis of our intuitive concept of waves*: **disturbances in a field** that **propagate**,
interfere, and diffract.   
<br>
To the physicist, a **wave** thus appears as the *non-stationary part of a field*—
the temporary deviation from the equilibrium value of the field at rest.   
<br>

* The *ripples* result from the **displacement** of water molecules—i.e., **of matter**.   
<br>
When a wave characterizes the *disturbance of a material medium*, the physicist refers to it
as a **mechanical wave**.   
<br>

* The **properties of mechanical waves**:
   *  *Propagation*
   *  *Interference*
   *  *Diffraction* around an obstacle.
   *  *Reflection and transmission* at the interface between two different media.
   *  *Energy transport*, but *no matter transport* over long distances.
   **are also found in more subtle phenomena** observed in nature and later described mathematically, or first predicted by physical theory before experimental confirmation.

<br>

![Waves Interference Diffraction](waves-interferences-diffraction-2_L1200.jpg)
_Representation of interference and diffraction phenomena._

<br>

#### Different Types of Waves

* Today, **four types of waves** have been observed, from *mechanical waves*
to *electromagnetic waves*, then *gravitational waves* and *quantum waves*.
In order, these waves **correspond to increasingly subtle levels of reality**,
linked to the speed of light *c*, and modeled by physical theories with
increasingly abstract mathematics.

<br>

![Four Types of Waves](waves-introduction-n2-EN_L1200.jpg)
_Four types of waves in physics, to describe increasingly subtle and abstract levels of reality._

---------

##### **Mechanical Waves** *($`v \lt c`$)*

* These are the *most familiar and intuitive* and are often very
*easy to observe* or feel. They correspond to a **disturbance in a material field**:
   * *ripples* on the water’s surface (height field).
   * *sounds* propagating through air (pressure field).
   * *seismic waves* in the ground (displacement field in Earth).
   * *vibrations* in a spring or a musical instrument string (displacement field).

* All **these waves are material**; their propagation speed $`\mathscr{v}`$ is lower
than the speed of light $`c`$.

* Requiring a material medium, they *cannot travel through a vacuum*.

![](https://m3p2.com/fr/temporary-m3p2/waves/images-sounds/wave-phenomena/Waves-reflexion-interferences-e_v2_L500.gif)
_Waves generated on the water’s surface in a dish during an impact on a wall._

<br>

--------

##### **Electromagnetic Waves** *($`v = c`$)*

* They do not result from the disturbance of a material medium but *are formed*
by a **perpendicular electric field and magnetic field that self-sustain**.
<br>
Since no supporting medium exists for electromagnetic waves, they
**can travel through a vacuum**, including interstellar space.

* These waves include:
   * *radio waves*
   * *microwaves*
   * *infrared*
   * *visible light*
   * *ultraviolet*
   * *X-rays*
   * *gamma rays*

* **Our eyes perceive only** a small part of this spectrum: *visible light*.
<br>
Because **these waves** are **pure energy** (they have no rest mass), they are
*far more abstract*.
<br>
At all times, **our bodies are traversed** by *radio waves*, *TV signals*, *WiFi waves* carrying
music, images, interview speech, etc.
**Without technology**, we would have *no awareness of most of these waves*.
<br>

* The **speed of electromagnetic waves** is
always *exactly $`c = 299\,792\,458 \, \text{m/s}`$*, a fundamental constant of nature called
*the speed of light in a vacuum*.
<br>
Since this speed does not depend on the observer’s state of motion, these waves
**defy our classical intuition** of the world. They constitute *one of the experimental proofs* of the coupling of space and time
within *spacetime*, first described by **special relativity** and later by **general relativity**.


<br>
![Linear Electromagnetic Wave](https://m3p2.com/fr/temporary_ins/waves/n2/overview/linear-electromag-wave-n3_L1200.gif)
![Elliptical Electromagnetic Wave](https://m3p2.com/fr/temporary_ins/waves/n2/overview/elliptic-wave-electromag-wave-n3_L1200.gif)
_Two different polarization states, linear (top) and elliptical (bottom), of an electromagnetic wave.
Without mastering the Mountain level, visual knowledge of these polarization states will allow you to understand, among other things, how you can see a movie in 3D even though it is projected on the 2D surface of a cinema screen._

! *Note* :
!
! **Electromagnetic waves**, until very recently (2015), were the *only source of all our knowledge of the Universe*:
!
! Astrophysics observes electromagnetic waves from the *Big Bang*, *galaxies*, *stars*,
! *planets*, and the *interstellar medium*.

---------------

##### **Gravitational Waves** *($`v = c`$)*

* Unlike electromagnetic waves, which travel through space and time, **gravitational waves**
are *even more abstract*—they are **disturbances in the curvature field of spacetime itself**.   
<br>

* **Spacetime** is warped by the presence of matter (which causes gravity), but it can also **vibrate**
during the *passage of gravitational waves* produced by violent events in the universe.   
Our senses cannot perceive these waves at all.


* Described by general relativity, they **travel** *at the speed of light $`c`$*.

! *Note* :
!
! Predicted by general relativity but observed only since 2015, the
! **gravitational waves** are at the **basis of a new astrophysics**,
! *gravitational wave astrophysics*.
! <br>
! It observes **violent and massive phenomena** in the universe:
! rapid rotations before their *merger of black holes and neutron stars*.

------

##### **Quantum Waves** *($`v \gt c`$ in some cases)*

<br>

*A - Wave Function and Measurement*

* The **wave function of a particle** (denoted by the Greek letter Psi $`\Psi`$) is governed by the
  Schrödinger equation in non-relativistic quantum mechanics, or by the Klein-Gordon,
  Dirac, Proca, Rarita-Schwinger equations (depending on the particle's spin) in quantum
  field theory (which combines and extends special relativity and quantum mechanics).

* It is *not material*, and one of its particularities is to
  *include an imaginary part* that plays a fundamental role.

* No one yet understands the real meaning of this wave.
  It is **limited by the speed of light, except at the moment of a measurement**
  (collapse of the wave function), which is a non-local, i.e., instantaneous phenomenon (therefore
  with $v > c$).
  This **non-local behavior** is *fundamentally random* and therefore
  *does not allow communication* (otherwise, it would imply the existence of temporal paradoxes).

<br>

*B - Wave Function and Entangled Particles*

* **Quantum entanglement** corresponds to an *even more abstract level of reality*.
  <br>
  The **quantum link between two entangled particles** (which have interacted together in the past) is
  an absolutely extraordinary connection that *exists outside of space and time*.
  <br>
  This link:
   * is *undetectable* by any known technology
   * *does not diminish* with distance
   * is *not stopped by obstacles* of any kind
   * has an *instantaneous behavior*, therefore *non-local*.

* **Fundamentally non-local**, this link is at the *basis of quantum teleportation*.
  <br>
  When the **state of a particle is teleported from place A to place B**,
  the *information propagates instantaneously* from A to B, and does not pass through the physical
  space between A and B (which is why it is said that this link exists outside of space and time).
  <br>
  The **conceptual understanding of this phenomenon** is *one of the great open questions*
  in the interpretation of quantum physics; it is the subject of major debates among physicists.

<br>

*C - Wave Function and Predictions*

* The **mathematical formulation of quantum mechanics** is
   * perfectly *well understood*
   * perfectly *experimentally verified*

  It is its conceptual interpretation that is a matter of controversy.

* The **instantaneous action of quantum entanglement** is *random*
  and *does not allow communication*.
  <br>
  However, **quantum teleportation allows communication** because it
  involves two steps:
   * a **first step** *carried by entanglement*,
   * a **second step** *limited by the speed of light*.

  Therefore, **complete teleportation** is *limited by the speed of light*.

! *Note* :
!
! In quantum mechanics and quantum field theory, the *wave function $`\Psi`$*
! is actually *linked to the probability of a particle's presence* in a given quantum state superposition. The probability itself is proportional to $` \Psi|^2`$.
! In this sense, it *describes the wave-particle duality*.

!! *Going Further* :
!!
!! The framework of quantum field theory, which combines and extends special relativity
!! and non-relativistic quantum mechanics, has seen many successes, including the prediction preceding the discovery of several particles such as the top quark (1995) and the Higgs boson (2011).
!!
!! However, it does not explain the phenomena predicted by general relativity (time dilation in a gravitational field, black holes, and gravitational waves, experimentally verified or observed).
!!
!! Thus, our understanding of all observed phenomena in the Universe requires two distinct theories: general relativity and quantum field theory, which seem
!! irreconcilable in their very foundations.
!!
!! Physicists continue the search for a unique principle that would give a single physical theory, of which general relativity and quantum field theory would be mere approximations,
!! and which would describe and statistically predict all phenomena at all scales of Nature.
