---
title: Démonstration du théorème d'Ampère
published: true
routable: true
visible: false
lessons:
    - slug: gauss-ampere-theorems-demonstration
      name: PARALLÈLE : Les 3 théorèmes pour physicien au niveau contreforts
      order: 3
---



<!--caligraphie de l'intégrale double curviligne-->
$`\def\oint{\displaystyle\mathop{{\int}\mkern-16mu \scriptsize \bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

##### Niveau Contreforts   _physique , maths appliqués_

---------------------------

### MAGNÉTOSTATIQUE

### Énoncé et démonstration :<br> **Théorème d'Ampère**

<br><br>

<!--------Commentaire-----------------------------------
!  *Thème* :<br>
! *N3 : Magnétostatique / Démonstration du théorème d'Ampère, forme intégrale et forme locale*<br>
! Guide pour établir les 3 parties : main, overview, beyond<br>
!
!  (_précède le thème : Magnétostatique : Application du théorème d'Ampère, forme intégrale et forme locale._)
-------------------------------------------------------->


ÉNONCÉS   DU   THÉORÈME   D' AMPÈRE<br>  ( appliqué à la MAGNÉTOSTATIQUE )

: ---

  *Domaine de validité* :
  
  Ne s'applique qu'en magnétostatique ($`\overrightarrow{B}`$ créé par des courants constants).<br>
  Son expression sera complétée en électromagnétisme ($`\overrightarrow{B}`$ créé par des courants variables) pour donner le théorème de Maxwell-Ampère.
   
   _Attention : Les expressions ci-dessous ne sont valables que dans le système international d'unité $`SI`$, anciennement $`MKS`$._
   
   ---
   
  *FORME  INTÉGRALE*
   
    La circulation du vecteur champ magnétique $`\overrightarrow{B}`$ le long d'un contour orienté $`\mathcal{C}`$ est égal à la somme algébrique des courants $`\overline{ \,I }`$ traversant toute surface ouverte $`S`$ associée à ce contour, multiplié par la constante magnétique $`\mu_0`$ :
    
    <br>$`\displaystyle\mathbf{\oint_{S\leftrightarrow\mathcal{C}} \overrightarrow{B}\cdot\overrightarrow{dl}=\mu_0\;\sum_{enlacés} \overline{I }}`$
    
    *autre formulation* : La circulation du vecteur champ magnétique $`\overrightarrow{B}`$ le long d'un contour orienté $`\mathcal{C}`$ est égal au flux du vecteur densité volumique de courant $`\overrightarrow{j}`$ à travers toute surface ouverte $`S`$ associée à ce contour, multiplié par la constante magnétique $`\mu_0`$ :
    
    <br>$`\displaystyle\mathbf{\oint_{\mathcal{C}\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}=\mu_0\; \iint_{S\leftrightarrow\mathcal{C}} \overrightarrow{j}\cdot\overrightarrow{dS}}`$
  
  <br>
  *FORME  LOCALE*
  
  En tout point de l'espace, le rotationnel du champ magnétique $`\overrightarrow{rot}\,\overrightarrow{B}`$ est égal au vecteur densité volumique de courant $`\overrightarrow{j}`$ multiplié par la constante magnétique $`\mu_0`$ :
   
    <br>$`\mathbf{\overrightarrow{rot}\,\overrightarrow{B}=\mu_0\;\overrightarrow{j}}`$
    
    ---
    
    *avec les unités $`SI`$* :<br>
    
   \- champ d'induction magnétique $`\overrightarrow{B}`$ : $`T`$<br>
   \- courant électrique $`\overline{I}`$ : $` A`$<br>
   \- vecteur densité volumique de courant $`\overrightarrow{j}`$ : $` A\;m^{-3}`$<br>
   \- constante magnétique = perméabilité du vide : $`\mu_0=1,25663706\cdot 10^{-6}\;SI`$
  


####  Quel est l'intérêt du théorème d'Ampère intégral ?

* Le théorème d'Ampère est un théorème très général.

* Dans la limite où un contour d'Ampère tend vers 0, il *permet de définir la notion de rotationnel* qui quantifie une propriété locale de tout champ vectoriel :<br>
$`\Longrightarrow`$ le théorème d'Ampère aura une expression locale.

* Cette notion de rotationnel est l'*une des trois notions essentielles* (avec le gradient et la divergence) *pour décrire les lois de la physique* au niveau universitaire.

* Il *permet de calculer le champ magnétique $`B`$* lorsque les distributions de courants présentent des invariances et symétries, en remplaçant des calculs qui seraient extrêmement complexes.

####  Quels sont les concepts nécessaires à sa compréhension ? 

* **Théorème** *= peut être démontré*

* Outre les concepts déjà vus de :<br>
\- circulation d'un champ vectoriel le long d'un contour.<br>
\- règle d'orientation de l'espace.<br>
la démonstration nécessite les concepts de :<br>
\- *ligne ouverte, et ligne fermée (contour)*.<br>
\- *surface ouverte associée à un contour*.<br>
\- *contours disjoints et contours enlacés*.<br>
\- *rotationnel* d'un champ vectoriel.<br>

#### Qu'est-ce qu'une ligne ouverte ou fermée ?

* **ligne ouverte = chemin** : ligne $`\mathcal{C}`$ délimitée par *2 extrémités $`M_1`$ et $`M_2`$*.<br>
$`\Longrightarrow`$ :<br>
\-  l'*orientation = sens* de parcours *défini comme positif* d'un chemin doit être choisie parmi les **deux sens possibles** : *de $`M_1`$ vers $`M_2`$*, ou *de $`M_2`$ vers  $`M_1`$*.<br>
\-  l'*intégration* sur un chemin utilise le symbole **$`\displaystyle\int_{\mathcal{C}}`$** :
*$`\quad\displaystyle\int_{M_1}^{M_2} ... `$* ou *$`\quad\displaystyle\int_{M_2}^{M_1} ... `$*

* **ligne fermée = contour = circuit** (circuit si parcouru par un courant électrique) : *ligne se refermant sur elle-même*.<br>
$`\Longrightarrow`$ :<br>
\- le **sens positif** de parcours doit être choisi et il est *indiqué par l'orientation des éléments vectoriels de chemin $`\overrightarrow{dl}`$*.<br>
\-  l'*intégration* sur un contour utilise le **symbole $`\oint_{\mathcal{C}}...`$**


#### Qu'est-ce qu'une surface ouverte associée à un contour ?

* Une surface ouverte **s'appuie sur un contour** si le contour est le *bord de la surface*.

* Il existe une **infinité de surfaces ouvertes** qui s'appuient sur *un même contour* quelconque.

![](contour_surface_enlacee_L1200.gif)

---

* Une **surface associée à un contour** respecte les deux conditions suivantes :<br>
<br>\- la surface **s'appuie sur ce contour**.<br>
<br>\- les **deux orientations choisis**, l'une sur le *contour* et l'autre sur la *surface*, sont liées par la **règle de la main droite**.

![](contour_surface_associated_oriented_4_L1200.gif)

---


#### Comment savoir si un chemin traverse une surface ouverte associée à un contour ?

##### Le contour et la surface associée sont contenus dans un plan

* Soient un **contour orienté $`\mathcal{C}`$** contenu **dans un plan $`\mathcal{P}`$**, et la **surface plane associé $`S`$**.

* L'**angle solide** sous lequel $`S`$ est vue depuis un point $`M`$ tend vers $`\pm 2\pi\;sr`$ lorsque la *distance du point $`M`$ à la surface $`S`$ tend vers 0* :<br>
<br>**$`\mathbf{\displaystyle\lim_{M\rightarrow{S\subset\mathcal{P}}}=\pm 2\pi}`$**,<br>
le signe $`+`$ ou $`-`$ dépendant du sens d'orientation choisi pour $`S`$ et de quel côté de la surface se situe $`M`$.

* Si un chemin $`M_1M_2`$ traverse une surface plane $`S`$, Il y a une **discontinuité de $`\pm 4\pi`$ dans la valeur de l'angle solide** sous lequel est vue $`S`$ *à la traversée de la surface plane*,<br>
le signe $`+`$ ou $`-`$ dépendant du sens d'orientation choisi pour $`S`$, et du sens de parcours du chemin $`M_1M_2`$.

* Ainsi, si $`\Omega_1`$ (respectivement $`\Omega_2)`$ est l'angle solide sous lequel est vue la surface plane $`S`$ depuis l'extrémité $`M_1`$ (resp. $`M_2`$), alors l'intégration de l'angle solide le long du chemin $`M_1M_2`$ est :<br>
<br> **$`\mathbf{\displaystyle\int_{M_1}^{M_2} d\Omega = \Omega_2 - \Omega_1 \pm 4\pi}`$**,<br>
le signe $`+`$ ou $`-`$ dépendant du sens d'orientation choisi pour $`S`$, et du sens de parcours du chemin $`M_1M_2`$.

![](traversee_contour_L850.gif)

-------

* Si le chemin **$`M_1M_2`$ traverse 2 fois et en sens inverses la surface plane $`S`$**, alors l'*intégration de l'angle solide* entre les deux extrémités $`M_1`$ et $`M_2`$ devient :<br>
**$`\mathbf{\displaystyle\int_{M_1}^{M_2} d\Omega = \Omega_2 - \Omega_1}`$**

![](contours_enlaces_1_L1200_v2.gif)

* Il existe alors **d' autres surfaces ouvertes s'appuyant sur le même contour** que le chemin  **$`M_1M_2`$ ne traverse pas**.
 
![](contours_enlaces_surface_no_plane_L1200.jpg)

---

##### Le contour et la surface associée sont quelconques


* Depuis un point $`M`$, l'**angle solide élémentaire $`d\Omega_{\Delta}`$** sous lequel est vu une *surface macroscopique traversée p fois* dans une direction $`\Delta`$  est donné par :<br>
**$`d\Omega_{\Delta}=\sum_{i=1}^p d\Omega_{\Delta, i}`$**, <br>
l'indice i indique l'ordre de traversée de la surface depuis le point d'observation $`M`$.<br>
(les différents $`d\Omega_{\Delta, i}`$ ont même valeur absolue $`|d\Omega_0|\ne 0`$)


* Si vue d'un point $`M`$ une surface est non torsadée, donc <br>
**si $`\forall i `$ les signes de $`d\Omega_{\Delta i}`$  et $`d\Omega_{\Delta i+1}`$ sont opposés, alors** :<br>
<br>\- **p pair** *$`\quad\Longrightarrow\quad\mathbf{d\Omega_{\Delta}= 0}`$*.<br>
<br>\- **p impair** *$`\quad\Longrightarrow\quad\mathbf{d\Omega_{\Delta}=\pm\,|\,d\Omega_0\,|}`$*.

* Si cette surface non torsadée est observée depuis *deux points $`M`$ et $`M'`$ situés sur l'axe d'observation $`\Delta`$ de par et d'autre au voisinage de la surface*, alors la **traversée entre $`M`$ et $`M'`$** implique :<br>
<br>\- **$`\mathbf{d\Omega_{\Delta}(M)=\pm\,|\,d\Omega_0\,|}`$**
*$`\quad\Longrightarrow\quad\mathbf{ d\Omega_{\Delta}(M')=0 }`$*<br>
<br>\- **$`\mathbf{d\Omega_{\Delta}(M)= 0}`$**
$`\quad\Longrightarrow\quad\mathbf{ d\Omega_{\Delta}(M')=\pm\,|\,d\Omega_0\,| }`$

![](solid-angle_traversee_L1200.gif)<br>

---

* Soit une **surface ouverte non plane et non torsadée $`S`$**, qui est *orientée.*<br>
Cette surface est *traversée en un point $`M_0`$* par une chemin ou un contour $`\mathcal{C}`$.


![](solid_angle_cross_surface_no_plane_3ter_L1200.gif)

* L'**angle solide limite $`\Omega_0`$** sous lesquel cette surface est observée lorsqu'*un point du chemin $`\mathcal{C}`$ tend par un côté vers $`M_0`$* n'est en général pas égale à $`2\pi`$. Mais cette  limite angle solide limite exprimé en stéradian peut s'écrire sous la forme :<br>
<br>**$`\mathbf{\Omega_0=\pm\,2\pi+\Omega '}`$** ,<br>
avec $`\Omega '`$ angle solide complémentaire qui peut être positif ou négatif.

* **Contribuent à $`\Omega_0`$ limite** tous les *angles solides élémentaires $`d\Omega_{\Delta}`$* correspondant à une direction $`\Delta`$ pour laquelle, depuis le point limite considéré, la *surface est traversée un nombre impair de fois*.

* **Ne contribuent pas à $`\Omega_0`$ limite** tous les angles solides élémentaires correspondants à une direction $`\Delta`$ qui *ne traverse pas* la surface, ou lorsque la *surface est traversée un nombre pair de fois*.


![](solid_angle_cross_surface_no_plane_2ter_L1200.gif)<br>
_Pour l'orientation de la surface_ $`S`$ _et la position du point_ $`M_0^+`$ _représentées sur la figure, l'angle solide limite sous lequel_ $`S`$ _est vue vaut_ $`\Omega_0^+=+2\pi+\Omega' `$_, avec_ $`\Omega' >0`$.

---

* L'**angle solide limite $`\Omega_0 '`$**  est l'angle solide d'observation de $`S`$ depuis *un point de $`\mathcal{C}`$ tend vers $`M_0`$* **depuis l'autre face**.<br>
$`\Longrightarrow`$ :<br>
\- toute direction $`\Delta`$ qui ne rencontrait pas la surface, la traverse désormais 1 fois.<br>
\- toute direction $`\Delta`$ qui traversait un nombre pair de fois la surface, la traverse un nombre impair de fois, et réciproquement.

* $`\Longrightarrow`$ toute direction qui apportaient une contribution à l'angle solide $`\Omega_0`$, ne contribue pas à l'angle solide $`\Omega_0 '`$.<br>
$`\Longrightarrow`$  inversement, toute direction ne contribuait pas à $`\Omega_0`$, contribue à $`\Omega_0 '`$.


* $`\Longrightarrow`$ Les **angles solides limites $`\Omega_0`$ et $`\Omega_0 '`$ vérifient** :<br>
<br>\- *algébriquement* :  **$`\mathbf{\Omega_0 ' - \Omega_0=\pm 4\pi}`$**<br>
<br>\- *en valeur absolue* : **$`\mathbf{|\,\Omega_0\,| + |\,\Omega_0 '\,|= 4\pi}`$**.

![](solid_angle_cross_surface_no_plane_1ter_L1200.gif)<br>
_Pour l'orientation de la surface_ $`S`$ _et la position du point_ $`M_0^-`$ _représentées sur la figure, l'angle solide limite sous lequel_ $`S`$ _est vue vaut_ $`\Omega_0^-=-2\pi+\Omega' `$_, en comptant_ $`\Omega' >0`$ comme dans la figure précédente.

---

* *A la traversée d'une surface quelconque*, l'**angle solide** sous lequel est observée une surface quelconque présente une **discontinuité de $`\pm\,4\pi`$**,<br>
le signe + ou - dépend de l'orientation de la surface, et du sens de traversée de la surface. 

![](angle_solide_variation_cross_any_surface_L1200.jpg)

---

#### Qu'est-ce que deux contours enlacés ?

* Deux contours sont **non enlacés** si et seulement si *il est possible de les séparer en les déformant*.<!--wikipedia : Si on peut séparer les deux courbes en les déformant sans les couper, alors l'enlacement des deux courbes vaut zéro. La réciproque est fausse.-->

* Considère le même cas que précédemment, mais avec les deux extrémités $`M_1`$ et $`M_2`$ d'un chemin confondues en un même point *$`M`$* $`\,=M_1=M_2`$ pour former un **contour $`\mathcal{C_2}`$** .

* Les *contours* sont **disjoints** :<br>
$`\Longleftrightarrow`$ un contour traverse **0 fois, 2 fois, ... 2n fois (avec n$`\in\mathbb{N}`$)** toute surface ouverte associée à l'autre contour.

* $`\Longrightarrow`$ lors d'un **tour complet** sur l'un des contours (exemple $`\mathcal{C_2}`$, la *variation de l'angle solide* sous lequel est vu l'autre contour (ou toute surface ouverte associée à ce contour) est *nulle* :<br>
**$`\mathbf{\oint_{\mathcal{C_2}} d\Omega = 0}`$**

![](contours_disjoints_L1200.jpg)

![](contours_enlaces_3_L1200.gif)

---


* Les *contours* sont **enlacés** :<br>
$`\Longleftrightarrow`$ un contour traverse **1 fois, 3 fois, ... (2n+1) fois (avec n$`\in\mathbb{N}`$)** toute surface ouverte associée à l'autre contour.

* $`\Longrightarrow`$ lors d'un **tour complet** sur l'un des contours (exemple $`\mathcal{C_2}`$, la *variation de l'angle solide* sous lequel est vue toute surface ouverte s'appuyant sur l'autre contour égale **$`\pm 4\pi`$ stéradians** :<br>
**$`\mathbf{\oint_{\mathcal{C_2}} d\Omega = \pm 4\pi}`$**

* Le **signe $`+`$ ou $`-`$** dépend des *sens de circulation définis comme positifs* sur chacun des contours.

![](contours_enlacees_1b_L1200.gif)

---


#### Démonstration du théorème d'Ampère : les différentes étapes

* Nous devrons reconstruire des angles solides $`d\Omega`$ et des surfaces $`dS`$ élémentaires à partir d'éléments de longueurs $`dl`$.<br>
$`\Longrightarrow`$ La **notation** suivante sera utilisée pour la clareté de la démonstration:<br>
\- *$`\mathbf{dl}`$* pour les éléments de longueur.<br>
\- *$`\mathbf{d^2S\;,\; d^2\Omega}`$* pour les éléments de surface et d'angles solides de base définis par le produit de deux éléments de longueur.<br>
\- *$`\mathbf{dS \;,\; d\Omega}`$*, puis *$`\mathbf{S \;,\; \Omega}`$* lors des intégrations successives.

<!--COMMENTAIRE------------------------------------
ou alors on parle d'infinitésimaux d'ordres 1, 2, ...?
---------------------------------------------------------->



##### Quel est le déplacement apparent d'un point $`P`$ de l'espace si l'observateur se déplace d'un point $`M`$ à un point $`M'`$ voisin ?

* L'**observateur** fait un *déplacement infinitésimal $`\overrightarrow{dl'}=\overrightarrow{MM'}`$*.

* Lorsque l'observateur est au point $`M`$, tout point $`P`$ est repéré par son vecteur position $`\overrightarrow{MP}`$.

* Lors du déplacement de $`M`$ en $`M'`$, le vecteur position de tout point $`P`$ devient :<br>
$`\overrightarrow{M'P}=\overrightarrow{M'M}+\overrightarrow{MP}
=-\,\overrightarrow{MM'}+\overrightarrow{MP}=-\,\overrightarrow{dl'}+\overrightarrow{MP}`$<br>

* $`\Longrightarrow`$ le **déplacement apparent de tout point $`P`$** est de **$`\mathbf{-\,\overrightarrow{dl'}}`$**.

<!--figure associée--->

##### Quelle est la surface apparente balayée par un élément de longueur $`\overrightarrow{dl}`$ si l'observateur se déplace de $`\overrightarrow{dl'}=\overrightarrow{MM'}`$ ?

* La **surface élémentaire $`d^2S`$ balayée** par l'élément de circuit $`\overrightarrow{dl}`$ est donnée :<br>
\- en valeur absolue par le produit $`dl\cdot dl' \cdot |\,sin \theta\,|`$,<br>
&nbsp;&nbsp;&nbsp;&nbsp;avec $`\theta`$ angle formé par les vecteurs $`\overrightarrow{dl}`$ et $`\overrightarrow{dl'}`$, soit encore :<br>
$`\quad d^2S=|| \overrightarrow{dl}\wedge(-\overrightarrow{dl'})||`$<br>
\- l'orientation de cette surface peut-être donnée par le produit vectoriel :<br>
**$`\mathbf{\quad \overrightarrow{d^2S}}`$**$`\;=\overrightarrow{dl}\wedge(-\overrightarrow{dl'})`$**$`\mathbf{\;=-\overrightarrow{dl}\wedge\overrightarrow{dl'}}`$**

##### Sous quel angle solide la surface balayée par $`\overrightarrow{dl}`$ est-elle observée depuis le point $`M`$ ?

* Cette surface élémentaire  $`d^2S`$ est *observée depuis le point $`M`$* sous l'**angle solide $`d^2\Omega`$** : <br>
$`d^2\Omega=\dfrac{d^2\Sigma}{r^2}=\dfrac{\overrightarrow{d^2S}\cdot\overrightarrow{MP}}{MP^3}`$
$`=\dfrac{\overrightarrow{d^2S}}{MP^2}\cdot\dfrac{\overrightarrow{MP}}{MP}`$
$`= \dfrac{\overrightarrow{d^2S}}{r^2}\cdot (-\overrightarrow{u}) `$
$`= \dfrac{\left(-\overrightarrow{dl}\wedge\overrightarrow{dl'}\right)\cdot (-\overrightarrow{u})}{r^2} `$
$`= \dfrac{\left(\overrightarrow{dl}\wedge\overrightarrow{dl'}\right)\cdot\overrightarrow{u}}{r^2} `$

* Or $`\left(\overrightarrow{dl}\wedge\overrightarrow{dl'}\right)\cdot\overrightarrow{u}`$ est le produit mixte
$`\left(\overrightarrow{dl},\overrightarrow{dl'},\overrightarrow{u}\right)`$, donc :<br>
$`\left(\overrightarrow{dl}\wedge\overrightarrow{dl'}\right)\cdot\overrightarrow{u}`$
$`=\left(\overrightarrow{dl}, \overrightarrow{dl'},\overrightarrow{u}\right)`$ 
$`=-\left(\overrightarrow{dl}, \overrightarrow{u},\overrightarrow{dl'}\right)`$ 
$`=-\left(\overrightarrow{dl}\land\overrightarrow{u}\right)\cdot\overrightarrow{dl'}`$

* L'angle solide $`d^2\Omega`$ se réécrit :<br>
**$`\mathbf{\quad d^2\Omega=-\,\dfrac{\left(\overrightarrow{dl}\wedge\overrightarrow{u}\right)\cdot\overrightarrow{dl'}}{r^2}}`$**

* Selon l'orientation de chaque $`\overrightarrow{dl}`$, l'angle solide correspondant *$`d^2\Omega`$ est positif ou négatif*.

![](ampere_theorem_demonstration_variation_solid_angle_displacement_1_v2_L1200.gif)


##### Sous quel angle solide la surface balayée par un contour $`\mathcal{C_1}`$ est-elle observée depuis le point $`M`$ ?

* Il faut *intégrer* sur tous les $`\overrightarrow{dl}`$ appartenant au contour $`\mathcal{C_1}`$ :<br>
**$`\mathbf{\quad d\Omega}`$**
$`\;=-\;\oint_{\mathcal{C_1}} \quad d^2\Omega`$
**$`\mathbf{\;=-\oint_{\overrightarrow{dl}\,\in\,\mathcal{C}_1} \dfrac{\left(\overrightarrow{dl}\wedge\overrightarrow{u}\right)\cdot\overrightarrow{dl'}}{r^2}}`$**

* Le calcul de l'angle solide $`d\Omega`$ fait apparaître une *contribution positive $` d\Omega^+`$* et une* contribution négative $` d\Omega^-`$*. 

* Un *contour* étant une ligne fermée, pour un déplacement infinitésimal de l'observateur, les contributions *$` d\Omega^+`$ et $` d\Omega^-`$ s'annulent presque*.

* $`\Longrightarrow\quad d\Omega`$ n'est pas l'angle solide $`\Omega_{\mathcal{C_1}}`$ sous lequel l'observateur voit le contour $`\mathcal{C_1}`$ ou toute surface ouverte associée à ce contour. Il est bien plus faible : $`d\Omega<<\Omega_{\mathcal{C_1}}`$

![](ampere_theorem_demonstration_variation_solid_angle_displacement_2_v2_L1200.jpg)


##### Comment s'exprime la variation d'angle solide sous lequel est vu un contour $`\mathcal{C_1}`$ si l'observateur se déplace de $`\overrightarrow{dl'}=\overrightarrow{MM'}`$ ?

* Dans l'hypothèse ou le **contour $`\mathcal{C_1}`$** apparaît **inchangé pour l'observateur** se déplaçant de  (par exemple $`\mathcal{C_1}`$ est une grande structure située à très grande distance de l'observateur), alors les contributions $` d\Omega^+`$ et $` d\Omega^-`$ s'annulent :<br>
$`\Longrightarrow`$**$`\mathbf{\quad d\Omega=0}`$**.

* Ainsi **$`\mathbf{\quad d\Omega\ne 0}`$** correspond à une **variation de perception de $`\mathcal{C_1}`$** lors du déplacement de l'observateur, due à la *parallaxe*.

* La **variation d'angle solide** sous lequel est vu un *contour* (ou *toute surface ouverte associée* à ce contour) est égale à **$`\mathbf{d\Omega}`$**.


##### Que vaut $`\overrightarrow{B}`$ créé en un point $`M`$ par un contour $`\mathcal{C_1}`$ parcouru par un courant constant $`I`$ ?

* L'**orientation de $`\mathcal{C_1}`$** est défini par le sens des *$`\mathbf{\overrightarrow{dl}}`$*.

* Le **sens du courant** est donnée par la *valeur algébrique de *$`\overline{\,I}*`$.

* Le champ magnétique créé en un point $`M`$ par un élément de courant $`\overline{\,I}\;\overrightarrow{dl_P}`$ en un point $`P`$ de l'espace est donné par la loi de Biot et Savart :
$`\overrightarrow{dB_M}_{\leftarrow P}=\dfrac{\mu_0\;\overline{ I}}{4\pi}
\cdot \dfrac{\overrightarrow{dl_M}\land\overrightarrow{PM}}{PM^3}`$

* Le  **champ magnétique $`\overrightarrow{B_M}`$** créé en un point $`M`$ par les éléments de longueur $`dl`$ en tous les points $`P`$ d'un *circuit fermé orienté* $`\mathcal{C_1}`$ parcouru par un *courant $`I`$ constant* s'écrit :<br>
$`\displaystyle\overrightarrow{B_M}=\dfrac{\mu_0\;\overline{ I}}{4\pi}
\cdot\oint_{\overrightarrow{dl}\,\in\,\mathcal{C}_1}  \dfrac{\overrightarrow{dl}\land\overrightarrow{PM}}{PM^3}`$<br>
soit <br>
**$`\displaystyle\mathbf{\overrightarrow{B_M}=\dfrac{\mu_0\;\overline{I}}{4\pi}
\cdot\oint_{\overrightarrow{dl}\,\in\,\mathcal{C}_1}  \dfrac{\overrightarrow{dl}\land\overrightarrow{u}}{r^2}}`$**<br>
avec en chaque point $`P`$ :<br>
$`\quad PM=||\overrightarrow{PM}||=r\quad`$ et $`\quad\overrightarrow{PM}=r\;\overrightarrow{u}`$.

##### Comment s'exprime la circulation du champ magnétique lors du déplacement de $`M`$ en $`M'`$ ?

* Si le point $`M`$ se déplace en $`M' `$, la circulation de $`\overrightarrow{B_M}`$ lors de ce déplacement $`\overrightarrow{dl'}=\overrightarrow{MM'}`$ s'écrit :<br>
$`\overrightarrow{B_M}\cdot\overrightarrow{dl'}=\dfrac{\mu_0\;\overline{I}}{4\pi}
\cdot \oint_{\overrightarrow{dl}\,\in\,\mathcal{C}_1} \dfrac{\left(\overrightarrow{dl}\land\overrightarrow{u}\right)\cdot\overrightarrow{dl'}}{r^2}`$

* $`\left(\overrightarrow{dl}\land\overrightarrow{u}\right)\cdot\overrightarrow{dl'}`$ est le produit mixte
$`\left(\overrightarrow{dl},\overrightarrow{u},\overrightarrow{dl'}\right)`$, et :<br>
$`\left(\overrightarrow{dl}\land\overrightarrow{u}\cdot\overrightarrow{dl'}\right)`$
$`=\left(\overrightarrow{dl}, \overrightarrow{u},\overrightarrow{dl'}\right)`$ 
$`=-\,\left(\overrightarrow{dl}, \overrightarrow{dl'},\overrightarrow{u}\right)`$ 
$`=-\,\left(\overrightarrow{dl}\land\overrightarrow{dl'}\right)\cdot\overrightarrow{u}`$

* $`\displaystyle\Longrightarrow\quad 
\overrightarrow{B_M}\cdot\overrightarrow{dl'}=-\,\dfrac{\mu_0\;\overline{\,I}}{4\pi}
\cdot \oint_{\overrightarrow{dl}\,\in\,\mathcal{C}_1} \dfrac{\left(\overrightarrow{dl}\land\overrightarrow{dl'}\right)\cdot\overrightarrow{u}}{r^2}`$

* $`\Longrightarrow\quad`$
**$`\mathbf{\overrightarrow{B_M}\cdot\overrightarrow{dl'}=\dfrac{\mu_0\;\overline{\,I}}{4\pi}\cdot d\Omega}`$**

##### Que vaut la circulation du champ magnétique créé par le contour $`\mathcal{C_1}`$ sur un contour $`\mathcal{C}_2`$?

* Le déplacement élémentaire précédent $`\overrightarrow{dl'}=\overrightarrow{MM'}`$ appartient à un contour $`\mathcal{C}_2`$.

* Le sens du vecteur déplacement élémentaire $`\overrightarrow{dl'}`$ définit le sens positif de circulation de $`\mathcal{C}_2`$.

* La circulation du champ magnétique $`\overrightarrow{B}`$ créé par le contour $`\mathcal{C_1}`$ sur le contour $`\mathcal{C}_2`$ s'obtient en intégrant l'expression précédente sur tous les $`\overrightarrow{dl'}`$ constituant $`\mathcal{C}_2`$ :<br>
<br>**$`\displaystyle\mathbf{\oint_{\overrightarrow{dl'}\,\in\,\mathcal{C}_2} \overrightarrow{B}\cdot\overrightarrow{dl'}=\dfrac{\mu_0\;\overline{\,I}}{4\pi}\cdot \oint_{\mathcal{C}_2} d\Omega}`$**<br>
<br>où $`\oint_{\mathcal{C}_2} d\Omega`$ est la variation de l'angle solide sous lequel est vu le contour $`\mathcal{C_2}`$ lorsqu'un tout complet est effectué sur le contour $`\mathcal{C_1}`$.

---

* Si les **contours** $`\mathcal{C_1}`$  et $`\mathcal{C_2}`$ sont **enlacés** :<br>
$`\Longrightarrow\quad\oint_{\mathcal{C}_2} d\Omega=\pm\,4\pi`$<br>
**$`\displaystyle\Longrightarrow\quad\mathbf{\oint_{\overrightarrow{dl'}\,\in\,\mathcal{C}_2} \overrightarrow{B}\cdot\overrightarrow{dl'}=\pm\,\mu_0\;\overline{\,I}}`$**.

<!--===============à terminer================
(revoir... à quel moment l'indétermination sur le signe est-elle levée, et comment l'expliquer si besoin?)
=============================================-->

---

* Si les **contours** $`\mathcal{C_1}`$  et $`\mathcal{C_2}`$  sont **disjoints** :<br>
$`\Longrightarrow\quad\oint_{\mathcal{C}_2} d\Omega=0`$<br>
**$`\displaystyle\Longrightarrow\quad\mathbf{
\oint_{\overrightarrow{dl'}\,\in\,\mathcal{C}_2} \overrightarrow{B}\cdot\overrightarrow{dl'}=0}`$**.

---



#### Que dit le théorème d'Ampère intégral ?
<!-- l'équivalent partie "main" sera ""Théorème d'Ampère (intégral)"-->

* Soit une **distribution quelconque de courant** dans l'espace, qui créé *un champ 
magnétique* $`\overrightarrow{B}`$ en tout point de l'espace,<br><br>
et soit un **ligne fermée C quelconque** dans un plan de l'espace.

![](Ampere-theorem-1-L1200.jpg)

* Soit une **surface ouverte S quelconque qui s'appuie sur le contour C**.

![](Ampere-theorem-2-L1200.jpg)

* Choisis une **orientation quelconque du contour C**, et **oriente en conséquence
chaque surface élémentaire dS** constituant la surface S selon la **règle d'orientation 
de l'espace dite "de la main droite"**.

![](Ampere-theorem-3-L1200.jpg)

Partant de la loi de Biot et Savart, le théorème d'Ampère montre que :

* La **circulation du champ d'induction magnétique $`B`$ le long du contour C**
est égale à la *somme algébrique des courants électriques traversant la surface S*, <br><br>
**$`\oint_C \overrightarrow{B} \cdot \overrightarrow{dl} = \mu_0 \cdot \sum_n \overline{I_n}`$** <br>  
ou, ce qui revient au même, au *flux du vecteur densité volumique de courant à travers la surface S*<br><br>
**$`\oint_C \overrightarrow{B} \cdot \overrightarrow{dl} = \mu_0 \cdot \iint_S \overrightarrow{j} \cdot \overrightarrow{dS}`$** 

<!--![](Ampere-theorem-4-L1200.jpg)-->

----------

![](Ampere-theorem-4-portrait-L620.jpg)

----------
#### Quelle est l'utilité du théorème d'Ampère intégral ?

* Le théorème d'Ampère donne un **résultat très général**, qui relie la circulation de
vecteur champ d'induction magnétique le long d'un contour fermé aux courants qui traversent
toute surface ouverte s'appuyant sur le contour.

* Il permet un **calcul très simple** de cette circulation, là où un calcul direct 
serait extrêmement compliqué.

* Le calcul de la circulation de $`\overrightarrow{B}`$ n'a 
**pas d'application utile dans le cas général**.

* Cependant, le théorème d'Ampère **permet un calcul très simple le champ magnétique**
créé par une *distribution de courant présentant de hautes symétries et invariances*.<br>

* Enfin et surtout, **généralisé par le théorème de Maxwell-Ampère** dans le cadre de 
l'électromagnétisme qui s'applique aux courants variables, il est 
l'**une des 4 équations de Maxwell** qui sont à la 
**base de l'unification des phénomènes électriques, magnétiques, et de l'optique** 
étendue à tout le spectre des ondes électromagnétiques. L'électromagnétisme de Maxwell
*contient les germes de la relativité restreinte* développée par Albert Einstein (1905)
qui offre une vision radicalement nouvelle et non intuitive de l'"espace-temps" et
de la "matière énergie", vision qui sera encore profondément modifiée avec la relativité 
générale (Einstein, 1915) qui couple les propriétés géométriques de l'espace-temps à son contenu 
en matière-énergie : "espace-temps-matière-énergie".

#### Comment dois-tu l'utiliser ?

* Ce point est développé dans le **chapitre "Application du théorème d'Ampère"**.

* Appliquer le thèorèmes d'Ampère et de Gauss *nécessite la* **maitrîse
des propriétés d'invariances et de symétries** des distributions de charges (Gauss)
et courants (Ampère), et des **propriétés de symétrie des vecteurs vrais** (ou polaires)
et **des pseudo-vecteurs** (ou vecteurs axiaux). 

* Ces propriétés sont *abordé dans le* **chapitre "Invariances et symétries"**.

#### Pourquoi le théorème d'Ampère intégral est-il insuffisant ?

![](ampere-integral-insuffisant-L1200.gif)<br>
_Champ magnétique créé par 3 courants électriques rectilignes, infinis et stationnaires,
se propageant dans une direction perpendiculaire au plan de représentation du champ
magnétique._

* Dans les *cas simples*, **l'oeil humain repère immédiatement** les points centre de rotation
des lignes de champ magnétique, qui localisent *les causes
du champ magnétique* dans le plan d'observation. 

* Le **théorème d'Ampère intégral** précise, lors d'une circulation non nulle du champ magnétique
le long d'un chemin fermé, la somme totale des courants à l'origine de cette circulation, 
mais *ne permet pas la localisation précise des sources* du champ magnétique.

* Il **doit exister une propriété locale** (à l'échelle mésoscopique, donc apparaissant ponctuelle
 à la résolution de l'observation) qui en tout point de l'espace *relie le champ magnétique
à sa cause élémentaire locale*.

#### Une idée pour relier une propriété locale du champ magnétique locale à sa cause ?

* Dans la **démonstration du théorème dAmpère** (partie principale), *aucune échelle de taille n'est précisée* 
pour les choix du contour d'Ampère et d'une surface s'appuyant sur ce contour.

* $`\Longrightarrow`$ idée 1 : faire tendre le contour d'Ampère vers un 
**contour mésoscopique plan autour de chaque point** de résolution de l'espace, 
 la *circulation* ainsi calculée sera une *propriété locale du champ*.

* $`\Longrightarrow`$ idée 2 : choisir pour *surface associée* la 
**portion de plan mésoscopique délimité par le contour précédent**,  le *flux du courant* 
à travers cette surface mésoscopique déduit du théorème d'Ampère 
sera ainsi un *courant local*.

* Cette idée est à la **base de la notion de champ rotationnel** d'un champ vectoriel.

#### Qu'est-ce que le champ rotationnel de B ?

Le champ rotationnel de B est un **champ vectoriel**.

En *tout point M de l'espace*, le vecteur **$`\overrightarrow{rot}\;\overrightarrow{B_M}`$ indique** :

* en mots :<br>
\- le **plan local** dans lequel s'effectue la **rotation de $`\overrightarrow{B_M}`$** par sa *direction*.<br>
$`\Longrightarrow`$ la *direction de $`\overrightarrow{j}`$*, vecteur densité volumique de courant.<br><br>
\- le **sens de la rotation** de $`\overrightarrow{B_M}`$ par le *sens de $`\overrightarrow{rot}\;\overrightarrow{B_M}`$
et la *règle d'orientation* de l'espace.<br>
$`\Longrightarrow`$ le *sens de $`\overrightarrow{j}`$*, vecteur densité volumique de courant.<br><br>
\- l'**intensité du champ magnétique créé** par *norme de $`\overrightarrow{rot}\;\overrightarrow{B_M}`$*<br>
$`\Longrightarrow`$ la *norme de $`\overrightarrow{j}`$*, vecteur densité volumique de courant.

* mathématiquement et plus précis : **$`\overrightarrow{rot}\;\overrightarrow{B}=\mu_0 \cdot \overrightarrow{j}`$**
 

#### Comment se détermine son expression en coordonnées cartésiennes ?


![](Rotationnel-B-cartesian-web-L1200-ok.jpg)

![](Rotationnel-B-cartesian-2-web-L1200-ok.jpg)

![](Rotationnel-B-cartesian-3-web-L1200-ok.jpg)


#### Comment visualiser et mémoriser le théorème de Stokes ?
<!-- l'équivalent partie "main" sera ""Le théorème de Stokes"-->
*Guide de démonstration et Aide à la mémorisation*


* Soit un **champ vectoriel $`\overrightarrow{X}(\overrightarrow{r})`$**, et un
**contour fermé C** dans l'espace.<br>
$`\Longrightarrow \overrightarrow{X}`$ est défini en chaque point de C.

![](Th-Stokes-1-L1200.jpg)

* Soit le **choix d'un sens de parcours positif** sur le contour C, qui oriente 
les déplacements élémentaires $`\overrightarrow{X}`$ de ce contour.<br>
$`\Longrightarrow`$ la circulation $`\mathcal{C}`$ de $`\overrightarrow{X}`$ le long de C peut
être calculée.

![](Th-Stokes-2-L1200.jpg)

* Soit une **surface quelconque ouverte S s'appuyant sur C**.

![](Th-Stokes-3-L1200.jpg)

<!-- cette figure ci-dessous n'est peut-être pas nécessaire. On verra s'il y a des questions étudiantes.
* Sur chaque branche de l'ensemble des surfaces élémentaires constituant le surface S, 
la circulation de \overrightarrow{X}`$ est défini
![](Th-Stokes-4-L1200.jpg) -->

* Le **sens positif d'orientation sur C** *impose le sens positif d'orientation
des contours élémentaires* fermés qui délimitent les surfaces élémentaires de S.

![](Th-Stokes-5-L1200.jpg)

* La **règle d'orientation de lespace de la main droite** permet alors l'*orientation
de chacune des surfaces élémentaires* de S.

À terminer 

![](Th-Stokes-6-L1200.jpg)

![](Th-Stokes-7-L1200.jpg)

![](Th-Stokes-8-L1200.jpg)

![](Th-Stokes-9-L1200.jpg)

![](Th-Stokes-10-L1200.jpg)



<!--

![](Th-Stokes-gif-1-L600.gif)

![](Th-Stokes-gif-2-L600.gif)

![](Th-Stokes-gif-3-L600.gif)

![](Th-Stokes-gif-4-L600.gif)

![](Th-Stokes-gif-5-L600.gif)

![](Th-Stokes-gif-6-L600.gif)

![](Th-Stokes-gif-7-L600.gif)

![](Th-Stokes-gif-8-L600.gif)

![](Th-Stokes-gif-9-L600.gif)

![](Th-Stokes-gif-10-L600.gif)

-->


#### Que dit le théorème d'Ampère local ?
<!-- l'équivalent partie "main" sera ""Théorème d'Ampère (intégral)"-->


