---
title: "Combinaciones de operadores"
published: true
routable: true
visible: false
lessons:
    - slug: combinaison-operators-for-electromagnetism
      name: TOOL-MATH : Combinación de operadores para electromagnetismo
      order: 1
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$

*Curso en construcción*, **no validado**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-ES_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-3_L1200.jpg)<details>
<summary>Etapa 3 : escribiendo : 1/3</summary>  
1. Lluvia de ideas
2. Estructuración
3. Escribiendo : 1/3
4. Escribiendo : 2/3
5. Escribiendo : 3/3
6. Revisión 
7. Probado con estudiantes.
8. Validado, aún incompleto
9. Validado, con base suficiente
10. Validado, operativo, en constante mejora.
</details>

<!--MétaDonnée : ... -->

##### Caminata Montaña :&nbsp;física, matemáticas aplicadas

---------------------------

### Identité et combinaisons d'opérateurs

<br>

RÉSUMÉ IDENTITÉ 
: ---

   Deux champs vectoriels quelconques $`\overrightarrow{U}`$ et $`\overrightarrow{V}`$ vérifient
   l'identité mathématique :     
   * $`\mathbf{div\,\big(\overrightarrow{U}\land\overrightarrow{V}\big)=\overrightarrow{U}\cdot\big(\overrightarrow{rot}\,\overrightarrow{V}\big)\,-\,\overrightarrow{V}\cdot\big(\overrightarrow{rot}\,\overrightarrow{U}\big)}`$


RÉSUMÉ COMBINAISONS
: ---

    Soient $`\overrightarrow{U}`$ un champ vectoriel et $`\phi`$ un champ scalaire quelconques :

   * $`\mathbf{\overrightarrow{rot}\big(\,\overrightarrow{grad}\,\phi\big)=\overrightarrow{0}}`$   
     
     * Est utilisée pour montrer qu'un champ vectoriel dérive d'un champ scalaire :   
     $`\overrightarrow{rot}\,\overrightarrow{U}=\overrightarrow{0}\quad\Longleftrightarrow\quad\exists\phi\,,\, \overrightarrow{U}=\overrightarrow{grad}\,\phi`$
     * En physique, un champ d'interaction $`\overrightarrow{U}`$ dérive d'un potentiel scalaire $`\phi`$
       $`\Longleftrightarrow\quad\exists\phi\,,\, \overrightarrow{U}=- \overrightarrow{grad}\,\phi`$,    
       le signe $`-`$ permettant de définir une énergie mécanique qui se conserve.

   * $`\mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{U}\big)=0}`$   
     * Est utilisée pour montrer qu'un champ vectoriel dérive d'un champ vectoriel :   
     $`div\,\overrightarrow{U}=0\quad\Longleftrightarrow\quad\exists\phi\,,\, \overrightarrow{U}=\overrightarrow{rot}\,\overrightarrow{V}`$
     * En physique, si $`\overrightarrow{U}`$ est un champ d'interaction, $`\overrightarrow{V}`$ est son potentiel vecteur.

   ---

   *Laplacien $`\Delta\,\phi`$ d'un champ scalaire $`\phi`$*

   * Définition de l'opérateur laplacien scalaire :  
     $`\mathbf{\Delta=div\big(\overrightarrow{grad}\big)}`$ 
 
   * Utilité en physique :   
     * équation d'onde (ou équation de d'Alembert) :   
       $`\Delta\,\phi-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \phi}{\partial t^2}=0`$
     * équation de Poisson :   
       $`\Delta\,\phi-f=0\quad`$, avec $`f`$ champ scalaire.
     * équation de Laplace :   
       $`\Delta\,\phi=0`$

   * Expression de $`\Delta\,\phi`$ en coordonnées cartésiennes :   
     $`\Delta\,\phi=\dfrac{\partial^2 \phi}{\partial x^2}+\dfrac{\partial^2 \phi}{\partial y^2}+\dfrac{\partial^2 \phi}{\partial z^2}`$    
     et expression avec l'opérateur nabla $`\nabla`$ :   
     $`\Delta\,\phi=\overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,\phi`$
  
   * <details markdown=1>
      <summary>Expressions en coordonnées cylindriques et sphériques</summary>
      * coordonnées cylindriques $`(\rho\,,\,\varphi\,,\,z)`$ :   
        <br>
       $`\Delta\,\phi=\dfrac{1}{\rho}\cdot\dfrac{\partial}{\partial \rho}\left(\rho\,\dfrac{\partial \phi}{\partial \rho}\right)`$
        $`\;+\;\dfrac{1}{\rho^2}\cdot\dfrac{\partial^2 \phi}{\partial \varphi^2}`$
        $`\;+\;\dfrac{\partial^2 \phi}{\partial z^2}`$   
       <br>
      * coordonnées sphérique $`(r\,,\,\theta\,,\,\varphi)`$ :   
        <br>
       $`\Delta\,\phi=\dfrac{1}{r}\cdot\dfrac{\partial^2}{\partial r^2}(r\phi)`$
       $`\;+\;\dfrac{1}{r^2\,\sin\theta}\cdot\dfrac{\partial}{\partial \theta}\left(\sin\theta\dfrac{\partial \phi}{\partial \theta}\right)`$
       $`\;+\;\dfrac{1}{r^2\,\sin^2\theta}\cdot\dfrac{\partial^2 \phi}{\partial \varphi^2}`$


   ---
   
   *Laplacien $`\Delta\,\overrightarrow{U}`$ d'un champ vectoriel $`\overrightarrow{U}`$*
   
   * Définition opérateur laplacien vectoriel :    
   $`\mathbf{\Delta=\overrightarrow{grad}\big(div\big)
   -\overrightarrow{rot}\big(\overrightarrow{rot}\big)}`$

   * Utilisé en physique dans l'équation d'onde vectorielle :   
     $`\Delta\,\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial \overrightarrow{U}}{\partial t^2}=0`$

   * Expression de $`\Delta\,\overrightarrow{U}`$ en coordonnées cartésiennes de base unitaire $`(\vec{e_x}\,,\,\vec{e_y}\,,\,\vec{e_z})`$ :   
     $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
     \dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_x}{\partial y^2}+\dfrac{\partial^2 U_x}{\partial z^2}\\
     \dfrac{\partial^2 U_y}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_y}{\partial z^2}\\
     \dfrac{\partial^2 U_z}{\partial x^2}+\dfrac{\partial^2 U_z}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial z^2}
     \end{array}\right)`$   
     <br>
     et expression avec l'opérateur nabla $`\nabla`$ :   
     $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
     \Delta\,U_x\\
     \Delta\,U_y\\
     \Delta\,U_z\\
     \end{array}\right)`$
     $`\;=\left(\begin{array}{l}
     \overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,U_x\\
     \overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,U_y\\
     \overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,U_z\\
     \end{array}\right)`$

   * <details markdown=1>
      <summary>Expressions en coordonnées cylindriques et sphériques</summary>
      * dans la base cylindrique unitaire $`(\vec{e_{\rho}}\,,\,\vec{e_{\phi}}\,,\,\vec{e_z})`$ :   
        <br>
       $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
         \Delta_{cyl}U_{\rho}\\
         \Delta_{cyl}U_{\phi}\\
         \Delta_{cyl}U_z
     \end{array}\right)`$   
     <br>
     où $`\Delta_{cyl}`$ est l'expression du laplacien scalaire en coordonnées cylindriques.
      * dans la base sphérique unitaire $`(\vec{e_r}\,,\,\vec{e_{\theta}}\,,\,\vec{e_{\phi}})`$ :   
        <br>
       $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
         \Delta_{sph}U_r\\
         \Delta_{sph}U_{\theta}\\
         \Delta_{sph}U_{\phi}
     \end{array}\right)`$   
     <br>
     où $`\Delta_{sph}`$ est l'expression du laplacien scalaire en coordonnées sphériques.
      </details>

<br>


#### Pourquoi combiner des opérateurs ?

* Les opérateurs **$`\mathbf{\overrightarrow{grad},\,div}`$ et $`\mathbf{\overrightarrow{rot}}`$** caractérisent en tout 
point de l'espace des *propriétés importantes des champs* sur lesquels ils s'appliquent. 
Ils ont une existence en soi, plus fondamentale que leurs expressions dans 
les différents systèmes de coordonnées.   
<br>
Ce sont des **opérateurs différentiels d'ordre un** : leurs expressions dans les différents systèmes 
de coordonnées n'utilisent que des *dérivées partielles spatiales du premier ordre*.

!!! *Exemples* :   
!!! * en électrostatique $`\overrightarrow{E}=-\overrightarrow{grad}\,V`$ qu'il existe une famille 
!!! de champs scalaires $`V`$ dont le champ électrostatique $`\overrightarrow{E}`$ peut dériver.
!!! * en électrostatique $`div\,\overrightarrow{E}=\dens_{charge}^{\;3D}\,/\,\epsilon_0`$ indique que
!!! le champ électrostatique $`\overrightarrow{E}`$ converge ou diverge sur la charge électrique qui le cause.
!!! La charge peut ainsi apparaître comme une simple propriété d'un champ électrostatique.
!!! * en magnétostatique, $`\overrightarrow{rot}\,\overrightarrow{H}=\overrightarrow{j}^{3D}`$ indique
!!! que les lignes de champ d'excitation magnétique $`,\overrightarrow{H}`$ s'enroule autour de l'élément de courant 
!!! $`\overrightarrow{j}^{3D}`$ qui le créé dans le plan perpendiculaire à $`\overrightarrow{j}^{3D}`$.
!!! l'élément de courant peut ainsi apparaître comme une simple propriété d'un champ magnétostatique.


* Cependant les **lois physiques** se traduisent souvent par des **équations différentielles d'ordre deux** : 
leurs expressions dans les différents systèmes  de coordonnées n'utilisent que des 
*dérivées partielles spatiales du second ordre*.

!!! *Exemples* :  en coordonnées cartésiennes $`(x,y,z)`$,
!!! * la propagation d'une onde plane progressive monochromatique $`\Phi`$ dans un milieu homogène et isotrope se propageant vers les x positifs
!!! selon la loi 
!!! $`\dfrac{\partial^2 \Phi(x,t)}{\partial x^2}-\dfrac{1}{\mathscr{v}^2}\,-\dfrac{1}{\mathscr{v}^2}\,\dfrac{\partial^2 \Phi(x,t)}{\partial t^2}`$.
!!! * L'équation de diffusion d'une grandeur physique de densité $`\Phi(x,y,z,t)`$ s'écrit
!!! $`\displaystyle\dfrac{\partial \Phi(\vec{r},t)}{\partial t}=\sum_{x_i=1}^3\sum_{x_j=1}^3\dfrac{\partial}{\partial x_i}\Bigg[\mathscr{D}(\Phi,\vec{r})\,\dfrac{\partial \Phi(\vec{r},t)}{\partial x_j}\Bigg]`$

* Ainsi les **expressions vectorielles des lois physiques**, utiles car indépendantes des systèmes de coordonnées, 
nécessitent des *combinaisons de deux opérateurs du premier ordre* pour obtenir un opérateur du second ordre.
<br>

#### Quelles sont les combinaisons possibles ?

* Les opérateurs différentiels de premier ordre principalement utilisés en physique sont au nombre de 3.

* Le nombre de séquences ordonnées 2 éléments, avec répétition possible d'un même élément, parmi 3 éléments est 9. 

! *Note* :   
!  En mathématique combinatoire et dénombrement :   
! * une séquence de deux éléments $`a`$ et $`b`$ est ordonnée si l'ordre à un sens, donc si
! $`(a,b)\ne(b,a)`$. Une séquence ordonnée s'appelle une suite.
! * Une suite de 2 éléments parmi 3 s'appelle un arrangement.
! * Lorsque la répétition $`(a,a)`$ d'un élément $`a`$ est permise, l'arrangement est dit avec répétition.
! * Le nombre d'arrangements avec répétition de p éléments d'un emsemble de n éléments s'écrit et se calcule :   
! $`A_n^p=n^p`$.
! Le nombre d'arrangements avec répétition de 2 éléments parmi 3 égale 
! $`A_3^2=3^2=9`$.

* Cependant, les opérateurs **$`\mathbf{\overrightarrow{grad},\,div,\,\overrightarrow{rot}}`$** 
 ne sont *pas du même type*.
   * $`\overrightarrow{grad}`$ s'applique à un champ scalaire et donne un champ vectoriel.
   * $`div`$ s'applique à un champ vectoriel et donne un champ scalaire.
   * $`\overrightarrow{rot}`$ s'applique à un champ vectoriel et donne un champ vectoriel.   
   * 
* Ainsi seuls cinq des neufs arrangements d'écriture possible *ont un sens*.     
  Ils conduisent aux **cinq opérateurs différentiels du second ordre** suivants :

*$`\quad\large{\require{cancel}\xcancel{\overrightarrow{grad}\,\big(\overrightarrow{grad})}}\quad ,`$*
**$`\quad\large{\overrightarrow{grad}\,\big(div)}`$**
*$`,\quad\large{\require{cancel}\xcancel{\overrightarrow{grad}\,\big(\overrightarrow{rot})}}`$*
**$`,\quad\large{div\,\big(\overrightarrow{grad})}`$**
*$`,\quad\large{\require{cancel}\xcancel{div\,\big(div)}}`$*
**$`,\quad\large{div\,\big(\overrightarrow{rot})}`$**
**$`,\quad\large{\overrightarrow{rot}\,\big(\overrightarrow{grad})}`$**
*$`,\quad\large{\require{cancel}\xcancel{\overrightarrow{rot}\,\big(div)}}`$*
**$`,\quad\large{\overrightarrow{rot}\,\big(\overrightarrow{rot})}`$**
   
* Toute **combinaison linéaire** *de ces cinq opérateurs* différentiels de second ordre est elle-même
un opérateur différentiel de second ordre.   
<br>
Une combinaison linéaire s'avère particulièrement **utile en physique** est    
<br>
**$`\large{div\,\big(\overrightarrow{grad})-\overrightarrow{rot}\,\big(\overrightarrow{rot})}`$** *$`\large{\;=\Delta}\;`$*,   
<br>
qui définit l'opérateur *Laplacien vectoriel $`\Delta`$*. Celui-ci intervient dans tout phénomène de propagation de champs vectoriels.

