---
title: 'Framework of special relativity'
published: true
routable: true
visible: false
lessons:
    -
      slug: michelson-morley-from-classical-to-relativistic-universe
      name: THEORIE-EXP : Michelson-Morley
      order: 3
    -
      slug: from-classical-to-relativistic-universe-through-euclidian-space-time
      name: CONCEPT : Espace-temps euclidien, étape conceptuel entre univers classique et relativiste.
      order: 3
---


<!---------------------------
lessons:
    - slug: stationary-electric-field
      order: 2
----------------------------->

$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-2_L1200.jpg)<details>
<summary>Etape 2 : Structuration</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Colline

---------------------------

*Cadre de la Relativité Restreinte :*

##### Un ESPACE-TEMPS Minkovskien, de la MATIÈRE-ÉNERGIE

<br>

RÉSUMÉ
:
*Corps* :   
\- tout être ou objet matériel  
*Observateur* :   
\- Corps percevant l'espace et le temps, et d'autres corps dans l'espace et le temps.   
\- Il peut mesurer des durées $`\Delta t`$ et des longueurs $`\Delta l`$ à l'aide d'une 
horloge et d'une règle, immobiles par rapport à lui le temps de la mesure.    
\- Il repère la position de corps dans l'espace-temps en choisissant une origine 
de l'espace-temps et des coordonnées $`(x,y,z,t)`$.   
*Autres corps dans l'espace-temps* :   
\- immobiles ou en mouvements par rapport à un observateur.  
\- et repérés par leurs coordonnées spatio-temporelles $`(x,y,z,t)`$.   
*Évènement* :   
\- position dans l'espace-temps d'un corps, d'une interaction ou d'une
coïncidence entre deux ou plusieurs corps.   
*Espace-temps minkovskien* :   
$`\Longleftrightarrow`$ il existe des systèmes de coordonnées rectilignes spatio-temporels 
$`(O,x,y,z,t)`$ appelées minkovskiennes, tels que, pour tout couple d'évènements $`A`$ 
et $`B`$, le résultat de la mesure 
$`s_{AB}=\sqrt{c^2\Delta t_{AB}^2-\Delta x_{AB}^2-\Delta y_{AB}^2-\Delta z_{AB}^2}`$    
\- avec c une 
constante fondamentale de l'espace-temps ayant la dimension d'une vitesse, est le 
même pour tout observateur.   
\- écriture $`\Delta u_{AB}^{\;2}=(u_B-u_A)^2`$, avec $`u`$ une coordonnée.   
*Perception de l'espace et du temps par un observateur*.  
\- l'observateur vit l'instant présent d'un temps fléché du passé vers le futur.   
\-  à chaque instant $`t`$, l'observateur perçoit un espace euclidien :    
il existe des systèmes de coordonnées spatiales $`(O,x,y,z)`$ appelées cartésiennes
tels que, pour tout couple de points $`C`$ et $`D`$, le résultat de la mesure   
$`\Delta l_{CD}=\sqrt{\Delta x_{CD}^2+\Delta y_{CD}^2+\Delta z_{CD}^2}`$   
est le même pour tout autre 
observateur immobile par rapport au premier et au même instant.   
*Ligne d'univers d'un corps* :   
\- ensemble des positions $`(x,y,z,t)`$ de l'espace-temps occupées par le corps.   
\- équation de la ligne d'univers : fonction $`f(x,y,z,t)`$ des coordonnées spatio-temporelles
d'une ligne d'univers telle que $`f(x,y,z,t)=0`$.   
*Observateur galiléen* :   
$`\Longleftrightarrow`$ un corps soumis à aucune interaction est observé immobile 
  ou se déplaçant selon une ligne d'univers rectiligne.   
*D'observateur galiléen à observateur galiléen*,   
en translation rectiligne l'un par rapport à l'autre à la vitesse constante $`V`$ 
selon une direction $`\Delta`$ :   
\- facteur de Lorentz : $`\Gamma = \dfrac{1}{\sqrt{1-V^2/c^2}}`$.   
Chaque observateur observe pour les corps en mouvement une même :   
\- contraction des longueurs dans la direction $`\Delta`$ 
d'un rapport $`\Gamma`$.   
\- conservation des longueurs dans la direction perpendiculaire à $`\Delta`$   
\- dilatation des durées, d'un rapport $`\Gamma`$.   
*Caractère absolu ou relatif d'une grandeur* :   
\- relatif : dont la valeur mesurée dépend de l'observateur.   
\- absolu : dont la valeur mesurée est la même pour tous les observateurs.   
*Caractère des grandeurs usuelles*.  
\- relativité des longueurs $`\Delta l`$    
\- relativité des durées $`\Delta t`$.  
$`\Longrightarrow`$ relativité des angles $`\varphi = \text{arctg}(\Delta l_{opposé} / \Delta l_{adjacent})`$.  
$`\Longrightarrow`$ relativité des vitesses linéaires $`\mathscr{v} = \Delta l / \Delta t`$.    
$`\Longrightarrow`$ relativité des accélérations linéaires $`a = \Delta\mathscr{v} / \Delta t`$.  
$`\Longrightarrow`$ relativité des vitesses angulaires $`\omega = \Delta \varphi / \Delta t'`$.  
$`\Longrightarrow`$ relativité des accélérations angulaires $`\dpt{\omega} = \Delta \omega / \Delta t'`$.  



# <p style="font-size:60%;text-align: center;">L' ESPACE-TEMPS MINKOWSKIEN<br><br>de la relativité restreinte</p>

## <p style="font-size:70%;text-align: center;">D'un espace-temps euclidien fictif<br>à la Relativité Restreinte</p>


#### L'espace-temps de la relativité restreinte.

<br>

![](https://m3p2.com/fr/temporary_ins/relativity/n2/an-euclidian-space-time/overview/espace-temps-euclidien-1_v2_L1200.gif)
_Représentation symbolique : des corps immobiles et en mouvements ont chacun leur propre perception de l'espace et du temps_
_ d'un espaxe-temps minkowskien._

##### Comme dans le cas d'un espace-temps euclidien fictif :

* Le **temps et** l'**espace** ne sont *ni universels, ni indépendants*.

* Des **corps** (êtres vivants observateurs, objets, tout corps matériel) sont **immobiles ou en mouvement** 
  les uns par rapport à d'autres *dans un espace-temps*.  

* *tout observateur* ou corps matériel *vit l'instant présent* d'**un espace-temps** tel que :
   * Le **temps** est *fléché du passé vers le futur*,
   * L'**espace** est *euclidien*   

##### Différemment d'un espace-temps euclidien fictif :

* **L'espace-temps de la relativité restreinte** n'est pas euclidien,
  mais il *est minkowskien*.

<br>


## <p style="font-size:70%;text-align: center;">L'espace-temps minkowskien</p>

A faire


#### Un nombre purement imaginaire, i

* Il est possible de retrouver les effets de la rel ... à terminer

* Invite un **nombre purement imaginaire**, note-le **$`\Large{i}`$**
  qui vérifierait l'égalité :   
  <br>
  **$`\Large{\mathbf{i^2}}`$** *$`\Large{\mathbf{\;=-1}}`$*   
  <br>
  C'est un nombre impossible car tu sais que le carré $`a^2`$ de tout nombre réel $`a`$ donne un nombre réel positif :   
  <br>
  $`\forall a \in \mathbb{R}\,,\, a^2 = a \times a \ge 0`$    
  <br>
  mais pose son existence.

!!!!! *Ecriture mathématique*  
!!!!!
!!!!! L'écriture mathématique $`\forall a \in \mathbb{R}\,,\, a^2 = a \times a \ge 0`$ utilise des
!!!!! symboles mathématiques suivants, qui signifient :   
!!!!! * $`\forall`$ : "pour tout"
!!!!! * $`\in`$ : "appartenant à"
!!!!! * $`\mathbb{R}`$ : "ensemble des nombres réels"   
!!!!
!!!!! Elle se lit donc :<br>   
!!!!! "Pour tout nombre rél $`a`$, le carré du nombre $`a`$ est un nombre réel supérieur ou
!!!!! égal à zéro."

!! *Pour aller plus loin : le nombre imaginaire $`i`$*
!! * Cette invention du nombre $`i`$ donnera naissance à une *nouvelle classe* de nombres, 
!! *les nombres imaginaires* dont l'ensemble sera noté *$`\mathbb{I}`$*.
!! Les nombres imaginaires s'écrivent de la forme $`a\,i= a \times i`$, où $`a`$ est un nombre réel.
!!
!! * *Ils interviendront dans une *autre classe* de nombre, *les nombres complexes*
!!  dont l'ensemble sera noté *$`\mathbb{C}`$*.
!! Les nombres complexes $`c`$ seront composés d'une partie réelle est d'une partie imaginaire, d'écriture générale
!! $`c = a + i\,b`$ où $`a`$ et $`b`$ sont deux nombres réels : $`(a,b)\in\mathbb{R}^2`$.
!!
!! * Les *nombres imaginaires et complexes* t'apparaîtront comme de *simples artifices de calcul*
!! qui permettront de simplifier parfois considérablement des calculs.
!!
!! * En *mécanique quantique*, ils acquièreront un *rôle beaucoup plus fondamental*, indispensable
!! à la description mathématique de la réalité du monde quantique.



<br>

## <p style="font-size:70%;text-align: center;">Corps matériels et observateurs inertiels</p>

A faire

<br>

## <p style="font-size:70%;text-align: center;">Contraction des longueurs, dilatation du temps, relativité de la simultanéïté</p>

A faire

![](minkowskien-space-time-time-dilatation-3_L1200.jpg)

<br>

## <p style="font-size:70%;text-align: center;">Des paradoxes apparents qui n'en sont pas</p>

A faire

<br>

## <p style="font-size:70%;text-align: center;">Cônes de lumière</p>

A faire

<br>



<!---

## <p style="font-size:70%;text-align: center;">La révolution conceptuelle<br>de la relativité restriente</p>

Partie synthèse sous forme de questions avec figures et animations

----->
   

