---
title: Géométrie et coordonnées - proposition 2
published: true
routable: true
visible: false
---


! *Du globe terretre à une carte du monde*
!
<!--
Là, à faire. Mais pour dire (sans le dire à ce niveau 1) qu'aucune projection de
la surface d'une sphère sur un plan ne peut conserver les angles et les distances...

Pour tester la visibilité des figures avant finition :

Idée de question :"Pourquoi faire une carte de la Terre?"   
Réponse possible : "Pour envelopper d'un seul regard la totalité de la surface terrestre."  
-->

<br><br>

https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/

![titre, projections et cartes](titre-bleu-projections-cartes_L1200.jpg)   

#### Pourquoi faire une carte de la Terre ?

* Pour **envelopper d'un seul regard la surface terrestre** en totalité.

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/earth-map-earth-globe-geometry-1_L1200.gif)

Et *peut-être aussi* pour :

* **comparer les tailles des continents**.
 
* **trouver le chemin le plus court** entre villes éloignées.


#### Comment réaliser une carte de la Terre?"  

Une **première idée** :

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/earth-map-earth-globe-geometry-2_L1000.gif)

* *En tout lieu sur Terre*, le **méridien** (nord-sud) et le **parallèle** (est-ouest) **sont perpendiculaires**
 
* *Sur une feuille de papier*, je trace :
   * *verticalement* **les méridiens**,
   * *horizontalement* **les parallèles**.
    
* **$`\mathbf{\Longrightarrow}`$** Comme sur la surface terrestre,   
*en tout point de la feuille*, le **méridien** (vertical) et le **parallèle** (horizontal) **sont perpendiculaires**.

* *Sur la feuille je reporte* **les couleurs des continents et des océans** en s'aidant des méridiens et parallèles.

J'ai ainsi réalisé une **carte de la surface terrestre**.

<!--
Idée de question :"Comment réaliser une carte de la Terre?"  
Réponse possible :   
Une première idée :  
\- en chaque lieu de la Terre, le méridien et le parallèle qui passe par ce lieu sont orthogonaux".   
donc :   
\- reporter verticalement sur une carte les méridiens, et horizontalement les parallèles.   
\_ en chaque pixel de cette carte, reporter la couleur du pixel correspondant sur le globe terrestre.  
-->

#### Ma carte ainsi réalisée est-elle fiable ?

* **Puis-je y comparer** *des distances ?*, et *des surfaces ?*

##### Non, sur ma carte les distances ne sont pas respectées

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/earth-map-earth-globe-geometry-3_L1000_v2.gif)  

* **Je ne peux pas comparer des distances** avec précision.

* *Par exemple* :
   * L'**équateur terrestre**, *40 000 km* de circonférence,   
   (**E** sur la figure)
   * Le **cercle polaire**, *16 000 km* de circonférence,   
   (**C** sur la figure)
   * Le **pôle sud**, *un simple lieu* sur Terre,  
   (**P** sur la figure)   
   sont *représentés par* des **lignes de longueurs égales** sur la carte.   
   (égales à la largeur de la carte)


##### Non, sur ma carte les chemins les plus courts ne sont pas des segments de droite.

*Qu'est-ce qu'un grand cercle* sur une sphère ?

* Un **grand cercle** sur une sphère est un *cercle dont tout diamètre passe par le centre de la sphère*.
`
* Soit $`\mathscr{S}`$ une sphère de centre $`O`$ :
   * Le **cercle $`\mathscr{C_1}`$** dont un diamètre $`\mathscr{D_1}`$ ne passe par par $`O`$ n'est *pas un grand cercle*.
   * Le **cercle $`\mathscr{C_2}`$** dont un diamètre $`\mathscr{D_2}`$ passe par $`O`$ est un *grand cercle*.

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/grand-cercle-1_L1200.gif)


*Qu'elle est le chemin le plus court* sur une sphère entre deux de ses points ?


* Le **chemin le plus court** entre deux points sur la surface d'une sphère est le *plus petit arc du
grand cercle* qui contient ces deux points.

* Soient deux points $`P`$ et $`Q`$ sur une sphère $`\mathscr{S}`$ de centre $`O`$ :
   * Le **plus petit arc du cercle $`\mathscr{C_0}`$** joignant$`P`$ et $`Q`$ n'est *pas le chemin le plus court*.
   * Le **plus petit arc du cercle $`\mathscr{C_1}`$** joignant$`P`$ et $`Q`$ n'est *pas le chemin le plus court*.
   * Le **plus petit arc du grand cercle $`\mathscr{C_2}`$** joignant$`P`$ et $`Q`$ est le *chemin le plus court*.

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/grand-cercle-2_L1200.gif)


* Un **grand cercle** est l'intersection entre la sphère et un plan passant par son milieu.   
$`\Longrightarrow`$ ce plan *coupe la sphère en deux demi-sphères*.

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/grand-cercle-orange_L1200.jpg)   
_Nous découpons en général une orange selon un grand cercle._


      
*Sur la figure suivante :*

* **A - Sur le globe terrestre** sont représentés les **plus courts chemins entre** :   
   1. chemin *vert* : **Fort-de-France - La Rochelle**.
   2. chemin *bleu* : **Montréal - Oslo**.
   3. chemin *rouge* : **Libreville - Macapá**.

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/earth-map-earth-globe-geometry-trips_v5_L900.gif)

* **B - Sur la carte** obtenue, ces chemins les plus courts **ne sont pas des segments de droites**.

   * **$`\Longrightarrow`$ en général** les **segments de droite** sur la carte ne représentent  **pas les chemins les plus courts** sur la surface terrestre entre ces deux points.
   
   * **Seule exception** :  lorsque les **deux points** sont **situés sur l'équateur terrestre**.    
    _Cas du chemin rouge Libreville - Macapá_   
    En effet l'*équateur terrestre* est le *seul grand cercle du globe* dont la représentation est une *ligne droite sur ma carte*.
        

<!--##### Non, les formes sont déformées et les aires ne peuvent se comparer.

figure à faire   


<!--
\- Je ne peux pas déterminer le chemin le plus court entre deux lieux de la Terre :   
$nbsp;$nbsp;\- à faire, mais la trajectoire la plus courte prise entre deux points de la Terre 
ne correspond pas à un sègment de droite sur la carte.
-->

<!--##### Non, les formes sont déformées et les aires ne peuvent se comparer.

figure à faire   -->


#### Existe-t-il une projection d'une sphère sur un plan qui respecte toutes les distances, aires et angles?

* **Non, une telle projection n'existe pas**.

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/geometry-euclidian-non-euclidian-orange_L1200.gif)
_Il n'existe aucune façon d'aplanir un minimum une peau d'orange sans la déformer, sans la déchirer_   
<!--merci pour l'idée Martin :)-->

*Pourquoi ?*

* C'est un point qui sera développé dans les niveaux supérieurs.   
En quelques mots : la **géométrie à la surface 2D d'une sphère** n'est *pas la géométrie euclidienne de notre espace 3D usuel*.


#### Comment réaliser au mieux la surface terrestre sur une carte? 

à terminer, décrire cette construction, probablement nécessité d'une autre image.

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/earth-projection-final-stage_v1_L1000.gif)


#### A quoi correspond un point de la carte ?

* un point sur la surface terrestre

* un axe, partant du centre de la sphère et passant par un point de sa surface.


#### Comment représenter sur une carte une direction dans l'espace ?

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/sphere-celeste-1_L1200.gif)

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/sphere-celeste-1b.gif)

**1** - Lorsque le regard d'un **observateur** se situe *à l'intérieur d'une sphère imaginaire*, la direction de son **regard coupe** cette sphère en *un point de sa surface*.

**2** - **Deux observateurs** occupant des *positions différentes* à l'intérieur de la sphère attribueront à **une même direction** de l'espace des *points différents* à la surface de la sphère.

**3** - **Par convention**, le regard de l'*observateur est situé au centre* de la sphère imaginaire.


#### Quel équateur, quels pôles définir pour repérer une direction ?

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/sphere-celeste-2_L1200.gif)

* Cela **dépend du sujet observé** dans toutes les directions de l'espace.
* Pour un sujet donné, les directions correspondantes aux **pôles et** à l'**équateur** 
*doivent pouvoir se déduire de l'observation* elle-même.
* Les **astrophysiciens** choississent les *coordonnées galactiques*.


#### Que sont les coordonnées galatiques ?

![](https://m3p2.com/fr/temporary_ins/geometry-coordinates/n1/overview/galactic-plane-demo-copriright-to-do_L1000.gif)


<!-----------
!   
!  *DES  GRANDEURS  PHYSIQUES  QUI  VARIENT, ET  LEURS  REPRESENTATIONS*   
!
!
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! L'idée est d'introduire :<br>
! - pour la suite dans ce niveau 1, les grandeurs comme la vitesse, l'accélération, les forces, qui ne se résument pas à un nombre.<br>
! - pour le niveau 2, idem, et on commencera à parler de grandeurs scalaires et vectorielles.<br>
! - pour le niveau 3, les grandeurs et champs scalaires et vectoriels.<br>
! - pour le niveau 4, les grandeurs et champs tensoriels, avec le tenseur comme une généralisation et un dépassement des scalaires et des vecteurs.
! <br>
!
! Donc déjà par dire ce qu'est une grandeur physique (je ne vois pas de mot plus simple pour ce niveau).<br>
! Les grandeurs physiques qui peuvent s'exprimer par un nombre (exemple : température) et par une flèche plus ou moins longues (exemple : vitesse du vent).<br>
! Ces grandeurs peuvent varier dans l'espace comme dans le temps.<br>
! Comment représenter les variations spatiales de ces grandeurs :<br>
! - une carte météorologique des température.<br>
! - une  carte météorologique des vents.<br>
! et leurs variations temporelles
! - pour continuer avec les exemples météorologiques et faire prendre conscience de l'urgence climatique :<br>
! &nbsp;&nbsp; - animation (gif) prévisions températures moyennes sur le globe 2100 pour différents scénarios.<br>
! &nbsp;&nbsp; - graphique (température moyenne/temps) 2100 sur une zone donnée du globe.<br>
! <br>
! Lien direct avec un bloc en mathématique sur les fonctions et leurs représentation, avec possibilité d'affichage en parallèle dans un mode.<br>
! <br>
! </details>  

Programme :


!   
!  *MODELISER  LES  PHENOMENES  OBSERVÉS*   
!
!
! <details>
! <summary>
! Lignes directrices
! </summary>
! <br>
! Il s'agit en fait sans le dire d'une première introduction (sans le dire) à la méthode scientifique. A partir des observations sur le temps, l'espace, les corps immobiles et en mouvements et des propriétés géométriques de l'espace et des nombres et des opérations d'introduire  la notion de modélisation physique.<br>  
! <br>
! Et de façon plus concrête, à partir des ces éléments de perceptions et de la mathématique, d'introduire la physique classique et la physique moderne.<br> 
! <br>
! Même si on doit bétonner la physique classique, car c'est celle qui est utile dans la vie de tous les jours, celle qui se "ressent" dans notren expérience du quotidien et qui nous permet de réaliser tout projet à ce niveau 1, il est important d'avoir une connaisance culturelle sur la physique moderne. Et la mise en parallèle de la physique classique, des relativités et quantique permet de mieux comprendre les "bases" de chacune, comment elles façonnent chacune notre vision du monde et se complètent, et de comprendre la notion-même de "modèle".<br>
! <br>
! Donc, a priori, se dirige en ce qui concerne la physique classique, vers la première étape de cinématique (sans dire ce mots), débarrassée des coordonnées. Donc a priori, on partirait des notions de position, de vitesse et d'accélération. Puis (sans le dire) vers des sensations physiques utiles, puis des concepts de dynamique et d'énergétique. <br>
! <br>
! </details>  

Programme :

--------->

<!--------------------------------------------------------------------

### Tests de visualisation (notamment sur smartphones) de figures,



! TEST VIDEO/GIF, EN/HORS CONNEXION
!

##### Le gif tout seul, issu de la vidéo de StD

![](test-meca-1-mp4-gif-steph-durand_v5.gif)  
_Indépendance des mouvements en x et en y._   
_La résistance de l'air est négligeable dans cette expérience._

Un charriot avance à vitesse constante, et un mécanisme dans le charriot projette une balle vers le haut.   
Remarquez la loi de l'inertie :   
la vitesse horizontale, initiale de la balle, due au charriot n'est pas affectée par ce qui se passer verticalement.   
La balle a gardé horizontalement la même vitesse que le charriot et elle retombe exactement dedans.   
La balle possède une vitesse constante en x et elle subit une chute libre en y;       
la combinaison de ces deux mouvements produit une parabole.   
Répétons le point crucial :   
pendant que la balle monte, elle conserve la même vitesse horizontale que le charriot,   
et donc elle retombe exactement dans le charriot.


##### Ceci est une vidéo associée avec commande html pour la vidéo

1. sans le Gif ni le texte associé

<!--
<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
</video>


2. sans le Gif ni le texte associé, mais avec phrase    
Your browser does not support the video tag.

<!--
<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
Your browser does not support the video tag.
</video>


3. avec le Gif mais sans le texte associé

<!--
<video width="100%" muted autoplay loop controls poster="/temporary_ins/geometry-coordinates-prop2/n1/overview/test-meca-1-mp4-gif-steph-durand_v2.gif">
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
</video>



4. avec le Gif et le texte associé

<!--
<video width="100%" muted autoplay loop>
<source src="/temporary_ins/geometry-coordinates-prop2/n1/overview/Méca-1-step-durand_10is.mp4" type="video/mp4">
![](test-meca-1-mp4-gif-steph-durand_v2.gif)   
<br>
Voici un mouvement horizontal à vitesse constante,   
Et voici un mouvement vertical en chute libre, ascendant, puis descendant.   
Et maintenant la combinaison des deux mouvements :   
Pendant que le charriot avance à vitesse constante, la balle est projetée vers le haut.   
Remarquez la loi de l'inertie :   
la vitesse horizontale, initiale de la balle, due au charriot n'est pas affectée par ce qui se passer verticalement.   
La balle a gardé horizontalement la même vitesse que le charriot et elle retombe exactement dedans.   
La balle possède une vitesse constante en x et elle subit une chute libre en y;       
la combinaison de ces deux mouvements produit une parabole.   
Répétons le point crucial :   
pendant que la balle monte, elle conserve la même vitesse horizontale que le charriot,   
et donc elle retombe exactement dans le charriot.
</video>


##### Ceci est une vidéo associée avec commande markdown

2. sans le Gif ni le texte associé, mais avec phrase    

<!--
![Your browser does not support the video tag.](Méca-1-step-durand_10is.mp)


3. avec le Gif mais sans le texte associé

<!--
![test-meca-1-mp4-gif-steph-durand_v5.gif](Méca-1-step-durand_10is.mp)


4. avec le Gif et le texte associé

<!--
![![](test-meca-1-mp4-gif-steph-durand_v5.gif)   
Voici un mouvement horizontal à vitesse constante,   
Et voici un mouvement vertical en chute libre, ascendant, puis descendant.   
Et maintenant la combinaison des deux mouvements :   
Pendant que le charriot avance à vitesse constante, la balle est projetée vers le haut.   
Remarquez la loi de l'inertie :   
la vitesse horizontale, initiale de la balle, due au charriot n'est pas affectée par ce qui se passer verticalement.   
La balle a gardé horizontalement la même vitesse que le charriot et elle retombe exactement dedans.   
La balle possède une vitesse constante en x et elle subit une chute libre en y;       
la combinaison de ces deux mouvements produit une parabole.   
Répétons le point crucial :   
pendant que la balle monte, elle conserve la même vitesse horizontale que le charriot,   
et donc elle retombe exactement dans le charriot.](Méca-1-step-durand_10is.mp)
-------------------------------------->


