---
title: "Metallic waveguides"
published: false
routable: false
visible: false
----

#### Chapter 4

### Exercices solved during
tutorials

<br>

chap2 Exercice 1: Parallel-Plate Capacitor with a dielectric

Consider first an ideal parallel-plate capacitor made of two metallic
plates of surface *S* and separated by a distance *L*, as shown in
figure [4.7,](#_bookmark87) left. The top plate has a positive surface
charge while the bottom plate a negative one both with a density *σ*.
The surface *S* is sufficiently large and the distance *L*
sufficiently small that we can make the approximation of infinte
plates.

1.  By applying Gauss theorem to the surface *S*, show that the electric
    field is inside the capacitor is given by *E\_*0 = *σ/E*~0~.

2.  Let's suppose now that a linear homogeneous and isotropic perfect
    di- electric slab of thickness *d*~2~ and relative permittivity
    *E~r~* is inserted in between the parallel plates. Show that in the
    region occupied by the di- electric, "region 2", the total electric
    field is *E\_* = *[σ]{.underline} [σp]{.underline}* , where *σ* is
    the polarisation charge density appearing on the interfaces of the
    dielectric.

3.  Use the boundary condition for the dielectric displacement vector
    $`\overrightarrow{D}`$ and its constitutive relation to show that the total electric
    field in region 2

is *σ*

*E* =

*E*~0~*E~r~*

(4.15)
>
and then that the surface density of the polarisation charges *σ~p~*
appear- ing on the dielectric is
>
*σ* = *P* = *σ* 1 − [1]{.underline} *.* (4.16)

4.  The capacitance *C* is defined as the ratio between the charges on
    the capacitor plates to the capacitor potential difference. Show
    that due to the presence of the dielectric, the capacitance is given
    by

*σS*

*C* ∆*φ*

*Sε*~0~
>
((*L* − *d* ) + *d*2 l
>
(4.17)
>
2 *Er*

81

where ∆*φ* is the potential difference of the capacitor.

5.  Simplify the expression for the capacitance when the dielectric
    occupies the entire space between the parallel plate. What
    conclusions can we draw on the effect of a dielectric inside a
    capacitor? (Consider that typical values of *E~r~* for materials
    used in capacitors are: *E~r~*=2.1 for PTFE, *E~r~*=2.4 for
    polystyrene, *E~r~*=500 for barium strontium titanate).

![](media/image238.png){width="3.8531244531933506in"
height="2.3428116797900262in"}

Figure 4.7: []{#_bookmark87 .anchor}Left: Capacitor without
dielectric. The red arrows represents the electric field *E*~0~. The
cylinder is taken as the Gauss's surface to calculate the electric
field. *S* is the surface of the cylinder base. Right: A dielectric of
thickness *d*~2~ is inserted. The total electric filed inside the
dielectric is the sum of the electric field due to the charges *σ*
(red arrows) plus the electric field generated by the polarisation
charges *σ~p~* (blue arrows).

chap2 Exercice 2: The solar sail

Une voile solaire est un dispositif de propulsion qui utilise la
pression de ra- diation ´electromagn´etique ´emise par le soleil pour
se d´eplacer dans l'espace. La pression de radiation est tr\`es faible
mais comme dans l'espace il n'y a pratiquement aucune r´esistance, la
vitesse ne fait qu'augmenter et peut at- tendre des valeurs tr\`es
grandes. La voile solaire est propuls´ee par la pression produite par
les photons qui viennent la percuter. On peut aussi donner une
description du ph´enom\`ene en utilisant la physique ondulatoire pour
´evaluer la pression exerc´ee par la radiation.
>
Pour cela, on suppose que la voile est r´ealis´ee dans un conducteur
(par exem- ple une feuille m´etallique) d'indice de refraction complex
*n~c~* = *n*^t^*c* + *inc*tt. On consid\`ere que la radiation est
constitu´e par une onde plane monochromatique,
>
de pulsation *ω* et de vecteur d'onde *\_k~i~* = *k_e~z~* (*z \>* 0),
se propageante dans le vide et faisant une incidence normale avec le
conducteur. On supposera que le conducteur occupe le demi espace *z
\>* 0.

1.  Donner l'expression du champ ´electrique et magn´etique transmis en
    fonc- tion du coefficient de transmission *t*.

2.  Calculer la moyenne temporelle de la densit´e de force (force par
    unit´e de volume) que le champ ´electromagn´etique transmis exerce
    sur le charges du conducteur.

3.  A\` partir du r´esultat pr´ec´edent d´eterminer la moyenne
    temporelle de la

pression *\< P_rad \>* que la radiation ´electromagn´etique exerce sur
les
>
charges du conducteur.

4.  Montrer que dans l'approximation d'un tr\`es bon conducteur, la
    moyenne

temporelle de la pression de radiation peut s'´ecrire *\< P_rad*
>
*\>*= 2 *[\<S\--i>]{.underline}*
>
ou\` *\< S_i \>* est la moyenne temporelle du vecteur de Poynting de
l'onde incidente et *c* la vitesse de la lumi\`ere dans le vide.

5.  La radiation solaire proche de la terre est d'environ 1370 W/m2. Si
    la voile solaire a une surface de 30 m2 et une masse de 10 kg,
    calculer l'acceleration maximale que la voile peut atteindre proche
    de la terre. Si on suppose que cette acceleration peut ˆetre
    maintenue pendant une ann´ee, calculer la vitesse que la voile
    pourrait attendre.

6.  Si l'on souhaite faire l´eviter une pi\`ece d'un Euro (masse 7.5 g
    et diam\`etre 23.25 mm et soumis \`a la force gravitationnelle sur
    Terre) suppos´e par- faitement r´efl´echissante \`a l'aide d'un
    laser, quelle puissance devrions nous utiliser ?

chap2 Exercices 3 : Propagation d'une OPPM dans un M.L.H.I.

Dans cette s´erie d'exercices, on se propose d'´etudier les
caract´eristiques d'une
>
onde ´electromagn´etique *E\_* = *E\_*0 exp*i*(*\--k*·*\--r*−*ωt*)
plane, sinuso¨ıdale, polaris´ee rec-
>
tilignement qui se propage dans un M.L.H.I., lorsque l'on augmente la
pulsa- tion *ω*. Les caract´eristiques de l'onde seront d´eduites de
l'´equation de disper- sion du milieu.
>
![](media/image239.jpeg){width="2.5549989063867016in"
height="1.9949989063867017in"}
>
Figure 4.8: La voile solaire Cosmos 1.
>
https://fr.wikipedia.org/wiki/Cosmos 1

![](media/image240.jpeg){width="1.850624453193351in"
height="2.334374453193351in"}

Figure 4.9: *Sch´ema de principe du d´eplacement des charges dans la
ionosph\`ere.*

chap4 Le plasma et la pulsation de plasma

Dans un premier temps, on d´etermine une des grandeurs propres au
plasma, en l'absence d'onde ´electromagntique. Un plasma est un gaz
ionis´e, de permit- tivit´e di´electrique *E*~0~ et de perm´eabilit´e
magn´etique *µ*~0~, constitu´e d'´electrons de charge *e* et de masse
*m~e~*, et d'ions de charge +*e* et de masse *M* , ainsi que d'atomes
neutres. Les densit´es ´electronique *n~e~* et ionique *n~i~* ´etant
´egales, le plasma est ´electriquement neutre. Si le plasma est peu
dense et si sa temp´erature est peu ´elev´ee, on peut n´egliger les
collisions dues \`a l'agitation thermique : il s'agit de
l'*approximation des plasmas froids*.
>
On se propose de d´eterminer les oscillations propres au plasma,
caract´eris´ees
>
par la pulsation plasma. Pour cela, supposons que sous l'action d'un
champ
>
´electrique stationnaire *E\_*0, les ´electrons de densit´e *n~e~* se
d´eplacent en bloc suivant l'axe (*Oz*), d'une quantit´e *z*, les
ions, du fait de leur inertie beau- coup plus grande restent
immobiles. Il apparaˆıt donc un champ ´electrique *E\_*induit =
*E~z~\_e~z~* entre les deux r´egions ou\` les charges oppos´ees se
retrouvent accumul´ees.

1.  D´eterminer l'expression de *E~z~* en fonction de *e*, *n~e~*,*z* et
    *E*~0~, sachant que l'expression d'un champ ´electrique g´en´er´e
    par un plan de densit´e sur-

facique de charge *σ~S~*
>
plan.
>
s'´ecrit : *E\_* = *[σS]{.underline} \_n*, *\_n* ´etant un vecteur
normal \`a ce 2*E*~0~

2.  D´eterminer le mouvement des ´electrons lorsque'on annule *E\_*0 une
    fois l'´equilibre atteint. En d´eduire la valeur de leur pulsation
    propre appel´e *pulsation plasma*: *ω~p~*.

3.  Calculer la fr´equence plasma pour une couche moyenne de la
    ionosph\`ere pour laquelle la densit´e ´electronique est *n~e~* =
    1011 m−3.

*[Note :]{.underline} Les 3 exercices qui suivent d´emarrent aussi par
la d´etermination du mouvement des particules charg´ees en r´esolvant
leur ´equation du mouvement. Dans cette ´equation, la force
´electrostatique sera toujours celle g´en´er´ee par le champ
´electrique de l'onde EM. Ainsi, le passage de l'onde dans le
mat´eriau impose un r´egime sinuso¨ıdale de pulsation ω pour les
mouvements des par- ticules charg´ees. On pourra donc utiliser les
outils math´ematiques adapt´es (notation complexe) pour r´esoudre ces
´equations.*

chap4 Propagation dans un plasma froid

Il s'agit maintenant de d´eterminer les caract´eristiques d'une onde
´electro-
>
magn´etique plane, sinuso¨ıdale, polaris´ee rectilignement
*E[\_]{.underline}* = *E\_*0 exp{\[*i*(*\_k* · *\_r* − *ωt*)\]}
>
qui se propage dans un plasma froid tel que *n~e~* = *n~i~* = *n*. On
n´eglige ´egalement les interactions entre particules. Dans ces
conditions, les mouvements des particules ne sont d´etermin´es que par
leur inertie et par l'action du champ
>
´electrique de l'onde ´electromagn´etique se propageant dans le
plasma, le poids des particules ´etant n´egligeable.

1.  A partir de l'´equation du mouvement d'un ion (d'un ´electron)
    soumis \`a l'action de l'onde, calculer la densit´e de courant
    ionique *j~i~* (´electronique *j~e~*). En d´eduire la conductivit´e
    *σ* du milieu.

2.  On pose la pulsation plasma des ions Ω2 = *nie*2 , et 2 =

2 + Ω2.

*^p^ E*~0~*M*

*ωc ωp p*
>
Etablir l'´equation de dispersion du plasma en fonction de *c*, *ω* et
*ω~c~*.

3.  D´eterminer le domaine de pulsation pour lequel l'onde est
    ´evanescente et celui pour lequel l'onde est progressive. Tracer
    la courbe de dispersion *ω*(*k*).

4.  Exprimer la vitesse de phase *v~ϕ~* et la vitesse de groupe *v~g~*
    de l'onde progressive en fonction de *c* et des pulsations
    caract´eristiques du plasma.

5.  Exprimer l'indice de r´efraction *n~opt~* du milieu et repr´esenter
    sa variation

*n~opt~*(*ω*).

6.  L'onde se propage dans la direction des *z* croissants. Ecrire le
    champ

´electrique dans chacun des domaines de fr´equences d´etermin´es aux
ques- tions 3 et 4.

7.  L'onde ´electromagn´etique qui se propage est-elle transverse ?
    Justifier.

8.  Le plasma consid´er´e fait partie de la ionosph\`ere (couche
    atmosph´erique situ´ee environ entre 50 et 100 km de hauteur),
    l'ionisation ´etant assur´ee par le soleil. La densit´e *n* est
    alors gale 1*,* 22*.*1012 m−3. Les masses *M* et *m* (= 9*.*10−31
    kg) des ions et des ´electrons sont dans le rapport

*m* \'.:: 1850.
>
Que peut-on dire \`a propos des conductivit´es de ces deux types de
charge?
>
Tenir compte de cette information pour simplifier et calculer la
fr´equence de coupure du plasma, ainsi que la longueur d'onde de
coupure *λ~c~* cor- respondante.
>
A quelle cat´egorie d'ondes appartiennent celles qui sont susceptibles
de traverser la ionosph\`ere ?

9.  Les ´etoiles pulsar ´emettent des ondes radios. L'interval de
    r´eception sur terre entre les impulsions \`a 400 MHz et 200 MHz
    ´emises par une pulsar est de 4 s. Sachant que la densit´e
    d'´electrons dans l'espace interstellaire est de 3×104m−3,
    calculer la distance du pulsar

chap4 Propagation dans un di´electrique

On peut consid´erer le milieu di´electrique comme ´etant constitu´e
d'ions im- mobiles (charge +*e*) et d'´electrons (charge *e*, masse
*m*), ces derniers restant toujours li´es aux ions. Les densit´es *n*
des ions et des ´electrons, par unit de vol- ume, sont suppos´ees
´egales. On adopte un mod\`ele dans lequel chaque ´electron est
consid´er´e "libre" (comme pour un conducteur), mais rappel´e vers un
ion par une force de rappel qu'on supposera ´elastique et de la forme
*K_r~e~* pour un petit d´eplacement *\_r~e~* de l'´electron par
rappo[rt]{.underline} \`a l'ion. Concernant les

´electrons, on posera leur pulsation propre *ω*~0~ = / *[K]{.underline}*
et leur pulsation plasma

*m* 2 2 2
>
est d´efinie comme dans l'exercice pr´ec´edent. On posera aussi Ω =
*ω*~0~ + *ωp* .

1.  On part du principe fondamental de la dynamique appliqu´e \`a un
    ´electron dont on n´egligera le poids. Indiquer la d´emarche du
    calcul qu'il convient d'effectuer pour ´etablir l'´equation de
    dispersion du milieu. D´eterminer cette ´equation.

2.  On augmente progressivement la fr´equence de l'onde incidente aux
    valeurs les plus ´elev´ees possibles. Donner alors les
    caract´eristiques successives de la propagation de l'onde dans ce
    milieu. Combien y a-t-il de bandes passantes ? de bandes non
    passantes ? Tracer la courbe de dispersion du milieu.

3.  Exprimer l'indice de r´efraction *n~opt~* du milieu et tracer sa
    variation en fonction de *ω*.

4.  Quelles information peut-on extraire \`a partir d'une mesure de
    r´eflectivit´e d'un di´electrique?

5.  Dans un di´electrique r´eel les ´electrons sont soumis \`a une force
    de frot- tement *F\_* = *ma_v* (qui d´ecrit les pertes par
    irradiation). Qu'est-ce que l'on peut conclure sur la nature de la
    propagation dans ce cas?

![](media/image241.png){width="5.18375in" height="3.0147911198600177in"}

Figure 4.10: *Haut: partie r´eelle et imaginaire de la function
di´electrique d'un conducteur selon le mod\`ele utilis´e dans
l'exercice avec ω~p~* = 1016 *rad/s et τ* = 10−14 *s. Bas: partie
r´eelle et imaginaire du vecteur d'onde correspondant.*
>
![](media/image242.png){width="5.191874453193351in"
height="1.5131244531933508in"}
>
Figure 4.11: *Gauche: partie r´eel et imaginaire de l'indice de
refraction du conducteur consid´er´e dans la figure pr´ec´edente.
Droite: le pouvoir r´eflecteur correspondant.*

chap4 Propagation dans un conducteur m´etallique

Dans un mod\`ele simple, un m´etal (le cuivre notamment) peut
s'assimiler un milieu L.H.I., de constantes di´electrique et
magn´etique *E*~0~ et *µ*~0~, ´electriquement neutre, constitu´e de
*n* ions (charge +*e*) fixes et de *n* ´electrons mobiles (charge *e*,
masse *m*). Ces derniers subissent des collisions. A l'´echelle
m´esoscopique, les collisions sont ´equivalentes une force de
frottement visqueux oppose leur vitesse *\_v* telle que *F\_* =
*ma_v*, ou\` *a* repr´esente la fr´equence des collisions lie au
>
temps de relaxation *τ* du m´etal par *a* = [1]{.underline} . On
posera qu'en r´egime permanent

*τ* 2

la conductivit´e du conducteur est *σ*~0~ = *ne τ* .

*m*

1.  En appliquant le principe fondamental de la dynamique \`a un
    ´electron (on n´egligera son poids), exprimer la conductivit´e *σ*
    en r´egime variable du mat´eriau en fonction de *σ*~0~ et du
    produit *ωτ* et donner les expressions de sa partie r´eelle *σ*^t^
    et imaginaire *σ*^tt1^.

Exprimer ensuite la conductivit´e en fonction de la pulsation de
plasma

*ω* = *ne*2 . Donner l'expression de la relation de dispersion du milieu

en fonction de *σ* et en d´eduire la nature de la propagation de
l'onde
>
´electromagn´etique susceptible de se trouver dans le conducteur.

2.  On suppose que la fr´equence de l'onde est suffisamment faible pour
    que *ωτ* 1. Donner l'expression approch´ee de la conductivit´e. En
    con- sid´erant que la conductivit´e en r´egime permanent des
    conducteurs est de l'ordre de 107 S/m, et que *τ* 10−14,
    simplifier la relation de dispersion, en d´eduire la nature de la
    propagation dans le milieu et la

1Comme pour l'exercice pr´ec´edent, on peut calculer la relation de
dispersion en utilisant deux m´ethodes: 1) On consid\`ere que *Er* = 1
et on calcul la conductivit´e *σ*. 2) On consid\`ere que *σ* = 0 et on
calcul la fonction di´electrique relative. Les deux m´ethodes donnes
le mˆeme r´esultat.
>
r´egion spectrale ou\` la condition *ωτ* 1 est satisfaite. Exprimer
ensuite l'indice de r´efraction *n~opt~* du m´etal et sa valuer.
Qu'est-ce que l'on peut conclure sur le pouvoir r´eflecteurs des
m´etaux dans ce domain spectral?

3.  On suppose maintenant la fr´equence de l'onde est telle que *ωτ* 1.

Donner l'expression approch´ee de la relation de dispersion et
determiner la nature de la propagation dans les deux cas suivants:

i.  Cas *ω \< ω~p~*.

ii. Cas *ω \ω~p~*. A\` quel domain spectrale correspondents ces
    pulsations?

![](media/image243.png){width="4.752498906386702in"
height="1.9049989063867017in"}

Figure 4.12: *Some critical frequency values (from "Born and Wolf,
Principle of Optics")*

chap4 3.5 Ecran pour t´el´ecommunications (extrait examen 2012-2013)

On se propose d'´etudier la possibilit´e d'empˆecher les
communications des t´el´ephones portables dans une salle de cours. La
strat´egie c'est d'appliquer aux fenˆetres une fine couche d'un
mat´eriau absorbant la radiation centr´ee sur l'´emission des
t´el´ephones portable (ft´el=1GHz=109 Hz) mais non absorbant dans le
spectre du visible (*λ^vis^*=500nm=5x10−7m). Ce mat´eriau est
consid´er´e comme un milieu LHI globalement neutre (*ρ~tot~*=0) et non
magn´etique (*µ*=*µ*~0~). Pour les fr´equences t´el´ephoniques sa
permittivit´e relative et sa conductivit´e sont respectivement :
>
*E*^t´el^=100 et *σ*^t´el^=107 S/m.
>
Pour les fr´equences visibles sa permittivit´e relative et sa
conductivit´e sont respectivement :
>
*E^vis^*=10 et *σ^vis^*=102 S/m.

1.  Ecrire les ´equations de Maxwell dans ce milieu, en supposant valide
    la loi d'Ohm locale (j=*σ*E).

2.  En d´eduire l'´equation de propagation, du champ ´electrique en
    fonction de *µ*~0~,c, *E~r~* et *σ*.

3.  En supposant pour *E\_* la forme suivante *E[\_]{.underline}* =
    *E\_*0*e^i^*^(*kz*−*ωt*)^, ou\` *k* est le

vecteur d'onde et *ω* la pulsation, donner l'´equation de dispersion
du milieu.

4.  Faire une ´evaluation num´erique des diff´erents termes apparaissant
    dans la relation de dispersion pour les fr´equences
    t´el´ephoniques et visibles.

    -   Partie fr´equences t´el´ephoniques :

5.  Pour les fr´equences t´el´ephoniques, donn[er un]{.underline}e
    formule approch´ee de

la relation de dispersion en fonction de *α* = [2]{.underline} .
Comment qualifier ce mat´eriau dans le domaine des fr´equences
t´el´ephoniques ? Quel est le type de
>
propagation ? (on rappelle que
>
√*i* =
>
[1+*i*]{.underline}
>
√2

6.  Ecrire l'expression d'un OPPM se propageant dans ce mat´eriau aux

fr´equences t´el´ephoniques selon Oz dans les sens de z positifs.

7.  On suppose que le signal des antennes relais des t´el´ephones ait
    une amplitude du champ ´electrique E~antenne~=1V/m proches de la
    salle, et que un t´el´ephone peut r´epondre s'il rec¸oit un signal
    d'au moins 1*µ*V/m. En n´egligeant les effet de r´eflexion aux
    surfaces, calculer l'´epaisseur minimal du milieu \`a d´eposer sur
    les fenˆetres afin d'empˆecher tout communication t´el´ephonique.

8.  Montrer que l'indice de r´efraction complexe *[N]{.underline}* du
    milieu peut s'´ecrire

*[N]{.underline}* = *n*(*i*) + *i n*(*ii*) avec *n*(*i*) = *n*(*ii*).

9.  On consid\`ere maintenant l'effet de la r´eflexion air (indice
    n*~air~*=1) -- milieu. Evaluer en forme approch´ee le pouvoir
    r´eflecteur. Conclure.

    -   Partie fr´equences du visible :

10. Pour le visible (*λ^vis^*=500nm), donner une formule approch´ee de
    la relation de dispersion. Comment qualifier ce mat´eriau dans le
    domaine du visible? Quel est le type de propagation ?

11. Evaluer l'impact pour la vue.

chap2 Exercice 4: R´eflexion m´etallique d'une onde polarise circulairement

Une onde plane poss´edant une polarisation circulaire gauche, se
propageant dans l'air dans le demi-espace *z* 0, dans la direction
(*Oz*) a pour expression du champ ´electrique r´eel:

*E\_* (*z, t*) = *E*~0~ \[cos (*kz* − *ωt*) *\_e~x~* − sin (*kz* − *ωt*)
*\_e~y~*\]

1.  D´eterminer l'expression du champ magn´etique *B\_* (*z, t*). Donner
    les ex- pressions des champs complexes *E\_ , B\_* associ´e au
    champ ´electro-magn´etique.

2.  Calculer le vecteur de Poynting associ´e cette onde. Commenter le
    r´esultat.

3.  L'onde se r´efl´echit sous incidence normale sur un miroir plan
    m´etallique de conductivit´e infinie, plac´e dans le plan *z* = 0.

    a.  D´eterminer l'´etat de polarisation de l'onde r´efl´echie (*E\_*
        t(*z, t*)*, B\_* t(*z, t*)).

    b.  D´eterminer les expressions du champ ´electromagn´etique
        r´esultant

(*E_T* (*z, t*)*, B\_ T* (*z, t*)) dans la r´egion *z* ≤ 0. En d´eduire
la valeur du

vecteur de Poynting Π*\_* total de l'onde r´esultante. Commenter.

c.  D´eterminer les densit´es surfaciques de charge *σ~S~*(*t*) et de
    courant

*\_j~S~*(*t*) dans le plan du miroir.

4.  L'onde plane, polarise circulaire gauche, arrive maintenant sous une
    in- cidence *θ* avec la normale au miroir m´etallique. D´eterminer
    *σ~S~*(*x, y, t*) dans cette nouvelle configuration.

chap2 Exercice 5: Cas pratiques de la propagation guid´ee

1.  Un guide d'onde, suppos´e parfait, doit pouvoir fonctionner en mode
    TE~*m,*0~ jusqu'\`a un ordre *p* mais aussi transmettre une bande de
    fr´equence comprise entre *f*~1~ et *f*~2~, avec *f*~1~ *\f*~2~.
    Quelles doivent ˆetre les dimensions

*a* et *b* du guide ? (Rappel: *a* est la dimension du guide suivant
(*Ox*) et
>
*b* celle suivant (*Oy*)).

2.  A partir d'un guide d'onde rectangulaire de dimensions connues (*a
    \b*), d´eterminer sa bande passante pour le mode TE~*m,*0~.

3.  Un guide d'onde carr´e, rempli d'air, a pour dimension *a* = *b* =
    2*,* 4 *cm*. Il est excit´e par deux petites antennes
    perpendiculaires aux faces or- thogonales, c'est dire
    parall\`element (*Ox*), et (*Oy*). Ecrire la condition de
    propagation des modes fondamentaux TE~1*,*0~, et TE~0*,*1~. En
    d´eduire la bande passante, et application num´erique pour les modes
    fondamentaux.

4.  Trouver le premier mode sup´erieur et ´ecrire la condition de non
    propa- gation de ce mode.
