---
title: 'Towards thin lenses'
published: true
visible: false
---

<!--### Lenses classification

A simple lens is a volume made with a transparent substance of refractive index $n$, that present a symetry of revolution around an axis called the optical axis of the lens. This volume is bound by two polished surfaces that can be both curved, or one curved and the other plane. The curved surfaces which have to 

The line joining the centres of the spheres making up the lens surfaces is called the axis of the lens.-->

### Towards thin lenses

! *As part of M3P2*, (UNAL-Manizales?, UdG?,) *INSA-Toulouse*, the results of this chapter "Thick lens" are not to be memorized or known. On the other hand, *understanding the reasoning* is important.

This chapter is a **necessary step** at level foothills, for me *to deeply understand and better master thin lenses*. It will allow me to :
* understand that the thin lens equation and the expression of transverse magnification for the thin lens result from a *second level of approximation* after the paraxial approximation.
* know *in what situations* are these two equations *correct and can be used*, or *wrong and must be modified*. For example are they still correct when :<br>
\- the thin lens is surrounded by a medium of spectral index value different than 1?<br>
\- both media in each side of the lens have different spectral index values?
* have a good introduction to the next main chapter *centered optical systems* because it is my first description of such a system. In particular I will understand the *necesity and requirement for the new concepts* of "principal planes and points, and nodal points" in the next chapter to characterize simply such optical centered system and calculate easily the images they realized. 

##### Physical description of a "thick lens".

A **thick lens** is a *centered physical system* consisting of *two spherical refracting surface that separate the lens glass of refractive index $n$* from the external mdium in each side.

I study the **general case**  where the *media on both sides of the lens have different values of spectral index*.
!!! *EXAMPLE* :  The lens can be used as a *magnifying porthole of a bathyscaphe*.

##### The centered optical system "thick lens" 

Im must remind the plane refracting surface viewed at level "plains". Even if the 

To define an optical system, I have to define a scenario : where is the objet to be imaged or viewed ? And where is the real image of the object to be registered by a matrix sensor or where is located the eye of the observator ? This gives me the direction of propagation of the light (from object to real image or eye) through the optical system. This direction of propagation is part of the description of an optical system. In the figure above the optical systems are each time two ordered spherical refracting surfaces._

A **thick lens** is a *centered optical system* consisting of *two spherical refracting surface that separate the lens glass of refractive index $n$* from the external mdium in each side. 

I study the **general case**  where the *media on both sides of the lens have different values of spectral index*.
!!! *EXAMPLE* :  The lens can be used as a *magnifying porthole of a bathyscaphe*, through which *a human in the air observes a fish in the water*.
 
Le premier dioptre $`DS_1`$ traversé par la lumière a pour sommet $`S_1`$ et pour centre de courbure $`C_1`$, et sépare le milieu (_où se propage la lumière incidente_) d'indice de réfraction $n1$ du milieu situé entre les deux dioptres d'indice de réfraction $n$. Le deuxième dioptre $DS_2$ traversé par la lumière à la suite du premier sépare donc le milieu intermédiaire d'indice de réfraction $n$ du milieu final d'indice de réfraction $n_2$, et a pour sommet $S_2$ et pour centre de courbure $C_2$. L'espacement entre les deux dioptres est caractérisé par la distance  algébrique $\overline{S_1S_2}$. L'orientation de l'axe optique étant choisie positive selon le sens de propagation de la lumière, la distance algébrique $\overline{S_1S_2}$ est positive ($\overline{S_1S_2}>0$.

Le **système centré $SO$** que constitue la lentille épaisse dans son environnement (_ses deux milieux de part et d'autre_) et ses conditions d'utilisation (_le sens considéré de propagation de la lumière à travers la lentille_) est donc **caractérisé par** :
* l'*ordre de traversée* de ces deux dioptres par la lumière, de $DS_1$ vers $DS_2$.
*  les *trois indices de réfraction $n_1$, $n$ et $n_2$* caractérisant respectivement le milieu de propagation de la lumière incidente sur le premier dioptre du système, le milieu intermédiaire commun aux deux dioptres et le milieu de propagation de la lumière transmise par le système.
*  les *rayons algébriques $\overline{S_1C_1}$ et $\overline{S_2C_2}$* des deux dioptres sphériques $DS_1$ et $DS_2$.
*  la *distance $\overline{S_1S_2}$* qui spécifie l'espacement entre les deux dioptres. 

! *IMPORTANT* : si la *lentille* est *plan-convexe ou plan concave*, il suffira de reprendre les diverses expressions mathématiques trouvées et *faire tendre le rayon de courbure concerné (_faire attention au sens de propagation de la lumière_) vers l'infini* ($\overline{SC}\rightarrow\infty$). Nous retrouverions (_certes d'une façon bien compliquée_) les résultats pour une paroi transparente regardée sous incidence normale et dans les conditions de Gauss, en faisant tendre les rayons de deux dioptres vers l'infini ($\overline{S_1C_1}\rightarrow\infty$ et $\overline{S_2C_2}\rightarrow\infty$).

Dans le cadre de l'optique paraxiale (_optique Gaussienne_), ce système optique est quasi-stigmatique et il donne les rayons de lumière issus du point objet $B$ un point image unique $B'$. La **position du point objet $B$ par rapport au système optique** est *déterminée par* :
* la *distance algébrique* **$\overline{AS_1}$** entre la projection $A$ du point objet $B$ sur l'axe optique et le sommet $S_1$ du premier dioptre $DS_1$.
* l'*élévation algébrique* **$\overline{AB}$** du point B par rapport à l'axe optique (_en choisissant préalablement un sens positif d'orientation commun à toute droite perpendiculaire à l'axe optique_).

##### Calcul de l'image finale d'un objet initial de position connue

La position du point $B$ est connue, grâce aux valeurs numériques de $\overline{AS_1}$ et $\overline{AB}$.

!!! *EXEMPLE* : je reprends l'exemple du scientifique qui observe un poisson des abymes à travers le hublot grossissant d'un bathyscaphe. Cela donne :
!!! * milieux extrêmes : $n_1$=$n_{eau}=4/3$ et $n_2$=$n_{air}=1$
!!! * hublot lenticulaire : $n$=$n_{verre}=3/2$, $\overline{S_1C_1}=1 m$, $\overline{S_2C_2}= -1 m$ et $\overline{S_1S_2}=5 cm$,

Pour calculer la position de l'image finale $B'$, je décompose l'action du système optique en considérant les actions successives des deux dioptres qui le constituent :

Le premier dioptre $DS_1$ forme de l'objet ponctuel initial $B$ une image ponctuelle $B_{int}$. Cette image intermédiaire $B_{int}$ devient objet pour le second dioptre $DS_2$ qui en forme une image ponctuelle finale $B'$. Le point $B'$ est donc l'image ponctuelle de l'objet ponctuel $B'$ par le système optique centré $SO$ formé par les deux dioptres successifs $DS_1$ et $DS_2$.

La **relation de conjugaison** genérale $`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=\dfrac{n_{fin}-n_{ini}}{\overline{SC}}`$ et l'**expression du grandissement transversal** générale $`\overline{M_T}=\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$ des dioptres sphériques, *appliquées au* **dioptre sphérique particulier $DS_1$** donnent :

* **$`\dfrac{n}{\overline{S_1A_{int}}}-\dfrac{n_1}{\overline{S_1A}}=\dfrac{n-n_1}{\overline{S_1C_1}}`$** (équ. 1a)

* **$`\overline{M_T}=\dfrac{n_1\cdot\overline{S_1A_{int}}}{n\cdot\overline{S_1A}}`$** (équ. 1b)

Je peux maintenant calculer la position du point image intermédiaire $B_{int}$. De l'équation 1a je peux calculer la valeur numérique de  $\overline{S_1A_{int}}$ du point image intermédiaire $A_{int}$ (_projection orthogonale de_ $B_{int}$ _sur l'axe optique_), et de l'équation 1b la valeur numérique de l'élévation $\overline{A_{int}B_{int}}$ :

$\overline{S_1A_{int}}=\dfrac{n\cdot\overline{S_1C_1}\cdot\overline{S_1A}}
{(n-n_1)\cdot\overline{S_1A}\;+\;n_1\cdot\overline{S_1C_1}}$  (équ. 1c)

par définition $\overline{M_T}=\dfrac{\overline{A_{int}B_{int}}}{\overline{AB}}$$\Longrightarrow\overline{A_{int}B_{int}}=\dfrac{n_1\cdot\overline{S_1A_{int}}}{n\cdot\overline{S_1A}}\cdot\overline{AB}$   (équ. 1d)

!!! *EXEMPLE* : &nbsp;&nbsp;(_suite_)<br>
!!! poisson :  $\overline{S_1A}= - 1 m$  et  $\overline{AB}= 7 cm$.<br>
!!! $\Longrightarrow\overline{S_1A_{int}}=-\dfrac{9}{7} m$  et  $\overline{A_{int}B_{int}}= +8 cm$.

Maintenant que la lumière à traversée le premier dioptre $DS_1$, est s'apprête à, franchir le second dioptre $DS_2$. Du point de vue du $DS_2$, les rayons incidents initiés par le point objet $B$ semblent parvenir du point intermédiaire $B_{int}$. Ce point $B_{int}$, point image pour le dioptre $DS_1$ devient point objet pour le dioptre $DS_2$.

La **relation de conjugaison** et l'**expression du grandissement transversal** générales des dioptres sphériques, *appliquées au* **dioptre sphérique particulier $DS_2$** donnent :

* **$`\dfrac{n_2}{\overline{S_2A'}}-\dfrac{n}{\overline{S_2A_{int}}}=\dfrac{n_2-n}{\overline{S_2C_2}}`$** (équ. 2a)

* **$`\overline{M_T}=\dfrac{n\cdot\overline{S_2A'}}{n_2\cdot\overline{S_2A_{int}}}`$** (équ. 2b)

Je peux calculer la valeur numérique $\overline{S_2A_{int}}$ en remarquant que

$\overline{S_2A_{int}}=\overline{S_1S_2}+\overline{S_1A_{int}}=\overline{S_1A_{int}}-\overline{S_1S_2}$. 

En injectant enfin $\overline{S_2A_{int}}$ et $\overline{A_{int}B_{int}}$ dans les équations 2a et 2b, je détermine les valeurs numériques $\overline{S_2A'}$ et $\overline{A'B'}$ donnant la position de l'image finale $B'$.

!!! *EXEMPLE* : &nbsp;&nbsp;(_suite_)<br>
!!! $\overline{S_2A_{int}}=-\frac{9}{7}-0.005=-1.334\:m$<br>
!!! $\overline{S_2A'}=-1.605\:m$<br>
!!! $\overline{A'B'}=+14.4\:cm$
!!!
!!! Attention, je dois donner une réponse pertinente au problème ! L'image finale n'est pas destinée à se former sur un capteur pour son enregistrement. Ce n'est pas la position de l'image par rapport au hublot ni sa taille qui sont déterminantes, mais la distance $\overline{A'O}$de l'image à l'oeil $O$ du scientifique, et l'angle apparent $\alpha$ sous lequel il voit le poisson.
!!!
!!! Donnée supplémentaire : l'oeil O du scientifique est situé à 10cm de la surface du hublot : $\overline{OA'}=-1.615\:m$ : donc l'image est situé devant l'oeil, le scientifique pourra la voir. De plus cette image est située plus loin que le puctum proximum, donc le scientifique pourra la voir nette. <br>
!!! Je sais que l'image est droite, je vais travailler maintenant pour simplifier en valeurs non algébriques :<br>
!!! $\alpha=arctg\left(\frac{A'B'}{A'O}\right)$$=arctg\left(\frac{0.144}{1.610}\right)$$=arctan(0.089)=0.089\:rad=5°$<br>
!!! Je vois bien ici que la valeur de l'angle apparent __exprimée en radian__ est quasi identique à la valeur de sa tangente, ce qui est une condition pour considérer l'angle petit. Cela valide les conditions de Gauss considérées pour cette observation, et donc  justifie l'étude de ce problème dans le cadre de l'optique paraxiale.


##### Calcul général de l'image finale 

Si je devais chercher les deux équations qui donnent directement la position  $B'$ en fonction de la position de $B$, le calcul (qui n'est pas à faire) serait fastidieux et le résultat complexe. Il donnerait :

$\overline{S_2A'}=\frac{  n_2 \cdot\overline{S_2C_2} \cdot\left(\frac{ n \cdot \overline{S_1C_1} \cdot\overline{S_1A}}{(n-n_1) \cdot\overline{S_1A}+n_1 \cdot \overline{S_1C_1}}- \overline{S_1S_2}\right)}{(n_2n)\cdot\left(\frac{n\cdot\overline{S_1C_1}\cdot\overline{S_1A}}{(n-n_1)\cdot\overline{S_1A}\;+\;n_1\cdot\overline{S_1C_1}}-\overline{S_1S_2}\right)+n\cdot \overline{S_2C_2}}$   (équ.3a)

$\overline{A'B'}=\overline{AB}\times\overline{M_{T-SO}}$, avec

$\overline{M_{T-SO}}=\frac{n\cdot n_1\cdot \overline{S_1C_1}}{(n-n_1)\cdot\overline{S_1A}+n_1\cdot\overline{S_1C_1}}\:\times\:$
$\frac{\overline{S_2C_2}}{(n2-n)\cdot\left(\frac{n\cdot\overline{S_1C_1}\cdot\overline{S_1A}}{(n-n_1)\cdot\overline{S_1A}+n_1\cdot\overline{S_1C_1}}-\overline{S_1S_2}\right)-n\cdot\overline{S_2C_2}}$    (équ.3b)

Ces équations sont difficiles à établir et à retenir. Essayons au moins d'établir la relation de conjugaison de type $\dfrac{n_2}{\overline{S_2A'}}-\dfrac{n_1}{\overline{S_1A}}=\cdot\cdot\cdot$

##### A la recherche d'une équation de conjugaison simple pour la lentille épaisse

Les équations complexes 3a et 3b sont difficiles à manipuler. le plus simples est de repartir des équations (équ.1a) et (équ.2a) où les grandeurs $\dfrac{n_1}{\overline{S_1A}}$ et $\dfrac{n_2}{\overline{S_2A'}}$ apparaissent déjà. L'addition de chaque membre des équations (équ.1a) et (équ.2a) donne :

$`\dfrac{n}{\overline{S_1A_{int}}}-\dfrac{n_1}{\overline{S_1A}}+\dfrac{n_2}{\overline{S_2A'}}-\dfrac{n}{\overline{S_2A_{int}}}$$=\dfrac{n-n_1}{\overline{S_1C_1}}+\dfrac{n_2-n}{\overline{S_2C_2}}`$

En ne gardant au premier membre que les termes $\dfrac{n_1}{\overline{S_1A}}$ et $\dfrac{n_2}{\overline{S_2A'}}$ j'obtiens l'équation :

$\dfrac{n_2}{\overline{S_2A'}}-\dfrac{n_1}{\overline{S_1A}}$$
\:=\:\dfrac{n-n_1}{\overline{S_1C_1}}+\dfrac{n_2-n}{\overline{S_2C_2}}+\dfrac{n}{\overline{S_2A_{int}}}-\dfrac{n}{\overline{S_1A_{int}}}$

Cette équation relativement simple semble convenir, mais c'est une *équation inutile*. Certes le membre de gauche ne contient que les informations sur les conditions d'utilisation de la lentille épaisse (_les indices_ $n_1$ _et_ $n_2$ _des milieux de part et d'autre de la lentille_) et de la position de l'objet $B$ (_la distance algébrique_ $\overline{S_1A_{int}}$_, position du point_ $A$ _par rapport au sommet_ $S_1$ _du premier dioptre rencontré par la lumière_). Mais pour être utile, le membre de droite ne devrait contenir que des grandeurs caractérisant la lentille épaisse elle-même : 
* $n-n_1$ et $n-n_2$  : indices de réfraction différentiels entre matériau constituant la lentille et les milieux extérieurs.
* $\overline{S_1C_1}$ et $\overline{S_2C_2}$ : rayons de courbures algébriques des faces d'entrée et de sortie de la lentille. 
* $\overline{S_1S_2}$ épaisseur de la lentille.
Or ce terme de droite contient aussi les distances algébriques $\overline{S_1A_{int}}$ et $\overline{S_2A_{int}}$ qui concernent la position de l'image intermédiaire $A_{int}$, or cette position dépend elle-même de la position du point objet initial $A$.

Lorsque les **positions des points objets et images** sont **précisées par leur distances par rapport aux sommets $S_1$ et $S_2$**, frontières physiques de la lentille épaisse avec son axe optique, il n'existe **pas d'équation simple** séparant dans un terme de gauche les conditions d'utilisation de la lentille et de positions de l'objet et de l'image, et dans un terme de droite les seules caractéristiques des deux dioptres formant la lentille épaisse. Une formule de conjugaison générale pour tout système centré sera établie au chapitre "Etude des systèmes centrés".

!! *POUR  ALLER  PLUS  LOIN* :<br>
!!
!! Tout système centré, qu'ils soit composé de deux ou de plusieurs éléments simples centrés sur un même axe optique, pourra être caractérisé par deux plans virtuels, appelés : 
!! * plan principal objet (P) de point d'intersection avec l'axe optique $H$
!! * plan principal image (P') de point d'intersection avec l'axe optique $H'$
!! qui remplaceront respectivement la face d'entrée de la première lentille ou miroir du système par la lumière, et la face de sortie de la dernière lentille ou du dernier miroir).
!!
!! Ces plans permettront de définir une relation de conjugaison simple de forme connue : 
!!
!! $\frac{n'}{\overline{H'A'}}-\frac{n}{\overline{HA}}=V$ (avec V, vergence du système dans son environnement)
!!
!! et serviront de référence au positionnement des points focaux objet F et image F' du système dans son environnement :
!!
!! $V=-\frac{n}{\overline{HF}}=\frac{n'}{\overline{H'F'}}$
!!
!! Contrairement à $\overline{S_1S_2}$ toujours positive qu'elle remplacera, la distance algébrique $\overline{H_1H_2}$ pourra être positive ou négative.


### Lentille mince 

Une lentille est dite **lentille mince** lorsque la *distance entre les deux sommets $S_1$ et $S_2$* de la lentille est *petite devant chacun des rayons de courbures* des deux faces.

Cette condition, $\overline{S_1S_2} \ll \overline{S_1C_1}$ et $\overline{S_1S_2} \ll \overline{S_2C_2}$ me permet de faire l'approximation $\overline{S_1S_2}\rightarrow 0$ dans les diverses équations de la lentille épaisse, considérant ainsi que les sommets $S_1$ et $S_2$ se confondent en un même point O.

$\overline{S_1S_2}\rightarrow 0 \:\longrightarrow\:S_1=S_2=O$$\:\longrightarrow\:\overline{S_1C_1}\rightarrow\overline{OC_1}$ et $\overline{S_2C_2}\rightarrow \overline{OC_2}$
 
##### Lentille mince en milieux extrêmes différents

Je peux toujours considérer la lentille mince comme un système optique composé de deux dioptres sphériques centrés, et donc reprendre l'étude initiale de la lentille épaisse, mais avec l' approximation suivante : $S_1=S_2=O$ 


##### Lentille mince plongé dans un même milieu

Je peux toujours considérer la lentille mince comme un système optique composé de deux dioptres sphériques centrés, et donc reprendre l'étude initiale de la lentille épaisse, mais avec les approximations suivantes : $S_1=S_2=O$ et $n_1=n_2=n_{ext}$


##### Lentille mince utilisés dans l'air ou dans le vide

Ce sont les conditions d'utilisation des lentilles minces dans la très grande majorité des cas. Je reprendre l'étude initiale de la lentille épaisse avec les approximations suivantes :

$S_1=S_2=O$ et $n_1=n_2=1$

###### Pour le **premier dioptre** :

La relation de conjugaison genérale $`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=\dfrac{n_{fin}-n_{ini}}{\overline{SC}}`$ et l'expression du grandissement transversal générale $`\overline{M_T}=\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$ des dioptres sphériques, donnent :

* **$`\dfrac{n}{\overline{OA_{int}}}-\dfrac{1}{\overline{OA}}=\dfrac{n-1}{\overline{S_1C_1}}`$** (équ. 4a)

* **$`\overline{M_{T-DS1}}=\dfrac{1\cdot\overline{OA_{int}}}{n\cdot\overline{OA}}`$** (équ. 4b)

###### Pour le **second dioptre** :

Ces mêmes expressions générales donnent :

* **$`\dfrac{1}{\overline{OA'}}-\dfrac{n}{\overline{OA_{int}}}=\dfrac{1-n}{\overline{S_2C_2}}`$** (équ. 5a)

* **$`\overline{M_{T-DS2}}=\dfrac{n\cdot\overline{OA'}}{1\cdot\overline{OA_{int}}}`$** (équ. 5b)

Additionner entre elles les équations 1a et 2a donne:


$\dfrac{n}{\overline{OA_{int}}}-\dfrac{1}{\overline{OA}}+\dfrac{1}{\overline{OA'}}-\dfrac{n}{\overline{OA_{int}}}=\dfrac{n-1}{\overline{S_1C_1}}+\dfrac{1-n}{\overline{S_2C_2}}$

soit 

**$\dfrac{1}{\overline{OA'}}-\dfrac{1}{\overline{OA}}=(n-1)\cdot\left(\dfrac{1}{\overline{S_1C_1}}-\dfrac{1}{\overline{S_2C_2}}\right)$**  (équ. 6)

**Cette équation est vraiment utile** :
* au premier membre ne se situent que les positions des points objet et image conjugués $A$ et $A'$  sur l'axe optique relativement au point O qui positionne la lentille mince sur cet axe.
* au second membre n'intervient que ce qui caractérise la lentille mince (_ses deux rayons algébriques de courbure_ $\overline{S_1C_1}$, $\overline{S_2C_2}$ et l'indice de réfraction $n$ du matériau qui la compose (_la position du point image intermédiaire_ $A_{int}$ _de_ $A$ _par le premier dioptre n'intervient pas_) donc ce second membre est indépendant de la position du point-objet $A$ initial. Dans ces conditions, le premier membre de cette équation définit la vergence de la lentille mince.

Connaissant les caractéristiques physiques ($\overline{S_1C_1}$, $\overline{S_2C_2}$, $n$) de la lentille, cette équation xxx *peut servir à calculer la position de tout point objet $A$ ou image $A'$ connaissant la position de son point conjugué* , c'est l'**équation de conjugaison avec origine au centre O de la lentille mince** lorsque les milieux de chaque côté de la lentille ont un même indice de réfraction $n=1$. On l'appelle *relation de conjugaison de Descartes*.

Les expressions des distances focales objet et image de la lentille en fonction de ses caractéristiques physiques s'obtiennent facilement.

* distance focale image $\overline{OF'}$  : $\left(|\overline{OA}|\rightarrow\infty\Rightarrow A'=F'\right)$

$(équ. 7)\Longrightarrow\overline{OF'}=\dfrac{\overline{S_1C_1}\cdot\overline{S_2C_2}}{(n-1)\cdot(\overline{S_2C_2}-\overline{S1_C1})}$.

* distance focale objet $\overline{OF}$  : $\left(|\overline{OA'}|\rightarrow\infty\Rightarrow A=F\right)$

$(équ. 8)\Longrightarrow\overline{OF}=\dfrac{\overline{S_1C_1}\cdot\overline{S_2C_2}}{(n-1)\cdot(\overline{S_1C_1}-\overline{S_2C_2})}$.

Je peux réécrire la vergence (premier membre de l'équation de conjugaison) en fonction des distances focales objet et image, et je reconnais bien l'**équation de conjugaison de la lentille mince plongée un milieu d'indice de réfraction 1** apprise au niveau "collines" :

**$\dfrac{1}{\overline{OA'}}-\dfrac{1}{\overline{OA}}=V=-\dfrac{1}{\overline{OF}}=\dfrac{1}{\overline{OF'}}$**  (équ. 9a)

! *REMARQUE * :<br>
! Du point de vue de l'optique paraxiale, les plans focaux objet et image sont situés à même distance de part et d'autre de la lentille mince ($\overline(OF)=-\overline(OF')$).  La lentille mince est donc optiquement symétrique. Elle est caractérisée par sa distance focale image $\overline(OF')$. Cette distance focale $\overline(OF')$ est algébrique, une distance focale négative indique une lentille mince divergente, ne distance focale positive indique une lentille mince convergente, 

<!--Le principe du retour inverse de la lumière indique que si la lumière change de sens, le point focal objet devient point focal image et vice versa.-->

<!-- Ce "pour aller plus lojn" suivant est long et mal calibré. Ou il est trop court, ou il est trop long. peut-être le scinder en deux, la partie courte ici, et une partie plus longue en vidéo dans la partie "Pour aller plus lojn" (partie M)-->
!! *POUR  ALLER  PLUS  LOIN* :<br>
!!  Du point de vue de l'optique paraxiale, toutes les lentilles minces caractérisées par une même distance focale $\overline(OF')$ sont optiquement symétrique et équivalentes, qu'elles soient physiquement symétriques ou non, et quelques soient leurs matériaux constitutifs. Ainsi les lentilles sphériques suivantes :
!! 1. biconvexe symétrique en verre crown  (PSK) : $n=1.63$ , $\overline{S_1C_1}=+50\;cm$ , $\overline{S_2C_2}=-50\;cm$.
!! 2. biconvexe symétrique en verre flint (BaF) : $n=1.63$ , $\overline{S_1C_1}=+50\;cm$ , $\overline{S_2C_2}=-50\;cm$. 
!! 3. plan-convexe en verre flint (BaF) : $n=1.63$, $\overline{S_1C_1}=19.3\;cm$ côté convexe.
!!
!! ont une même distance focale image $\overline(OF')=+30.5\;cm$.
!!
!! Pourtant leurs comportements optiques réels seront légèrement différents. L'écart entre le comportement optique réel et le comportement décrit par l'optique paraxiale est dit lié aux aberrations.
!!
!! * Aberration chromatique : L'indice de réfraction varie légèrement avec la longueur d'onde dans le domaine visible (_selon les types de matériaux, la variation de l'indice de réfraction limité au domaine visible est modélisé par différentes fonctions de la longueur d'onde : fonctions de Cauchy, de Briot, de  Sellmeier_). Ainsi, selon la loi de Snell-Descartes, un même rayon lumineux polychromatique incident sur un dioptre avec un angle non nul donnera lieu à différents rayons (_spectre de raies_) ou un faisceau de rayons (_spectre continu_) émergents monochromatiques : c'est le phénomène de dispersion chromatique. Ainsi la position des plans focaux objet et image varient continuement sur une petite plage de distance en fonction de la longueur donde. Même dans des conditions de Gauss idéalement réalisées, un point objet diffusant une lumière blanche (de spectre continu) ne donnera pas un point image blanc, mais une petite étenddue colorée aux couleurs de l'arce-en-ciel. Ce phénomène de dispersion est bien connu dans le cas d'un prisme qui décompose la lumière incidente en un faisceau coloré, mais ce phénomène est aussi présent lorsque la lumière traverse une lentille (_même si le résultat est moins accentué grâce à sa forme_). C'est le nombre d'Abbe qui caractérise ce phénomène de dispersion chromatique : plus il est petit plus le phénomène de dispersion est important.<br>
!! Dans l'exemple, les lentilles 1 et 2 ont mêmes rayons de courbure et un même indice de réfraction, mais le lentille en verre flint (BaF) présentera une aberration chromatique beaucoup plus importante que la lentille en verre crown (PSK). 
!!
!! * L'aberration géométrique : xxx.<br>
!! Pour une lentille plan-convexe, l'aberration géométrique sera différente selon le sens de traversée de la lentille par la lumière. Les lentilles 2 et 3 sont réalisées dans un même verre et sont caractérisées par une même distance focale image, elles se comportent de façons identiques selon l'optique paraxiale. Cependant, éclairées par un même faisceau monochromatique (_pour éviter l'aberration chromatique_) sous incidence normale, c'est la lentille plan-convexe utilisée avec la lumière incidente

Le grandissement transversal de la lentille mince est le produit des grandissements transversaux de chacun des deux dioptres qui composent la lentille mince. En effet :

$M_T  =\dfrac{\overline{A'B'}}{\overline{AB}}=\dfrac{\overline{A_{int}B_{int}}}{\overline{AB}}\cdot\dfrac{\overline{A'B'}}{\overline{A_{int}B_{int}}}=M_{T-DS1}\cdot M_{T-DS2}$

Le calcul de son expression :

$M_{T-DS1}\cdot M_{T-DS2}$$=\dfrac{1\cdot\overline{OA_{int}}}{n\cdot\overline{OA}}\times\dfrac{n\cdot\overline{OA'}}{1\cdot\overline{OA_{int}}}$

se simplifie en :

**$M_{T-thinlens}=\dfrac{\overline{OA'}}{\overline{OA}}$**    (équ. 9b)

Les équations 9a et 9b prennent le point O, centre de la lentille mince, pour référence des distances algébriques $\overline{OA}$, $\overline{OA'}$, et permettent de calculer les distances focales objet $\overline{OF}$ et image $\overline{OF'}$, et donc de postionner les points focaux $F$ et $F'$ de la lentille mince.

Si c'est points sont déjà connus, alors je peux déduire une autre formule de conjugaison et une autre expression du grandissement transversal en prenant les points focaux $F$ et $F'$ pour références des distances algébriques :

$\dfrac{1}{\overline{OA'}}-\dfrac{1}{\overline{OA}}=V=-\dfrac{1}{\overline{OF}}=\dfrac{1}{\overline{OF'}}$

Je peux par exemple multiplier chaque membre de l'équation par  $\overline{OA}$

$\dfrac{\overline{OA}}{\overline{OA'}}-1=\dfrac{\overline{OA}}{\overline{OF'}}$

Puis réduire au même dénominateur le membre de gauche

$\dfrac{\overline{OA}-\overline{OA'}}{\overline{OA'}}=\dfrac{\overline{OA}}{\overline{OF'}}$

Je fais le produit en croix

$\overline{OA'}\cdot\overline{OA}=(\overline{OA}-\overline{OA'})\cdot\overline{OF'}$

Je fais apparaître $\overline{FA}$ et $\overline{F'A'}$

$(\overline{OF'}+\overline{F'A'})\cdot(\overline{OF}+\overline{FA})$$=[(\overline{OF}+\overline{FA})-(\overline{OF'}+\overline{F'A'})]\cdot\overline{OF'}$

Je ne garde par exemple que la distance focale image en remplaçant $\overline{OF}$ par $-\overline{OF'}$

$(\overline{OF'}+\overline{F'A'})\cdot(-\overline{OF'}+\overline{FA})$$=(-\overline{OF'}+\overline{FA}-\overline{OF'}-\overline{F'A'})\cdot\overline{OF'}$

J'effectue les produits

$-\overline{OF'}^2+\overline{OF'}\cdot\overline{FA}-\overline{OF'}\cdot\overline{F'A'}+\overline{FA}\cdot\overline{F'A'}$$=-\overline{OF'}^2+\overline{OF'}\cdot\overline{FA}-\overline{OF'}^2-\overline{OF'}\cdot\overline{F'A'}$

et je simplifie

**$\overline{FA}\cdot\overline{F'A'}=-\overline{OF'}^2$**

**Cette équation est vraiment utile** :
* au premier membre ne se situent que les positions des points objet et image conjugués $A$ et $A'$  sur l'axe optique relativement aux foyers objet $F$ et image $F'$ de la lentille mince avec de chaque côté un milieu d'indice de réfraction $n=1$.
* au second membre n'intervient que ce qui caractérise la lentille mince dans ces conditions d'utilisation (_ses distances algébriques _ $\overline{OF}$ et  $\overline{OF'}$ , positions des points focaux objet et image par rapport au point O). 

Connaissant la distance focale image $\overline{OF' }$de la lentille (_attention, comme toute distance en optique géométrique, cette distance est algébrique_), cette équation xxx *peut servir à calculer la position de tout point objet $A$ ou image $A'$ connaissant la position de son point conjugué* , c'est l'**équation de conjugaison de la lentille mince, avec origines aux foyers**,
lorsque les milieux de chaque côté de la lentille ont un même indice de réfraction $n=1$. On l'appelle *relation de conjugaison de Newton*.




