---
title: Example of a possible structure on the topic "Electromagnetism"
published: true
routable: true
visible: false
lessons:
    - slug: structure-example-234-electromagnetism
      order: 3
---


#### Guidance to structure this level 4

These are **our courses, restructured and redesigned together**.

##### The blocks

In this level 4, **blocks** are important because they **allow to differentiate**
**students** according to different specialties. Later we can associate a
metadata in the file, to select certain blocks and suggest circuits
specific teaching according to the wishes of each student.

So use the blocks to **target different specialties** within this level 4.

Note: A block, which can contain several chapters and many figures, can be
quite heavy, but the estimate is that a block displayed in a presentation mode,
is displayed relatively quickly in 4G (even without wifi connection). A block will match
most likely to 1 M3P2 web page.

--------------------------------------------------------------------------------

##### Color coded blocks in this design step:

!! BLOCK: all students entering this level 4

!!!! BLOCK: Physicists

!!! BLOCK: Electronics - Telecoms

! BLOCK: Modeling mathematicians

--------------------------------------------------------------------------------

#### An example of what to do in terms of structure: level 4

!! *BLOCK ELMAG4-1*
!!
!! *Possible title* : Learning guide
!!
!! *Short description:*    
!! A broad vision of the teaching of electromagnetism at this level 4:
!! The block "for all" and the specialty blocks
!!
!! *For whom?* : All those who enter this level 4.

--------------------------------------------------------------------------------

!! *BLOCK ELMAG4-2*
!!
!! *Possible title* : Maxwell's equations (in a vacuum)
!!
!! *Short description* : from static properties of fields E and B to equations
!! of local and integral Maxwells. Coupling E, B => electromagnetic field Fields of application, linearity.
!! Scalar potential V and vector potential A. Propagation equations for potentials V and A:
!! Lorentz gauge, vacuum application, delayed potentials.
!! Establishment of the propagation equations for fields E and B, ε_0μ_0c ^ 2 = 1.
!! The electromagnetic field propagates and it contains energy
!! volume density of energy EM u_EM = u_E + u_B, vector of Poynting? intensity?
!!
!! *Program elements, or structuring in chapters* :
!!
!! *For whom?* : All those who enter this level 4.

--------------------------------------------------------------------------------

!! *BLOCK ELMAG4-3*
!!
!! *Possible title* : Propagation of electromagnetic waves in vacuum
!!
!! *Short description* :   
!! The ideal model of the monochromatic EM wave = harmonic = sinusoidal, its domain of validity
!! and application, spectral decomposition (Fourier), the real wave (locally), the wave train.
!! Spherical, (parabolic) and plane ideal monochromatic traveling wave models. <br>
!! Zoom on the monochromatic progressive plane wave (OPPM), field of application.
!! Sum of 2 OPPM: standing waves versus traveling waves.
!! Rectinear, circular, elliptical polarizations of OPMs
!!
!! *Program elements, or structuring in chapters* :
!!
!! *For whom?* : All those who enter this level 4.

--------------------------------------------------------------------------------

!!!! *BLOCK ELMAG4-4*
!!!!
!!!! *Possible title* : "Classical" matter-EM wave interaction
!!!!
!!!! *Short description* :
!!!! charge subjected to the EM field Wave radiated by an oscillating dipole ...

--------------------------------------------------------------------------------

!!!! *BLOCK ELMAG4-5*
!!!!
!!!! *Possible title* : Statistical properties of electromagnetic waves
!!!!
!!!! *Short description* : Idea is to go from electromagnetic wave, to trains
!!!! of individual waves emitted by the atoms, which compose it. Redefine optical intensity as
!!!! a statistical average (necessary to make after the fact, the link between the electromagnetic waves,
!!!! and wave optics). Properties of spatial coherence, temporal coherence, mutual coherence,
!!!! power spectral density and spectral width. Feedback on interference between two beams
!!!! partially consistent. Gain in spatial coherence by propagation. Angular diameter measurement
!!!! of stars and planets by Michelson interferometry.
!!!!
!!!! *Program elements, or structuring in chapters* :
!!!!
!!!! *For whom?* : Physicists (or is it rather master's level? N5?)

----------------------------------------------------------------------------

!!!! *BLOCK ELMAG4-6*
!!!!
!!!! *Possible title* : From electromagnetic waves to photons
!!!!
!!!! *Idea* : can also be a terminal branch at level 4 of a transverse theme
!!!! of type "waves and corpuscles" covering the 4 levels, at the border between the
!!!! classical physics and quantum physics.
!!!!
!!!! *Short description* :   
!!!! From this classic theme "electromagnetism", after EM waves (ELMAG4-3), their properties
!!!! statistics (ELMAG4-4), finish at this level 4 with their corpuscular properties.
!!!! Link between electric field, amplitude of probability, revisiting the phenomenon
!!!! interference in its double-sided appearance.
!!!!
!!!! *Program elements, or structuring in chapters* :
!!!!
!!!! *For whom?* : Physicists (for others, they will stop at level 3
!!!! in the transverse theme "waves and corpuscles")

--------------------------------------------------------------------------------

!! *BLOCK ELMAG4-7*
!!
!! *Possible title* : Propagation of electromagnetic waves in material media
!!
!! *Short description* :   
!! conductive media, dielectric media, magnetic media
!! (continuities of ELMAG3-5, ELMAG3-6-7, ELMAG3-11-12)
!! polarization currents, magnetization currents,
!! Maxwell's equations generalized to material media
!! propagation of an OPPM in LHI media
!! generalized dielectric constant and dispersion equation
!! 3 modes: evanescent wave, attenuated wave, non-attenuated wave
!! dispersion equation, group velocity, phase velocity
!! complex refractive index
!! ideal conductive media, and penetration depth
!! non-absorbent dielectric media
!!
!! *Program elements, or structuring in chapters* :
!!
!! *For who ?*

--------------------------------------------------------------------------------

!! *BLOCK ELMAG4-8*
!!
!! *Possible title* : Classic light-matter interactions?
!!
!! *Short description* :   
!! classic model of a crystal : Lorentz model, Drude model, frequency dependence of X_e (w)
!!
!! *Program elements, or structuring in chapters* :
!!
!! *For who ?* : 

------------------------------------------------------------------------------- 

