---
title: 'Electrostatique : Calculs directs'
published: true
routable: true
visible: true
lessons:
    -
        slug: electrostatics-direct-3-linear
        order: 1
    -
        slug: causes-stationary-electric-magnetic-fields
        order: 1
    -
        slug: electrostatics-cylindrical-charge-direct-gauss-integral-local
        order: 1
    -
        slug: causes-E-B-static-to-dynamic-cylindrical-symmetry-34-panorama
        order: 1
    -
        slug: rectilinear-line-electrosta-magnetostat-electromag
        order: 1
---

<!--caligraphie Latex spécifique-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Loiint{\displaystyle\mathop{{\iint}\mkern-22mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$


!!!! *Attention : COURS EN CONSTRUCTION :*    
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.

<!--MétaDonnée : ... -->

---------------------------------------------


### Électrostatique

#### Loi de Coulomb

Soient **deux charges électriques ponctuelles immobiles quelconques dans le référentiel de l'observateur**, 
la *charge $`q_1`$ au point $`P_1`$* et la *charge $`q_2`$ au point $`P_2`$ *de l'espace.

Chacune de ces deux charge exerce une force électrique de Coulomb sur l'autre.

La **loi de Coulomb** exprime la *force $`\overrightarrow{F_{12}}`$* qu'exerce la charge $`q_1`$ sur la charge $`q_2`$* :

**$`\mathbf{ \overrightarrow{F_{12}}=\dfrac{1}{4\pi\epsilon_0}\cdot q_1 \, q_2\cdot\dfrac{\overrightarrow{P_1P_2}}{\lVert\overrightarrow{P_1P_2} \rVert^3}}`$**.

Dans un repère de l'espace de point origine $`O`$ où chaque charge $`q_i`$ en un point $`P_i`$ est repérée par son vecteur position $`\overrightarrow{r_i}=\overrightarrow{OP_i}`$, la loi de Coulomb se réécrit :

$`\overrightarrow{F_{12}}=\dfrac{1}{4\pi\epsilon_0}\cdot \dfrac{q_1 \, q_2}{\lVert\overrightarrow{r_2}-\overrightarrow{r_1}\rVert^3}\cdot (\overrightarrow{r_2}-\overrightarrow{r_1})`$,

ou encore,

**$`\mathbf{ \overrightarrow{F_{12}}=\dfrac{1}{4\pi\epsilon_0}\cdot \dfrac{q_1 \, q_2}{r_{12}^3}\cdot\overrightarrow{e_{12}}}`$**,   

avec **$`\mathbf{\overrightarrow{r_{12}}=\overrightarrow{r_2}-\overrightarrow{r_1}}`$**$`=\overrightarrow{P_1P_2}\quad`$ et 
**$`\mathbf{\quad\overrightarrow{e_{12}}=\dfrac{\overrightarrow{r_{12}}}{\lVert \overrightarrow{r_{12}} \rVert}}`$**


#### Champ électrostatique

La force de Coulomb se réécrit simplement :

$` \overrightarrow{F_{12}}=\left(\dfrac{1}{4\pi\epsilon_0}\cdot \dfrac{q_1}{r_{12}^3}\cdot\overrightarrow{e_{12}}\right) \times q_2`$, 

ce qui permet de définir la grandeur physique entre parenthèse comme le champ électrostatique  $`\overrightarrow{E_{12}}`$ créé par la charge $`q_1`$ immobile en $`\overrightarrow{r_1}`$ au point $`\overrightarrow{r_2}`$.    

$`\overrightarrow{F_{12}}=\overrightarrow{E_{12}} \times q_2\quad`$ (eq 1),

avec $`\quad\overrightarrow{E_{12}}=\dfrac{1}{4\pi\epsilon_0}\cdot \dfrac{q_1}{r_{12}^3}\cdot\overrightarrow{e_{12}}`$,   

Si $`\overrightarrow{E_{12}}`$ est connu, alors une charge $`q_2`$ située en $`\overrightarrow{r_2}`$
est soumise à la force de Coulomb
$`\overrightarrow{F_{12}}=\overrightarrow{E_{12}} \times q_2`$ due à la charge $`q_1`$.

La loi de Coulomb n'a aucune exigence sur la valeur de la charge $`q_2`$ ni sur sa position $`\overrightarrow{r_2}`$ tant que $`\overrightarrow{r_2}\ne \overrightarrow{r_1} `$, si bien que nous pouvons généraliser le vecteur $`\overrightarrow{r_2}`$ à tout vecteur $`\overrightarrow{r}`$ de l'espace
et $`q_2`$ à toute charge élémentaire $`q`$.

Nous pouvons ainsi considérer que la charge $`q_1`$ est la source dans tout l'espace d'un champ électrostatique $`\overrightarrow{E_1}`$ dont l'expression en tout point  $`\overrightarrow{r}`$ de l'espace est :

 $`\overrightarrow{E_{1}}(\overrightarrow{r})=\dfrac{1}{4\pi\epsilon_0}\cdot \dfrac{q_1}{\lVert \overrightarrow{r}-\overrightarrow{r_1}\rVert^3}\cdot(\overrightarrow{r}-\overrightarrow{r_1})`$,

<!--=========================
Le premier terme indique

Plutôt que de s'intéresser à la force créée entre deux charges ponctuelles immobiles en deux points de l'espace, il est intéressant de déomposer le problème en deux étapes :

* La charge 
=========================-->

#### Quelles sont les causes d'un champ électrique stationnaire ?

* Les causes d'un champ magnétique sont des **charges électriques immobiles** dans le référentiel d'observation.


#### Comment créer un champ électrique stationnaire ?

##### Distributions volumique, surfacique et linéïque de charge

L*'espace réel perçu possède 3 dimensions*, les charges occupent les trois dimensions spatiales et tout point point de l'espace peut être caractérisé par une **densité volumique de charge $`\dens^{3D}`$** d'unité SI (pour Système International d'unité) $`Cm^{-3}`$.

**$`\mathbf{\dens^{3D} = \dens^{3D}\,(\rho, \varphi, z)\quad}`$** *$`Cm^{-3}`$*

!!!! *Attention* :   
!!!!
!!!! La *lettre grecque "rho"* désigne traditionnellement à la fois :
!!!! * la *coordonnée rho* du repère cylindrique.
!!!! * une *densité volumique* (densité volumique de charge, densité volumique de masse = masse volumique, ...).
!!!!
!!!! Pour distinguer ces deux significations de la lettre rho et éviter toute confusion, *M3P2 utilise* deux police de caractères différentes de cette même lettre rho :
!!!!
!!!! * *$`\large\rho`$* est la *coordonnée rho* du repère cylindrique.   
!!!! * *$`\dens`$* représente une *densité volumique*.

Dans le cas de *charges localisées au voisinage d'une surface* ,sur une couche d'*épaisseur $`e`$ négligeable*, alors un point de cette surface peut être caractérisé par une **densité surfacique de charge $`\dens^{2D}`$** d'unité SI $`Cm^{-2}`$. Densité surfacique se dit aussi densité superficielle. Si les charges sont sur la surface latérale du cylindre, la densité surfacique s'écrit :

**$`\mathbf{\dens^{2D} = \dens^{2D}\,(\varphi, z)\quad}`$** *$`Cm^{-2}`$*

Dans la case de *charges réparties sur une ligne* de *section droite $`S_{\perp}`$ négligeable*, tout point de cette ligne peut être caractérisé par une **densité linéïque de charge $`\dens^{1D}`$** d'unité SI $`Cm^{-1}`$. Dans ce cas la densité linéïque de charge s'écrit : 

**$`\mathbf{\dens^{1D} = \dens^{1D}\,(z)\quad}`$** *$`Cm^{-1}`$*

! *Important* :   
!
! *Densités surfaciques et linéïque* de charge résultent d'une *idéalisation*, d'une *modélisation 2D et 1D* de la distribution des charges dans l'espace.   
!
! Si d'une façon générale, à l'échelle d'observation les grandeurs physiques et les champs varient de façon continue dans l'espace 3D, *des discontinuités peuvent apparaître* lors des modélisations 2D ou 1D.    
!
! Ces discontinuités correspondent à une perte d'information, aux variations continues ignorées des grandeurs physiques et des champs le long des dimensions négligées. 

##### Qu'est-ce qu'un élément de charge ?

Un **élément de charge** est un *ensemble de charges électriques* apparaissant comme *ponctuel à l'échelle d'observation*. Ainsi, en un point $`P`$ de l'espace :

*  un **élément de volume $`\mathbf{d\Ltau_P}`$** porte un élément de *charge $`\mathbf{dq=\dens_P^{3D}\cdot d\Ltau_P}`$*.
*  un **élément de surface $`\mathbf{dS_P}`$** porte un élément de *charge $`\mathbf{dq=\dens_P^{2D}\cdot dS_P}`$*.
*  un **élément de ligne $`\mathbf{d\mathcal{l}_P}`$** porte un élément de *charge $`\mathbf{dq=\dens_P^{1D}\cdot d\mathcal{l}_P}`$*.


!! *Pour aller plus loin* :   
!!
!! Un *point* est une *abstraction mathématique sans dimension* (0D) de volume nul. 
!!
!! Il représente un *petit volume* entourant tout point M, *non résolu à l'échelle d'observation* spatiale, mais suffisamment grand pour que la valeur moyenne de la grandeur physique exprimée en ce point soit statistiquement stable à l'échelle d'observation temporelle.  
!!  
!! Un tel volume est dit *volume mésoscopique*. 
!! 
!! Cette notion de volume mésoscopique sera précisée et utilisée dans les diverses études sur les propriétés physiques de la matière, dès ce niveau contrefort puis au niveau montagne.


##### Comment s'exprime de champ électrique créé par une distribution de charges?

Un *élément de charge $`dq_P`$*  localisé en un point $`P`$ créé en tout point $`M`$ de l'espace un **champ électrique élémentaire $`\overrightarrow{dE}_{P\rightarrow M}`$** donné par la loi de Coulomb :

**$`\mathbf{\overrightarrow{dE}_{P\rightarrow M}=\dfrac{dq_P}{4\pi\epsilon_0}\cdot \dfrac{\overrightarrow{r_M}-\overrightarrow{r_P}}{\lVert \overrightarrow{r_M}-\overrightarrow{r_P}\rVert^3}}`$**,
 
 En posant $`\overrightarrow{r}=\overrightarrow{PM}=\overrightarrow{r_M}-\overrightarrow{r_P}`$,   
  $`\overrightarrow{e_r}=\dfrac{\overrightarrow{r}}{\lVert \overrightarrow{r}\rVert}\quad`$ et $`\quad r=\lVert\overrightarrow{r}\rVert`$    
  où $`P`$ est un point quelqconque d'une distribution de charge $`\mathscr{D}`$,   
 le *champ électrique totale $`\overrightarrow{E}_M`$* créé en ce point $`M`$ quelconque par $`\mathscr{D}`$ s'écrit alors :
 
 $`\displaystyle\mathbf{\color{blue}{
 \overrightarrow{E}_M=\iiint_{\mathscr{D}} \dfrac{dq}{4\pi\epsilon_0}\cdot \dfrac{\overrightarrow{e_r}}{r^2}}}`$


#### Qu'est-ce que le calcul direct d'un champ électrique ?

* La **calcul direct** résoudre l'intégrale précédente pour la dustribution de charge étudiée.   
   Il consiste donc à :
  * *décomposer* la distribution spatiale des charges *en charges élémentaires*.
  * pour chacun d'eux, *calculer le champ électrique élémentaire induit en un point quelconque de l'espace. 
  * *intégrer les champs électriques élémentaires* créés par l'ensemble des charges élémentaires de la distribution.

* Cette méthode n'est réalisable analytiquement que dans quelques cas très simples.
* Cette méthode peut être traduite en un programme informatique.

<!--MAGST-200-->

#### Quel est le champ électrique créé par un fil rectiligne infini uniformément chargé ?

<!--MAGST-300-->

##### Description et paramétrage du problème

* Le **fil rectiligne infini** est caractérisé par une *densité linéÏque de charge $`\dens^{1D}`$*.

![](electric-field-fil-rectiligne-infini-1_v2_L1200.jpg)

* Le *champ électrique* doit être calculé **en tout point de l'espace**. <br>
Pour cela nous prenons un **point $`M`$ quelconque, représentatif** de tout point de l'espace.<br>
* Il faut *décomposer la charge* dans le fil **en ses charges élémentaires**.<br>
Nous prenons une **charge élémentaire $`\dens^{1D}\cdot\overrightarrow{dl}_P`$ en un point P quelconque, représentatif** de tous les points du fil.
* Ceci nous permettra :<br>
\- dans une première étape, de calculer le champ électrique $`\overrightarrow{dE_M}`$ créé par $`\dens^{1D}\cdot\overrightarrow{dl}_P`$ au point $`M`$.<br>
\- dans une seconde étape seront intégrés l'ensemble des $`\overrightarrow{dE_M}`$ créés par toutes les charges élémentaires constituant le charge dans le fil, pour conduire au champ électrique $`\overrightarrow{E_M}`$ total.

![](electric-field-fil-rectiligne-infini-2_v2_L1200.jpg)

* Il faut ensuite **choisir le bon repère de l'espace** dans lequel la description mathématique de la situation et les calculs seront simples :<br>

* Un **fil rectiligne infini** est *invariant par rotation d'angle $`\varphi`$* quelconque et *par translation $`z`$* quelconque, si nous choissisons un **repère cylindrique $`(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})`$ dont l'axe $`Oz`$ est l'axe du fil**, comme repère de l'espace.
* Nous choisirons de positionner l'**origine $`O`$** du repère au *point de projection orthogonale du point $`M`$ sur le fil*. Ainsi le point $`M`$ de coordonnées cylindriques $`(\rho; \varphi, z)`$ est suité à la distance $`z`$ du fil. 

![](electric-field-fil-rectiligne-infini-3_v2_L1200.jpg)

* L'avantage de cette position de l'origine $`O`$ est que **les trois points $`(P, O, M)`$** forment un **triangle rectangle** en $`O`$.<br>
 Ainsi *les distances $`z`$, $`\rho`$ et $`d=||\,\overrightarrow{PM}\,||`$* qui interviendront dans le calcul de $`\overrightarrow{dB_M}`$, sont aussi les longueurs d'arête de ce triangle rectangle vérifient **$`d^2=\rho^2+z^2`$** et les **relations trigonométriques simples d'un triangle rectangle**.
 
* La charge élémentaire $`\dens^{1D}\cdot\overrightarrow{dl_P}`$ et un point $`M`$ définissent un plan $`\mathcal{P}`$. La loi de Coulomb nous indique que la **direction** du vecteur champ électrique est donnée par le *vecteur $`\mathbf{\overrightarrow{PM}}`$* et son **sens** par le *signe de la charge* élémentaire en $`M`$.

! *Remarque* :   
! Dans le cas d'un fil rectiligne chargé, toutes les charges élémentaires constitutives et le point $`M`$ sont situés dans un même plan $`\mathcal{P}`$. Ces charges conduiront en ce point $`M`$ à des champs électriques élémentaires qui seront contenus dans ce plan $`\mathcal{P}`$.   
!   
! ![](electric-field-fil-rectiligne-infini-4_v2_L1200.jpg)
!
! Bien sûr, cette remarque n'est pas nécessaire, les calculs directs redonneront ce résultats, mais cette remarque *permet de vérifier la véracité du calcul* sur ce point.

* Il faut maintenant **paramétrer le problème**, introduire les *grandeurs physiques intermédiaires utiles* à notre perception du problème. Ainsi nous portons sur la figure :   
<br>
![](electric-field-fil-rectiligne-infini-5_v2_L1200.jpg)   
<br>
   * la distance $`d=||\,\overrightarrow{PM}\,||`$ qui intervient dans la loi de Biot et Savard
   * le vecteur $`\overrightarrow{e_d}`$ tel que le vecteur $`\overrightarrow{PM}`$ s'écrive $`\overrightarrow{PM}=d\cdot \overrightarrow{e_d}`$
   * l'angle $`\alpha =\widehat{OMP}`$


##### Expression du champ électrique élémentaire

* Calculons le **champ électrique élémentaire** au point $`M`$ :<br>
<br>$`\overrightarrow{dE}_M\quad=\quad\dfrac{\dens_P^{1D}\cdot dl}{4\pi\epsilon_0}\cdot\dfrac{\overrightarrow{PM}}{||\,\overrightarrow{PM}\,||^{\,3}}`$
$`\quad=\quad\dfrac{\dens^{1D}\cdot dz}{4\pi\epsilon_0}\cdot\dfrac{d\,\overrightarrow{e_d}}{d^3}`$
$`\quad=\quad\dfrac{\dens^{1D}\cdot dz}{4\pi\epsilon_0}\cdot\dfrac{1}{d^2}\cdot \overrightarrow{e_d}`$

* Nous devons décomposer le vecteur $`\overrightarrow{e_d}`$ en fonction des vecteurs de la base cylindrique choisie, ce qui donne :<br>
$`\quad\overrightarrow{e_d}=\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\quad`$

*  Nous obtenons alors :<br>
<br>**$`\mathbf{\overrightarrow{dE}_M=\dfrac{\dens^{1D}\cdot dz}{4\pi\epsilon_0}\cdot\dfrac{1}{d^2}}`$
$`\;\mathbf{\cdot \left(\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\right)}`$**

##### Calcul du champ électrique total par intégration

* Pour obtenir le *champ électrique total*, il reste à **intégrer tous les champs électriques élémentaires** créés par les éléments de charge qui composent le fil chargé.

!!!! *ATTENTION :* un *fil* est une *variété à une dimension* (variété = espace) : la position d'un élément de charge $`\dens_P^{1D}`$ sur le fil est repérée par *une seule coordonnée, $`z`$* dans le repère choisi.
!!!!
!!!! *Intégrer sur le fil infini* signifie tenir compte de tous les éléments de charge $`\dens_P^{1D}`$  en faisant varier *$`z`$ entre $`-\infty`$ et $`+\infty`$*.
!!!!
!!!! Mais dans notre expression du champ électrique élémentaire, la variable $`z`$ peut être liée à d'autres variables intermédiaires utilisées dans la description du problème. La *question à se poser* est :<br>
!!!! *Si le point $`P`$ se déplace, quelles variables utilisées varient?*
!!!!
!!!! *Si plusieurs variables sont liées* à ce déplacement unidimensionnel de $`P`$, alors elles sont liées. Il faut alors *choisir l'une d'elles comme variable d'intégration*, puis *exprimer les autres en fonction de celle choisie* AVANT de réaliser l'intégration.

* Dans cette étude, lorsque l'élément de charge se déplace le long du fil, les trois variables **$`z`$, $`d`$ et $`\alpha`$ varient de façon non indépendantes**, elles sont liés. Il faut donc **choisir l'une d'elle comme variable d'intégration**.   
$`\Longrightarrow`$ Nous avons la *liberté de choix*, il en résultera simplement des calculs plus ou moins difficiles, un résultat d'écriture plus ou moins smple, un éclairage particulier sur l'interprétation finale. Pour montrer cela, nous choisirons successivement $`z`$, puis $`\alpha`$.

*_Choix de $`z`$ comme variable d'intégration_*

à faire

_*Choix de $`\alpha`$ comme variable d'intégration*_

* C'est le choix la plupart du temps présenté lors de l'étude du fil rectiligne infini. Il conduit facilement à une expression simple du champ magnétique total. 

* Il faut **exprimer $`dz`$ et $`d`$ en fonction de $`\alpha`$**. Le triangle $`(P,O,M)`$ étant rectangle en $`O`$, nous avons :   

![](electric-magnetic-field-fil-rectiligne-infini-6_v2_L1200.jpg)

   * *$`\color{blue}{\dfrac{z}{\rho}=\tan\alpha}`$*$`\quad\Longrightarrow\quad z=\rho\cdot \tan\alpha`$<br>
<br>$`\Longrightarrow\quad\dfrac{dz}{d\alpha}=\rho\cdot \dfrac{d}{d\alpha}\left(\dfrac{\sin\alpha}{\cos\alpha}\right)`$
$`\quad\quad=\rho\cdot \dfrac{\cos^2\alpha+\sin^2\alpha}{\cos^2\alpha}=\dfrac{\rho}{\cos^2\alpha}`$<br>
<br>**$`\mathbf{\Longrightarrow\quad dz=\dfrac{\rho}{\cos^2\alpha}\cdot d\alpha}`$**

  * $`\color{blue}{\dfrac{\rho}{d}= \cos\alpha\quad}`$**$`\mathbf{\Longrightarrow\quad\dfrac{1}{d^2}=\dfrac{\cos^2\alpha}{\rho^2}}`$**

* Exprimé *seulement en fonction de $`\alpha`$*, le champ électrique élémentaire s'écrit :<br>
<br>**$`\mathbf{\overrightarrow{dE}_M}`$**
$`\;=\dfrac{\dens^{1D}\cdot dz}{4\pi\epsilon_0}\cdot\dfrac{1}{d^2}`$
$`\;\cdot \left(\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\right)`$   
<br>  
$`\quad=\dfrac{\dens^{1D}}{4\pi\epsilon_0}\cdot
\underbrace
{\color{brown}{\dfrac{\cos^2\alpha}{\rho^2}}}
_{\color{blue}{\large\mathbf{\frac{1}{d^2}}}}
\cdot
\underbrace
{\color{brown}{\dfrac{\rho}{\cos^2\alpha}\cdot d\alpha}}
_{\color{blue}{\mathbf{dz}}}
`$
$`\;\cdot \left(\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\right)`$   
**$`\mathbf{\quad=\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho}\cdot d\alpha}`$
$`\;\mathbf{\cdot \left(\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\right)}`$**   
<br>


* Calcul de $`\overrightarrow{E}_M`$ créé par un **fil rectiligne de longueur finie**   
 de *densité linéïque de charge uniforme $`\dens^{1D}`$*   
 <br>   
![](electric-field-fil-rectiligne-infini-7_v2_L1200.gif)
 <br>
  Les **extrémités** du fil sont vues, depuis le point $`M`$ dans le repère choisi, sous les angles **$`\mathbf{\alpha_{inf}}`$ et $`\mathbf{\alpha_{sup}}`$** tels que $`\mathbf{\alpha_{inf}\lt\alpha_{sup}}`$, les angles étant *en notation algébrique*.   Le calcul conduit à :   
<br>
**$`\displaystyle\mathbf{\overrightarrow{E_M}}`$**
$`\displaystyle\;=\int_{\alpha_{inf}}^{\alpha_{sup}}\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho}\cdot d\alpha`$
$`\;\cdot \left(\cos\alpha\cdot\overrightarrow{e_{\rho}}-\sin\alpha\cdot\overrightarrow{e_z}\right)`$    
<br>   
$`\begin{align}
\quad=&\int_{\alpha_{inf}}^{\alpha_{sup}}\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho}\cdot \cos\alpha \cdot d\alpha \cdot\overrightarrow{e_{\rho}}\\
&\;-\;\int_{\alpha_{inf}}^{\alpha_{sup}}\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho}\cdot \sin\alpha \cdot d\alpha \cdot\overrightarrow{e_z}
\end{align}`$   
<br><br>
$`\begin{align}
\quad=&\;\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[\sin\alpha\,\Big]_{\alpha_{inf}}^{\alpha_{sup}}\cdot\overrightarrow{e_{\rho}}\\
&\;\;-\;\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[-\,\cos\alpha\,\Big]_{\alpha_{inf}}^{\alpha_{sup}}\cdot\overrightarrow{e_z}
\end{align}`$   
<br><br>
**$`\begin{align}
\quad=&\mathbf{\;\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[\sin\alpha_{sup} - \sin\alpha_{inf} \Big]\cdot\overrightarrow{e_{\rho}}}\\
&\mathbf{\;\;+\;\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[\cos\alpha_{sup} - \cos\alpha_{inf} \Big]\cdot\overrightarrow{e_z}}
\end{align}`$**   

<br>
* Calcul de $`\overrightarrow{E}_M`$ créé par un **fil rectiligne de longueur infinie**   
 de *densité linéïque de charge uniforme $`\dens^{1D}`$*   
 <br>   
 _(figure à ajouter)_   
 <br>
 Dans ce cas, depuis le point M dans le repère choisi, le fil est vu entre les **angles limites 
 $`\mathbf{\alpha_{inf}=-\dfrac{\pi}{2}}`$** et **$`\mathbf{\alpha_{sup}=+\dfrac{\pi}{2}}`$**.
 Le calcul donne alors :   
 <br>
$`\overrightarrow{E_M}=\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[\underbrace
{\color{brown}{\sin\left(\dfrac{\pi}{2}\right) - \sin\left(-\dfrac{\pi}{2}\right)}}_{\color{blue}{=\;1-(-1)\;=\;2}} \Big]\cdot\overrightarrow{e_{\rho}}`$
$`\quad\quad\quad+\;\dfrac{\dens^{1D}}{4\pi\epsilon_0\,\rho} \cdot\Big[\underbrace
{\color{brown}{\cos\left(\dfrac{\pi}{2}\right) - \cos\left(-\dfrac{\pi}{2}\right)}}_{\color{blue}{=\;0-0\;=\;0}} \Big]\cdot\overrightarrow{e_z}`$   
<br>
Soit au final :   
<br>
**$`\displaystyle\mathbf{\overrightarrow{E_M}=\dfrac{\dens^{1D}}{2\pi\epsilon_0\,\rho}\cdot\overrightarrow{e_{\rho}}}`$**
 
 

! *Remarque :*   
!
! Ces expressions impliquent une valeur de champ électrique qui tend vers l'infini quand la distance au fil tend vers zéro. Est-ce physiquement réaliste ?
!
! Dans la modélisation de l'expérience, nous avons considéré un fil de section nulle. Nous avons ainsi fait un modèle approximé à 1 dimension (1D) d'une réalité physique tridimensionnelle (3D). Une reprise 3D de cette étude réalisée à une résolution mésoscopique (le "point" représentant en réalité un volume non résolvable à l'échelle d'observation) ferait apparaître à l'intérieur du fil un champ électrique qui s'éloigne des prédictions du modèle filaire 1D. Notamment les valeurs limites infinies disparaitraient.

!! *Pour aller plus loin :*<br>
!! Faire cette étude 3D de façon analytique en calculs directs serait extrêmement difficile. Une façon de faire serait d'implémenter la loi de Coulomb pour le champ électrique dans un calcul informatique avec un certain maillage de l'espace et une longeur de fil limitée. Par contre, ce fil uniformément chargé présentant des invariances et symétries suffisantes, ce calcul sera très facile en utilisant le théorème de Gauss (première étape réservée à ceux qui se destinent à maîtriser l'électromagnétisme de Maxwell).
!!
!! L'électron étant considéré comme une particule ponctuelle, même dans une description 3D les valeurs du champ électrique tend vers l'infini quand la distance à l'électron tend vers 0. 
!!
!! A la résolution de la plupart de nos expérience, nous utiliseront la notion de volume mésoscopique. C'est un volume infinitésimal à l'échelle d'observation et donc considéré comme ponctuel dans la modélisation, mais très grand devant les dimensions atomiques. Cela permet d'attribuer au volume mésoscopique la valeur moyenne des champs à l'intérieur de celui-ci, évitant ainsi les valeurs infinies. Dans l'étude des propriétés des matériaux, l'ordre de grandeur d'un volume mésoscopique est de quelques nanomètres cube à quelques dizaines de microns cube, selon les moyens de caractérisations.

#### Quel est le champ électrique créé en un point de son axe par une spire circulaire chargé uniformément ?

<!--MAGST-400-->

#### Quel est le champ électrique créé dans tous l'espace par un disque chargé uniformément ?

<!--MAGST-500-->

#### Quel est le champ électrique créé dans tous l'espace par plan infini uniformément chargé ?

<!--MAGST-550-->

#### Qu'est-ce qu'un dipôle électrique, et quel champ électrique créé t-il ?

<!--MAGST-600-->
