---
title: "Metallic waveguides"
published: true
routable: true
visible: false
----

#### Chapter 4

### Metallic waveguides

<br>

#### 4.1 - Introduction

We propose to study in this chapter the conditions for propagation of
elm radiation in conductive rectangular waveguides and to identify the
main char- acteristic of this kind of propagation. We will introduce a
"practical approach" based on the previous chapter's results.


#### 4.2 - Practical approach

We have seen in the previous chapter that the oblique incidence of
plane waves on planar conductive materials gives rise to an
interference pattern between the incident and reflected waves such
that the resulting wave has propagating character along the z axis
and a standing wave pattern along the y axis. 

![](TE-and-TM-waves-1_L1200.jpg)   
_Figure 4.1 : TE and TM waves and their corresponding standing wave behaviour along the y axis._


* For TE modes (TE = transverse-electric) we have :   
   

$`\overrightarrow{E}_{\perp}=`$$`\underbrace{-2\,E_0\,\sin(k\; y\, \cos\theta)}_{\large{amplitude}}
\cdot \sin\big(\underbrace{k\,\sin\theta}_{\large{wavevector}} z-\omega t\big)\overrightarrow{e_z}`$$`\quad(eq.1)`$    

   
$`\overrightarrow{B}_{\perp}=`$
$`\left(\begin{array}{l}
0\\
-\dfrac{2\,E_0}{c}\sin\theta \cdot \sin\,(k\; y \, \cos\theta)\cdot \sin\,(k\; z\,\sin\theta -\omega t)\\
-\dfrac{2\,E_0}{c}\cos\theta \cdot\cos\,(k\; y \, \cos\theta)\cdot\cos\,(k\; z\,\sin\theta -\omega t)
\end{array}\right)`$$`\quad(eq.2)`$   

<br>

* Similarly for TM modes (TM = transverse-magnetic) :  
   
$`\overrightarrow{E}_{\parallel}=`$
$`\left(\begin{array}{l}
0\\
+2\,E_0\,\sin\theta \cdot\cos\,(k\;y \, \cos\theta)\cdot\cos\,(k\;z\,\sin\theta -\omega t)\\
-2\,E_0\,\cos\theta \cdot\sin\,(k\; y \, \cos\theta)\cdot\sin\,(k\;z\,\sin\theta -\omega t)
\end{array}\right)`$$`\quad(eq.3)`$    
   
$`\overrightarrow{B}_{\parallel}=-2\,E_0\,\sin\,(k\; y\, \cos\theta)
\cdot \sin\big(k\;z\,\sin\,\theta -\omega t\big)\overrightarrow{e_z}`$$`\quad(eq.4)`$ 


These results are dictated by the boundary conditions at the air-metal
interface which impose that for every point on the boundary surface
and for all times the tangential component of the electric field $`\overrightarrow{E}_{\parallel}`$
(incident + reflected) and the perpendicular component of the
induction field $`\overrightarrow{B}_{\perp}`$ (incident + reflected) to be zero:   

$`\overrightarrow{E}_{\parallel}=0\quad\text{and}\quad\overrightarrow{B}_{\perp}=0`$.  

  
* For TE modes,   
this results in the fact that the total electric field
$`\overrightarrow{E}_{\perp}`$  (it is only tangential by definition) has nodes for 
$`y=\dfrac{n\pi}{k\,\cos\theta}=\dfrac{n\pi}{k_y}=\dfrac{n\lambda}{2\cos\theta}`$ where 
$`k_y=k\,\cos\theta`$ is the y component of the wavevector.

* For TM modes,   
we have instead $`\overrightarrow{E}_{\parallel\,,\,z}=0`$ as the z component of the
total electric field represents the tangential component.

As the tangent component of the electric field is zero in the nodal planes,   
$`y=\dfrac{\pi}{k_y}=\dfrac{2\pi}{k_y}=\dfrac{3\pi}{k_y}=\dots`$ 
for TE and TM modes, placing a new conducting plate at
the position of these planes would not disturb the total electric
field. Let's for instance place a conductive plate at the position of
the first node $`y=b=\dfrac{\pi}{k_y}`$ for a TE wave. We can see
that the incident wave, after striking the first plate will be
reflected towards the second plate where now will replicate the same
refection phenomenon with exactly the same incident angle and
automatically satisfying the boundary conditions for the electric field: we have
obtained the confinement of the wave, i.e. the wave is guided.

##### Rectangular waveguides

Now, let's add two more conducting plates perpendicularly to the
previous ones, i.e. two new plates parallel to the y axis. The
boundary conditions to be satisfied at the new surfaces are :   

$`\overrightarrow{E}_{\parallel}=0\quad\Longrightarrow\quad (E_y = 0 , E_z = 0)`$

$`\overrightarrow{B}{\perp}=0\quad\Longrightarrow\quad B_x = 0`$

* For TE modes,   
according to $`(eq.1)`$ we have that $`\overrightarrow{E}\;\parallel\;x`$
and the only condition imposed on the electric field is that
its tangent component must be null, its perpendicular component can
well be discontinue.   
For the magnetic field $`(eq.2)`$
$`b_x = 0`$ is already satisfied.   
In summary, nothing changes for the
electric or magnetic fields, but we have totally confined the
radiation in the x and y directions.


* For TM modes,   
(at least for TM$`_{m\,,\,0}`$ or TM$`_{O\,,\,n}`$, see later for
the definition of these modes), the boundary conditions cannot be
satisfied (try to show it). In what follows we will consider for
simplicity only the case of TE modes.


![](rectangular_waveguide_with_a_TE_mode.jpg)   
_Figure 4.2 : Rectangular waveguide with a TE mode._

<br>

#### 3 TE modes


##### Mode numbering

In the previous example, we have chose the orientation of the frame to
describe the rectangular waveguide such that the successive reflection
of the electric field intervene between the conducting plates placed
at $`y=0`$ and $`y=b`$ where $`b=\dfrac{n\lambda}{2\,\cos\theta}`$.
We will describe this wave as a $`TE_{0,n}`$ which signifies that the reflection
occurs between the plates placed at $`y=0`$ and $`y=b`$ and that there are $`n`$
antinodes of the electric field standing wave between
these plates.

![](mode-numbering-convention_temp_2_L1200.jpg)    
_Figure 4.3: The mode numbering convention._

Obviously the situation will be formally identical if
now we decide to force the successive refections along the other
conducting plates placed now at $`x=0`$ and $`x=a`$ where $`a=\frac{m\lambda}{2\cos\theta}`$
if the wave is $`TE`$ for __that reflection__: The electric
field must be now oriented along the $`y`$  direction in order to be a $`TE`$
wave __for these new plates__.We will describe this wave as a
$`TE_{m,0}`$ which signifies that the reflection occurs between the
plates placed at $`x=0`$ and $`x=a`$ and that there are $`m`$
antinodes of the electric field standing wave between these plates. If
two $`TE`$ waves are simultaneously excited in the system (each one being
$`TE`$ for its respective incidence), than we will describe this wave as a
$`TE_{m,n}`$.


##### Properties of the confined modes

Let's try to find the dispersion relation of a rectangular waveguides
with a few simple considerations on $`TE_{0,n}`$ waves in a waveguide
with dimensions $`y=b`$ and $`x=a`$ :

*  The wave is propagating in air (or vacuum for simplicity). The wave
    must satisfy the usual wave equation and dispersion relation $`k=\frac{\omega}{c}`$
with $`k=\sqrt{k_x^2+k_y^2+k_z^2}`$.

*  We now consider that the boundary conditions impose restrictions on
    the possible values of $`k_y`$. For what seen before, the
    propagation condition reads $`k_y=k\,\cos\theta=frac{n\pi}{b}`$ , 
    and being a $`TE_{0,n}`$ wave we have $`k_x=0`$.

* The wave is propagating along the $`z`$-axis and it is the __nature of__ $`k_z`$
which defines the type of propagation.

In summary, for $`TE`$ waves:   

$`\Longrightarrow`$ Existence of a cut-off frequency. The dispersion relation is:

   * $`k_z=\sqrt{\dfrac{\omega^2}{c^2}-\dfrac{\pi^2 n^2}{b^2}}`$ for a $`TE_{0,n}`$ mode.

   * $`k_z=\sqrt{\dfrac{\omega^2}{c^2}-\dfrac{\pi^2 m^2}{a^2}}`$ for a $`TE_{m,0}`$ mode.

   * $`k_z=\sqrt{\dfrac{\omega^2}{c^2}-\dfrac{\pi^2 n^2}{b^2}-\dfrac{\pi^2 m^2}{a^2}}`$ for a $`TE_{m,n}`$ mode.

We have for:

* a $`TE_{0,n}`$ mode :
   * if $`\omega\gt\omega_c=\dfrac{n\pi c}{b}\;\Longrightarrow\;k_z\in\mathscr{R}e`$   
     $`\Longrightarrow`$ propagation without absorption for mode $`TE_{0,n}`$.
   * if $`\omega\lt\omega_c=\dfrac{n\pi c}{b}\;\Longrightarrow\;k_z\in\mathscr{I}m`$   
     $`\Longrightarrow`$ evanescent wave for mode $`TE_{0,n}`$.

* a $`TE_{m,0}`$ mode :
   * if $`\omega\gt\omega_c=\dfrac{n\pi c}{b}\;\Longrightarrow\;k_z\in\mathscr{R}e`$   
     $`\Longrightarrow`$ propagation without absorption for mode $`TE_{m,0}`$.
   * if $`\omega\lt\omega_c=\dfrac{n\pi c}{b}\;\Longrightarrow\;k_z\in\mathscr{I}m`$   
     $`\Longrightarrow`$ evanescent wave for mode $`TE_{m,0}`$.

* a $`TE_{m,n}`$ mode :
   * if $`\omega\gt\omega_c=\sqrt{\dfrac{n\pi c}{b}^2+\dfrac{n\pi c}{b}^2}\;\Longrightarrow\;k_z\in\mathscr{R}e`$   
     $`\Longrightarrow`$ propagation without absorption for mode $`TE_{m,n}`$.
   * if $`\omega\lt\omega_c=\sqrt{\dfrac{n\pi c}{b}^2+\dfrac{n\pi c}{b}^2}\;\Longrightarrow\;k_z\in\mathscr{I}m`$   
     $`\Longrightarrow`$ evanescent wave for mode $`TE_{m,n}`$.

where $`\omega_c`$ is the cut-off angular frequency. So we can propagate an
electromagnetic wave as a $`TE`$ wave in rectangular waveguides only for frequencies
larger than the cut-off one: the waveguide acts as a high-pass filter.

$`\Longrightarrow`$ Propagation in the waveguide is dispersive:
>
For TEM waves in free space we have: $`k=\omega / c`$ and $`v_{\varphi}=c`$,
which is independent of $`\omega`$: non-dispersive medium. For $`TE`$ waves in
rectangular waveguides, we have in the case of a $`TE_{0,n}`$ mode: (the
propagation is along the $`z`$-axis):

$`k_z=\sqrt{\dfrac{\omega^2}{c^2}-\dfrac{\pi^2 n^2}{b^2}}`$

and   

$`v_{\varphi}=\dfrac{\omega}{k_z}=\dfrac{c}{\sqrt{1-\frac{\omega_c^2}{\omega^2}}}`$

It is a dispersive medium.

![](dispersion-relation-for-a-mode_temp_L1200.jpg)   
_Fig. 4.4 : The geometric interpretation of the dispersion._

Similarly we obtain for the group velocity:

$`v_{\varphi}=\dfrac{\partial \omega}{\partial k_z}=c\,\sqrt{1-\dfrac{\omega_c^2}{\omega^2}}`$

__Geometrical interpretation__

![](geometrical-interpretation-of-the-dispersion_temp_L1200.jpg)   
_Fig. 4.5 : The geometric interpretation of the dispersion._

We can understand the propagating behaviour of the $`TE`$ wave using a
simple interpretation:

*  For $`\omega=\omega_c\,, k_z=k\,\sin\theta = 0`$.   
   This implies $`\theta=0`$. The
    wave is doing a normal incidence on the plates (no $`z`$
    progression) and $`v_g=0`$. In regions close to $`\omega_c`$ the
    waveguides is highly dispersive.

* For $`\omega\longrightarrow\infty\,,k_z\longrightarrow\frac{\omega}{c}\,\theta\longrightarrow\pi/2`$
  and $`v_g\longrightarrow c`$.   
  The $`TE`$ waves tends to have very large incidence angles and the guide
    behaves essentially as vacuum, i.e. dispersionless.

* We can rewrite the dispersion relation for a $`TE_{0,n}`$ mode using
  wavelengths. Eq [4.5] becomes:
  <br>
  $`\dfrac{1}{\lambda_z}=\sqrt{\big(\dfrac{1}{\lambda}\big)^2-\big(\dfrac{1}{\lambda_y}\big)^2}`$   
  <br>
  where $`\lambda_z=\lambda / \sin\theta`$ and $`\lambda_y=\lambda / \cos\theta`$, or again
  <br>
  $`\dfrac{1}{\lambda_z}=\sqrt{\big(\dfrac{1}{\lambda}\big)^2-\big(\dfrac{n}{2b}\big)^2}`$   
  <br>
from which it is easy to confirm (see definition of $`\omega_c`$) that the
cut-off wavelength for a $`TE_{0,n}`$ mode is $`\lambda_c=\frac{2b}{n}`$

![](variation-phase-group-velocity-wersus-omega-guided-mode_temp_L1200.jpg)    
_Fig. 4.6 : The phase and group velocity variations vs angular frequency for a guided mode._

!!!!! *Exercice 4.1 : Refractive index*   
!!!!! Calculate and plot the refractive index vs the angular frequency for a $`TE`$ wave.



#### 4.4 - Power flow

The power density (power per unit surface, units $`[W/m^2]`$
traversing the waveguide can be evaluated from the time-averaged
Poynting vector :

$`\langle\overrightarrow{P}\rangle=\Big\langle\dfrac{\overrightarrow{E}\times\overrightarrow{B}}{\mu}\Big\rangle`$

Let's consider a $`TE_{0,n}`$ mode as described by equations
[4.1] and [4.2.]. We can omit the pre-factor
"-2" from the amplitudes and use the fact that 
$`k\,\cos\theta=k_y=n\pi/b`$ and $`k\,\sin\theta=k_z`$. We get

$`\overrightarrow{E}_{\perp}=`$$`E_0\,\sin\Big(\dfrac{n\pi}{b}\,y\Big)\,\sin(k_z\,z-\omega\,t)\overrightarrow{e_x}`$
$`\quad(eq. 4.11)`$ 

and

   
$`\overrightarrow{B}_{\perp}=
\left(\begin{array}{l}
0\\
\dfrac{E_0}{c}\dfrac{k_z}{k}\sin\big(\dfrac{n\pi}{b}\,y\big)\sin\,(k_z\,z -\omega\,t)\\
\dfrac{E_0}{c}\dfrac{n\pi}{b\,k}\cos\big(\dfrac{n\pi}{b}\,y\big)\sin\,(k_z\,z -\omega\,t)
\end{array}\right)`$
$`\quad(eq. 4.12)`$  

The time-averaged Poynting vector becomes:

$`\langle\overrightarrow{P}\rangle=
\dfrac{1}{2}\,\dfrac{E_0^{\;2}}{c\mu_0}\,\dfrac{k_z}{z}\,\sin^2\Big(\dfrac{n\pi}{b}\,y\Big)\,\overrightarrow{e_z}`$
$`\quad(eq. 4.13)`$  

The power transmitted by the guide (units $`W`$) can be found by
integrating the previous results over the cross-section of the
waveguide

$`\displaystyle\mathscr{P}=\int_0^a\int_0^b\langle P\rangle\,dx\,dy=\dfrac{1}{4}\,\dfrac{E_0^{\;2}}{c\mu_0}\,\dfrac{k_z}{k}`$
$`\quad(eq. 4.14)`$  

i.e. the transmitted power is proportional to the cross-sectional area
of the waveguide. The practical limit of transmittable power is set by
the dielectric breakdown of the dielectric filling the waveguide. In
case of dry air, this limit is of about $`3\;MV/m`$.

!!!!! *Exercice 4.2 : Transmitted power*   
!!!!! 
!!!!! 1) Estimate the maximum power transmittable by a rectangular waveguide
!!!!! of dimensions $`b=2.5\,cm\;,\; a=1b=2.5, a=1\,cm`$ at $`f=9.24\,GHz`$ filled with dry air
!!!!! for the mode $`TE_{0,1}`$.   
!!!!!
!!!!! 2) Rewrite equation 4.14 in case the guide is filled with a perfect dielectric
!!!!! with refractive index $`n`$.

