---
title: Contributing
slug: contributing
---

## How it works

- 📖 *Flat files*
  - [enhanced markdown](#enhanced-markdown) for content
  - [YAML frontmatter](https://learn.getgrav.org/15/content/headers) for metadata
- 🦊 *Continuous integration* using [GitLab (Ruby)](https://m3p2.ljbac.com)
- 🌎 *Decentralized versioning* using [Git](https://en.wikipedia.org/wiki/Git)
  - asynchronous and offline collaboration
  - scales to thousands of contributors
- 🚀 *HTML generation* using [Grav (PHP)](https://m3p2.ljbac.com/m3p2/grav-website)
  - basically the new WordPress, _but much better_
  - vibrant and growing community in 2019


## Data Flow

```mermaid

graph LR

User(Teacher)
Website[M3P2 Website]
Local[Local Website]
Git[Git]
GitLab[GitLab]

User --> |contributes via| Git
User --> |contributes via| GitLab
User --> |contributes via| Local

Local --> |triggers| Git
Git --> |triggers| GitLab
GitLab --> |updates| Website

```


<marquee>🐠</marquee>


## Enhanced Markdown

The point of Markdown (compared to raw HTML) is the _readability of the source_.


### Markdown Cheatsheet

```
# Header like h1
## Header like h2
…
###### Header like h6

_italic_
__underlined__
*bold*
**strong**
~~strike-through~~

Go [there](https://…)
[Current chapter](.)
[Parent chapter](..)
[Sibling chapter](../another-chapter)
[Child chapter](chapter)
[Anchor in the page](#slug-of-header)

![Description of the image](local-image.png)

! blue notice
!! green notice
!!! orange notice
!!!! red notice
!!!!
!!!! another line on the red notice
```

> More at Gitlab's [Markdown documentation](https://docs.gitlab.com/ee/user/markdown.html).



### Emoticons ✨

Just type or paste the unicode character, modern browsers will do the rest.

Here's a handy list: https://unicode.org/emoji/charts/full-emoji-list.html



### LateX

You can use LateX in the courses.

For example, the following

    $E = m \cdot c^2$

yields $E = m \cdot c^2$

!!!! Make sure you add trailing spaces to expressions like `\cdot`,
!!!! or you'll end up with broken formulas.
!!!!
!!!! Generous spacing also improves the readability of the source, and costs nothing.
