---
title: "Operator Combinations"
published: true
routable: true
visible: false
lessons:
    - slug: combinaison-operators-for-electromagnetism
      name: TOOL-MATH: Combination of operators for electromagnetism
      order: 1
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$

*Lecture under construction*, **not validated**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-EN_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-3_L1200.jpg)<details>
<summary>Stage 3 : in writing : 1/3</summary>  
1. Brainstorming
2. In structuring
3. In writing : 1/3
4. In writing : 2/3
5. In writing : 3/3
6. Under review
7. Tested with students
8. Validated, still incomplete
9. Validated, sufficient basis
10. Validated, operational, in constant improvement
</details>

<!--MétaDonnée : ... -->

##### Mountain pathway :&nbsp; _Physics, applied mathematics_

---------------------------

### Mathematical identity and combinations of operators

<br>

RÉSUMÉ IDENTITÉ 
: ---

   Deux champs vectoriels quelconques $`\overrightarrow{U}`$ et $`\overrightarrow{V}`$ vérifient
   l'identité mathématique :     
   * $`\mathbf{div\,\big(\overrightarrow{U}\land\overrightarrow{V}\big)=\overrightarrow{U}\cdot\big(\overrightarrow{rot}\,\overrightarrow{V}\big)\,-\,\overrightarrow{V}\cdot\big(\overrightarrow{rot}\,\overrightarrow{U}\big)}`$


RÉSUMÉ COMBINAISONS
: ---

    Soient $`\overrightarrow{U}`$ un champ vectoriel et $`\phi`$ un champ scalaire quelconques :

   * $`\mathbf{\overrightarrow{rot}\big(\,\overrightarrow{grad}\,\phi\big)=\overrightarrow{0}}`$   
     
     * Est utilisée pour montrer qu'un champ vectoriel dérive d'un champ scalaire :   
     $`\overrightarrow{rot}\,\overrightarrow{U}=\overrightarrow{0}\quad\Longleftrightarrow\quad\exists\phi\,,\, \overrightarrow{U}=\overrightarrow{grad}\,\phi`$
     * En physique, un champ d'interaction $`\overrightarrow{U}`$ dérive d'un potentiel scalaire $`\phi`$
       $`\Longleftrightarrow\quad\exists\phi\,,\, \overrightarrow{U}=- \overrightarrow{grad}\,\phi`$,    
       le signe $`-`$ permettant de définir une énergie mécanique qui se conserve.

   * $`\mathbf{div\big(\overrightarrow{rot}\,\overrightarrow{U}\big)=0}`$   
     * Est utilisée pour montrer qu'un champ vectoriel dérive d'un champ vectoriel :   
     $`div\,\overrightarrow{U}=0\quad\Longleftrightarrow\quad\exists\phi\,,\, \overrightarrow{U}=\overrightarrow{rot}\,\overrightarrow{V}`$
     * En physique, si $`\overrightarrow{U}`$ est un champ d'interaction, $`\overrightarrow{V}`$ est son potentiel vecteur.

   ---

   *Laplacien $`\Delta\,\phi`$ d'un champ scalaire $`\phi`$*

   * Définition de l'opérateur laplacien scalaire :  
     $`\mathbf{\Delta=div\big(\overrightarrow{grad}\big)}`$ 
 
   * Utilité en physique :   
     * équation d'onde (ou équation de d'Alembert) :   
       $`\Delta\,\phi-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \phi}{\partial t^2}=0`$
     * équation de Poisson :   
       $`\Delta\,\phi-f=0\quad`$, avec $`f`$ champ scalaire.
     * équation de Laplace :   
       $`\Delta\,\phi=0`$

   * Expression de $`\Delta\,\phi`$ en coordonnées cartésiennes :   
     $`\Delta\,\phi=\dfrac{\partial^2 \phi}{\partial x^2}+\dfrac{\partial^2 \phi}{\partial y^2}+\dfrac{\partial^2 \phi}{\partial z^2}`$    
     et expression avec l'opérateur nabla $`\nabla`$ :   
     $`\Delta\,\phi=\overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,\phi`$
  
   * <details markdown=1>
      <summary>Expressions en coordonnées cylindriques et sphériques</summary>
      * coordonnées cylindriques $`(\rho\,,\,\varphi\,,\,z)`$ :   
        <br>
       $`\Delta\,\phi=\dfrac{1}{\rho}\cdot\dfrac{\partial}{\partial \rho}\left(\rho\,\dfrac{\partial \phi}{\partial \rho}\right)`$
        $`\;+\;\dfrac{1}{\rho^2}\cdot\dfrac{\partial^2 \phi}{\partial \varphi^2}`$
        $`\;+\;\dfrac{\partial^2 \phi}{\partial z^2}`$   
       <br>
      * coordonnées sphérique $`(r\,,\,\theta\,,\,\varphi)`$ :   
        <br>
       $`\Delta\,\phi=\dfrac{1}{r}\cdot\dfrac{\partial^2}{\partial r^2}(r\phi)`$
       $`\;+\;\dfrac{1}{r^2\,\sin\theta}\cdot\dfrac{\partial}{\partial \theta}\left(\sin\theta\dfrac{\partial \phi}{\partial \theta}\right)`$
       $`\;+\;\dfrac{1}{r^2\,\sin^2\theta}\cdot\dfrac{\partial^2 \phi}{\partial \varphi^2}`$


   ---
   
   *Laplacien $`\Delta\,\overrightarrow{U}`$ d'un champ vectoriel $`\overrightarrow{U}`$*
   
   * Définition opérateur laplacien vectoriel :    
   $`\mathbf{\Delta=\overrightarrow{grad}\big(div\big)
   -\overrightarrow{rot}\big(\overrightarrow{rot}\big)}`$

   * Utilisé en physique dans l'équation d'onde vectorielle :   
     $`\Delta\,\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial \overrightarrow{U}}{\partial t^2}=0`$

   * Expression de $`\Delta\,\overrightarrow{U}`$ en coordonnées cartésiennes de base unitaire $`(\vec{e_x}\,,\,\vec{e_y}\,,\,\vec{e_z})`$ :   
     $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
     \dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_x}{\partial y^2}+\dfrac{\partial^2 U_x}{\partial z^2}\\
     \dfrac{\partial^2 U_y}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_y}{\partial z^2}\\
     \dfrac{\partial^2 U_z}{\partial x^2}+\dfrac{\partial^2 U_z}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial z^2}
     \end{array}\right)`$   
     <br>
     et expression avec l'opérateur nabla $`\nabla`$ :   
     $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
     \Delta\,U_x\\
     \Delta\,U_y\\
     \Delta\,U_z\\
     \end{array}\right)`$
     $`\;=\left(\begin{array}{l}
     \overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,U_x\\
     \overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,U_y\\
     \overrightarrow{\nabla}\cdot\overrightarrow{\nabla}\,U_z\\
     \end{array}\right)`$

   * <details markdown=1>
      <summary>Expressions en coordonnées cylindriques et sphériques</summary>
      * dans la base cylindrique unitaire $`(\vec{e_{\rho}}\,,\,\vec{e_{\phi}}\,,\,\vec{e_z})`$ :   
        <br>
       $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
         \Delta_{cyl}U_{\rho}\\
         \Delta_{cyl}U_{\phi}\\
         \Delta_{cyl}U_z
     \end{array}\right)`$   
     <br>
     où $`\Delta_{cyl}`$ est l'expression du laplacien scalaire en coordonnées cylindriques.
      * dans la base sphérique unitaire $`(\vec{e_r}\,,\,\vec{e_{\theta}}\,,\,\vec{e_{\phi}})`$ :   
        <br>
       $`\Delta\,\overrightarrow{U}=\left(\begin{array}{l}
         \Delta_{sph}U_r\\
         \Delta_{sph}U_{\theta}\\
         \Delta_{sph}U_{\phi}
     \end{array}\right)`$   
     <br>
     où $`\Delta_{sph}`$ est l'expression du laplacien scalaire en coordonnées sphériques.
      </details>

<br>


#### Pourquoi combiner des opérateurs ?

* Les opérateurs **$`\mathbf{\overrightarrow{grad},\,div}`$ et $`\mathbf{\overrightarrow{rot}}`$** caractérisent en tout 
point de l'espace des *propriétés importantes des champs* sur lesquels ils s'appliquent. 
Ils ont une existence en soi, plus fondamentale que leurs expressions dans 
les différents systèmes de coordonnées.   
<br>
Ce sont des **opérateurs différentiels d'ordre un** : leurs expressions dans les différents systèmes 
de coordonnées n'utilisent que des *dérivées partielles spatiales du premier ordre*.

!!! *Exemples* :   
!!! * en électrostatique $`\overrightarrow{E}=-\overrightarrow{grad}\,V`$ qu'il existe une famille 
!!! de champs scalaires $`V`$ dont le champ électrostatique $`\overrightarrow{E}`$ peut dériver.
!!! * en électrostatique $`div\,\overrightarrow{E}=\dens_{charge}^{\;3D}\,/\,\epsilon_0`$ indique que
!!! le champ électrostatique $`\overrightarrow{E}`$ converge ou diverge sur la charge électrique qui le cause.
!!! La charge peut ainsi apparaître comme une simple propriété d'un champ électrostatique.
!!! * en magnétostatique, $`\overrightarrow{rot}\,\overrightarrow{H}=\overrightarrow{j}^{3D}`$ indique
!!! que les lignes de champ d'excitation magnétique $`,\overrightarrow{H}`$ s'enroule autour de l'élément de courant 
!!! $`\overrightarrow{j}^{3D}`$ qui le créé dans le plan perpendiculaire à $`\overrightarrow{j}^{3D}`$.
!!! l'élément de courant peut ainsi apparaître comme une simple propriété d'un champ magnétostatique.


* Cependant les **lois physiques** se traduisent souvent par des **équations différentielles d'ordre deux** : 
leurs expressions dans les différents systèmes  de coordonnées n'utilisent que des 
*dérivées partielles spatiales du second ordre*.

!!! *Exemples* :  en coordonnées cartésiennes $`(x,y,z)`$,
!!! * la propagation d'une onde plane progressive monochromatique $`\Phi`$ dans un milieu homogène et isotrope se propageant vers les x positifs
!!! selon la loi 
!!! $`\dfrac{\partial^2 \Phi(x,t)}{\partial x^2}-\dfrac{1}{\mathscr{v}^2}\,-\dfrac{1}{\mathscr{v}^2}\,\dfrac{\partial^2 \Phi(x,t)}{\partial t^2}`$.
!!! * L'équation de diffusion d'une grandeur physique de densité $`\Phi(x,y,z,t)`$ s'écrit
!!! $`\displaystyle\dfrac{\partial \Phi(\vec{r},t)}{\partial t}=\sum_{x_i=1}^3\sum_{x_j=1}^3\dfrac{\partial}{\partial x_i}\Bigg[\mathscr{D}(\Phi,\vec{r})\,\dfrac{\partial \Phi(\vec{r},t)}{\partial x_j}\Bigg]`$

* Ainsi les **expressions vectorielles des lois physiques**, utiles car indépendantes des systèmes de coordonnées, 
nécessitent des *combinaisons de deux opérateurs du premier ordre* pour obtenir un opérateur du second ordre.
<br>

#### Quelles sont les combinaisons possibles ?

* Les opérateurs différentiels de premier ordre principalement utilisés en physique sont au nombre de 3.

* Le nombre de séquences ordonnées 2 éléments, avec répétition possible d'un même élément, parmi 3 éléments est 9. 

! *Note* :   
!  En mathématique combinatoire et dénombrement :   
! * une séquence de deux éléments $`a`$ et $`b`$ est ordonnée si l'ordre à un sens, donc si
! $`(a,b)\ne(b,a)`$. Une séquence ordonnée s'appelle une suite.
! * Une suite de 2 éléments parmi 3 s'appelle un arrangement.
! * Lorsque la répétition $`(a,a)`$ d'un élément $`a`$ est permise, l'arrangement est dit avec répétition.
! * Le nombre d'arrangements avec répétition de p éléments d'un emsemble de n éléments s'écrit et se calcule :   
! $`A_n^p=n^p`$.
! Le nombre d'arrangements avec répétition de 2 éléments parmi 3 égale 
! $`A_3^2=3^2=9`$.

* Cependant, les opérateurs **$`\mathbf{\overrightarrow{grad},\,div,\,\overrightarrow{rot}}`$** 
 ne sont *pas du même type*.
   * $`\overrightarrow{grad}`$ s'applique à un champ scalaire et donne un champ vectoriel.
   * $`div`$ s'applique à un champ vectoriel et donne un champ scalaire.
   * $`\overrightarrow{rot}`$ s'applique à un champ vectoriel et donne un champ vectoriel.   
   * 
* Ainsi seuls cinq des neufs arrangements d'écriture possible *ont un sens*.     
  Ils conduisent aux **cinq opérateurs différentiels du second ordre** suivants :

*$`\quad\large{\require{cancel}\xcancel{\overrightarrow{grad}\,\big(\overrightarrow{grad})}}\quad ,`$*
**$`\quad\large{\overrightarrow{grad}\,\big(div)}`$**
*$`,\quad\large{\require{cancel}\xcancel{\overrightarrow{grad}\,\big(\overrightarrow{rot})}}`$*
**$`,\quad\large{div\,\big(\overrightarrow{grad})}`$**
*$`,\quad\large{\require{cancel}\xcancel{div\,\big(div)}}`$*
**$`,\quad\large{div\,\big(\overrightarrow{rot})}`$**
**$`,\quad\large{\overrightarrow{rot}\,\big(\overrightarrow{grad})}`$**
*$`,\quad\large{\require{cancel}\xcancel{\overrightarrow{rot}\,\big(div)}}`$*
**$`,\quad\large{\overrightarrow{rot}\,\big(\overrightarrow{rot})}`$**
   
* Toute **combinaison linéaire** *de ces cinq opérateurs* différentiels de second ordre est elle-même
un opérateur différentiel de second ordre.   
<br>
Une combinaison linéaire s'avère particulièrement **utile en physique** est    
<br>
**$`\large{div\,\big(\overrightarrow{grad})-\overrightarrow{rot}\,\big(\overrightarrow{rot})}`$** *$`\large{\;=\Delta}\;`$*,   
<br>
qui définit l'opérateur *Laplacien vectoriel $`\Delta`$*. Celui-ci intervient dans tout phénomène de propagation de champs vectoriels.



### Combinaisons pour l'étude des phénomènes de propagation

<br>

#### L'opérateur laplacien scalaire, et la propagation d'un champ scalaire.

##### 1 - Opérateur laplacien scalaire et équation d'onde d'un champ scalaire.

* Un *champ scalaire $`f`$ se propage* s'il vérifie l'**équation d'onde scalaire**.
  <br>
  L'écriture générale de cette équation *utilise l'opérateur lagrangien scalaire $`\Delta`$* et s'écrit :   
  <br>
  **$`\Delta\,f-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0`$**

* Cet opérateur laplacien scalaire **$`\Delta`$ possède une existence en soi**, 
  *indépendante de son expression dans un système de coordonnées* donné, de même qu'un vecteur à une existence en soit, indépendante de l'expression de ses composantes
  dans un système de coordonnées donné.

* Exprimée **en coordonnées cartésiennes**, l'*équation d'onde scalaire* s'écrit :   
  <br>
  *$`\left(\dfrac{\partial^2 f}{\partial x^2}+\dfrac{\partial^2 f}{\partial y^2}+\dfrac{\partial^2 f}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0`$*
  <br>
  l'expression du laplacien scalaire **$`\Delta`$ en coordonnées cartésienne** étant :   
  <br>
  **$`\Delta=\dfrac{\partial^2}{\partial x^2}+\dfrac{\partial^2}{\partial y^2}+\dfrac{\partial^2}{\partial z^2}`$**

!!! *Exemples de champs scalaires* :   
!!! * le champ des température dans l'atmosphère terrestre.
!!! * le champ de la densité volumique de masse du globe terrestre, ou de l'atmosphère terrestre.

##### 2 - Champ scalaire et opérateur $`\overrightarrow{grad}`$

* Un **champ scalaire $`f`$**, fonction continue et au moins une fois dérivable de l'espace, peut être
  caractérisé *en chacun de ses points* par un *vecteur gradient $`\overrightarrow{grad}\,f`$*.   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le *champ de gradient $`\overrightarrow{grad}\,f`$* qui est un **champ vectoriel**.

##### 3 - Définition du laplacien scalaire à partir du gradient

* Le **champ de gradient $`\overrightarrow{grad}\,f`$** d'un champ scalaire $`f`$ au moins deux fois dérivable, peut être caractérisé
  *en chacun de ses points* par sa *divergence $`div\,\overrightarrow{grad}\,f`$*.   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le **champ de divergence $`div\,\overrightarrow{grad}\,f`$** qui est un champ scalaire.

* Cherchons l'expression de ce champ de divergence en fonction du champ f, en coordonnées cartésiennes.
   * L'expression cartésienne du gradient d'un champ $`f`$ est :   
     $`\overrightarrow{grad}\,f=\dfrac{\partial f}{\partial x}\overrightarrow{e_x}+\dfrac{\partial f}{\partial y}\overrightarrow{e_y}+\dfrac{\partial f}{\partial z}\overrightarrow{e_z}`$
   * L'expression cartésienne de la divergence d'un champ $`\overrightarrow{U}`$ est :  
     $`div\,\overrightarrow{U}=\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}`$
   * La combinaison des deux expressions permet d'exprimer la 
     *divergence du gradient de $`f`$ en coordonnées cartésiennes* :   
     <br>
     *$`div\,\overrightarrow{grad}\,f`$*
     $`\quad= \dfrac{\partial}{\partial x}\left(\dfrac{\partial f}{\partial x}\right)+\dfrac{\partial}{\partial y}\left(\dfrac{\partial f}{\partial y}\right)+\dfrac{\partial}{\partial z}\left(\dfrac{\partial f}{\partial z}\right)`$
     *$`\quad = \dfrac{\partial^2 f}{\partial x^2}+\dfrac{\partial^2 f}{\partial y^2}+\dfrac{\partial^2 f}{\partial z^2}`$*   
     <br>
     et l'**opérateur $`div\,\overrightarrow{grad}`$ en coordonnées cartésiennes** :   
     <br>
     **$`div\,\overrightarrow{grad}= \dfrac{\partial^2}{\partial x^2}+\dfrac{\partial^2}{\partial y^2}+\dfrac{\partial^2}{\partial z^2}`$**

* Nous reconnaissons l'expression cartésienne de l'opérateur laplacien.

* L'opérateur combiné $`div\,\overrightarrow{grad}`$ constitue la **définition de l'opérateur laplacien scalaire** :   
<br>
**$`\large{\Delta}=div\;\overrightarrow{grad}`$**

##### 4 - Relation entre les propriétés locales d'un champ scalaire et sa propagation

* Tout champ scalaire $`f`$ (continue et au moins deux fois dérivable) possède son champ de gradient $`\overrightarrow{f}`$.
* *Si le gradient de $`\overrightarrow{f}`$ vérifie l'* **équation d'onde** :   
  <br>
  *$`\large{div\,\overrightarrow{grad}\,f-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0}`$*      
  <br>
  ou écrit avec le laplacien scalaire :   
  <br>
  **$`\large{\Delta\,f-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 f}{\partial t^2}=0}`$**      
  <br>
  **alors le champ scalaire $`f`$ se propage** *à la célérité $`\mathscr{v}`$*.

<br>

-----------------------------------

#### L'opérateur laplacien vectoriel, et la propagation d'un champ vectoriel

##### 1 - Opérateur laplacien vectoriel et équation d'onde d'un champ vectoriel.

* Un *champ vectoriel $`\overrightarrow{U}`$ se propage* s'il vérifie l'**équation d'onde vectorielle**.
  <br>
  L'écriture générale de cette équation *utilise l'opérateur lagrangien vectoriel $`\overrightarrow{\Delta}`$* et s'écrit :   
  <br>
  **$`\Delta\,\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=\overrightarrow{0}`$**

* Cet opérateur laplacien vectoriel **$`\Delta`$ possède une existence en soi**, 
  *indépendante de son expression dans un système de coordonnées* donné, de même qu'un vecteur 
  à une existence en soit, indépendante de l'expression de ses composantes
  dans un système de coordonnées donné.

* Exprimée **en coordonnées cartésiennes**,   
    * Le *champ vectoriel* s'écrit :   
    <br>
    *$`\overrightarrow{U}=U_x\,\overrightarrow{e_x}+U_y\,\overrightarrow{e_y}+U_z\,\overrightarrow{e_z}`$*
    * et l'*équation d'onde vectoriel* se décompose en :   

    *$`\left\{\begin{array}{l}
    \;\left(\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_x}{\partial y^2}+\dfrac{\partial^2 U_x}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 U_x}{\partial t^2}=0\\
    \;\left(\dfrac{\partial^2 U_y}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_y}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 U_y}{\partial t^2}=0\\    
    \;\left(\dfrac{\partial^2 U_z}{\partial x^2}+\dfrac{\partial^2 U_z}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial z^2}\right)-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 U_z}{\partial t^2}=0   
    \end{array}\right.`$*   
    <br>
    *Chacune des composantes du champ vérifie l'équation d'onde scalaire*.

* L'expression du laplacien vectoriel **$`\Delta\,\overrightarrow{U}`$**
  d'un vecteur $`\overrightarrow{U}`$ **en coordonnées cartésiennes** est :   
  <br>
  **$`\Delta`$**
  **$`=\left(
   \begin{array}{l}
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}\\
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}\\
    \dfrac{\partial^2 U_x}{\partial x^2} + \dfrac{\partial^2 U_x}{\partial y^2} + \dfrac{\partial^2 U_x}{\partial z^2}
    \end{array}
   \right)`$**


<br>

##### 2 - Champ vectoriel et opérateurs $`div`$ et $`\overrightarrow{rot}`$

* Un **champ vectoriel $`\overrightarrow{U}`$**, fonction continue et au moins une fois dérivable de l'espace,
  peut être caractérisé *en chacun de ses points* par un *scalaire divergence $`div\,\overrightarrow{U}`$* et
  un *vecteur rotationnel $`\overrightarrow{rot}\,\overrightarrow{U}`$*   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le *champ de divergence $`div\,\overrightarrow{U}`$* 
  qui est un **champ scalaire**.   
  <br>
  **$`\Longrightarrow`$** nous pouvons construire le *champ de rotationnel $`\overrightarrow{rot}\,\overrightarrow{U}`$* 
  qui est un **champ vectoriel**.

<br>

##### 3 - Définition du laplacien vectoriel à partir de la divergence et du rotationnel

* Le **champ de divergence $`div\,\overrightarrow{U}`$** d'un champ vectoriel $`\overrightarrow{U}`$ au moins 
  deux fois dérivable, peut être caractérisé *en chacun de ses points* par : 
   * *son gradient $`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$*   
   <br>
   **$`\Longrightarrow`$** nous pouvons cronstruire le 
   **champ de gradient $`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$**
   qui est un champ vectoriel.

* Cherchons les coordonnées cartésiennes de $`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$`\color{blue}{div\,\overrightarrow{U}=\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}}`$

* La divergence d'un champ vectoriel est un champ scalaire.   
      Le gradient d'un champ scalaire $`f`$ est le champ vectoriel, qui s'exprime en coordonnées cartésiennes :

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;$`\overrightarrow{grad}\,f=\left(
\begin{array}{l}
\dfrac{\partial f}{\partial x}\\
\dfrac{\partial f}{\partial y}\\
\dfrac{\partial f}{\partial z}
\end{array}\right)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; donc :

$`\overrightarrow{grad}\big(\color{blue}{div\,\overrightarrow{U}}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial}{\partial x}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)\\
\dfrac{\partial}{\partial y}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)\\
\dfrac{\partial}{\partial z}\left( \color{blue}{\dfrac{\partial U_x}{\partial x}+\dfrac{\partial U_y}{\partial y}+\dfrac{\partial U_z}{\partial z}} \right)
\end{array}\right)`$

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; et nous obtenons l'expression **en coordonnées cartésiennes** :

$`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$
**$`\quad = \left(
\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$**

<br>

----------------------------------

<br>


* Le **champ de rotationnel $`\overrightarrow{rot}\,\overrightarrow{U}`$** d'un champ vectoriel $`\overrightarrow{U}`$ au moins 
  deux fois dérivable, peut être caractérisé *en chacun de ses points* par : 
   * son *rotationnel $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$*   
   <br>
   **$`\Longrightarrow`$** nous pouvons cronstruire le 
   **champ de rotationnel $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$**
   qui est un champ vectoriel.

* Cherchons les coordonnées cartésiennes de $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$.

$`\color{blue}{\overrightarrow{rot}\,\overrightarrow{U}=
\left(\begin{array}{l}
\dfrac{\partial U_z}{\partial y}-\dfrac{\partial U_y}{\partial z}\\
\dfrac{\partial U_x}{\partial z}-\dfrac{\partial U_z}{\partial x}\\
\dfrac{\partial U_y}{\partial x}-\dfrac{\partial U_x}{\partial y}
\end{array}\right)}`$


$`\overrightarrow{rot}\big(\color{blue}{\overrightarrow{rot}\,\overrightarrow{U}\big)}`$
$`\quad =
\left[\begin{array}{l}
\dfrac{\partial}{\partial y}\left(
\color{blue}{\dfrac{\partial U_y}{\partial x}-\dfrac{\partial U_x}{\partial y}}
\right)
-\dfrac{\partial}{\partial z}\left(
\color{blue}{\dfrac{\partial U_x}{\partial z}-\dfrac{\partial U_z}{\partial x}}
\right)\\
\dfrac{\partial}{\partial z}\left(
\color{blue}{\dfrac{\partial U_z}{\partial y}-\dfrac{\partial U_y}{\partial z}}
\right)
-\dfrac{\partial}{\partial x}\left(
\color{blue}{\dfrac{\partial U_y}{\partial x}-\dfrac{\partial U_x}{\partial y}}
\right)\\
\dfrac{\partial}{\partial x}\left(
\color{blue}{\dfrac{\partial U_x}{\partial z}-\dfrac{\partial U_z}{\partial x}}
\right)
-\dfrac{\partial}{\partial y}\left(
\color{blue}{\dfrac{\partial U_z}{\partial y}-\dfrac{\partial U_y}{\partial z}}
\right)\end{array}\right]`$

 &nbsp;&nbsp;&nbsp;&nbsp; Nous obtenons alors l'expression **en coordonnées cartésiennes** :

$`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
**$`\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_y}{\partial y\,\partial x}
-\dfrac{\partial^2 U_x}{\partial y^2}
-\dfrac{\partial^2 U_x}{\partial z^2}
+\dfrac{\partial^2 U_z}{\partial z\,\partial x} \\
\dfrac{\partial^2 U_z}{\partial z\,\partial y}
-\dfrac{\partial^2 U_y}{\partial z^2}
-\dfrac{\partial^2 U_y}{\partial x^2}
+\dfrac{\partial^2 U_x}{\partial x\,\partial y} \\
\dfrac{\partial^2 U_y}{\partial x\,\partial z}
-\dfrac{\partial^2 U_x}{\partial x^2}
-\dfrac{\partial^2 U_z}{\partial y^2}
+\dfrac{\partial^2 U_z}{\partial y\,\partial z} \\
\end{array}\right)`$**

<br>

----------------------------------

<br>

Un **fait important** apparaît par 
*soustraction* des composantes cartésiennes *de $`\overrightarrow{grad}\big(div\,\overrightarrow{U}\big)`$*
*et de $`\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$*

$`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
$`\quad = \left(
\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$
$`\quad - \quad
\left(\begin{array}{l}
\dfrac{\partial^2 U_y}{\partial y\,\partial x}
-\dfrac{\partial^2 U_x}{\partial y^2}
-\dfrac{\partial^2 U_x}{\partial z^2}
+\dfrac{\partial^2 U_z}{\partial z\,\partial x} \\
\dfrac{\partial^2 U_z}{\partial z\,\partial y}
-\dfrac{\partial^2 U_y}{\partial z^2}
-\dfrac{\partial^2 U_y}{\partial x^2}
+\dfrac{\partial^2 U_x}{\partial x\,\partial y} \\
\dfrac{\partial^2 U_y}{\partial x\,\partial z}
-\dfrac{\partial^2 U_x}{\partial x^2}
-\dfrac{\partial^2 U_z}{\partial y^2}
+\dfrac{\partial^2 U_z}{\partial y\,\partial z} \\
\end{array}\right)`$

$`\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial x\, \partial y}+\dfrac{\partial^2 U_z}{\partial x \,\partial z}\\
\quad\quad - \dfrac{\partial^2 U_y}{\partial y\,\partial x}
+\dfrac{\partial^2 U_x}{\partial y^2}
+\dfrac{\partial^2 U_x}{\partial z^2}
-\dfrac{\partial^2 U_z}{\partial z\,\partial x} \\
\\
\dfrac{\partial^2 U_x}{\partial y \,\partial x}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial y \,\partial z}\\
\quad\quad - \dfrac{\partial^2 U_z}{\partial z\,\partial y}
+\dfrac{\partial^2 U_y}{\partial z^2}
+\dfrac{\partial^2 U_y}{\partial x^2}
-\dfrac{\partial^2 U_x}{\partial x\,\partial y} \\
\\
\dfrac{\partial^2 U_x}{\partial z \,\partial x}+\dfrac{\partial^2 U_y}{\partial z \,\partial y}+\dfrac{\partial^2 U_z}{\partial z^2}\\
\quad\quad - \dfrac{\partial^2 U_y}{\partial x\,\partial z}
+\dfrac{\partial^2 U_x}{\partial x^2}
+\dfrac{\partial^2 U_z}{\partial y^2}
-\dfrac{\partial^2 U_z}{\partial y\,\partial z} \\
\end{array}\right)`$

* L'ordre de dérivation n'important pas,    
$`\big(\text{exemple :}\;\dfrac{\partial^2}{\partial x\,\partial y}=\dfrac{\partial^2}{\partial y\,\partial x}\big)`$,   
  nous remarquons alors que toutes les dérivées partielles du second ordre correspondant à
  des termes croisés de coordonnées s'annulent :

$`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
$`\require{cancel}\quad = \left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial x\, \partial y}}}+\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial x \,\partial z}}}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial y\,\partial x}}}
+\dfrac{\partial^2 U_x}{\partial y^2}
+\dfrac{\partial^2 U_x}{\partial z^2}
-\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial z\,\partial x}}} \\
\\
\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial y \,\partial x}}}+\dfrac{\partial^2 U_y}{\partial y^2}+\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial y \,\partial z}}}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial z\,\partial y}}}
+\dfrac{\partial^2 U_y}{\partial z^2}
+\dfrac{\partial^2 U_y}{\partial x^2}
-\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial x\,\partial y}}} \\
\\
\color{blue}{\cancel{\dfrac{\partial^2 U_x}{\partial z \,\partial x}}}+\color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial z \,\partial y}}}+\dfrac{\partial^2 U_z}{\partial z^2}\\
\quad\quad - \color{blue}{\cancel{\dfrac{\partial^2 U_y}{\partial x\,\partial z}}}
+\dfrac{\partial^2 U_x}{\partial x^2}
+\dfrac{\partial^2 U_z}{\partial y^2}
-\color{blue}{\cancel{\dfrac{\partial^2 U_z}{\partial y\,\partial z}}} \\
\end{array}\right)`$

* Au total nous obtenons l'expression simple **en coordonnées cartésiennes** :

$`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
**$`\quad =\left(\begin{array}{l}
\dfrac{\partial^2 U_x}{\partial x^2}+\dfrac{\partial^2 U_x}{\partial y^2}+\dfrac{\partial^2 U_x}{\partial z^2}\\
\dfrac{\partial^2 U_y}{\partial x^2}+\dfrac{\partial^2 U_y}{\partial y^2}+\dfrac{\partial^2 U_y}{\partial z^2}\\
\dfrac{\partial^2 U_z}{\partial x^2}+\dfrac{\partial^2 U_z}{\partial y^2}+\dfrac{\partial^2 U_z}{\partial z^2}
\end{array}\right)`$**

* Nous reconnaissons l'expression cartésienne de l'opérateur laplacien vectoriel.

* L'opérateur combiné $`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$
constitue la **définition de l'opérateur laplacien vectoriel** :   
<br>
**$`\large{\Delta=\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)}`$**

<br>

----------------------------------

<br>

##### 4 - Relation entre les propriétés locales d'un champ vectoriel et sa propagation

* Tout champ vectoriel $`\overrightarrow{U}`$ (continue et au moins deux fois dérivable) 
possède son champ $`\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)`$.

* *Si le champ vectoriel $`\overrightarrow{U}`$ vérifie l'* **équation d'onde** :   
  <br><br>
  *$`\large{\overrightarrow{grad}\big(div\;\overrightarrow{U}\big)
-\overrightarrow{rot}\big(\overrightarrow{rot}\,\overrightarrow{U}\big)}`$
$`\;\;\large{-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=\overrightarrow{0}}`$*      
  <br><br>
  ou écrit avec le laplacien vectoriel :   
  <br><br>
  **$`\large{\Delta\,\overrightarrow{U}-\dfrac{1}{\mathscr{v}^2}\dfrac{\partial^2 \overrightarrow{U}}{\partial t^2}=\overrightarrow{0}}`$**      
  <br><br>
  **alors le champ vectoriel $`f`$ se propage** *à la célérité $`\mathscr{v}`$*.







