---
title: Exemple de structure possible sur le thème "Electromagnétisme"
published: true
routable: true
visible: false
lessons:
    - slug: structure-example-123-electromagnetism
      order: 3
    - slug: structure-example-234-electromagnetism
      order: 2
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\oint{\displaystyle\mathop{{\int}\mkern-16mu \scriptsize \bigcirc}}`$

#### Tips for thinking about the structuring of this level 3

This is the **equivalent of the first or two years at university**.
There is a big jump with the lower level. But we are not limited
to a number of hours or pages. We can make a quiet and controlled progression
even inside this level 3.

The high school is not homogeneous, there are sectors, specialties and options, and moreover
programs also vary by country and time. Certain mathematical tools
level N3 can be seen already in high school. Conversely, it is possible that certain themes
of our N2 level, are not seen in high school. **Think these levels 2 and 3 freely and**
**without leading references**.

Even within a level, you have to be very progressive, we have the space for that.
The gap should not be too large from one level to another, so as not to demotivate
students.


##### The blocks

In this level 3, **blocks** are important because they **allow to differentiate**
**students**. For example we can make an electrostatic block for
students who wish to stop at this level 3 in electromagnetism. This may be
a block with only direct calculations, and the notion of electric dipole. But
without Gauss's theorems and the divergence operator, which will be put in another
block for students who must prepare the mastery of the equations of
Maxwell's electromagnetism at level 4.

Later we can associate a metadata in the file, to select certain
blocks and offer specific educational circuits according to the student's wishes.

So use the blocks to **target the different pre-specialties** within
of this level 3.

Note: A block, which can contain several chapters and many figures, can be
quite heavy, but the estimate is that a block displayed in a presentation mode,
is displayed relatively quickly in 4G (even without wifi connection). A block will match
most likely to 1 web page of M3P2, otherwise 2 or 3.

--------------------------------------------------------------------------------

##### Color coded blocks in this design step:

!! BLOCK: all students entering this level 3

!!!! BLOCK students who will have to master Maxwell's electromagnetism at level 4

--------------------------------------------------------------------------------

#### An example of what to do in terms of structure: level 3

!! *BLOCK ELMAG3-1*
!!
!! *Possible title* : Conceptual diagram of electromagnetism
!!
!! *Short description* :   
!! An introduction to levels 3 and 4 of teaching electromagnetism
!! intended for physicists and others who will need to master Maxwell's equations.
!! And a learning guide on levels 3 and 4.
!!
!! *Program elements, or structuring in chapters* :
!! * give a general vision of electromagnetism, the cycle:    
!! moving charges    
!! $`=`$ (4 Maxwell equations) $`\Longrightarrow`$    
!! Lorentz forces on charges       
!! $`=`$ (Dynamic $`\overrightarrow{dp} = \overrightarrow F} dt) \Longrightarrow`$   
!! modification of the movement of charges.   
!! * area of ​​validity
!! * brief history
!! * learning guide for level 3 and blocks for all at level 4 :
! why first electrostat, magnetosta,
!! why mathematical tool divergence, rotational, etc ..., <br>
!! difference between electromag in vacuum, and in matter (averages of the fields
!! in mesoscopic volumes), ...
!!
!! *For whom?* : All, at this level 3.

--------------------------------------------------------------------------------

!! *BLOCK ELMAG3-2*
!!
!! *Possible title* : Introduction to electromagnetic phenomena
!!
!! *Short description* : A general view of electromagnetic phenomena
!! of level N3, by privileging the phenomenological study with the mathematical tool
!! level N3 deprived of the divergence and rotational tools (we can cite them and give
!! intuitive meaning, but go no further) necessary to
!! Maxwell's electromagnetism.
!!
!! *Program elements, or structuring in chapters* :
!! The causes of the electric field (static: charges; and variable: B variable,
!! therefore in particular variable currents, moving currents and magnets).
!! The causes of the magnetic field (static: constant currents; and variable E variable,
!! therefore in particular variable currents, moving currents and magnets).
!!
!! *For whom?* : all (physics, biology, ecology, etc.) at level N3.

--------------------------------------------------------------------------------

!! *BLOCK ELMAG3-3*
!!
!! *Possible title* : Electrostatics in vacuum: direct calculations
!!
!! *Short description* : Electrostatic: E and V, with integral relation (circulation)
!! and local (gradient) between E and V. Direct calculations of E created by loads, and
!! of F induced by E on charges, introduction to the electric dipole
!! (force and moment which is exerted on it, and field E which it creates at great distance).
!!
!! *Program elements, or structuring in chapters* :
!!
!! *For whom?* : All (physics, biology, ecology, etc.) at level N3.

--------------------------------------------------------------------------------

!!!! *BLOCK ELMAG3-4*
!!!!
!!!! *Possible title* : Electrostatics in vacuum: first steps towards Maxwell's equations
!!!!
!!!! *Short description* : Gaussian theorem (integral and local) and all the tool
!!!! conceptual and associated mathematics: symmetries, vectors and pseudo vectors, divergence,
!!!! rotational, Laplacian, Poisson equation
!!!!
!!!! *Program elements, or structuring in chapter* :
!!!! finalize $`div \overrightarrow{E} = \ ho / \epsilon_0`$, but also
!!!! $`\overrightarrow{rot} \overrightarrow{E} = \ overrightarrow{0}`$
!!!! and $`\Delta V = \rho / \epsilon_0`$
!!!!
!!!!
!!!! *For whom?* : Physicists and others who will have to master Maxwell's equations.

--------------------------------------------------------------------------------

!! *BLOCK ELMAG3-5*
!!
!! *Possible title* : Conductive media (subject to stationary E)
!!
!! *Short description* : conductive & semiconductor media, bound charges
!! AND presence of free charges, thermal speed.
!! Materials (solid) cond. and semi-cond subjected to stationary E: drift speed, notion of hole
!! Cond. participating in a closed conductive circuit: current volume density vector,
!! then surface, intensity, resistivity-conductivity (local prop) and resistance,
!! Ohm's law (local and integral), charge conservation equation (all see
!! or review the discrepancy here)
!! Cond. isolated: external / internal / total electric field, transient: external E field => free charges
!! on the surface, equilibrium => Etotal = 0 => equipotential & volume density of zero charge
!! (phenomenological justification, and by Th Gauss cited for all)
!! towards Faraday cage and EM waves (even if it is variable E)
!!
!! *Idea* : it is for everyone at level 3. If it is too detailed for some, it is
!! remains a description of this theme at level 2
!!
!! *Program elements, or structuring in chapters* :
!!
!! *For whom?* All at level 3.

--------------------------------------------------------------------------------

!! *BLOCK ELMAG3-6*
!!
!! *Possible title* : Dielectric media 1 (subjected to stationary Eext)
!!
!! *Short description* : Short description: dielectric medium, dipole moment
!! electric, phenomena at the origin of dipole moments, polarization vector,
!! electronic, atomic and orientation polarization, E and P relationship, LHI media:
!! susceptibility, uniform, non-uniform polarization, volume density of charges
!! polarization, surface density of polarization charges, dielectric / conductor interface
!! with isotropic / anisotropic dielectric, electric induction vector, links between D, E, P, ε, ε_0, ε_r, χe
!! (all this for E stationary, but in "beyond, we indicate that it will depend on the frequency
!! of field E => N4)
!!
!! *Idea* : it is for everyone at level 3. If it is too detailed for some, it is
!! remains a description of this theme at level 2
!!
!! *Program elements, or structuring in chapters* :
!!
!! *For whom?* All at level 3.

--------------------------------------------------------------------------------

!!!! *BLOCK ELMAG3-7*
!!!!
!!!! *Possible title* : Dielectric media 2 (subjected to stationary Eext)
!!!!
!!!! *Short description* : Gaussian theorem (integral and local) expressed
!!!! with E, then with D
!!!!
!!!! *Program elements, or structuring in chapters* :
!!!!
!!!!
!!!! *For whom?* : Physicists and others who will have to master Maxwell's equations
!!!! in matter and at interfaces

--------------------------------------------------------------------------------

!! *BLOCK ELMAG3-8*
!!
!! *Possible title* : Capacitors (subject to stationary E)
!!
!! *Short description* : Conductors in total influence - capacitors
!! - capacity - with and without dielectric - series and in parallel - energy - and?
!!
!! *Program elements, or structuring in chapter* :
!!
!! *For whom?* : All at level 3.

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-9*
!!
!! *Titre possible* : Magnétostatique  dans le vide : calculs directs
!!
!! *Description succincte :*  B (induction) et, H!(excitation) et calculs directs 
!! divers,<br>
!! Les causes du champ magnétique, calculs directs de B/H (fil infini et 
!! que peut-on dire de B/H créé par une nappe de courant, par boucle de courant circulaire 
!! en un point de son axe, et loin de la boucle (analogie avec E, car pas B=rotA), et
!! invariance par rapport à la forme exacte de la boucle dans son plan. Notion de
!! dipôle magnétique.<br>
!! Les effets de B : calculs de forces induites par B, entre 2 conducteurs rectilignes
!! infinis parcouru par I cst, force et moment exercés par B sur une boucle circulaire 
!! rigide de courant, vers l'action d'un B sur un dipôle magnétique.
!!
!! *Idée* : c'est pour tous au niveau 3. Si c'est trop détaillé pour certains, il
!! reste une description de ce thème au niveau 2
!!
!!  *Eleménts de programme, ou structuration en chapitre* :
!!
!! *Pour qui ?* tous au niveau 3

--------------------------------------------------------------------------------

!!!! *BLOC ELMAG3-10* 
!!!!
!!!! *Titre possible* : Magnétostatique dans le vide : premiers pas vers les équations 
!!!! de Maxwell
!!!!
!!!! *Description succincte :*  Théorème d'Ampères (intégral et local) et tout l'outil 
!!!! conceptuel et mathématique divergence, rotationnel, nécessaire aux équations de
!!!! Maxwell , B = rot (A), lien entre A et j, retour sur champ B/H créé par boucle
!!!! circulaire de courant loin ed la boucle.
!!!! 
!!!! *Eleménts de programme, ou structuration en chapitre* :
!!!! établir au final $`rot\overrightarrow{H}=\overrightarrow{j}`$ / 
!!!! $`rot\overrightarrow{B}=\mu_0\overrightarrow{j}`$ ET $`\oint \overrightarrow{B}\cdot\overrightarrow{dS}=0`$,
!!!! Pointer la différence entre $`\displaystyle\int`$ et $`\oint`$ : cas du champ magnétique.
!!!!
!!!! *Pour qui ?* physiciens et autres qui devront maîtriser les équations de Maxwell.

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-11* 
!!
!! *Titre possible* : Les milieux magnétique 1 (soumis à Bext stationnaire)
!!
!! *Description succincte :*  milieux magnétiques, moment magnétiques : orbital et de spin,
!! aimantation M, aimantation : approche ampérienne à ce niveau N3, 
!! aimantation non uniforme => vecteur densité volumique de courants d'aimantation ,
!! uniforme/non uniforme => vecteur densité surfacique de courant d'aimantation,
!! paramagnétisme/diamagnétisme/ferromagnétisme.
!! liens entre H, B, M ,μ, μ_0, μ_r, χ_m, dans milieux LHI ou non
!!
!! *Idée* : c'est pour tous au niveau 3. Si c'est trop détaillé pour certains, il
!! reste une description de ce thème au niveau 2
!!
!! *Eleménts de programme, ou structuration en chapitre* :
!!
!! *Pour qui ?* tous au niveau 3

--------------------------------------------------------------------------------

!!!! *BLOC ELMAG3-12* 
!!!!
!!!! *Titre possible* : Les milieux magnétique 2 (soumis à Bext stationnaire)
!!!!
!!!! *Description succincte :*  théorème d'Ampère en fonction de B , puis de H 
!!!!
!!!! *Pour qui ?* physiciens et autres qui devront maîtriser les équations de Maxwell
!!!! dans la matière et aux interfaces

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-13* 
!!
!! *Titre possible* : Phénomènes d'induction électromagnétique : premiers pas
!!
!! *Description succincte :*   Pour ceux qui en resteront à ce niveau 3, sans atteindre
!! les équations de Maxwell.
!!
!! *Eleménts de programme, ou structuration en chapitre* :
!! le couplage électromagnétique,
!! force électromotrice $`e=-d\Phi/dt`$ et conséquences.
!!
!! *Pour qui ?* tous au niveau 3

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-14* 
!!
!! *Titre possible* : Les ondes électromagnétiques : premiers pas
!!
!! *Description succincte :*   Pour ceux qui en resteront à ce niveau 3, sans atteindre
!! les équations de Maxwell. 
!!
!! *Eleménts de programme, ou structuration en chapitre* :
!!  Description des ondes électromagnétiques.
!!  En lien très fort avec un autre thème à ouvrir
!!  sur les "ondes" à construire (les ondes en générales, qui se diversifieront au fur et à mesure que
!!  l'on monte dans les niveaux)
!!
!! *Pour qui ?* tous au niveau 3

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-15* 
!!
!! *Titre possible* : Selfs et transformateurs
!!
!! *Description succincte :*   bobine=solénoïde=self - inductance - 
!! avec et sans noyau ferromagnétique - série et  parallèle - énergie - et ?
!!
!! *Idée* : c'est pour tous au niveau 3. Si c'est trop détaillé pour certains, il
!! reste une description de ce thème au niveau 2
!!
!! *Eleménts de programme, ou structuration en chapitre* :
!!
!! *Pour qui ?* tous au niveau 3

--------------------------------------------------------------------------------

!!!! *BLOC ELMAG3-16* 
!!!!
!!!! *Titre possible* : Interfaces, diodes et transistors ?
!!!!
!!!! *Description succincte :*   
!!!!
!!!! *Pour qui ?* physiciens, électroniciens, Télécoms

--------------------------------------------------------------------------------

!! *BLOC ELMAG3-17* 
!!
!! *Titre possible* : Les circuits électriques
!!
!! *Description succincte :*   Générateurs de tension, générateurs de courant, 
!! récepteurs. Lois de Kirchhoff, théorème de superposition, théorème de Thévenin, 
!! théorème de Norton. Relation de Millman.
!! Les courants variables et les courants alternatifs dans
!! l’approximation des régimes quasi–stationnaires.
!! Régimes propres, régimes transitoires, constante de temps, régime forcé. 
!! Représentation de Fresnel, utilisation des complexes, puissance en alternatif, résonance.
!! Utilisation des complexes, charge et décharge d’un condensateur, ponts en alternatif, 
!! circuits LC, RLC
!!
!! *Idée* : c'est pour tous au niveau 3. Si c'est trop détaillé pour certains, il
!! reste une description de ce thème au niveau 2
!!
!! *Eleménts de programme, ou structuration en chapitre* :
!!
!! *Pour qui ?* tous au niveau 3

--------------------------------------------------------------------------------

autres
