---
title: Les ondes
published: true
routable: true
visible: false
lessons:
    -
      slug: energy-mix-hydroelectricity-2
      name: TD4 : Hydroélectricité
      order: 3
    -
      slug: TD4-hydroelectricity-energy-efficiency-values
      name: DÉFINITIONS-2 : TD4 et grandeurs d'efficacité énergétique
      order: 3
---

<!--Commandes Latex spécifiques
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
-->

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-1_L1200.jpg)<details>
<summary>Etape 1 : Appel à idées</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Mix-énergétique : TD 4

---------------------------


# <p style="font-size:70%;text-align: center;">Les Centrales<br> au fil de l'eau</p>

_Exercice basé sur 5 écluses du canal du Rhône au Rhin déclassé équipées chacune 
depuis 2014 avec une petite-centrale hydroélectrique à vis d'Archimède, et dérivé 
d'un TD donné au Lycée Lavoisier de Mulhouse._

Un *exemple technique de micro-centrale* au fil de l'eau est la **turbine à vis d'archimède**.

![](energy-mix-TD4-hydroelectricity-micro-power-station-1_L1200.jpg)   
_turbine à vis d'archimède travaillant en générateur de courant électrique._


* La turbine à vis d'Archimède est un *type de turbine à action*, bien *adaptée aux basses chutes à débit variable*. 

* La turbine à vis d'Archimède **peut être conçue pour fonctionner en mode STEP**.  
  <br>
  La *turbine* est alors couplée à une installation électrique pouvant fonctionner 
   * soit en *mode alternateur*
   * soit en *mode moteur électrique*. 


![](energy-mix-TD4-hydroelectricity-micro-power-station-2_L1200.jpg)   
_turbine à vis d'archimède travaillant en mode stockage d'énergie potentielle gravitationnelle._

   * Lorsque l'**eau entraîne la rotation de la turbine** par sa chute, l'installation électrique 
   fonctionne en *mode générateur* délivrant ainsi de la puissance électrique.   
   
   * Lorsque la **rotation de la turbine est entraînée en sens inverse** par l'installation 
   électrique fonctionnant en *mode moteur*, l'eau piégée entre les pales est entraînée 
   depuis le bassin bas vers le bassin haut, et elle gagne ainsi en énergie potentielle.

##### Données de l'exercice :

* **Variation mensuelle** *du débit $`\mathbf{Q}`$* (exemple du )canal Rhône au Rhin déclassé) :

---

| &nbsp;&nbsp;&nbsp;&nbsp;**Mois**&nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;janvier&nbsp;&nbsp; | &nbsp;&nbsp;février &nbsp;&nbsp;|&nbsp;&nbsp;&nbsp;&nbsp; mars&nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp;&nbsp;avril &nbsp;&nbsp;&nbsp;&nbsp;|
| :---: | :---: | :---: | :---: | :---: |
| *débit<br> ($`m^3\,s^{-1}`$)* | 6,1 | 5,8 | 4,8 | 3,2 |

   ---
   
 | &nbsp;&nbsp;&nbsp;&nbsp;**Mois**&nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp;&nbsp;mai&nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp;&nbsp;juin &nbsp;&nbsp;&nbsp;&nbsp;| &nbsp;&nbsp;&nbsp;&nbsp; juillet &nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;&nbsp;&nbsp;&nbsp;août &nbsp;&nbsp;&nbsp;&nbsp;|
| :---: | :---: | :---: | :---: | :---: |
| *débit<br> ($`m^3\,s^{-1}`$)* | 2,1 | 1,3 | 0,9 | 0,7 |

   ---
   
| &nbsp;&nbsp;&nbsp;&nbsp;**Mois**&nbsp;&nbsp;&nbsp;&nbsp; | &nbsp;septembre| &nbsp;octobre| &nbsp;novembre| &nbsp;décembre|
| :---: | :---: | :---: | :---: | :---: |
| *débit<br> ($`m^3\,s^{-1}`$)* | 0,8 | 1,3 | 1,9 | 4,7 |

---
<br>

* **Hauteur** de l'écluse : *$`\mathbf{H = 2,2\;m}`$*
* L'installation électrique a une **puissance crête $`\mathbf{P_c}`$** de *$`\mathbf{90}`$ kWh*.
* **Rendement total** de conversion d'énergie mécanique en énergie électrique : *$`\boldsymbol{\mathbf{\eta_{\,conv} = 0,67}}`$*
* **Accélération de la pesanteur** : *$`\mathbf{g \simeq 10\;ms^{-2}}`$*
* **Densité massique de l'eau** : *$`\boldsymbol{\mathbf{\varrho = 1000\;kg.m^{-3}}}`$* 
* Le **coût d'installation** de la micro-centrale est de *$`\mathbf{350\;k}`$€ (*). 
* Le **coût moyen de maintenance annuel** est de *$`\mathbf{20\;k}`$€ (*).
* Le **prix de vente du kWh** électrique est de *$`\mathbf{0,22}`$€*.
* La **maintenance** arrête de la centrale *vingt jours par an*.
* Ces **installations** sont souvent installées en *zone rurale*, donc *pavillonnaire*. 
* 
   _(* : donnée estimée pour l'exercice (sans référence réelle)_

En France, la **consommation électrique moyenne d'un foyer** composé de 4 personnes vivant 
dans une maison de 120 m² et utilisant uniquement de l’électricité est de *$`\mathbf{20 000}`$ kWh* d’électricité.
                                                               

## <p style="font-size:60%;text-align: center;">FONCTION dans le SYSTEME ENERGETIQUE</p>

##### 1. **Capacité de stockage / déstockage** ou *générateur continu* d'énergie<br><br>a)  A laquelle de ces deux classes appartiennent ces centrales de lac?

<details markdown=1><summary>Solution</summary>

* Une **petite centrale hydraulique au fil de l'eau** n'est en général pas précédée d'une retenue d'eau.
Installée dans un lieu de faible dénivelé, une telle retenue d'eau n'aurait pas vraiment de sens 
en terme de capacité de stockage d'énergie sous forme gravitationnelle ; sa présence résulterait 
plutôt d'une volonté de préserver des habitats en cas de crue, ou de faire des réserves d'eau pour 
l'irrigation en période de sécheresse. Ainsi une petite centrale n'a 
*pas de fonction de stockage /déstockage d'énergie*.

* Par contre, la turbine d'une petite centrale au fil de l'eau est **alimenté en continue par le débit d'un cours d'eau**,
subissant *certes des variations mensuelles*, mais relativement *stable sur la semaine*.

* Elle jour plus le **rôle d'un générateur continu** d'électricité dans la chaine industrielle énergétique.

</details>

<br>

##### b)  Calculer la puissance électrique produite moyennée sur une année de fonctionnement

* Le **débit annuelle moyen annuelle** est, en négligeant la légère variation de durée des  
      différents mois :  
 
**$`\boldsymbol{\mathbf{Q_{moy}(1\,an)}}`$** $`\,=\dfrac{6,1+5,8+4,8+3,2+2,1+1,3+0,9+0,7+0,8+1,3+1,9+4,7}{12}`$

**$`\hspace{1,6cm}=\dfrac{33,6}{12}\mathbf{=2,8\,m^3s^{-1}}`$**

<br>

* La **puissance électrique moyenne annuelle** est :

**$`\boldsymbol{\mathbf{P_{moy}^{1\,an}=\eta_{tot}\times
\big(
\varrho_{eau}\times Q_{moy}^{1\,an}\times H\times g\big)}}`$**

$`\hspace{1,6cm} = 0,67 \times 10^3 \times 2,8 \times 2,2 \times 10`$

**$`\hspace{1,6cm}\mathbf{=41,3\times 10^3\;J\,s^{-1}}`$**

---



