---
title: "Application du théorème d'Ampère intégral : méthode"
published: true
routable: true
visible: false
lessons:
    -
        slug: magnetostatics-ampere-application-method-3
        name: LINÉAIRE : Théorème d'Ampère : méthode générale
        order: 2
    -
        slug: ampere-integral-cylindrical-symmetry-wire-3-method
        name: LINÉAIRE : Ampère intégral et câbles rectilignes coaxiaux
        order: 3
    -
        slug: ampere-integral-cylindrical-symmetry-solenoid-3-method
        name: LINÉAIRE : Ampère intégral et solénoïdes
        order: 3
    -
        slug: ampere-integral-cylindrical-symmetry-toroidal-coil-3-method
        name: LINÉAIRE-3 : Ampère intégral et bobines toriques
        order: 3
    -  
        slug: ampere-integral-demonstration-towards-application
        name: PARALLÈLE : Ampère intégral, démonstration vers application
        order: 3
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Loiint{\displaystyle\mathop{{\iint}\mkern-22mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-6_L1200.jpg)<details>
<summary>Etape 6 : Relecture</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------

### Forme intégrale

#### Introduction :

Soit une *distribution de courants constants* dans l'espace, décrite par un champ de vecteur densité volumique de courants $`\overrightarrow{j}`$.

Le **Théorème d'Ampère intégral** démontre que la circulation $`\mathcal{C}_B`$ 
du vecteur champ magnétique $`\overrightarrow{B}`$ le long de toute 
*ligne fermée orientée $`\Gamma`$* dans l'espace est égal la constante magnétique 
du vide $`\mu_0`$ multipliée par la somme algébrique des intensités des courants électriques $`\displaystyle\sum_{S\leftrightarrow\Gamma}\,\overline{I}`$ 
qui traversent toute *surface ouverte orientée $`S`$ qui s'appuie sur  $`\Gamma`$*, 
et telle que les *orientations de $`\Gamma`$ et $`S`$*
soient *liées par la règle de la main droite* d'orientation de l'espace.   


**$`\displaystyle\large{\mathbf{\quad\oint\limits_{\Gamma_{or.}}\vec{B}\cdot\vec{dl}\; =\;\mu_0\,\iint\limits_{S_{or.}\leftrightarrow \Gamma_{or.}}\vec{j}^{3D}\cdot\vec{dS}}}`$**   
<br>
$`\hspace{4.9cm}\text{OU}`$   
<br>
**$`\displaystyle\large{\mathbf{\quad\hspace{3.1cm}=\;\mu_0\,\sum\limits_{S_{or.}\leftrightarrow \Gamma_{or.}}\,\overline{I}}}`$**

Le théorème d'Ampère intégral **s'applique avec**, quelque soit le niveau de modélisation et d'approximation des distributions de courants :
*  un *vecteur densité volumique de courants $`\overrightarrow{j}^{3D}`$*.

mais aussi 
*  un *vecteur densité surfacique de courants $`\overrightarrow{j}^{2D}`$*, lorsque les courants sont confinés
en surface sur une profondeur que la modélisation 2D néglige. Il faut alors bien sûr *adapter le théorème d'Ampère*
pour passer d'une densité volumique de courant à une densité surfacique.
*  un vecteur densité linéïque de courants $`\dens^{1D}`$, lorsque les courants sont confinés dans un circuit dont la modélisation 1D néglige la section droite.   
   Dans ce cas, ce *courant* linéïque est représenté par un *simple nombre réel $`\overline{I}`$*  de signe positif si il traverse la surface $`S`$ dans son sens d'orientation
positif, et de signe négatif dans le cas contraire.

!!!!! *Terminologie* : une section droite est une section perpendiculaire à la direction longitudinale.

C'est d'ailleurs ce théorème d'Ampère intégral qui **démontre les discontinuités du champ magnétique** 
*à la traversée d'une nappe de courants* à cette étape contrefort, et que seront démontrées 
les relations de continuité des champs d'induction $`\overrightarrow{B}`$ et d'excitation $`\overrightarrow{H}`$ 
magnétiques à l'étape suivante de montagne, en électromagnétisme dans le vide et dans la matière.

Ces **résultats concernant la discontinuité** du champ magnétostatique à la traversée 
d'une nappe de courants sont *nécessaires si le théorème d'Ampère local est utilisé* 
pour calculer le champ  $`\overrightarrow{B}`$ en tout point de l'espace *avec modélisation 2D* de la distribution de courants.

<br>

-------------------------

#### 2° étape : Choix du contour d'Ampère, de son orientation, et calcul de la circulation

Le théorème d'Ampère permet de calculer le champ magnétique en un point $`M`$ quelconque, 
donc en tout point $`M`$ de l'espace.

À cette **étape 2**, l'intérêt se porte sur le **premier terme du théorème d'Ampère**. 
Il s'agit d'*identifier le contour d'Ampère*
$`\mathcal{\Gamma}_A`$, de *l'orienter* puis de *calculer la circulation* de $`\overrightarrow{B}`$ le long de ce contour.       
<br>
**ÉTAPE 2 :**   
<br>
**$`\displaystyle\large{\mathbf{\quad\oint\limits_{\Gamma_{or.}}\vec{B}\cdot\vec{dl}}}`$**
*$`\displaystyle\large{\mathbf{\; =\;\mu_0\,\iint\limits_{S_{or.}\leftrightarrow \Gamma_{or.}}\vec{j}^{3D}\cdot\vec{dS}}}`$*   
<br>
$`\hspace{4.9cm}\text{OU}`$   
<br>
*$`\displaystyle\large{\mathbf{\quad\hspace{3.1cm}=\;\mu_0\,\sum\limits_{S_{or.}\leftrightarrow \Gamma_{or.}}\,\overline{I}}}`$*


##### Éléments physiques conduisant au choix du contour

Si le théorème d'Ampère est vrai quelque-soit le contour fermé considéré, aussi complexe soit-il, 
il ne peut nous aider à calculer le champ magnétique $`\overrightarrow{B}`$ dans tout l'espace 
que si chacun de ses termes est facile à calculer.

C'est l'**expression du champ magnétique** déduite de l'étude des symétries et invariances 
qui *permet de déterminer le contour d'Ampère* adapté.

Le calcul de la circulation de $`\overrightarrow{B}`$ le long du contour d'Ampère orienté $`\mathcal{\Gamma}_A`$ 
nécessite de calculer en chacun de ses éléments de longueur $`dl`$ constitutifs le 
produit scalaire $`\overrightarrow{B}\cdot\overrightarrow{dl}`$.

Un **contour d'Ampère adapté** sera donc un contour d'Ampère qui **vérifie 3 conditions** :

* *Les éléments vectoriels de longueur $`\overrightarrow{dl}`$ vérifient* :

   * **$`\mathbf{\overrightarrow{dl}\parallel\overrightarrow{B}}`$**, car alors le produit 
scalaire se résumera au simple produit des composantes selon $`\beta`$ de chacun de ces vecteurs.    
Si  $`\overrightarrow{B}=B_{\beta}(\alpha)\;\overrightarrow{e_{\beta}}`$ et si $`\overrightarrow{dl}=dl\;\overrightarrow{e_{\beta}}`$, alors :   
*$`\mathbf{\overrightarrow{dl}\parallel \overrightarrow{B} \Longrightarrow\overrightarrow{dl}\cdot \overrightarrow{B}}`$*
$`= \left(dl\;\overrightarrow{e_{\beta}}\right)\cdot \left( B\;\overrightarrow{e_{\beta}}\right)`$   
$`\hspace{4.5cm}=  B\;dl \times ( \underbrace{\overrightarrow{e_{\beta}}\cdot \overrightarrow{e_{\beta}}}_{=\;1})`$
*$`\hspace{4.5cm}\mathbf{=  B\; dl}`$*


   * **$`\mathbf{\overrightarrow{dl}\perp\overrightarrow{B}}`$**, car alors le produit scalaire est nul :   
*$`\mathbf{\overrightarrow{dl}\perp\overrightarrow{B}\Longrightarrow\overrightarrow{B}\cdot\overrightarrow{dl}=0}`$*.   
! *Note* : l'ensemble des éléments vectoriels de longueur $`\overrightarrow{dl}`$ du contour d'Ampère
! $`S\Gamma_{A\,or.}`$ ne doivent pas vérifier $`\overrightarrow{dl}\perp\overrightarrow{B}`$, sinon tu aurais 
! $`\displaystyle\oint_{\Gamma_{A\,or.}} \overrightarrow{B}\cdot\overrightarrow{dl}=0`$ et 
! le théorème d'Ampère se limiterait au résultat $`0=0`$, résultat vrai mais qui n'aiderait pas au calcul
! du champ magnétique.

* **En chaque point $`P`$** du contour d'Ampère 
**où $`\overrightarrow{dl}\parallel\overrightarrow{B}`$**, le champ magnétique 
**$`\overrightarrow{B}`$** a une même valeur unique, une**valeur constante , ou une valeur nulle**.   
<br>
En effet, le *théorème d'Ampère* est une *équation unique*, qui ne doit donc 
contenir qu'*une seule inconnue*, la valeur non nulle et constante de 
$`\overrightarrow{B}`$ lorsque $`\overrightarrow{dl}\parallel\overrightarrow{B}`$.

! *Note* :    
! Cette remarque est indispensable pour le calcul de $`\overrightarrow{B}`$
! créé par un plan infini parcouru par un vecteur densité de courant uniforme.  
!
! Il faudra alors considérer un élément de symétrie supplémentaire par rapport à 
! l'étude d'une distribution de charge à symétrie cylindrique ou sphérique.

<!-----------
Par ailleurs le **théorème d'Ampère'** est une **équation unique** qui, une fois 
le produit scalaire $`\overrightarrow{B}\cdot\overrightarrow{dl}`$ réalisé sur 
chaque $`dl`$, relie la composante $`B=B_{\beta}(\beta)`$ à un courant. Il *ne doit donc y avoir qu'une seule inconnue*, 
$`B=B_{\beta}(\alpha)`$ dans l'exemple considéré. 
--------------->

!!! *Contre-exemple* :   
!!! 
!!! Supposons que dans un repère de l'espace
!!! $`(O, \overrightarrow{e_{\alpha}},\overrightarrow{e_{\beta}},\overrightarrow{e_{\gamma}})`$,
!!! les symétries et invariances nous indiquent que le champ magnétique est de la forme 
!!! $`\mathbf{\overrightarrow{B}=B_{\beta}\,(\alpha)\,\overrightarrow{e_{\beta}}}`$.
!!!
!!! Utilisons le théorème d'Ampère pour déterminer le champ en un point $`M`$ quelconque de 
!!! coordonnées $`(\alpha_M, \beta_M, \gamma_M)`$
!!! avec l'indice $`M`$ ici précisé pour la démonstration. Le contour d'Ampère doit 
!!! nécessairement contenir le point $`M`$, 
!!! donc l'un de ses éléments de longueur doit avoir pour coordonnées
!!!  $`dl=dl(\alpha_M, \beta_M, \gamma_M)`$.
!!!
!!! Choisissons un contour fermé d'Ampère dont en chacun de ses points de coordonnées
!!!  $`(\alpha, \beta, \gamma)`$    
!!! les éléments de longueur $`dl=dl(\alpha, \beta, \gamma)`$ qui vérifient 
!!! $`\overrightarrow{dl}\parallel\overrightarrow{B}`$ 
!!! se classent en deux catégories :       
!!!   * $`dl=dl(\alpha, \beta_M, \gamma)`$ avec $`\beta_M`$ _coordonnée_ $`\beta`$ du point $`M`$.
!!!   * $`dl=dl(\alpha, \beta_0, \gamma)`$ avec $`\beta_0\ne\beta_M`$.
!!!
!!! Les circulations élémentaires $`\overrightarrow{B}\cdot\overrightarrow{dl}`$ en chaque point du contour
!!! d'Ampère se classeront aussi en deux catégories, à savoir :   
!!! * $`\overrightarrow{B}(\alpha, \beta_M, \gamma)\cdot\overrightarrow{dl}(\alpha, \beta_M, \gamma)`$.
!!! * $`\overrightarrow{B}(\alpha, \beta_0, \gamma)\cdot\overrightarrow{dl}(\alpha, \beta_0, \gamma)`$.
!!!
!!! Le champ magnetique étant inconnu (c'est l'objectif du théorème d'Ampère de le calculer), deux inconnues de !!! champ apparaîtraient dans le calcul de la circulation de 
!!! $`\overrightarrow{B}`$ _le long du contour d'Ampère_ $`\mathcal{\Gamma}_A`$ :
!!! * inconnue 1 : $`B_{\beta}(\beta_M)`$.
!!! * inconnue 2 : $`B_{\beta}(\beta_0)`$.   
!!!
!!! Au final, l'équation unique composant le théorème d'Ampère ne permettrait pas alors de calculer 
!!! $`\overrightarrow{B}`$.


!!!! *Attention* :   
!!!! *Ne pas confondre composante et amplitude* de $`\overrightarrow{B}`$.   
!!!! *Faire attention aux signes*.
!!!! 
!!!! Lorsque nous écrivons d'un vecteur $`\overrightarrow{U}=U\;\overrightarrow{e_U}`$ , avec $`\overrightarrow{e_U}=\dfrac{\overrightarrow{U}}{\lVert \overrightarrow{U} \rVert}`$,    
!!!! $`U`$ est ici la composante de $`\overrightarrow{U}`$.   
!!!!    * la *composante $`U`$* peut être *positive ou négative*.
!!!!    * l'*amplitude ou norme $`\lVert \overrightarrow{U} \rVert`$* est *toujours positive*.
!!!!
!!!! L'étude des *symétries et invariances* d'une distribution de courants ne donne que la direction, mais elle *n'indique pas le sens* de $`\overrightarrow{B}`$,. 
!!!!
!!!! En physique : *1 direction = 2 sens possibles*
!!!!
!!!!
!!!! Le *théorème d'Ampère* permet de calculer $`\overrightarrow{B}`$, et par conséquent *détermine aussi le sens* de  $`\overrightarrow{B}`$. 
!!!! Pour cela il faut précisément *respecter les signes* :
!!!!    * signe $`+`$ ou $`-`$ devant une composante (dont la valeur, déterminée par la suite, pourra elle-même être positive ou négative).
!!!!    * signes $`+`$ ou $`-`$ des charges dans la distribution.
!!!!
!!!! *Les erreurs de signe*, par omission ou par négligence, *sont des erreurs fréquentes*.


<br>

---------------------------------

#### 3° étape : Calcul du l'intensité (en valeur algébrique) du courant traversant une surface d'Ampère adaptée

Cette **étape 3** consiste dans le **deuxième terme du théorème d'Ampère** à
*identifer et calculer l'intensité (en valeur algébrique) du courant traversant une surface d'Ampère adaptée* à travers une surface d'Ampère $`S_A`$ qui s'appuie
sur le contour d'Ampère $`\Gamma_A`$, et d'orientation compatible avec l'orientation choisie pour $`\Gamma_A`$ selon
la règle d'orientation de la main droite.   
<br>
**ÉTAPE 3 :**   
<br>
*$`\displaystyle\large{\mathbf{\quad\oint\limits_{\Gamma_{or.}}\vec{B}\cdot\vec{dl}\,=}}`$*
**$`\displaystyle\large{\mathbf{\;\mu_0\,\iint\limits_{S_{or.}\leftrightarrow \Gamma_{or.}}\vec{j}^{3D}\cdot\vec{dS}}}`$**   
<br>
$`\hspace{4.9cm}\text{OU}`$   
<br>
**$`\displaystyle\large{\mathbf{\quad\hspace{3.1cm}=\;\mu_0\,\sum\limits_{S_{or.}\leftrightarrow \Gamma_{or.}}\,\overline{I}}}`$**

C'est la **connaissance de la distribution de courants**, cause du champ magnétique étudié, qui *permet de déterminer la surface d'Ampère* adaptée. 

Le calcul du flux de $`\overrightarrow{j}`$ à travers la surface d'Ampère orientée $`S_{A\,or.}`$ nécessite de calculer en chacun de ses éléments de surface $`\overrightarrow{dS}`$ le produit scalaire $`\overrightarrow{j}\cdot\overrightarrow{dS}`$

Une **surface d'Ampère adaptée** sera donc une surface dont les **éléments vérifient 2 conditions** :

* **$`\mathbf{\overrightarrow{dS}\parallel\overrightarrow{j}}`$**, car alors le produit 
scalaire se résumera au simple produit des composantes selon $`\alpha`$ de chacun de ces vecteurs.    
Si  $`\overrightarrow{j}=j_{\alpha}(\gamma)\;\overrightarrow{e_{\alpha}}`$ et si $`\overrightarrow{dS}=dS\;\overrightarrow{e_{\alpha}}`$, alors :   
*$`\mathbf{\overrightarrow{dS}\parallel \overrightarrow{j} \Longrightarrow\overrightarrow{dS}\cdot \overrightarrow{j}}`$*
$`= \left(dS\;\overrightarrow{e_{\alpha}}\right)\cdot \left( j\;\overrightarrow{e_{\alpha}}\right)`$   
$`\hspace{4.5cm}=  j\;dS \times ( \underbrace{\overrightarrow{e_{\alpha}}\cdot \overrightarrow{e_{\alpha}}}_{=\;1})`$
*$`\hspace{4.5cm}\mathbf{=  j\; dS}`$*


* **$`\mathbf{\overrightarrow{dS}\perp\overrightarrow{j}}`$**, car alors le produit scalaire est nul :   
*$`\mathbf{\overrightarrow{dS}\perp\overrightarrow{j}\Longrightarrow\overrightarrow{j}\cdot\overrightarrow{dS}=0}`$*.   
! *Note* : l'ensemble des éléments de surface $`\overrightarrow{dS}`$ de la surface d'Ampère
! $`S_{A\,or.}`$ ne doivent pas vérifier $`\overrightarrow{dS}\perp\overrightarrow{j}`$, sinon tu aurais 
! $`\displaystyle\iint_{S_{A\,or.}} \overrightarrow{j}\cdot\overrightarrow{dS}=0`$ et 
! le théorème d'Ampère se limiterait au résultat $`0=0`$, résultat vrai mais qui n'aiderait pas au calcul
! du champ magnétique.

<!----------
En genéral, il n'y a pas de fonction mathématique décrivant la densité volumique de 
courant $`\overrightarrow{j}^{3D}`$ dans tout l'espace.
------------->
<br>

-----------------------------------------

#### 4° étape, finale  : Calcul de $`\overrightarrow{B}`$

Cette **étape 4** consiste à **réaliser l'égalité** entre le *premier terme de champ* et le *deuxième terme de courant* du théorème d'Ampère, pour en **déduire l'expression du champ magnétique $`\overrightarrow{B}`$**.   
<br>
**ÉTAPE 4 :**   
<br>
*$`\displaystyle\large{\mathbf{\quad\oint\limits_{\Gamma_{or.}}\vec{B}\cdot\vec{dl}\,=}}`$*
*$`\displaystyle\large{\mathbf{\;\color{brown}{\mu_0}\,\iint\limits_{S_{or.}\leftrightarrow \Gamma_{or.}}\vec{j}^{3D}\cdot\vec{dS}}}`$*   
<br>
$`\hspace{4.9cm}\text{OU}`$   
<br>
*$`\displaystyle\large{\mathbf{\quad\hspace{3.1cm}=\;\color{brown}{\mu_0}\,\sum\limits_{S_{or.}\leftrightarrow \Gamma_{or.}}\,\overline{I}}}`$*


!!!! *ATTENTION* : l'erreur la plus courante à ce stade est d'oublier la perméabilité magnétique du vide $`\mu_0`$, aussi appelée constante magnétique.





