---
title: cylindrical coordinates
published: true
routable: true
visible: false
lessons:
     - 
        slug: cartesian-cylindrical-spherical-coordinates
        name: PARALLÈLE : Coordonnées cartésienne, cylindrique et sphérique
        order: 2
     -
        slug: cylindrical-coordinates-linear
        name : LINÉAIRE : Les coordonnées cylindriques
        order:2
     - 
        slug: gauss-integral-cylindrical-symmetry-3-mathtool
        name: OUTIL-MATH : Gauss intégral et charges cylindriques
        order: 1
---

<!--caligraphie de l'intégrale double curviligne-->
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

<!--MétaDonnée : INS-1°année-->

<!-- Partie synthèse $`\longleftarrow`$ Coordonnées cylindriques N3 -->

##### Niveau Contreforts :&nbsp; _toute spécialité_

---------------------------

#### Que sont les coordonnées cylindriques ?

* 3 coordonnées *spatiales* : **$`\mathbf{\rho\;,\;\varphi\;,\;z}`$**

* définies à partir du **système de référence** des *coordonnées cartésiennes associées*.

* **$`\mathbf{\rho}`$** et **$`\mathbf{z}`$** sont des *longueurs*, de coordonnées SI : le mètre *($`\mathbf{m}`$)*.

* **$`\mathbf{\varphi}`$** est un *angle* exprimés en radian *($`\mathbf{rad}`$)*.


![](cylindrical_coordinates_definition_L1200.gif)

-----
 
#### Quels sont les domaines de variation des coordonnées ?

-----

![](cylindrical_coordinates_variation_range_L1200_v2.gif)

-----

#### Comment passer des cylindriques aux cartésiennes ?

* Méthode : *projeter* le vecteurs $`\overrightarrow{OM}`$ sur l'axe $`Oz`$, sur le plan $`xOy`$ au point $`M_{xOy}`$ 
* puis sur chacun des axes $`Ox`$ et $`Oy`$, *en utilisant les fonctions* trigonométriques *sinus* et *cosinus*.

* $`\Longrightarrow`$
**$`\quad\mathbf{}\left\{\begin{array}{l} \mathbf{ x=\rho\cdot\cos\varphi} \\\mathbf{ y=\rho\cdot\sin\varphi} \\\mathbf{ z=z} \\ \end{array}\right. `$**

------

![](cylindrical_coordinates_projection.png)

------

#### Comment définir le vecteur unitaire associé à chaque coordonnée ?

* Le vecteur unitaire $`\overrightarrow{e_{\alpha}}`$ indique la **direction et le sens de déplacement** d'un point $`M`$ si *seule la coordonnée $`\alpha`$* du point $`M`$ *varie d'une quantité positive infinitésimale $`d\alpha^+`$*.

##### Vecteur unitaire $`\overrightarrow{e_{\varphi}}`$

---------

![](cylindrical_coordinates_unit_vector_phi_definition_L1200_v3.gif)

--------

* Déplacement **$`\mathbf{M(\rho,\varphi,z) \longrightarrow M"(\rho,\varphi+\Delta\varphi^+,z)}`$**<br>
 (avec $`\Delta\varphi^+=\Delta\varphi>0`$)<br>
<br>**$`\Longrightarrow`$ direction et sens** de **$`\mathbf{\overrightarrow{e_{\varphi}}}`$**<br>
$`\Longrightarrow\overrightarrow{e_{\varphi}}`$ : vecteur unitaire tangent en $`M`$ au cercle de rayon $`\rho_M`$ dans le plan $`z_M=const`$, orienté dans le sens des $`\varphi`$ croissants.

* Longueur parcourue : $`l_{\Delta\varphi}`$<br>
 Vecteur déplacement : $`\overrightarrow{MM''}`$

* Déplacement *macroscopique :  $`\mathbf{l_{\Delta\varphi} \ne\, ||\overrightarrow{MM''}||}`$*.
* Déplacement **infinitésimal : $`\mathbf{dl_{\varphi}=\,||\overrightarrow{MM''}||}`$**.
 
* Cas général ($`d\varphi=d\varphi^+>0`$  ou $`d\varphi^-<0`$) :<br>
<br>**$`\mathbf{\overrightarrow{dl_{\varphi}}}`$** *$`\displaystyle=\lim_{\Delta\varphi\rightarrow 0} \overrightarrow{MM''}`$* **$`\mathbf{=\rho_M\cdot d\varphi\cdot\overrightarrow{e_{\varphi}}}`$**<br>



##### Vecteurs unitaires $`\overrightarrow{e_{\rho}}`$ et $`\overrightarrow{e_z}`$

---------

![](cylindrical_coordinates_e-z_e-rho_unit_vector_L1200.gif)

--------

* **$`\mathbf{M(\rho,\varphi,z) \longrightarrow M'(\rho+\Delta\rho^+,\varphi,z)}`$**<br>
**$`\mathbf{M(\rho,\varphi,z) \longrightarrow M'''(\rho,\varphi,z+\Delta z^+)}`$** <br>
(avec $`\Delta\rho^+=\Delta\rho>0`$ et $`\Delta z^+=\Delta z>0`$)<br>
<br>**$`\Longrightarrow`$ directions et sens** de <br>
**$`\quad\overrightarrow{e_{\rho}}`$** : selon l'axe $`Om_{xOy}`$.<br>
**$`\quad\overrightarrow{e_z}`$** : selon l'axe $`Oz`$.

* Dans les deux cas, la trajectoire suivie par $`M`$ : sègment de droite<br>
$`\Longrightarrow`$ longueur parcourue = norme du vecteur déplacement.<br>
$`\Longrightarrow`$ $`l_{\Delta\rho}=||\overrightarrow{MM'}||\quad`$ et $`\quad l_{\Delta z}=||\overrightarrow{MM'''}||`$


* Cas général ($`d\rho\;, dz >0\;\text{ou}<0`$) :<br>
**$`\mathbf{\overrightarrow{dl_{\rho}}}`$** $`\displaystyle=\lim_{\Delta\rho\rightarrow 0} \overrightarrow{MM'}`$ **$`\mathbf{ = d\rho \cdot \overrightarrow{e_{\rho}}}`$**.<br>
 **$`\mathbf{\overrightarrow{dl_z}}`$** $`\displaystyle=\lim_{\Delta z \rightarrow 0} \overrightarrow{MM'''}`$
 **$`\mathbf{=dz \cdot \overrightarrow{e_z}}`$**.

#### La base $`(\overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})`$ est orthonormée.

----

![](cylindrical_coordinates_orthogonal_base_L1200.jpg)

---

* $`(\overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})`$ est la *base associée à un point $`M(\rho_M,\varphi_M,z_M)`$*.

*  **$`(\overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})`$** est orthonormée **directe si $`(\overrightarrow{e_x}, \overrightarrow{e_y}, \overrightarrow{e_z})`$** est orthonormée **directe**, et *inverse dans le cas contraire*.

* **$`\left\{ \begin{array}{l}\mathbf{\overrightarrow{e_{\rho}}=\cos\varphi\cdot\overrightarrow{e_x}+\sin\varphi\cdot\overrightarrow{e_y}} \\\mathbf{\overrightarrow{e_{\varphi}}=-\sin\varphi\cdot\overrightarrow{e_x}+\cos\varphi\cdot\overrightarrow{e_y}} \end{array}\right.`$**

* Dans le référentiel  $`(O,\overrightarrow{e_x}, \overrightarrow{e_y}, \overrightarrow{e_z},t)`$, la *base $`(\overrightarrow{e_x}, \overrightarrow{e_y}, \overrightarrow{e_z})`$* :<br>
\- n'est **pas fixe**.<br>
\- **change d'orientation** *quand $`\varphi_M`$ varie*.

#### Comment s'exprime le vecteur position $`\overrightarrow{OM}`$ ?

----

![](cylindrical_coordinates_vector_OM_L1200.gif)

---

*  **$`\mathbf{\overrightarrow{OM}=\rho_M\cdot\overrightarrow{e_{\rho}}+z_M\cdot\overrightarrow{e_z}}`$**

#### Que sont l'élément de longueur $`dl`$ et  vecteur déplacement élémentaire $`\overrightarrow{dl}`$ ?

* Un point **$`M(\rho,\varphi,z)`$** fait un **déplacement infinitésimal** jusqu'au point $`M'(\rho+d\rho,\varphi+d\varphi,z+dz)`$, avec *$`d\rho`$, $`d\varphi`$ et $`dz`$ variations infinitésimales, positives ou négatives*, des coordonnées $`\rho\;,\;\varphi\;,\;z`$.

##### Vecteur déplacement élémentaire $`\overrightarrow{dl}`$

* vecteur déplacement élémentaire = *élément vectoriel d'arc* [Norme IEC](http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-05-02)

* Le **vecteur déplacement élémentaire** est le vecteur
**$`\overrightarrow{dl}`$** $`\;=dl_{\rho}\cdot\overrightarrow{e_{\rho}}+dl_{\varphi}\cdot\overrightarrow{e_{\varphi}}+dl_z\cdot\overrightarrow{e_z}`$
**$`\quad=dl_{\rho}\cdot\overrightarrow{e_{\rho}}+\rho\,d\varphi\cdot\overrightarrow{e_{\varphi}}+dl_z\cdot\overrightarrow{e_z}`$**

*  permet de calculer les vecteurs vitesse $`\overrightarrow{v}(t)`$ et accélération $`\overrightarrow{a}(t)`$ d'un point M à tout instant t :<br>
**$`\overrightarrow{v}(t)`$**$`\;=\dfrac{\overrightarrow{dOM}}{dt}`$**$`\;=\dfrac{\overrightarrow{dl}}{dt}`$**<br>
**$`\overrightarrow{a}(t)`$**$`\;=\dfrac{\overrightarrow{d^2 OM}}{dt^2}`$**$`\;=\dfrac{d}{dt}\left(\dfrac{\overrightarrow{dl}}{dt}\right)`$**

##### Élément de longueur $`dl`$

* élément de longueur = *élément scalaire d'arc* [Norme IEC](http://www.electropedia.org/iev/iev.nsf/display?openform&ievref=102-05-01)

* L'**élément de longueur $`dl`$** est la *longueur parcourue* sur la trajectoire entre $`M`$ et $`M'`$ :<br>
**$`dl`$**$`\;=\sqrt{dl_{\rho}^2+dl_{\varphi}^2+dl_z^2}`$**$`\;=\sqrt{d\rho^2+\rho^2\,d\varphi^2+dz^2}`$**

* Permet de calculer la longueur $`\mathscr{l}`$ d'une trajectoire $`L`$, lorsque les coordonnées $`\rho(t)`$, $`\varphi(t)`$ et $`z(t)`$ varient en fonction du temps de façon indépendantes les une des autres :<br>
**$`\displaystyle\mathbf{\mathscr{l}=\int_L dl}`$**

#### Qu'est-ce que la surface élémentaire associée à chaque coordonnée ?

* **Element de surface $`dl_{\rho}`$**, surface élémentaire *perpendiculaire à $`\overrightarrow{e_{\rho}}`$*.<br>
 <br>_Utilisable, par exemple, pour calculer l'aire de la surface latérale d'un cylindre._

![](cylindrical_coordinates_surface_4_L1200.jpg)<br>

-----------------

* **Element de surface $`dl_{\varphi}`$**, surface élémentaire *perpendiculaire à $`\overrightarrow{e_{\varphi}}`$*.<br>
 <br>_Utilisable, par exemple, pour calculer l'aire d'un disque centré et perpendiculaire à l'axe $`Oz`$._

![](cylindrical_coordinates_surface_2_L1200.jpg)<br>

-----------------

* **Element de surface $`dl_z`$**, surface élémentaire *perpendiculaire à $`\overrightarrow{e_z}`$*.<br>
 <br>_Utilisable, par exemple, pour calculer l'aire de la section d'un cylindre contenant l'axe $`Oz`$._
<!-- mal dit ça, "contenant" ... à changer -->

![](cylindrical_coordinates_surface_3_L1200.jpg)<br>

---

#### Qu'est-ce que le volume élémentaire ?

Le **volume élémentaire** en chaque point $`M`$ de coordonnées $`(\rho, \varphi, z)`$
est le volume $`d\tau`$ d'un *parallélépipède rectangle mésoscopique*, d'*arêtes parallèles aux vecteurs
$`\overrightarrow{e_{\rho}}`$, $`\overrightarrow{e_{\varphi}}`$ et $`\overrightarrow{e_z}`$*,
et de *longueurs* respectives *$`dl_{\rho}`$, $`dl_{\varphi}`$ et $`dl_z`$*.

Donc **$`\mathbf{d\tau}`$**$`\; = dl_{\rho} \cdot dl_{\varphi}\cdot dl_z`$**$`\; =\mathbf{\rho\,d\rho\,d\varphi\,dz}`$**

![](cylindrical_coordinates_volume_L1200.jpg)<br>


     


