---
title: Équations de Maxwell , fondement de l'électromagnétisme
published: false
routable: false
visible: false
lessons:
    - slug: maxwell-equations
      name: LINÉAIRE - les équations de Maxwell
      order: 2
    - 
       slug: electromagnetic-waves-propagation-from-vacuum-to-media
       name: PARALLÈLE : Propagation des ondes EM, du vide aux milieux matériels
       order: 1
    -
        slug: maxwell-equations-in-EM-learning-pattern
        name: SITUATION : Les équations de Maxwell dans l'électromagnétisme
        order: 2

---

<!--MétaDonnée : ... -->

<!--caligraphie de l'intégrale double curviligne-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\soiint{\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

Attention !!! En période très préliminaire d'élaboration et de construction !

##### Randonnée montagne :&nbsp; _physique_

---------------------------

### Les équations de Maxwell

#### Quel fut le travail de Maxwell ?

* *Jusqu'au milieu du XIVème siècle*, **électricité, magnétisme et optique** étaient étudiés dans des *domaines scientifiques distincts*. 

* Cependant l'*observation de phénomènes naturels et d'expériences de laboratoire* montrèrent une
**interaction incomprise entre électricité, magnétisme,** voire **optique**.
    * naturel : la foudre peu charger des objets métalliques, aimante le fer, créé un éclair.
    * expériences :   
      \- un courant dévie l'aiguille d'une boussole.   
      \- le déplacement d'un aimant créé un courant.

* Bon mathématicien, **Maxwell** fait *synthèse des résultats expérimentaux* de son époque
qui se résume en 4 équations, les *équations de Maxwell*.

* Ces 4 équations **unifient électricité, magnétisme et optique** au sein de l'électromagnétisme,   
  et élargissent l'optique à un *monde nouveau : les ondes électromagnétiques*.

![](Maxwell-equation-fr.png)
_Maxwell modifie deux des équations de l'électrostatique et de la magnétostatique en
introduisant des termes de couplage entre E et B,
et révolutionne ainsi la physique._

#### Pourquoi disons-nous "équations" et pas "théorèmes" de Maxwell ?

* Les **4 équations de Maxwell** *ne sont pas démontrées*, donc elles ne constituent pas des théorèmes.
* Elles sont *posées et supposées vraies*, ce **sont des postulats**.

#### Pourquoi ces équations fondent l'électromagnétisme ?

#### Quel est le domaine de validité de ces équations ?

#### Que sont ces 4 équations de Maxwell ?

##### Sous forme locale 
_(fondamental, connaître)_

* Deux **expressions de la divergence** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ *inchangées par rapport au cas stationnaire* (électrostatique et magnétostatique) :

   * **$`\mathbf{div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-Gauss*).

   * ** $`\mathbf{div \overrightarrow{B} = 0}`$** &nbsp;&nbsp;&nbsp;(éq. *Maxwell-flux*).


* Deux **expressions du rotationnel** des champs $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ qui *changent et couplent les champs $`\mathbf{\overrightarrow{E}}`$ et $`\mathbf{\overrightarrow{B}}`$* :

   * **$`\mathbf{\overrightarrow{rot} \;\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$**
   &nbsp;&nbsp;&nbsp;(éq. *Maxwell-Faraday*).

   * **$`\mathbf{\overrightarrow{rot} \;\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$**&nbsp;&nbsp;&nbsp;(éq. *Maxwell-Ampère*).

* où :
   * $`\dens=\dens^{3D}`$ est la densité volumique de charge. 
   * $`\overrightarrow{j}=\overrightarrow{j}^{3D}`$ est le vecteur densité volumique de courant. 

------------------

* Et ces équations *réécrites avec l'opérateur nabla : $`\mathbf{\nabla}`$ *

   * **$`\mathbf{\nabla\cdot\overrightarrow{E}=\dfrac{\dens}{\epsilon_0}}`$**

   * **$`\mathbf{\nabla\cdot\overrightarrow{B}=0}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{E}= -\dfrac{\partial \overrightarrow{B}}{\partial t}}`$**

   * **$`\mathbf{\nabla\land\overrightarrow{B}= \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}}`$**


------------------


##### Sous forme intégrale
_(savoir redémontrer)_


* Elles **se déduisent des équations locales**, avec l'aide :
   * du *théorème d'Ostrograsky* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iiint_{\Ltau} div\;\overrightarrow{X} \cdot d\tau = \displaystyle 
\oiint_{S\leftrightarrow\Ltau} \overrightarrow{X}\cdot\overrightarrow{dS}`$*
   * du *théorème de Stokes* :   
   $`\forall \overrightarrow{X}(\overrightarrow{r})`$ : 
   *$`\displaystyle\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{X} \cdot dS 
= \displaystyle \oint_{\Gamma\leftrightarrow S} \overrightarrow{X}\cdot\overrightarrow{dl}`$*.

* **Maxwell-Gauss** :   
     
  À tout instant t, et pour tout volume $`\tau`$ :

   * $`\forall \overrightarrow{r}, div \overrightarrow{E} = \dfrac{\dens}{\epsilon_0}`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{E}\,d\tau = \iiint_{\Ltau}\dfrac{\dens}{\epsilon_0}\,d\tau \\
\iiint_{\Ltau} div\;\overrightarrow{E} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{E}\cdot\overrightarrow{dS}
= \dfrac{1}{\epsilon_0} \cdot \iiint_{\Ltau} \rho \cdot d\tau = \dfrac{Q_{int}}{\epsilon_0}}`$**

------------

* **Maxwell-flux** :

     
  À tout instant t, et pour tout volume $`\tau`$ :
  
     * $`\forall \overrightarrow{r}, div \overrightarrow{B} = 0`$
  $`\Longrightarrow \iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0`$   

   * $`\left.\begin{array}{l}
\iiint_{\Ltau} div \overrightarrow{B}\,d\tau = 0 \\
\iiint_{\Ltau} div\;\overrightarrow{B} \cdot d\tau = \displaystyle 
\soiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\mathbf{\displaystyle \quad\oiint_{S\leftrightarrow\Ltau} \overrightarrow{B}\cdot\overrightarrow{dS}= 0}`$**

-----------------

* **Maxwell-Faraday** :

     
  À tout instant t,   
  et pour toute surface $`S`$ ouverte et orientée, fixe et indéformable, qui s'appuie sur un contour $`\Gamma`$ 
  d'orientation compatible avec celle de $`S`$ selon la règle de la main droite :

   * $`\forall \overrightarrow{r}, \overrightarrow{rot} \,\overrightarrow{E} = -\dfrac{\partial \overrightarrow{B}}{\partial t}`$
  $`\Longrightarrow \iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big)`$  
<br>   

   * $`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = \iint_S\Big(-\dfrac{\partial\overrightarrow{B}}{\partial t}\cdot\overrightarrow{dS}\Big) \\
\text{Newton : espace et temps indépendants,} \\
\text{ordre dérivation/intégration n'importe pas}
\end{array}\right\}`$
$`\Longrightarrow`$
$`\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big)`$   
<br>   

   * $`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{E}\cdot\overrightarrow{dS} = -\dfrac{d}{dt}\Big(\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}\Big) \\
\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{E} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}
\end{array}\right\}`$
$`\Longrightarrow`$
**$`\begin{array}{l}
  &nbsp; \\
 \mathbf{\displaystyle\quad\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}= -\dfrac{d}{dt}\iint_S\overrightarrow{B}\cdot\overrightarrow{dS}}
\end{array}`$**   
<br>   
   *  Cette équation joue un *rôle important pour les phénomènes d'induction*.    
      _La quantité_ $`\oint_{\Gamma\leftrightarrow S} \overrightarrow{E}\cdot\overrightarrow{dl}`$ 
      _d'appelation historique imparfaite "force électromotrice (fem)", homogène à une tension, est à l'origine à un courant_
      _traversant le contour $`\Gamma`$ si celui-ci représente un circuit conducteur._
     

---------------

* **Maxwell-Ampère** :

  À tout instant t,   
  et pour toute surface $`S`$ ouverte et orientée, fixe et indéformable, qui s'appuie sur un contour $`\Gamma`$ 
  d'orientation compatible avec celle de $`S`$ selon la règle de la main droite :
<br>

$`\forall \overrightarrow{r}, \overrightarrow{rot} \,\overrightarrow{B} = \mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}`$
  $`\Longrightarrow`$$` \iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS}`$  
<br>
   
$`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \iint_S\Big(\mu_0\;\overrightarrow{j} + \mu_0 \epsilon_0 \;\dfrac{\partial \overrightarrow{E}}{\partial t}\Big)\cdot\overrightarrow{dS} \\
\text{Newton : espace et temps indépendants},\\
\text{ordre dérivation/intégration n'importe pas}
\end{array}\right\}`$
$`\Longrightarrow`$
$`\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS}`$$`\; = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
 \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}`$   
<br>
   
$`\left.\begin{array}{l}
\iint_S \overrightarrow{rot} \,\overrightarrow{B}\cdot\overrightarrow{dS} = \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +
 \mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS} \\
\iint_{S} \;\overrightarrow{rot}\;\overrightarrow{B} \cdot dS = \oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}
\end{array}\right\}`$
$`\Longrightarrow`$

**$`&nbsp;\mathbf{\displaystyle\;\,\oint_{\,\Gamma\leftrightarrow S} \overrightarrow{B}\cdot\overrightarrow{dl}}`$
$`\;\mathbf{\displaystyle= \mu_0\iint_S \overrightarrow{j}\cdot\overrightarrow{dS} +\mu_0 \epsilon_0\dfrac{d}{dt}\iint_S\overrightarrow{E}\cdot\overrightarrow{dS}}`$**



#### Pourquoi parlons-nous de champ électromagnétique ?

* Les 2 équations de couplage de $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ impliquent 
que **variables, $`\overrightarrow{E}`$ et $`\overrightarrow{B}`$ ne peuvent exister l'un sans l'autre**.

* Le terme *$`\dfrac{\partial\overrightarrow{B}}{\partial t}\ne 0`$ implique $`\overrightarrow{E}\ne \overrightarrow{0}`$*
* Le terme *$`\dfrac{\partial\overrightarrow{E}}{\partial t}\ne 0`$ implique $`\overrightarrow{B}\ne \overrightarrow{0}`$*

#### Le champ électromagnétique contient-t-il de l'énergie ?

à faire

#### Pourquoi parlons-nous d'ondes électromagnétiques ?

à faire


#### Qu'est-ce que le vecteur de Poynting ?

à faire

#### Comment calculer le puissance traversée par une surface d'aire et d'orientation quelconque ?

à faire

#### le champ électromagnétique peut-il céder ou prendre de l'énergie à la matière ?

à faire

#### Comment émettre une onde électromagnétique ?

Quelques idées très synthétiques.   
Pour des ressources transverses et classiques, liens en parallèles


#### Comment capter la puissance d'une onde électromagnétique ?

Quelques idées très synthétiques.   
Pour des ressources transverses et classiques, liens en parallèles









