---
title: Les ondes
published: true
routable: true
visible: false
lessons:
    -
      slug: energy-mix-hydroelectricity-2
      name: TD4 : Hydroélectricité
      order: 2
    -
      slug: TD4-hydroelectricity-energy-efficiency-values
      name: DÉFINITIONS-2 : TD4 et grandeurs d'efficacité énergétique
      order: 2
---

<!--Commandes Latex spécifiques
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
-->

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-5_L1200.jpg)<details>
<summary>Etape 5 : Ecriture : 3/3</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>

##### Mix-énergétique : TD 4

---------------------------

# <p style="font-size:70%;text-align: center;">Les Centrales<br> de haute chute</p>

Un **barrage** est créé dans une vallée. Il conduit à une inondation partielle de celle-ci,
créant un **lac artificiel** de *volume d'eau maximum $`\mathbf{V_{lac}}`$*       
décrit par le schéma ci-dessous :

![](energy-mix-TD4-hydroelectricity-high-falls-power-station-1_L1200.jpg)

Lorsque les vannes sont ouvertes, chaque mètre cube **chute** d'une *hauteur moyenne* équivalente de *$`\mathbf{H=150\,m}`$*.

En bas de la chute, la **puissance électrique crête $`\mathbf{P_c}`$** des turbines installée est de *$`\mathbf{P_c = 300\,MW}`$*. 

## <p style="font-size:60%;text-align: center;">FONCTION dans le SYSTEME ENERGETIQUE</p>

##### 1. **Capacité de stockage / déstockage** ou *générateur continu* d'énergie<br><br>a)  A laquelle de deux classes ci-dessus appartiennent les centrales de lac ?

<details markdown=1><summary>Solution</summary>
* Le **lac** est le **réservoir d'énergie** stockée *sous forme d'énergie potentielle gravitationnelle*. 

* L'**approvisionnement** de ce réservoir n'a *pas de coût dans la chaîne industrielle énergétique*, car 
il est réalisé par le cycle annuel naturel de l'eau "évaporation (principalement au niveau 
de la mer et en plaines)  / élévation / condensation / précipitation (aboutissant dans 
le lac d'altitude), cycle alimenté par l'énergie solaire. 

* Le **déstockage d'énergie** est humainement *pilotable par simple ouverture ou fermeture des vannes*
qui déversent l'eau du lac sur des turbines situées à une altitude bien inférieure à celle des vannes.
</details>

##### b)  Calculer $`\mathbf{E_{\,stock}^{\,grav}}`$,<br> l'énergie potentielle gravitationnelle stockée lorsque le lac est à son niveau maximum.

<details markdown=1><summary>Solution</summary>

* *$`\mathbf{V_{lac}=\dfrac{L\times l \times h}{2}}`$*   

$`\hspace{1,6cm}=\dfrac{6\times 3\times 1}{2}\times 10^{3+3+2}`$

*$`\hspace{1,6cm}\mathbf{= 9\times 10^8=900\,Mm^3}`$*

<br>

* **$`\boldsymbol{\mathbf{E_{\,stock}^{\,grav}=
\varrho_{eau}\times\dfrac{L\times l \times h}{2}\times g \times H}}`$**

$`\hspace{1,6cm}=
10^3\times\dfrac{6\times 3 \times 1 \times 10^{3+3+2}}{2}\times 10^1 \times 1,5\cdot10^2`$   

*$`\hspace{1,6cm}\mathbf{= 13,5\times 10^{14}\,J}`$*   

$`\hspace{1,6cm}= (13,5\times 10^{14}\,J)\times \left(\dfrac{1}{3,6\times 10^6}\,kWh.J^{-1}\right)`$   

**$`\hspace{1,1cm}\mathbf{E_{\,stock}^{\,grav}= 3,75 \times 10^8 \,kWh = 375 \,GWh}`$**

</details>

!! <details markdown=1><summary>Comparaison : lac et barrage de Serre-Ponson (Hautes-Alpes, France)</summary>
!!
!! * Lac de Serre-Ponson : 90km de berges, $`\mathbf{L=20\,km}`$ et $`\mathbf{l=3\,km}`$ à son niveau maximum.
!! * Profondeur maximale $`\mathbf{h=90\,m}`$
!! * volume maximal $`\mathbf{V = 1\,270\,Mm^3}`$
!! * Superficie $`\mathbf{S=28,2\,km^2}`$
!! * Centrale hydroélectrique de Serre-Ponson : Hauteur $`\mathbf{H=124\,m}`$
!! * Puissance installée $`\mathbf{P_{instal}=380\,MW}`$
!! * Production annuelle $`\mathbf{E_{\,1\,an}^{\,elec}=7\times 10^8\,kWh= 700\,GWh}`$<br>
!! <br>
!! soit la *consommation annuelle du département des Hautes-Alpes* <br>
!! ou encore de<br>
!! l'*agglomération d'Aix-en-Provence ( $`\mathbf{\approx 150\,000}`$ hab)*
!! </details>

! <details markdown=1><summary>Note : Consommation moyenne française</summary>
! En *France*, la *consommation moyenne d’électricité par mois et par foyer* est de l’ordre de *390 kWh*, 
! soit *4 679 kWh par an* (_source : particuliers.engie.fr_).
! </details>

<br>

----

##### 2. **Production annuelle d'énergie** et *nombre d'habitants alimentés* en électricité


* Le **rendement de conversion total** entre énergie potentielle gravitationnelle et 
  énergie électrique est *$`\boldsymbol{\mathbf{\eta_{\,conv}^{\,destock}\simeq 0,8}}`$*.

* Par ailleurs, on considère que pour une installation de ce type le *volume d'eau 
  chutant par an dans les turbines* pour produire l'électricité est, en moyenne, 
  au moins **égal au volume du lac** qu'elle créé.    
  <br>
  Pour les besoins du calcul, **nous prendrons $`\mathbf{80\,\%}`$ du volume** de ce lac. 

* En **France**, la *consommation moyenne annuelle par habitant* est de *$`\mathbf{E_{\,1\,an\,1\,hab}^{\,elec}\simeq 4700\,kWh\,an^{-1}\,hab^{-1}}`$*

##### Calculer l'énergie électrique produite annuellement,<br> puis<br>comparer à la consommation moyenne annuelle par habitant en France

<details markdown=1><summary>Solution</summary>

* **$`\mathbf{E_{\,1\,an}^{\,elec}}=`$** $`\eta_{\,conv}^{\,destock}\times (0,8\times E_{\,stock}^{\,grav})`$

$`\hspace{1,6cm}=0,8\times 0,8\times 375\times 10^9\,Wh\,an^{-1}`$   

**$`\hspace{1,6cm}\mathbf{= 240\,GWh\,an^{-1}}`$**   

* Cela représente la *consommation annuelle de $`\mathbf{\dfrac{240\times 10^9}{4,7\times 10^6}\simeq \mathbf{51000}}`$  habitants*.

</details>

<br>

----

##### 3. **Facteur de charge** et *type d'utilisation*


##### a)  Calculer le facteur de charge de cette centrale. 

<details markdown=1><summary>Solution</summary>

* Rappel : l'installation électrique a une puissance crête de *$`\mathbf{P_c = 300\;MW}`$*

* **$`\mathbf{F_{charge}=\dfrac{P_{moy}(\Delta t)}{P_c}=\dfrac{1}{P_c}\cdot\dfrac{E_{\Delta t}}{\Delta t}}`$**

<br>
$`\hspace{1,6cm}=\dfrac{1}{300\times 10^6\;(W)}\cdot\dfrac{E_{\,1\,an}^{\,elec}\;(W.h)}{\underbrace{365,25\times 24\;(h)}_{\text{nombre d'heures par an}}}`$

$`\hspace{1,6cm}=\dfrac{1}{300\times 10^6\;(W)}\cdot\dfrac{240\times 10^9\;(W.h)}{8766\;(h)}`$

**$`\hspace{1,6cm}\mathbf{=0,091}`$**

&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Le facteur de charge *exprimé en %* s'écrit :

*$`\hspace{1,1cm}\mathbf{F_{charge}=9,1\;\%}`$*

##### b)  Quel sera son rôle dans le système d'approvisionnement en énergie ?

* Ce **faible facteur de charge** de 9,1% indique qu'il s'agit vraiment d'une *capacité de stockage* où puiser aux périodes de pointe.

</details>

<br>

## <p style="font-size:60%;text-align: center;">EFFICACITÉ  et  ENJEUX  ÉCOLOGIQUES</p>



##### 4. Densité surfacique d'énergie stockée

##### Calculer $`\mathbf{d_{\,stock}^{\,surf}}`$, la densité surfacique d'énergie stockée lorsque le barrage est à son niveau maximum,<br> puis <br> la puissance crête libérable.

<details markdown=1><summary>Solution</summary>

* **$`\mathbf{d_{\,stock}^{\,surf}=\dfrac{E_{s\,stock}^{max}}{A_{stock}}}
=\dfrac{\eta_{\,conv}^{\,destock}\times E_{\,stock}^{\,grav}}{A_{lac}}`$**

$`\hspace{1,6cm}=\dfrac{0,8\times 375\times 10^{9}}{18\times 10^6}`$ **$`\mathbf{\simeq 16,7\;kWh.m^{-2}}`$

* La **puissance instantanée** libérable est la *puissance électrique installée*, soit $`\mathbf{300\,MW}`$.

</details>

<br>

----

##### 5. Densité volumique d'énergie stockée

* La **digue du barrage** a la forme suivante :

![](energy-mix-TD4-hydroelectricity-high-falls-power-station-2_L1200.jpg)


##### a)  Calculer le nombre de mètre cube de matériau de cette digue.

<details markdown=1><summary>Solution</summary>
  
**$`\mathbf{V_{digue}}`$** $`\;= (2\times 300\times 150)+\dfrac{48\times 300\times 150}{2}\,m^3`$

$`\hspace{1,6cm}=(90\,000+1\,080\,000)\,m^3`$

**$`\hspace{1,6cm}\mathbf{\simeq 1,2\cdot10^6\,m^3}`$**

</details>

<br>

##### b) La durée de vie du barrage étant estimée à 100 années,<br><br> calculer l'énergie électrique produite sur la durée de vie de l'ouvrage par unité volumique de barrage. 

<details markdown=1><summary>Solution</summary>

<br>

Appelons **$`\boldsymbol{\mathbf{\eta_{\,vol\;/\;elec}^{\;duree\;vie}}}`$** ce *rendement énergétique* estimé
 sur la durée de vie du barrage par unité de volume :<br>
<br>
**$`\boldsymbol{\mathbf{\eta_{\,vol\;/\;elec}^{\;duree\;vie}=\dfrac{E_{\,1\,an}^{\,elec}\times \Delta t_{vie}}{V_{digue}}}}`$**

$`\hspace{1,6cm}\simeq\dfrac{(2,4\times 10^{11})\times 10^2}{10^6}`$

**$`\hspace{1,6cm}\mathbf{=2,4\times 10^7\,kWh\,m^3}`$**

</details>

!! <details markdown=1><summary>Comparaison : lac et barrage de Serre-Ponson (Hautes-Alpes, France)</summary>
!!
!! Pour le Lac de Serre-Ponson : 
!! * Hauteur $`\mathbf{h=120\,m}`$
!! * Largeur $`\mathbf{l=600\,m}`$
!! * Épaisseur à sa base $`\mathbf{e=650\,m}`$
!! * Volume de matériaux : $`\mathbf{V=14\,M\,m^3}`$
!! </details>

! <details markdown=1><summary>Note : grande variabilité des barrages</summary>
! Trois différentes formes de barrage peuvent se distinguer : 
! * Le barrage-poids
! * le barrage-voûte
! * le barrage à contreforts.<br> 
! Pour une même retenue, la forme et le volume du barrage peuvent différer beaucoup. 
! L'exemple choisi dans le texte est juste un cas d'école.

<br>   

## <p style="font-size:60%;text-align: center;">RÉSILIENCE CLIMATIQUE et GÉOPOLITIQUE</p>

Pas de question posée

<br>

## <p style="font-size:60%;text-align: center;">POTENTIEL de DÉVELOPPEMENT en FRANCE</p>

Pas de question posée

<br>

## <p style="font-size:60%;text-align: center;">EQUILIBRE ECONOMIQUE<br> et CADRE LEGISLATIF actuels
</p>

Pas de question posée

