---
title: Lentille épaisse : "au-delà"
published: true
routable: true
visible: false
---



! *YOUR  CHALLENGE*  :  An object (a painting), a physical system (a lensball), how many scenarios and optical systems?
!
! _Skill tested : understanding of physical situations_
!
! ![](physical-system-versus-optical-system_L650.gif)
!
! *Discovery time : 30 minutes*<br>
! *Resolution time : 10 minutes*
!
! <details markdown=1>
! <summary>
! I choose it
! </summary>
! A lensball is a simple physical system: a sphere of glass of refractive index $`n=1.5`$ and of radius $`R=5\;cm`$.
!
! A ball lensball is placed in front of a painting. Depending on the position of the observer or the camera, 
! the optical system (the sequence of simple optical elements crossed by light between the physical object
! and the observed image) that forms the image differs.
!
! Observe the 3 images of the painting given by the lensball :
!
! Image 1
!
! ![](lentille-boule-1-transparence_L650.jpg)
!
! Images 2 (the smallest) and 3
!
! ![](lentille-boule-2-reflexions_L650.jpg)
!
! For each image of the painting, can you identify the optical system, then specify `
! the characteristics of the various simple elements that constitute the system and their relative distances?
!
! * _The resolution time is the typical expected time to be allocated to this problem if it was part of an examen for an optics certificate._ 
! * _The discovery time is the expected time required to prepare this challenge if you don't have practice. But take as much time as you need._
!
! <\details>
! <details markdown=1>
! <summary>
! Ready to answer M3P2 team questions for image 1?
! </summary>
!
! <details markdown=1>
! <summary>
! Where is the painting located?
! </summary>
! * The painting is located on the other side of the lens, in relation to you.
! </details>
! <details markdown=1>
! <summary>
! What is the optical system giving the image of the painting?
! </summary>
! <br>
! * The optical system is composed of two spherical refracting surfaces, centered on the same optical axis.<br>
! <br>
! </details>
! <details markdown=1>
! <summary>
! How do you characterize each of the single optical elements that make up this optical system, 
! and their relative distances?
! </summary>
! <br>
! * The optical axis is oriented positively in the direction of light propagation 
! (from the painting towards the lensball).<br>
! <br>
! * The first spherical refracting surface 
! $`DS1`$ encountered by the light has
! the follwing characteristics :<br>
! $`\overline{S_1C_1}=+|R|=+5\;cm`$, 
! $`n_{ini}=1`$ and $`n_{fin}=1.5`$.
! <br>
! * The second spherical refracting surface 
! $DS2$ encountered by the light has the follwing characteristics :<br>
! $`\overline{S_2C_2}=-|R|=-5\;cm`$ , 
! $`n_{ini}=1.5`$ and $`n_{fin}=1`$
!
! * Algebraic distance between $DS1$ and $DS2$ is : $`\overline{S_1S_2}=+10\;cm`$
!
! </details>
! <details markdown=1>
! <summary>
! If you had to determine the characteristics of the image (position, size), how 
! would you handle the problem?
! </summary>
!
! * $`DS1`$ gives an image $`B_1`$ of an object $`B`$. This image $`B_1`$ for $`DS1`$ 
! becomes the object for $`DS2`$. $`DS2`$ gives an image $`B'1`$ of the object $`B_1`$
!
! </details>
! </details>
! <!--FOR IMAGES 2 & 3-->
!
! <details markdown=1>
! <summary>
! Ready to answer M3P2 team questions for images 2 and 3?
! </summary>
!
! <details markdown=1>
! <summary>
! Where is the painting located?
! </summary>
!
! * The painting is located on the same side of the lens as you, behind you.
!
! </details>
! <details markdown=1>
! <summary>
! 
! What are the two optical systems at the origin of the two images of the painting? And 
! can you characterize each of the single optical elements (+ their relative distances) 
! that make up each of these optical systems ?
! </summary>
!
! * A first optical system $`OS1`$ is composed of a simple convexe spherical mirror 
! (the object is reflected on the front face of the ball lensball). Keaping the optical
! axis positively oriented in the direction of the incident light propagation on the lensball,
! the algebraic value of the mirror radius is : $`\overline{SC}=+5\;c`$.
!
! * The second optical system $`OS2`$ is composed of three simple optical elements :<br><br>
! 1) The light crosses a spherical refracting surface $`DS1`$ with characteristics : 
! $`\overline{S_1C_1}=+|R|=+5\;cm`$ , $`n_{ini}=1`$ and $`n_{fin}=1.5`$.
!
! 2) Then the light is reflected at the surface of the last lensball interface that
! acts like a spherical mirror of characteristics : $`\overline{S_2C_2}=-|R|=-5\;cm`$, 
! $`n=1.5`$.
!
! 3) Finally the light crosses back the first interface of the lensball that acts 
! like a spherical refracting surface those characteristics are :
! $`\overline{S_3C_3}=+|R|=+5\;cm`$ , $`n_{ini}=1.5$ and $n_{fin}=1`$.
!
! Relative algebraic distances between the different elements of $`OS2`$ are :
!
! $`\overline{S_1S_2}=+10\;cm`$ and $`\overline{S_2S_3}=-10\;cm`$
!
! </details>
! <details markdown=1>
! <summary>
! Which image is associated with each of the optical systems?
! </summary>
! 
! * It is difficult to be 100% sure before having made the calculations. 
!
! </details>
! <details markdown=1>
! <summary>
! Why do we had to take the picture in the darkness, with only the painting 
! illuminated behind the camera, to obtain images 2 and 3 ?
! </summary>
!
! * At a refracting interface, part of the light incident power is refracted, 
! and part is reflected. For transparent material like glass and for visible light,
! the part of the reflected power is small. If the room had been homogeneously 
! illuminated, the images 2 and 3 of the painting on the wall behind the camera would
! have been faintly visible compared to the image of the front wall through the lensball.
! </details>
! </details>
! </details>

! *TON  DÉFI  :  "Je regarde une cathédrale à travers une lentille boule. Puis-je prédire mon observation ?"*.<br>
! <br>
! _Aptitude testée : Savoir poser un problème et conduire des calculs_<br>
! <br>
! ![](lensball-brut-820-760.jpg)<br>
! <br>
! *Durée de découverte : 2 heures*<br>
! *Durée de résolution : 30 minutes*
! <details markdown=1>
! <summary>
! Je choisis ce défi.
! </summary>
! La lentille-boule est une sphère de rayon $`R=5 cm`$, réalisée dans un verre
! d'indice de réfraction $`n_{verre}=1.5`$. La cathédrale à une hauteur totale,
! depuis sa base jusqu'au sommets de ses tours, de 90 mètres. Je me tiens à
! 400 mètres de la cathédrale (cette distance est la distance cathédrale-oeil). 
! Je regarde la cathédrale à travers la lentille-boule, située à 20 centimètres
! de mon oeil. Que-suis sensé voir ?
!
! * _La durée de résolution représente le temps qui serait typiquement alloué à la résolution_
! _de ce problème, s'il faisait partie d'un examen d'optique géométrique de_
! _première année universitaire._
!
! * _La durée de découverte est le temps estimé pour préparer ce défi, en absence_
! _d'entraînement. Cette durée est juste une indication. Prends autant de temps que_
! _nécessaire. Le temps de s'interroger sereinement sur la façon de traiter le problème,_
! _sur la méthode de résolution et sa validité, sur quelques approximations possibles_ 
! _si elles peuvent se justifier, et le temps qu'il faut pour vérifier les équations_ 
! _si vous ne les avez pas préalablement mémorisées et pour effectuer le calcul, sont importants._
!
! <details markdown=1>
! <summary>
! Prêt pour les questions ?
! </summary>
! <!--question 1-->
! <details markdown=1>
! <summary>
! Quel cadre scientifique choisis-tu pour étudier ce problème ?
! </summary>
! * Toutes les tailles caractéristiques dans ce problème sont beaucoup plus grandes
! que les longueurs d'onde de la lumière visible ($`\lambda\approx5\mu m`$), donc
! je vais étudier ce problème dans le cadre de l'optique géométrique.
!
! * Depuis la lentille-boule, la cathédrale est observée sous un angle apparent de
! $`arctan\left(\dfrac{90}{400}\right)=13°`$.
! Pour cette valeur d'angle, il semble raisonnable d'étudier ce problème dans le sous-cadre
! de l'optique gaussienne, c'est à dire de considérer que les approximations de Gauss
! (ou approximations paraxiales) sont suffisantes pour décrire mes observations.<br>
!
! _En absence de critères plus précis, comme la taille du pixel d'un capteur matriciel photosensible_
! _qui enregistrerait une image réalisée dans son plan, on considère comme ordre de grandeur, que_
! _des angles $`\alpha`$ d'incidence et de réfraction inférieurs à $`\alpha\le 10°`$ permettent_
! _d'utiliser les conditions de Gauss pour réaliser les calculs._
! </details>
! <!--question 2-->
! <details markdown=1>
! <summary>
! Décris le système optique qui modélise la lentille-boule.
! </summary>
!
! * La lentille-boule se modélise comme deux dioptres sphériques partageant
! le même centre de courbure, et de rayons de courbures opposés (en valeurs algébriques).
!
! </details>
! <!--question 3-->
! <details markdown=1>
! <summary>
! Quelle est votre méthode de résolution ?
! </summary>
! <!-----* You don't use general equations 3a and 3b for a thick lens, they are too complicated 
! to remind, and you don't have in m3p2 to "use" but to "build a reasoning". And you don't
! know at this step how to handle with centered optical systems.-->
! * Je calcule l'image de la cathédrale par le premier dioptre sphérique $`DS_1`$ rencontré par la lumière
! lors de sa propagation depuis l'object "cathédrale" vers l'oeil final.<br>
! Cette image devient objet pour le second dioptre sphérique $`DS_2`$ rencontré par la lumière, ce
! qui me permet de calculer la taille, la position et le sens de l'image finale qui sera observée par l'oeil.
!
! * For a spherical refracting surface, general equations are :<br><br>
! $`\dfrac{n_{fin}}{\overline{SA_{ima}}}-\dfrac{n_{ini}}{\overline{SA_{obj}}}=\dfrac{n_{fin}-n_{ini}}{\overline{SC}}`$ 
! for the position.<br>
! $`\overline{M_T}=\dfrac{n_{ini}\cdot\overline{SA_{ima}}}{n_{fin}\cdot\overline{SA_{obj}}}`$ 
! for the transverse magnification.
!
! </details>
! <!--question 4-->
! <details markdown=1>
! <summary>
! How do you set down your calculations?
! </summary>
!
! * The optical axis is the straight line that joins the center C of the lens to my eye, 
! positively oriented in the direction of the light propagation for that observation, 
! so from the cathedral to my eye. 
! * First spherical refrating surface $`DS1`$ : $`\overline{S_1C_1}=+5\:cm`$, $`n_{ini}=1`$ (air) 
! and $`n_{fin}=1.5`$ (glass).<br>
!  Second spherical refrating surface $`DS2`$ : $`\overline{S_2C_2}=-5\:cm`$, $`n_{ini}=1.5`$ (glass) 
! and $`n_{fin}=1`$ (air)<br>
!  Distance between $`DS1`$ and $`DS2`$ vertices : $`\overline{S_1S_2}=+10\:cm`$<br>
!  Object cathedral $`AB`$ :  $`\overline{AB}=90\;m`$ and $`\overline{S_1A}=-400\;m`$<br>
!  Let us write $`\overline{A_1B_1}`$ the intermediate image (the image of the cathedral
! given by $`DS1`$.
!
!  * Specific equations for $`DS1`$ are :<br><br> 
! $`\dfrac{1.5}{\overline{S_1A_1}}-\dfrac{1}{\overline{S_1A}}=\dfrac{0.5}{\overline{S_1C_1}}`$ (équ. DS1a), 
! and $`\overline{M_T}=\dfrac{\overline{S_1A_1}}{1.5\cdot\overline{S_1A}}`$ (équ. DS1b)<br><br>
! Specific equations for $`DS2`$ are :<br><br> 
! $`\dfrac{1}{\overline{S_2A'}}-\dfrac{1.5}{\overline{S_2A_1}}=-\dfrac{0.5}{\overline{S_2C_2}}`$  (équ. DS2a),  and 
! $`\overline{M_T}=\dfrac{1.5\cdot\overline{S_2A'}}{\overline{S_2A_1}}`$ (équ. DS2b)<br><br>
! The missing link between these two sets of equations is :<br>
! $`\overline{S_2A_1}=\overline{S_2S_1}+\overline{S_1A_1}=\overline{S_1A_1}-\overline{S_1S_2}`$.
!
! </details>
! <!--question 5-->
! <details markdown=1>
! <summary>
! Do you see some approximation that can be done ? 
! </summary>
! * In the visible range, refractive index values of transparent material are in the range [1 ; 2],
! then the focal lengthes of a spherical refractive surface (object as well as image) are
! expected to remain in the same order of magnitude than the radius of curvature,
! so a few centimeters in this case (we talk in absolute value here). 
!
! * We can if we want just check this fact for $`DS1`$ ($`|S_1C_1|=5\;cm`$) using équation DS1 :<br>
! \- considering $`\overline{S_1A_1}\longrightarrow\infty`$ to obtain the object focal length
! $`\overline{S_1F_1}`$} we get :<br>
! $`-\dfrac{1}{\overline{S_1F_1}}=\dfrac{0.5}{\overline{S_1C_1}}`$ 
! $`\Longrightarrow=\overline{S_1F_1}=-10\;cm`$<br><br>
! \- considering $`\overline{S_1A}\longrightarrow\infty`$ to obtain the image focal length 
! $`\overline{S_1F'_1}`$ we get :<br>
! $`\dfrac{1.5}{\overline{S_1F'_1}}=\dfrac{0.5}{\overline{S_1C_1}}\Longrightarrow\overline{S_1F'_1}=+15\;cm`$
! 
! * The distance of the cathedral from the lensball $`|\overline{S_1A}|=90\;m`$ is huge
! compared to the object focal length $`|\overline{S_1F_1}|=10\;cm`$, we can consider 
! that the cathedral is at infinity from the lensball and so the image $`\overline{A_1B_1}`$ 
! of the cathedral stands quasi in the image focal plane of $`DS1`$ : 
! $`\overline {S_1A_1}=\overline {S_1F'_1}=+15cm`$. So we can directly use equation DS2a with :<br>
! $`\overline{S_2A_1}=\overline{S_2F'_1}=\overline{S_2S_1}+\overline{S_1F'_1}`$ 
! $`=\overline{S_1F'_1}-\overline{S_1S_2}=+15-10=+5\;cm`$..
!
! </details>
! <details markdown=1>
! <summary>
! Where is the image and how tall it is ?
! </summary>
!
! * To perform calculation, you must choose a unic lenght unit in your calculation, 
! here $`cm`$ or $`m`$. We choose $`m`$ below.
! * Equation DS1a gives :<br>
! $`\dfrac{1.5}{\overline{S_1A_1}}-\dfrac{1}{-400}=\dfrac{0.5}{0.05}`$ $`\Longrightarrow\overline{S_1A_1}=0.15\;m`$<br>
! With more than 2 significant figures, your calculator would tell you $`0.150037`$, 
! which nearly exactly the value of $`\overline{S_1F'_1}=+0.15\;m`$, so the approximation 
! $`\overline{S_1A_1}=\overline{S_1F'_1}`$ you could have done is fully justified.
! 
! * Equation DS2a gives :<br>
! $`\dfrac{1}{\overline{S_2A'}}-\dfrac{1.5}{-0.1+0.15}=\dfrac{-0.5}{-0.05}`$ 
! $`\Longrightarrow\overline{S_2A'}=0.025\;m`$
!
! * The final image is real, and stands 2.5 cm in front of the lensball in the side 
! of your eye. Do not bring your eye or camera too close of the lensball \!
!
! * The size of an image (transversally to the optical axis) is given by the transverse 
! magnification $`M_T`$.  By Definition $`M_T`$ is the ratio of the algebraic size of 
! the final image $`\overline{A'B'}`$  to the algebraic size of the initial object $`\overline{AB}`$.
! With an intermediate image, it can be break down :<br><br>
!  $`M_T=\dfrac{\overline{A'B'}}{\overline{AB}}`$ 
! $`=\dfrac{\overline{A'B'}}{\overline{A_1B_1}}\times\dfrac{A_1B_1}{\overline{AB}}`$<br><br>
! It is the product of the transverse magnifications of the cathedral introduced 
! by the two spherical refracting surfaces of the lensball. <br><br>
! $`\overline{M_T}`$ introduced by $`DS1`$ is 
! $`\overline{M_T}=\dfrac{\overline{S_1A_1}}{1.5\cdot\overline{S_1A}}`$
! $`=\dfrac{+0.15}{1.5\times(-400)}=-0.00025`$<br><br>
! $`\overline{M_T}`$ introduced by $`DS2`$ is 
! $`\overline{M_T}=\dfrac{1.5\cdot\overline{S_2A'}}{\overline{S_2A_1}}`$ 
! $`=\dfrac{1.5\cdot\overline{S_2A'}}{\overline{S_1A_1}-\overline{S_1S_2}}`$
! $`=\dfrac{1.5\cdot0.025}{+0.15-0.10} =0.75`$<br><br>
! So $`\overline{M_T}`$ introduced by the lensball is :<br><br>
! $`\overline{M_T}=-0.00025\times0.75`$ $`=-0.00019\approx-1.9\cdot10^{-4}`$<br><br>
! The image is  $`\dfrac{1}{-1.9\cdot10^{-4}}\approx5300`$ smaller than the cathedral.<br><br> 
! $`M_T=\dfrac{\overline{A'B'}}{\overline{AB}}\approx8\cdot10^{-4}`$ 
! $`\Longrightarrow\overline{A'B'}=\overline{AB} \times M_T`$
! $`=1.9\cdot10^{-4} \times 90\;m=-0.017\;m`$<br><br>
! The image is 1.7 cm height and it is reversed.
!</details>
!
!<!--question 7-->
!<details markdown=1>
!<summary>
! What is the apparent magnification of the cathedral ?
!</summary>
! * Apparent magnification = angular magnification = magnifying power.
!
! * As calculated previously, standing 400 metres from the cathedral, the 90 m heigh
! cathedral sustends the apparent angles of $`\alpha=arctan\left(\dfrac{90}{400}\right)=0.221\;rad=12.7°`$ 
! at your eye.<br>
! <br>
! * The image of the cathedral is 1.7 cm heigth and is located between the lens 
! (from its vertex $`S2`$) and your eyes and at 2.5cm from the lens. If your eye is
! 20cm away from the lens, so the distance eye-image is 17.5 cm (we use no algebraic values).
! Thus the image of the catedral subtends the apparent angle 
! $`\alpha'=arctan\left(\dfrac{1.7}{17.5}\right)=0.097\;rad=5.6°`$ at your eye.<br>
! <br>
! * The apparent magnification $`M_A`$ of the cathedral throught the lensball for my 
! eye in that position is<br>
!  $`M_A=\dfrac{\alpha'}{\alpha}=\dfrac{0.097}{0.221}=0.44`$.<br><br>
!  Taking into account that the image is reversed, the algebraic value of the apparent
! magnification is $`\overline{M_A}=-0.44`$.<br>
! <br>
! * You could obtained directly this algebraic value of $`M_A`$ by considering algebraic
! lengthes and angles values in the calculations :<br><br> 
! $`\overline{M_A}=\dfrac{\overline{\alpha'}}{\overline{\alpha}}`$
! $`=\dfrac  {arctan\left(\frac{-0.017}{-0.175}\right)} {arctan\left(\frac{90}{-400}\right)}`$ $`=\dfrac{0.097}{-0.221}=-0.44`$
!
! ![](lentille-boule-orleans-1bis.jpg)<br>
! _Cathedral of Orleans (France)_
! </details>
! </details>
! </details>
! </details>

!! *BEYOND* : The gravitationnal lensball (or Einstein's ring), due to a black hole or a galaxy.
!! Similarities, and differences.
!!
!! ![](Einstein-ring-free.jpg)
!!
!! <details  markdown=1>
!! <summary>
!! To see
!! </summary>
!! still to be done, in progress. 
!! </details>





  



