---
title: Synthèse
routable: false
visible: false
lessons:
    -
        slug: cylindrical-charge-or-current-distributions-local
        name: PARALLÈLE-3 : Distributions cylindriques, Gauss et Ampère locaux
        order: 3
---

<!--Commandes Latex spécifiques-->
$`\def\dens{\large{\varrho}\normalsize}`$
$`\def\oiint{\displaystyle\mathop{{\iint}\mkern-18mu \scriptsize \bigcirc}}`$
$`\def\Ltau{\Large{\tau}\normalsize}`$
$`\def\Sopen{\mathscr{S}_{\smile}}`$
$`\def\Sclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$
$`\def\Ssclosed{\mathscr{S}_{\scriptsize\bigcirc}}`$
$`\def\PSopen{\mathscr{S}_{\smile}}`$
$`\def\PSclosed{\mathscr{S}_{\displaystyle\tiny\bigcirc}}`$


$`\newcommand{\dpt}[1]{\overset{\large\bullet}{#1}}`$   
$`\newcommand{\ddpt}[1]{\overset{\large\bullet\bullet}{#1}}`$   

*Cours en construction*, **non validé**.    
![](https://m3p2.com/fr/temporary_ins/images/M3P2-validity-state-FR_L1200.jpg)   
![](https://m3p2.com/fr/temporary_ins/images/M3P2-maturity-3_L1200.jpg)<details>
<summary>Etape 3 : Ecriture : 1/3</summary>  
1. Appel à idées
2. Structuration 
3. Ecriture : 1/3
4. Ecriture : 2/3
5. Ecriture : 3/3
6. Relecture 
7. En test auprès d'étudiants
8. Validé, encore incomplet
9. Validé, base suffisante
10. Validé, opérationnel
</details>


##### Randonnée Contreforts :&nbsp; _physique , math appliquée_

---------------------------

##### Application du théorème d' **Ampère local** aux :


### **Distributions cylindriques de courants**

* Le terme **cylindrique** réfère à l'*aspect extérieur* de la distribution de courants.


#### Propriétés nécessaires au théorème d'Ampère

* Le théorème d'Ampère' sera utilisable si une distribution cylindrique de courants possède les deux éléments de symétrie suivants :
   * une *symétrie de révolution*
   * une **symétrie de translation**   
  
  *autour* et **selon** un même axe, *l'axe de révolution*.

<!---------un peu inutile ici---------
! *rappel* : un axe de *révolution* est un axe de *rotation d'ordre infini*.

* La cause du champ $`\overrightarrow{E}`$ (la charge électrique) étant un scalaire, tout plan contenant l'axe de révolution est plan de symétrie pour la charge électrique.
------------------------------------->

<!--ATTENTION : ce qui est ici en commentaire est probablement faux----------
de courant possède les deux éléments de symétrie suivants :
   * une *symétrie de révolution*
   * une **symétrie de translation**   
  
  *autour* et **selon** un même axe, *l'axe de révolution*.

! *rappel* : un axe de *révolution* est un axe de *rotation d'ordre infini*.
--------------------------------------------------------------------------->

#### Y a t-il plusieurs configurations vérifiant ces propriétés ?

* La cause du champ $`\overrightarrow{B}`$ étant vectorielle, *deux  configurations de* **courants** sont possibles. Le déplacement des charges peut s'effectuer :
   *  **en direction de l'axe de révolution** : c'est le cas d'un *fil électrique rectiligne* infini parcouru par un courant.   
      $`\Longrightarrow``$ tout plan contenant l'axe de révolution est plan de symétrie pour le courant.
   *  en **tournant circulairement autour de l'axe de révolution** : c'est le cas d'un *solénoïde* infini parcouru par un courant.   
      $`\Longrightarrow`$ tout plan contenant l'axe de révolution est plan d'anti-symétrie pour le courant.

----------------------

#### LES COURANTS S'ENROULENT AUTOUR DE L'AXE DE RÉVOLUTION <br><br> exemple : un solénoïde conducteur infini.

----------------------

#### Quel système de coordonnées spatiales choisir ?

* Le système de coordonnées *le mieux adapté* est le système de **coordonnées cylindriques $`(O,\rho,\varphi,z)`$**, 
   avec **$`Oz =\;`$ axe de révolution**, et où :
   * $`O`$ est le point de l'espace pris comme origine des coordonnées.
   * $`(\rho,\varphi,z)`$ sont les coordonnées cylindriques.
   
  et de repère orthonormé associé le *repère cylindrique $`\mathbf{(O, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}}, \overrightarrow{e_z})}`$*.



#### Comment modéliser un solénoïde ?


* **$`\mathbf{a}\;:`$** Cette distribution de courants s'approche de celle réalisée dans un *solénoïde de rayon R et de longueur L* 
parcouru par un *courant constant I*,   
lorsque le fil du solénoïde à un diamètre D suffisamment faible *(D<<R)* et que
le solénoïde est suffisamment long *(L>>R)*.   
<br>
_C'est le cas pour l'essentiel des bobines_
_destinée à réaliser un champ magnétique en leur centre. Hors un "Effet de bord" lorsque_ 
_l'on s'approche des extrémités de la bobine, le champ magnétique_
_calculé avec le théorème d'Ampère représente avec une très bonne précision celui présent à l'intérieur de la bobine._   


![](magnetostatics_bobine_modelisations_1_L1200.gif)

Le théorème d'Ampère nécessitant ici de considérer une distribution de courants présentant une **symétrie de révolution**
et une **symétrie de translation** respectivement *autour et selon l'axe $`Oz`$*, cela implique de modéliser la bobine par, soit :

* **$`\mathbf{b}\;:`$** des *spires jointives* perpendiculaires à l'axe $`Oz`$, de sections nulles et parcourues par un même
courant constant $`I`$.

* **$`\mathbf{c}\;:`$** un champ de *vecteur densité volumique de courant $`\overrightarrow{j}^{3D}`$*  qui s'enroule autour de l'axe $   
  _Dans le cas d'une bobine, il peut y avoir plusieurs couches de spires donnant une certaine épaisseur._

* **$`\mathbf{d}\;:`$** un champ de *vecteur densité surfacique de courant $`\overrightarrow{j}^{2D}`$* qui s'enroule autour de l'axe $`Oz`$.



#### Comment caractériser cette distribution de courant ?


* Dans le cas où la *section droite* du fil conducteur constituant le solénoïde est *négligée*, le **courant** est simplement décrit 
 par l'intensité *$`I`$* qui parcourt le solénoïde. Le **sens du courant** dans le solénoïde est *précisé par une flèche*.   
 _(en magnétostatique, le courant est constant, donc son sens ne varie pas au cours du temps)._   


* Dans le cas contraire où la *section droite* est *non négligée*, le courant est décrit par un
 **vecteur densité de courant $`\overrightarrow{j}`$**.
<br>
   * *Un courant s'enroulant atour de l'axe de révolution* implique **$`\overrightarrow{j}=j(\rho,\varphi,z)\,\overrightarrow{e_{\varphi}}`$**
   * L'*invariance par rotation* d'angle $`\Delta\varphi`$ quelconque impose **$`\require{\cancel} \overrightarrow{j} = \overrightarrow{j}(\rho,\xcancel{\varphi}, z)`$**.   
   * L'*invariance par translation* de longueur $`\Delta z`$ quelconque impose  **$`\require{cancel}\overrightarrow{j}= \overrightarrow{j}(\rho,\varphi, \xcancel{z})`$**.   
<br>
* *Au final*, le vecteur densité volumique de courant **$`\overrightarrow{j}`$** est **dirigé selon $`\overrightarrow{e_{\varphi}}`$**
 et **ne dépend que de $`\rho`$** :   
*$`\mathbf{\left.\begin{array}{l}
\overrightarrow{j}=j\,\overrightarrow{e_{\varphi}} \\
\overrightarrow{j}=\overrightarrow{j}\,(\rho, z) \\
\overrightarrow{j}=\overrightarrow{j}\,(\rho, \varphi)
\end{array}\quad\right\}
\,\Longrightarrow}`$* **$`\mathbf{\overrightarrow{j}=j_{\varphi}(\rho)\,\overrightarrow{e_{\varphi}}}`$**


#### De quelles coordonnées dépend $`\overrightarrow{B}`$ ?

* **L'effet** possède les *invariances de sa cause* :
$`\Longrightarrow`$**$`\mathbf{\overrightarrow{B}}`$** possède les *invariances de $`\overrightarrow{j}`$*

* $`\mathbf{\overrightarrow{j}=\overrightarrow{j}(\rho)\Longrightarrow}`$ **$`\mathbf{\overrightarrow{B}=\overrightarrow{B}(\rho)}`$**


#### Comment déterminer la direction de $`\overrightarrow{B}`$ ?

* *Par l'* **étude des symétries** *de la distribution de courant $`\overrightarrow{j}`$*.   
<br>
Que la distribution de courant soit modélisée par un courant $``I``$ parcourant le solénoïïde infini :

![](magnetostat-bobine-1-symetries-direction-B_v2_L1200.gif)

<br>
ou soit modélisée par un vecteur densité de courant $`\overrightarrow{j}`$ :

![](magnetostat-bobine-2-symetries-direction-B_L1200.gif)

1. Soit un **point $`M(\rho_M\,\varphi_M,z_M)`$ quelconque** de l'espace.
2. Le **plan $`P_1`$** qui contient le point $`M`$ et perpendiculaire à l'axe $`Oz`$ est *plan de symétrie* pour la distribution de courant.
3. Le champ magnétique **$`\overrightarrow{B}`$ étant un vecteur axial**, en tout point d'un plan de symétrie 
   il est perpendiculaire à ce plan. Le plan de symétrie $`P_1`$ étant déterminé, la
   *direction de $`\overrightarrow{B}`$, selon $`\overrightarrow{e_z}`$*, est 
   *totalement déterminée*.
4. _Étape non nécessaire :_    
_Le plan_ $`P_2`$ _qui contient le point $`M`$ et l'axe $`Oz`$ est_
 _plan d'anti-symétrie pour la distribution de courant. En tout point d'un plan_
_d'anti-symétrie, $`\overrightarrow{B}`$ vecteur axial est contenu dans ce plan, ce qui est bien vérifié._   


* De façon plus concise :   
<br>
**En tout point $`M`$** l'espace,   
*$`\left.\begin{array}{l} \overrightarrow{B}\;\text{vecteur axial} \\
P_1\,(M, \overrightarrow{e_{\rho}}, \overrightarrow{e_{\varphi}})\; \text{plan de symétrie}\end{array}\right\}\,\Longrightarrow`$* 
**$`\mathbf{\overrightarrow{B}=B_z\,\overrightarrow{e_z}}`$**

![](magnetostat-symetries-solenoide_L1200.jpg)   
<br>

#### Comment s'exprime $`\overrightarrow{B}`$ en tout point de l'espace ?

* Synthèse de l'étude des invariances et symétries de $`\overrightarrow{j}`$ :   
<br>
**En tout point $`M`$** de l'espace,
*$`\left.\begin{array}{l}
\text{Invariances}\Longrightarrow\overrightarrow{B}=\overrightarrow{B}(\rho) \\
\text{Symétries}\Longrightarrow\overrightarrow{B}=B_z\,\overrightarrow{e_z}
\end{array}\right\}\,\Longrightarrow`$* **$`\mathbf{\overrightarrow{B}=B_z(\rho)\,\overrightarrow{e_z}}`$**



#### Y-a-t'il des lieux où $`\overrightarrow{B}`$ est déjà totalement déterminé par les symétries et invariances ?

à faire


