---
title: Géométrie et coordonnées  proposition 2
published: false
routable: false
visible: false
lessons:
    - slug: geometry-coordinates-prop2-234-panorama-overview
      order: 3
    - slug: geometry-coordinates-prop2-4-parallel
      order: 2
    - slug: geometry-coordinates-4-linear
      order: 2

---

!!!!  <details>
!!!! <summary> Cours en construction, non validé à ce stade </summary>  
!!!! Publié mais invisible : n'apparait pas dans l'arborescence du site m3p2.com.   
!!!!  Ce cours est en phase très préliminaire, il n'est *pas validé par l'équipe pédagogique* à ce stade.   
!!!! Document de travail destiné uniquement aux équipes pédagogiques.
!!!! </details>

<!--MétaDonnée : ... -->

##### Randonnée Montagne

---------------------------------------------

### Géométrie et coordonnées

#### Pourquoi considérer des espaces de dimensions supérieures à trois ?

##### Qu'est-ce qu'un espace?

##### appel à idées...

faire des liens vers l'espace des phases, l'espace de Hilbert, l'espace-temps, ...

<br><br>

--------------------------------

#### Pourquoi considérer des systèmes de coordonnées non orthonormés ?

-------------------------------------

##### Pour décrire et caractériser la matière cristalline.

* Les **propriétés des cristaux** sont à la *base de nombreux composants en microélectronique, photonique et optique*.   
$`\Longrightarrow`$ l'étude des différentes structures  cristallines et des propriétés physiques qu'elles induisent est une **base de toute formation de physicien** de la matière condensée **ou d'ingénieur physicien** en microélectronique et instrumentation-mesure. 

<br>
*Symétries et structure atomique d'un cristal*

<image animée : structure atomique d'un cristal, réseau, motif, maille conventionnelle>

* Dans les **cristaux**, la matière est organisée selon un *motif d'atomes répété aux noeuds d'un* **réseau tri-dimentionnel aux directions non orthogonales** en général.    
Les cristaux se classent dans 7 systèmes cristallins.

* La *description de la matière* atomique se fait dans un *système d'axes* dont les *directions sont celles du réseau cristallin*   
$`\Longrightarrow`$ les **axes de coordonnées sont non orthogonaux** en général.

* Sur chaque axe de coordonnée, l'*unité de mesure* peut être choisie comme la *longueur de la maille cristalline dans la direction considérée*.   
$`\Longrightarrow`$ les **vecteurs de la base** associée à ces axes de coordonnées ne sont en général **pas unitaires**.  

<br>
*Étude des propriétés physiques anisotropes dans les cristaux*

* Cette *distribution anisotrope des atomes* dans les cristaux induit des **propriétés physiques non isotropes**.

* $`\Longrightarrow`$ **la réponse du cristal** (polarisation électrique, déformation, ... ) à une contrainte appliquée (champ électrique, variation de température, force, ...) **dépend de la direction** d'application de la contrainte.

* L'espace-temps utilisé *pour les calculs* est celui de la physique classique et quantique où **l'espace est euclidien**. Par simplicité *les calculs sont donc réalisés dans des* **bases orthonormées**.     
$`\Longrightarrow`$ pour chacun des 7 systèmes cristallins, une **règle de convention** indique la *passage des axes cristallographiques aux axes orthonormés* pour les calculs.

<br>
*Caractérisation structurale des cristaux*

<image animée : diffraction des X par un cristal, du reseau cristallin au réseau réciproque>

* La **détermination des directions cristallographiques** dans des matériaux monocristallins est souvent une première *étape importante* dans la réalisation de composants.

* Cette caractérisation *fait appel à des* **techniques de diffraction de rayons X** par la structure atomique périodique des cristaux.

* transformée de Fourier, réseau réciproque, base duale : à construire.

-------------------------------------

##### Pour décrire un espace-temps non euclidien

------------------------------------

* L'**objectif principal** étant de décrire le cadre géométrique de l'*espace-temps de la relativité générale*, et de construire les *outils d'intégration et de différentiation* dans ce cadre géométrique.   
Le cours de relativité générale, alors libéré de cet aspect géométrique déjà maîtrisé, se concentrera sur la relation entre la géométrique de l'espace-temps et son contenu en masse-énergie, et ses applications.

* Un **système de coordonnées** est une façon de *repérer des points dans un espace*, ou dans une partie importante d'un espace.

* En tout point d'un espace courbe, les **lignes de coordonnées** définissent les *directions des axes dans le plan tangent* à l'espace courbe en ce point.

* Dans un espace courbe, *un système de coordonnées* **ne peut pas toujours être orthogonal** sur tout l'espace qu'il couvre.

![](surface-non-euclidienne-form1-A_L1200.gif)

* De même, en un *même point* d'un espace, les **angles entre les lignes de coordonnées peuvent varier** dans le temps.

![](surface-non-euclidienne-form1-B_L1200.gif)

* Ainsi, même si **en chaque point,  un espace courbe** peut s'assimiler à un *plan euclidien* dans lequel des *coordonnées cartésiennes peuvent être définies*, mais cela **ne permet pas à repérer les points sur tout l'espace** couvert.

![](surface-non-euclidienne-form1-C_L1200.gif)

* Si l'*espace courbe* est **plongé dans un espace euclidien de dimension supérieure**, nous utiliserons un *système de coordonnées cartésiennes de l'espace euclidien*.

<figure animée à terminer>

figures à placer, en attente :

![](euclidian-geometry-no-problem-v2_L1200.gif)

![](non-euclidian-geometry-problem-v2_L1200.gif)

![](non-eudlidian-2D-question_L1200.jpg)

![](non-eudlidian-2D-extrinsic_L1200.gif)

![](non-eudlidian-2D-intrinsic_L1200.jpg)



* Il n'est ni nécessaire, ni obligatoire qu'un espace courbe soit plongé dans un espace euclidien de dimension supérieure.    
$`\Longrightarrow`$ la maîtrise des systèmes de coordonnées non orthonormées est nécessaire :   
   * pour le calcul des longueurs, surfaces, volumes, ...    
   * pour le calcul différentiel 

<figure animée à terminer>

<br><br><br>


------------------------------------

!   
! *SYMETRIES ET STRUCTURES ATOMIQUES  DES  CRISTAUX*  
!
! Fera très certainement l'objet d'un grand chapitre individuel.   
! Le titre pourra être changé.
!

<br><br><br>

-------------

!   
! *CARACTERISATION  STRUCTURALE  DES  CRISTAUX*  
!
! Fera très certainement l'objet d'un grand chapitre individuel.   
! Le titre pourra être changé.
!

<br><br><br>

--------------

!   
! *ESPACES NON  EUCLIDIENS*  
!
! Fera très certainement l'objet d'un grand chapitre individuel.   
! Le titre pourra être changé.
!


<br><br><br>

--------------


Stockage demo pour coordonnées non orthogonales dans un espace euclidien.

figure à faire

Idée : deux axes notés $`Ox1`$ et $`Ox2`$ non orthogonaux, sécants en $Ò`$, et une unité de mesure.

Si les axes des coordonnées sont orthogonaux, alors les projections orthogonale et parallèle mènent au même point projeté sur chaque axe.

Si les axes des coordooonnées ne sont pas orthogonaux, alors les projections orthogonale et parallèle mènent à des points projetés différents sur chaque axe.

Soient deux points U et V.

Coordonnées de ces points en projection parallèle : $`U=(u^1, u^2)`$ et $`V=(v^1, v^2)`$

Coordonnées de ces points en projection perpendiculaire : $`U=(u_1, u_2)`$ et $`V=(v_1, v_2)`$

Notons : 

* $`u`$ la distance entre $`O`$ et $`U`$.
* $`v`$ la distance entre $`O`$ et $`V`$.
* $`\theta`$ l'angle entre les sègments $`[OV]`$ et $`[OU]`$.
* $`\alpha`$ l'angle entre le sègment $`Ox1`$ et l'axe $`[OV]`$.
* $`\beta`$ l'angle entre le sègment $`[OU]`$ et l'axe $`Ox2`$.
* $`a = \dfrac{\pi}{2}-\beta-\theta-\alpha`$

L'idée est, en restant au niveau des coordonnées, de démontrer l'égalité :

$`u\,v\,\cos(\theta)=u_1\,v^1\,+\,u_2\,v^2`$

Démonstration :

$`u_1=u\cdot\cos(\alpha)`$

$`u^1=u\cdot\dfrac{\cos(a + \alpha)}{\cos(a)}`$

$`u_2=u\cdot\cos(\theta + \beta)=u\cdot\sin(a + \alpha)`$

$`u^2=u\cdot\dfrac{\sin(\alpha)}{\cos(a)}`$



$`v_1=v\cdot\cos(\theta + \alpha)`$

$`v^1=v\cdot\dfrac{\cos(a + \theta + \alpha)}{\cos(a)}`$

$`v_2=v\cdot\sin(a + \theta + \alpha)`$

$`v^2=v\cdot\dfrac{\sin(\theta + \alpha)}{\cos(a)}`$


$`\begin{equation}\begin{split}
u_1v^1+u_2v^2\,&=u\cdot\cos(\alpha)\cdot v\cdot\dfrac{\cos(a + \theta + \alpha)}{\cos(a)} \\
&\quad + u\cdot\sin(a + \alpha) \cdot v\cdot\dfrac{\sin(\theta + \alpha)}{\cos(a)}
\end{split}\end{equation}`$

$`\begin{equation}\begin{split}
u_1v^1+u_2v^2\,&= u\,v\,\dfrac{1}{\cos(a)} \times \\
& \quad \left[+\cos(\alpha)\,\cos(a + \theta + \alpha) \right. \\
& \left.\quad\;+\,\sin(a + \alpha)\,\sin(\theta + \alpha)\,\right]
\end{split}\end{equation}`$

En utilisant les relations trigonométriques

$`\cos(\theta + \alpha)=\cos(\theta)\cos(\alpha)-\sin(\theta)\sin(\alpha)`$

$`\sin(a + \alpha)=\sin(a)\cos(\alpha)+\sin(\alpha)\cos(a)`$

$`\sin(\theta + \alpha)=\sin(\theta)\cos(\alpha)+\sin(\alpha)\cos(\theta)`$

qui impliquent

$`\begin{equation}\begin{split}
\cos(a\,&\,+ \theta + \alpha)=\cos\left[a + (\theta + \alpha)\right] \\
& \\
&=\cos(a)\,\cos(\theta + \alpha)-\sin(a)\,\sin(\theta + \alpha) \\
& \\
&=+\cos(a)\,[\cos(\theta)\cos(\alpha)-\sin(\theta)\sin(\alpha)] \\
& \quad-\sin(a)\,[\sin(\theta)\cos(\alpha)+\sin(\alpha)\cos(\theta)]\\
& \\
&=+\cos(a)\cos(\theta)\cos(\alpha) \\
&\quad-\cos(a)\sin(\theta)\sin(\alpha) \\
& \quad-\sin(a)\sin(\theta)\cos(\alpha)\\
& \quad-\sin(a)\sin(\alpha)\cos(\theta)]
\end{split}\end{equation}`$

et

$`\begin{equation}\begin{split}
\sin(a +& \alpha)\,\sin(\theta + \alpha) \\
&=[\sin(a)\cos(\alpha)+\sin(\alpha)\cos(a)] \\
& \quad\times[\sin(\theta)\cos(\alpha)+\sin(\alpha)\cos(\theta)] \\
& \\
&= + \sin(a)\cos(\alpha)\sin(\theta)\cos(\alpha) \\
& \quad + \sin(a)\cos(\alpha)\sin(\alpha)\cos(\theta) \\
& \quad + \sin(\alpha)\cos(a)\sin(\theta)\cos(\alpha) \\
& \quad +\sin(\alpha)\cos(a)\sin(\alpha)\cos(\theta)
\end{split}\end{equation}`$

nous obtenons

$`\begin{equation}
\begin{split}
u_1v^1+u_2v^2 &= u\,v\,\dfrac{1}{\cos(a)} \times \\
& \left[\,+\,\cos(\alpha)\cos(a)\cos(\theta)cos(\alpha)\right.\\
&\;-\,\cos(\alpha)\cos(a)\sin(\theta)\sin(\alpha)\\
&\;-\,\cos(\alpha)\sin(a)\sin(\theta)\cos(\alpha)\\
&\;-\,\cos(\alpha)\sin(a)\sin(\alpha)\cos(\theta)\\
&\;+\, \sin(a)\cos(\alpha)\sin(\theta)\cos(\alpha)\\
&\;+\,\sin(a)\cos(\alpha)\sin(\alpha)\cos(\theta)\\
&\;+\,\sin(\alpha)\cos(a)\sin(\theta)\cos(\alpha)\\
 & \left.\;\;+\,\sin(\alpha)\cos(a)\sin(\alpha)\cos(\theta)\,\right]
\end{split}
\end{equation}`$

$`\begin{equation}
\begin{split}\require{cancel}
u_1v^1+u_2v^2 &= u\,v\,\dfrac{1}{\cos(a)} \times \\
& \left[\,+\,\cos(\alpha)\cos(a)\cos(\theta)cos(\alpha)\right.\\
&\;-\,\cos(\alpha)\cancel{\cos(a)\sin(\theta)}\sin(\alpha)\\
&\;-\,\cos(\alpha)\cancel{\sin(a)\sin(\theta)}\cos(\alpha)\\
&\;-\,\cos(\alpha)\cancel{\sin(a)\sin(\alpha)}\cos(\theta)\\
&\;+\,\sin(a)\cancel{\cos(\alpha)\sin(\theta)}\cos(\alpha)\\
&\;+\,\sin(a)\cancel{\cos(\alpha)\sin(\alpha)}\cos(\theta)\\
&\;+\,\sin(\alpha)\cancel{\cos(a)\sin(\theta)}\cos(\alpha)\\
 & \left.\;\;+\,\sin(\alpha)\cos(a)\sin(\alpha)\cos(\theta)\,\right]
\end{split}
\end{equation}`$

$`\begin{equation}
\begin{split}\require{cancel}
u_1v^1+u_2v^2 &= u\,v\,\dfrac{1}{\cos(a)} \times \\
& \quad\left[\,+\,\cos^2(\alpha)\cos(a)\cos(\theta)\right.\\
& \quad\left.\;\;+\,\sin^2(\alpha)\cos(a)\cos(\theta)\,\right] 
\end{split}\end{equation}`$

$`\begin{equation}
\begin{split}\require{cancel}
u_1v^1+u_2v^2 &= u\,v\,\dfrac{1}{\cos(a)} \times \\
& \left[\left(\cos^2(\alpha) + \sin^2(\alpha)\right)\,\cos(a)\cos(\theta)\right]
\end{split}\end{equation}`$

$`u_1v^1+u_2v^2 = u\,v\,\dfrac{\cos(a)\cos(\theta)}{\cos(a)}`$

$`u_1v^1+u_2v^2 = u\,v\,\cos(\theta)`$

C'est une propriété intéressante si l'on considère les vecteurs géométriques $`\overrightarrow{OU}`$ et $`\overrightarrow{OV}`$. On a un lien avec le produit scalaire de ces deux vecteurs.

Maintenant, il y a un gros morceau pour expliquer comment construire la base duale, ce qu'elle représente, pour exprimer un vecteur en base naturelle (avec ses composantes contravariantes) et en base duale (avec ses composantes covariantes). deux façons de voir les choses... Expliquer aussi les termes covariant et contravariant.


##### Stockage pour métrique

_Note : la métrique, lien entre l'invariant distance et les variations des coordonnées, n'est pas encore identifiée au produit scalaire des vecteurs de la base naturelle associée aux coordonnées. Ci-dessous, on montre qu'on peut toujours choisir une métrique symétrique par rapport à ses deux indices._

* Une métrique est symétrique par rapport à ses deux indices.   
<br>
**$`\mathbf{\large g_{ab}=g_{ba}}`$**    
<br>
   A priori un peu inutile tout ce qui suit ici. Pertinence à revoir...   
   <br>
   * Toute **métrique non symétrique** (NS) **$`\mathbf{g_{ab}^{NS}}`$** permet la *définition de deux composantes* :   
*$`\mathbf{g_{ab}^{S}}=\dfrac{g_{ab}^{NS}}{2}+\dfrac{g_{ba}^{NS}}{2}`$*, et    
*$`\mathbf{g_{ab}^{AS}}=\dfrac{g_{ab}^{NS}}{2}-\dfrac{g_{ba}^{NS}}{2}`$*    
<br>
    * la composantes *$`\mathbf{g_{ab}^{S}}`$* est *symétrique* (S) par rapport à ses deux indices $`a\text{ et }b`$, ce qui signifie que cette composante $`\mathbf{g_{ab}^{S}}`$ garde sa valeur par permutation de ses deux indices :   
      $`\mathbf{g_{ab}^{S}-g_{ba}^{S}}`$
      $`=\left(\dfrac{g_{ab}^{NS}}{2}+\dfrac{g_{ba}^{NS}}{2}\right)-\left(\dfrac{g_{ba}^{NS}}{2}+\dfrac{g_{ab}^{NS}}{2}\right)`$   
      $`\hspace{0,8 cm}=\require{cancel}\color{brown}{
      \xcancel{
      \dfrac{g_{ab}^{NS}}{2}-\dfrac{g_{ab}^{NS}}{2}
      }}+
      \color{blue}{
      \xcancel{
      \dfrac{g_{ba}^{NS}}{2}-\dfrac{g_{ba}^{NS}}{2}
      }}`$*$`\mathbf{=0}`$*   
      
      **$`\Longrightarrow\mathbf{g_{ab}^{S}=g_{ba}^{S}}`$**   
       
     et la composante *$`\mathbf{g_{ab}^{AS}}`$* est *anti-symétrique* (AS) par rapport à ses deux indices $`a\text{ et }b`$, ce qui signifie que cette composante $`\mathbf{g_{ab}^{AS}}`$ change de signe lorsque ses deux indices sont permutés :   
      $`\mathbf{g_{ab}^{AS}+g_{ba}^{AS}}`$
      $`=\left(\dfrac{g_{ab}^{NS}}{2}-\dfrac{g_{ba}^{NS}}{2}\right)+\left(\dfrac{g_{ba}^{NS}}{2}-\dfrac{g_{ab}^{NS}}{2}\right)`$   
      $`\hspace{0,8 cm}=\require{cancel}\color{brown}{
      \xcancel{
      \dfrac{g_{ab}^{NS}}{2}-\dfrac{g_{ab}^{NS}}{2}
      }}+
      \color{blue}{
      \xcancel{
      \dfrac{g_{ba}^{NS}}{2}-\dfrac{g_{ba}^{NS}}{2}
      }}`$*$`\mathbf{=0}`$*   
      
      **$`\Longrightarrow\mathbf{g_{ab}^{AS} = -\,g_{ba}^{AS}}`$**   
     <br>

    * Toute métrique non symétrique (NS) $`\mathbf{g_{ab}^{NS}}`$ *égale la somme de  sa composante symétrique $`\mathbf{g_{ab}^{S}}`$ et de sa composante anti-symétrique  $`\mathbf{g_{ab}^{AS}}`$* :   
**$`\mathbf{g_{ab}^{S}+g_{ab}^{AS}}`$**$`\;=\dfrac{g_{ab}^{NS}}{2}+\dfrac{g_{ba}^{NS}}{2}+\dfrac{g_{ab}^{NS}}{2}-\dfrac{g_{ba}^{NS}}{2}`$   
$`\hspace{1,6 cm}=\require{cancel}\color{brown}{\dfrac{g_{ab}^{NS}}{2}}\color{blue}{+\xcancel{\dfrac{g_{ba}^{NS}}{2}}}\color{brown}{+\dfrac{g_{ab}^{NS}}{2}}\color{blue}{-\xcancel{\dfrac{g_{ba}^{NS}}{2}}}`$    
**$`\mathbf{\hspace{1,6 cm}=g_{ab}^{NS}}`$**    
<br>

   * La *métrique* associée à un système de coordonnées **détermine l'invariant élémentaire $`ds`$**, et donc son carré $`ds^2`$ en chaque point $`M`$ :    
   <br>
   **$`\mathbf{ds^2_M}`$** $`\;\color{blue}{=\mathbf{g_{ab\,M}}}\,dx^a dx^b`$.    
   <br>
   ce qui se réécrit *avec les composantes symétriques et anti-symétriques* de la métrique :   
   <br>
     $`ds^2_M=;\color{blue}{\mathbf{g_{ab\,M}^S}}\,dx^a dx^b+;\color{blue}{\mathbf{g_{ab\,M}^{AS}}}\,dx^a dx^b`$.    
  en se souvenant que cette égalité est écrite en convention d'Einstein.

   *  En écriture traditionnelle *avec le signe somme*, elle s'écrit :   
  <br>
  $`\displaystyle ds^2_M=\color{blue}{\sum_{a=1}^{n}\sum_{b=1}^{n}}\left[g_{ab\,M}^S\,dx^a dx^b+g_{ab\,M}^{AS}\,dx^a dx^b\right]`$
  
  <br>
   *  **Pour tout couple $`\mathbf{(a_0, b_0)}`$** de valeurs particulières **avec $`\mathbf{a_0\ne b_0}`$** des indices appartenant à la somme $`\sum_{a=1}^{n}\sum_{b=1}^{n}`$, *le couple $`(b_0, a_0)`$ appartient aussi à la somme $`\sum_{a=1}^{n}\sum_{b=1}^{n}`$*. Ainsi le carré de l'invariant se réécrit :   
  <br>
    $`\displaystyle ds^2_M=\color{brown}{\sum_{a=1}^n \mathbf{g_{aa\,M}^{AS}}}\,(dx^a)^2`$
$`\displaystyle\,+ \color{blue}{\sum_{a=2}^n \sum_{b\lt a} (\mathbf{g_{ab\,M}^{AS} + g_{ba\,M}^{AS}})}\,dx^x dx^a`$

  <br>
   *   *Pour tout couple $`\mathbf{(a, b)}`$* d'indices, l'antisymétrie de la composante $`g_{ab}^{AS}`$ par rapport à ses indices entraîne :   
   <br>
   $`\left.\begin{array}{l}
   g_{ab}^{AS}= - g_{ba}^{AS} \\
   b = a
   \end{array}\right\}\Longrightarrow\; g_{aa}^{AS}=- g_{aa}^{AS}=0`$
   **$`\displaystyle\Longrightarrow\;\sum_{a=1}^n \mathbf{g_{aa\,M}^{AS}\,(dx^a)^2=0}`$**   
   <br>
      $`\left.\begin{array}{l}
   g_{ab}^{AS}= - g_{ba}^{AS} \\
   b \ne a
   \end{array}\right\}\Longrightarrow\; g_{ab}^{AS}+g_{ba}^{AS}=0`$
   $`\color{blue}{\displaystyle\Longrightarrow\;\sum_{a=2}^n \sum_{b\lt a} (\mathbf{g_{ab\,M}^{AS} + g_{ba\,M}^{AS})\,dx^x dx^a=0}}`$
   
   <br>
    * Ainsi **la composante antisymétrique $`\mathbf{g_{aa\,M}^{AS}}`$** de la métrique *ne contribue pas à l'invariant élémentaire $`\mathbf{ds}`$* :   
**$`\displaystyle\mathbf{ds^2_M}`$**$`\;=\displaystyle\sum_{a=1}^{n}\sum_{b=1}^{n}\,g_{ab\,M}^{NS}\,dx^a dx^b`$.    
  $`\require{cancel}\displaystyle\hspace{1 cm}=\sum_{a=1}^{n}\sum_{b=1}^{n}\left[g_{ab\,M}^S\,dx^a dx^b+\color{blue}{\xcancel{g_{ab\,M}^{AS}\,dx^a dx^b}}\right]`$   
   **$`\displaystyle\hspace{1 cm}\mathbf{=\sum_{a=1}^{n}\sum_{b=1}^{n}\,g_{ab\,M}^S\,dx^a dx^b}`$**   
   <br>
Seule la composante symétrique $`g_{ab\,M}^S`$ contribuant à l'invariant élémentaire $`ds`$, et la composante symétrique se déduisant facilement de toute métrique $`g_{ab\,M}^{NS}`$,   
 *nous ne considérerons dans la suite que des* **métriques symétriques** que nous écrirons simplement **$`\mathbf{g_{ab}}`$**.   




<!--============================
##### Variété

Figures temporaires, et tout à construire.

variété euclidienne

Punto de vista extrínseco / Point de vue extrinsèque / Extrinsic point of view 

p.v. : punto de vista / point de vue / point of view 

![](m3p2-N4-variete-extrinsec_euclid_L1200.gif)

Punto de vista intrínseco / Point de vue intrinsèque /  Intrinsic point of view 

![](m3p2-N4-variete-intrinsec-C.gif)


variété non euclidienne

Punto de vista extrínseco / Point de vue extrinsèque / Extrinsic point of view 

p.v. : punto de vista / point de vue / point of view 

![](m3p2-N4-variete-extrinsec.gif)

Punto de vista intrínseco / Point de vue intrinsèque /  Intrinsic point of view 

![](m3p2-N4-variete-intrinsec_A_L1200.gif)

 ##### Comment exprimer la variation d'un vecteur naturel lors d'un déplacement élémentaire $`\overrightarrow{ds}`$ ?
 
 d'un point $`M`$ à un point $`P`$ voisin?
 
 Plaçons-nous dans une variété de dimensions 2, que nous visualisons comme la surface courbe $`\mathscr{S}`$ représentée sur la figure.
 
 Choisissons un système de coordonnées $`x_1, x_2`$ sur $`\mathscr{S}`$.
 
 Soit deux points voisins $`M`$ et $`P`$ appartenant à $`\mathscr{S}`$. 
 
 Pour décomposer, les points $`M`$ et $`P`$ sont deux points voisins sur la ligne de coordonnées $`x^2`$ dans un systèmes de coordonnées $`(O,x^1, x^2)`$. 



simple test de visualisation ...

![](test-visualisation.jpg)   
 _Refaire cette figure avec deux lignes de coordonnées x1 et x2 non orthogonales dans chacun des plans tangents, ce qui impliquera de changer aussi les flèches. Retravailler le visage et la main, ou changer le personnage._
 
* Soient $`\overrightarrow{e_1}_M`$ et $`\overrightarrow{e_2}_M`$ les deux vecteurs de la base naturelle associée aux coordonnées $`(x^1, x^2)`$ au point $`M`$.

* Suivons le vecteur $`\overrightarrow{e_1}_M`$ dans un déplacement infinitésimal entre le point $`M`$ et le point $`P`$ voisin sur la ligne de la coordonnée $`x_2`$.

* Le vecteur $`\overrightarrow{e_1}_P`$ au point $`P`$ n'appartient pas à la même variété. Dans cette vision bidimensionnelle, les vecteurs $`\overrightarrow{e_1}_M`$ et $`\overrightarrow{e_1}_P`$ vivent dans deux plans différents non parallèles $`\mathscr{P}_M`$ et  $`\mathscr{P}_P`$. Il ne peut y avoir aucune expression des vecteurs de base naturelle $`\overrightarrow{e_1}_M`$ et $`\overrightarrow{e_2}_M`$ en $`M`$ en fonction des vecteurs  $`\overrightarrow{e_1}_P`$ et $`\overrightarrow{e_2}_P`$ en $`P`$.

* Imaginons ces deux variétés $`\mathscr{P}_M`$ et  $`\mathscr{P}_P`$ comme plongées dans une même variété $`\mathscr{E}`$ de dimension 3 euclidienne. Il est dès lors possible d'exprimer les quatre vecteurs 
$`\overrightarrow{e_1}_M`$, $`\overrightarrow{e_2}_M`$, $`\overrightarrow{e_1}_P`$ et $`\overrightarrow{e_2}_P`$ dans une même base de $`\mathscr{E}`$. En particulier pour l'exemple donné par la figure, il est possible d'exprimer le vecteur élémentaire $`d\overrightarrow{e_1}_M=\overrightarrow{e_1}_P-\overrightarrow{e_1}_M`$ dans la base choisie de $`\mathscr{E}`$, et il est possible de projeter ce vecteur élémentaire $`d\overrightarrow{e_1}_M`$ sur la variété $`\mathscr{P}_1`$

<!---------------------------
_Je reformaterai, réorganiserai et continuerai après. Mes déjà je rentre quelques équations liées à la figure adaptée à venir._   
_Comme la figure et l'exemple pris doivent restés au plus proche de ce qui est déjà assimilé, je garde pour un vecteur l'écriture $`\overrightarrow{e}`$ avec sa flèche, au lieu de l'écriture en caractère gras  $`\mathbf{e}`$ usuelle qui sera introduite en parallèle._

* Soit  $`\left.\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\right|_{\mathscr{P}_M}`$ la projection de $`\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}`$ sur le plan tangent $`\mathscr{P}_M`$ à la courbe $`\mathscr{S}`$ au point $`M`$.  
Cette projection $`\left.\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\right|_{\mathscr{P}_M}`$ peut être décomposée sur les vecteurs de la base naturelle $`\left(\overrightarrow{e_1}_M,\overrightarrow{e_2}_M\right)`$ au point $`M`$, associée aux coordonnées $`(x_1, x_2)`$ choisies sur $`\mathscr{S}`$ :   
<br>
$`\left.\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\right|_{\mathscr{P}_M}
=\left(\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\cdot\overrightarrow{e_1}_M\right)\,\overrightarrow{e_1}_M`$
$`\;+\left(\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\cdot\overrightarrow{e_2}_M\right)\,\overrightarrow{e_2}_M`$

$`\hspace{0,8 cm}=\Gamma_{12}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{12}^{\;2}\,\overrightarrow{e_2}_M`$

Le vecteur $`\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}`$, qui représente la variation du vecteur $`\overrightarrow{e_1}_M`$ par unité de longueur sur la ligne de coordonnées $`x^2`$ au point $`M`$ de la variété bidimensionnelle $`\mathscr{S}`$, n'appartient pas à la variété euclidienne $`\mathscr{P}_1`$ tangente en $`M`$ à $`\mathscr{S}`$.    
Pour utiliser les mots plus usuels référant à l'espace euclidien 3D de la physique newtonienne, qui contient des surfaces courbes ou des plans 2D, ainsi que des lignes courbes ou des axes 1D, nous pouvons dire :   
----------------------------------->

<!--================

* Le vecteur $`\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}`$, qui représente la variation du vecteur $`\overrightarrow{e_1}_M`$ par unité de longueur sur la ligne de coordonnées $`x^2`$ au point $`M`$ de la surface courbe $`\mathscr{S}`$, n'appartient pas au plan euclidienne $`\mathscr{P}_M`$ tangent en $`M`$ à $`\mathscr{S}`$. 

* Ce vecteur Le vecteur $`\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}`$ appartient à l'espace euclidien 3D dans lequel la surface courbe $`\mathscr{S}`$ est plongée, ou il est un intermédiaire mathématique utile dans le cas où il n'existe pas d'espace 3D dans lequel $`\mathscr{S}`$ serait plongée. Il est en effet toujours possible d'imaginer un tel espace intermédiaire.




* Par contre ce vecteur $`\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}`$ peut être projeté dans le plan tangent au point $`M`$ à la surface courbe $`\mathscr{S}`$. Cette projection $`\left.\dfrac{\partial \overrightarrow{e_2}_M}{\partial x^1}\right|_{\mathscr{P}_M}`$ peut alors se décomposer selon les vecteurs de la base naturelle $`\left(\overrightarrow{e_1}_M,\overrightarrow{e_2}_M\right)`$ associée au point $`M`$ aux coordonnées $`(x^1,x^2)`$ s'écrit :   
<br>

==================-->

* $`\left.\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\right|_{\mathscr{P}_M}
=\left(\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\cdot\overrightarrow{e_1}_M\right)\,\overrightarrow{e_1}_M`$
$`\;+\left(\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\cdot\overrightarrow{e_2}_M\right)\,\overrightarrow{e_2}_M`$ ,   
<br>
ce que nous pouvons reécrire :   
<br>
**$`\displaystyle\left.\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2} \right|_{\mathscr{P}_M}
=\sum_{b=1}^2 \left(\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\cdot\overrightarrow{e_b}_M \right)\,\overrightarrow{e_b}_M`$**


* Il est important à ce stade de bien différencier les deux composantes contravariantes que nous noterons $`\Gamma_{12}^{\;b}`$ de $`\left.\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2} \right|_{\mathscr{P}_M}`$ qui sont deux nombres réels, des deux composantes vectorielles $`\Gamma_{12\,M}^{\;b}\,\overrightarrow{e_{b\,M}}`$ :   
<br>
$`\displaystyle\overbrace{\left.
\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\right|_{\mathscr{P}_M}}^{\color{brown}{\large{\mathbf{\in\,\mathscr{P}_M}}}}
=\sum_{b=1}^{2}\overbrace{\underbrace{\left(\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\cdot\overrightarrow{e_b}_M\right)}_{\color{brown}{\large{\mathbf{=\,\Gamma_{12\,M}^{\;b}\,\in\,\mathbb{R}}}}}\,\overrightarrow{e_b}_M}^{\color{brown}{\large{\mathbf{=\,\Gamma_{12\,M}^{\;b}\,\overrightarrow{e_b}_M\,\in \,\mathscr{P}_M}}}}`$   

* Nous obtenons **de même**,   
<br>
$`\left.\dfrac{\partial \overrightarrow{e_2}_M}{\partial x^1}\right|_{\mathscr{P}_M}
=\left(\dfrac{\partial \overrightarrow{e_2}_M}{\partial x^1}\cdot\overrightarrow{e_1}_M\right)\,\overrightarrow{e_1}_M`$
$`\;+\left(\dfrac{\partial \overrightarrow{e_2}_M}{\partial x^1}\cdot\overrightarrow{e_2}_M\right)\,\overrightarrow{e_2}_M`$   
<br>
$`\hspace{0,8 cm}=\Gamma_{21\,M}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{21\,M}^{\;2}\,\overrightarrow{e_2}_M`$   

   ---

   <br>
      $`\left.\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^1}\right|_{\mathscr{P}_M}
=\left(\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^1}\cdot\overrightarrow{e_1}_M\right)\,\overrightarrow{e_1}_M`$
$`\;+\left(\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^1}\cdot\overrightarrow{e_2}_M\right)\,\overrightarrow{e_2}_M`$   
<br>
$`\hspace{0,8 cm}=\Gamma_{11\,M}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{11\,M}^{\;2}\,\overrightarrow{e_2}_M`$

   ---
   
   <br>
     $`\left.\dfrac{\partial \overrightarrow{e_2}_M}{\partial x^2}\right|_{\mathscr{P}_M}
=\left(\dfrac{\partial \overrightarrow{e_2}_M}{\partial x^2}\cdot\overrightarrow{e_1}_M\right)\,\overrightarrow{e_1}_M`$
$`\;+\left(\dfrac{\partial \overrightarrow{e_2}_M}{\partial x^2}\cdot\overrightarrow{e_2}_M\right)\,\overrightarrow{e_2}_M`$   
<br>
$`\hspace{0,8 cm}=\Gamma_{22\,M}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{22\,M}^{\;2}\,\overrightarrow{e_2}_M`$


#### Pourquoi condenser l'écriture mathématique ?

<!----------------------------------
à construire, surement pour partie principale, idées :

* Notre "champ de représentation mentale" est limité. 
* Un raisonnement, une modélisation physique est une représentation mentale souvent longue et complexe.
* doit se décomposer en étapes suffisamment petites pour qu'à chaque étape, la représentation mentale soit maîtrisée et que nous y percevions du sens.
* Nécessité d'un support extérieur pour stocker et afficher les différentes étapes.
* En terme mathématique : succession de différentes assertions avec leurs écritures mathématiques.
* Processus d'assimilation d'un concept est un processus qui prend du temps, mais une fois acquis une écriture mathématique "plus simple" de ce concept permet aussi de soulager la charge mentale associée à la compréhension d'une étape, donc de faire des étapes plus denses et au final pour un même nombre d'étape, de maîtriser des raisonnements et des modélisations plus complexes.

bref, la simplification de l'écriture mathématique participe à donner du sens à des assertions de plus en plus denses.

mal dit tout cela ...

Aparté "au-delà" à construire, puis à placer dans le sous-chapitre correspondant dans la partie principale :

!! *Au-delà* : à construire ... à mettre au point     
!! Une analogie avec la linguistique : lorsqu'un concept signifiant et fréquemment utilisé est identifié (exemple 1 : "lieu de vie protégé des éléments extérieurs tels la pluie, le froid, ... et permettant la réalisation des fonctions journalières vitales comme préparer à manger, manger, se laver, dormir" (voire les définitions juridiques des fonctions, qui s'affranchissent souvent du mot représentatif car celui-ci peut être détourné); exemple 2 : "une maison minimaliste sur roues"), et une fois que, après un long travail notre esprit se l'est bien approprié, un "mot" représentatif de ce concept est inventé. Ce mot permet ensuite de construire des pensées plus simples, et donc "pour une même longueur d'expression" de construire des descriptions, des phrases exprimant des pensées plus complexes.   
!! exemple 1 : "lieu de vie protégé des éléments extérieurs tels la pluie, le froid, ... et permettant la réalisation des fonctions journalières vitales comme préparer à manger, manger, se laver, dormir" = "maison".   
!! exemple 2 : "une maison minimaliste sur roues" = "caravane".   
!! Au total, pour une même longueur d'expression : exemple "une maison minimaliste sur roues" et "je passe des vacances en caravane", l'identification des concepts à des mots permet d'exprimer une même pensée de façon plus concise et compréhensible.   
!! Exemple : "je passe des vacances en caravane"   
!! est plus simple et signifiant que    
!! "je passe des vacances dans un lieu de vie minimaliste car sur roues, mais protégé des éléments extérieurs tels la pluie, le froid,... et permettant la réalisation des fonctions journalières vitales comme préparer à manger, manger, se laver, dormir".
----------------------->


#### Comment condenser l'écriture mathématique ?

* Les quatre expressions précédentes peuvent s'écrire **de façon de plus en plus concise** en posant   
<br>
**$`\mathbf{\forall (a,b)\in\{1 , 2\}\times \{1 , 2\}}\;`$** ,   
   * *avec un signe somme* :   
<br>
**$`\displaystyle\left.\dfrac{\partial \overrightarrow{e_a}_M}{\partial x^b}\right|_{\mathscr{P}_M}`$**
$`\displaystyle\;=\color{blue}{\sum_{c=1}^2}\, \left(\dfrac{\partial \overrightarrow{e_a}_M}{\partial x^b}\cdot\overrightarrow{e_c}_M\right)\,\overrightarrow{e_c}_M`$   
<br>
**$`\displaystyle\hspace{0,8cm}=\sum_{c=1}^2\,\Gamma_{ab\,M}^{\;c}\,\overrightarrow{e_c}_M`$**

   * *sans préciser le point d'application $`M`$*. En effet les valeurs des différents coefficients varient en chaque point (ce sont des champs scalaires) mais les expressions de ces coefficients sont locales et générales, identiques en tout point de la variété :   
<br>
$`\require{cancel}\displaystyle\left.\dfrac{\partial \overrightarrow{e_a}_\color{blue}{\xcancel{\mathbf{\large M}}}}{\partial x^b}\right|_{\mathscr{P}_\color{blue}{\mathbf{\xcancel{M}}}}`$
$`\displaystyle\;=\sum_{c=1}^2\, \left(\dfrac{\partial \overrightarrow{e_a}_\color{blue}{\mathbf{\xcancel{M}}}}{\partial x^b}\cdot\overrightarrow{e_c}_\color{blue}{\mathbf{\xcancel{M}}}\right)\,\overrightarrow{e_c}_\color{blue}{\mathbf{\xcancel{M}}}`$   
<br>
$`\Longrightarrow\quad`$
**$`\displaystyle\left.\dfrac{\partial \overrightarrow{e_a}}{\partial x^b}\right|_{\mathscr{P}}
=\sum_{c=1}^2\,\Gamma_{ab}^{\;c}\,\overrightarrow{e_c}`$**

   * puis *en convention d'Einstein*, en remarquant que l'indice c apparaît deux fois dans le produit de terme de droite :   
<br>
**$`\left.\dfrac{\partial \,\overrightarrow{e_a}}{\partial x^b}\right|_{\mathscr{P}}`$**
$`\require{cancel}\displaystyle\;=\color{blue}{\xcancel{\sum_{c=1}^2}}\left(\dfrac{\partial \,\overrightarrow{e_a}}{\partial x^b}
\cdot\overrightarrow{e_\mathbf{\large\color{blue}{c}}}\right)\,\overrightarrow{e_\mathbf{\large\color{blue}{c}}}`$   
<br>
$`\hspace{0,8 cm}=\left(\dfrac{\partial \,\overrightarrow{e_a}}{\partial x^b}
\cdot\overrightarrow{e_\mathbf{\large\color{blue}{c}}}\right)\,\overrightarrow{e_\mathbf{\large\color{blue}{c}}}`$**$`\;=\Gamma_{ab}^c\,\overrightarrow{e_c}`$**

   * puis avec la nouvelle écriture, les *caractères gras réservés vecteurs* :   
<br>
**$`\left.\dfrac{\partial \,\mathbf{e_a}}{\partial x^b}\right|_{\mathscr{P}}`$**$`\;=\left(\dfrac{\partial \,\color{blue}{\mathbf{e_a}}}{\partial x^b}
\cdot\color{blue}{\mathbf{e_c}}\right)\,\color{blue}{\mathbf{e_c}}`$**$`\;=\Gamma_{ab}^{\;c}\,\mathbf{e_c}`$**

   * Et enfin avec l'*écriture réduite de la différentiation partielle* , $`\partial_b\mathbf{e_a}=\dfrac{\partial_\mathbf{e_a}}{\partial b}`$ :    
<br>
**$`\left.\partial_b \mathbf{e_a}\right|_{\mathscr{P}}`$**$`\;=\left(\color{blue}{\partial_b \mathbf{e_a}}\cdot\mathbf{e_c}\right)\,\mathbf{e_c}`$**$`\;=\Gamma_{ab}^{\;c}\,\mathbf{e_c}`$**

! préparer des petits exercices de compréhension d'écriture mathématique, de rapidité de compréhension et de manipulation, d'automatisation, à placer dans la partie "au-delà". Peut-être faudra t-il scinder en deux la partie au-delà, av ec une vraie partir "pour éller au-delà", et une partie "exercices/problèmes". A voir.

#### Que sont les "coefficients de connexion" ?

à construire :

* "**Coefficients de connexion**" = "**Symboles de Christoffel**"

* Ce sont les coefficients **$`\Large\Gamma_{ab}^{\;c}`$**

* *Chaque indice* $`a,b,c`$ peut prendre *autant de valeurs entières que le nombre de dimensions* de la variété considérée du point de vue intrinsèque.

   * variété de **dimension 2** $`\Longrightarrow\;(a,b,c)\in\{1,2\}^3\;\Longrightarrow; 3^2=\;`$ *6 coefficients* $`\Gamma_{ab}^{\;c}`$.

   * variété de **dimension 3** $`\Longrightarrow\;(a,b,c)\in\{1,2,3\}^3\;\Longrightarrow\; 3^3=\;`$  *27 coefficients* $`\Gamma_{ab}^{\;c}`$.

   * variété de **dimension 4** $`\Longrightarrow\;(a,b,c)\in\{1,2,3,4\}^3\;\Longrightarrow\; 4^3=\;`$  *256 coefficients* $`\Gamma_{ab}^{\;c}`$

Dans chaque cas le nombre de coefficients de connexion indépendants diminue si l'on considère une métrique symétrique ou non... Savoir si on en parle avant, auquel cas il faut en parler.

un aparté "au-delà", à construire, puis placer dans la partie principale :

!! *Au-delà* : à construire : relativité générale, 4 dimensions, 1, 2 et 3 indices d'espace, indice 0 souvent réservé au temps pour indiquer malgré tout son aspect spécial dans notre perception de notre monde.

#### Quel sens physique donner aux "coefficients de connexion" ?


#### Comment relier la connexion à la métrique ?

Figure à créer. Localement, en tout point M sont connus les coefficient de la métrique en ce point, et leurs dérivées partielles selon chacune des coordonnées de la métrique.

L'**objectif** est d'**exprimer les $`\Gamma_{ab}^{\;c}`$** *en fonction des $`\mathbf{g_{ab}}`$ et des $`\mathbf{\dfrac{\partial \,g_{ab}}{\partial x^c}}`$*.

Nous considérons les **variétés** :

* **continues et différenciables**   
$`\Longrightarrow`$ en tout point de la variété *sont connues ou calculables* :
    * les coefficients *$`\mathbf{g_{ab}}`$* de la métrique associée aux coordonnées $`x^a`$ et $`x^b`$,
    * les dérivées partielles *$`\mathbf{\dfrac{\partial \,g_{ab}}{\partial x^c}}`$* de cette métrique,

* **$`\mathbf{\large g_{ab}=g_{ba}}`$**   

* Nous ne considérons que des *variétés sans torsion*, donc telles que :     **$`\mathbf{\large\Gamma_{ab}^{\,c}=\Gamma_{ba}^{\,c}}`$**

------------------

Ici, calcul d'un coefficient de connexion particulier en relation directe avec la figure. Refaire les figures.
   
Calculons d'abord les coefficients $`\dfrac{\partial \,g_{ab}}{\partial x^c}`$ dans le cadre d'une variété de dimension 2 : 

* **$`\mathbf{\dfrac{\partial \,g_{11}}{\partial x^2}}`$**$`\;=\dfrac{\partial \left(\overrightarrow{e_1}\cdot\overrightarrow{e_1}\right)}{\partial x^2}`$   
<br>
$`\hspace{0,8 cm}=2\times\left.\dfrac{\partial \overrightarrow{e_1}}{\partial x^2}\right|_{\mathscr{P}}\cdot\overrightarrow{e_1}`$   
<br>
$`\hspace{0,8 cm}=
2\times \left(\Gamma_{12}^{\;1}\,\overrightarrow{e_1}+\Gamma_{12}^{\;2}\,\overrightarrow{e_2}\right)\cdot\overrightarrow{e_1}`$   
<br>
$`\hspace{0,8 cm}=
2 \times
\left(\Gamma_{12}^{\;1}\;\overrightarrow{e_1}\cdot\overrightarrow{e_1}\right.`$
$`\left.\;+\;\Gamma_{12}^{\;2}\;\overrightarrow{e_2}\cdot\overrightarrow{e_1}\right)`$    
<br>
**$`\mathbf{\hspace{0,8 cm}=
2 \left(\Gamma_{12}^{\;1}\;g_{11}\;+\;\Gamma_{12}^{\;2}\;g_{21}\right)}`$**

* **$`\mathbf{\dfrac{\partial \,g_{22}}{\partial x^1}}`$**$`\;=\dfrac{\partial \left(\overrightarrow{e_2}\cdot\overrightarrow{e_2}\right)}{\partial x^1}`$   
<br>
$`\hspace{0,8 cm}=2\times\left.\dfrac{\partial \overrightarrow{e_2}}{\partial x^1}\right|_{\mathscr{P}}\cdot\overrightarrow{e_2}`$   
<br>
$`\hspace{0,8 cm}=
2\times \left(\Gamma_{21}^{\;1}\,\overrightarrow{e_1}+\Gamma_{21}^{\;2}\,\overrightarrow{e_2}\right)\cdot\overrightarrow{e_2}`$   
<br>
$`\hspace{0,8 cm}=
2 \times
\left(\Gamma_{21}^{\;1}\;\overrightarrow{e_1}\cdot\overrightarrow{e_2}\right.`$
$`\left.\;+\;\Gamma_{21}^{\;2}\;\overrightarrow{e_2}\cdot\overrightarrow{e_2}\right)`$    
<br>
**$`\mathbf{\hspace{0,8 cm}=
2 \left(\Gamma_{21}^{\;1}\;g_{12}\;+\;\Gamma_{21}^{\;2}\;g_{22}\right)}`$**

---------
Ici, calcul d'un coefficient de connexion particulier en relation directe avec la figure. Refaire les figures.
<br>

**$`\mathbf{g^{11}\,\dfrac{\partial \,g_{11}}{\partial x^2}+g^{12}\,\dfrac{\partial \,g_{22}}{\partial x^1}}`$**   
$`\begin{align*}\hspace{1,0 cm} &\;\\
&=\quad g^{11}\times 2 \left(\Gamma_{12}^{\;1}\;g_{11}+\;\Gamma_{12}^{\;2}\;g_{21}\right) \\
&\quad +g^{12}\times 2 \left(\Gamma_{21}^{\;1}\;g_{12}+\;\Gamma_{21}^{\;2}\;g_{22}\right)
\end{align*}`$

Utilisons les égalités *$`\mathbf{\Gamma_{21}^{\;1}=\Gamma_{12}^{\;1}}`$*
et $`\Gamma_{21}^{\;2}=`\Gamma_{12}^{\;2}`$,   
$`\begin{align*}\hspace{1,0 cm} &\;\\
&=\quad g^{11}\times 2 \left(\Gamma_{12}^{\;1}\;g_{11}\;+\;\Gamma_{12}^{\;2}\;g_{21}\right) \\
&\quad +g^{12}\times 2 \,\left(\mathbf{\color{blue}{\Gamma_{12}^{\;1}}}\;g_{12}\;+\;\mathbf{\color{blue}{\Gamma_{12}^{\;2}}}\;g_{22}\right)
\end{align*}`$

Regroupons les termes de façon différente,    
$`\begin{align*}\hspace{1,0 cm} &\;\\
&=\quad 2 \,\Gamma_{12}^{\;1}\left(\mathbf{\color{blue}{g^{11} g_{11}+g^{12} g_{21}}}\right) \\
&\quad +2 \,\Gamma_{12}^{\;2}\left(\mathbf{\color{blue}{g^{11} g_{12}+g^{12} g_{22}}}\right)
\end{align*}`$

Réécrivons *avec le signe somme*, pour cette variété de dimension $`n=2`$,    
$`\displaystyle
\hspace{1,0 cm}=\left( 2\,\Gamma_{12}^{\;1}\color{blue}{\sum_{a=1}^{n} \mathbf{g^{1a} g_{a1}}}\right) +\left(2\,\Gamma_{12}^{\;2}\color{blue}{\sum_{a=1}^{n} \mathbf{g^{1a} g_{a2}}}\right)`$

puis en *notation d'Einstein*,        
$`\hspace{1,0 cm}= 2 \,\Gamma_{12}^{\;1}\, \mathbf{\color{blue}{g^{1a} g_{a1}}} + 2 \,\Gamma_{12}^{\;2}\, \mathbf{\color{blue}{g^{1a} g_{a2}}}`$

La *propriété $`\mathbf{g^{ba}\,g_{ac}=\delta^b_c}`$* de toute métrique exprimée en notation d'Einstein simplifie l'expression :   
*$`g^{11}\,\dfrac{\partial \,g_{11}}{\partial x^2}+g^{12}\,\dfrac{\partial \,g_{22}}{\partial x^1}`$*
$`\;=2 \,\Gamma_{12}^{\;1} \,\underbrace{\color{blue}{\mathbf{\delta^1_1}}}_{\color{brown}{\mathbf{=\,1}}} + 2 \,\Gamma_{12}^{\;2} \,\underbrace{\color{blue}{\mathbf{\delta^1_2}}}_{\color{brown}{\mathbf{=\,0}}}`$
**$`\mathbf{\;=2\,\Gamma_{12}^{\;1}}`$**

Et nous obtenons au final l'expression du coefficient $`\mathbf{\Gamma_{12}^{\;1}}`$ en fonction des coefficients de la métrique et de leurs dérivées partielles :   
**$`\mathbf{\Gamma_{12}^{\;1}=\dfrac{1}{2}\left(g^{11}\,\dfrac{\partial \,g_{11}}{\partial x^2}+g^{12}\,\dfrac{\partial \,g_{22}}{\partial x^1}\right)}`$** 

@@@@@@@@@@@@@@@@@



$`\mathbf{\dfrac{\partial \,g_{21\,M}}{\partial x^1}}`$**$`\;=\dfrac{\partial \left(\overrightarrow{e_2}_M\cdot\overrightarrow{e_1}_M\right)}{\partial x^1}`$

$`\hspace{0,8 cm}=\left.\dfrac{\partial \overrightarrow{e_2}_M}{\partial x^1}\right|_{\mathscr{P}_M}\cdot\overrightarrow{e_1}_M`$
$`\;+\left.\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^1}\right|_{\mathscr{P}_M}\cdot\overrightarrow{e_2}_M`$

$`\hspace{0,8 cm}=
\left(\Gamma_{21}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{21}^{\;2}\,\overrightarrow{e_2}_M\right)\cdot\overrightarrow{e_1}_M`$
$`\;+\left(\Gamma_{11}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{11}^{\;2}\,\overrightarrow{e_2}_M\right)\cdot\overrightarrow{e_2}_M`$

$`\hspace{0,8 cm}=
\Gamma_{21}^{\;1}\;\overrightarrow{e_1}_M\cdot\overrightarrow{e_1}_M`$
$`\;+\;\Gamma_{21}^{\;2}\;\overrightarrow{e_2}_M\cdot\overrightarrow{e_1}_M`$
$`\;+\;\Gamma_{11}^{\;1}\;\overrightarrow{e_1}_M\cdot\overrightarrow{e_2}_M`$
$`\;+\;\Gamma_{11}^{\;2}\;\overrightarrow{e_2}_M\cdot\overrightarrow{e_2}_M`$

**$`\mathbf{\hspace{0,8 cm}=
\Gamma_{21}^{\;1}\;g_{11}\;+\;\Gamma_{21}^{\;2}\;g_{21}}`$
$`\mathbf{\;+\;\Gamma_{11}^{\;1}\;g_{12}\;+\;\Gamma_{11}^{\;2}\;g_{22}}`$**


@@@@@@@@@@@@@@@@@@

Faire les autres coefficients.

Ici, c'était pour une variété de dimension 2, pour coller à la vision géométrique limité des figures.   
Il faudra donner l'expression générale des coefficients de connexion en fonction de la métrique

**$`\large{\Gamma_{ab}^{\;c}=\dfrac{1}{2}\,g^{ad}\,\left(\dfrac{\partial \,g_{dc}}{\partial x^b}+ \dfrac{\partial \,g_{bd}}{\partial x^c}- \dfrac{\partial \,g_{bc}}{\partial x^d}\right)}`$**   

ou


**$`\mathbf{\large{\Gamma_{ab}^{\;c}=\dfrac{1}{2}\,g^{ad}\,\left(\dfrac{\partial \,g_{dc}}{\partial x^b}+ \dfrac{\partial \,g_{bd}}{\partial x^c}- \dfrac{\partial \,g_{bc}}{\partial x^d}\right)}}`$**   

  
avant ou après l'étude du coeffcient particulier ?

Dans la partie principale, l'idée est de faire l'inverse, donner la démonstration générale puis d'en déduire les expressions dans le cas où la variété est de dimension 2.

Il faut passer, en l'expliquant, de    
$`\left.\dfrac{\partial \,\mathbf{e_a}}{\partial x^b}\right|_{\mathscr{P}}=\Gamma_{ab}^{\;c}\,\mathbf{e_c}`$   
à      
$`\dfrac{\partial \,\mathbf{e_a}}{\partial x^b}=\Gamma_{ab}^{\;c}\,\mathbf{e_c}`$  
avant, ou après...

Puis dans le désordre ...

Transport parallèle ...

Opérateur de dérivation covariante ...

Géodésique....

...

Courbure ...

Stock de formules, 

111111 ----

$`\dfrac{\partial g_{12\,M}}{\partial x^2}=\dfrac{\partial \left(\overrightarrow{e_1}_M\cdot\overrightarrow{e_2}_M\right)}{\partial x^2}`$

$`\hspace{0,8 cm}=\left.\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^2}\right|_{\mathscr{P}_M}\cdot\overrightarrow{e_2}_M`$
$`\;+\left.\dfrac{\partial \overrightarrow{e_2}_M}{\partial x^2}\right|_{\mathscr{P}_M}\cdot\overrightarrow{e_1}_M`$

$`\hspace{0,8 cm}=
\left(\Gamma_{12}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{12}^{\;2}\,\overrightarrow{e_2}_M\right)\cdot\overrightarrow{e_2}_M`$
$`\;+\left(\Gamma_{21}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{21}^{\;2}\,\overrightarrow{e_2}_M\right)\cdot\overrightarrow{e_1}_M`$

$`\hspace{0,8 cm}=
\Gamma_{12}^{\;1}\;\overrightarrow{e_1}_M\cdot\overrightarrow{e_2}_M`$
$`\;+\;\Gamma_{12}^{\;2}\;\overrightarrow{e_2}_M\cdot\overrightarrow{e_2}_M`$
$`\;+\;\Gamma_{21}^{\;1}\;\overrightarrow{e_1}_M\cdot\overrightarrow{e_1}_M`$
$`\;+\;\Gamma_{21}^{\;2}\;\overrightarrow{e_2}_M\cdot\overrightarrow{e_1}_M`$

$`\hspace{0,8 cm}=
\Gamma_{12}^{\;1}\;g_{12}\;+\;\Gamma_{12}^{\;2}\;g_{22}`$
$`\;+\;\Gamma_{21}^{\;1}\;g_{11}\;+\;\Gamma_{21}^{\;2}\;g_{21}`$

22222----

**$`\mathbf{\dfrac{\partial \,g_{12\,M}}{\partial x^1}}`$**$`\;=\dfrac{\partial \left(\overrightarrow{e_1}_M\cdot\overrightarrow{e_2}_M\right)}{\partial x^1}`$

$`\hspace{0,8 cm}=\left.\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^1}\right|_{\mathscr{P}_M}\cdot\overrightarrow{e_2}_M`$
$`\;+\left.\dfrac{\partial \overrightarrow{e_2}_M}{\partial x^1}\right|_{\mathscr{P}_M}\cdot\overrightarrow{e_1}_M`$

$`\hspace{0,8 cm}=
\left(\Gamma_{11}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{11}^{\;2}\,\overrightarrow{e_2}_M\right)\cdot\overrightarrow{e_2}_M`$
$`\;+\left(\Gamma_{21}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{21}^{\;2}\,\overrightarrow{e_2}_M\right)\cdot\overrightarrow{e_1}_M`$

$`\hspace{0,8 cm}=
\Gamma_{11}^{\;1}\;\overrightarrow{e_1}_M\cdot\overrightarrow{e_2}_M`$
$`\;+\;\Gamma_{11}^{\;2}\;\overrightarrow{e_2}_M\cdot\overrightarrow{e_2}_M`$
$`\;+\;\Gamma_{21}^{\;1}\;\overrightarrow{e_1}_M\cdot\overrightarrow{e_1}_M`$
$`\;+\;\Gamma_{21}^{\;2}\;\overrightarrow{e_2}_M\cdot\overrightarrow{e_1}_M`$

**$`\mathbf{\hspace{0,8 cm}=
\Gamma_{11}^{\;1}\;g_{12}\;+\;\Gamma_{11}^{\;2}\;g_{22}}`$
$`\mathbf{\;+\;\Gamma_{21}^{\;1}\;g_{11}\;+\;\Gamma_{21}^{\;2}\;g_{21}}`$**

333333----

**$`\mathbf{\dfrac{\partial \,g_{21\,M}}{\partial x^1}}`$**$`\;=\dfrac{\partial \left(\overrightarrow{e_2}_M\cdot\overrightarrow{e_1}_M\right)}{\partial x^1}`$

$`\hspace{0,8 cm}=\left.\dfrac{\partial \overrightarrow{e_2}_M}{\partial x^1}\right|_{\mathscr{P}_M}\cdot\overrightarrow{e_1}_M`$
$`\;+\left.\dfrac{\partial \overrightarrow{e_1}_M}{\partial x^1}\right|_{\mathscr{P}_M}\cdot\overrightarrow{e_2}_M`$

$`\hspace{0,8 cm}=
\left(\Gamma_{21}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{21}^{\;2}\,\overrightarrow{e_2}_M\right)\cdot\overrightarrow{e_1}_M`$
$`\;+\left(\Gamma_{11}^{\;1}\,\overrightarrow{e_1}_M+\Gamma_{11}^{\;2}\,\overrightarrow{e_2}_M\right)\cdot\overrightarrow{e_2}_M`$

$`\hspace{0,8 cm}=
\Gamma_{21}^{\;1}\;\overrightarrow{e_1}_M\cdot\overrightarrow{e_1}_M`$
$`\;+\;\Gamma_{21}^{\;2}\;\overrightarrow{e_2}_M\cdot\overrightarrow{e_1}_M`$
$`\;+\;\Gamma_{11}^{\;1}\;\overrightarrow{e_1}_M\cdot\overrightarrow{e_2}_M`$
$`\;+\;\Gamma_{11}^{\;2}\;\overrightarrow{e_2}_M\cdot\overrightarrow{e_2}_M`$

**$`\mathbf{\hspace{0,8 cm}=
\Gamma_{21}^{\;1}\;g_{11}\;+\;\Gamma_{21}^{\;2}\;g_{21}}`$
$`\mathbf{\;+\;\Gamma_{11}^{\;1}\;g_{12}\;+\;\Gamma_{11}^{\;2}\;g_{22}}`$**


--------------

!   
! *CALCUL DIFFEÉRENTIEL EN ESPACE NON EUCLIDIEN*  
!
! Fera très certainement l'objet d'un grand chapitre individuel.   
! Le titre pourra être changé.
!

limité aux espaces de Riemann...

vecteur $`\mathbf{v}`$ en composantes contravariantes 

$`\large{\mathbf{v}=v^a\,\mathbf{e_a}}`$

dérivée partielle covariante

$`\begin{align}
\Large{\color{blue}{\partial_b\mathbf{v}}}&=\partial_b\,(v^a\,\mathbf{e_a})\\
\\
&=(\partial_b\,v^a)\;\mathbf{e_a} + v^a\,(\partial_b\;\mathbf{e_a})\\
\\
&=(\partial_b\,v^a)\,\mathbf{e_a}+\underbrace{v^a\,\Gamma_{ab}^{\;c}\,\mathbf{e_c}}_{\color{brown}{
\begin{array}{c}\text{a et c muets}\\ \Rightarrow \\ \text{interchangeables}\end{array}}}\\
\\
&\Large{\color{blue}{=\big(\partial_b\,v^a + v^a\,\Gamma_{cb}^{\;a}\big)\,\mathbf{e_a}}}
\end{align}`$


$`\begin{align}
\Large{\color{blue}{\partial_b\mathbf{v}}}&=\partial_b\,(v^a\,\mathbf{e_a})\\
\\
&=(\partial_b\,v^a)\;\mathbf{e_a} + v^a\,(\partial_b\;\mathbf{e_a})\\
\\
&=(\partial_b\,v^a)\,\mathbf{e_a}+\underbrace{v^a\,\Gamma_{ab}^{\;c}\,\mathbf{e_c}}_{\color{brown}{
\begin{array}{c}\text{a et c muets} \Rightarrow \\ \text{interchangeables}\end{array}}}\\
\\
&\Large{\color{blue}{=\bigg(\partial_b\,v^a + v^a\,\Gamma_{cb}^{\;a}\bigg)\,\mathbf{e_a}}}
\end{align}`$









<br><br><br>

--------------















